/*
 * Decompiled with CFR 0.152.
 */
package controllers.controller;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import dao.installation.domain.input.InstallationEventInput;
import dao.installation.domain.input.InstallationEventInput$;
import dao.installation.domain.output.InstallationEventOutput$;
import dao.installation.domain.situation.InstallationEventsLinks;
import dao.installation.domain.situation.InstallationEventsLinks$;
import dao.installation.itf.InstallationEventDao;
import dao.installation.rpc.MailDao;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.administration.model.SieauParameters;
import fr.aquasys.daeau.campaign.domain.input.CampaignInput$;
import fr.aquasys.daeau.hydrometry.domain.HydrologicalEvent;
import fr.aquasys.daeau.hydrometry.itf.HydrometryEventDao;
import fr.aquasys.daeau.installation.domain.InstallationEvent;
import fr.aquasys.daeau.installation.domain.InstallationEvent$;
import fr.aquasys.daeau.installation.itf.InstallationDao;
import fr.aquasys.daeau.installation.model.Installation;
import fr.aquasys.daeau.piezometry.itf.PiezometryEventDao;
import fr.aquasys.daeau.piezometry.model.PiezometryEvent;
import fr.aquasys.daeau.pluviometry.itf.PluviometryEventDao;
import fr.aquasys.daeau.pluviometry.model.PluviometryEvent;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDao;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDetailed;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.EventUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.ErrorUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\tea\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!1\u0006A!A!\u0002\u00139\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011%\u0004!\u0011!Q\u0001\n)D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u001d\u0005\ts\u0002\u0011\t\u0011)A\u0005u\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001\"CA\u0017\u0001\t\u0007I\u0011AA\u0018\u0011!\ti\u0005\u0001Q\u0001\n\u0005E\u0002bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\t9\n\u0001C\u0001\u00033C\u0011\"a)\u0001\u0005\u0004%\t!!*\t\u0011\u0005}\u0006\u0001)A\u0005\u0003OCq!!1\u0001\t\u0003\t\u0019\rC\u0004\u0002N\u0002!\t!a4\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"9\u0011Q\u001d\u0001\u0005\u0002\u0005\u001d\b\"CAy\u0001\t\u0007I\u0011AAz\u0011!\t9\u0010\u0001Q\u0001\n\u0005U\bbBA}\u0001\u0011\u0005\u00111 \u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0005mIen\u001d;bY2\fG/[8o\u000bZ,g\u000e^\"p]R\u0014x\u000e\u001c7fe*\u0011A$H\u0001\u000bG>tGO]8mY\u0016\u0014(\"\u0001\u0010\u0002\u0017\r|g\u000e\u001e:pY2,'o]\u0002\u0001'\r\u0001\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!\nT\"A\u0015\u000b\u0005)Z\u0013aA1qS*\u0011A&L\u0001\te\u0006\u0014'-\u001b;nc*\u0011afL\u0001\bCF,\u0018m]=t\u0015\u0005\u0001\u0014A\u00014s\u0013\t\u0011\u0014F\u0001\u0005Qe>$WoY3s\u0003QIgn\u001d;bY2\fG/[8o\u000bZ,g\u000e\u001e#b_B\u0011Q\u0007P\u0007\u0002m)\u0011q\u0007O\u0001\u0004SR4'BA\u001d;\u00031Ign\u001d;bY2\fG/[8o\u0015\u0005Y\u0014a\u00013b_&\u0011QH\u000e\u0002\u0015\u0013:\u001cH/\u00197mCRLwN\\#wK:$H)Y8\u0002\u001f%t7\u000f^1mY\u0006$\u0018n\u001c8EC>\u0004\"\u0001Q#\u000e\u0003\u0005S!a\u000e\"\u000b\u0005e\u001a%B\u0001#.\u0003\u0015!\u0017-Z1v\u0013\t1\u0015IA\bJ]N$\u0018\r\u001c7bi&|g\u000eR1p\u0003I\u0019\u0018.Z1v!\u0006\u0014\u0018-\\3uKJ\u001cH)Y8\u0011\u0005%kU\"\u0001&\u000b\u0005]Z%B\u0001'D\u00039\tG-\\5oSN$(/\u0019;j_:L!A\u0014&\u0003%MKW-Y;QCJ\fW.\u001a;feN$\u0015m\\\u0001\b[\u0006LG\u000eR1p!\t\tF+D\u0001S\u0015\t\u0019\u0006(A\u0002sa\u000eL!!\u0016*\u0003\u000f5\u000b\u0017\u000e\u001c#b_\u0006q1\u000f^1uS>tG*\u001b8l\t\u0006|\u0007C\u0001-`\u001b\u0005I&B\u0001.\\\u0003-\u0019H/\u0019;j_:d\u0017N\\6\u000b\u0005qk\u0016!\u00027j].\u001c(B\u00010D\u0003\u001d\u0019H/\u0019;j_:L!\u0001Y-\u0003\u001dM#\u0018\r^5p]2Kgn\u001b#b_\u0006\u0011\u0002/[3{_6,GO]=Fm\u0016tG\u000fR1p!\t\u0019w-D\u0001e\u0015\t9TM\u0003\u0002g\u0007\u0006Q\u0001/[3{_6,GO]=\n\u0005!$'A\u0005)jKj|W.\u001a;ss\u00163XM\u001c;EC>\f1\u0003\u001d7vm&|W.\u001a;ss\u00163XM\u001c;EC>\u0004\"a[8\u000e\u00031T!aN7\u000b\u00059\u001c\u0015a\u00039mkZLw.\\3uefL!\u0001\u001d7\u0003'AcWO^5p[\u0016$(/_#wK:$H)Y8\u0002%!LHM]8nKR\u0014\u00180\u0012<f]R$\u0015m\u001c\t\u0003g^l\u0011\u0001\u001e\u0006\u0003oUT!A^\"\u0002\u0015!LHM]8nKR\u0014\u00180\u0003\u0002yi\n\u0011\u0002*\u001f3s_6,GO]=Fm\u0016tG\u000fR1p\u0003\u001dawnZ+uS2\u0004\"a\u001f@\u000e\u0003qT!!`\u0016\u0002\tU$\u0018\u000e\\\u0005\u0003\u007fr\u0014q\u0001T8h+RLG.\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003\u000b\tI!a\u0003\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+\t9\"!\u0007\u0011\u0007\u0005\u001d\u0001!D\u0001\u001c\u0011\u0015\u0019$\u00021\u00015\u0011\u0015q$\u00021\u0001@\u0011\u00159%\u00021\u0001I\u0011\u0015y%\u00021\u0001Q\u0011\u00151&\u00021\u0001X\u0011\u0015\t'\u00021\u0001c\u0011\u0015I'\u00021\u0001k\u0011\u0015\t(\u00021\u0001s\u0011\u0015I(\u00021\u0001{Q\rQ\u0011Q\u0004\t\u0005\u0003?\tI#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\u0019IgN[3di*\u0011\u0011qE\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003W\t\tC\u0001\u0004J]*,7\r^\u0001\u000bS\u0012\u0014V-\u00193M_:<WCAA\u0019!\u0019\t\u0019$a\u0011\u0002H5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0003kg>t'\u0002BA\u001e\u0003{\tA\u0001\\5cg*\u0019!&a\u0010\u000b\u0005\u0005\u0005\u0013\u0001\u00029mCfLA!!\u0012\u00026\t)!+Z1egB\u0019!%!\u0013\n\u0007\u0005-3E\u0001\u0003M_:<\u0017aC5e%\u0016\fG\rT8oO\u0002\nQcZ3u\u0013:\u001cH/\u00197mCRLwN\\#wK:$8\u000f\u0006\u0006\u0002T\u0005%\u00141OAB\u0003\u000f\u0003B!!\u0016\u0002d9!\u0011qKA0!\r\tIfI\u0007\u0003\u00037R1!!\u0018 \u0003\u0019a$o\\8u}%\u0019\u0011\u0011M\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\t)'a\u001a\u0003\rM#(/\u001b8h\u0015\r\t\tg\t\u0005\b\u0003Wj\u0001\u0019AA7\u0003\u001diWm]:bO\u0016\u0004B!a\r\u0002p%!\u0011\u0011OA\u001b\u0005\u001dQ5OV1mk\u0016Dq!!\u001e\u000e\u0001\u0004\t9(A\u0004iK\u0006$WM]:\u0011\u0011\u0005U\u0013\u0011PA*\u0003{JA!a\u001f\u0002h\t\u0019Q*\u00199\u0011\u0007\t\ny(C\u0002\u0002\u0002\u000e\u00121!\u00118z\u0011\u001d\t))\u0004a\u0001\u0003'\na!\\8ek2,\u0007bBAE\u001b\u0001\u0007\u00111K\u0001\u0005kN,'/A\nhKR,e/\u001a8ug\nK8)Y7qC&<g\u000e\u0006\u0006\u0002T\u0005=\u0015\u0011SAJ\u0003+Cq!a\u001b\u000f\u0001\u0004\ti\u0007C\u0004\u0002v9\u0001\r!a\u001e\t\u000f\u0005\u0015e\u00021\u0001\u0002T!9\u0011\u0011\u0012\bA\u0002\u0005M\u0013\u0001G4fi&s7\u000f^1mY\u0006$\u0018n\u001c8BY2,e/\u001a8ugRQ\u00111KAN\u0003;\u000by*!)\t\u000f\u0005-t\u00021\u0001\u0002n!9\u0011QO\bA\u0002\u0005]\u0004bBAC\u001f\u0001\u0007\u00111\u000b\u0005\b\u0003\u0013{\u0001\u0019AA*\u0003uIgn\u001d;bY2\fG/[8o\u000bZ,g\u000e^!oIV\u001bXM\u001d*fC\u0012\u001cXCAAT!\u0019\t\u0019$a\u0011\u0002*B9!%a+\u00020\u0006M\u0013bAAWG\t1A+\u001e9mKJ\u0002B!!-\u0002<6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,A\u0003j]B,HOC\u0002\u0002:b\na\u0001Z8nC&t\u0017\u0002BA_\u0003g\u0013a#\u00138ti\u0006dG.\u0019;j_:,e/\u001a8u\u0013:\u0004X\u000f^\u0001\u001fS:\u001cH/\u00197mCRLwN\\#wK:$\u0018I\u001c3Vg\u0016\u0014(+Z1eg\u0002\nq#\u001b8tKJ$\u0018J\\:uC2d\u0017\r^5p]\u00163XM\u001c;\u0015\u0015\u0005M\u0013QYAd\u0003\u0013\fY\rC\u0004\u0002lI\u0001\r!!\u001c\t\u000f\u0005U$\u00031\u0001\u0002x!9\u0011Q\u0011\nA\u0002\u0005M\u0003bBAE%\u0001\u0007\u00111K\u0001\u0018kB$\u0017\r^3J]N$\u0018\r\u001c7bi&|g.\u0012<f]R$\"\"a\u0015\u0002R\u0006M\u0017Q[Al\u0011\u001d\tYg\u0005a\u0001\u0003[Bq!!\u001e\u0014\u0001\u0004\t9\bC\u0004\u0002\u0006N\u0001\r!a\u0015\t\u000f\u0005%5\u00031\u0001\u0002T\u0005!r-\u001a;J]N$\u0018\r\u001c7bi&|g.\u0012<f]R$\"\"a\u0015\u0002^\u0006}\u0017\u0011]Ar\u0011\u001d\tY\u0007\u0006a\u0001\u0003[Bq!!\u001e\u0015\u0001\u0004\t9\bC\u0004\u0002\u0006R\u0001\r!a\u0015\t\u000f\u0005%E\u00031\u0001\u0002T\u00059B-\u001a7fi\u0016Len\u001d;bY2\fG/[8o\u000bZ,g\u000e\u001e\u000b\u000b\u0003'\nI/a;\u0002n\u0006=\bbBA6+\u0001\u0007\u0011Q\u000e\u0005\b\u0003k*\u0002\u0019AA<\u0011\u001d\t))\u0006a\u0001\u0003'Bq!!#\u0016\u0001\u0004\t\u0019&\u0001\u0005d_\u0012,'+Z1e+\t\t)\u0010\u0005\u0004\u00024\u0005\r\u00131K\u0001\nG>$WMU3bI\u0002\n1eZ3u\u0013:\u001cH/\u00197mCRLwN\\#wK:$8oV5uQ\u0006\u001b8o\\2jCR,G\r\u0006\u0006\u0002T\u0005u\u0018q B\u0001\u0005\u0007Aq!a\u001b\u0019\u0001\u0004\ti\u0007C\u0004\u0002va\u0001\r!a\u001e\t\u000f\u0005\u0015\u0005\u00041\u0001\u0002T!9\u0011\u0011\u0012\rA\u0002\u0005M\u0013AC:f]\u0012\u0014\u00150T1jYRQ\u00111\u000bB\u0005\u0005\u0017\u0011iAa\u0004\t\u000f\u0005-\u0014\u00041\u0001\u0002n!9\u0011QO\rA\u0002\u0005]\u0004bBAC3\u0001\u0007\u00111\u000b\u0005\b\u0003\u0013K\u0002\u0019AA*Q\r\u0001!1\u0003\t\u0005\u0003?\u0011)\"\u0003\u0003\u0003\u0018\u0005\u0005\"!C*j]\u001edW\r^8o\u0001")
public class InstallationEventController
implements Producer {
    private final InstallationEventDao installationEventDao;
    private final InstallationDao installationDao;
    private final SieauParametersDao sieauParametersDao;
    private final MailDao mailDao;
    private final StationLinkDao stationLinkDao;
    private final PiezometryEventDao piezometryEventDao;
    private final PluviometryEventDao pluviometryEventDao;
    private final HydrometryEventDao hydrometryEventDao;
    private final LogUtil logUtil;
    private final Reads<Object> idReadLong;
    private final Reads<Tuple2<InstallationEventInput, String>> installationEventAndUserReads;
    private final Reads<String> codeRead;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        InstallationEventController installationEventController = this;
        synchronized (installationEventController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public Reads<Object> idReadLong() {
        return this.idReadLong;
    }

    public String getInstallationEvents(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.idReadLong()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(31).append("Can't get installation events:\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> InstallationEventController.$anonfun$getInstallationEvents$2(this, BoxesRunTime.unboxToLong((Object)read)));
    }

    public String getEventsByCampaign(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.idAndUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate Json to get campaign event :\n").append(error).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double id = tuple2._1$mcD$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)id), (Object)user);
            double id2 = tuple22._1$mcD$sp();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.toJson($this.installationEventDao.getCampaignEvent(id2, user2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)InstallationEvent$.MODULE$.installationEventWrites())).toString();
        });
    }

    public String getInstallationAllEvents(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.installationEventDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), InstallationEventOutput$.MODULE$.format())).toString();
    }

    public Reads<Tuple2<InstallationEventInput, String>> installationEventAndUserReads() {
        return this.installationEventAndUserReads;
    }

    public String insertInstallationEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.installationEventAndUserReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate event input", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InstallationEventInput event = (InstallationEventInput)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)event, (Object)user);
            InstallationEventInput event2 = (InstallationEventInput)tuple22._1();
            String user2 = (String)tuple22._2();
            Tuple2<Object, Object> tuple23 = $this.installationEventDao.insert(event2, user2);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            int result = tuple23._1$mcI$sp();
            int id = tuple23._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(result, id);
            int result2 = sp2._1$mcI$sp();
            int id2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)id2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateInstallationEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(InstallationEvent$.MODULE$.installationEventUpdateReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get event id", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InstallationEvent event = (InstallationEvent)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)event, (Object)user);
            InstallationEvent event2 = (InstallationEvent)tuple22._1();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.installationEventDao.update(event2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getInstallationEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(InstallationEvent$.MODULE$.installationEventReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get installation id or event id", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int installationId = tuple2._1$mcI$sp();
            int eventId = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(installationId, eventId);
            int installationId2 = sp2._1$mcI$sp();
            int eventId2 = sp2._2$mcI$sp();
            return Json$.MODULE$.toJson($this.installationEventDao.find(installationId2, eventId2), Writes$.MODULE$.OptionWrites((Writes)InstallationEvent$.MODULE$.installationEventWrites())).toString();
        });
    }

    public String deleteInstallationEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(InstallationEvent$.MODULE$.installationEventReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get installation id or event id", ErrorUtil$.MODULE$.getJsonError$default$3()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int installationId = tuple2._1$mcI$sp();
            int eventId = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(installationId, eventId);
            int installationId2 = sp2._1$mcI$sp();
            int eventId2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.installationEventDao.delete(installationId2, eventId2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public Reads<String> codeRead() {
        return this.codeRead;
    }

    public String getInstallationEventsWithAssociated(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.codeRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(29).append("Can't get installation code \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), 400), (Function1 & Serializable)instCode -> {
            Seq allLinks = $this.stationLinkDao.get(instCode, (long)StationTypeUtil$.MODULE$.StationTypeCode(StationTypeUtil$.MODULE$.INSTALLATION()));
            Seq instIds = (Seq)((IterableOps)allLinks.filter((Function1 & Serializable)l -> BoxesRunTime.boxToBoolean((boolean)InstallationEventController.$anonfun$getInstallationEventsWithAssociated$3(l)))).map((Function1 & Serializable)l -> BoxesRunTime.boxToLong((long)l.stationLinkedId()));
            Seq piezoIds = (Seq)((IterableOps)allLinks.filter((Function1 & Serializable)l -> BoxesRunTime.boxToBoolean((boolean)InstallationEventController.$anonfun$getInstallationEventsWithAssociated$5(l)))).map((Function1 & Serializable)l -> BoxesRunTime.boxToInteger((int)InstallationEventController.$anonfun$getInstallationEventsWithAssociated$6(l)));
            Seq hydroIds = (Seq)((IterableOps)allLinks.filter((Function1 & Serializable)l -> BoxesRunTime.boxToBoolean((boolean)InstallationEventController.$anonfun$getInstallationEventsWithAssociated$7(l)))).map((Function1 & Serializable)l -> BoxesRunTime.boxToDouble((double)l.stationLinkedId()));
            Seq pluvioIds = (Seq)((IterableOps)allLinks.filter((Function1 & Serializable)l -> BoxesRunTime.boxToBoolean((boolean)InstallationEventController.$anonfun$getInstallationEventsWithAssociated$9(l)))).map((Function1 & Serializable)l -> BoxesRunTime.boxToInteger((int)InstallationEventController.$anonfun$getInstallationEventsWithAssociated$10(l)));
            Seq<InstallationEvent> instEvents = $this.installationEventDao.getEventsByInstallations((Seq<Object>)instIds);
            Seq piezoEvents = $this.piezometryEventDao.getEventsWithIds(piezoIds);
            Seq hydroEvents = $this.hydrometryEventDao.getEventsWithIds(hydroIds);
            Seq pluvioEvents = $this.pluviometryEventDao.getAllWithIds(pluvioIds);
            InstallationEventsLinks result = new InstallationEventsLinks(instEvents, (Seq<PiezometryEvent>)piezoEvents, (Seq<HydrologicalEvent>)hydroEvents, (Seq<PluviometryEvent>)pluvioEvents);
            return Json$.MODULE$.toJson((Object)result, InstallationEventsLinks$.MODULE$.format()).toString();
        });
    }

    public String sendByMail(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(EventUtil$.MODULE$.eventIdAndStationIdAndEmailRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate Json to send Event by mail :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple3 tuple3 = params;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int eventId = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int stationId = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Seq emails = (Seq)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)eventId), (Object)BoxesRunTime.boxToInteger((int)stationId), (Object)emails);
            int eventId2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int stationId2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Seq emails2 = (Seq)tuple32._3();
            Option<InstallationEvent> option = $this.installationEventDao.find(stationId2, eventId2);
            if (option instanceof Some) {
                Some some = (Some)option;
                InstallationEvent event = (InstallationEvent)some.value();
                Option option2 = $this.installationDao.get((long)stationId2);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Installation piezo = (Installation)some2.value();
                    Seq parameters = $this.sieauParametersDao.getAll($this.sieauParametersDao.getAll$default$1(), $this.sieauParametersDao.getAll$default$2());
                    emails2.foreach((Function1 & Serializable)email -> {
                        this.mailDao.sendMail(email, event, piezo, (Seq<SieauParameters>)parameters);
                        return BoxedUnit.UNIT;
                    });
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"success"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)200), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                $this.logUtil.debug(new StringBuilder(30).append("Error installation: ").append(stationId2).append(" not found").toString(), $this.logUtil.debug$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.debug(new StringBuilder(42).append("Error event: ").append(eventId2).append(" not found for installation: ").append(stationId2).toString(), $this.logUtil.debug$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public static final /* synthetic */ String $anonfun$getInstallationEvents$2(InstallationEventController $this, long read) {
        return Json$.MODULE$.toJson($this.installationEventDao.getEventsByInstallation(read), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)InstallationEvent$.MODULE$.installationEventWrites())).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getInstallationEventsWithAssociated$3(StationLinkDetailed l) {
        return l.typeName().equals(StationTypeUtil$.MODULE$.INSTALLATION().toLowerCase());
    }

    public static final /* synthetic */ boolean $anonfun$getInstallationEventsWithAssociated$5(StationLinkDetailed l) {
        return l.typeName().equals(StationTypeUtil$.MODULE$.PIEZOMETRY().toLowerCase());
    }

    public static final /* synthetic */ int $anonfun$getInstallationEventsWithAssociated$6(StationLinkDetailed l) {
        return (int)l.stationLinkedId();
    }

    public static final /* synthetic */ boolean $anonfun$getInstallationEventsWithAssociated$7(StationLinkDetailed l) {
        return l.typeName().equals(StationTypeUtil$.MODULE$.HYDROMETRY().toLowerCase());
    }

    public static final /* synthetic */ boolean $anonfun$getInstallationEventsWithAssociated$9(StationLinkDetailed l) {
        return l.typeName().equals(StationTypeUtil$.MODULE$.PLUVIOMETRY().toLowerCase());
    }

    public static final /* synthetic */ int $anonfun$getInstallationEventsWithAssociated$10(StationLinkDetailed l) {
        return (int)l.stationLinkedId();
    }

    @Inject
    public InstallationEventController(InstallationEventDao installationEventDao, InstallationDao installationDao, SieauParametersDao sieauParametersDao, MailDao mailDao, StationLinkDao stationLinkDao, PiezometryEventDao piezometryEventDao, PluviometryEventDao pluviometryEventDao, HydrometryEventDao hydrometryEventDao, LogUtil logUtil) {
        this.installationEventDao = installationEventDao;
        this.installationDao = installationDao;
        this.sieauParametersDao = sieauParametersDao;
        this.mailDao = mailDao;
        this.stationLinkDao = stationLinkDao;
        this.piezometryEventDao = piezometryEventDao;
        this.pluviometryEventDao = pluviometryEventDao;
        this.hydrometryEventDao = hydrometryEventDao;
        this.logUtil = logUtil;
        Producer.$init$((Producer)this);
        this.idReadLong = JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.LongReads());
        this.installationEventAndUserReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("event").read(InstallationEventInput$.MODULE$.installationEventWrites()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.codeRead = JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads());
    }
}

