/*
 * Decompiled with CFR 0.152.
 */
package controllers.controller;

import dao.installationTypes.network.dao.NetworkTableDao;
import dao.installationTypes.network.model.NetworkTableInput;
import dao.installationTypes.network.model.NetworkTableInput$;
import dao.installationTypes.network.model.NetworkTableLine;
import fr.aquasys.constants.StationTypeConstants$;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.installation.itf.InstallationNetworkDao;
import fr.aquasys.daeau.installation.model.InstallationNetwork;
import fr.aquasys.daeau.installation.model.InstallationNetwork$;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.SieauFilteredTableLine;
import util.SieauFilteredTableLine$;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\b\u0010\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\tU\u0001\u0011\t\u0011)A\u0005W!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!1\u0005A!A!\u0002\u00139\u0005\"B(\u0001\t\u0003\u0001\u0006bB1\u0001\u0005\u0004%\tA\u0019\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003d\u0011%\tI\u0001\u0001b\u0001\n\u0003\tY\u0001\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u0007\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002N\u0001!\t!a\u0014\u0003;%s7\u000f^1mY\u0006$\u0018n\u001c8OKR<xN]6D_:$(o\u001c7mKJT!\u0001E\t\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0013\u0003-\u0019wN\u001c;s_2dWM]:\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002-%t7\u000f^1mY\u0006$\u0018n\u001c8OKR<vN]6EC>\u0004\"!\b\u0015\u000e\u0003yQ!a\b\u0011\u0002\u0007%$hM\u0003\u0002\"E\u0005a\u0011N\\:uC2d\u0017\r^5p]*\u00111\u0005J\u0001\u0006I\u0006,\u0017-\u001e\u0006\u0003K\u0019\nq!Y9vCNL8OC\u0001(\u0003\t1'/\u0003\u0002*=\t1\u0012J\\:uC2d\u0017\r^5p]:+Go^8sW\u0012\u000bw.\u0001\ntS\u0016\fW\u000fU1sC6,G/\u001a:t\t\u0006|\u0007C\u0001\u00171\u001b\u0005i#BA\u0010/\u0015\ty#%\u0001\bbI6Lg.[:ue\u0006$\u0018n\u001c8\n\u0005Ej#AE*jK\u0006,\b+\u0019:b[\u0016$XM]:EC>\f!B\\3uo>\u00148\u000eR1p!\t!D(D\u00016\u0015\t1t'A\u0002eC>T!\u0001O\u001d\u0002\u000f9,Go^8sW*\u0011!hO\u0001\u0012S:\u001cH/\u00197mCRLwN\u001c+za\u0016\u001c(\"\u0001\u001c\n\u0005u*$a\u0004(fi^|'o\u001b+bE2,G)Y8\u0002\u001dU\u001cXM]*uCRLwN\u001c#b_B\u0011\u0001\tR\u0007\u0002\u0003*\u0011qD\u0011\u0006\u0003\u0007\n\nA!^:fe&\u0011Q)\u0011\u0002\u000f+N,'o\u0015;bi&|g\u000eR1p\u0003\u001dawnZ+uS2\u0004\"\u0001S'\u000e\u0003%S!AS&\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0019\u0012\n\u0001B]1cE&$X.]\u0005\u0003\u001d&\u0013q\u0001T8h+RLG.\u0001\u0004=S:LGO\u0010\u000b\u0007#N#VKV,\u0011\u0005I\u0003Q\"A\b\t\u000bm1\u0001\u0019\u0001\u000f\t\u000b)2\u0001\u0019A\u0016\t\u000bI2\u0001\u0019A\u001a\t\u000by2\u0001\u0019A \t\u000b\u00193\u0001\u0019A$)\u0005\u0019I\u0006C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\u0019IgN[3di*\ta,A\u0003kCZ\f\u00070\u0003\u0002a7\n1\u0011J\u001c6fGR\fA\u0002Z1uC^KG\u000f[+tKJ,\u0012a\u0019\t\u0004I6|W\"A3\u000b\u0005\u0019<\u0017\u0001\u00026t_:T!\u0001[5\u0002\t1L'm\u001d\u0006\u0003U.\f1!\u00199j\u0015\u0005a\u0017\u0001\u00029mCfL!A\\3\u0003\u000bI+\u0017\rZ:\u0011\tY\u0001(/`\u0005\u0003c^\u0011a\u0001V;qY\u0016\u0014\u0004CA:{\u001d\t!\b\u0010\u0005\u0002v/5\taO\u0003\u0002x'\u00051AH]8pizJ!!_\f\u0002\rA\u0013X\rZ3g\u0013\tYHP\u0001\u0004TiJLgn\u001a\u0006\u0003s^\u00012A`A\u0002\u001b\u0005y(bAA\u0001A\u0005)Qn\u001c3fY&\u0019\u0011QA@\u0003'%s7\u000f^1mY\u0006$\u0018n\u001c8OKR<xN]6\u0002\u001b\u0011\fG/Y,ji\",6/\u001a:!\u0003EqW\r^<pe.$\u0016M\u00197f\u0013:\u0004X\u000f^\u000b\u0003\u0003\u001b\u0001B\u0001Z7\u0002\u0010A)a\u0003]A\teB!\u00111CA\f\u001b\t\t)BC\u0002\u0002\u0002]JA!!\u0007\u0002\u0016\t\tb*\u001a;x_J\\G+\u00192mK&s\u0007/\u001e;\u0002%9,Go^8sWR\u000b'\r\\3J]B,H\u000fI\u0001\u0017O\u0016$\u0018J\\:uC2d\u0017\r^5p]:+Go^8sWRI!/!\t\u0002,\u0005m\u0012q\b\u0005\b\u0003GY\u0001\u0019AA\u0013\u0003\u001diWm]:bO\u0016\u00042\u0001ZA\u0014\u0013\r\tI#\u001a\u0002\b\u0015N4\u0016\r\\;f\u0011\u001d\tic\u0003a\u0001\u0003_\tq\u0001[3bI\u0016\u00148\u000f\u0005\u0004t\u0003c\u0011\u0018QG\u0005\u0004\u0003ga(aA'baB\u0019a#a\u000e\n\u0007\u0005erCA\u0002B]fDa!!\u0010\f\u0001\u0004\u0011\u0018AB7pIVdW\rC\u0003D\u0017\u0001\u0007!/A\rva\u0012\fG/Z%ogR\fG\u000e\\1uS>tg*\u001a;x_J\\G#\u0003:\u0002F\u0005\u001d\u0013\u0011JA&\u0011\u001d\t\u0019\u0003\u0004a\u0001\u0003KAq!!\f\r\u0001\u0004\ty\u0003\u0003\u0004\u0002>1\u0001\rA\u001d\u0005\u0006\u00072\u0001\rA]\u0001\r]\u0016$xo\u001c:l)\u0006\u0014G.\u001a\u000b\ne\u0006E\u00131KA+\u0003/Bq!a\t\u000e\u0001\u0004\t)\u0003C\u0004\u0002.5\u0001\r!a\f\t\r\u0005uR\u00021\u0001s\u0011\u0015\u0019U\u00021\u0001s\u0001")
public class InstallationNetworkController {
    private final InstallationNetworkDao installationNetWorkDao;
    private final SieauParametersDao sieauParametersDao;
    private final NetworkTableDao networkDao;
    private final UserStationDao userStationDao;
    private final LogUtil logUtil;
    private final Reads<Tuple2<String, InstallationNetwork>> dataWithUser;
    private final Reads<Tuple2<NetworkTableInput, String>> networkTableInput;

    public Reads<Tuple2<String, InstallationNetwork>> dataWithUser() {
        return this.dataWithUser;
    }

    public Reads<Tuple2<NetworkTableInput, String>> networkTableInput() {
        return this.networkTableInput;
    }

    public String getInstallationNetwork(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate id from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)id -> InstallationNetworkController.$anonfun$getInstallationNetwork$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String updateInstallationNetwork(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.dataWithUser()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(61).append("Can't validate installation Network object from json input : ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)networkRead -> {
            Tuple2 tuple2 = networkRead;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            InstallationNetwork network = (InstallationNetwork)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)network);
            String user2 = (String)tuple22._1();
            InstallationNetwork network2 = (InstallationNetwork)tuple22._2();
            Option option = $this.installationNetWorkDao.get((long)((int)BoxesRunTime.unboxToLong((Object)network2.idStation().get())));
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.installationNetWorkDao.insert(network2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (option instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.installationNetWorkDao.update(network2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String networkTable(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.networkTableInput()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(38).append("Can't parse installation table input, ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Tuple2<Seq<NetworkTableLine>, Object> tuple2;
            Tuple2<Seq<NetworkTableLine>, Object> tuple22;
            Tuple2 tuple23 = params;
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            NetworkTableInput input = (NetworkTableInput)tuple23._1();
            String module = (String)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)input, (Object)module);
            NetworkTableInput input2 = (NetworkTableInput)tuple24._1();
            String module2 = (String)tuple24._2();
            Option operatorCode = $this.sieauParametersDao.getString("contributorTypeOperator", "SIEAU");
            Option administratorCode = $this.sieauParametersDao.getString("contributorTypeAdministrator", "SIEAU");
            Seq allowStations = $this.userStationDao.getAvailableStation(input2.user(), StationTypeConstants$.MODULE$.TYPE_STATION_INSTALLATION(), module2);
            String string = CommonReadUtil$.MODULE$.getAllowedStations(allowStations);
            String string2 = StationTypeConstants$.MODULE$.FORBIDEN();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                tuple22 = new Tuple2<Seq<NetworkTableLine>, Object>((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0));
            } else {
                String string4 = StationTypeConstants$.MODULE$.ALL();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    tuple22 = $this.networkDao.getNetworkTable(input2, (Option<String>)administratorCode, (Option<String>)operatorCode, (Seq<Object>)((Seq)Nil$.MODULE$), StationTypeConstants$.MODULE$.ALL());
                } else {
                    Seq allowStationsIds = (Seq)allowStations.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$3))));
                    tuple22 = tuple2 = $this.networkDao.getNetworkTable(input2, (Option<String>)administratorCode, (Option<String>)operatorCode, (Seq<Object>)allowStationsIds, $this.networkDao.getNetworkTable$default$5());
                }
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq sqlResults = (Seq)tuple2._1();
            int nbElements = tuple2._2$mcI$sp();
            Tuple2 tuple25 = new Tuple2((Object)sqlResults, (Object)BoxesRunTime.boxToInteger((int)nbElements));
            Seq sqlResults2 = (Seq)tuple25._1();
            int nbElements2 = tuple25._2$mcI$sp();
            return SieauFilteredTableLine$.MODULE$.generateJson((Seq<SieauFilteredTableLine>)sqlResults2, input2.searchValue(), input2.forceLoad(), input2.previewSize(), nbElements2);
        });
    }

    public static final /* synthetic */ String $anonfun$getInstallationNetwork$2(InstallationNetworkController $this, int id) {
        Option option = $this.installationNetWorkDao.get((long)id);
        if (option instanceof Some) {
            Some some = (Some)option;
            InstallationNetwork network = (InstallationNetwork)some.value();
            return Json$.MODULE$.toJson((Object)network, (Writes)InstallationNetwork$.MODULE$.format()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't find installation Network.", 404, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5());
        }
        throw new MatchError((Object)option);
    }

    @Inject
    public InstallationNetworkController(InstallationNetworkDao installationNetWorkDao, SieauParametersDao sieauParametersDao, NetworkTableDao networkDao, UserStationDao userStationDao, LogUtil logUtil) {
        this.installationNetWorkDao = installationNetWorkDao;
        this.sieauParametersDao = sieauParametersDao;
        this.networkDao = networkDao;
        this.userStationDao = userStationDao;
        this.logUtil = logUtil;
        this.dataWithUser = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("data").read((Reads)InstallationNetwork$.MODULE$.format())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.networkTableInput = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("networkTableInput").read(NetworkTableInput$.MODULE$.format()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

