/*
 * Decompiled with CFR 0.152.
 */
package controllers.controller;

import dao.installationTypes.Tank.TankTableDao;
import dao.installationTypes.Tank.TankTableInput;
import dao.installationTypes.Tank.TankTableInput$;
import dao.installationTypes.Tank.TankTableLine;
import fr.aquasys.constants.StationTypeConstants$;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.agri_mobile.links.exploitation.samplingPoint.sampleTank.SampleTankDao;
import fr.aquasys.daeau.agri_mobile.links.exploitation.samplingPoint.sampleTank.SampleTankWithLinks;
import fr.aquasys.daeau.agri_mobile.links.exploitation.samplingPoint.sampleTank.SampleTankWithLinks$;
import fr.aquasys.daeau.installation.domain.tank.TankLinks;
import fr.aquasys.daeau.installation.domain.tank.TankLinks$;
import fr.aquasys.daeau.installation.domain.tank.TankWithLinks;
import fr.aquasys.daeau.installation.domain.tank.TankWithLinks$;
import fr.aquasys.daeau.installation.itf.InstallationTankDao;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.SieauFilteredTableLine;
import util.SieauFilteredTableLine$;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\f\u0018\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\te\u0001\u0011\t\u0011)A\u0005g!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u000b\u0015\u0004A\u0011\u00014\t\u000fa\u0004!\u0019!C\u0001s\"9\u0011\u0011\b\u0001!\u0002\u0013Q\b\"CA\u001e\u0001\t\u0007I\u0011AA\u001f\u0011!\tI\u0005\u0001Q\u0001\n\u0005}\u0002bBA&\u0001\u0011\u0005\u0011Q\n\u0005\n\u0003_\u0002!\u0019!C\u0001\u0003cB\u0001\"a\u001f\u0001A\u0003%\u00111\u000f\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!!&\u0001\t\u0003\t9\nC\u0005\u0002\"\u0002\u0011\r\u0011\"\u0001\u0002$\"A\u0011q\u0016\u0001!\u0002\u0013\t)\u000bC\u0004\u00022\u0002!\t!a-\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\nQ\u0012J\\:uC2d\u0017\r^5p]R\u000bgn[\"p]R\u0014x\u000e\u001c7fe*\u0011\u0001$G\u0001\u000bG>tGO]8mY\u0016\u0014(\"\u0001\u000e\u0002\u0017\r|g\u000e\u001e:pY2,'o]\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u0014S:\u001cH/\u00197mCRLwN\u001c+b].$\u0015m\u001c\t\u0003KAj\u0011A\n\u0006\u0003O!\n1!\u001b;g\u0015\tI#&\u0001\u0007j]N$\u0018\r\u001c7bi&|gN\u0003\u0002,Y\u0005)A-Y3bk*\u0011QFL\u0001\bCF,\u0018m]=t\u0015\u0005y\u0013A\u00014s\u0013\t\tdEA\nJ]N$\u0018\r\u001c7bi&|g\u000eV1oW\u0012\u000bw.A\u0007tC6\u0004H.\u001a+b].$\u0015m\u001c\t\u0003i}j\u0011!\u000e\u0006\u0003m]\n!b]1na2,G+\u00198l\u0015\tA\u0014(A\u0007tC6\u0004H.\u001b8h!>Lg\u000e\u001e\u0006\u0003um\nA\"\u001a=qY>LG/\u0019;j_:T!\u0001P\u001f\u0002\u000b1Lgn[:\u000b\u0005yR\u0013aC1he&|Vn\u001c2jY\u0016L!\u0001Q\u001b\u0003\u001bM\u000bW\u000e\u001d7f)\u0006t7\u000eR1p\u0003I\u0019\u0018.Z1v!\u0006\u0014\u0018-\\3uKJ\u001cH)Y8\u0011\u0005\r;U\"\u0001#\u000b\u0005\u001d*%B\u0001$+\u00039\tG-\\5oSN$(/\u0019;j_:L!\u0001\u0013#\u0003%MKW-Y;QCJ\fW.\u001a;feN$\u0015m\\\u0001\bY><W\u000b^5m!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0003vi&d'BA(-\u0003!\u0011\u0018M\u00192ji6\f\u0018BA)M\u0005\u001daunZ+uS2\fa\"^:feN#\u0018\r^5p]\u0012\u000bw\u000e\u0005\u0002U16\tQK\u0003\u0002(-*\u0011qKK\u0001\u0005kN,'/\u0003\u0002Z+\nqQk]3s'R\fG/[8o\t\u0006|\u0017\u0001\u0004;b].$\u0016M\u00197f\t\u0006|\u0007C\u0001/d\u001b\u0005i&B\u00010`\u0003\u0011!\u0016M\\6\u000b\u0005\u0001\f\u0017!E5ogR\fG\u000e\\1uS>tG+\u001f9fg*\t!-A\u0002eC>L!\u0001Z/\u0003\u0019Q\u000bgn\u001b+bE2,G)Y8\u0002\rqJg.\u001b;?)\u001d9\u0017N[6m[:\u0004\"\u0001\u001b\u0001\u000e\u0003]AQaI\u0004A\u0002\u0011BQAM\u0004A\u0002MBQ!Q\u0004A\u0002\tCQ!S\u0004A\u0002)CQAU\u0004A\u0002MCQAW\u0004A\u0002mC#a\u00029\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018AB5oU\u0016\u001cGOC\u0001v\u0003\u0015Q\u0017M^1y\u0013\t9(O\u0001\u0004J]*,7\r^\u0001\rI\u0006$\u0018mV5uQV\u001bXM]\u000b\u0002uB)10!\u0003\u0002\u000e5\tAP\u0003\u0002~}\u0006!!n]8o\u0015\ry\u0018\u0011A\u0001\u0005Y&\u00147O\u0003\u0003\u0002\u0004\u0005\u0015\u0011aA1qS*\u0011\u0011qA\u0001\u0005a2\f\u00170C\u0002\u0002\fq\u0014QAU3bIN\u0004rAHA\b\u0003'\tI#C\u0002\u0002\u0012}\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA\u000b\u0003GqA!a\u0006\u0002 A\u0019\u0011\u0011D\u0010\u000e\u0005\u0005m!bAA\u000f7\u00051AH]8pizJ1!!\t \u0003\u0019\u0001&/\u001a3fM&!\u0011QEA\u0014\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011E\u0010\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005!A/\u00198l\u0015\r\t\u0019\u0004K\u0001\u0007I>l\u0017-\u001b8\n\t\u0005]\u0012Q\u0006\u0002\u000e)\u0006t7nV5uQ2Kgn[:\u0002\u001b\u0011\fG/Y,ji\",6/\u001a:!\u00039!\u0018M\\6UC\ndW-\u00138qkR,\"!a\u0010\u0011\u000bm\fI!!\u0011\u0011\u000fy\ty!a\u0011\u0002\u0014A\u0019A,!\u0012\n\u0007\u0005\u001dSL\u0001\bUC:\\G+\u00192mK&s\u0007/\u001e;\u0002\u001fQ\fgn\u001b+bE2,\u0017J\u001c9vi\u0002\nqbZ3u\u00032d\u0017i\u001a:j)\u0006t7n\u001d\u000b\u000b\u0003'\ty%!\u0017\u0002j\u00055\u0004bBA)\u0019\u0001\u0007\u00111K\u0001\b[\u0016\u001c8/Y4f!\rY\u0018QK\u0005\u0004\u0003/b(a\u0002&t-\u0006dW/\u001a\u0005\b\u00037b\u0001\u0019AA/\u0003\u001dAW-\u00193feN\u0004\u0002\"!\u0006\u0002`\u0005M\u00111M\u0005\u0005\u0003C\n9CA\u0002NCB\u00042AHA3\u0013\r\t9g\b\u0002\u0004\u0003:L\bbBA6\u0019\u0001\u0007\u00111C\u0001\u0007[>$W\u000f\\3\t\r]c\u0001\u0019AA\n\u0003!\u0011X-\u00193UC:\\WCAA:!\u0015Y\u0018\u0011BA;!\r!\u0014qO\u0005\u0004\u0003s*$aE*b[BdW\rV1oW^KG\u000f\u001b'j].\u001c\u0018!\u0003:fC\u0012$\u0016M\\6!\u00039\u0019'/Z1uK\u0006;'/\u001b+b].$\"\"a\u0005\u0002\u0002\u0006\r\u0015QQAD\u0011\u001d\t\tf\u0004a\u0001\u0003'Bq!a\u0017\u0010\u0001\u0004\ti\u0006C\u0004\u0002l=\u0001\r!a\u0005\t\r]{\u0001\u0019AA\n\u0003M9W\r^%ogR\fG\u000e\\1uS>tG+\u00198l))\t\u0019\"!$\u0002\u0010\u0006E\u00151\u0013\u0005\b\u0003#\u0002\u0002\u0019AA*\u0011\u001d\tY\u0006\u0005a\u0001\u0003;Bq!a\u001b\u0011\u0001\u0004\t\u0019\u0002\u0003\u0004X!\u0001\u0007\u00111C\u0001\u0017kB$\u0017\r^3J]N$\u0018\r\u001c7bi&|g\u000eV1oWRQ\u00111CAM\u00037\u000bi*a(\t\u000f\u0005E\u0013\u00031\u0001\u0002T!9\u00111L\tA\u0002\u0005u\u0003bBA6#\u0001\u0007\u00111\u0003\u0005\u0007/F\u0001\r!a\u0005\u0002\u00131Lgn[:SK\u0006$WCAAS!\u0015Y\u0018\u0011BAT!\u001dq\u0012qBA\n\u0003S\u0003B!a\u000b\u0002,&!\u0011QVA\u0017\u0005%!\u0016M\\6MS:\\7/\u0001\u0006mS:\\7OU3bI\u0002\nq\"\u001e9eCR,G+\u00198l\u0019&t7n\u001d\u000b\u000b\u0003'\t),a.\u0002:\u0006m\u0006bBA))\u0001\u0007\u00111\u000b\u0005\b\u00037\"\u0002\u0019AA/\u0011\u001d\tY\u0007\u0006a\u0001\u0003'Aaa\u0016\u000bA\u0002\u0005M\u0011!\u0003;b].$\u0016M\u00197f))\t\u0019\"!1\u0002D\u0006\u0015\u0017q\u0019\u0005\b\u0003#*\u0002\u0019AA*\u0011\u001d\tY&\u0006a\u0001\u0003;Bq!a\u001b\u0016\u0001\u0004\t\u0019\u0002\u0003\u0004X+\u0001\u0007\u00111\u0003")
public class InstallationTankController {
    private final InstallationTankDao installationTankDao;
    private final SampleTankDao sampleTankDao;
    private final SieauParametersDao sieauParametersDao;
    private final LogUtil logUtil;
    private final UserStationDao userStationDao;
    private final TankTableDao tankTableDao;
    private final Reads<Tuple2<String, TankWithLinks>> dataWithUser;
    private final Reads<Tuple2<TankTableInput, String>> tankTableInput;
    private final Reads<SampleTankWithLinks> readTank;
    private final Reads<Tuple2<String, TankLinks>> linksRead;

    public Reads<Tuple2<String, TankWithLinks>> dataWithUser() {
        return this.dataWithUser;
    }

    public Reads<Tuple2<TankTableInput, String>> tankTableInput() {
        return this.tankTableInput;
    }

    public String getAllAgriTanks(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.sampleTankDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)SampleTankWithLinks$.MODULE$.accessibilitesWrites())).toString();
    }

    public Reads<SampleTankWithLinks> readTank() {
        return this.readTank;
    }

    public String createAgriTank(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.readTank()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate json from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)tank -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.sampleTankDao.createInstallationTank(tank)), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public String getInstallationTank(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate id from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)id -> InstallationTankController.$anonfun$getInstallationTank$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String updateInstallationTank(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.dataWithUser()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(58).append("Can't validate installation tank object from json input : ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)tankRead -> {
            Tuple2 tuple2 = tankRead;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            TankWithLinks tank = (TankWithLinks)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)tank);
            String user2 = (String)tuple22._1();
            TankWithLinks tank2 = (TankWithLinks)tuple22._2();
            Option option = $this.installationTankDao.getWithLinks(tank2.idStation());
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.installationTankDao.insert(tank2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (option instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.installationTankDao.update(tank2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public Reads<Tuple2<String, TankLinks>> linksRead() {
        return this.linksRead;
    }

    public String updateTankLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.linksRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(45).append("Can't validate tank object from json input : ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)input -> {
            Tuple2 tuple2 = input;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            TankLinks links = (TankLinks)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)links);
            String user2 = (String)tuple22._1();
            TankLinks links2 = (TankLinks)tuple22._2();
            Option option = $this.installationTankDao.getWithLinks(links2.idStation());
            if (None$.MODULE$.equals(option)) {
                return ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't find installation tank.", 404, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5());
            }
            if (option instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.installationTankDao.updateLinks(links2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String tankTable(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.tankTableInput()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(30).append("Can't parse Tank table input, ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Tuple2<Seq<TankTableLine>, Object> tuple2;
            Tuple2<Seq<TankTableLine>, Object> tuple22;
            Tuple2 tuple23 = params;
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            TankTableInput input = (TankTableInput)tuple23._1();
            String module = (String)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)input, (Object)module);
            TankTableInput input2 = (TankTableInput)tuple24._1();
            String module2 = (String)tuple24._2();
            Option operatorCode = $this.sieauParametersDao.getString("contributorTypeOperator", "SIEAU");
            Option administratorCode = $this.sieauParametersDao.getString("contributorTypeAdministrator", "SIEAU");
            Seq allowStations = $this.userStationDao.getAvailableStation(input2.user(), StationTypeConstants$.MODULE$.TYPE_STATION_INSTALLATION(), module2);
            String string = CommonReadUtil$.MODULE$.getAllowedStations(allowStations);
            String string2 = StationTypeConstants$.MODULE$.FORBIDEN();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                tuple22 = new Tuple2<Seq<TankTableLine>, Object>((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0));
            } else {
                String string4 = StationTypeConstants$.MODULE$.ALL();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    tuple22 = $this.tankTableDao.getTankTable(input2, (Option<String>)administratorCode, (Option<String>)operatorCode, (Seq<Object>)((Seq)Nil$.MODULE$), StationTypeConstants$.MODULE$.ALL());
                } else {
                    Seq allowStationsIds = (Seq)allowStations.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4))));
                    tuple22 = tuple2 = $this.tankTableDao.getTankTable(input2, (Option<String>)administratorCode, (Option<String>)operatorCode, (Seq<Object>)allowStationsIds, $this.tankTableDao.getTankTable$default$5());
                }
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq sqlResults = (Seq)tuple2._1();
            int nbElements = tuple2._2$mcI$sp();
            Tuple2 tuple25 = new Tuple2((Object)sqlResults, (Object)BoxesRunTime.boxToInteger((int)nbElements));
            Seq sqlResults2 = (Seq)tuple25._1();
            int nbElements2 = tuple25._2$mcI$sp();
            return SieauFilteredTableLine$.MODULE$.generateJson((Seq<SieauFilteredTableLine>)sqlResults2, input2.searchValue(), input2.forceLoad(), input2.previewSize(), nbElements2);
        });
    }

    public static final /* synthetic */ String $anonfun$getInstallationTank$2(InstallationTankController $this, int id) {
        Option option = $this.installationTankDao.getWithLinks((long)id);
        if (option instanceof Some) {
            Some some = (Some)option;
            TankWithLinks tank = (TankWithLinks)some.value();
            return Json$.MODULE$.toJson((Object)tank, (Writes)TankWithLinks$.MODULE$.format()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't find installation tank.", 404, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5());
        }
        throw new MatchError((Object)option);
    }

    @Inject
    public InstallationTankController(InstallationTankDao installationTankDao, SampleTankDao sampleTankDao, SieauParametersDao sieauParametersDao, LogUtil logUtil, UserStationDao userStationDao, TankTableDao tankTableDao) {
        this.installationTankDao = installationTankDao;
        this.sampleTankDao = sampleTankDao;
        this.sieauParametersDao = sieauParametersDao;
        this.logUtil = logUtil;
        this.userStationDao = userStationDao;
        this.tankTableDao = tankTableDao;
        this.dataWithUser = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("data").read((Reads)TankWithLinks$.MODULE$.format())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.tankTableInput = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("tankTableInput").read(TankTableInput$.MODULE$.format()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.readTank = JsPath$.MODULE$.$bslash("tank").read((Reads)SampleTankWithLinks$.MODULE$.accessibilitesWrites());
        this.linksRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("links").read((Reads)TankLinks$.MODULE$.format())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

