/*
 * Decompiled with CFR 0.152.
 */
package dao.installationTypes.borehole.controllers;

import dao.installation.domain.output.InstallationBoreholesOutput;
import dao.installation.domain.output.InstallationBoreholesOutput$;
import dao.installationTypes.borehole.domain.BoreholeTableInput;
import dao.installationTypes.borehole.domain.BoreholeTableInput$;
import dao.installationTypes.borehole.domain.BoreholeTableLine;
import dao.installationTypes.borehole.itf.BoreholeTableDao;
import fr.aquasys.constants.StationTypeConstants$;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.installation.domain.BoreholeLinks;
import fr.aquasys.daeau.installation.domain.BoreholeLinks$;
import fr.aquasys.daeau.installation.domain.BoreholeWithLinks;
import fr.aquasys.daeau.installation.domain.BoreholeWithLinks$;
import fr.aquasys.daeau.installation.itf.borehole.InstallationBoreholeDao;
import fr.aquasys.daeau.installation.model.borehole.InstallationBorehole;
import fr.aquasys.daeau.station.links.aquifer.StationAquifer;
import fr.aquasys.daeau.station.links.usages.Usage;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.SieauFilteredTableLine;
import util.SieauFilteredTableLine$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001\u0002\n\u0014\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!I\u0005A!A!\u0002\u0013Q\u0005\"\u0002*\u0001\t\u0003\u0019\u0006b\u00023\u0001\u0005\u0004%\t!\u001a\u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003g\u0011%\ty\u0001\u0001b\u0001\n\u0003\t\t\u0002\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\n\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\u0012\u0001\t\u0003\tI\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0001\u0002V!A\u0011\u0011\r\u0001!\u0002\u0013\t9\u0006C\u0004\u0002d\u0001!\t!!\u001a\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u00111\u0010\u0001\u0005\u0002\u0005u$AH%ogR\fG\u000e\\1uS>t'i\u001c:fQ>dWmQ8oiJ|G\u000e\\3s\u0015\t!R#A\u0006d_:$(o\u001c7mKJ\u001c(B\u0001\f\u0018\u0003!\u0011wN]3i_2,'B\u0001\r\u001a\u0003EIgn\u001d;bY2\fG/[8o)f\u0004Xm\u001d\u0006\u00025\u0005\u0019A-Y8\u0004\u0001M\u0011\u0001!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0002/%t7\u000f^1mY\u0006$\u0018n\u001c8C_J,\u0007n\u001c7f\t\u0006|\u0007CA\u00132\u001b\u00051#B\u0001\f(\u0015\tA\u0013&A\u0002ji\u001aT!AK\u0016\u0002\u0019%t7\u000f^1mY\u0006$\u0018n\u001c8\u000b\u00051j\u0013!\u00023bK\u0006,(B\u0001\u00180\u0003\u001d\t\u0017/^1tsNT\u0011\u0001M\u0001\u0003MJL!A\r\u0014\u0003/%s7\u000f^1mY\u0006$\u0018n\u001c8C_J,\u0007n\u001c7f\t\u0006|\u0017\u0001\u0005\"pe\u0016Dw\u000e\\3UC\ndW\rR1p!\t)t'D\u00017\u0015\tAS#\u0003\u00029m\t\u0001\"i\u001c:fQ>dW\rV1cY\u0016$\u0015m\\\u0001\u000fkN,'o\u0015;bi&|g\u000eR1p!\tYt(D\u0001=\u0015\tASH\u0003\u0002?W\u0005!Qo]3s\u0013\t\u0001EH\u0001\bVg\u0016\u00148\u000b^1uS>tG)Y8\u0002%MKW-Y;QCJ\fW.\u001a;feN$\u0015m\u001c\t\u0003\u0007\u001ek\u0011\u0001\u0012\u0006\u0003Q\u0015S!AR\u0016\u0002\u001d\u0005$W.\u001b8jgR\u0014\u0018\r^5p]&\u0011\u0001\n\u0012\u0002\u0013'&,\u0017-\u001e)be\u0006lW\r^3sg\u0012\u000bw.A\u0004m_\u001e,F/\u001b7\u0011\u0005-\u0003V\"\u0001'\u000b\u00055s\u0015\u0001B;uS2T!aT\u0017\u0002\u0011I\f'MY5u[FL!!\u0015'\u0003\u000f1{w-\u0016;jY\u00061A(\u001b8jiz\"b\u0001\u0016,X1fS\u0006CA+\u0001\u001b\u0005\u0019\u0002\"B\u0012\u0007\u0001\u0004!\u0003\"B\u001a\u0007\u0001\u0004!\u0004\"B\u001d\u0007\u0001\u0004Q\u0004\"B!\u0007\u0001\u0004\u0011\u0005\"B%\u0007\u0001\u0004Q\u0005F\u0001\u0004]!\ti&-D\u0001_\u0015\ty\u0006-\u0001\u0004j]*,7\r\u001e\u0006\u0002C\u0006)!.\u0019<bq&\u00111M\u0018\u0002\u0007\u0013:TWm\u0019;\u0002\u0019\u0011\fG/Y,ji\",6/\u001a:\u0016\u0003\u0019\u00042a\u001a9s\u001b\u0005A'BA5k\u0003\u0011Q7o\u001c8\u000b\u0005-d\u0017\u0001\u00027jENT!!\u001c8\u0002\u0007\u0005\u0004\u0018NC\u0001p\u0003\u0011\u0001H.Y=\n\u0005ED'!\u0002*fC\u0012\u001c\b#\u0002\u0010tk\u0006\u0005\u0011B\u0001; \u0005\u0019!V\u000f\u001d7feA\u0011a/ \b\u0003on\u0004\"\u0001_\u0010\u000e\u0003eT!A_\u000e\u0002\rq\u0012xn\u001c;?\u0013\tax$\u0001\u0004Qe\u0016$WMZ\u0005\u0003}~\u0014aa\u0015;sS:<'B\u0001? !\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004S\u00051Am\\7bS:LA!a\u0003\u0002\u0006\t\t\"i\u001c:fQ>dWmV5uQ2Kgn[:\u0002\u001b\u0011\fG/Y,ji\",6/\u001a:!\u0003I\u0011wN]3i_2,G+\u00192mK&s\u0007/\u001e;\u0016\u0005\u0005M\u0001\u0003B4q\u0003+\u0001RAH:\u0002\u0018U\u0004B!!\u0007\u0002\u001e5\u0011\u00111\u0004\u0006\u0004\u0003\u000f)\u0012\u0002BA\u0010\u00037\u0011!CQ8sK\"|G.\u001a+bE2,\u0017J\u001c9vi\u0006\u0019\"m\u001c:fQ>dW\rV1cY\u0016Le\u000e];uA\u00059r-\u001a;J]N$\u0018\r\u001c7bi&|gNQ8sK\"|G.\u001a\u000b\nk\u0006\u001d\u0012\u0011GA!\u0003\u000bBq!!\u000b\f\u0001\u0004\tY#A\u0004nKN\u001c\u0018mZ3\u0011\u0007\u001d\fi#C\u0002\u00020!\u0014qAS:WC2,X\rC\u0004\u00024-\u0001\r!!\u000e\u0002\u000f!,\u0017\rZ3sgB1a/a\u000ev\u0003wI1!!\u000f\u0000\u0005\ri\u0015\r\u001d\t\u0004=\u0005u\u0012bAA ?\t\u0019\u0011I\\=\t\r\u0005\r3\u00021\u0001v\u0003\u0019iw\u000eZ;mK\")ah\u0003a\u0001k\u0006QR\u000f\u001d3bi\u0016Len\u001d;bY2\fG/[8o\u0005>\u0014X\r[8mKRIQ/a\u0013\u0002N\u0005=\u0013\u0011\u000b\u0005\b\u0003Sa\u0001\u0019AA\u0016\u0011\u001d\t\u0019\u0004\u0004a\u0001\u0003kAa!a\u0011\r\u0001\u0004)\b\"\u0002 \r\u0001\u0004)\u0018!\u00037j].\u001c(+Z1e+\t\t9\u0006\u0005\u0003ha\u0006e\u0003#\u0002\u0010tk\u0006m\u0003\u0003BA\u0002\u0003;JA!a\u0018\u0002\u0006\ti!i\u001c:fQ>dW\rT5oWN\f!\u0002\\5oWN\u0014V-\u00193!\u0003M)\b\u000fZ1uK\n{'/\u001a5pY\u0016d\u0015N\\6t)%)\u0018qMA5\u0003W\ni\u0007C\u0004\u0002*=\u0001\r!a\u000b\t\u000f\u0005Mr\u00021\u0001\u00026!1\u00111I\bA\u0002UDQAP\bA\u0002U\fqbZ3u\u00032d'i\u001c:fQ>dWm\u001d\u000b\nk\u0006M\u0014QOA<\u0003sBq!!\u000b\u0011\u0001\u0004\tY\u0003C\u0004\u00024A\u0001\r!!\u000e\t\r\u0005\r\u0003\u00031\u0001v\u0011\u0015q\u0004\u00031\u0001v\u00035\u0011wN]3i_2,G+\u00192mKRIQ/a \u0002\u0002\u0006\r\u0015Q\u0011\u0005\b\u0003S\t\u0002\u0019AA\u0016\u0011\u001d\t\u0019$\u0005a\u0001\u0003kAa!a\u0011\u0012\u0001\u0004)\b\"\u0002 \u0012\u0001\u0004)\b")
public class InstallationBoreholeController {
    private final InstallationBoreholeDao installationBoreholeDao;
    private final BoreholeTableDao BoreholeTableDao;
    private final UserStationDao userStationDao;
    private final SieauParametersDao SieauParametersDao;
    private final LogUtil logUtil;
    private final Reads<Tuple2<String, BoreholeWithLinks>> dataWithUser;
    private final Reads<Tuple2<BoreholeTableInput, String>> boreholeTableInput;
    private final Reads<Tuple2<String, BoreholeLinks>> linksRead;

    public Reads<Tuple2<String, BoreholeWithLinks>> dataWithUser() {
        return this.dataWithUser;
    }

    public Reads<Tuple2<BoreholeTableInput, String>> boreholeTableInput() {
        return this.boreholeTableInput;
    }

    public String getInstallationBorehole(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate id from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)id -> InstallationBoreholeController.$anonfun$getInstallationBorehole$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String updateInstallationBorehole(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.dataWithUser()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(62).append("Can't validate installation borehole object from json input : ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)boreholeRead -> {
            Tuple2 tuple2 = boreholeRead;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            BoreholeWithLinks borehole = (BoreholeWithLinks)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)borehole);
            String user2 = (String)tuple22._1();
            BoreholeWithLinks borehole2 = (BoreholeWithLinks)tuple22._2();
            Option option = $this.installationBoreholeDao.get(BoxesRunTime.unboxToLong((Object)borehole2.id().get()));
            if (None$.MODULE$.equals(option)) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.installationBoreholeDao.insert(borehole2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (option instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.installationBoreholeDao.update(borehole2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public Reads<Tuple2<String, BoreholeLinks>> linksRead() {
        return this.linksRead;
    }

    public String updateBoreholeLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.linksRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(49).append("Can't validate borehole object from json input : ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)input -> {
            Tuple2 tuple2 = input;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            BoreholeLinks links = (BoreholeLinks)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)links);
            String user2 = (String)tuple22._1();
            BoreholeLinks links2 = (BoreholeLinks)tuple22._2();
            Option option = $this.installationBoreholeDao.get(links2.idStation());
            if (None$.MODULE$.equals(option)) {
                return ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't find installation borehole.", 404, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5());
            }
            if (option instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.installationBoreholeDao.updateLinks(links2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String getAllBoreholes(JsValue message, Map<String, Object> headers, String module, String user) {
        Seq boreholes = this.installationBoreholeDao.getAll();
        Seq aquifers = this.installationBoreholeDao.getAllBoreholeAquifers();
        Seq usages = this.installationBoreholeDao.getAllBoreholeUsages();
        return Json$.MODULE$.toJson(boreholes.map((Function1 & Serializable)b -> new InstallationBoreholesOutput(b.id(), (Option<Object>)b.nature(), (Option<Object>)b.superficialWaterIsolation(), (Option<Object>)b.supIsolationToVerify(), (Option<Object>)b.nonIsolatedWaterTables(), (Option<Object>)b.isolatedWaterTables(), (Option<Object>)b.isolationToVerify(), (Option<String>)b.isolationComment(), (Option<Object>)b.waterTableAccompaniment(), (Option<Object>)b.watershed(), (Option<Object>)b.hourWaterFlow(), (Option<Object>)b.yearWaterFlow(), (Option<String>)b.cementationTubing(), (Option<String>)b.pumpType(), (Option<Object>)b.zReferenceMark(), (Option<String>)b.referenceMarkComment(), (Option<String>)b.arrestCode(), (Option<DateTime>)b.arrestDate(), (Option<DateTime>)b.serviceDate(), (Option<Object>)b.allowedHourWaterFlow(), (Option<Object>)b.allowedYearWaterVolume(), (Option<Object>)b.operator(), (Option<Object>)b.managementUnit(), (Option<Object>)b.distributionUnit(), (Option<Object>)b.fieldMode(), (Option<Object>)b.depth(), (Option<String>)b.surfaceGeology(), (Option<Object>)b.pumpDepth(), (Option<Object>)aquifers.find((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)InstallationBoreholeController.$anonfun$getAllBoreholes$2(b, a))).flatMap((Function1 & Serializable)a -> a.aquiferCode()), (Seq<Usage>)((Seq)usages.filter((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)InstallationBoreholeController.$anonfun$getAllBoreholes$4(b, u)))))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), InstallationBoreholesOutput$.MODULE$.installationBoreholesOutputFormat())).toString();
    }

    public String boreholeTable(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.boreholeTableInput()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(34).append("Can't parse borehole table input, ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Tuple2<Seq<BoreholeTableLine>, Object> tuple2;
            Tuple2<Seq<BoreholeTableLine>, Object> tuple22;
            Tuple2 tuple23 = params;
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            BoreholeTableInput input = (BoreholeTableInput)tuple23._1();
            String module = (String)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)input, (Object)module);
            BoreholeTableInput input2 = (BoreholeTableInput)tuple24._1();
            String module2 = (String)tuple24._2();
            Seq allowStations = $this.userStationDao.getAvailableStation(input2.user(), StationTypeConstants$.MODULE$.TYPE_STATION_INSTALLATION(), module2);
            Option operatorCode = $this.SieauParametersDao.getString("contributorTypeOperator", "SIEAU");
            Option administratorCode = $this.SieauParametersDao.getString("contributorTypeAdministrator", "SIEAU");
            String string = CommonReadUtil$.MODULE$.getAllowedStations(allowStations);
            String string2 = StationTypeConstants$.MODULE$.FORBIDEN();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                tuple22 = new Tuple2<Seq<BoreholeTableLine>, Object>((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0));
            } else {
                String string4 = StationTypeConstants$.MODULE$.ALL();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    tuple22 = $this.BoreholeTableDao.getBoreholeTable(input2, (Option<String>)administratorCode, (Option<String>)operatorCode, (Seq<Object>)((Seq)Nil$.MODULE$), StationTypeConstants$.MODULE$.ALL());
                } else {
                    Seq allowStationsIds = (Seq)allowStations.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4))));
                    tuple22 = tuple2 = $this.BoreholeTableDao.getBoreholeTable(input2, (Option<String>)administratorCode, (Option<String>)operatorCode, (Seq<Object>)allowStationsIds, $this.BoreholeTableDao.getBoreholeTable$default$5());
                }
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq sqlResults = (Seq)tuple2._1();
            int nbElements = tuple2._2$mcI$sp();
            Tuple2 tuple25 = new Tuple2((Object)sqlResults, (Object)BoxesRunTime.boxToInteger((int)nbElements));
            Seq sqlResults2 = (Seq)tuple25._1();
            int nbElements2 = tuple25._2$mcI$sp();
            return SieauFilteredTableLine$.MODULE$.generateJson((Seq<SieauFilteredTableLine>)sqlResults2, input2.searchValue(), input2.forceLoad(), input2.previewSize(), nbElements2);
        });
    }

    public static final /* synthetic */ String $anonfun$getInstallationBorehole$2(InstallationBoreholeController $this, int id) {
        Option option = $this.installationBoreholeDao.getWithLinks((long)id);
        if (option instanceof Some) {
            Some some = (Some)option;
            BoreholeWithLinks borehole = (BoreholeWithLinks)some.value();
            return Json$.MODULE$.toJson((Object)borehole, (Writes)BoreholeWithLinks$.MODULE$.format()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't find installation borehole.", 404, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5());
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$getAllBoreholes$2(InstallationBorehole b$1, StationAquifer a) {
        return (long)a.idStation() == b$1.id();
    }

    public static final /* synthetic */ boolean $anonfun$getAllBoreholes$4(InstallationBorehole b$1, Usage u) {
        return (long)u.idStation() == b$1.id();
    }

    @Inject
    public InstallationBoreholeController(InstallationBoreholeDao installationBoreholeDao, BoreholeTableDao BoreholeTableDao2, UserStationDao userStationDao, SieauParametersDao SieauParametersDao2, LogUtil logUtil) {
        this.installationBoreholeDao = installationBoreholeDao;
        this.BoreholeTableDao = BoreholeTableDao2;
        this.userStationDao = userStationDao;
        this.SieauParametersDao = SieauParametersDao2;
        this.logUtil = logUtil;
        this.dataWithUser = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("data").read((Reads)BoreholeWithLinks$.MODULE$.format())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.boreholeTableInput = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("boreholeTableInput").read(BoreholeTableInput$.MODULE$.format()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.linksRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("links").read((Reads)BoreholeLinks$.MODULE$.format())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

