/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common;

import java.util.Set;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.SystemOfUnits;
import si.uom.quantity.AngularSpeed;
import tech.units.indriya.AbstractSystemOfUnits;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.Units;

public final class USCustomary
extends AbstractSystemOfUnits {
    private static final String SYSTEM_NAME = "United States Customary Units";
    private static final USCustomary INSTANCE = new USCustomary();
    public static final Unit<Length> METER = USCustomary.addUnit(Units.METRE);
    public static final Unit<Length> FOOT = USCustomary.addUnit(METER.multiply(3048.0).divide(10000.0), "Foot", "ft");
    public static final Unit<Length> FOOT_SURVEY = USCustomary.addUnit(METER.multiply(1200.0).divide(3937.0), "US Survey foot", "ft_survey_us");
    public static final Unit<Length> YARD = USCustomary.addUnit(FOOT.multiply(3.0), "Yard", "yd");
    public static final Unit<Length> INCH = USCustomary.addUnit(FOOT.divide(12.0), "in");
    public static final Unit<Length> MILE = USCustomary.addUnit(METER.multiply(1609344.0).divide(1000.0), "Mile", "mi");
    public static final Unit<Length> LIGHT_YEAR = USCustomary.addUnit(Units.METRE.multiply(9.460528405E15), "Light year", "ly");
    public static final Unit<Length> NAUTICAL_MILE = USCustomary.addUnit(METER.multiply(1852.0), "Nautical mile", "nmi");
    public static final Unit<Mass> POUND = USCustomary.addUnit(Units.KILOGRAM.multiply(4.5359237E7).divide(1.0E8), "Pound", "lb");
    public static final Unit<Mass> OUNCE = USCustomary.addUnit(POUND.divide(16.0), "oz");
    public static final Unit<Mass> TON = USCustomary.addUnit(POUND.multiply(2000.0), "ton_us");
    public static final Unit<Temperature> RANKINE = USCustomary.addUnit(Units.KELVIN.multiply(5.0).divide(9.0));
    public static final Unit<Temperature> FAHRENHEIT = USCustomary.addUnit(RANKINE.shift(459.67), "\u00b0F");
    public static final Unit<Angle> REVOLUTION = USCustomary.addUnit(Units.RADIAN.multiply(2.0).multiply(Math.PI).asType(Angle.class), "rev");
    public static final Unit<Angle> DEGREE_ANGLE = USCustomary.addUnit(REVOLUTION.divide(360.0));
    public static final Unit<Angle> MINUTE_ANGLE = USCustomary.addUnit(DEGREE_ANGLE.divide(60.0));
    public static final Unit<Angle> SECOND_ANGLE = USCustomary.addUnit(MINUTE_ANGLE.divide(60.0));
    public static final Unit<Angle> CENTIRADIAN = USCustomary.addUnit(Units.RADIAN.divide(100.0));
    public static final Unit<Angle> GRADE = USCustomary.addUnit(REVOLUTION.divide(400.0));
    public static final Unit<Time> MINUTE = USCustomary.addUnit(Units.SECOND.multiply(60.0));
    public static final Unit<Time> HOUR = USCustomary.addUnit(MINUTE.multiply(60.0));
    public static final Unit<Speed> FOOT_PER_SECOND = USCustomary.addUnit(FOOT.divide(Units.SECOND).asType(Speed.class));
    public static final Unit<Speed> MILE_PER_HOUR = USCustomary.addUnit(MILE.divide(HOUR).asType(Speed.class), "Mile per hour", "mph");
    public static final Unit<Speed> KNOT = USCustomary.addUnit(NAUTICAL_MILE.divide(HOUR).asType(Speed.class), "Knot", "kn");
    public static final Unit<Area> SQUARE_FOOT = USCustomary.addUnit(new ProductUnit((Unit)((AbstractUnit)FOOT.multiply(FOOT))), "sft");
    public static final Unit<Area> ARE = USCustomary.addUnit(Units.SQUARE_METRE.multiply(100.0), "Are", "a");
    public static final Unit<Area> HECTARE = USCustomary.addUnit(ARE.multiply(100.0), "Hectare", "ha");
    public static final Unit<Area> ACRE = USCustomary.addUnit(SQUARE_FOOT.multiply(43560.0), "Acre", "ac");
    public static final Unit<Energy> ELECTRON_VOLT = USCustomary.addUnit(Units.JOULE.multiply(1.602176462E-19), "Electron Volt", "eV");
    public static final Unit<Power> HORSEPOWER = USCustomary.addUnit(Units.WATT.multiply(745.69987158227), "Horsepower", "hp");
    public static final Unit<Power> ELECTRICAL_HORSEPOWER = USCustomary.addUnit(Units.WATT.multiply(746.0), "Horsepower (Electrical)", "hp(E)");
    public static final Unit<Volume> LITER = USCustomary.addUnit(new TransformedUnit(Units.CUBIC_METRE, (UnitConverter)MultiplyConverter.ofRational((long)1L, (long)1000L)), "Liter", "L");
    public static final Unit<Volume> CUBIC_INCH = USCustomary.addUnit(INCH.pow(3).asType(Volume.class), "in\u00b3");
    public static final Unit<Volume> CUBIC_FOOT = USCustomary.addUnit(CUBIC_INCH.multiply(1728.0), "ft\u00b3");
    public static final Unit<Volume> ACRE_FOOT = USCustomary.addUnit(CUBIC_FOOT.multiply(43560.0), "Acre-foot", "ac ft");
    public static final Unit<Volume> GALLON_DRY = USCustomary.addUnit(CUBIC_INCH.multiply(2688025.0).divide(10000.0), "US dry gallon", "gal_dry_us");
    public static final Unit<Volume> GALLON_LIQUID = USCustomary.addUnit(CUBIC_INCH.multiply(231.0), "US gallon", "gal");
    public static final Unit<Volume> FLUID_OUNCE = USCustomary.addUnit(GALLON_LIQUID.divide(128.0), "Fluid Ounze", "fl oz");
    public static final Unit<Volume> GILL_LIQUID = USCustomary.addUnit(FLUID_OUNCE.multiply(4.0), "Liquid Gill", "liq.gi");
    public static final Unit<Volume> MINIM = USCustomary.addUnit(MetricPrefix.MICRO(LITER).multiply(61.61152), "Minim", "min_us");
    public static final Unit<Volume> FLUID_DRAM = USCustomary.addUnit(MINIM.multiply(60.0), "Fluid dram", "fl dr");
    public static final Unit<Volume> CUP = USCustomary.addUnit(FLUID_OUNCE.multiply(8.0), "Cup", "cup");
    public static final Unit<Volume> TEASPOON = USCustomary.addUnit(MINIM.multiply(80.0), "Teaspoon", "tsp");
    public static final Unit<Volume> TABLESPOON = USCustomary.addUnit(TEASPOON.multiply(3.0), "Tablespoon", "Tbsp");
    public static final Unit<Volume> BARREL = USCustomary.addUnit(LITER.multiply(238.481), "Barrel", "bbl");
    public static final Unit<Volume> PINT = USCustomary.addUnit(GILL_LIQUID.multiply(4.0), "Pint", "pt");
    public static final Unit<AngularSpeed> REVOLUTION_PER_MINUTE = USCustomary.addUnit(REVOLUTION.divide(MINUTE), "Pint", "rpm").asType(AngularSpeed.class);

    private USCustomary() {
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return SYSTEM_NAME;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        USCustomary.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel) {
            SimpleUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return (U)AbstractSystemOfUnits.Helper.addUnit((Set)USCustomary.INSTANCE.units, unit, (String)name);
        }
        USCustomary.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String label) {
        return USCustomary.addUnit(unit, name, label, true);
    }

    private static <U extends Unit<?>> U addUnit(U unit, String text) {
        return USCustomary.addUnit(unit, null, text, true);
    }
}

