/*
 * Decompiled with CFR 0.152.
 */
package Quality.ades.controller;

import Quality.ades.controller.AdesQualityDataImport;
import Quality.ades.controller.AdesQualityStationImport;
import Quality.ades.dao.OperationDao;
import ades.AdesWSUtil;
import ades.controller.AdesFilter;
import ades.controller.AdesFilter$;
import ades.dao.rpc.StationDao;
import ades.model.Bss;
import ades.model.Bss$;
import ades.model.hubeauCall.HubeauCodesResult;
import ades.model.hubeauCall.HubeauCodesResult$;
import constant.ImportMode$;
import constant.IntegrationType$;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.model.QualitometerCode;
import fr.aquasys.daeau.referentials.sandreCode.dao.SandreCodeDao;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode;
import fr.aquasys.daeau.station.links.network.StationNetwork;
import fr.aquasys.daeau.station.links.network.StationNetworkDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import java.net.URLEncoder;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.management.InvalidApplicationException;
import org.joda.time.DateTime;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.xml.NodeSeq;
import scala.xml.XML$;
import util.WSUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\tUa\u0001\u0002\u000b\u0016\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006Y\u0001\n\u0005\t_\u0001\u0011\t\u0011)A\u0006a!AA\u0007\u0001B\u0001B\u0003-Q\u0007\u0003\u00059\u0001\t\u0005\t\u0015a\u0003:\u0011!\u0011\u0005A!A!\u0002\u0017\u0019\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b1B%\t\u0011a\u0003!\u0011!Q\u0001\feC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006YA\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0006O\"Aq\u000e\u0001B\u0001B\u0003-\u0001\u000f\u0003\u0005{\u0001\t\u0005\t\u0015a\u0003|\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0006bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003+\u0004AQAAl\u0011%\tI\u0010AI\u0001\n\u000b\tYPA\u000bBI\u0016\u001c\u0018+^1mSRL8i\u001c8ue>dG.\u001a:\u000b\u0005Y9\u0012AC2p]R\u0014x\u000e\u001c7fe*\u0011\u0001$G\u0001\u0005C\u0012,7OC\u0001\u001b\u0003\u001d\tV/\u00197jif\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\f!a^:\u0011\u0005\u0015jS\"\u0001\u0014\u000b\u0005\r:#B\u0001\u0015*\u0003\u0011a\u0017NY:\u000b\u0005)Z\u0013aA1qS*\tA&\u0001\u0003qY\u0006L\u0018B\u0001\u0018'\u0005!96k\u00117jK:$\u0018!F!eKN\fV/\u00197jif$\u0015\r^1J[B|'\u000f\u001e\t\u0003cIj\u0011!F\u0005\u0003gU\u0011Q#\u00113fgF+\u0018\r\\5us\u0012\u000bG/Y%na>\u0014H/\u0001\rBI\u0016\u001c\u0018+^1mSRL8\u000b^1uS>t\u0017*\u001c9peR\u0004\"!\r\u001c\n\u0005]*\"\u0001G!eKN\fV/\u00197jif\u001cF/\u0019;j_:LU\u000e]8si\u0006Q1\u000f^1uS>tG)Y8\u0011\u0005i\u0002U\"A\u001e\u000b\u0005qj\u0014a\u0001:qG*\u0011ahP\u0001\u0004I\u0006|'\"\u0001\r\n\u0005\u0005[$AC*uCRLwN\u001c#b_\u0006aq\u000e]3sCRLwN\u001c#b_B\u0011AIR\u0007\u0002\u000b*\u0011ahF\u0005\u0003\u000f\u0016\u0013Ab\u00149fe\u0006$\u0018n\u001c8EC>\fQbU1oIJ,7i\u001c3f\t\u0006|\u0007C\u0001&W\u001b\u0005Y%B\u0001 M\u0015\tie*\u0001\u0006tC:$'/Z\"pI\u0016T!a\u0014)\u0002\u0019I,g-\u001a:f]RL\u0017\r\\:\u000b\u0005E\u0013\u0016!\u00023bK\u0006,(BA*U\u0003\u001d\t\u0017/^1tsNT\u0011!V\u0001\u0003MJL!aV&\u0003\u001bM\u000bg\u000e\u001a:f\u0007>$W\rR1p\u0003=\tX/\u00197ji>lW\r^3s\t\u0006|\u0007C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\rIGO\u001a\u0006\u0003=B\u000bq!];bY&$\u00180\u0003\u0002a7\ny\u0011+^1mSR|W.\u001a;fe\u0012\u000bw.\u0001\u0006bI\u0016\u001cxkU+uS2\u0004\"a\u00193\u000e\u0003}J!!Z \u0003\u0015\u0005#Wm],T+RLG.A\u0004M_\u001e,F/\u001b7\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017\u0001B;uS2T!\u0001\u001c*\u0002\u0011I\f'MY5u[FL!A\\5\u0003\u000f1{w-\u0016;jY\u0006\t2\u000b^1uS>tg*\u001a;x_J\\G)Y8\u0011\u0005EDX\"\u0001:\u000b\u0005M$\u0018a\u00028fi^|'o\u001b\u0006\u0003kZ\fQ\u0001\\5oWNT!a\u001e)\u0002\u000fM$\u0018\r^5p]&\u0011\u0011P\u001d\u0002\u0012'R\fG/[8o\u001d\u0016$xo\u001c:l\t\u0006|\u0017A\u0003&pE2{w-\u0016;jYB\u0011Ap`\u0007\u0002{*\u0011aPU\u0001\u0006kRLGn]\u0005\u0004\u0003\u0003i(A\u0003&pE2{w-\u0016;jY\u00061A(\u001b8jiz\"\"!a\u0002\u00151\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;\ty\u0002\u0005\u00022\u0001!)1\u0005\u0004a\u0002I!)q\u0006\u0004a\u0002a!)A\u0007\u0004a\u0002k!)\u0001\b\u0004a\u0002s!)!\t\u0004a\u0002\u0007\")\u0001\n\u0004a\u0002\u0013\")\u0001\f\u0004a\u00023\")\u0011\r\u0004a\u0002E\")a\r\u0004a\u0002O\")q\u000e\u0004a\u0002a\")!\u0010\u0004a\u0002w\"\u001aA\"a\t\u0011\t\u0005\u0015\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u00051\u0011N\u001c6fGRT!!!\f\u0002\u000b)\fg/\u0019=\n\t\u0005E\u0012q\u0005\u0002\u0007\u0013:TWm\u0019;\u0002\u001f\u0015DXmY;uK6\u000bg.^1mYf$B!a\u000e\u0002NA!\u0011\u0011HA$\u001d\u0011\tY$a\u0011\u0011\u0007\u0005ur$\u0004\u0002\u0002@)\u0019\u0011\u0011I\u000e\u0002\rq\u0012xn\u001c;?\u0013\r\t)eH\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00131\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015s\u0004C\u0004\u0002P5\u0001\r!!\u0015\u0002\u000f5,7o]1hKB!\u00111KA-\u001b\t\t)FC\u0002\u0002X\u001d\nAA[:p]&!\u00111LA+\u0005\u001dQ5OV1mk\u0016\fq!\u001a=fGV$X\r\u0006\u0003\u0002b\u0005e\u0004CBA2\u0003[\n\u0019H\u0004\u0003\u0002f\u0005%d\u0002BA\u001f\u0003OJ\u0011\u0001I\u0005\u0004\u0003Wz\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003_\n\tHA\u0002TKFT1!a\u001b !\rq\u0012QO\u0005\u0004\u0003oz\"aA%oi\"9\u0011q\n\bA\u0002\u0005E\u0013\u0001D4fi\u0006#Wm]\"pI\u0016\u001cHCBA@\u00033\u000b9\u000b\u0006\u0003\u0002\u0002\u0006=\u0005CBA2\u0003[\n\u0019\t\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tIiP\u0001\u0006[>$W\r\\\u0005\u0005\u0003\u001b\u000b9IA\u0002CgNDq!!%\u0010\u0001\b\t\u0019*\u0001\bk_\n,\u00050Z2vi&|g.\u00133\u0011\u0007y\t)*C\u0002\u0002\u0018~\u0011A\u0001T8oO\"9\u00111T\bA\u0002\u0005u\u0015a\u00024jYR,'o\u001d\t\u0005\u0003?\u000b\u0019+\u0004\u0002\u0002\"*\u0011acP\u0005\u0005\u0003K\u000b\tK\u0001\u0006BI\u0016\u001ch)\u001b7uKJDq!!+\u0010\u0001\u0004\tY+\u0001\u0007rk\u0006d\u0017\u000e^8D_\u0012,7\u000f\u0005\u0004\u0002d\u00055\u0014Q\u0016\t\u0005\u0003_\u000b\u0019,\u0004\u0002\u00022*\u0019\u0011\u0011R/\n\t\u0005U\u0016\u0011\u0017\u0002\u0011#V\fG.\u001b;p[\u0016$XM]\"pI\u0016\fAdZ3u\t\u0016\u0004\u0018M\u001d;nK:$8i\u001c3fg\u001a\u0013x.\u001c%vE\u0016\fW\u000f\u0006\u0004\u0002<\u0006}\u00161\u0019\u000b\u0005\u0003\u0003\u000bi\fC\u0004\u0002\u0012B\u0001\u001d!a%\t\u000f\u0005\u0005\u0007\u00031\u0001\u0002\u0002\u0006!A-\u0019;b\u0011\u001d\t)\r\u0005a\u0001\u0003o\t1!\u001e:m\u0003A\u0001(o\\2fgN$v.\u00113fg\n\u001b8\u000f\u0006\u0003\u0002L\u0006=G\u0003BAA\u0003\u001bDq!!%\u0012\u0001\b\t\u0019\nC\u0004\u0002RF\u0001\r!a5\u0002\u000b\r|G-Z:\u0011\r\u0005\r\u0014QNA\u001c\u0003m9W\r\u001e\"tg\u001a\u0013x.\\(mI\u000e{G-\u001a,jC\n\u0013v)T<ggR1\u0011\u0011\\Ar\u0003O$B!a7\u0002bB)a$!8\u0002\u0004&\u0019\u0011q\\\u0010\u0003\r=\u0003H/[8o\u0011\u001d\t\tJ\u0005a\u0002\u0003'Cq!!:\u0013\u0001\u0004\t9$\u0001\u0006oK^\u00145o]\"pI\u0016D\u0011\"!;\u0013!\u0003\u0005\r!a\u001d\u0002\u000bI,GO]=)\u0007I\ti\u000f\u0005\u0003\u0002p\u0006UXBAAy\u0015\r\t\u0019pH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA|\u0003c\u0014q\u0001^1jYJ,7-A\u0013hKR\u00145o\u001d$s_6|E\u000eZ\"pI\u00164\u0016.\u0019\"S\u000f6;hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q \u0016\u0005\u0003g\nyp\u000b\u0002\u0003\u0002A!!1\u0001B\u0005\u001b\t\u0011)A\u0003\u0003\u0003\b\u0005E\u0018!C;oG\",7m[3e\u0013\u0011\u0011YA!\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rK\u0002\u0001\u0005\u001f\u0001B!!\n\u0003\u0012%!!1CA\u0014\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class AdesQualityController {
    private final WSClient ws;
    private final AdesQualityDataImport AdesQualityDataImport;
    private final AdesQualityStationImport AdesQualityStationImport;
    private final OperationDao operationDao;
    private final SandreCodeDao SandreCodeDao;
    private final QualitometerDao qualitometerDao;
    private final AdesWSUtil adesWSUtil;
    private final LogUtil LogUtil;
    private final StationNetworkDao StationNetworkDao;
    private final JobLogUtil JobLogUtil;

    public String executeManually(JsValue message) {
        Seq<Object> results = this.execute(message);
        return Json$.MODULE$.toJson(results.map((Function1 & Serializable)id -> AdesQualityController.$anonfun$executeManually$1(BoxesRunTime.unboxToInt((Object)id))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)GenericData$.MODULE$.writes())).toString();
    }

    public Seq<Object> execute(JsValue message) {
        return (Seq)message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            $this.LogUtil.error(new StringBuilder(44).append("Error validate Json to execute ades model :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.LogUtil.error$default$2());
            return (Seq)Nil$.MODULE$;
        }, (Function1 & Serializable)jobParameters -> {
            long jobExecutionId = jobParameters.jobExecutionId();
            Option stationIntegration = ((IterableOnceOps)jobParameters.dataTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals(IntegrationType$.MODULE$.STATION_INTEGRATION())));
            Option importModeOpt = ((IterableOnceOps)jobParameters.dataTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(ImportMode$.MODULE$.DATA())));
            AdesFilter filters = (AdesFilter)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new AdesFilter(AdesFilter$.MODULE$.$lessinit$greater$default$1(), AdesFilter$.MODULE$.$lessinit$greater$default$2(), AdesFilter$.MODULE$.$lessinit$greater$default$3(), AdesFilter$.MODULE$.$lessinit$greater$default$4(), AdesFilter$.MODULE$.$lessinit$greater$default$5(), AdesFilter$.MODULE$.$lessinit$greater$default$6(), AdesFilter$.MODULE$.$lessinit$greater$default$7(), AdesFilter$.MODULE$.$lessinit$greater$default$8(), AdesFilter$.MODULE$.$lessinit$greater$default$9(), AdesFilter$.MODULE$.$lessinit$greater$default$10(), AdesFilter$.MODULE$.$lessinit$greater$default$11(), AdesFilter$.MODULE$.$lessinit$greater$default$12(), AdesFilter$.MODULE$.$lessinit$greater$default$13(), AdesFilter$.MODULE$.$lessinit$greater$default$14()), false, AdesFilter$.MODULE$.format());
            Seq qualitometers = (Seq)$this.qualitometerDao.getAllCodes().$plus$plus((IterableOnce)(filters.dontCheckInternalReferences().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? Nil$.MODULE$ : $this.qualitometerDao.getAllOldOrNewBssCodes()));
            Seq sandreCodes = stationIntegration.contains((Object)IntegrationType$.MODULE$.STATION_INTEGRATION()) ? $this.SandreCodeDao.getAll() : (Seq)Nil$.MODULE$;
            BooleanRef serviceAvailable = BooleanRef.create((boolean)true);
            Seq<Bss> adesCodesFound = this.getAdesCodes(filters, (Seq<QualitometerCode>)qualitometers, jobExecutionId);
            Seq groups = adesCodesFound.grouped(1).toSeq();
            Seq importedIds = (Seq)((IterableOps)groups.zipWithIndex()).flatMap((Function1 & Serializable)x0$1 -> {
                Seq seq;
                int idx;
                block7: {
                    block8: {
                        Success success;
                        Seq qualitoCodes;
                        Try try_;
                        Failure failure;
                        boolean bl;
                        block9: {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Seq codes = (Seq)tuple2._1();
                            idx = tuple2._2$mcI$sp();
                            if (!serviceAvailable$1.elem || !codes.nonEmpty()) break block8;
                            $this.JobLogUtil.checkExecutionAbort(jobExecutionId);
                            bl = false;
                            failure = null;
                            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.AdesQualityStationImport.manageQualitometerStations((Seq<Bss>)codes, jobExecutionId, (Option<String>)stationIntegration, (String)jobParameters.user().get(), (Seq<SandreCode>)sandreCodes, filters));
                            if (!(try_ instanceof Failure)) break block9;
                            bl = true;
                            failure = (Failure)try_;
                            if (!(failure.exception() instanceof InvalidApplicationException)) break block9;
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "ADES ws unavailable, please contact ADES support. Stopping job...", "", $this.JobLogUtil.log$default$5());
                            serviceAvailable$1.elem = false;
                            seq = (Seq)Nil$.MODULE$;
                            break block7;
                        }
                        if (bl) {
                            Throwable e = failure.exception();
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error during Station integration", "", $this.JobLogUtil.log$default$5());
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", $this.JobLogUtil.log$default$5());
                            $this.LogUtil.printError(e);
                            seq = (Seq)Nil$.MODULE$;
                            break block7;
                        } else if (try_ instanceof Success && (qualitoCodes = (Seq)(success = (Success)try_).value()) != null) {
                            Seq results;
                            Seq seq2 = qualitoCodes;
                            Option option = importModeOpt;
                            if (option instanceof Some) {
                                String importMode;
                                Some some = (Some)option;
                                String string = importMode = (String)some.value();
                                String string2 = ImportMode$.MODULE$.NOTHING();
                                if (string == null ? string2 != null : !string.equals(string2)) {
                                    seq2.foreach((Function1 & Serializable)oneCode -> {
                                        AdesQualityController.$anonfun$execute$9(this, importMode, filters, jobExecutionId, importModeOpt, oneCode);
                                        return BoxedUnit.UNIT;
                                    });
                                }
                            }
                            seq = results = (Seq)seq2.map((Function1 & Serializable)adesObj -> BoxesRunTime.boxToInteger((int)AdesQualityController.$anonfun$execute$16(adesObj)));
                            break block7;
                        } else {
                            throw new MatchError((Object)try_);
                        }
                    }
                    seq = (Seq)Nil$.MODULE$;
                }
                Seq res = seq;
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.PROGRESS(), Integer.toString((int)(((double)idx + 1.0) * 100.0 / (double)groups.length())), "", $this.JobLogUtil.log$default$5());
                return res;
            });
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.STATION_IDS(), importedIds.mkString(","), "", $this.JobLogUtil.log$default$5());
            return importedIds;
        });
    }

    public Seq<Bss> getAdesCodes(AdesFilter filters, Seq<QualitometerCode> qualitoCodes, long jobExecutionId) {
        Seq seq;
        block4: {
            String string = filters.selectStationsMode();
            switch (string == null ? 0 : string.hashCode()) {
                case -1109706007: {
                    if (!"codesMode".equals(string)) break;
                    Seq stringCodes = (Seq)((IterableOps)filters.stationCodes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable)c -> c.toUpperCase().split("/")[0].trim());
                    seq = this.processToAdesBss((Seq<String>)stringCodes, jobExecutionId);
                    break block4;
                }
                case -872620994: {
                    Seq results;
                    if (!"filtersMode".equals(string)) break;
                    Seq departmentCodes = (Seq)filters.departmentCodes().map((Function1 & Serializable)codes -> (Seq)ArrayOps$.MODULE$.grouped$extension(Predef$.MODULE$.refArrayOps((Object[])codes.split(",")), 50).toSeq().flatMap((Function1 & Serializable)codesGroup -> this.getDepartmentCodesFromHubeau((Seq<Bss>)((Seq)Nil$.MODULE$), new StringBuilder(123).append("https://hubeau.eaufrance.fr/api/v1/qualite_nappes/stations?num_departement=").append(Predef$.MODULE$.wrapRefArray((Object[])codesGroup).mkString("%2C")).append("&fields=bss_id%2Ccode_bss&format=json&size=20000").toString(), jobExecutionId))).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    Seq networkCodes = (Seq)filters.network().map((Function1 & Serializable)networkId -> AdesQualityController.$anonfun$getAdesCodes$6(this, qualitoCodes, jobExecutionId, BoxesRunTime.unboxToInt((Object)networkId))).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    seq = results = (Seq)departmentCodes.$plus$plus((IterableOnce)networkCodes);
                    break block4;
                }
            }
            throw new MatchError((Object)string);
        }
        Seq codesWithoutId = seq;
        return (Seq)codesWithoutId.map((Function1 & Serializable)adesCode -> {
            Option option = qualitoCodes.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AdesQualityController.$anonfun$getAdesCodes$12(adesCode, p)));
            if (option instanceof Some) {
                Some some = (Some)option;
                QualitometerCode qualitoFound = (QualitometerCode)some.value();
                Some x$1 = new Some((Object)BoxesRunTime.boxToDouble((double)qualitoFound.id()));
                String x$2 = adesCode.copy$default$1();
                Option<String> x$3 = adesCode.copy$default$2();
                Option<String> x$4 = adesCode.copy$default$3();
                Option<String> x$5 = adesCode.copy$default$5();
                return adesCode.copy(x$2, x$3, x$4, (Option<Object>)x$1, x$5);
            }
            if (None$.MODULE$.equals(option)) {
                return adesCode;
            }
            throw new MatchError((Object)option);
        });
    }

    public Seq<Bss> getDepartmentCodesFromHubeau(Seq<Bss> data, String url, long jobExecutionId) {
        Option<HubeauCodesResult> promise = WSUtil$.MODULE$.simpleGet(url, WSUtil$.MODULE$.simpleGet$default$2(), WSUtil$.MODULE$.simpleGet$default$3(), HubeauCodesResult$.MODULE$.format(), this.ws);
        Option<HubeauCodesResult> option = promise;
        if (None$.MODULE$.equals(option)) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error while getting codes from department via hubeau", "", this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(37).append("Error calling hubeau with this url : ").append(url).toString(), "", this.JobLogUtil.log$default$5());
            return (Seq)Nil$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            HubeauCodesResult result = (HubeauCodesResult)some.value();
            Option<String> option2 = result.next();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String nextUrl = (String)some2.value();
                return this.getDepartmentCodesFromHubeau((Seq<Bss>)((Seq)data.$plus$plus((IterableOnce)result.data().map((Function1 & Serializable)d -> new Bss((String)d.bss_id().getOrElse((Function0 & Serializable)() -> d.code_bss()), (Option<String>)new Some((Object)d.code_bss()), d.bss_id(), (Option<Object>)None$.MODULE$, Bss$.MODULE$.$lessinit$greater$default$5())))), nextUrl, jobExecutionId);
            }
            return (Seq)data.$plus$plus((IterableOnce)result.data().map((Function1 & Serializable)d -> new Bss((String)d.bss_id().getOrElse((Function0 & Serializable)() -> d.code_bss()), (Option<String>)new Some((Object)d.code_bss().toUpperCase()), (Option<String>)d.bss_id().map((Function1 & Serializable)x$5 -> x$5.toUpperCase()), (Option<Object>)None$.MODULE$, Bss$.MODULE$.$lessinit$greater$default$5())));
        }
        throw new MatchError(option);
    }

    public Seq<Bss> processToAdesBss(Seq<String> codes, long jobExecutionId) {
        Tuple2 tuple2 = codes.partition((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)AdesQualityController.$anonfun$processToAdesBss$1(c)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq newCodes = (Seq)tuple2._1();
        Seq oldCodes = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)newCodes, (Object)oldCodes);
        Seq newCodes2 = (Seq)tuple22._1();
        Seq oldCodes2 = (Seq)tuple22._2();
        Seq oldCodesBss = (Seq)oldCodes2.map((Function1 & Serializable)c -> new Bss((String)c, (Option<String>)new Some((Object)c.toUpperCase()), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, Bss$.MODULE$.$lessinit$greater$default$5()));
        Seq newFromHubeau = (Seq)newCodes2.grouped(200).toSeq().flatMap((Function1 & Serializable)groupCodes -> {
            Option<HubeauCodesResult> promise;
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(22).append("Call hubeau for ").append(groupCodes.length()).append(" codes").toString(), "", $this.JobLogUtil.log$default$5());
            String url = new StringBuilder(114).append("https://hubeau.eaufrance.fr/api/v1/niveaux_nappes/stations?bss_id=").append(groupCodes.mkString("%2C%20")).append("&fields=bss_id%2Ccode_bss&format=json&size=20000").toString();
            Option<HubeauCodesResult> option = promise = WSUtil$.MODULE$.simpleGet(url, WSUtil$.MODULE$.simpleGet$default$2(), WSUtil$.MODULE$.simpleGet$default$3(), HubeauCodesResult$.MODULE$.format(), $this.ws);
            if (None$.MODULE$.equals(option)) {
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error while getting old codes from new codes via hubeau", "", $this.JobLogUtil.log$default$5());
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(37).append("Error calling hubeau with this url : ").append(url).toString(), "", $this.JobLogUtil.log$default$5());
                return Nil$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                HubeauCodesResult result = (HubeauCodesResult)some.value();
                return (IterableOnce)result.data().map((Function1 & Serializable)d -> new Bss((String)d.bss_id().getOrElse((Function0 & Serializable)() -> d.code_bss()), (Option<String>)new Some((Object)d.code_bss().toUpperCase()), (Option<String>)d.bss_id().map((Function1 & Serializable)x$7 -> x$7.toUpperCase()), Bss$.MODULE$.$lessinit$greater$default$4(), Bss$.MODULE$.$lessinit$greater$default$5()));
            }
            throw new MatchError(option);
        });
        Seq oldFromHubeau = (Seq)oldCodes2.grouped(200).toSeq().flatMap((Function1 & Serializable)groupCodes -> {
            String url = new StringBuilder(116).append("https://hubeau.eaufrance.fr/api/v1/niveaux_nappes/stations?code_bss=").append(((IterableOnceOps)groupCodes.map((Function1 & Serializable)x$8 -> x$8.replace("/", "%2F"))).mkString("%2C%20")).append("&fields=bss_id%2Ccode_bss&format=json&size=20000").toString();
            Option<HubeauCodesResult> promise = WSUtil$.MODULE$.simpleGet(url, WSUtil$.MODULE$.simpleGet$default$2(), WSUtil$.MODULE$.simpleGet$default$3(), HubeauCodesResult$.MODULE$.format(), $this.ws);
            Option<HubeauCodesResult> option = promise;
            if (None$.MODULE$.equals(option)) {
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error while getting old codes from new codes via hubeau", "", $this.JobLogUtil.log$default$5());
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(37).append("Error calling hubeau with this url : ").append(url).toString(), "", $this.JobLogUtil.log$default$5());
                return Nil$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                HubeauCodesResult result = (HubeauCodesResult)some.value();
                return (IterableOnce)result.data().map((Function1 & Serializable)d -> new Bss(d.code_bss(), (Option<String>)new Some((Object)d.code_bss().toUpperCase()), (Option<String>)d.bss_id().map((Function1 & Serializable)x$9 -> x$9.toUpperCase()), Bss$.MODULE$.$lessinit$greater$default$4(), Bss$.MODULE$.$lessinit$greater$default$5()));
            }
            throw new MatchError(option);
        });
        Seq notFoundHubeau = (Seq)((IterableOps)newCodes2.filter((Function1 & Serializable)code -> BoxesRunTime.boxToBoolean((boolean)AdesQualityController.$anonfun$processToAdesBss$11(newFromHubeau, code)))).flatMap((Function1 & Serializable)code -> this.getBssFromOldCodeViaBRGMwfs((String)code, this.getBssFromOldCodeViaBRGMwfs$default$2(), jobExecutionId));
        return (Seq)((IterableOps)((IterableOps)oldCodesBss.$plus$plus((IterableOnce)oldFromHubeau)).$plus$plus((IterableOnce)newFromHubeau)).$plus$plus((IterableOnce)notFoundHubeau);
    }

    public final Option<Bss> getBssFromOldCodeViaBRGMwfs(String newBssCode, int retry, long jobExecutionId) {
        Try try_;
        block5: {
            Try try_2;
            block6: {
                String res;
                while (true) {
                    String filter;
                    if (retry == 0) {
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(49).append("Code ").append(newBssCode).append(" not found on hubeau, calling BRGM WFS... : ").toString(), newBssCode, this.JobLogUtil.log$default$5());
                    }
                    if ((try_ = Try$.MODULE$.apply(() -> AdesQualityController.$anonfun$getBssFromOldCodeViaBRGMwfs$1(this, filter = new StringBuilder(145).append("<Filter><PropertyIsLike wildcard='*' singleChar='.' escape='!'><PropertyName>bss_id</PropertyName><Literal>*").append(newBssCode).append("*</Literal></PropertyIsLike></Filter>").toString()))) instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable err = failure.exception();
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(29).append("Error during BRGM WFS call : ").append(err.getMessage()).toString(), newBssCode, this.JobLogUtil.log$default$5());
                        this.LogUtil.printError(err);
                        return None$.MODULE$;
                    }
                    if (!(try_ instanceof Success)) break block5;
                    Success success = (Success)try_;
                    String result = (String)success.value();
                    try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> XML$.MODULE$.loadString(result).$bslash$bslash("code_bss").text());
                    if (try_2 instanceof Failure) {
                        Failure failure = (Failure)try_2;
                        Throwable err = failure.exception();
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "Code not found on BRGM WFS", newBssCode, this.JobLogUtil.log$default$5());
                        this.LogUtil.printError(err);
                        return None$.MODULE$;
                    }
                    if (!(try_2 instanceof Success)) break block6;
                    Success success2 = (Success)try_2;
                    res = (String)success2.value();
                    if (!res.trim().isEmpty() || retry > 3) break;
                    ++retry;
                }
                if (res.trim().isEmpty()) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(42).append("Code ").append(newBssCode).append(" not found, with call retried 3 times").toString(), newBssCode, this.JobLogUtil.log$default$5());
                    return new Some((Object)new Bss(newBssCode, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)newBssCode), Bss$.MODULE$.apply$default$4(), Bss$.MODULE$.apply$default$5()));
                }
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(58).append("Code ").append(newBssCode).append(" successfully fetched from BRGM WFS, oldcode found : ").append(res).toString(), newBssCode, this.JobLogUtil.log$default$5());
                return new Some((Object)new Bss(newBssCode, (Option<String>)new Some((Object)res.toUpperCase()), (Option<String>)new Some((Object)newBssCode), Bss$.MODULE$.apply$default$4(), Bss$.MODULE$.apply$default$5()));
            }
            throw new MatchError((Object)try_2);
        }
        throw new MatchError((Object)try_);
    }

    public final int getBssFromOldCodeViaBRGMwfs$default$2() {
        return 0;
    }

    public static final /* synthetic */ GenericData $anonfun$executeManually$1(int id) {
        DateTime x$1 = new DateTime();
        DateTime x$2 = new DateTime();
        int x$3 = id;
        None$ x$4 = None$.MODULE$;
        Option x$5 = GenericData$.MODULE$.$lessinit$greater$default$5();
        Option x$6 = GenericData$.MODULE$.$lessinit$greater$default$6();
        Option x$7 = GenericData$.MODULE$.$lessinit$greater$default$7();
        Option x$8 = GenericData$.MODULE$.$lessinit$greater$default$8();
        Option x$9 = GenericData$.MODULE$.$lessinit$greater$default$9();
        Option x$10 = GenericData$.MODULE$.$lessinit$greater$default$10();
        Option x$11 = GenericData$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = GenericData$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = GenericData$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = GenericData$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = GenericData$.MODULE$.$lessinit$greater$default$15();
        return new GenericData(x$1, x$2, (Option)x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
    }

    public static final /* synthetic */ void $anonfun$execute$9(AdesQualityController $this, String importMode$1, AdesFilter filters$1, long jobExecutionId$1, Option importModeOpt$1, Bss oneCode) {
        Option option;
        String string = importMode$1;
        String string2 = ImportMode$.MODULE$.ADD_LAST_DATA();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            option = oneCode.id().flatMap((Function1 & Serializable)id -> $this.operationDao.getLastDate(BoxesRunTime.unboxToDouble((Object)id), (Option<Object>)None$.MODULE$));
        } else {
            String string3 = importMode$1;
            String string4 = ImportMode$.MODULE$.REPLACE_RECENT_HISTO();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Option lastDate = oneCode.id().flatMap((Function1 & Serializable)id -> $this.operationDao.getLastDate(BoxesRunTime.unboxToDouble((Object)id), (Option<Object>)None$.MODULE$));
                option = lastDate.map((Function1 & Serializable)l -> (DateTime)new .colon.colon(l, (List)new .colon.colon((Object)new DateTime().minusMonths(BoxesRunTime.unboxToInt((Object)filters$1.recentHistoReplacePeriod().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 6))), (List)Nil$.MODULE$)).minBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getMillis()), (Ordering)Ordering.Long$.MODULE$));
            } else {
                option = None$.MODULE$;
            }
        }
        Option lastOperationDate = option;
        $this.JobLogUtil.checkExecutionAbort(jobExecutionId$1);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.adesWSUtil.callADESQualitoSamplesMultiple(oneCode, jobExecutionId$1, (Option<DateTime>)lastOperationDate));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tuple2 tuple = (Tuple2)success.value();
            Tuple2 tuple2 = tuple;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Bss adesBss = (Bss)tuple2._1();
            NodeSeq samples = (NodeSeq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)adesBss, (Object)samples);
            Bss adesBss2 = (Bss)tuple22._1();
            NodeSeq samples2 = (NodeSeq)tuple22._2();
            if (samples2.isEmpty()) {
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(25).append("No samples found for bss ").append(adesBss2.wantedCode()).toString(), adesBss2.wantedCode(), $this.JobLogUtil.log$default$5());
                return;
            }
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(21).append("Begin insert for bss ").append(adesBss2.wantedCode()).toString(), adesBss2.wantedCode(), $this.JobLogUtil.log$default$5());
            NodeSeq x$1 = samples2;
            String x$2 = adesBss2.wantedCode();
            double x$3 = BoxesRunTime.unboxToDouble((Object)adesBss2.id().get());
            long x$4 = jobExecutionId$1;
            String string5 = importMode$1;
            String string6 = ImportMode$.MODULE$.REPLACE_HISTO();
            boolean x$5 = !(string5 != null ? !string5.equals(string6) : string6 != null);
            Option x$6 = importModeOpt$1;
            Option<Seq<Object>> x$7 = filters$1.excludedProducers();
            None$ x$8 = None$.MODULE$;
            Option<Object> x$9 = filters$1.recentHistoReplacePeriod();
            Option<String> x$10 = $this.AdesQualityDataImport.insertMeasures$default$9();
            $this.AdesQualityDataImport.insertMeasures(x$1, x$2, x$3, x$4, x$5, x$7, (Option<String>)x$6, (Option<Object>)x$8, x$10, x$9);
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), "Error during samples integration", "", $this.JobLogUtil.log$default$5());
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), e.getMessage(), "", $this.JobLogUtil.log$default$5());
            $this.LogUtil.printError(e);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ int $anonfun$execute$16(Bss adesObj) {
        return (int)BoxesRunTime.unboxToDouble((Object)adesObj.id().get());
    }

    public static final /* synthetic */ boolean $anonfun$getAdesCodes$8(StationNetwork nl$1, QualitometerCode p) {
        return (int)p.id() == nl$1.idStation();
    }

    public static final /* synthetic */ Seq $anonfun$getAdesCodes$6(AdesQualityController $this, Seq qualitoCodes$1, long jobExecutionId$2, int networkId) {
        Seq networkStations = $this.StationNetworkDao.getStations(StationTypeUtil$.MODULE$.QUALITY(), networkId);
        return $this.processToAdesBss((Seq<String>)((Seq)networkStations.flatMap((Function1 & Serializable)nl -> qualitoCodes$1.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AdesQualityController.$anonfun$getAdesCodes$8(nl, p))).map((Function1 & Serializable)p -> p.code()))), jobExecutionId$2);
    }

    public static final /* synthetic */ boolean $anonfun$getAdesCodes$12(Bss adesCode$1, QualitometerCode p) {
        return adesCode$1.oldCode().map((Function1 & Serializable)old -> old.split("/")[0]).contains((Object)p.code()) || adesCode$1.newCode().map((Function1 & Serializable)c -> c.split("/")[0]).contains((Object)p.code());
    }

    public static final /* synthetic */ boolean $anonfun$processToAdesBss$1(String c) {
        return c.toUpperCase().startsWith("BSS");
    }

    public static final /* synthetic */ boolean $anonfun$processToAdesBss$12(String code$1, Bss bss) {
        return bss.newCode().contains((Object)code$1);
    }

    public static final /* synthetic */ boolean $anonfun$processToAdesBss$11(Seq newFromHubeau$1, String code) {
        return !newFromHubeau$1.exists((Function1 & Serializable)bss -> BoxesRunTime.boxToBoolean((boolean)AdesQualityController.$anonfun$processToAdesBss$12(code, bss)));
    }

    public static final /* synthetic */ String $anonfun$getBssFromOldCodeViaBRGMwfs$1(AdesQualityController $this, String filter$1) {
        return WSUtil$.MODULE$.getAsString(new StringBuilder(151).append("http://mapsref.brgm.fr/wxs/infoterre/catalogue?SERVICE=WFS&VERSION=2.0.0&REQUEST=GetFeature&TYPENAME=BSS_EAU_POINT&PROPERTYNAME=code_bss,bss_id&Filter=").append(URLEncoder.encode(filter$1, "UTF-8")).toString(), $this.ws);
    }

    @Inject
    public AdesQualityController(WSClient ws, AdesQualityDataImport AdesQualityDataImport2, AdesQualityStationImport AdesQualityStationImport2, StationDao stationDao, OperationDao operationDao, SandreCodeDao SandreCodeDao2, QualitometerDao qualitometerDao, AdesWSUtil adesWSUtil, LogUtil LogUtil2, StationNetworkDao StationNetworkDao2, JobLogUtil JobLogUtil2) {
        this.ws = ws;
        this.AdesQualityDataImport = AdesQualityDataImport2;
        this.AdesQualityStationImport = AdesQualityStationImport2;
        this.operationDao = operationDao;
        this.SandreCodeDao = SandreCodeDao2;
        this.qualitometerDao = qualitometerDao;
        this.adesWSUtil = adesWSUtil;
        this.LogUtil = LogUtil2;
        this.StationNetworkDao = StationNetworkDao2;
        this.JobLogUtil = JobLogUtil2;
    }
}

