/*
 * Decompiled with CFR 0.152.
 */
package Quality.hubeau.controller;

import Quality.ades.dao.OperationDao;
import Quality.hubeau.domain.HubeauQualityFilter;
import Quality.hubeau.domain.HubeauQualityFilter$;
import Quality.hubeau.model.HubeauQualityAnalysis;
import Quality.hubeau.model.HubeauQualityResult;
import Quality.hubeau.model.HubeauQualityResult$;
import Quality.surfaceQualitometer.controller.SurfaceQualitometerController;
import ades.model.Bss;
import ades.model.Bss$;
import ades.model.hubeauCall.HubeauCodesResult;
import ades.model.hubeauCall.HubeauCodesResult$;
import constant.ImportMode$;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.quality.chronicAnalysis.AnalysisImport;
import fr.aquasys.daeau.quality.chronicAnalysis.AnalysisImport$;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.model.EnvironnementalMeasure;
import fr.aquasys.daeau.quality.model.Indice;
import fr.aquasys.daeau.quality.model.QualitometerCode;
import fr.aquasys.daeau.quality.model.QualitometerOperationList;
import fr.aquasys.daeau.quality.model.QualitometerPoint;
import fr.aquasys.daeau.quality.operation.OperationImport;
import fr.aquasys.daeau.quality.operation.OperationImport$;
import fr.aquasys.daeau.quality.sample.SampleImport;
import fr.aquasys.daeau.quality.sample.SampleImport$;
import fr.aquasys.daeau.quality.sampling.Sampling;
import fr.aquasys.daeau.referentials.contributor.itf.ContributorsDao;
import fr.aquasys.daeau.referentials.support.itf.SupportDao;
import fr.aquasys.daeau.station.links.network.StationNetwork;
import fr.aquasys.daeau.station.links.network.StationNetworkDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import genericImport.itf.GenericImportDao;
import genericImport.model.CompleteOperationImport;
import genericImport.model.CompleteOperationImport$;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import genericImport.model.MicroSampling;
import genericImport.model.QualityRecovery;
import java.io.Serializable;
import javax.inject.Inject;
import model.ImportQualityDefaultValue;
import model.ImportQualityDefaultValue$;
import model.ImportQualityDefaultValueFind;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.ws.WSClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import util.WSUtil$;
import util.qualito.ContributorUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001B\t\u0013\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006Y!\t\u0005\t[\u0001\u0011\t\u0011)A\u0006]!AA\u0007\u0001B\u0001B\u0003-Q\u0007\u0003\u0005@\u0001\t\u0005\t\u0015a\u0003A\u0011!Q\u0005A!A!\u0002\u0017Y\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b1\u0002+\t\u0011u\u0003!\u0011!Q\u0001\fyC\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006YA\u001a\u0005\t[\u0002\u0011\t\u0011)A\u0006]\"AQ\u000f\u0001B\u0001B\u0003-a\u000fC\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003/\u0004A\u0011AAm\u0011\u001d\t)\u000f\u0001C\u0001\u0003O\u0014q\u0003S;cK\u0006,\u0018+^1mSRL8i\u001c8ue>dG.\u001a:\u000b\u0005M!\u0012AC2p]R\u0014x\u000e\u001c7fe*\u0011QCF\u0001\u0007QV\u0014W-Y;\u000b\u0003]\tq!U;bY&$\u0018p\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-A\u0004M_\u001e,F/\u001b7\u0011\u0005\tZS\"A\u0012\u000b\u0005\u0011*\u0013\u0001B;uS2T!AJ\u0014\u0002\u0011I\f'MY5u[FT!\u0001K\u0015\u0002\u000f\u0005\fX/Y:zg*\t!&\u0001\u0002ge&\u0011Af\t\u0002\b\u0019><W\u000b^5m\u0003)QuN\u0019'pOV#\u0018\u000e\u001c\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u001d\nQ!\u001e;jYNL!a\r\u0019\u0003\u0015){'\rT8h+RLG.A\brk\u0006d\u0017\u000e^8nKR,'\u000fR1p!\t1T(D\u00018\u0015\tA\u0014(A\u0002ji\u001aT!AO\u001e\u0002\u000fE,\u0018\r\\5us*\u0011AhJ\u0001\u0006I\u0006,\u0017-^\u0005\u0003}]\u0012q\"U;bY&$x.\\3uKJ$\u0015m\\\u0001\u0012'R\fG/[8o\u001d\u0016$xo\u001c:l\t\u0006|\u0007CA!I\u001b\u0005\u0011%BA\"E\u0003\u001dqW\r^<pe.T!!\u0012$\u0002\u000b1Lgn[:\u000b\u0005\u001d[\u0014aB:uCRLwN\\\u0005\u0003\u0013\n\u0013\u0011c\u0015;bi&|gNT3uo>\u00148\u000eR1p\u00031y\u0007/\u001a:bi&|g\u000eR1p!\ta\u0015+D\u0001N\u0015\tqu*A\u0002eC>T!\u0001\u0015\f\u0002\t\u0005$Wm]\u0005\u0003%6\u0013Ab\u00149fe\u0006$\u0018n\u001c8EC>\f!bU;qa>\u0014H\u000fR1p!\t)6,D\u0001W\u0015\tAtK\u0003\u0002Y3\u000691/\u001e9q_J$(B\u0001.<\u00031\u0011XMZ3sK:$\u0018.\u00197t\u0013\tafK\u0001\u0006TkB\u0004xN\u001d;EC>\f\u0001cZ3oKJL7-S7q_J$H)Y8\u0011\u0005}\u001bW\"\u00011\u000b\u0005a\n'\"\u00012\u0002\u001b\u001d,g.\u001a:jG&k\u0007o\u001c:u\u0013\t!\u0007M\u0001\tHK:,'/[2J[B|'\u000f\u001e#b_\u0006q1m\u001c8ue&\u0014W\u000f^8s\t\u0006|\u0007CA4l\u001b\u0005A'B\u0001\u001dj\u0015\tQ\u0017,A\u0006d_:$(/\u001b2vi>\u0014\u0018B\u00017i\u0005=\u0019uN\u001c;sS\n,Ho\u001c:t\t\u0006|\u0017!H*ve\u001a\f7-Z)vC2LGo\\7fi\u0016\u00148i\u001c8ue>dG.\u001a:\u0011\u0005=\u001cX\"\u00019\u000b\u0005M\t(B\u0001:\u0017\u0003M\u0019XO\u001d4bG\u0016\fV/\u00197ji>lW\r^3s\u0013\t!\bOA\u000fTkJ4\u0017mY3Rk\u0006d\u0017\u000e^8nKR,'oQ8oiJ|G\u000e\\3s\u0003\t98\u000f\u0005\u0002x\u007f6\t\u0001P\u0003\u0002vs*\u0011!p_\u0001\u0005Y&\u00147O\u0003\u0002}{\u0006\u0019\u0011\r]5\u000b\u0003y\fA\u0001\u001d7bs&\u0019\u0011\u0011\u0001=\u0003\u0011]\u001b6\t\\5f]R\fa\u0001P5oSRtDCAA\u0004)Y\tI!!\u0004\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0001cAA\u0006\u00015\t!\u0003C\u0003!\u0017\u0001\u000f\u0011\u0005C\u0003.\u0017\u0001\u000fa\u0006C\u00035\u0017\u0001\u000fQ\u0007C\u0003@\u0017\u0001\u000f\u0001\tC\u0003K\u0017\u0001\u000f1\nC\u0003T\u0017\u0001\u000fA\u000bC\u0003^\u0017\u0001\u000fa\fC\u0003f\u0017\u0001\u000fa\rC\u0003n\u0017\u0001\u000fa\u000eC\u0003v\u0017\u0001\u000fa\u000fK\u0002\f\u0003G\u0001B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0004j]*,7\r\u001e\u0006\u0003\u0003[\tQA[1wCbLA!!\r\u0002(\t1\u0011J\u001c6fGR\f!$\u001a=fGV$X\rS;cK\u0006,\u0018+^1mSRL\u0018*\u001c9peR$B!a\u000e\u0002>A\u00191$!\u000f\n\u0007\u0005mBD\u0001\u0003V]&$\bbBA \u0019\u0001\u0007\u0011\u0011I\u0001\b[\u0016\u001c8/Y4f!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$s\u0006!!n]8o\u0013\u0011\tY%!\u0012\u0003\u000f)\u001bh+\u00197vK\u0006\tr-\u001a;ECR\fgI]8n\u0011V\u0014W-Y;\u0015\u0015\u0005E\u0013\u0011QAK\u00033\u000bi\n\u0006\u0003\u0002T\u0005]\u0004CBA+\u0003K\nYG\u0004\u0003\u0002X\u0005\u0005d\u0002BA-\u0003?j!!a\u0017\u000b\u0007\u0005u\u0003$\u0001\u0004=e>|GOP\u0005\u0002;%\u0019\u00111\r\u000f\u0002\u000fA\f7m[1hK&!\u0011qMA5\u0005\r\u0019V-\u001d\u0006\u0004\u0003Gb\u0002\u0003BA7\u0003gj!!a\u001c\u000b\u0007\u0005ED#A\u0003n_\u0012,G.\u0003\u0003\u0002v\u0005=$!\u0006%vE\u0016\fW/U;bY&$\u00180\u00118bYf\u001c\u0018n\u001d\u0005\b\u0003sj\u00019AA>\u00039QwNY#yK\u000e,H/[8o\u0013\u0012\u00042aGA?\u0013\r\ty\b\b\u0002\u0005\u0019>tw\rC\u0004\u0002\u00046\u0001\r!!\"\u0002\u0017M$\u0018\r^5p]\u000e{G-\u001a\t\u0005\u0003\u000f\u000byI\u0004\u0003\u0002\n\u0006-\u0005cAA-9%\u0019\u0011Q\u0012\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t*a%\u0003\rM#(/\u001b8h\u0015\r\ti\t\b\u0005\b\u0003/k\u0001\u0019AA*\u0003A\u0001(/\u001a<j_V\u001cX*Z1tkJ,7\u000fC\u0004\u0002\u001c6\u0001\r!!\"\u0002\u0007U\u0014H\u000eC\u0004\u0002 6\u0001\r!!\"\u0002\u001bM$\u0018M\u001d;ECR,\u0007+\u0019:u\u000319W\r^!eKN\u001cu\u000eZ3t)\u0019\t)+a.\u0002HR!\u0011qUA[!\u0019\t)&!\u001a\u0002*B!\u00111VAY\u001b\t\tiK\u0003\u0003\u0002r\u0005=&\"\u0001)\n\t\u0005M\u0016Q\u0016\u0002\u0004\u0005N\u001c\bbBA=\u001d\u0001\u000f\u00111\u0010\u0005\b\u0003ss\u0001\u0019AA^\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003$\u0012A\u00023p[\u0006Lg.\u0003\u0003\u0002F\u0006}&a\u0005%vE\u0016\fW/U;bY&$\u0018PR5mi\u0016\u0014\bbBAe\u001d\u0001\u0007\u00111Z\u0001\rcV\fG.\u001b;p\u0007>$Wm\u001d\t\u0007\u0003+\n)'!4\u0011\t\u0005=\u00171[\u0007\u0003\u0003#T1!!\u001d:\u0013\u0011\t).!5\u0003!E+\u0018\r\\5u_6,G/\u001a:D_\u0012,\u0017\u0001H4fi\u0012+\u0007/\u0019:u[\u0016tGoQ8eKN4%o\\7Ik\n,\u0017-\u001e\u000b\u0007\u00037\fy.a9\u0015\t\u0005\u001d\u0016Q\u001c\u0005\b\u0003sz\u00019AA>\u0011\u001d\t\to\u0004a\u0001\u0003O\u000bA\u0001Z1uC\"9\u00111T\bA\u0002\u0005\u0015\u0015\u0001\u00059s_\u000e,7o\u001d+p\u0003\u0012,7OQ:t)\u0011\tI/!<\u0015\t\u0005\u001d\u00161\u001e\u0005\b\u0003s\u0002\u00029AA>\u0011\u001d\ty\u000f\u0005a\u0001\u0003c\fQaY8eKN\u0004b!!\u0016\u0002f\u0005\u0015\u0005")
public class HubeauQualityController {
    private final LogUtil LogUtil;
    private final JobLogUtil JobLogUtil;
    private final QualitometerDao qualitometerDao;
    private final StationNetworkDao StationNetworkDao;
    private final OperationDao operationDao;
    private final SupportDao SupportDao;
    private final GenericImportDao genericImportDao;
    private final ContributorsDao contributorDao;
    private final WSClient ws;

    public void executeHubeauQualityImport(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            Predef$.MODULE$.print(error);
            $this.LogUtil.error(new StringBuilder(60).append("Error validate Json to execute Hubeau quality integration :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.LogUtil.error$default$2());
            return "";
        }, (Function1 & Serializable)jobParameters -> {
            HubeauQualityController.$anonfun$executeHubeauQualityImport$2(this, jobParameters);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<HubeauQualityAnalysis> getDataFromHubeau(String stationCode, Seq<HubeauQualityAnalysis> previousMeasures, String url, String startDatePart, long jobExecutionId) {
        String usedUrl = new StringBuilder(0).append(url).append(startDatePart).toString();
        Option<HubeauQualityResult> promise = WSUtil$.MODULE$.simpleGet(usedUrl, WSUtil$.MODULE$.simpleGet$default$2(), WSUtil$.MODULE$.simpleGet$default$3(), HubeauQualityResult$.MODULE$.format(), this.ws);
        Option<HubeauQualityResult> option = promise;
        if (None$.MODULE$.equals(option)) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(40).append("Error calling hubeau with stationCode : ").append(stationCode).toString(), stationCode, this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(13).append("Failed url : ").append(usedUrl).toString(), stationCode, this.JobLogUtil.log$default$5());
            return (Seq)Nil$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            HubeauQualityResult result = (HubeauQualityResult)some.value();
            Option<String> option2 = result.next();
            if (option2 instanceof Some) {
                String lastDate = ((HubeauQualityAnalysis)result.data().last()).date_debut_prelevement();
                String newStartDate = new StringBuilder(24).append("&date_debut_prelevement=").append(lastDate).toString();
                Seq newData = (Seq)result.data().filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)HubeauQualityController.$anonfun$getDataFromHubeau$1(lastDate, d)));
                return this.getDataFromHubeau(stationCode, (Seq<HubeauQualityAnalysis>)((Seq)previousMeasures.$plus$plus((IterableOnce)newData)), url, newStartDate, jobExecutionId);
            }
            if (None$.MODULE$.equals(option2)) {
                return (Seq)previousMeasures.$plus$plus(result.data());
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public Seq<Bss> getAdesCodes(HubeauQualityFilter filters, Seq<QualitometerCode> qualitoCodes, long jobExecutionId) {
        Seq seq;
        block4: {
            String string = filters.selectStationsMode();
            switch (string == null ? 0 : string.hashCode()) {
                case -1109706007: {
                    if (!"codesMode".equals(string)) break;
                    Seq stringCodes = (Seq)filters.stationCodes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    seq = this.processToAdesBss((Seq<String>)stringCodes, jobExecutionId);
                    break block4;
                }
                case -872620994: {
                    Seq results;
                    if (!"filtersMode".equals(string)) break;
                    Seq departmentCodes = (Seq)filters.departmentCodes().map((Function1 & Serializable)codes -> (Seq)ArrayOps$.MODULE$.grouped$extension(Predef$.MODULE$.refArrayOps((Object[])codes.split(",")), 50).toSeq().flatMap((Function1 & Serializable)codesGroup -> this.getDepartmentCodesFromHubeau((Seq<Bss>)((Seq)Nil$.MODULE$), new StringBuilder(123).append("https://hubeau.eaufrance.fr/api/v1/qualite_nappes/stations?num_departement=").append(Predef$.MODULE$.wrapRefArray((Object[])codesGroup).mkString("%2C")).append("&fields=bss_id%2Ccode_bss&format=json&size=20000").toString(), jobExecutionId))).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    Seq networkCodes = (Seq)filters.network().map((Function1 & Serializable)networkId -> HubeauQualityController.$anonfun$getAdesCodes$5(this, qualitoCodes, jobExecutionId, BoxesRunTime.unboxToInt((Object)networkId))).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    seq = results = (Seq)departmentCodes.$plus$plus((IterableOnce)networkCodes);
                    break block4;
                }
            }
            throw new MatchError((Object)string);
        }
        Seq codesWithoutId = seq;
        return (Seq)codesWithoutId.map((Function1 & Serializable)adesCode -> {
            Option option = qualitoCodes.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HubeauQualityController.$anonfun$getAdesCodes$11(adesCode, p)));
            if (option instanceof Some) {
                Some some = (Some)option;
                QualitometerCode piezoFound = (QualitometerCode)some.value();
                Some x$1 = new Some((Object)BoxesRunTime.boxToDouble((double)piezoFound.id()));
                Some x$2 = new Some((Object)piezoFound.code());
                String x$3 = adesCode.copy$default$1();
                Option<String> x$4 = adesCode.copy$default$2();
                Option<String> x$5 = adesCode.copy$default$3();
                return adesCode.copy(x$3, x$4, x$5, (Option<Object>)x$1, (Option<String>)x$2);
            }
            if (None$.MODULE$.equals(option)) {
                return adesCode;
            }
            throw new MatchError((Object)option);
        });
    }

    public Seq<Bss> getDepartmentCodesFromHubeau(Seq<Bss> data, String url, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(31).append("Calling hubeau with this url : ").append(url).toString(), "", this.JobLogUtil.log$default$5());
        Option<HubeauCodesResult> option = WSUtil$.MODULE$.simpleGet(url, WSUtil$.MODULE$.simpleGet$default$2(), WSUtil$.MODULE$.simpleGet$default$3(), HubeauCodesResult$.MODULE$.format(), this.ws);
        if (None$.MODULE$.equals(option)) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error while getting codes from department via hubeau", "", this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(37).append("Error calling hubeau with this url : ").append(url).toString(), "", this.JobLogUtil.log$default$5());
            return (Seq)Nil$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            HubeauCodesResult result = (HubeauCodesResult)some.value();
            Option<String> option2 = result.next();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String nextUrl = (String)some2.value();
                return this.getDepartmentCodesFromHubeau((Seq<Bss>)((Seq)data.$plus$plus((IterableOnce)result.data().map((Function1 & Serializable)d -> new Bss((String)d.bss_id().getOrElse((Function0 & Serializable)() -> d.code_bss()), (Option<String>)new Some((Object)d.code_bss()), d.bss_id(), (Option<Object>)None$.MODULE$, Bss$.MODULE$.$lessinit$greater$default$5())))), nextUrl, jobExecutionId);
            }
            return (Seq)data.$plus$plus((IterableOnce)result.data().map((Function1 & Serializable)d -> new Bss((String)d.bss_id().getOrElse((Function0 & Serializable)() -> d.code_bss()), (Option<String>)new Some((Object)d.code_bss().split("/")[0].toUpperCase()), (Option<String>)d.bss_id().map((Function1 & Serializable)x$3 -> x$3.split("/")[0].toUpperCase()), (Option<Object>)None$.MODULE$, Bss$.MODULE$.$lessinit$greater$default$5())));
        }
        throw new MatchError(option);
    }

    public Seq<Bss> processToAdesBss(Seq<String> codes, long jobExecutionId) {
        Tuple2 tuple2 = codes.partition((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)HubeauQualityController.$anonfun$processToAdesBss$1(c)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq newCodes = (Seq)tuple2._1();
        Seq oldCodes = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)newCodes, (Object)oldCodes);
        Seq newCodes2 = (Seq)tuple22._1();
        Seq oldCodes2 = (Seq)tuple22._2();
        return (Seq)((IterableOps)newCodes2.grouped(200).toSeq().flatMap((Function1 & Serializable)groupCodes -> {
            String url = new StringBuilder(114).append("https://hubeau.eaufrance.fr/api/v1/qualite_nappes/stations?bss_id=").append(groupCodes.mkString("%2C%20")).append("&fields=bss_id%2Ccode_bss&format=json&size=20000").toString();
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(31).append("Calling hubeau with this url : ").append(url).toString(), "", $this.JobLogUtil.log$default$5());
            Option<HubeauCodesResult> option = WSUtil$.MODULE$.simpleGet(url, WSUtil$.MODULE$.simpleGet$default$2(), WSUtil$.MODULE$.simpleGet$default$3(), HubeauCodesResult$.MODULE$.format(), $this.ws);
            if (None$.MODULE$.equals(option)) {
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error while getting old codes from new codes via hubeau", "", $this.JobLogUtil.log$default$5());
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(37).append("Error calling hubeau with this url : ").append(url).toString(), "", $this.JobLogUtil.log$default$5());
                return (Seq)Nil$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                HubeauCodesResult result = (HubeauCodesResult)some.value();
                return (Seq)result.data().map((Function1 & Serializable)d -> new Bss((String)d.bss_id().getOrElse((Function0 & Serializable)() -> d.code_bss()), (Option<String>)new Some((Object)d.code_bss()), (Option<String>)d.bss_id().map((Function1 & Serializable)x$5 -> x$5.split("/")[0].toUpperCase()), (Option<Object>)None$.MODULE$, Bss$.MODULE$.$lessinit$greater$default$5()));
            }
            throw new MatchError(option);
        })).$plus$plus((IterableOnce)oldCodes2.map((Function1 & Serializable)c -> new Bss((String)c, (Option<String>)new Some(c), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, Bss$.MODULE$.$lessinit$greater$default$5())));
    }

    public static final /* synthetic */ void $anonfun$executeHubeauQualityImport$13(Map fractionSupportMap$1, DateTimeFormatter dtf$1, ImportQualityDefaultValueFind defaultValue$1, long jobExecutionId$1, Bss bss$1, Option campaign$1, ObjectRef ListCompleteOperations$1, Seq sampleAnalysis) {
        None$ x$56;
        HubeauQualityAnalysis first = (HubeauQualityAnalysis)sampleAnalysis.head();
        Some support = new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)fractionSupportMap$1.getOrElse((Object)Integer.toString(first.code_fraction()), (Function0 & Serializable)() -> "0")))));
        DateTime date = dtf$1.parseDateTime(first.date_debut_prelevement());
        Seq listanalyse = (Seq)sampleAnalysis.map((Function1 & Serializable)a -> {
            Some x$13;
            double x$1 = 0.0;
            long x$2 = 0L;
            double x$3 = 0.0;
            double x$4 = 0.0;
            Some x$5 = new Some((Object)date);
            Some x$6 = new Some((Object)Integer.toString(a.code_param()));
            Option<String> x$7 = a.code_unite();
            Option<Object> x$8 = a.resultat();
            None$ x$9 = a.code_remarque_analyse().isDefined() ? new Some((Object)a.code_remarque_analyse().get().toString()) : None$.MODULE$;
            None$ x$10 = a.code_lieu_analyse().isDefined() ? new Some((Object)a.code_lieu_analyse().get().toString()) : None$.MODULE$;
            Option<Object> x$11 = a.limite_quantification();
            Option<Object> x$12 = a.limite_detection();
            Object object = a.code_qualification().isDefined() ? new Some((Object)((String)a.code_qualification().get()).toString()) : (x$13 = defaultValue$1.qualification().isDefined() ? new Some((Object)defaultValue$1.qualification().get().toString()) : None$.MODULE$);
            Some x$14 = a.code_statut_analyse().isDefined() ? new Some((Object)((String)a.code_statut_analyse().get()).toString()) : (defaultValue$1.status().isDefined() ? new Some((Object)defaultValue$1.status().get().toString()) : None$.MODULE$);
            Some x$15 = new Some((Object)Integer.toString(a.code_fraction()));
            Option<Object> x$16 = a.code_methode();
            None$ x$17 = defaultValue$1.labo().isDefined() ? new Some((Object)((String)defaultValue$1.labo().get()).toString()) : None$.MODULE$;
            Some x$18 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$1));
            Option x$19 = AnalysisImport$.MODULE$.$lessinit$greater$default$5();
            Option x$20 = AnalysisImport$.MODULE$.$lessinit$greater$default$8();
            Option x$21 = AnalysisImport$.MODULE$.$lessinit$greater$default$10();
            Option x$22 = AnalysisImport$.MODULE$.$lessinit$greater$default$11();
            Option x$23 = AnalysisImport$.MODULE$.$lessinit$greater$default$17();
            Option x$24 = AnalysisImport$.MODULE$.$lessinit$greater$default$21();
            Option x$25 = AnalysisImport$.MODULE$.$lessinit$greater$default$23();
            Option x$26 = AnalysisImport$.MODULE$.$lessinit$greater$default$24();
            Option x$27 = AnalysisImport$.MODULE$.$lessinit$greater$default$25();
            Option x$28 = AnalysisImport$.MODULE$.$lessinit$greater$default$27();
            Option x$29 = AnalysisImport$.MODULE$.$lessinit$greater$default$28();
            Option x$30 = AnalysisImport$.MODULE$.$lessinit$greater$default$29();
            Option x$31 = AnalysisImport$.MODULE$.$lessinit$greater$default$30();
            Option x$32 = AnalysisImport$.MODULE$.$lessinit$greater$default$31();
            Option x$33 = AnalysisImport$.MODULE$.$lessinit$greater$default$32();
            Option x$34 = AnalysisImport$.MODULE$.$lessinit$greater$default$33();
            Option x$35 = AnalysisImport$.MODULE$.$lessinit$greater$default$34();
            Option x$36 = AnalysisImport$.MODULE$.$lessinit$greater$default$35();
            Option x$37 = AnalysisImport$.MODULE$.$lessinit$greater$default$36();
            Option x$38 = AnalysisImport$.MODULE$.$lessinit$greater$default$37();
            Option x$39 = AnalysisImport$.MODULE$.$lessinit$greater$default$38();
            Option x$40 = AnalysisImport$.MODULE$.$lessinit$greater$default$39();
            Option x$41 = AnalysisImport$.MODULE$.$lessinit$greater$default$40();
            Option x$42 = AnalysisImport$.MODULE$.$lessinit$greater$default$41();
            Option x$43 = AnalysisImport$.MODULE$.$lessinit$greater$default$42();
            Option x$44 = AnalysisImport$.MODULE$.$lessinit$greater$default$43();
            Option x$45 = AnalysisImport$.MODULE$.$lessinit$greater$default$44();
            Option x$46 = AnalysisImport$.MODULE$.$lessinit$greater$default$45();
            Option x$47 = AnalysisImport$.MODULE$.$lessinit$greater$default$46();
            Option x$48 = AnalysisImport$.MODULE$.$lessinit$greater$default$47();
            Option x$49 = AnalysisImport$.MODULE$.$lessinit$greater$default$49();
            Option x$50 = AnalysisImport$.MODULE$.$lessinit$greater$default$50();
            Option x$51 = AnalysisImport$.MODULE$.$lessinit$greater$default$51();
            return new AnalysisImport(0.0, 0L, 0.0, 0.0, x$19, (Option)x$5, (Option)x$6, x$20, x$7, x$21, x$22, x$8, (Option)x$9, (Option)x$10, x$11, x$12, x$23, (Option)x$13, (Option)x$14, (Option)x$15, x$24, x$16, x$25, x$26, x$27, (Option)x$17, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, (Option)x$18, x$49, x$50, x$51);
        });
        double x$52 = BoxesRunTime.unboxToDouble((Object)bss$1.id().get());
        double x$53 = 0.0;
        DateTime x$54 = date;
        Some x$55 = new Some((Object)first.code_producteur());
        Object object = x$56 = defaultValue$1.sampler().isDefined() ? new Some((Object)((String)defaultValue$1.sampler().get()).toString()) : None$.MODULE$;
        None$ x$57 = support.isDefined() && BoxesRunTime.unboxToInt((Object)support.get()) != 0 ? new Some((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToInt((Object)support.get()))) : (defaultValue$1.support().isDefined() ? new Some((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToInt((Object)defaultValue$1.support().get()))) : None$.MODULE$);
        Option<Object> x$58 = first.code_methode();
        Option x$59 = campaign$1;
        Some x$60 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$1));
        None$ x$61 = None$.MODULE$;
        Option x$62 = OperationImport$.MODULE$.$lessinit$greater$default$4();
        Option x$63 = OperationImport$.MODULE$.$lessinit$greater$default$5();
        Option x$64 = OperationImport$.MODULE$.$lessinit$greater$default$6();
        Option x$65 = OperationImport$.MODULE$.$lessinit$greater$default$7();
        Option x$66 = OperationImport$.MODULE$.$lessinit$greater$default$8();
        Option x$67 = OperationImport$.MODULE$.$lessinit$greater$default$9();
        Option x$68 = OperationImport$.MODULE$.$lessinit$greater$default$10();
        Option x$69 = OperationImport$.MODULE$.$lessinit$greater$default$11();
        Option x$70 = OperationImport$.MODULE$.$lessinit$greater$default$12();
        Option x$71 = OperationImport$.MODULE$.$lessinit$greater$default$13();
        Option x$72 = OperationImport$.MODULE$.$lessinit$greater$default$15();
        Option x$73 = OperationImport$.MODULE$.$lessinit$greater$default$16();
        Option x$74 = OperationImport$.MODULE$.$lessinit$greater$default$17();
        Option x$75 = OperationImport$.MODULE$.$lessinit$greater$default$18();
        Option x$76 = OperationImport$.MODULE$.$lessinit$greater$default$20();
        Option x$77 = OperationImport$.MODULE$.$lessinit$greater$default$21();
        Option x$78 = OperationImport$.MODULE$.$lessinit$greater$default$23();
        Option x$79 = OperationImport$.MODULE$.$lessinit$greater$default$26();
        Option x$80 = OperationImport$.MODULE$.$lessinit$greater$default$27();
        Option x$81 = OperationImport$.MODULE$.$lessinit$greater$default$28();
        Option x$82 = OperationImport$.MODULE$.$lessinit$greater$default$29();
        Option x$83 = OperationImport$.MODULE$.$lessinit$greater$default$30();
        Option x$84 = OperationImport$.MODULE$.$lessinit$greater$default$31();
        Option x$85 = OperationImport$.MODULE$.$lessinit$greater$default$32();
        Option x$86 = OperationImport$.MODULE$.$lessinit$greater$default$33();
        Option x$87 = OperationImport$.MODULE$.$lessinit$greater$default$34();
        Option x$88 = OperationImport$.MODULE$.$lessinit$greater$default$35();
        Option x$89 = OperationImport$.MODULE$.$lessinit$greater$default$36();
        Option x$90 = OperationImport$.MODULE$.$lessinit$greater$default$37();
        Option x$91 = OperationImport$.MODULE$.$lessinit$greater$default$38();
        Option x$92 = OperationImport$.MODULE$.$lessinit$greater$default$39();
        Option x$93 = OperationImport$.MODULE$.$lessinit$greater$default$40();
        Option x$94 = OperationImport$.MODULE$.$lessinit$greater$default$42();
        Option x$95 = OperationImport$.MODULE$.$lessinit$greater$default$43();
        Option x$96 = OperationImport$.MODULE$.$lessinit$greater$default$44();
        Option x$97 = OperationImport$.MODULE$.$lessinit$greater$default$46();
        Option x$98 = OperationImport$.MODULE$.$lessinit$greater$default$47();
        OperationImport Ope = new OperationImport(x$52, 0.0, x$54, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, (Option)x$61, x$72, x$73, x$74, x$75, (Option)x$55, x$76, x$77, (Option)x$56, x$78, (Option)x$57, x$58, x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, (Option)x$60, x$94, x$95, x$96, x$59, x$97, x$98);
        double x$99 = 0.0;
        double x$100 = BoxesRunTime.unboxToDouble((Object)bss$1.id().get());
        DateTime x$101 = date;
        Some x$102 = new Some((Object)first.code_producteur());
        None$ x$103 = defaultValue$1.labo().isDefined() ? new Some((Object)((String)defaultValue$1.labo().get()).toString()) : None$.MODULE$;
        Option x$104 = SampleImport$.MODULE$.$lessinit$greater$default$4();
        Option x$105 = SampleImport$.MODULE$.$lessinit$greater$default$5();
        Option x$106 = SampleImport$.MODULE$.$lessinit$greater$default$6();
        Option x$107 = SampleImport$.MODULE$.$lessinit$greater$default$8();
        Option x$108 = SampleImport$.MODULE$.$lessinit$greater$default$9();
        Option x$109 = SampleImport$.MODULE$.$lessinit$greater$default$10();
        Option x$110 = SampleImport$.MODULE$.$lessinit$greater$default$11();
        Option x$111 = SampleImport$.MODULE$.$lessinit$greater$default$13();
        Option x$112 = SampleImport$.MODULE$.$lessinit$greater$default$14();
        Option x$113 = SampleImport$.MODULE$.$lessinit$greater$default$15();
        Option x$114 = SampleImport$.MODULE$.$lessinit$greater$default$16();
        Option x$115 = SampleImport$.MODULE$.$lessinit$greater$default$17();
        Option x$116 = SampleImport$.MODULE$.$lessinit$greater$default$18();
        Option x$117 = SampleImport$.MODULE$.$lessinit$greater$default$19();
        Option x$118 = SampleImport$.MODULE$.$lessinit$greater$default$20();
        Option x$119 = SampleImport$.MODULE$.$lessinit$greater$default$21();
        Option x$120 = SampleImport$.MODULE$.$lessinit$greater$default$22();
        Option x$121 = SampleImport$.MODULE$.$lessinit$greater$default$23();
        Option x$122 = SampleImport$.MODULE$.$lessinit$greater$default$24();
        Option x$123 = SampleImport$.MODULE$.$lessinit$greater$default$25();
        Option x$124 = SampleImport$.MODULE$.$lessinit$greater$default$26();
        Option x$125 = SampleImport$.MODULE$.$lessinit$greater$default$27();
        Option x$126 = SampleImport$.MODULE$.$lessinit$greater$default$28();
        SampleImport sample = new SampleImport(0.0, x$100, x$101, x$104, x$105, x$106, (Option)x$102, x$107, x$108, x$109, x$110, (Option)x$103, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126);
        OperationImport x$127 = Ope;
        Some x$128 = new Some((Object)sample);
        Seq x$129 = listanalyse;
        None$ x$130 = None$.MODULE$;
        Option<QualitometerPoint> x$131 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$4();
        Option<Seq<Sampling>> x$132 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$6();
        Option<Seq<Indice>> x$133 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$7();
        Option<Seq<String>> x$134 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$8();
        Option<Object> x$135 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$9();
        Option<Seq<QualityRecovery>> x$136 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$10();
        Option<Seq<MicroSampling>> x$137 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$11();
        Option<Seq<QualitometerOperationList>> x$138 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$12();
        ListCompleteOperations$1.elem = (Seq)((Seq)ListCompleteOperations$1.elem).$plus$plus((IterableOnce)new .colon.colon((Object)new CompleteOperationImport(x$127, (Option<SampleImport>)x$128, (Seq<AnalysisImport>)x$129, x$131, (Option<Seq<EnvironnementalMeasure>>)x$130, x$132, x$133, x$134, x$135, x$136, x$137, x$138), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$executeHubeauQualityImport$2(HubeauQualityController $this, JobParameters jobParameters) {
        long jobExecutionId = jobParameters.jobExecutionId();
        HubeauQualityFilter filters = (HubeauQualityFilter)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new HubeauQualityFilter(HubeauQualityFilter$.MODULE$.$lessinit$greater$default$1(), HubeauQualityFilter$.MODULE$.$lessinit$greater$default$2(), HubeauQualityFilter$.MODULE$.$lessinit$greater$default$3(), HubeauQualityFilter$.MODULE$.$lessinit$greater$default$4(), HubeauQualityFilter$.MODULE$.$lessinit$greater$default$5(), HubeauQualityFilter$.MODULE$.$lessinit$greater$default$6(), HubeauQualityFilter$.MODULE$.$lessinit$greater$default$7(), HubeauQualityFilter$.MODULE$.$lessinit$greater$default$8(), HubeauQualityFilter$.MODULE$.$lessinit$greater$default$9(), HubeauQualityFilter$.MODULE$.$lessinit$greater$default$10()), false, HubeauQualityFilter$.MODULE$.format());
        ImportQualityDefaultValue olDefaultValue = (ImportQualityDefaultValue)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new ImportQualityDefaultValue(ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$1(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$2(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$3(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$4(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$5(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$6(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$7(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$8(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$9(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$10(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$11(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$12()), false, ImportQualityDefaultValue$.MODULE$.jsonReads());
        ImportQualityDefaultValueFind defaultValue = ContributorUtil$.MODULE$.getDefaultValue(olDefaultValue, $this.LogUtil, $this.contributorDao);
        Seq qualitometers = (Seq)$this.qualitometerDao.getAllCodes().$plus$plus((IterableOnce)$this.qualitometerDao.getAllOldOrNewBssCodes());
        Option<Object> campaign = filters.campaignId();
        Seq<Bss> codesFound = $this.getAdesCodes(filters, (Seq<QualitometerCode>)qualitometers, jobExecutionId);
        String parameters = (String)filters.parameterCodes().map((Function1 & Serializable)codes -> {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(codes))) {
                return new StringBuilder(12).append("&code_param=").append(codes.replace(",", "%2C")).toString();
            }
            return "";
        }).getOrElse((Function0 & Serializable)() -> "");
        Map fractionSupportMap = $this.SupportDao.getFractionSupportMap();
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"YYYY-MM-dd");
        Option importMode = ((IterableOnceOps)jobParameters.dataTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains(ImportMode$.MODULE$.DATA())));
        boolean purgeAll = importMode.isDefined() && ((String)importMode.get()).equalsIgnoreCase("DATA_REPLACE_HISTO");
        Option user = jobParameters.user();
        codesFound.foreach((Function1 & Serializable)bss -> {
            String stationCode = bss.wantedCode().split("/")[0].toUpperCase();
            if (bss.id().isEmpty()) {
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(31).append("Bss code ").append(stationCode).append(" not found on database").toString(), stationCode, $this.JobLogUtil.log$default$5());
                return BoxedUnit.UNIT;
            }
            None$ startDate = importMode.isDefined() && ((String)importMode.get()).equalsIgnoreCase("DATA_ADD_LAST_DATA") ? $this.operationDao.getLastDate(BoxesRunTime.unboxToDouble((Object)bss.id().get()), campaign).map((Function1 & Serializable)d -> d.plusDays(1)) : None$.MODULE$;
            String startDateStr = (String)startDate.map((Function1 & Serializable)d -> new StringBuilder(24).append("&date_debut_prelevement=").append(d.toString("YYYY-MM-dd")).toString()).getOrElse((Function0 & Serializable)() -> "");
            String url = new StringBuilder(372).append("https://hubeau.eaufrance.fr/api/v1/qualite_nappes/analyses?bss_id=").append(((String)bss.newCode().getOrElse((Function0 & Serializable)() -> (String)bss.oldCode().get())).replace("/", "%2F")).append(parameters).append("&fields=longitude%2Clatitude%2Ccode_producteur%2Cnom_producteur%2Cdate_debut_prelevement%2Ccode_param%2Ccode_fraction%2Cresultat%2Ccode_remarque_analyse%2Ccode_lieu_analyse%2Ccode_methode%2Ccode_unite%2Ccode_statut_analyse%2Ccode_qualification%2Climite_quantification%2Climite_detection&size=20000&sort=asc").toString();
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(12).append("Call Hubeau ").append(url).toString(), stationCode, $this.JobLogUtil.log$default$5());
            Seq<HubeauQualityAnalysis> hubeauData = $this.getDataFromHubeau(stationCode, (Seq<HubeauQualityAnalysis>)((Seq)Nil$.MODULE$), url, startDateStr, jobExecutionId);
            if (hubeauData.isEmpty()) {
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No analysis found.", stationCode, $this.JobLogUtil.log$default$5());
                return BoxedUnit.UNIT;
            }
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(55).append(hubeauData.length()).append(" analysis fetched. Begin integration for station id ").append((int)BoxesRunTime.unboxToDouble((Object)bss.id().get())).append("...").toString(), stationCode, $this.JobLogUtil.log$default$5());
            Map sampleGroups = hubeauData.groupBy((Function1 & Serializable)analysis -> new StringBuilder(1).append(analysis.code_producteur()).append(":").append(analysis.date_debut_prelevement()).toString());
            ObjectRef ListCompleteOperations = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
            sampleGroups.values().map((Function1 & Serializable)sampleAnalysis -> {
                HubeauQualityController.$anonfun$executeHubeauQualityImport$13(fractionSupportMap, dtf, defaultValue, jobExecutionId, bss, campaign, ListCompleteOperations, sampleAnalysis);
                return BoxedUnit.UNIT;
            });
            Option<Seq<Object>> x$139 = filters.excludedProducers();
            Option x$140 = importMode;
            None$ x$141 = filters.campaignId().isDefined() ? new Some((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToDouble((Object)filters.campaignId().get())))) : None$.MODULE$;
            Option<Object> x$142 = ImportOptions$.MODULE$.apply$default$1();
            Option<Object> x$143 = ImportOptions$.MODULE$.apply$default$3();
            Option<String> x$144 = ImportOptions$.MODULE$.apply$default$4();
            Option<Object> x$145 = ImportOptions$.MODULE$.apply$default$7();
            return BoxesRunTime.boxToInteger((int)$this.genericImportDao.importQuality(Integer.toString((int)BoxesRunTime.unboxToDouble((Object)bss.id().get())), bss.wantedCode(), jobExecutionId, (Seq<CompleteOperationImport>)((Seq)ListCompleteOperations.elem), (String)user.get(), (Option<ImportOptions>)new Some((Object)new ImportOptions(x$142, (Option<String>)x$140, x$143, x$144, (Option<Object>)x$141, x$139, x$145))));
        });
    }

    public static final /* synthetic */ boolean $anonfun$getDataFromHubeau$1(String lastDate$1, HubeauQualityAnalysis d) {
        String string = d.date_debut_prelevement();
        String string2 = lastDate$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$getAdesCodes$7(StationNetwork nl$1, QualitometerCode p) {
        return (int)p.id() == nl$1.idStation();
    }

    public static final /* synthetic */ Seq $anonfun$getAdesCodes$5(HubeauQualityController $this, Seq qualitoCodes$1, long jobExecutionId$2, int networkId) {
        Seq networkStations = $this.StationNetworkDao.getStations(StationTypeUtil$.MODULE$.QUALITY(), networkId);
        return $this.processToAdesBss((Seq<String>)((Seq)networkStations.flatMap((Function1 & Serializable)nl -> qualitoCodes$1.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HubeauQualityController.$anonfun$getAdesCodes$7(nl, p))).map((Function1 & Serializable)p -> p.code()))), jobExecutionId$2);
    }

    public static final /* synthetic */ boolean $anonfun$getAdesCodes$11(Bss adesCode$1, QualitometerCode p) {
        return adesCode$1.oldCode().map((Function1 & Serializable)x$2 -> x$2.split("/")[0]).contains((Object)p.code()) || adesCode$1.newCode().contains((Object)p.code());
    }

    public static final /* synthetic */ boolean $anonfun$processToAdesBss$1(String c) {
        return c.toUpperCase().startsWith("BSS");
    }

    @Inject
    public HubeauQualityController(LogUtil LogUtil2, JobLogUtil JobLogUtil2, QualitometerDao qualitometerDao, StationNetworkDao StationNetworkDao2, OperationDao operationDao, SupportDao SupportDao2, GenericImportDao genericImportDao, ContributorsDao contributorDao, SurfaceQualitometerController SurfaceQualitometerController2, WSClient ws) {
        this.LogUtil = LogUtil2;
        this.JobLogUtil = JobLogUtil2;
        this.qualitometerDao = qualitometerDao;
        this.StationNetworkDao = StationNetworkDao2;
        this.operationDao = operationDao;
        this.SupportDao = SupportDao2;
        this.genericImportDao = genericImportDao;
        this.contributorDao = contributorDao;
        this.ws = ws;
    }
}

