/*
 * Decompiled with CFR 0.152.
 */
package Quality.surfaceQualitometer.controller;

import Quality.GenericFilter;
import Quality.GenericFilter$;
import Quality.ades.dao.OperationDao;
import Quality.ades.model.Operation;
import Quality.surfaceQualitometer.SurfaceQualitometerFilter;
import Quality.surfaceQualitometer.SurfaceQualitometerFilter$;
import Quality.surfaceQualitometer.dao.Aqua6boSurfaceQualitometerDao;
import Quality.surfaceQualitometer.domain.callSandre.SurfaceQualitometerSandre;
import Quality.surfaceQualitometer.domain.callSandre.SurfaceQualitometerSandre$;
import Quality.surfaceQualitometer.domain.input.SurfaceQualitometerOperationInput;
import Quality.surfaceQualitometer.domain.input.SurfaceQualitometerStationInput;
import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constant.ImportMode$;
import constant.IntegrationType$;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.quality.chronicAnalysis.AnalysisImport;
import fr.aquasys.daeau.quality.chronicAnalysis.AnalysisImport$;
import fr.aquasys.daeau.quality.domain.QualitometerLinks;
import fr.aquasys.daeau.quality.domain.QualitometerLinks$;
import fr.aquasys.daeau.quality.domain.QualitometerWithLinks;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.model.EnvironnementalMeasure;
import fr.aquasys.daeau.quality.model.EnvironnementalMeasure$;
import fr.aquasys.daeau.quality.model.Indice;
import fr.aquasys.daeau.quality.model.Qualitometer;
import fr.aquasys.daeau.quality.model.QualitometerOperationList;
import fr.aquasys.daeau.quality.model.QualitometerPoint;
import fr.aquasys.daeau.quality.operation.OperationImport;
import fr.aquasys.daeau.quality.operation.OperationImport$;
import fr.aquasys.daeau.quality.sample.SampleImport;
import fr.aquasys.daeau.quality.sample.SampleImport$;
import fr.aquasys.daeau.quality.sampling.Sampling;
import fr.aquasys.daeau.referentials.city.itf.CityDao;
import fr.aquasys.daeau.referentials.city.model.City;
import fr.aquasys.daeau.referentials.city.model.City$;
import fr.aquasys.daeau.referentials.watermass.domain.WatermassInput;
import fr.aquasys.daeau.referentials.watermass.itf.WatermassDao;
import fr.aquasys.daeau.referentials.watershed.itf.WatershedDao;
import fr.aquasys.daeau.referentials.watershed.model.Watershed;
import fr.aquasys.daeau.referentials.watershed.model.Watershed$;
import fr.aquasys.daeau.station.links.watermass.StationWatermass;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import genericImport.itf.GenericImportDao;
import genericImport.model.CompleteOperationImport;
import genericImport.model.CompleteOperationImport$;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import genericImport.model.MicroSampling;
import genericImport.model.QualityRecovery;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import model.ImportQualityDefaultValue;
import model.ImportQualityDefaultValue$;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import play.api.db.Database;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.parallel.CollectionConverters;
import scala.collection.parallel.CollectionConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import util.JobParametersUtil$;
import util.WSUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\tMg\u0001B\u000e\u001d\u0001\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006Y!\r\u0005\tw\u0001\u0011\t\u0011)A\u0006y!A\u0001\n\u0001B\u0001B\u0003-\u0011\n\u0003\u0005P\u0001\t\u0005\t\u0015a\u0003Q\u0011!9\u0006A!A!\u0002\u0017A\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b1B3\t\u0011-\u0004!\u0011!Q\u0001\f1D\u0001b\u001d\u0001\u0003\u0002\u0003\u0006Y\u0001\u001e\u0005\tw\u0002\u0011\t\u0011)A\u0006y\"Q\u0011q\u0001\u0001\u0003\u0002\u0003\u0006Y!!\u0003\t\u0015\u0005]\u0001A!A!\u0002\u0017\tI\u0002C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003c\u0003A\u0011AAZ\u0011\u001d\t9\f\u0001C\u0001\u0003sCq!!3\u0001\t\u0003\tY\rC\u0005\u0002j\u0002\t\n\u0011\"\u0001\u0002l\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001\"\u0003B\n\u0001E\u0005I\u0011\u0001B\u000b\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057A\u0011Ba\u000e\u0001#\u0003%\tA!\u000f\t\u000f\tu\u0002\u0001\"\u0001\u0003@!9!Q\r\u0001\u0005\n\t\u001d\u0004b\u0002BP\u0001\u0011%!\u0011\u0015\u0002\u001e'V\u0014h-Y2f#V\fG.\u001b;p[\u0016$XM]\"p]R\u0014x\u000e\u001c7fe*\u0011QDH\u0001\u000bG>tGO]8mY\u0016\u0014(BA\u0010!\u0003M\u0019XO\u001d4bG\u0016\fV/\u00197ji>lW\r^3s\u0015\u0005\t\u0013aB)vC2LG/_\u0002\u0001'\r\u0001AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\n1!\u00199j\u0013\tyCFA\u0003N_\u0012,G.\u0001\u0002xgB\u0011!'O\u0007\u0002g)\u0011\u0001\u0007\u000e\u0006\u0003kY\nA\u0001\\5cg*\u0011Qf\u000e\u0006\u0002q\u0005!\u0001\u000f\\1z\u0013\tQ4G\u0001\u0005X'\u000ec\u0017.\u001a8u\u0003\u001daunZ+uS2\u0004\"!\u0010$\u000e\u0003yR!a\u0010!\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\n\u000b\u0001B]1cE&$X.\u001d\u0006\u0003\u0007\u0012\u000bq!Y9vCNL8OC\u0001F\u0003\t1'/\u0003\u0002H}\t9Aj\\4Vi&d\u0017!H1rk\u00064$m\\*ve\u001a\f7-Z)vC2LGo\\7fi\u0016\u0014H)Y8\u0011\u0005)kU\"A&\u000b\u00051s\u0012a\u00013b_&\u0011aj\u0013\u0002\u001e\u0003F,\u0018M\u000e2p'V\u0014h-Y2f#V\fG.\u001b;p[\u0016$XM\u001d#b_\u0006aq\u000e]3sCRLwN\u001c#b_B\u0011\u0011+V\u0007\u0002%*\u0011Aj\u0015\u0006\u0003)\u0002\nA!\u00193fg&\u0011aK\u0015\u0002\r\u001fB,'/\u0019;j_:$\u0015m\\\u0001\bG&$\u0018\u0010R1p!\tI&-D\u0001[\u0015\tYF,A\u0002ji\u001aT!!\u00180\u0002\t\rLG/\u001f\u0006\u0003?\u0002\fAB]3gKJ,g\u000e^5bYNT!!\u0019\"\u0002\u000b\u0011\fW-Y;\n\u0005\rT&aB\"jif$\u0015m\\\u0001\u000b\u0015>\u0014Gj\\4Vi&d\u0007C\u00014j\u001b\u00059'B\u00015C\u0003\u0015)H/\u001b7t\u0013\tQwM\u0001\u0006K_\ndunZ+uS2\fq\"];bY&$x.\\3uKJ$\u0015m\u001c\t\u0003[Fl\u0011A\u001c\u0006\u00037>T!\u0001\u001d1\u0002\u000fE,\u0018\r\\5us&\u0011!O\u001c\u0002\u0010#V\fG.\u001b;p[\u0016$XM\u001d#b_\u0006aq/\u0019;feNDW\r\u001a#b_B\u0011Q/_\u0007\u0002m*\u00111l\u001e\u0006\u0003qz\u000b\u0011b^1uKJ\u001c\b.\u001a3\n\u0005i4(\u0001D,bi\u0016\u00148\u000f[3e\t\u0006|\u0017\u0001D<bi\u0016\u0014X.Y:t\t\u0006|\u0007cA?\u0002\u00045\taP\u0003\u0002\\\u007f*\u0019\u0011\u0011\u00010\u0002\u0013]\fG/\u001a:nCN\u001c\u0018bAA\u0003}\naq+\u0019;fe6\f7o\u001d#b_\u0006\u0001r-\u001a8fe&\u001c\u0017*\u001c9peR$\u0015m\u001c\t\u0005\u0003\u0017\t\u0019\"\u0004\u0002\u0002\u000e)\u00191,a\u0004\u000b\u0005\u0005E\u0011!D4f]\u0016\u0014\u0018nY%na>\u0014H/\u0003\u0003\u0002\u0016\u00055!\u0001E$f]\u0016\u0014\u0018nY%na>\u0014H\u000fR1p\u0003\t!'\r\u0005\u0003\u0002\u001c\u0005}QBAA\u000f\u0015\r\t9BN\u0005\u0005\u0003C\tiB\u0001\u0005ECR\f'-Y:f\u0003\u0019a\u0014N\\5u}Q\u0011\u0011q\u0005\u000b\u0019\u0003S\ti#a\f\u00022\u0005M\u0012QGA\u001c\u0003s\tY$!\u0010\u0002@\u0005\u0005\u0003cAA\u0016\u00015\tA\u0004C\u00031\u0019\u0001\u000f\u0011\u0007C\u0003<\u0019\u0001\u000fA\bC\u0003I\u0019\u0001\u000f\u0011\nC\u0003P\u0019\u0001\u000f\u0001\u000bC\u0003X\u0019\u0001\u000f\u0001\fC\u0003e\u0019\u0001\u000fQ\rC\u0003l\u0019\u0001\u000fA\u000eC\u0003t\u0019\u0001\u000fA\u000fC\u0003|\u0019\u0001\u000fA\u0010C\u0004\u0002\b1\u0001\u001d!!\u0003\t\u000f\u0005]A\u0002q\u0001\u0002\u001a!\u001aA\"!\u0012\u0011\t\u0005\u001d\u0013\u0011K\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u00051\u0011N\u001c6fGRT!!a\u0014\u0002\u000b)\fg/\u0019=\n\t\u0005M\u0013\u0011\n\u0002\u0007\u0013:TWm\u0019;\u0002\u001b\u001d,GOU8vi&twmS3z)\t\tI\u0006\u0005\u0003\u0002\\\u0005%d\u0002BA/\u0003K\u00022!a\u0018'\u001b\t\t\tGC\u0002\u0002d\t\na\u0001\u0010:p_Rt\u0014bAA4M\u00051\u0001K]3eK\u001aLA!a\u001b\u0002n\t11\u000b\u001e:j]\u001eT1!a\u001a'\u0003-A\u0017M\u001c3mK\u0016\u0013(o\u001c:\u0015\r\u0005M\u0014\u0011PAH!\r)\u0013QO\u0005\u0004\u0003o2#\u0001B+oSRDq!a\u001f\u000f\u0001\u0004\ti(A\u0001f!\u0011\ty(!#\u000f\t\u0005\u0005\u0015Q\u0011\b\u0005\u0003?\n\u0019)C\u0001(\u0013\r\t9IJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY)!$\u0003\u0013\u0015C8-\u001a9uS>t'bAADM!9\u0011\u0011\u0013\bA\u0002\u0005M\u0015A\u00046pE\u0016CXmY;uS>t\u0017\n\u001a\t\u0004K\u0005U\u0015bAALM\t!Aj\u001c8h\u0003\u001d)\u00070Z2vi\u0016$b!a\u001d\u0002\u001e\u0006\u0005\u0006bBAP\u001f\u0001\u0007\u0011\u0011L\u0001\u000be>,H/\u001b8h\u0017\u0016L\bbBAR\u001f\u0001\u0007\u0011QU\u0001\b[\u0016\u001c8/Y4f!\u0011\t9+!,\u000e\u0005\u0005%&bAAVi\u0005!!n]8o\u0013\u0011\ty+!+\u0003\u000f)\u001bh+\u00197vK\u0006yQ\r_3dkR,W*\u00198vC2d\u0017\u0010\u0006\u0003\u0002Z\u0005U\u0006bBAR!\u0001\u0007\u0011QU\u0001\fS:$Xm\u001a:bi&|g\u000e\u0006\u0003\u0002<\u0006\u001d\u0007CBA@\u0003{\u000b\t-\u0003\u0003\u0002@\u00065%aA*fcB\u0019Q%a1\n\u0007\u0005\u0015gEA\u0002J]RDq!a)\u0012\u0001\u0004\t)+\u0001\nti\u0006$\u0018n\u001c8J]R,wM]1uS>tGCBAg\u0003;\f)\u000f\u0006\u0003\u0002P\u0006m\u0007#B\u0013\u0002R\u0006U\u0017bAAjM\t1q\n\u001d;j_:\u00042!JAl\u0013\r\tIN\n\u0002\u0007\t>,(\r\\3\t\u000f\u0005E%\u0003q\u0001\u0002\u0014\"I\u0011q\u0017\n\u0011\u0002\u0003\u0007\u0011q\u001c\t\u0004K\u0005\u0005\u0018bAArM\t9!i\\8mK\u0006t\u0007bBAt%\u0001\u0007\u0011\u0011L\u0001\u0005G>$W-\u0001\u000fti\u0006$\u0018n\u001c8J]R,wM]1uS>tG\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055(\u0006BAp\u0003_\\#!!=\u0011\t\u0005M\u0018Q`\u0007\u0003\u0003kTA!a>\u0002z\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003w4\u0013AC1o]>$\u0018\r^5p]&!\u0011q`A{\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0011O\u0016$8+\u00198ee\u0016\u001cF/\u0019;j_:$\u0002B!\u0002\u0003\n\t-!q\u0002\u000b\u0005\u0003\u001f\u00149\u0001C\u0004\u0002\u0012R\u0001\u001d!a%\t\u000f\u0005\u001dH\u00031\u0001\u0002Z!9!Q\u0002\u000bA\u0002\u0005U\u0017!C:uCRLwN\\%e\u0011%\u0011\t\u0002\u0006I\u0001\u0002\u0004\t\t-A\u0004oE\u0006\u0003\b/\u001a7\u00025\u001d,GoU1oIJ,7\u000b^1uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t]!\u0006BAa\u0003_\f!d\u0019:fCR,wJ]+qI\u0006$X-U;bY&$x.\\3uKJ$\u0002\"a4\u0003\u001e\t5\"\u0011\u0007\u0005\b\u0005?1\u0002\u0019\u0001B\u0011\u0003\u001d\tX/\u00197ji>\u0004BAa\t\u0003*5\u0011!Q\u0005\u0006\u0004\u0005Oy\u0017!B7pI\u0016d\u0017\u0002\u0002B\u0016\u0005K\u0011A\"U;bY&$x.\\3uKJDq!!%\u0017\u0001\u0004\u0011y\u0003E\u0003&\u0003#\f\u0019\nC\u0005\u00034Y\u0001\n\u00111\u0001\u00036\u0005iq/\u0019;fe6\f7o]\"pI\u0016\u0004R!JAi\u00033\nAe\u0019:fCR,wJ]+qI\u0006$X-U;bY&$x.\\3uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005wQCA!\u000e\u0002p\u0006ar\u000e]3sCRLwN\\!oC2L8/[:J]R,wM]1uS>tG\u0003\u0004B!\u0005\u000b\u0012YEa\u0014\u0003R\tMC\u0003BA:\u0005\u0007Bq!!%\u0019\u0001\b\t\u0019\nC\u0004\u0003Ha\u0001\rA!\u0013\u0002#\u0015D8\r\\;eK\u0012\u0004&o\u001c3vG\u0016\u00148\u000fE\u0003&\u0003#\fY\fC\u0004\u0003Na\u0001\rA!\u000e\u0002\u0015%l\u0007o\u001c:u\u001b>$W\rC\u0004\u0003\u000ea\u0001\r!!6\t\u000f\u0005\u001d\b\u00041\u0001\u0002Z!9!Q\u000b\rA\u0002\t]\u0013A\u00039be\u0006lW\r^3sgB!!\u0011\fB1\u001b\t\u0011YF\u0003\u0003\u0003(\tu#b\u0001B0A\u0006\u0019!n\u001c2\n\t\t\r$1\f\u0002\u000e\u0015>\u0014\u0007+\u0019:b[\u0016$XM]:\u00023\u001d,Go\u00149fe\u0006$\u0018n\u001c8t\u0007\u0006dG\u000eR1uKN\u0014Vm\u0019\u000b\t\u0005S\u0012II!$\u0003\u0012B1\u0011q\u0010B6\u0005_JAA!\u001c\u0002\u000e\n!A*[:u!\u001d)#\u0011\u000fB;\u0005kJ1Aa\u001d'\u0005\u0019!V\u000f\u001d7feA!!q\u000fBC\u001b\t\u0011IH\u0003\u0003\u0003|\tu\u0014\u0001\u0002;j[\u0016TAAa \u0003\u0002\u0006!!n\u001c3b\u0015\t\u0011\u0019)A\u0002pe\u001eLAAa\"\u0003z\tAA)\u0019;f)&lW\rC\u0004\u0003\ff\u0001\rA!\u001e\u0002\u0013M$\u0018M\u001d;ECR,\u0007b\u0002BH3\u0001\u0007!QO\u0001\bK:$G)\u0019;f\u0011\u001d\u0011\u0019*\u0007a\u0001\u0005S\nQAY;jYRD3!\u0007BL!\u0011\u0011IJa'\u000e\u0005\u0005e\u0018\u0002\u0002BO\u0003s\u0014q\u0001^1jYJ,7-\u0001\u000bhKR|\u0005/\u001a:bi&|gn\u001d)be\u000e\u000bG\u000e\u001c\u000b\u000f\u0005G\u0013)La.\u0003:\nu&\u0011\u0019Bb!\u0019\ty(!0\u0003&B!!q\u0015BY\u001b\t\u0011IK\u0003\u0003\u0003,\n5\u0016!B5oaV$(b\u0001BX=\u00051Am\\7bS:LAAa-\u0003*\n\t3+\u001e:gC\u000e,\u0017+^1mSR|W.\u001a;fe>\u0003XM]1uS>t\u0017J\u001c9vi\"9!1\u0012\u000eA\u0002\tU\u0004b\u0002BH5\u0001\u0007!Q\u000f\u0005\b\u0005wS\u0002\u0019AAa\u0003\u001d\tG\u000f^3naRDqAa0\u001b\u0001\u0004\tI&A\u0006ti\u0006$\u0018n\u001c8D_\u0012,\u0007bBAI5\u0001\u0007\u00111\u0013\u0005\b\u0005\u000bT\u0002\u0019\u0001Bd\u0003\u001d1\u0017\u000e\u001c;feN\u0004R!JAi\u0005\u0013\u0004b!a \u0002>\u0006e\u0003f\u0001\u0001\u0003NB!\u0011q\tBh\u0013\u0011\u0011\t.!\u0013\u0003\u0013MKgn\u001a7fi>t\u0007")
public class SurfaceQualitometerController
implements Model {
    private final WSClient ws;
    private final LogUtil LogUtil;
    private final Aqua6boSurfaceQualitometerDao aqua6boSurfaceQualitometerDao;
    private final OperationDao operationDao;
    private final CityDao cityDao;
    private final JobLogUtil JobLogUtil;
    private final QualitometerDao qualitometerDao;
    private final WatershedDao watershedDao;
    private final WatermassDao watermassDao;
    private final GenericImportDao genericImportDao;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        SurfaceQualitometerController surfaceQualitometerController = this;
        synchronized (surfaceQualitometerController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        SurfaceQualitometerController surfaceQualitometerController = this;
        synchronized (surfaceQualitometerController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.SURFACE_QUALITOMETER_MODEL_TOPIC();
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_SURFACE_QUALITOMETER();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.integration(message);
            return;
        }
        if (string != null) {
            String string4 = string;
            this.LogUtil.info(new StringBuilder(19).append("Bad routing key => ").append(string4).toString(), this.LogUtil.info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    public String executeManually(JsValue message) {
        Seq<Object> results = this.integration(message);
        return Json$.MODULE$.toJson(results.map((Function1 & Serializable)id -> SurfaceQualitometerController.$anonfun$executeManually$1(BoxesRunTime.unboxToInt((Object)id))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)GenericData$.MODULE$.writes())).toString();
    }

    public Seq<Object> integration(JsValue message) {
        return (Seq)message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            $this.LogUtil.error(new StringBuilder(21).append("Fail to parse json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.LogUtil.error$default$2());
            return (Seq)Nil$.MODULE$;
        }, (Function1 & Serializable)parameters -> {
            Seq seq;
            block6: {
                if (scala.sys.package$.MODULE$.env().get((Object)"APPLICATION_TOKEN").isEmpty()) {
                    $this.JobLogUtil.log(parameters.jobExecutionId(), JobState$.MODULE$.ERROR(), "APPLICATION_TOKEN env is not in .env", "", $this.JobLogUtil.log$default$5());
                    return (Seq)Nil$.MODULE$;
                }
                try {
                    long jobExecutionId = parameters.jobExecutionId();
                    GenericFilter filters = (GenericFilter)JobUtil$.MODULE$.getFilters(parameters, jobExecutionId, $this.JobLogUtil, (Object)new GenericFilter(GenericFilter$.MODULE$.$lessinit$greater$default$1(), GenericFilter$.MODULE$.$lessinit$greater$default$2(), GenericFilter$.MODULE$.$lessinit$greater$default$3(), GenericFilter$.MODULE$.$lessinit$greater$default$4(), GenericFilter$.MODULE$.$lessinit$greater$default$5(), GenericFilter$.MODULE$.$lessinit$greater$default$6(), GenericFilter$.MODULE$.$lessinit$greater$default$7(), GenericFilter$.MODULE$.$lessinit$greater$default$8(), GenericFilter$.MODULE$.$lessinit$greater$default$9(), GenericFilter$.MODULE$.$lessinit$greater$default$10()), true, GenericFilter$.MODULE$.format());
                    ImportQualityDefaultValue defaultValue = (ImportQualityDefaultValue)JobUtil$.MODULE$.getFilters(parameters, jobExecutionId, $this.JobLogUtil, (Object)new ImportQualityDefaultValue(ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$1(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$2(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$3(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$4(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$5(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$6(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$7(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$8(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$9(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$10(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$11(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$12()), true, ImportQualityDefaultValue$.MODULE$.jsonReads());
                    Option<Seq<Object>> excludedProducers = filters.excludedProducers();
                    Option importMode = ((IterableOnceOps)parameters.dataTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains(ImportMode$.MODULE$.DATA())));
                    Option stationInte = ((IterableOnceOps)parameters.dataTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals(IntegrationType$.MODULE$.STATION_INTEGRATION())));
                    Option option = parameters.parameters();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Seq codes = (Seq)some.value();
                        Seq importedIds = (Seq)codes.flatMap((Function1 & Serializable)code -> {
                            if (code != null && code.trim().length() > 0) {
                                $this.JobLogUtil.checkExecutionAbort(jobExecutionId);
                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(42).append("Start integration for station with code : ").append((String)code).toString(), code, $this.JobLogUtil.log$default$5());
                                Option<Object> option = this.stationIntegration(stationInte.isDefined() && ((String)stationInte.get()).equalsIgnoreCase("stationIntegration"), (String)code, jobExecutionId);
                                if (option instanceof Some) {
                                    Some some = (Some)option;
                                    double id = BoxesRunTime.unboxToDouble((Object)some.value());
                                    if (importMode.isDefined() && !((String)importMode.get()).equalsIgnoreCase("DATA_NOTHING")) {
                                        this.operationAnalysisIntegration(excludedProducers, (Option<String>)importMode, id, (String)code, (JobParameters)parameters, jobExecutionId);
                                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(40).append("End integration for station with code : ").append((String)code).toString(), code, $this.JobLogUtil.log$default$5());
                                        return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{(int)id}));
                                    }
                                    return (Seq)Nil$.MODULE$;
                                }
                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "Station not found", code, $this.JobLogUtil.log$default$5());
                                return (Seq)Nil$.MODULE$;
                            }
                            return (Seq)Nil$.MODULE$;
                        });
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.STATION_IDS(), importedIds.mkString(","), "", $this.JobLogUtil.log$default$5());
                        seq = importedIds;
                        break block6;
                    }
                    if (None$.MODULE$.equals(option)) {
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "Parameters is not present", "", $this.JobLogUtil.log$default$5());
                        seq = (Seq)Nil$.MODULE$;
                        break block6;
                    }
                    throw new MatchError((Object)option);
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    $this.LogUtil.error(new StringBuilder(14).append("Error : ").append(e.getClass().getName()).append(" : ").append(e.getMessage()).append(" \n ").append(sw.toString()).toString(), $this.LogUtil.error$default$2());
                    $this.JobLogUtil.log(parameters.jobExecutionId(), JobState$.MODULE$.ERROR(), e.getMessage(), "", $this.JobLogUtil.log$default$5());
                    seq = (Seq)Nil$.MODULE$;
                }
            }
            return seq;
        });
    }

    public Option<Object> stationIntegration(boolean integration, String code, long jobExecutionId) {
        Option option = this.qualitometerDao.get(code);
        if (option instanceof Some) {
            Some some = (Some)option;
            Qualitometer station = (Qualitometer)some.value();
            if (integration) {
                Option<SurfaceQualitometerStationInput> option2 = this.aqua6boSurfaceQualitometerDao.getStation(code, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)));
                if (option2 instanceof Some) {
                    Option<String> option3;
                    None$ none$;
                    Some some2 = (Some)option2;
                    SurfaceQualitometerStationInput s = (SurfaceQualitometerStationInput)some2.value();
                    if (s.basinCode().isDefined()) {
                        Option watershed = this.watershedDao.getbyCode((String)s.basinCode().get());
                        if (watershed.isDefined()) {
                            none$ = new Some((Object)BoxesRunTime.boxToDouble((double)((Watershed)watershed.get()).id()));
                        } else {
                            Option watershedId = this.watershedDao.create(new Watershed(0.0, s.basinCode(), s.basinName(), Watershed$.MODULE$.$lessinit$greater$default$4(), Watershed$.MODULE$.$lessinit$greater$default$5(), Watershed$.MODULE$.$lessinit$greater$default$6(), Watershed$.MODULE$.$lessinit$greater$default$7(), Watershed$.MODULE$.$lessinit$greater$default$8(), Watershed$.MODULE$.$lessinit$greater$default$9()));
                            none$ = new Some((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToLong((Object)watershedId.get())));
                        }
                    } else {
                        none$ = None$.MODULE$;
                    }
                    None$ bassinid = none$;
                    Qualitometer qualito = s.toQualitometer(station.id(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), (Option<Object>)bassinid, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)));
                    if (s.basinCode().isDefined()) {
                        Option watermass = this.watermassDao.get((String)s.waterMassCode().get());
                        if (watermass.isDefined()) {
                            option3 = s.waterMassCode();
                        } else {
                            String x$1 = (String)s.waterMassCode().get();
                            Option<String> x$2 = s.waterMassName();
                            Option<String> x$3 = s.waterMassEuCode();
                            None$ x$4 = None$.MODULE$;
                            None$ x$5 = None$.MODULE$;
                            None$ x$6 = None$.MODULE$;
                            None$ x$7 = None$.MODULE$;
                            None$ x$8 = None$.MODULE$;
                            None$ x$9 = None$.MODULE$;
                            None$ x$10 = None$.MODULE$;
                            None$ x$11 = None$.MODULE$;
                            None$ x$12 = None$.MODULE$;
                            None$ x$13 = None$.MODULE$;
                            None$ x$14 = None$.MODULE$;
                            None$ x$15 = None$.MODULE$;
                            None$ x$16 = None$.MODULE$;
                            None$ x$17 = None$.MODULE$;
                            None$ x$18 = None$.MODULE$;
                            None$ x$19 = None$.MODULE$;
                            None$ x$20 = None$.MODULE$;
                            None$ x$21 = None$.MODULE$;
                            None$ x$22 = None$.MODULE$;
                            this.watermassDao.create(new WatermassInput(x$1, x$3, x$2, (Option)x$4, (Option)x$5, (Option)x$6, (Option)x$7, (Option)x$8, (Option)x$9, (Option)x$10, (Option)x$11, (Option)x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, (Option)x$18, (Option)x$19, (Option)x$20, (Option)x$21, (Option)x$22));
                            option3 = s.waterMassCode();
                        }
                    } else {
                        option3 = None$.MODULE$;
                    }
                    Option<String> watermassCode = option3;
                    return this.createOrUpdateQualitometer(qualito, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), watermassCode);
                }
                if (None$.MODULE$.equals(option2)) {
                    return this.getSandreStation(code, station.id(), 1, jobExecutionId);
                }
                throw new MatchError(option2);
            }
            return new Some((Object)BoxesRunTime.boxToDouble((double)station.id()));
        }
        if (None$.MODULE$.equals(option)) {
            Option<SurfaceQualitometerStationInput> option4 = this.aqua6boSurfaceQualitometerDao.getStation(code, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)));
            if (option4 instanceof Some) {
                Option<Object> option5;
                Some some = (Some)option4;
                SurfaceQualitometerStationInput station = (SurfaceQualitometerStationInput)some.value();
                try {
                    Option<String> option6;
                    None$ none$;
                    if (station.basinCode().isDefined()) {
                        Option watershed = this.watershedDao.getbyCode((String)station.basinCode().get());
                        if (watershed.isDefined()) {
                            none$ = new Some((Object)BoxesRunTime.boxToDouble((double)((Watershed)watershed.get()).id()));
                        } else {
                            Option watershedId = this.watershedDao.create(new Watershed(0.0, station.basinCode(), station.basinName(), Watershed$.MODULE$.$lessinit$greater$default$4(), Watershed$.MODULE$.$lessinit$greater$default$5(), Watershed$.MODULE$.$lessinit$greater$default$6(), Watershed$.MODULE$.$lessinit$greater$default$7(), Watershed$.MODULE$.$lessinit$greater$default$8(), Watershed$.MODULE$.$lessinit$greater$default$9()));
                            none$ = new Some((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToLong((Object)watershedId.get())));
                        }
                    } else {
                        none$ = None$.MODULE$;
                    }
                    None$ bassinid = none$;
                    Qualitometer qualito = station.toQualitometer(0.0, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), (Option<Object>)bassinid, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)));
                    if (station.basinCode().isDefined()) {
                        Option watermass = this.watermassDao.get((String)station.waterMassCode().get());
                        if (watermass.isDefined()) {
                            option6 = station.waterMassCode();
                        } else {
                            String x$23 = (String)station.waterMassCode().get();
                            Option<String> x$24 = station.waterMassName();
                            Option<String> x$25 = station.waterMassEuCode();
                            None$ x$26 = None$.MODULE$;
                            None$ x$27 = None$.MODULE$;
                            None$ x$28 = None$.MODULE$;
                            None$ x$29 = None$.MODULE$;
                            None$ x$30 = None$.MODULE$;
                            None$ x$31 = None$.MODULE$;
                            None$ x$32 = None$.MODULE$;
                            None$ x$33 = None$.MODULE$;
                            None$ x$34 = None$.MODULE$;
                            None$ x$35 = None$.MODULE$;
                            None$ x$36 = None$.MODULE$;
                            None$ x$37 = None$.MODULE$;
                            None$ x$38 = None$.MODULE$;
                            None$ x$39 = None$.MODULE$;
                            None$ x$40 = None$.MODULE$;
                            None$ x$41 = None$.MODULE$;
                            None$ x$42 = None$.MODULE$;
                            None$ x$43 = None$.MODULE$;
                            None$ x$44 = None$.MODULE$;
                            this.watermassDao.create(new WatermassInput(x$23, x$25, x$24, (Option)x$26, (Option)x$27, (Option)x$28, (Option)x$29, (Option)x$30, (Option)x$31, (Option)x$32, (Option)x$33, (Option)x$34, (Option)x$35, (Option)x$36, (Option)x$37, (Option)x$38, (Option)x$39, (Option)x$40, (Option)x$41, (Option)x$42, (Option)x$43, (Option)x$44));
                            option6 = station.waterMassCode();
                        }
                    } else {
                        option6 = None$.MODULE$;
                    }
                    Option<String> watermassCode = option6;
                    option5 = this.createOrUpdateQualitometer(qualito, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), watermassCode);
                }
                catch (Exception e) {
                    Predef$.MODULE$.println((Object)e);
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(31).append("Error in station integration : ").append(e.getMessage()).toString(), code, this.JobLogUtil.log$default$5());
                    option5 = None$.MODULE$;
                }
                return option5;
            }
            if (None$.MODULE$.equals(option4)) {
                return this.getSandreStation(code, 0.0, 1, jobExecutionId);
            }
            throw new MatchError(option4);
        }
        throw new MatchError((Object)option);
    }

    public boolean stationIntegration$default$1() {
        return true;
    }

    public Option<Object> getSandreStation(String code, double stationId, int nbAppel, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Station not found with Aqua6BO, calling Sandre WS...", code, this.JobLogUtil.log$default$5());
        String url = new StringBuilder(406).append("https://services.sandre.eaufrance.fr/geo/stq?SERVICE=WFS&REQUEST=getFeature&VERSION=1.1.0&srsName=epsg%3A4326&TYPENAME=StationMesureEauxSurface&FILTER=%3CFilter%3E%3CPropertyIsEqualTo%3E%3CPropertyName%3ECdStationMesureEauxSurface%3C/PropertyName%3E%3CLiteral%3E").append(code).append("%3C/Literal%3E%3C/PropertyIsEqualTo%3E%3C/Filter%3E&outputFormat=application/json%3B%20subtype%3Dgeojson&pk_vid=44c7655ea6adbb2d1591623913ffe154").toString();
        Future<Either<SurfaceQualitometerSandre, Exception>> future = WSUtil$.MODULE$.getWithAuthWithReads(url, SurfaceQualitometerSandre$.MODULE$.readsWS(), WSUtil$.MODULE$.getWithAuthWithReads$default$3(), WSUtil$.MODULE$.getWithAuthWithReads$default$4(), this.ws);
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(14).append("Calling url : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
        Either either = (Either)Await$.MODULE$.result(future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(15)).minutes());
        if (either instanceof Left) {
            Left left = (Left)either;
            SurfaceQualitometerSandre qualitoSandre = (SurfaceQualitometerSandre)left.value();
            Qualitometer qualito = qualitoSandre.toQualitometer(stationId, jobExecutionId);
            return this.createOrUpdateQualitometer(qualito, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), this.createOrUpdateQualitometer$default$3());
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Exception e = (Exception)right.value();
            if (nbAppel < 3) {
                Thread.sleep(10000L);
                return this.getSandreStation(code, stationId, nbAppel + 1, jobExecutionId);
            }
            if (e.getMessage().contains("error.path.missing")) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Station not found with sandre", code, this.JobLogUtil.log$default$5());
                return None$.MODULE$;
            }
            this.LogUtil.printError((Throwable)e);
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(30).append("Error during Sandre WS call : ").append(e.getMessage()).toString(), code, this.JobLogUtil.log$default$5());
            return None$.MODULE$;
        }
        throw new MatchError((Object)either);
    }

    public int getSandreStation$default$3() {
        return 0;
    }

    public Option<Object> createOrUpdateQualitometer(Qualitometer qualito, Option<Object> jobExecutionId, Option<String> watermassCode) {
        Some some;
        Tuple2 tuple2;
        BoxedUnit boxedUnit;
        None$ watermass = watermassCode.isDefined() ? new Some((Object)new .colon.colon((Object)new StationWatermass(qualito.id(), (String)watermassCode.get(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), (List)Nil$.MODULE$)) : None$.MODULE$;
        double x$1 = 0.0;
        None$ x$2 = watermass;
        Option x$3 = QualitometerLinks$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = QualitometerLinks$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = QualitometerLinks$.MODULE$.$lessinit$greater$default$4();
        Option x$6 = QualitometerLinks$.MODULE$.$lessinit$greater$default$5();
        Option x$7 = QualitometerLinks$.MODULE$.$lessinit$greater$default$6();
        Option x$8 = QualitometerLinks$.MODULE$.$lessinit$greater$default$7();
        Option x$9 = QualitometerLinks$.MODULE$.$lessinit$greater$default$9();
        Option x$10 = QualitometerLinks$.MODULE$.$lessinit$greater$default$10();
        Option x$11 = QualitometerLinks$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = QualitometerLinks$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = QualitometerLinks$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = QualitometerLinks$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = QualitometerLinks$.MODULE$.$lessinit$greater$default$15();
        Option x$16 = QualitometerLinks$.MODULE$.$lessinit$greater$default$16();
        Option x$17 = QualitometerLinks$.MODULE$.$lessinit$greater$default$17();
        Option x$18 = QualitometerLinks$.MODULE$.$lessinit$greater$default$18();
        Option x$19 = QualitometerLinks$.MODULE$.$lessinit$greater$default$19();
        Option x$20 = QualitometerLinks$.MODULE$.$lessinit$greater$default$20();
        Option x$21 = QualitometerLinks$.MODULE$.$lessinit$greater$default$21();
        QualitometerLinks qualitoLinks = new QualitometerLinks(0.0, x$3, x$4, x$5, x$6, x$7, x$8, (Option)x$2, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        if (qualito.id() > 0.0) {
            BoxedUnit boxedUnit2;
            if (qualito.townCode().isDefined()) {
                Some x$22 = new Some((Object)new StringBuilder(2).append("<").append(qualito.townCode().get()).append(">").toString());
                String x$23 = (String)qualito.townCode().get();
                Option x$24 = City$.MODULE$.$lessinit$greater$default$3();
                Option x$25 = City$.MODULE$.$lessinit$greater$default$4();
                Option x$26 = City$.MODULE$.$lessinit$greater$default$5();
                Option x$27 = City$.MODULE$.$lessinit$greater$default$6();
                Option x$28 = City$.MODULE$.$lessinit$greater$default$7();
                Option x$29 = City$.MODULE$.$lessinit$greater$default$8();
                Option x$30 = City$.MODULE$.$lessinit$greater$default$9();
                Option x$31 = City$.MODULE$.$lessinit$greater$default$10();
                Option x$32 = City$.MODULE$.$lessinit$greater$default$11();
                Option x$33 = City$.MODULE$.$lessinit$greater$default$12();
                Option x$34 = City$.MODULE$.$lessinit$greater$default$13();
                Option x$35 = City$.MODULE$.$lessinit$greater$default$14();
                Option x$36 = City$.MODULE$.$lessinit$greater$default$15();
                boxedUnit2 = this.cityDao.createCities((Seq)new .colon.colon((Object)new City(x$23, (Option)x$22, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36), (List)Nil$.MODULE$));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            int res = this.qualitometerDao.update(new QualitometerWithLinks(qualito, qualitoLinks));
            if (res > 0) {
                JobParametersUtil$.MODULE$.jobLog(jobExecutionId, JobState$.MODULE$.SUCCESS(), "Station description updated successfully", qualito.code(), "", this.JobLogUtil);
            }
            return new Some((Object)BoxesRunTime.boxToDouble((double)qualito.id()));
        }
        if (qualito.townCode().isDefined()) {
            Some x$37 = new Some((Object)new StringBuilder(2).append("<").append(qualito.townCode().get()).append(">").toString());
            String x$38 = (String)qualito.townCode().get();
            Option x$39 = City$.MODULE$.$lessinit$greater$default$3();
            Option x$40 = City$.MODULE$.$lessinit$greater$default$4();
            Option x$41 = City$.MODULE$.$lessinit$greater$default$5();
            Option x$42 = City$.MODULE$.$lessinit$greater$default$6();
            Option x$43 = City$.MODULE$.$lessinit$greater$default$7();
            Option x$44 = City$.MODULE$.$lessinit$greater$default$8();
            Option x$45 = City$.MODULE$.$lessinit$greater$default$9();
            Option x$46 = City$.MODULE$.$lessinit$greater$default$10();
            Option x$47 = City$.MODULE$.$lessinit$greater$default$11();
            Option x$48 = City$.MODULE$.$lessinit$greater$default$12();
            Option x$49 = City$.MODULE$.$lessinit$greater$default$13();
            Option x$50 = City$.MODULE$.$lessinit$greater$default$14();
            Option x$51 = City$.MODULE$.$lessinit$greater$default$15();
            boxedUnit = this.cityDao.createCities((Seq)new .colon.colon((Object)new City(x$38, (Option)x$37, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51), (List)Nil$.MODULE$));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option option = this.qualitometerDao.insert(new QualitometerWithLinks(qualito, qualitoLinks));
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            int result = tuple2._1$mcI$sp();
            double id = tuple2._2$mcD$sp();
            if (result > 0) {
                JobParametersUtil$.MODULE$.jobLog(jobExecutionId, JobState$.MODULE$.SUCCESS(), "Station description created successfully", qualito.code(), "", this.JobLogUtil);
                return new Some((Object)BoxesRunTime.boxToDouble((double)id));
            }
            JobParametersUtil$.MODULE$.jobLog(jobExecutionId, JobState$.MODULE$.ERROR(), "Error during surface qualitometer creation", qualito.code(), "", this.JobLogUtil);
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            JobParametersUtil$.MODULE$.jobLog(jobExecutionId, JobState$.MODULE$.ERROR(), "Error during surface qualitometer creation", qualito.code(), "", this.JobLogUtil);
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public Option<String> createOrUpdateQualitometer$default$3() {
        return None$.MODULE$;
    }

    public void operationAnalysisIntegration(Option<Seq<Object>> excludedProducers, Option<String> importMode, double stationId, String code, JobParameters parameters, long jobExecutionId) {
        DateTime dateTime;
        SurfaceQualitometerFilter filters = (SurfaceQualitometerFilter)JobUtil$.MODULE$.getFilters(parameters, jobExecutionId, this.JobLogUtil, (Object)new SurfaceQualitometerFilter(SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$1(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$2(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$3(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$4(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$5(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$6(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$7(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$8(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$9(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$10(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$11(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$12(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$13(), SurfaceQualitometerFilter$.MODULE$.$lessinit$greater$default$14()), true, SurfaceQualitometerFilter$.MODULE$.format());
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(19).append("Integration Mode : ").append(parameters.dataTypes().get()).toString(), code, this.JobLogUtil.log$default$5());
        if (importMode.contains((Object)ImportMode$.MODULE$.ADD_LAST_DATA())) {
            Option<Operation> option = this.operationDao.getLastOperation(code, filters.campaignId());
            if (option instanceof Some) {
                Some some = (Some)option;
                Operation operation = (Operation)some.value();
                dateTime = operation.start();
            } else {
                dateTime = new DateTime(1980, 1, 1, 0, 0, DateTimeZone.forID((String)"Europe/Paris")).minusDays(1);
            }
        } else if (importMode.contains((Object)ImportMode$.MODULE$.REPLACE_RECENT_HISTO())) {
            Option<Operation> option = this.operationDao.getLastOperation(code, filters.campaignId());
            if (option instanceof Some) {
                Some some = (Some)option;
                Operation operation = (Operation)some.value();
                dateTime = (DateTime)new .colon.colon((Object)operation.start(), (List)new .colon.colon((Object)new DateTime().minusMonths(BoxesRunTime.unboxToInt((Object)filters.recentHistoReplacePeriod().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 6))), (List)Nil$.MODULE$)).minBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getMillis()), (Ordering)Ordering.Long$.MODULE$);
            } else {
                dateTime = new DateTime(1980, 1, 1, 0, 0, DateTimeZone.forID((String)"Europe/Paris")).minusDays(1);
            }
        } else {
            dateTime = new DateTime(1980, 1, 1, 0, 0, DateTimeZone.forID((String)"Europe/Paris")).minusDays(1);
        }
        DateTime beginDate = dateTime;
        ImportQualityDefaultValue defaultValue = (ImportQualityDefaultValue)JobUtil$.MODULE$.getFilters(parameters, jobExecutionId, this.JobLogUtil, (Object)new ImportQualityDefaultValue(ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$1(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$2(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$3(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$4(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$5(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$6(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$7(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$8(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$9(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$10(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$11(), ImportQualityDefaultValue$.MODULE$.$lessinit$greater$default$12()), true, ImportQualityDefaultValue$.MODULE$.jsonReads());
        List<Tuple2<DateTime, DateTime>> allDates = this.getOperationsCallDatesRec(beginDate, new DateTime(), (List<Tuple2<DateTime, DateTime>>)Nil$.MODULE$);
        Seq allOperations = (Seq)CollectionConverters.ImmutableSeqIsParallelizable$.MODULE$.par$extension(CollectionConverters$.MODULE$.ImmutableSeqIsParallelizable(allDates)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DateTime start = (DateTime)tuple2._1();
                DateTime end = (DateTime)tuple2._2();
                return this.getOperationsParCall(start, end, 1, code, jobExecutionId, (Option<Seq<String>>)parameters.filters());
            }
            throw new MatchError((Object)tuple2);
        }).seq().flatten(Predef$.MODULE$.$conforms());
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(47).append("End call Aqua6BO, ").append(allOperations.length()).append(" operations, ").append(((SeqOps)allOperations.flatMap((Function1 & Serializable)x$4 -> (Seq)x$4.analysis().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$))).length()).append(" analysis found.").toString(), code, this.JobLogUtil.log$default$5());
        Seq constructedOperations = (Seq)allOperations.map((Function1 & Serializable)sqo -> {
            double x$1 = 0.0;
            double x$2 = stationId;
            DateTime x$3 = sqo.dateOperation();
            Option<String> x$4 = sqo.producerCode();
            Option<String> x$5 = sqo.comment();
            None$ x$6 = sqo.accreditationCode().isDefined() ? new Some((Object)sqo.accreditationCode().get().toString()) : None$.MODULE$;
            Option<String> x$7 = sqo.samplerCode();
            None$ x$8 = sqo.methodCode().isDefined() ? new Some((Object)sqo.methodCode().get().toString()) : None$.MODULE$;
            Some x$9 = new Some((Object)sqo.sampleCode());
            Option x$10 = SampleImport$.MODULE$.$lessinit$greater$default$5();
            Option x$11 = SampleImport$.MODULE$.$lessinit$greater$default$6();
            Option x$12 = SampleImport$.MODULE$.$lessinit$greater$default$8();
            Option x$13 = SampleImport$.MODULE$.$lessinit$greater$default$10();
            Option x$14 = SampleImport$.MODULE$.$lessinit$greater$default$11();
            Option x$15 = SampleImport$.MODULE$.$lessinit$greater$default$12();
            Option x$16 = SampleImport$.MODULE$.$lessinit$greater$default$13();
            Option x$17 = SampleImport$.MODULE$.$lessinit$greater$default$14();
            Option x$18 = SampleImport$.MODULE$.$lessinit$greater$default$16();
            Option x$19 = SampleImport$.MODULE$.$lessinit$greater$default$17();
            Option x$20 = SampleImport$.MODULE$.$lessinit$greater$default$18();
            Option x$21 = SampleImport$.MODULE$.$lessinit$greater$default$19();
            Option x$22 = SampleImport$.MODULE$.$lessinit$greater$default$21();
            Option x$23 = SampleImport$.MODULE$.$lessinit$greater$default$23();
            Option x$24 = SampleImport$.MODULE$.$lessinit$greater$default$24();
            Option x$25 = SampleImport$.MODULE$.$lessinit$greater$default$25();
            Option x$26 = SampleImport$.MODULE$.$lessinit$greater$default$26();
            Option x$27 = SampleImport$.MODULE$.$lessinit$greater$default$27();
            Option x$28 = SampleImport$.MODULE$.$lessinit$greater$default$28();
            SampleImport sample = new SampleImport(0.0, x$2, x$3, x$5, x$10, x$11, x$4, x$12, (Option)x$9, x$13, x$14, x$15, x$16, x$17, (Option)x$6, x$18, x$19, x$20, x$21, (Option)x$8, x$22, x$7, x$23, x$24, x$25, x$26, x$27, x$28);
            double x$29 = stationId;
            double x$30 = 0.0;
            DateTime x$31 = sqo.dateOperation();
            Option<String> x$32 = sqo.producerCode();
            Option<String> x$33 = sqo.samplerCode();
            Option<Object> x$34 = sqo.campaignId();
            None$ x$35 = sqo.supportCode().isDefined() ? new Some((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToInt((Object)sqo.supportCode().get()))) : None$.MODULE$;
            Some x$36 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId));
            Option<String> x$37 = sqo.comment();
            None$ x$38 = None$.MODULE$;
            Option x$39 = OperationImport$.MODULE$.$lessinit$greater$default$4();
            Option x$40 = OperationImport$.MODULE$.$lessinit$greater$default$5();
            Option x$41 = OperationImport$.MODULE$.$lessinit$greater$default$6();
            Option x$42 = OperationImport$.MODULE$.$lessinit$greater$default$7();
            Option x$43 = OperationImport$.MODULE$.$lessinit$greater$default$8();
            Option x$44 = OperationImport$.MODULE$.$lessinit$greater$default$10();
            Option x$45 = OperationImport$.MODULE$.$lessinit$greater$default$11();
            Option x$46 = OperationImport$.MODULE$.$lessinit$greater$default$12();
            Option x$47 = OperationImport$.MODULE$.$lessinit$greater$default$13();
            Option x$48 = OperationImport$.MODULE$.$lessinit$greater$default$15();
            Option x$49 = OperationImport$.MODULE$.$lessinit$greater$default$16();
            Option x$50 = OperationImport$.MODULE$.$lessinit$greater$default$17();
            Option x$51 = OperationImport$.MODULE$.$lessinit$greater$default$18();
            Option x$52 = OperationImport$.MODULE$.$lessinit$greater$default$20();
            Option x$53 = OperationImport$.MODULE$.$lessinit$greater$default$21();
            Option x$54 = OperationImport$.MODULE$.$lessinit$greater$default$23();
            Option x$55 = OperationImport$.MODULE$.$lessinit$greater$default$25();
            Option x$56 = OperationImport$.MODULE$.$lessinit$greater$default$26();
            Option x$57 = OperationImport$.MODULE$.$lessinit$greater$default$27();
            Option x$58 = OperationImport$.MODULE$.$lessinit$greater$default$28();
            Option x$59 = OperationImport$.MODULE$.$lessinit$greater$default$29();
            Option x$60 = OperationImport$.MODULE$.$lessinit$greater$default$30();
            Option x$61 = OperationImport$.MODULE$.$lessinit$greater$default$31();
            Option x$62 = OperationImport$.MODULE$.$lessinit$greater$default$32();
            Option x$63 = OperationImport$.MODULE$.$lessinit$greater$default$33();
            Option x$64 = OperationImport$.MODULE$.$lessinit$greater$default$34();
            Option x$65 = OperationImport$.MODULE$.$lessinit$greater$default$35();
            Option x$66 = OperationImport$.MODULE$.$lessinit$greater$default$36();
            Option x$67 = OperationImport$.MODULE$.$lessinit$greater$default$37();
            Option x$68 = OperationImport$.MODULE$.$lessinit$greater$default$38();
            Option x$69 = OperationImport$.MODULE$.$lessinit$greater$default$39();
            Option x$70 = OperationImport$.MODULE$.$lessinit$greater$default$40();
            Option x$71 = OperationImport$.MODULE$.$lessinit$greater$default$42();
            Option x$72 = OperationImport$.MODULE$.$lessinit$greater$default$43();
            Option x$73 = OperationImport$.MODULE$.$lessinit$greater$default$44();
            Option x$74 = OperationImport$.MODULE$.$lessinit$greater$default$46();
            Option x$75 = OperationImport$.MODULE$.$lessinit$greater$default$47();
            OperationImport Ope = new OperationImport(x$29, 0.0, x$31, x$39, x$40, x$41, x$42, x$43, x$37, x$44, x$45, x$46, x$47, (Option)x$38, x$48, x$49, x$50, x$51, x$32, x$52, x$53, x$33, x$54, (Option)x$35, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, (Option)x$36, x$71, x$72, x$73, x$34, x$74, x$75);
            Seq listAnalys = sqo.analysis().isDefined() ? (Seq)((IterableOps)sqo.analysis().get()).map((Function1 & Serializable)ana -> {
                None$ x$94;
                double x$76 = stationId;
                long x$77 = 0L;
                double x$78 = 0.0;
                double x$79 = 0.0;
                Some x$80 = new Some((Object)ana.parameterCode());
                Option<DateTime> x$81 = ana.measureDate();
                Option<Object> x$82 = ana.measure();
                Some x$83 = ana.fractionCode().isDefined() ? new Some((Object)ana.fractionCode().get().toString()) : (defaultValue.fraction().isDefined() ? new Some((Object)defaultValue.fraction().get().toString()) : None$.MODULE$);
                Option x$84 = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)ana.methodCode().get())).toOption();
                Option<String> x$85 = ana.extractionMethodCode();
                Option<String> x$86 = ana.unitCode();
                Option x$87 = ana.remarkCode().map((Function1 & Serializable)x$5 -> SurfaceQualitometerController.$anonfun$operationAnalysisIntegration$9(BoxesRunTime.unboxToInt((Object)x$5)));
                Option x$88 = ana.insituCode().map((Function1 & Serializable)x$6 -> SurfaceQualitometerController.$anonfun$operationAnalysisIntegration$10(BoxesRunTime.unboxToInt((Object)x$6)));
                Option<Object> x$89 = ana.detectionLimit();
                Option<Object> x$90 = ana.quantificationLimit();
                Option<Object> x$91 = ana.saturationLimit();
                Some x$92 = ana.statusCode().isDefined() ? new Some((Object)ana.statusCode().get().toString()) : (defaultValue.status().isDefined() ? new Some((Object)defaultValue.status().get().toString()) : None$.MODULE$);
                Option x$93 = ana.accreditationCode().map((Function1 & Serializable)x$7 -> SurfaceQualitometerController.$anonfun$operationAnalysisIntegration$11(BoxesRunTime.unboxToInt((Object)x$7)));
                Object object = ana.laboratoryCode().isDefined() ? ana.laboratoryCode() : (x$94 = defaultValue.labo().isDefined() ? new Some((Object)defaultValue.labo().get().toString()) : None$.MODULE$);
                Some x$95 = ana.qualificationCode().isDefined() ? new Some((Object)ana.qualificationCode().get().toString()) : (defaultValue.qualification().isDefined() ? new Some((Object)defaultValue.qualification().get().toString()) : None$.MODULE$);
                Some x$96 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId));
                Option<String> x$97 = ana.laboratoryRef();
                Option x$98 = AnalysisImport$.MODULE$.$lessinit$greater$default$5();
                Option x$99 = AnalysisImport$.MODULE$.$lessinit$greater$default$8();
                Option x$100 = AnalysisImport$.MODULE$.$lessinit$greater$default$10();
                Option x$101 = AnalysisImport$.MODULE$.$lessinit$greater$default$11();
                Option x$102 = AnalysisImport$.MODULE$.$lessinit$greater$default$21();
                Option x$103 = AnalysisImport$.MODULE$.$lessinit$greater$default$23();
                Option x$104 = AnalysisImport$.MODULE$.$lessinit$greater$default$24();
                Option x$105 = AnalysisImport$.MODULE$.$lessinit$greater$default$25();
                Option x$106 = AnalysisImport$.MODULE$.$lessinit$greater$default$27();
                Option x$107 = AnalysisImport$.MODULE$.$lessinit$greater$default$29();
                Option x$108 = AnalysisImport$.MODULE$.$lessinit$greater$default$30();
                Option x$109 = AnalysisImport$.MODULE$.$lessinit$greater$default$31();
                Option x$110 = AnalysisImport$.MODULE$.$lessinit$greater$default$32();
                Option x$111 = AnalysisImport$.MODULE$.$lessinit$greater$default$33();
                Option x$112 = AnalysisImport$.MODULE$.$lessinit$greater$default$34();
                Option x$113 = AnalysisImport$.MODULE$.$lessinit$greater$default$36();
                Option x$114 = AnalysisImport$.MODULE$.$lessinit$greater$default$37();
                Option x$115 = AnalysisImport$.MODULE$.$lessinit$greater$default$38();
                Option x$116 = AnalysisImport$.MODULE$.$lessinit$greater$default$39();
                Option x$117 = AnalysisImport$.MODULE$.$lessinit$greater$default$40();
                Option x$118 = AnalysisImport$.MODULE$.$lessinit$greater$default$42();
                Option x$119 = AnalysisImport$.MODULE$.$lessinit$greater$default$43();
                Option x$120 = AnalysisImport$.MODULE$.$lessinit$greater$default$44();
                Option x$121 = AnalysisImport$.MODULE$.$lessinit$greater$default$45();
                Option x$122 = AnalysisImport$.MODULE$.$lessinit$greater$default$46();
                Option x$123 = AnalysisImport$.MODULE$.$lessinit$greater$default$47();
                Option x$124 = AnalysisImport$.MODULE$.$lessinit$greater$default$49();
                Option x$125 = AnalysisImport$.MODULE$.$lessinit$greater$default$50();
                Option x$126 = AnalysisImport$.MODULE$.$lessinit$greater$default$51();
                return new AnalysisImport(x$76, 0L, 0.0, 0.0, x$98, x$81, (Option)x$80, x$99, x$86, x$100, x$101, x$82, x$87, x$88, x$90, x$89, x$91, (Option)x$95, (Option)x$92, (Option)x$83, x$102, x$84, x$103, x$104, x$105, (Option)x$94, x$106, x$97, x$107, x$108, x$109, x$110, x$111, x$112, x$93, x$113, x$114, x$115, x$116, x$117, x$85, x$118, x$119, x$120, x$121, x$122, x$123, (Option)x$96, x$124, x$125, x$126);
            }) : (Seq)Nil$.MODULE$;
            None$ listMe = sqo.listMesureEnvironnementale().isDefined() ? new Some(((IterableOps)sqo.listMesureEnvironnementale().get()).map((Function1 & Serializable)mesur -> {
                double x$127 = stationId;
                Option<DateTime> x$128 = mesur.dteMeasure();
                Option<Object> x$129 = mesur.codeOperation();
                Option<Object> x$130 = mesur.codeCondition();
                Option<DateTime> x$131 = mesur.timeMeasure();
                Option<String> x$132 = mesur.comment();
                Option<Object> x$133 = mesur.qualification();
                Option<Object> x$134 = mesur.status();
                Option<Object> x$135 = mesur.method();
                Option<Object> x$136 = mesur.data();
                Option<String> x$137 = mesur.unit();
                Option<Object> x$138 = mesur.param();
                Option x$139 = EnvironnementalMeasure$.MODULE$.$lessinit$greater$default$10();
                return new EnvironnementalMeasure(x$127, x$129, x$130, x$128, x$131, x$132, x$133, x$134, x$135, x$139, x$138, x$137, x$136);
            })) : None$.MODULE$;
            OperationImport x$140 = Ope;
            Some x$141 = new Some((Object)sample);
            Seq x$142 = listAnalys;
            None$ x$143 = listMe;
            Option<QualitometerPoint> x$144 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$4();
            Option<Seq<Sampling>> x$145 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$6();
            Option<Seq<Indice>> x$146 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$7();
            Option<Seq<String>> x$147 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$8();
            Option<Object> x$148 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$9();
            Option<Seq<QualityRecovery>> x$149 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$10();
            Option<Seq<MicroSampling>> x$150 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$11();
            Option<Seq<QualitometerOperationList>> x$151 = CompleteOperationImport$.MODULE$.$lessinit$greater$default$12();
            return new CompleteOperationImport(x$140, (Option<SampleImport>)x$141, (Seq<AnalysisImport>)x$142, x$144, (Option<Seq<EnvironnementalMeasure>>)x$143, x$145, x$146, x$147, x$148, x$149, x$150, x$151);
        });
        if (constructedOperations.isEmpty()) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(50).append("No data found for surface qualitometer for code : ").append(code).toString(), code, this.JobLogUtil.log$default$5());
            return;
        }
        Option<Seq<Object>> x$152 = excludedProducers;
        None$ x$153 = filters.campaignId().isDefined() ? new Some((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToDouble((Object)filters.campaignId().get())))) : None$.MODULE$;
        Option<String> x$154 = importMode;
        Option<Object> x$155 = filters.recentHistoReplacePeriod();
        Option<Object> x$156 = ImportOptions$.MODULE$.apply$default$1();
        Option<Object> x$157 = ImportOptions$.MODULE$.apply$default$3();
        Option<String> x$158 = ImportOptions$.MODULE$.apply$default$4();
        this.genericImportDao.importQuality(Integer.toString((int)stationId), code, jobExecutionId, (Seq<CompleteOperationImport>)constructedOperations, (String)parameters.user().get(), (Option<ImportOptions>)new Some((Object)new ImportOptions(x$156, x$154, x$157, x$158, (Option<Object>)x$153, x$152, x$155)));
    }

    private List<Tuple2<DateTime, DateTime>> getOperationsCallDatesRec(DateTime startDate, DateTime endDate, List<Tuple2<DateTime, DateTime>> built) {
        while (startDate.getMillis() < endDate.getMillis()) {
            DateTime newEndDate = startDate.plusYears(1).getMillis() > endDate.getMillis() ? endDate : startDate.plusYears(1);
            built = (List)built.$colon$plus((Object)new Tuple2((Object)startDate, (Object)newEndDate));
            startDate = startDate.plusYears(1);
        }
        return built;
    }

    private Seq<SurfaceQualitometerOperationInput> getOperationsParCall(DateTime startDate, DateTime endDate, int attempt, String stationCode, long jobExecutionId, Option<Seq<String>> filters) {
        Seq seq;
        while (true) {
            try {
                Seq newOperations = (Seq)this.aqua6boSurfaceQualitometerDao.getOperationAnalysis(stationCode, (Option<DateTime>)new Some((Object)startDate), (Option<DateTime>)new Some((Object)endDate), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId)), filters, true).getOrElse((Function0 & Serializable)() -> {
                    throw new Exception("Error on attempt to get operation analysis");
                });
                if (newOperations.nonEmpty()) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(32).append("Call received for dates: ").append(DateUtil$.MODULE$.getDate(startDate)).append(" to ").append(DateUtil$.MODULE$.getDate(endDate)).append(" : ").append(newOperations.length()).toString(), stationCode, this.JobLogUtil.log$default$5());
                    seq = newOperations;
                    break;
                }
                if (attempt == 3) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(38).append("No operations received for dates: ").append(DateUtil$.MODULE$.getDate(startDate)).append(" to ").append(DateUtil$.MODULE$.getDate(endDate)).toString(), stationCode, this.JobLogUtil.log$default$5());
                    seq = (Seq)Nil$.MODULE$;
                    break;
                }
                Thread.sleep(1000L);
                seq = this.getOperationsParCall(startDate, endDate, attempt + 1, stationCode, jobExecutionId, filters);
            }
            catch (Exception e) {
                if (attempt == 3) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(56).append("Error on data recuperation (with 3 attempts) for code : ").append(stationCode).toString(), stationCode, this.JobLogUtil.log$default$5());
                    throw new Exception(new StringBuilder(56).append("Error on data recuperation (with 3 attempts) for code : ").append(stationCode).toString(), e);
                }
                Thread.sleep(1000L);
                ++attempt;
                continue;
            }
            break;
        }
        return seq;
    }

    public static final /* synthetic */ GenericData $anonfun$executeManually$1(int id) {
        DateTime x$1 = new DateTime();
        DateTime x$2 = new DateTime();
        int x$3 = id;
        None$ x$4 = None$.MODULE$;
        Option x$5 = GenericData$.MODULE$.$lessinit$greater$default$5();
        Option x$6 = GenericData$.MODULE$.$lessinit$greater$default$6();
        Option x$7 = GenericData$.MODULE$.$lessinit$greater$default$7();
        Option x$8 = GenericData$.MODULE$.$lessinit$greater$default$8();
        Option x$9 = GenericData$.MODULE$.$lessinit$greater$default$9();
        Option x$10 = GenericData$.MODULE$.$lessinit$greater$default$10();
        Option x$11 = GenericData$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = GenericData$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = GenericData$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = GenericData$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = GenericData$.MODULE$.$lessinit$greater$default$15();
        return new GenericData(x$1, x$2, (Option)x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
    }

    public static final /* synthetic */ String $anonfun$operationAnalysisIntegration$9(int x$5) {
        return Integer.toString(x$5);
    }

    public static final /* synthetic */ String $anonfun$operationAnalysisIntegration$10(int x$6) {
        return Integer.toString(x$6);
    }

    public static final /* synthetic */ String $anonfun$operationAnalysisIntegration$11(int x$7) {
        return Integer.toString(x$7);
    }

    @Inject
    public SurfaceQualitometerController(WSClient ws, LogUtil LogUtil2, Aqua6boSurfaceQualitometerDao aqua6boSurfaceQualitometerDao, OperationDao operationDao, CityDao cityDao, JobLogUtil JobLogUtil2, QualitometerDao qualitometerDao, WatershedDao watershedDao, WatermassDao watermassDao, GenericImportDao genericImportDao, Database db) {
        this.ws = ws;
        this.LogUtil = LogUtil2;
        this.aqua6boSurfaceQualitometerDao = aqua6boSurfaceQualitometerDao;
        this.operationDao = operationDao;
        this.cityDao = cityDao;
        this.JobLogUtil = JobLogUtil2;
        this.qualitometerDao = qualitometerDao;
        this.watershedDao = watershedDao;
        this.watermassDao = watermassDao;
        this.genericImportDao = genericImportDao;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        Statics.releaseFence();
    }
}

