/*
 * Decompiled with CFR 0.152.
 */
package Quality.surfaceQualitometer.dao;

import Quality.surfaceQualitometer.constants.SurfaceQualitometerConstants$;
import Quality.surfaceQualitometer.domain.input.SurfaceQualitometerOperationInput;
import Quality.surfaceQualitometer.domain.input.SurfaceQualitometerOperationInput$;
import Quality.surfaceQualitometer.domain.input.SurfaceQualitometerStationInput;
import Quality.surfaceQualitometer.domain.input.SurfaceQualitometerStationInput$;
import constant.JobState$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.ws.WSClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import util.JobParametersUtil$;
import util.WSUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001B\u0005\u000b\u0001EA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006Y!\u0007\u0005\tK\u0001\u0011\t\u0011)A\u0006M!A\u0011\u0007\u0001B\u0001B\u0003-!\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0003J\u0001\u0011\u0005!\nC\u0003j\u0001\u0011\u0005!\u000eC\u0005\u0002&\u0001\t\n\u0011\"\u0001\u0002(!9\u0011Q\b\u0001\u0005\u0002\u0005}\"!H!rk\u00064$m\\*ve\u001a\f7-Z)vC2LGo\\7fi\u0016\u0014H)Y8\u000b\u0005-a\u0011a\u00013b_*\u0011QBD\u0001\u0014gV\u0014h-Y2f#V\fG.\u001b;p[\u0016$XM\u001d\u0006\u0002\u001f\u00059\u0011+^1mSRL8\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0017a\u0002'pOV#\u0018\u000e\u001c\t\u00035\rj\u0011a\u0007\u0006\u00039u\tA!\u001e;jY*\u0011adH\u0001\te\u0006\u0014'-\u001b;nc*\u0011\u0001%I\u0001\bCF,\u0018m]=t\u0015\u0005\u0011\u0013A\u00014s\u0013\t!3DA\u0004M_\u001e,F/\u001b7\u0002\u0005]\u001c\bCA\u00140\u001b\u0005A#BA\u0013*\u0015\tQ3&\u0001\u0003mS\n\u001c(B\u0001\u0017.\u0003\r\t\u0007/\u001b\u0006\u0002]\u0005!\u0001\u000f\\1z\u0013\t\u0001\u0004F\u0001\u0005X'\u000ec\u0017.\u001a8u\u0003)QuN\u0019'pOV#\u0018\u000e\u001c\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k}\tQ!\u001e;jYNL!a\u000e\u001b\u0003\u0015){'\rT8h+RLG.\u0001\u0004=S:LGO\u0010\u000b\u0002uQ!1(\u0010 @!\ta\u0004!D\u0001\u000b\u0011\u0015AB\u0001q\u0001\u001a\u0011\u0015)C\u0001q\u0001'\u0011\u0015\tD\u0001q\u00013Q\t!\u0011\t\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u00061\u0011N\u001c6fGRT\u0011AR\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0011\u000e\u0013a!\u00138kK\u000e$\u0018AC4fiN#\u0018\r^5p]R\u00191JV2\u0011\u0007Mae*\u0003\u0002N)\t1q\n\u001d;j_:\u0004\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\u000b%t\u0007/\u001e;\u000b\u0005Mc\u0011A\u00023p[\u0006Lg.\u0003\u0002V!\ny2+\u001e:gC\u000e,\u0017+^1mSR|W.\u001a;feN#\u0018\r^5p]&s\u0007/\u001e;\t\u000b]+\u0001\u0019\u0001-\u0002\u0017M$\u0018\r^5p]\u000e{G-\u001a\t\u00033\u0002t!A\u00170\u0011\u0005m#R\"\u0001/\u000b\u0005u\u0003\u0012A\u0002\u001fs_>$h(\u0003\u0002`)\u00051\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\tyF\u0003C\u0003e\u000b\u0001\u0007Q-\u0001\bk_\n,\u00050Z2vi&|g.\u00133\u0011\u0007Mae\r\u0005\u0002\u0014O&\u0011\u0001\u000e\u0006\u0002\u0005\u0019>tw-\u0001\u000bhKR|\u0005/\u001a:bi&|g.\u00118bYf\u001c\u0018n\u001d\u000b\fWbL\u0018QBA\t\u0003'\tY\u0002E\u0002\u0014\u00192\u00042!\u001c:v\u001d\tq\u0007O\u0004\u0002\\_&\tQ#\u0003\u0002r)\u00059\u0001/Y2lC\u001e,\u0017BA:u\u0005\r\u0019V-\u001d\u0006\u0003cR\u0001\"a\u0014<\n\u0005]\u0004&!I*ve\u001a\f7-Z)vC2LGo\\7fi\u0016\u0014x\n]3sCRLwN\\%oaV$\b\"B,\u0007\u0001\u0004A\u0006\"\u0002>\u0007\u0001\u0004Y\u0018!\u00032fO&tG)\u0019;f!\r\u0019B\n \t\u0004{\u0006%Q\"\u0001@\u000b\u0007}\f\t!\u0001\u0003uS6,'\u0002BA\u0002\u0003\u000b\tAA[8eC*\u0011\u0011qA\u0001\u0004_J<\u0017bAA\u0006}\nAA)\u0019;f)&lW\r\u0003\u0004\u0002\u0010\u0019\u0001\ra_\u0001\bK:$G)\u0019;f\u0011\u0015!g\u00011\u0001f\u0011\u001d\t)B\u0002a\u0001\u0003/\tqAZ5mi\u0016\u00148\u000f\u0005\u0003\u0014\u0019\u0006e\u0001cA7s1\"I\u0011Q\u0004\u0004\u0011\u0002\u0003\u0007\u0011qD\u0001\nY&<\u0007\u000e^'pI\u0016\u00042aEA\u0011\u0013\r\t\u0019\u0003\u0006\u0002\b\u0005>|G.Z1o\u0003y9W\r^(qKJ\fG/[8o\u0003:\fG._:jg\u0012\"WMZ1vYR$c'\u0006\u0002\u0002*)\"\u0011qDA\u0016W\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001c)\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0012\u0011\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aC2bY2\f\u0015/^17\u0005>$\u0012b[A!\u0003\u0007\n)%!\u0013\t\u000b]C\u0001\u0019\u0001-\t\u000b\u0011D\u0001\u0019A3\t\r\u0005\u001d\u0003\u00021\u0001Y\u0003\r)(\u000f\u001c\u0005\b\u0003\u0017B\u0001\u0019AA'\u0003\tq'\rE\u0002\u0014\u0003\u001fJ1!!\u0015\u0015\u0005\rIe\u000e\u001e")
public class Aqua6boSurfaceQualitometerDao {
    private final LogUtil LogUtil;
    private final WSClient ws;
    private final JobLogUtil JobLogUtil;

    public Option<SurfaceQualitometerStationInput> getStation(String stationCode, Option<Object> jobExecutionId) {
        String url = new StringBuilder(0).append(SurfaceQualitometerConstants$.MODULE$.STATION_URL()).append(stationCode).toString();
        JobParametersUtil$.MODULE$.jobLog(jobExecutionId, JobState$.MODULE$.INFO(), "Start station integration", stationCode, "", this.JobLogUtil);
        JobParametersUtil$.MODULE$.jobLog(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(11).append("Call url : ").append(url).toString(), stationCode, "", this.JobLogUtil);
        return WSUtil$.MODULE$.getWithAuthOneTry(url, 4, new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)404), (JFunction0.mcV.sp & Serializable)() -> JobParametersUtil$.MODULE$.jobLog(jobExecutionId, JobState$.MODULE$.INFO(), "Station not found (404)", stationCode, "", $this.JobLogUtil), (Object)None$.MODULE$), (List)Nil$.MODULE$), WSUtil$.MODULE$.getWithAuthOneTry$default$4(), SurfaceQualitometerStationInput$.MODULE$.writes(), this.ws);
    }

    public Option<Seq<SurfaceQualitometerOperationInput>> getOperationAnalysis(String stationCode, Option<DateTime> beginDate, Option<DateTime> endDate, Option<Object> jobExecutionId, Option<Seq<String>> filters, boolean lightMode) {
        String defaultUrl = new StringBuilder(0).append(SurfaceQualitometerConstants$.MODULE$.OPERATION_ANALYSIS_URL()).append(stationCode).toString();
        String filterDate = (String)beginDate.map((Function1 & Serializable)d -> new StringBuilder(11).append("&beginDate=").append(Long.toString(d.getMillis())).toString()).getOrElse((Function0 & Serializable)() -> "");
        String filterDateEnd = (String)endDate.map((Function1 & Serializable)d -> new StringBuilder(9).append("&endDate=").append(Long.toString(d.getMillis())).toString()).getOrElse((Function0 & Serializable)() -> "");
        String filterParameters = (String)filters.map((Function1 & Serializable)f -> new StringBuilder(12).append("&parameters=").append(f.mkString(",")).toString()).getOrElse((Function0 & Serializable)() -> "");
        if (lightMode) {
            String url = new StringBuilder(15).append(defaultUrl).append(filterDate).append(filterDateEnd).append("&lightMode=true").toString();
            JobParametersUtil$.MODULE$.jobLog(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(23).append("Call Aqua6BO with url: ").append(url).toString(), stationCode, "", this.JobLogUtil);
            return this.callAqua6Bo(stationCode, jobExecutionId, url, 1);
        }
        String url = new StringBuilder(0).append(defaultUrl).append(filterDate).append(filterParameters).toString();
        JobParametersUtil$.MODULE$.jobLog(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(23).append("Call Aqua6BO with url: ").append(url).toString(), stationCode, "", this.JobLogUtil);
        return WSUtil$.MODULE$.getWithAuthOneTry(url, 4, new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)404), (JFunction0.mcV.sp & Serializable)() -> JobParametersUtil$.MODULE$.jobLog(jobExecutionId, JobState$.MODULE$.INFO(), "Station not found (404)", stationCode, "", $this.JobLogUtil), (Object)None$.MODULE$), (List)Nil$.MODULE$), WSUtil$.MODULE$.getWithAuthOneTry$default$4(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), SurfaceQualitometerOperationInput$.MODULE$.writes()), this.ws);
    }

    public boolean getOperationAnalysis$default$6() {
        return false;
    }

    public Option<Seq<SurfaceQualitometerOperationInput>> callAqua6Bo(String stationCode, Option<Object> jobExecutionId, String url, int nb) {
        String x$1 = url;
        Reads x$2 = Reads$.MODULE$.seq(SurfaceQualitometerOperationInput$.MODULE$.reads());
        .colon.colon x$3 = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)404), (JFunction0.mcV.sp & Serializable)() -> JobParametersUtil$.MODULE$.jobLog(jobExecutionId, JobState$.MODULE$.INFO(), "Station not found (404)", stationCode, "", $this.JobLogUtil), (Object)package$.MODULE$.Left().apply((Object)Nil$.MODULE$)), (List)Nil$.MODULE$);
        Option<Tuple2<String, String>> x$4 = WSUtil$.MODULE$.getWithAuthWithReads$default$3();
        Future future = WSUtil$.MODULE$.getWithAuthWithReads(x$1, x$2, x$4, x$3, this.ws);
        Either either = (Either)Await$.MODULE$.result(future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(15)).minutes());
        if (either instanceof Left) {
            Left left = (Left)either;
            Seq operations = (Seq)left.value();
            return new Some((Object)operations);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Exception e = (Exception)right.value();
            if (nb == 4) {
                this.LogUtil.printError((Throwable)e);
                if (jobExecutionId.isDefined()) {
                    this.JobLogUtil.log(BoxesRunTime.unboxToLong((Object)jobExecutionId.get()), JobState$.MODULE$.ERROR(), new StringBuilder(23).append("Error during WS call : ").append(e.getMessage()).toString(), stationCode, this.JobLogUtil.log$default$5());
                }
                return None$.MODULE$;
            }
            Thread.sleep(10000L);
            return this.callAqua6Bo(stationCode, jobExecutionId, url, nb + 1);
        }
        throw new MatchError((Object)either);
    }

    @Inject
    public Aqua6boSurfaceQualitometerDao(LogUtil LogUtil2, WSClient ws, JobLogUtil JobLogUtil2) {
        this.LogUtil = LogUtil2;
        this.ws = ws;
        this.JobLogUtil = JobLogUtil2;
    }
}

