/*
 * Decompiled with CFR 0.152.
 */
package ades.controller;

import ades.AdesWSUtil;
import ades.controller.AdesFilter;
import ades.controller.AdesFilter$;
import ades.controller.piezometry.AdesPiezometryDataImport;
import ades.controller.piezometry.AdesPiezometryStationImport;
import ades.dao.rpc.StationDao;
import ades.model.Bss;
import ades.model.Bss$;
import ades.model.hubeauCall.HubeauCodesResult;
import ades.model.hubeauCall.HubeauCodesResult$;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constant.ImportMode$;
import constant.IntegrationType$;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.model.PiezometerCode;
import fr.aquasys.daeau.referentials.sandreCode.dao.SandreCodeDao;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode;
import fr.aquasys.daeau.station.links.network.StationNetwork;
import fr.aquasys.daeau.station.links.network.StationNetworkDao;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.management.InvalidApplicationException;
import org.joda.time.DateTime;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.xml.NodeSeq;
import scala.xml.XML$;
import util.WSUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001B\n\u0015\u0001eA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006Y!\f\u0005\to\u0001\u0011\t\u0011)A\u0006q!A\u0001\t\u0001B\u0001B\u0003-\u0011\t\u0003\u0005F\u0001\t\u0005\t\u0015a\u0003G\u0011!a\u0005A!A!\u0002\u0017i\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b1B,\t\u0011i\u0003!\u0011!Q\u0001\fmC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006Y!\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0006Y\"Aa\u000f\u0001B\u0001B\u0003-q\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002,\u0001!\t!!\f\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u00111\u0012\u0001\u0005\u0002\u00055\u0005bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0003'\u0004A\u0011AAk\u0011\u001d\t\t\u000f\u0001C\u0003\u0003GD\u0011B!\u0002\u0001#\u0003%)Aa\u0002\u00031\u0005#Wm\u001d)jKj|W.\u001a;ss\u000e{g\u000e\u001e:pY2,'O\u0003\u0002\u0016-\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003]\tA!\u00193fg\u000e\u00011c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0016\u000e\u0003\tR!a\t\u0013\u0002\u0007\u0005\u0004\u0018N\u0003\u0002&M\u0005A!/\u00192cSRl\u0017O\u0003\u0002(Q\u00059\u0011-];bgf\u001c(\"A\u0015\u0002\u0005\u0019\u0014\u0018BA\u0016#\u0005!\u0001&o\u001c3vG\u0016\u0014\u0018AA<t!\tqS'D\u00010\u0015\ta\u0003G\u0003\u00022e\u0005!A.\u001b2t\u0015\t\u00193GC\u00015\u0003\u0011\u0001H.Y=\n\u0005Yz#\u0001C,T\u00072LWM\u001c;\u0002\u0015M$\u0018\r^5p]\u0012\u000bw\u000e\u0005\u0002:}5\t!H\u0003\u0002<y\u0005\u0019!\u000f]2\u000b\u0005u2\u0012a\u00013b_&\u0011qH\u000f\u0002\u000b'R\fG/[8o\t\u0006|\u0017AC1eKN<6+\u0016;jYB\u0011!iQ\u0007\u0002-%\u0011AI\u0006\u0002\u000b\u0003\u0012,7oV*Vi&d\u0017\u0001G!eKN\u0004\u0016.\u001a>p[\u0016$(/\u001f#bi\u0006LU\u000e]8siB\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nF\u0001\u000ba&,'p\\7fiJL\u0018BA&I\u0005a\tE-Z:QS\u0016Tx.\\3uef$\u0015\r^1J[B|'\u000f^\u0001\u0010a&,'p\\7fi\u0016\u0014H)Y3bkB\u0011a\nV\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0004SR4'BA%S\u0015\t\u0019f%A\u0003eC\u0016\fW/\u0003\u0002V\u001f\ny\u0001+[3{_6,G/\u001a:EC\u0016\fW/A\u000eBI\u0016\u001c\b+[3{_6,GO]=Ti\u0006$\u0018n\u001c8J[B|'\u000f\u001e\t\u0003\u000fbK!!\u0017%\u00037\u0005#Wm\u001d)jKj|W.\u001a;ssN#\u0018\r^5p]&k\u0007o\u001c:u\u00035\u0019\u0016M\u001c3sK\u000e{G-\u001a#b_B\u0011ALY\u0007\u0002;*\u0011QH\u0018\u0006\u0003?\u0002\f!b]1oIJ,7i\u001c3f\u0015\t\t'+\u0001\u0007sK\u001a,'/\u001a8uS\u0006d7/\u0003\u0002d;\ni1+\u00198ee\u0016\u001cu\u000eZ3EC>\fq\u0001T8h+RLG\u000e\u0005\u0002gS6\tqM\u0003\u0002iI\u0005!Q\u000f^5m\u0013\tQwMA\u0004M_\u001e,F/\u001b7\u0002#M#\u0018\r^5p]:+Go^8sW\u0012\u000bw\u000e\u0005\u0002ni6\taN\u0003\u0002pa\u00069a.\u001a;x_J\\'BA9s\u0003\u0015a\u0017N\\6t\u0015\t\u0019(+A\u0004ti\u0006$\u0018n\u001c8\n\u0005Ut'!E*uCRLwN\u001c(fi^|'o\u001b#b_\u0006Q!j\u001c2M_\u001e,F/\u001b7\u0011\u0005a\\X\"A=\u000b\u0005i4\u0013!B;uS2\u001c\u0018B\u0001?z\u0005)QuN\u0019'pOV#\u0018\u000e\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}$b#!\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0011q\u0003\t\u0004\u0003\u0007\u0001Q\"\u0001\u000b\t\u000b1Z\u00019A\u0017\t\u000b]Z\u00019\u0001\u001d\t\u000b\u0001[\u00019A!\t\u000b\u0015[\u00019\u0001$\t\u000b1[\u00019A'\t\u000bY[\u00019A,\t\u000bi[\u00019A.\t\u000b\u0011\\\u00019A3\t\u000b-\\\u00019\u00017\t\u000bY\\\u00019A<)\u0007-\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\r%t'.Z2u\u0015\t\t)#A\u0003kCZ\f\u00070\u0003\u0003\u0002*\u0005}!AB%oU\u0016\u001cG/A\bfq\u0016\u001cW\u000f^3NC:,\u0018\r\u001c7z))\ty#!\u0012\u0002V\u0005\u0015\u0014\u0011\u000e\t\u0005\u0003c\tyD\u0004\u0003\u00024\u0005m\u0002cAA\u001b95\u0011\u0011q\u0007\u0006\u0004\u0003sA\u0012A\u0002\u001fs_>$h(C\u0002\u0002>q\ta\u0001\u0015:fI\u00164\u0017\u0002BA!\u0003\u0007\u0012aa\u0015;sS:<'bAA\u001f9!9\u0011q\t\u0007A\u0002\u0005%\u0013aB7fgN\fw-\u001a\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011q\n\u0019\u0002\t)\u001cxN\\\u0005\u0005\u0003'\niEA\u0004KgZ\u000bG.^3\t\u000f\u0005]C\u00021\u0001\u0002Z\u00059\u0001.Z1eKJ\u001c\b\u0003CA\u0019\u00037\ny#a\u0018\n\t\u0005u\u00131\t\u0002\u0004\u001b\u0006\u0004\bcA\u000e\u0002b%\u0019\u00111\r\u000f\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002h1\u0001\r!a\f\u0002\r5|G-\u001e7f\u0011\u001d\tY\u0007\u0004a\u0001\u0003_\tA!^:fe\u00069Q\r_3dkR,G\u0003BA9\u0003\u0013\u0003b!a\u001d\u0002~\u0005\re\u0002BA;\u0003srA!!\u000e\u0002x%\tQ$C\u0002\u0002|q\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0000\u0005\u0005%aA*fc*\u0019\u00111\u0010\u000f\u0011\u0007m\t))C\u0002\u0002\br\u00111!\u00138u\u0011\u001d\t9%\u0004a\u0001\u0003\u0013\nAbZ3u\u0003\u0012,7oQ8eKN$b!a$\u0002*\u0006MF\u0003BAI\u0003?\u0003b!a\u001d\u0002~\u0005M\u0005\u0003BAK\u00037k!!a&\u000b\u0007\u0005ee#A\u0003n_\u0012,G.\u0003\u0003\u0002\u001e\u0006]%a\u0001\"tg\"9\u0011\u0011\u0015\bA\u0004\u0005\r\u0016A\u00046pE\u0016CXmY;uS>t\u0017\n\u001a\t\u00047\u0005\u0015\u0016bAAT9\t!Aj\u001c8h\u0011\u001d\tYK\u0004a\u0001\u0003[\u000bqAZ5mi\u0016\u00148\u000f\u0005\u0003\u0002\u0004\u0005=\u0016bAAY)\tQ\u0011\tZ3t\r&dG/\u001a:\t\u000f\u0005Uf\u00021\u0001\u00028\u0006Q\u0001/[3{_\u000e{G-Z:\u0011\r\u0005M\u0014QPA]!\u0011\tY,a0\u000e\u0005\u0005u&bAAM#&!\u0011\u0011YA_\u00059\u0001\u0016.\u001a>p[\u0016$XM]\"pI\u0016\fAdZ3u\t\u0016\u0004\u0018M\u001d;nK:$8i\u001c3fg\u001a\u0013x.\u001c%vE\u0016\fW\u000f\u0006\u0004\u0002H\u0006-\u0017q\u001a\u000b\u0005\u0003#\u000bI\rC\u0004\u0002\">\u0001\u001d!a)\t\u000f\u00055w\u00021\u0001\u0002\u0012\u0006!A-\u0019;b\u0011\u001d\t\tn\u0004a\u0001\u0003_\t1!\u001e:m\u0003A\u0001(o\\2fgN$v.\u00113fg\n\u001b8\u000f\u0006\u0003\u0002X\u0006mG\u0003BAI\u00033Dq!!)\u0011\u0001\b\t\u0019\u000bC\u0004\u0002^B\u0001\r!a8\u0002\u000b\r|G-Z:\u0011\r\u0005M\u0014QPA\u0018\u0003m9W\r\u001e\"tg\u001a\u0013x.\\(mI\u000e{G-\u001a,jC\n\u0013v)T<ggR1\u0011Q]Ax\u0003g$B!a:\u0002nB)1$!;\u0002\u0014&\u0019\u00111\u001e\u000f\u0003\r=\u0003H/[8o\u0011\u001d\t\t+\u0005a\u0002\u0003GCq!!=\u0012\u0001\u0004\ty#\u0001\u0006oK^\u00145o]\"pI\u0016D\u0011\"!>\u0012!\u0003\u0005\r!a!\u0002\u000bI,GO]=)\u0007E\tI\u0010\u0005\u0003\u0002|\n\u0005QBAA\u007f\u0015\r\ty\u0010H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0002\u0003{\u0014q\u0001^1jYJ,7-A\u0013hKR\u00145o\u001d$s_6|E\u000eZ\"pI\u00164\u0016.\u0019\"S\u000f6;hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0002\u0016\u0005\u0003\u0007\u0013Ya\u000b\u0002\u0003\u000eA!!q\u0002B\u000b\u001b\t\u0011\tB\u0003\u0003\u0003\u0014\u0005u\u0018!C;oG\",7m[3e\u0013\u0011\u00119B!\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rK\u0002\u0001\u00057\u0001B!!\b\u0003\u001e%!!qDA\u0010\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class AdesPiezometryController
implements Producer {
    private final WSClient ws;
    private final AdesWSUtil adesWSUtil;
    private final AdesPiezometryDataImport AdesPiezometryDataImport;
    private final PiezometerDaeau piezometerDaeau;
    private final AdesPiezometryStationImport AdesPiezometryStationImport;
    private final SandreCodeDao SandreCodeDao;
    private final LogUtil LogUtil;
    private final StationNetworkDao StationNetworkDao;
    private final JobLogUtil JobLogUtil;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        AdesPiezometryController adesPiezometryController = this;
        synchronized (adesPiezometryController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public String executeManually(JsValue message, Map<String, Object> headers, String module, String user) {
        Seq<Object> results = this.execute(message);
        return Json$.MODULE$.toJson(results.map((Function1 & Serializable)id -> AdesPiezometryController.$anonfun$executeManually$1(BoxesRunTime.unboxToInt((Object)id))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)GenericData$.MODULE$.writes())).toString();
    }

    public Seq<Object> execute(JsValue message) {
        return (Seq)message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            $this.LogUtil.error(new StringBuilder(44).append("Error validate Json to execute ades model :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.LogUtil.error$default$2());
            return (Seq)Nil$.MODULE$;
        }, (Function1 & Serializable)jobParameters -> {
            long jobExecutionId = jobParameters.jobExecutionId();
            Option stationIntegration = ((IterableOnceOps)jobParameters.dataTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals(IntegrationType$.MODULE$.STATION_INTEGRATION())));
            Option dataIntegration = ((IterableOnceOps)jobParameters.dataTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(ImportMode$.MODULE$.DATA())));
            Seq sandreCodes = stationIntegration.contains((Object)IntegrationType$.MODULE$.STATION_INTEGRATION()) ? $this.SandreCodeDao.getAll() : (Seq)Nil$.MODULE$;
            BooleanRef serviceAvailable = BooleanRef.create((boolean)true);
            AdesFilter filters = (AdesFilter)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new AdesFilter(AdesFilter$.MODULE$.$lessinit$greater$default$1(), AdesFilter$.MODULE$.$lessinit$greater$default$2(), AdesFilter$.MODULE$.$lessinit$greater$default$3(), AdesFilter$.MODULE$.$lessinit$greater$default$4(), AdesFilter$.MODULE$.$lessinit$greater$default$5(), AdesFilter$.MODULE$.$lessinit$greater$default$6(), AdesFilter$.MODULE$.$lessinit$greater$default$7(), AdesFilter$.MODULE$.$lessinit$greater$default$8(), AdesFilter$.MODULE$.$lessinit$greater$default$9(), AdesFilter$.MODULE$.$lessinit$greater$default$10(), AdesFilter$.MODULE$.$lessinit$greater$default$11(), AdesFilter$.MODULE$.$lessinit$greater$default$12(), AdesFilter$.MODULE$.$lessinit$greater$default$13(), AdesFilter$.MODULE$.$lessinit$greater$default$14()), false, AdesFilter$.MODULE$.format());
            Seq piezometers = (Seq)$this.piezometerDaeau.getAllCodes($this.piezometerDaeau.getAllCodes$default$1()).$plus$plus((IterableOnce)(filters.dontCheckInternalReferences().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? Nil$.MODULE$ : $this.piezometerDaeau.getAllOldOrNewBssCodes()));
            Seq<Bss> adesCodesFound = this.getAdesCodes(filters, (Seq<PiezometerCode>)piezometers, jobExecutionId);
            Seq importedIds = (Seq)((IterableOps)adesCodesFound.zipWithIndex()).flatMap((Function1 & Serializable)x0$1 -> {
                Seq seq;
                int idx;
                block10: {
                    block11: {
                        Some some;
                        Bss piezoCode;
                        Success success;
                        Option option;
                        Try try_;
                        Failure failure;
                        boolean bl;
                        block12: {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Bss bss = (Bss)tuple2._1();
                            idx = tuple2._2$mcI$sp();
                            if (!serviceAvailable$1.elem) break block11;
                            $this.JobLogUtil.checkExecutionAbort(jobExecutionId);
                            bl = false;
                            failure = null;
                            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.AdesPiezometryStationImport.managePiezometerStations(bss, jobExecutionId, (Option<String>)stationIntegration, (String)jobParameters.user().get(), (Seq<SandreCode>)sandreCodes, filters));
                            if (!(try_ instanceof Failure)) break block12;
                            bl = true;
                            failure = (Failure)try_;
                            if (!(failure.exception() instanceof InvalidApplicationException)) break block12;
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "ADES ws unavailable, please contact ADES support. Stopping job...", "", $this.JobLogUtil.log$default$5());
                            serviceAvailable$1.elem = false;
                            seq = (Seq)Nil$.MODULE$;
                            break block10;
                        }
                        if (bl) {
                            Throwable e = failure.exception();
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error during Station integration", "", $this.JobLogUtil.log$default$5());
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", $this.JobLogUtil.log$default$5());
                            $this.LogUtil.printError(e);
                            seq = (Seq)Nil$.MODULE$;
                            break block10;
                        } else if (try_ instanceof Success && (option = (Option)(success = (Success)try_).value()) instanceof Some && (piezoCode = (Bss)(some = (Some)option).value()).id().isDefined()) {
                            Option option2 = dataIntegration;
                            if (option2 instanceof Some) {
                                String integration;
                                Some some2 = (Some)option2;
                                String string = integration = (String)some2.value();
                                String string2 = ImportMode$.MODULE$.NOTHING();
                                if (string == null ? string2 != null : !string.equals(string2)) {
                                    Some some3;
                                    Tuple3 tuple3;
                                    Success success2;
                                    Option option3;
                                    Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.adesWSUtil.callADESPiezoMeasuresNew(piezoCode, jobExecutionId, ((IterableOnceOps)jobParameters.dataTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains(ImportMode$.MODULE$.ADD_LAST_DATA())))));
                                    if (try_2 instanceof Success && (option3 = (Option)(success2 = (Success)try_2).value()) instanceof Some && (tuple3 = (Tuple3)(some3 = (Some)option3).value()) != null) {
                                        int measureCote = BoxesRunTime.unboxToInt((Object)tuple3._1());
                                        Bss adesBss = (Bss)tuple3._2();
                                        NodeSeq chronicles = (NodeSeq)tuple3._3();
                                        BoxesRunTime.boxToInteger((int)$this.AdesPiezometryDataImport.insertMeasures(chronicles, adesBss.wantedCode(), BoxesRunTime.unboxToDouble((Object)adesBss.id().get()), jobExecutionId, measureCote, (String)jobParameters.user().get(), integration, filters.dataManager(), filters.excludedProducers()));
                                    } else if (try_2 instanceof Failure) {
                                        Failure failure2 = (Failure)try_2;
                                        Throwable e = failure2.exception();
                                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error during measures integration", "", $this.JobLogUtil.log$default$5());
                                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", $this.JobLogUtil.log$default$5());
                                        $this.LogUtil.printError(e);
                                    }
                                }
                            }
                            seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{(int)BoxesRunTime.unboxToDouble((Object)piezoCode.id().get())}));
                            break block10;
                        } else {
                            seq = (Seq)Nil$.MODULE$;
                        }
                        break block10;
                    }
                    seq = (Seq)Nil$.MODULE$;
                }
                Seq res = seq;
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.PROGRESS(), Integer.toString((int)(((double)idx + 1.0) * 100.0 / (double)adesCodesFound.length())), "", $this.JobLogUtil.log$default$5());
                return res;
            });
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.STATION_IDS(), importedIds.mkString(","), "", $this.JobLogUtil.log$default$5());
            return importedIds;
        });
    }

    public Seq<Bss> getAdesCodes(AdesFilter filters, Seq<PiezometerCode> piezoCodes, long jobExecutionId) {
        Seq seq;
        block4: {
            String string = filters.selectStationsMode();
            switch (string == null ? 0 : string.hashCode()) {
                case -1109706007: {
                    if (!"codesMode".equals(string)) break;
                    Seq stringCodes = (Seq)((IterableOps)filters.stationCodes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable)c -> c.toUpperCase().split("/")[0].trim());
                    seq = this.processToAdesBss((Seq<String>)stringCodes, jobExecutionId);
                    break block4;
                }
                case -872620994: {
                    Seq results;
                    if (!"filtersMode".equals(string)) break;
                    Seq departmentCodes = (Seq)filters.departmentCodes().map((Function1 & Serializable)codes -> (Seq)ArrayOps$.MODULE$.grouped$extension(Predef$.MODULE$.refArrayOps((Object[])codes.split(",")), 50).toSeq().flatMap((Function1 & Serializable)codesGroup -> this.getDepartmentCodesFromHubeau((Seq<Bss>)((Seq)Nil$.MODULE$), new StringBuilder(124).append("https://hubeau.eaufrance.fr/api/v1/niveaux_nappes/stations?code_departement=").append(Predef$.MODULE$.wrapRefArray((Object[])codesGroup).mkString("%2C")).append("&fields=bss_id%2Ccode_bss&format=json&size=20000").toString(), jobExecutionId))).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    Seq networkCodes = (Seq)filters.network().map((Function1 & Serializable)networkId -> AdesPiezometryController.$anonfun$getAdesCodes$6(this, piezoCodes, jobExecutionId, BoxesRunTime.unboxToInt((Object)networkId))).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    seq = results = (Seq)departmentCodes.$plus$plus((IterableOnce)networkCodes);
                    break block4;
                }
            }
            throw new MatchError((Object)string);
        }
        Seq codesWithoutId = seq;
        return (Seq)codesWithoutId.map((Function1 & Serializable)adesCode -> {
            Option option = piezoCodes.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AdesPiezometryController.$anonfun$getAdesCodes$12(adesCode, p)));
            if (option instanceof Some) {
                Some some = (Some)option;
                PiezometerCode piezoFound = (PiezometerCode)some.value();
                Some x$1 = new Some((Object)BoxesRunTime.boxToDouble((double)piezoFound.id()));
                String x$2 = adesCode.copy$default$1();
                Option<String> x$3 = adesCode.copy$default$2();
                Option<String> x$4 = adesCode.copy$default$3();
                Option<String> x$5 = adesCode.copy$default$5();
                return adesCode.copy(x$2, x$3, x$4, (Option<Object>)x$1, x$5);
            }
            if (None$.MODULE$.equals(option)) {
                return adesCode;
            }
            throw new MatchError((Object)option);
        });
    }

    public Seq<Bss> getDepartmentCodesFromHubeau(Seq<Bss> data, String url, long jobExecutionId) {
        Option<HubeauCodesResult> promise = WSUtil$.MODULE$.simpleGet(url, WSUtil$.MODULE$.simpleGet$default$2(), WSUtil$.MODULE$.simpleGet$default$3(), HubeauCodesResult$.MODULE$.format(), this.ws);
        Option<HubeauCodesResult> option = promise;
        if (None$.MODULE$.equals(option)) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error while getting codes from department via hubeau", "", this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(37).append("Error calling hubeau with this url : ").append(url).toString(), "", this.JobLogUtil.log$default$5());
            return (Seq)Nil$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            HubeauCodesResult result = (HubeauCodesResult)some.value();
            Option<String> option2 = result.next();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String nextUrl = (String)some2.value();
                return this.getDepartmentCodesFromHubeau((Seq<Bss>)((Seq)data.$plus$plus((IterableOnce)result.data().map((Function1 & Serializable)d -> new Bss((String)d.bss_id().getOrElse((Function0 & Serializable)() -> d.code_bss()), (Option<String>)new Some((Object)d.code_bss()), d.bss_id(), (Option<Object>)None$.MODULE$, Bss$.MODULE$.$lessinit$greater$default$5())))), nextUrl, jobExecutionId);
            }
            return (Seq)data.$plus$plus((IterableOnce)result.data().map((Function1 & Serializable)d -> new Bss((String)d.bss_id().getOrElse((Function0 & Serializable)() -> d.code_bss()), (Option<String>)new Some((Object)d.code_bss().toUpperCase()), (Option<String>)d.bss_id().map((Function1 & Serializable)x$4 -> x$4.toUpperCase()), (Option<Object>)None$.MODULE$, Bss$.MODULE$.$lessinit$greater$default$5())));
        }
        throw new MatchError(option);
    }

    public Seq<Bss> processToAdesBss(Seq<String> codes, long jobExecutionId) {
        Tuple2 tuple2 = codes.partition((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)AdesPiezometryController.$anonfun$processToAdesBss$1(c)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq newCodes = (Seq)tuple2._1();
        Seq oldCodes = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)newCodes, (Object)oldCodes);
        Seq newCodes2 = (Seq)tuple22._1();
        Seq oldCodes2 = (Seq)tuple22._2();
        Seq oldCodesBss = (Seq)oldCodes2.map((Function1 & Serializable)c -> new Bss((String)c, (Option<String>)new Some((Object)c.toUpperCase()), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, Bss$.MODULE$.$lessinit$greater$default$5()));
        Seq newFromHubeau = (Seq)newCodes2.grouped(200).toSeq().flatMap((Function1 & Serializable)groupCodes -> {
            String url = new StringBuilder(114).append("https://hubeau.eaufrance.fr/api/v1/niveaux_nappes/stations?bss_id=").append(groupCodes.mkString("%2C%20")).append("&fields=bss_id%2Ccode_bss&format=json&size=20000").toString();
            Option<HubeauCodesResult> promise = WSUtil$.MODULE$.simpleGet(url, WSUtil$.MODULE$.simpleGet$default$2(), WSUtil$.MODULE$.simpleGet$default$3(), HubeauCodesResult$.MODULE$.format(), $this.ws);
            Option<HubeauCodesResult> option = promise;
            if (None$.MODULE$.equals(option)) {
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error while getting old codes from new codes via hubeau", "", $this.JobLogUtil.log$default$5());
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(37).append("Error calling hubeau with this url : ").append(url).toString(), "", $this.JobLogUtil.log$default$5());
                return Nil$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                HubeauCodesResult result = (HubeauCodesResult)some.value();
                return (IterableOnce)result.data().map((Function1 & Serializable)d -> new Bss((String)d.bss_id().getOrElse((Function0 & Serializable)() -> d.code_bss()), (Option<String>)new Some((Object)d.code_bss().toUpperCase()), (Option<String>)d.bss_id().map((Function1 & Serializable)x$6 -> x$6.toUpperCase()), Bss$.MODULE$.$lessinit$greater$default$4(), Bss$.MODULE$.$lessinit$greater$default$5()));
            }
            throw new MatchError(option);
        });
        Seq oldFromHubeau = (Seq)oldCodes2.grouped(200).toSeq().flatMap((Function1 & Serializable)groupCodes -> {
            String url = new StringBuilder(116).append("https://hubeau.eaufrance.fr/api/v1/niveaux_nappes/stations?code_bss=").append(((IterableOnceOps)groupCodes.map((Function1 & Serializable)x$7 -> x$7.replace("/", "%2F"))).mkString("%2C%20")).append("&fields=bss_id%2Ccode_bss&format=json&size=20000").toString();
            Option<HubeauCodesResult> promise = WSUtil$.MODULE$.simpleGet(url, WSUtil$.MODULE$.simpleGet$default$2(), WSUtil$.MODULE$.simpleGet$default$3(), HubeauCodesResult$.MODULE$.format(), $this.ws);
            Option<HubeauCodesResult> option = promise;
            if (None$.MODULE$.equals(option)) {
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error while getting old codes from new codes via hubeau", "", $this.JobLogUtil.log$default$5());
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(37).append("Error calling hubeau with this url : ").append(url).toString(), "", $this.JobLogUtil.log$default$5());
                return Nil$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                HubeauCodesResult result = (HubeauCodesResult)some.value();
                return (IterableOnce)result.data().map((Function1 & Serializable)d -> new Bss(d.code_bss(), (Option<String>)new Some((Object)d.code_bss().toUpperCase()), (Option<String>)d.bss_id().map((Function1 & Serializable)x$8 -> x$8.toUpperCase()), Bss$.MODULE$.$lessinit$greater$default$4(), Bss$.MODULE$.$lessinit$greater$default$5()));
            }
            throw new MatchError(option);
        });
        Seq notFoundHubeau = (Seq)((IterableOps)newCodes2.filter((Function1 & Serializable)code -> BoxesRunTime.boxToBoolean((boolean)AdesPiezometryController.$anonfun$processToAdesBss$11(newFromHubeau, code)))).flatMap((Function1 & Serializable)code -> this.getBssFromOldCodeViaBRGMwfs((String)code, this.getBssFromOldCodeViaBRGMwfs$default$2(), jobExecutionId));
        return (Seq)((IterableOps)((IterableOps)oldCodesBss.$plus$plus((IterableOnce)oldFromHubeau)).$plus$plus((IterableOnce)newFromHubeau)).$plus$plus((IterableOnce)notFoundHubeau);
    }

    public final Option<Bss> getBssFromOldCodeViaBRGMwfs(String newBssCode, int retry, long jobExecutionId) {
        Try try_;
        block5: {
            Try try_2;
            block6: {
                String res;
                while (true) {
                    String filter;
                    if (retry == 0) {
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(49).append("Code ").append(newBssCode).append(" not found on hubeau, calling BRGM WFS... : ").toString(), newBssCode, this.JobLogUtil.log$default$5());
                    }
                    if ((try_ = Try$.MODULE$.apply(() -> AdesPiezometryController.$anonfun$getBssFromOldCodeViaBRGMwfs$1(this, filter = new StringBuilder(145).append("<Filter><PropertyIsLike wildcard='*' singleChar='.' escape='!'><PropertyName>bss_id</PropertyName><Literal>*").append(newBssCode).append("*</Literal></PropertyIsLike></Filter>").toString()))) instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable err = failure.exception();
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(29).append("Error during BRGM WFS call : ").append(err.getMessage()).toString(), newBssCode, this.JobLogUtil.log$default$5());
                        this.LogUtil.printError(err);
                        return None$.MODULE$;
                    }
                    if (!(try_ instanceof Success)) break block5;
                    Success success = (Success)try_;
                    String result = (String)success.value();
                    try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> XML$.MODULE$.loadString(result).$bslash$bslash("code_bss").text());
                    if (try_2 instanceof Failure) {
                        Failure failure = (Failure)try_2;
                        Throwable err = failure.exception();
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "Code not found on BRGM WFS", newBssCode, this.JobLogUtil.log$default$5());
                        this.LogUtil.printError(err);
                        return None$.MODULE$;
                    }
                    if (!(try_2 instanceof Success)) break block6;
                    Success success2 = (Success)try_2;
                    res = (String)success2.value();
                    if (!res.trim().isEmpty() || retry > 3) break;
                    ++retry;
                }
                if (res.trim().isEmpty()) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(42).append("Code ").append(newBssCode).append(" not found, with call retried 3 times").toString(), newBssCode, this.JobLogUtil.log$default$5());
                    return new Some((Object)new Bss(newBssCode, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)newBssCode), Bss$.MODULE$.apply$default$4(), Bss$.MODULE$.apply$default$5()));
                }
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(58).append("Code ").append(newBssCode).append(" successfully fetched from BRGM WFS, oldcode found : ").append(res).toString(), newBssCode, this.JobLogUtil.log$default$5());
                return new Some((Object)new Bss(newBssCode, (Option<String>)new Some((Object)res.toUpperCase()), (Option<String>)new Some((Object)newBssCode), Bss$.MODULE$.apply$default$4(), Bss$.MODULE$.apply$default$5()));
            }
            throw new MatchError((Object)try_2);
        }
        throw new MatchError((Object)try_);
    }

    public final int getBssFromOldCodeViaBRGMwfs$default$2() {
        return 0;
    }

    public static final /* synthetic */ GenericData $anonfun$executeManually$1(int id) {
        DateTime x$1 = new DateTime();
        DateTime x$2 = new DateTime();
        int x$3 = id;
        None$ x$4 = None$.MODULE$;
        Option x$5 = GenericData$.MODULE$.$lessinit$greater$default$5();
        Option x$6 = GenericData$.MODULE$.$lessinit$greater$default$6();
        Option x$7 = GenericData$.MODULE$.$lessinit$greater$default$7();
        Option x$8 = GenericData$.MODULE$.$lessinit$greater$default$8();
        Option x$9 = GenericData$.MODULE$.$lessinit$greater$default$9();
        Option x$10 = GenericData$.MODULE$.$lessinit$greater$default$10();
        Option x$11 = GenericData$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = GenericData$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = GenericData$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = GenericData$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = GenericData$.MODULE$.$lessinit$greater$default$15();
        return new GenericData(x$1, x$2, (Option)x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
    }

    public static final /* synthetic */ boolean $anonfun$getAdesCodes$8(StationNetwork nl$1, PiezometerCode p) {
        return (int)p.id() == nl$1.idStation();
    }

    public static final /* synthetic */ Seq $anonfun$getAdesCodes$6(AdesPiezometryController $this, Seq piezoCodes$1, long jobExecutionId$2, int networkId) {
        Seq networkStations = $this.StationNetworkDao.getStations(StationTypeUtil$.MODULE$.PIEZOMETRY(), networkId);
        return $this.processToAdesBss((Seq<String>)((Seq)networkStations.flatMap((Function1 & Serializable)nl -> piezoCodes$1.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AdesPiezometryController.$anonfun$getAdesCodes$8(nl, p))).map((Function1 & Serializable)p -> p.code()))), jobExecutionId$2);
    }

    public static final /* synthetic */ boolean $anonfun$getAdesCodes$12(Bss adesCode$1, PiezometerCode p) {
        return adesCode$1.oldCode().map((Function1 & Serializable)old -> old.split("/")[0]).contains((Object)p.code()) || adesCode$1.newCode().map((Function1 & Serializable)c -> c.split("/")[0]).contains((Object)p.code());
    }

    public static final /* synthetic */ boolean $anonfun$processToAdesBss$1(String c) {
        return c.toUpperCase().startsWith("BSS");
    }

    public static final /* synthetic */ boolean $anonfun$processToAdesBss$12(String code$1, Bss bss) {
        return bss.newCode().contains((Object)code$1);
    }

    public static final /* synthetic */ boolean $anonfun$processToAdesBss$11(Seq newFromHubeau$1, String code) {
        return !newFromHubeau$1.exists((Function1 & Serializable)bss -> BoxesRunTime.boxToBoolean((boolean)AdesPiezometryController.$anonfun$processToAdesBss$12(code, bss)));
    }

    public static final /* synthetic */ String $anonfun$getBssFromOldCodeViaBRGMwfs$1(AdesPiezometryController $this, String filter$1) {
        return WSUtil$.MODULE$.getAsString(new StringBuilder(151).append("http://mapsref.brgm.fr/wxs/infoterre/catalogue?SERVICE=WFS&VERSION=2.0.0&REQUEST=GetFeature&TYPENAME=BSS_EAU_POINT&PROPERTYNAME=code_bss,bss_id&Filter=").append(URLEncoder.encode(filter$1, "UTF-8")).toString(), $this.ws);
    }

    @Inject
    public AdesPiezometryController(WSClient ws, StationDao stationDao, AdesWSUtil adesWSUtil, AdesPiezometryDataImport AdesPiezometryDataImport2, PiezometerDaeau piezometerDaeau, AdesPiezometryStationImport AdesPiezometryStationImport2, SandreCodeDao SandreCodeDao2, LogUtil LogUtil2, StationNetworkDao StationNetworkDao2, JobLogUtil JobLogUtil2) {
        this.ws = ws;
        this.adesWSUtil = adesWSUtil;
        this.AdesPiezometryDataImport = AdesPiezometryDataImport2;
        this.piezometerDaeau = piezometerDaeau;
        this.AdesPiezometryStationImport = AdesPiezometryStationImport2;
        this.SandreCodeDao = SandreCodeDao2;
        this.LogUtil = LogUtil2;
        this.StationNetworkDao = StationNetworkDao2;
        this.JobLogUtil = JobLogUtil2;
        Producer.$init$((Producer)this);
    }
}

