/*
 * Decompiled with CFR 0.152.
 */
package ades.controller.piezometry;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.referentials.contributor.itf.ContributorsDao;
import fr.aquasys.daeau.referentials.contributor.model.ContributorLight;
import fr.aquasys.daeau.referentials.contributor.model.ContributorLight$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.AlgoUtil$;
import fr.aquasys.utils.JobLogUtil;
import genericImport.itf.GenericImportDao;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import play.api.libs.json.Reads;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.xml.NodeSeq;
import util.DateUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001B\u0004\t\u0001=A\u0001B\t\u0001\u0003\u0002\u0003\u0006Ya\t\u0005\tS\u0001\u0011\t\u0011)A\u0006U!A!\u0007\u0001B\u0001B\u0003-1\u0007\u0003\u0005:\u0001\t\u0005\t\u0015a\u0003;\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u00159\u0006\u0001\"\u0001Y\u0005a\tE-Z:QS\u0016Tx.\\3uef$\u0015\r^1J[B|'\u000f\u001e\u0006\u0003\u0013)\t!\u0002]5fu>lW\r\u001e:z\u0015\tYA\"\u0001\u0006d_:$(o\u001c7mKJT\u0011!D\u0001\u0005C\u0012,7o\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/\u0001j\u0011\u0001\u0007\u0006\u00033i\t1!\u00199j\u0015\tYB$\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0015\tib$A\u0004bcV\f7/_:\u000b\u0003}\t!A\u001a:\n\u0005\u0005B\"\u0001\u0003)s_\u0012,8-\u001a:\u0002\u000f1{w-\u0016;jYB\u0011AeJ\u0007\u0002K)\u0011aEG\u0001\u0005kRLG.\u0003\u0002)K\t9Aj\\4Vi&d\u0017\u0001E4f]\u0016\u0014\u0018nY%na>\u0014H\u000fR1p!\tY\u0003'D\u0001-\u0015\tic&A\u0002ji\u001aT\u0011aL\u0001\u000eO\u0016tWM]5d\u00136\u0004xN\u001d;\n\u0005Eb#\u0001E$f]\u0016\u0014\u0018nY%na>\u0014H\u000fR1p\u0003)QuN\u0019'pOV#\u0018\u000e\u001c\t\u0003i]j\u0011!\u000e\u0006\u0003mq\tQ!\u001e;jYNL!\u0001O\u001b\u0003\u0015){'\rT8h+RLG.A\bD_:$(/\u001b2vi>\u00148\u000fR1p!\tY4)D\u0001=\u0015\tiSH\u0003\u0002?\u007f\u0005Y1m\u001c8ue&\u0014W\u000f^8s\u0015\t\u0001\u0015)\u0001\u0007sK\u001a,'/\u001a8uS\u0006d7O\u0003\u0002C9\u0005)A-Y3bk&\u0011A\t\u0010\u0002\u0010\u0007>tGO]5ckR|'o\u001d#b_\u00061A(\u001b8jiz\"\u0012a\u0012\u000b\u0006\u0011*[E*\u0014\t\u0003\u0013\u0002i\u0011\u0001\u0003\u0005\u0006E\u0015\u0001\u001da\t\u0005\u0006S\u0015\u0001\u001dA\u000b\u0005\u0006e\u0015\u0001\u001da\r\u0005\u0006s\u0015\u0001\u001dA\u000f\u0015\u0003\u000b=\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\r%t'.Z2u\u0015\u0005!\u0016!\u00026bm\u0006D\u0018B\u0001,R\u0005\u0019IeN[3di\u0006q\u0011N\\:feRlU-Y:ve\u0016\u001cH\u0003D-]IF480`@\u0002\u0004\u00055\u0001CA\t[\u0013\tY&CA\u0002J]RDQ!\u0018\u0004A\u0002y\u000bQb\u00195s_:L7\r\\3t16d\u0007CA0c\u001b\u0005\u0001'BA1\u0013\u0003\rAX\u000e\\\u0005\u0003G\u0002\u0014qAT8eKN+\u0017\u000fC\u0003f\r\u0001\u0007a-A\u0002cgN\u0004\"a\u001a8\u000f\u0005!d\u0007CA5\u0013\u001b\u0005Q'BA6\u000f\u0003\u0019a$o\\8u}%\u0011QNE\u0001\u0007!J,G-\u001a4\n\u0005=\u0004(AB*ue&twM\u0003\u0002n%!)!O\u0002a\u0001g\u0006a\u0001/[3{_6,G/\u001a:JIB\u0011\u0011\u0003^\u0005\u0003kJ\u0011a\u0001R8vE2,\u0007\"B<\u0007\u0001\u0004A\u0018A\u00046pE\u0016CXmY;uS>t\u0017\n\u001a\t\u0003#eL!A\u001f\n\u0003\t1{gn\u001a\u0005\u0006y\u001a\u0001\r!W\u0001\fG>$X-T3bgV\u0014X\rC\u0003\u007f\r\u0001\u0007a-\u0001\u0003vg\u0016\u0014\bBBA\u0001\r\u0001\u0007a-\u0001\u0006j[B|'\u000f^'pI\u0016Dq!!\u0002\u0007\u0001\u0004\t9!A\u0006eCR\fW*\u00198bO\u0016\u0014\b\u0003B\t\u0002\neK1!a\u0003\u0013\u0005\u0019y\u0005\u000f^5p]\"9\u0011q\u0002\u0004A\u0002\u0005E\u0011!E3yG2,H-\u001a3Qe>$WoY3sgB)\u0011#!\u0003\u0002\u0014A)\u0011QCA\u00103:!\u0011qCA\u000e\u001d\rI\u0017\u0011D\u0005\u0002'%\u0019\u0011Q\u0004\n\u0002\u000fA\f7m[1hK&!\u0011\u0011EA\u0012\u0005\r\u0019V-\u001d\u0006\u0004\u0003;\u0011\u0002f\u0001\u0001\u0002(A\u0019\u0001+!\u000b\n\u0007\u0005-\u0012KA\u0005TS:<G.\u001a;p]\u0002")
public class AdesPiezometryDataImport
implements Producer {
    private final LogUtil LogUtil;
    private final GenericImportDao genericImportDao;
    private final JobLogUtil JobLogUtil;
    private final ContributorsDao ContributorsDao;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        AdesPiezometryDataImport adesPiezometryDataImport = this;
        synchronized (adesPiezometryDataImport) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public int insertMeasures(NodeSeq chroniclesXml, String bss, double piezometerId, long jobExecutionId, int coteMeasure, String user, String importMode, Option<Object> dataManager, Option<Seq<Object>> excludedProducers) {
        int n;
        Seq filteredMeasures;
        Map contributors = ((IterableOnceOps)AlgoUtil$.MODULE$.uniqBy((Seq)chroniclesXml, (Function1 & Serializable)node -> Try$.MODULE$.apply((Function0 & Serializable)() -> node.$bslash$bslash("CdIntervenant").text()).toOption()).flatMap((Function1 & Serializable)node -> Try$.MODULE$.apply((Function0 & Serializable)() -> node.$bslash$bslash("CdIntervenant").text()).toOption().map((Function1 & Serializable)code -> {
            None$ x$1 = None$.MODULE$;
            None$ x$2 = code.length() > 10 ? new Some(code) : None$.MODULE$;
            None$ x$3 = code.length() < 10 ? new Some(code) : None$.MODULE$;
            Option x$4 = Try$.MODULE$.apply((Function0 & Serializable)() -> node.$bslash$bslash("NomIntervenant").text()).toOption();
            Some x$5 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId));
            Option x$6 = ContributorLight$.MODULE$.apply$default$6();
            Option x$7 = ContributorLight$.MODULE$.apply$default$7();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(code), (Object)new ContributorLight((Option)x$1, (Option)x$2, x$4, (Option)x$3, (Option)x$5, x$6, x$7));
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map contributorMap = (Map)contributors.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                ContributorLight c = (ContributorLight)tuple2._2();
                return new Tuple2((Object)key, $this.ContributorsDao.createContributors((Seq)new .colon.colon((Object)c, (List)Nil$.MODULE$), (Option)new Some((Object)user)).head());
            }
            throw new MatchError((Object)tuple2);
        });
        Seq measures = (Seq)chroniclesXml.map((Function1 & Serializable)xml -> {
            DateTime measureDate = DateUtil$.MODULE$.dateFormater().parseDateTime(xml.$bslash("DateMesure").text());
            DateTime hour = DateUtil$.MODULE$.hourFormater().parseDateTime(xml.$bslash("HeureMesure").text());
            DateTime fullDate = measureDate.withTime(hour.hourOfDay().get(), hour.minuteOfHour().get(), hour.secondOfMinute().get(), hour.millisOfSecond().get());
            Option respValidation = Try$.MODULE$.apply((Function0 & Serializable)() -> xml.$bslash$bslash("CdIntervenant").text()).toOption().flatMap((Function1 & Serializable)code -> contributorMap.get(code).flatMap((Function1 & Serializable)contrib -> contrib.id()));
            return new GenericData(fullDate, fullDate, Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(xml.$bslash("ValeurMesure").text()))).toOption(), -1, Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(xml.$bslash("StatutAcqMesure").text()))).toOption(), Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(xml.$bslash("ConformiteAcqMesure").text()))).toOption(), Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(xml.$bslash("ModeObtentionMesure").text()))).toOption(), respValidation, respValidation, dataManager, Try$.MODULE$.apply((Function0 & Serializable)() -> xml.$bslash("NatureMesure").text()).toOption(), Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(xml.$bslash("CdContinuiteMesure").text()))).toOption(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15());
        });
        Seq seq = filteredMeasures = excludedProducers.isDefined() ? (Seq)measures.filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)AdesPiezometryDataImport.$anonfun$insertMeasures$18(excludedProducers, m))) : measures;
        if (filteredMeasures.isEmpty()) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No measures found on ADES call", bss, this.JobLogUtil.log$default$5());
            return 0;
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(51).append(filteredMeasures.length()).append(" measures fetched, begin integration in database...").toString(), bss, this.JobLogUtil.log$default$5());
        try {
            Some x$8 = new Some((Object)importMode);
            Some x$9 = new Some((Object)BoxesRunTime.boxToInteger((int)coteMeasure));
            Option<Object> x$10 = ImportOptions$.MODULE$.apply$default$1();
            Option<String> x$11 = ImportOptions$.MODULE$.apply$default$4();
            Option<Object> x$12 = ImportOptions$.MODULE$.apply$default$5();
            Option<Seq<Object>> x$13 = ImportOptions$.MODULE$.apply$default$6();
            Option<Object> x$14 = ImportOptions$.MODULE$.apply$default$7();
            Some options = new Some((Object)new ImportOptions(x$10, (Option<String>)x$8, (Option<Object>)x$9, x$11, x$12, x$13, x$14));
            int result = this.genericImportDao.importPiezometry(Double.toString(piezometerId), bss, user, jobExecutionId, (Seq<GenericData>)filteredMeasures, (Option<ImportOptions>)options);
            if (result > 0) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(34).append(result).append(" measures integrated with success.").toString(), bss, this.JobLogUtil.log$default$5());
            } else {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No measures integrated.", bss, this.JobLogUtil.log$default$5());
            }
            n = result;
        }
        catch (InterruptedException interupted) {
            throw interupted;
        }
        catch (Exception exception) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), exception.getMessage(), bss, this.JobLogUtil.log$default$5());
            this.LogUtil.printError((Throwable)exception);
            n = 0;
        }
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$insertMeasures$18(Option excludedProducers$1, GenericData m) {
        return m.producer().isEmpty() || !((SeqOps)excludedProducers$1.get()).contains(m.producer().get());
    }

    @Inject
    public AdesPiezometryDataImport(LogUtil LogUtil2, GenericImportDao genericImportDao, JobLogUtil JobLogUtil2, ContributorsDao ContributorsDao2) {
        this.LogUtil = LogUtil2;
        this.genericImportDao = genericImportDao;
        this.JobLogUtil = JobLogUtil2;
        this.ContributorsDao = ContributorsDao2;
        Producer.$init$((Producer)this);
    }
}

