/*
 * Decompiled with CFR 0.152.
 */
package ades.controller.piezometry;

import ades.AdesWSUtil;
import ades.controller.AdesFilter;
import ades.dao.piezometry.ADESPiezometerDao;
import ades.domain.piezometry.AdesNetworkLink;
import ades.domain.piezometry.AdesPiezometer;
import ades.domain.piezometry.AdesPiezometer$;
import ades.model.Bss;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constant.IntegrationType$;
import constant.JobState$;
import fr.aquasys.daeau.piezometry.domain.PiezometerWithLinks;
import fr.aquasys.daeau.piezometry.domain.PiezometerWithLinks$;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.model.Piezometer;
import fr.aquasys.daeau.piezometry.model.Piezometer$;
import fr.aquasys.daeau.piezometry.model.PiezometryEvent;
import fr.aquasys.daeau.piezometry.model.PiezometryEvent$;
import fr.aquasys.daeau.referentials.city.model.City;
import fr.aquasys.daeau.referentials.city.model.City$;
import fr.aquasys.daeau.referentials.contributor.itf.ContributorsDao;
import fr.aquasys.daeau.referentials.contributor.model.ContributorLight;
import fr.aquasys.daeau.referentials.contributor.model.ContributorLight$;
import fr.aquasys.daeau.referentials.network.model.Network;
import fr.aquasys.daeau.referentials.network.model.Network$;
import fr.aquasys.daeau.referentials.sandreCode.constants.SandreConstants$;
import fr.aquasys.daeau.referentials.sandreCode.dao.SandreCodeDao;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode$;
import fr.aquasys.daeau.referentials.watermass.model.Watermass;
import fr.aquasys.daeau.referentials.watermass.model.Watermass$;
import fr.aquasys.daeau.station.links.altimetrySystem.AltimetrySystem;
import fr.aquasys.daeau.station.links.altimetrySystem.AltimetrySystem$;
import fr.aquasys.daeau.station.links.despoliationMode.DespoliationMode;
import fr.aquasys.daeau.station.links.functions.StationFunction;
import fr.aquasys.daeau.station.links.hydroEntity.StationHydroEntity;
import fr.aquasys.daeau.station.links.landmark.Landmark;
import fr.aquasys.daeau.station.links.landmark.Landmark$;
import fr.aquasys.daeau.station.links.locations.StationLocation;
import fr.aquasys.daeau.station.links.measureMethod.MeasureMethod;
import fr.aquasys.daeau.station.links.measureMethod.MeasureMethod$;
import fr.aquasys.daeau.station.links.tempRef.StationTempRef;
import fr.aquasys.daeau.station.links.tempRef.StationTempRef$;
import fr.aquasys.daeau.station.links.usages.Usage;
import fr.aquasys.daeau.station.links.watermass.StationWatermass;
import fr.aquasys.daeau.user.constant.HabilitationConstants$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.ReferentialUtil$;
import fr.aquasys.utils.StringUtil$;
import infoTerre.model.InfoTerreBorehole;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.libs.json.Reads;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;
import util.InfoTerreUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\r}c\u0001\u0002\u0010 \u0001\u0019B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006YA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0006\u0003\"AQ\t\u0001B\u0001B\u0003-a\t\u0003\u0005N\u0001\t\u0005\t\u0015a\u0003O\u0011!I\u0006A!A!\u0002\u0017Q\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b1B1\t\u0011%\u0004!\u0011!Q\u0001\f)DQ\u0001\u001d\u0001\u0005\u0002EDq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002|\u0001!\t!! \t\u0013\u0005E\u0006A1A\u0005\n\u0005M\u0006\u0002CAg\u0001\u0001\u0006I!!.\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"9\u00111 \u0001\u0005\u0002\u0005u\bb\u0002B\u0005\u0001\u0011\u0005!1\u0002\u0005\b\u0005W\u0001A\u0011\u0001B\u0017\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005kAqA!\u0013\u0001\t\u0003\u0011Y\u0005C\u0004\u0003`\u0001!\tA!\u0019\t\u000f\tM\u0004\u0001\"\u0001\u0003v!9!\u0011\u0012\u0001\u0005\u0002\t-\u0005b\u0002BO\u0001\u0011\u0005!q\u0014\u0005\b\u0005c\u0003A\u0011\u0001BZ\u0011\u001d\u00119\r\u0001C\u0001\u0005\u0013DqA!8\u0001\t\u0003\u0011y\u000eC\u0004\u0003t\u0002!\tA!>\t\u000f\r-\u0001\u0001\"\u0001\u0004\u000e!91\u0011\u0005\u0001\u0005\u0002\r\r\u0002bBB\u001d\u0001\u0011\u000511\b\u0002\u001c\u0003\u0012,7\u000fU5fu>lW\r\u001e:z'R\fG/[8o\u00136\u0004xN\u001d;\u000b\u0005\u0001\n\u0013A\u00039jKj|W.\u001a;ss*\u0011!eI\u0001\u000bG>tGO]8mY\u0016\u0014(\"\u0001\u0013\u0002\t\u0005$Wm]\u0002\u0001'\r\u0001q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00059:T\"A\u0018\u000b\u0005A\n\u0014aA1qS*\u0011!gM\u0001\te\u0006\u0014'-\u001b;nc*\u0011A'N\u0001\bCF,\u0018m]=t\u0015\u00051\u0014A\u00014s\u0013\tAtF\u0001\u0005Qe>$WoY3s\u0003\u001daunZ+uS2\u0004\"a\u000f \u000e\u0003qR!!P\u0019\u0002\tU$\u0018\u000e\\\u0005\u0003\u007fq\u0012q\u0001T8h+RLG.\u0001\u0006bI\u0016\u001cxkU+uS2\u0004\"AQ\"\u000e\u0003\rJ!\u0001R\u0012\u0003\u0015\u0005#Wm],T+RLG.A\tB\t\u0016\u001b\u0006+[3{_6,G/\u001a:EC>\u0004\"aR&\u000e\u0003!S!\u0001I%\u000b\u0005)\u001b\u0013a\u00013b_&\u0011A\n\u0013\u0002\u0012\u0003\u0012+5\u000bU5fu>lW\r^3s\t\u0006|\u0017!D:b]\u0012\u0014XmQ8eK\u0012\u000bw\u000e\u0005\u0002P/6\t\u0001K\u0003\u0002K#*\u0011!kU\u0001\u000bg\u0006tGM]3D_\u0012,'B\u0001+V\u00031\u0011XMZ3sK:$\u0018.\u00197t\u0015\t16'A\u0003eC\u0016\fW/\u0003\u0002Y!\ni1+\u00198ee\u0016\u001cu\u000eZ3EC>\f!BS8c\u0019><W\u000b^5m!\tYf,D\u0001]\u0015\ti6'A\u0003vi&d7/\u0003\u0002`9\nQ!j\u001c2M_\u001e,F/\u001b7\u0002\u001f\r{g\u000e\u001e:jEV$xN]:EC>\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\u0007%$hM\u0003\u0002g'\u0006Y1m\u001c8ue&\u0014W\u000f^8s\u0013\tA7MA\bD_:$(/\u001b2vi>\u00148\u000fR1p\u00035\u0001\u0018.\u001a>p[\u0016$XM\u001d#b_B\u00111N\\\u0007\u0002Y*\u0011A-\u001c\u0006\u0003AUK!a\u001c7\u0003\u001fAKWM_8nKR,'\u000fR1fCV\fa\u0001P5oSRtD#\u0001:\u0015\u0011M,ho\u001e=zun\u0004\"\u0001\u001e\u0001\u000e\u0003}AQ!\u000f\u0005A\u0004iBQ\u0001\u0011\u0005A\u0004\u0005CQ!\u0012\u0005A\u0004\u0019CQ!\u0014\u0005A\u00049CQ!\u0017\u0005A\u0004iCQ\u0001\u0019\u0005A\u0004\u0005DQ!\u001b\u0005A\u0004)D#\u0001C?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\r%t'.Z2u\u0015\t\t)!A\u0003kCZ\f\u00070C\u0002\u0002\n}\u0014a!\u00138kK\u000e$\u0018\u0001G7b]\u0006<W\rU5fu>lW\r^3s'R\fG/[8ogRq\u0011qBA\u0011\u0003K\ty#a\u0013\u0002P\u0005=\u0004#\u0002\u0015\u0002\u0012\u0005U\u0011bAA\nS\t1q\n\u001d;j_:\u0004B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037\u0019\u0013!B7pI\u0016d\u0017\u0002BA\u0010\u00033\u00111AQ:t\u0011\u001d\t\u0019#\u0003a\u0001\u0003+\t1AY:t\u0011\u001d\t9#\u0003a\u0001\u0003S\taB[8c\u000bb,7-\u001e;j_:LE\rE\u0002)\u0003WI1!!\f*\u0005\u0011auN\\4\t\u000f\u0005E\u0012\u00021\u0001\u00024\u0005\u00112\u000f^1uS>t\u0017J\u001c;fOJ\fG/[8o!\u0015A\u0013\u0011CA\u001b!\u0011\t9$!\u0012\u000f\t\u0005e\u0012\u0011\t\t\u0004\u0003wISBAA\u001f\u0015\r\ty$J\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r\u0013&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\nIE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007J\u0003bBA'\u0013\u0001\u0007\u0011QG\u0001\u0005kN,'\u000fC\u0004\u0002R%\u0001\r!a\u0015\u0002\u0017M\fg\u000e\u001a:f\u0007>$Wm\u001d\t\u0007\u0003+\ny&!\u001a\u000f\t\u0005]\u00131\f\b\u0005\u0003w\tI&C\u0001+\u0013\r\ti&K\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t'a\u0019\u0003\u0007M+\u0017OC\u0002\u0002^%\u0002B!a\u001a\u0002l5\u0011\u0011\u0011\u000e\u0006\u0004\u00037\t\u0016\u0002BA7\u0003S\u0012!bU1oIJ,7i\u001c3f\u0011\u001d\t\t(\u0003a\u0001\u0003g\nqAZ5mi\u0016\u00148\u000f\u0005\u0003\u0002v\u0005]T\"A\u0011\n\u0007\u0005e\u0014E\u0001\u0006BI\u0016\u001ch)\u001b7uKJ\f\u0011cZ3u\u0003\u0012,7\u000fU5fu>lW\r^3s)A\ty(!$\u0002\u001c\u0006\u0015\u0016\u0011VAV\u0003[\u000by\u000b\u0005\u0003\u0002\u0002\u0006%UBAAB\u0015\r\u0001\u0013Q\u0011\u0006\u0004\u0003\u000f\u001b\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002\f\u0006\r%AD!eKN\u0004\u0016.\u001a>p[\u0016$XM\u001d\u0005\b\u0003\u001fS\u0001\u0019AAI\u0003\rAX\u000e\u001c\t\u0005\u0003'\u000b9*\u0004\u0002\u0002\u0016*\u0019\u0011qR\u0015\n\t\u0005e\u0015Q\u0013\u0002\u0005\u001d>$W\rC\u0004\u0002\u001e*\u0001\r!a(\u0002\u0005%$\u0007c\u0001\u0015\u0002\"&\u0019\u00111U\u0015\u0003\u0007%sG\u000fC\u0004\u0002(*\u0001\r!!\u000e\u0002\u000f\t\u001c8oQ8eK\"9\u0011q\u0005\u0006A\u0002\u0005%\u0002bBA'\u0015\u0001\u0007\u0011Q\u0007\u0005\b\u0003#R\u0001\u0019AA*\u0011\u001d\t\tH\u0003a\u0001\u0003g\n!\u0002Z1uK\u001a{'/\\1u+\t\t)\f\u0005\u0003\u00028\u0006%WBAA]\u0015\u0011\tY,!0\u0002\r\u0019|'/\\1u\u0015\u0011\ty,!1\u0002\tQLW.\u001a\u0006\u0005\u0003\u0007\f)-\u0001\u0003k_\u0012\f'BAAd\u0003\ry'oZ\u0005\u0005\u0003\u0017\fILA\tECR,G+[7f\r>\u0014X.\u0019;uKJ\f1\u0002Z1uK\u001a{'/\\1uA\u0005y\u0001/\u0019:tKBKWM_8nKR,'\u000f\u0006\b\u0002T\u0006%\u00181^Aw\u0003_\f\t0!?\u0011\u000f!\n).!7\u0002d&\u0019\u0011q[\u0015\u0003\rQ+\b\u000f\\33!\u0011\tY.a8\u000e\u0005\u0005u'bAA\u000e[&!\u0011\u0011]Ao\u0005)\u0001\u0016.\u001a>p[\u0016$XM\u001d\t\u0004Q\u0005\u0015\u0018bAAtS\t9!i\\8mK\u0006t\u0007bBAH\u001b\u0001\u0007\u0011\u0011\u0013\u0005\b\u0003Ok\u0001\u0019AA\u001b\u0011\u001d\ti*\u0004a\u0001\u0003?Cq!!\u0014\u000e\u0001\u0004\t)\u0004C\u0004\u0002(5\u0001\r!a=\u0011\u0007!\n)0C\u0002\u0002x&\u0012a\u0001R8vE2,\u0007bBA9\u001b\u0001\u0007\u00111O\u0001\u000ea\u0006\u00148/\u001a)pS:$X)Y;\u0015\u0019\u0005e\u0017q B\u0001\u0005\u0007\u0011)Aa\u0002\t\u000f\u0005=e\u00021\u0001\u0002\u0012\"9\u0011q\u0015\bA\u0002\u0005U\u0002bBAO\u001d\u0001\u0007\u0011q\u0014\u0005\b\u0003\u001br\u0001\u0019AA\u001b\u0011\u001d\t9C\u0004a\u0001\u0003g\fQ\u0002]1sg\u0016\u0014VM\u001a+f[B|G\u0003\u0003B\u0007\u0005G\u0011)C!\u000b\u0011\r\u0005U\u0013q\fB\b!\u0011\u0011\tBa\b\u000e\u0005\tM!\u0002\u0002B\u000b\u0005/\tq\u0001^3naJ+gM\u0003\u0003\u0003\u001a\tm\u0011!\u00027j].\u001c(b\u0001B\u000f+\u000691\u000f^1uS>t\u0017\u0002\u0002B\u0011\u0005'\u0011ab\u0015;bi&|g\u000eV3naJ+g\rC\u0004\u0002\u0010>\u0001\r!!%\t\u000f\t\u001dr\u00021\u0001\u0002 \u00069\u0001/[3{_&#\u0007bBA\u0014\u001f\u0001\u0007\u0011\u0011F\u0001\u000ba\u0006\u00148/\u001a#faRDG\u0003\u0002B\u0018\u0005c\u0001R\u0001KA\t\u0003gDq!a$\u0011\u0001\u0004\t\t*\u0001\bqCJ\u001cXMR;oGRLwN\\:\u0015\r\t]\"Q\tB$!\u0019\t)&a\u0018\u0003:A!!1\bB!\u001b\t\u0011iD\u0003\u0003\u0003@\t]\u0011!\u00034v]\u000e$\u0018n\u001c8t\u0013\u0011\u0011\u0019E!\u0010\u0003\u001fM#\u0018\r^5p]\u001a+hn\u0019;j_:Dq!a$\u0012\u0001\u0004\t\t\nC\u0004\u0003(E\u0001\r!a(\u0002\u001bA\f'o]3OKR<xN]6t)\u0011\u0011iE!\u0018\u0011\r\u0005U\u0013q\fB(!\u0011\u0011\tF!\u0017\u000e\u0005\tM#\u0002BA\u000e\u0005+R1Aa\u0016T\u0003\u001dqW\r^<pe.LAAa\u0017\u0003T\t9a*\u001a;x_J\\\u0007bBAH%\u0001\u0007\u0011\u0011S\u0001\na\u0006\u00148/Z\"jif$BAa\u0019\u0003rA!!Q\rB7\u001b\t\u00119G\u0003\u0003\u0002\u001c\t%$b\u0001B6'\u0006!1-\u001b;z\u0013\u0011\u0011yGa\u001a\u0003\t\rKG/\u001f\u0005\b\u0003\u001f\u001b\u0002\u0019AAI\u0003A\u0001\u0018M]:f/\u0006$XM]7bgN,7\u000f\u0006\u0003\u0003x\t\u001d\u0005CBA+\u0003?\u0012I\b\u0005\u0003\u0003|\t\rUB\u0001B?\u0015\u0011\tYBa \u000b\u0007\t\u00055+A\u0005xCR,'/\\1tg&!!Q\u0011B?\u0005%9\u0016\r^3s[\u0006\u001c8\u000fC\u0004\u0002\u0010R\u0001\r!!%\u0002'A\f'o]3XCR,'/\\1tg2Kgn[:\u0015\r\t5%\u0011\u0014BN!\u0019\t)&a\u0018\u0003\u0010B!!\u0011\u0013BK\u001b\t\u0011\u0019J\u0003\u0003\u0003\u0002\n]\u0011\u0002\u0002BL\u0005'\u0013\u0001c\u0015;bi&|gnV1uKJl\u0017m]:\t\u000f\u0005=U\u00031\u0001\u0002\u0012\"9!qE\u000bA\u0002\u0005}\u0015a\u00039beN,WI^3oiN$\u0002B!)\u0003*\n-&Q\u0016\t\u0007\u0003+\nyFa)\u0011\t\u0005m'QU\u0005\u0005\u0005O\u000biNA\bQS\u0016Tx.\\3uef,e/\u001a8u\u0011\u001d\tyI\u0006a\u0001\u0003#CqAa\n\u0017\u0001\u0004\ty\nC\u0004\u0002(Y\u0001\rAa,\u0011\u000b!\n\t\"!\u000b\u0002#A\f'o]3OKR<xN]6MS:\\7\u000f\u0006\u0006\u00036\nu&q\u0018Ba\u0005\u0007\u0004b!!\u0016\u0002`\t]\u0006\u0003BAA\u0005sKAAa/\u0002\u0004\ny\u0011\tZ3t\u001d\u0016$xo\u001c:l\u0019&t7\u000eC\u0004\u0002\u0010^\u0001\r!!%\t\u000f\t\u001dr\u00031\u0001\u0002 \"9\u0011qE\fA\u0002\u0005%\u0002b\u0002Bc/\u0001\u0007\u0011QG\u0001\bG>$WMQ:t\u00039\u0001\u0018M]:f\u0019\u0006tG-\\1sWN$bAa3\u0003Z\nm\u0007CBA+\u0003?\u0012i\r\u0005\u0003\u0003P\nUWB\u0001Bi\u0015\u0011\u0011\u0019Na\u0006\u0002\u00111\fg\u000eZ7be.LAAa6\u0003R\nAA*\u00198e[\u0006\u00148\u000eC\u0004\u0002\u0010b\u0001\r!!%\t\u000f\t\u001d\u0002\u00041\u0001\u0002 \u0006)\u0002/\u0019:tK\u0006cG/[7fiJL8+_:uK6\u001cHC\u0002Bq\u0005_\u0014\t\u0010\u0005\u0004\u0002V\u0005}#1\u001d\t\u0005\u0005K\u0014Y/\u0004\u0002\u0003h*!!\u0011\u001eB\f\u0003=\tG\u000e^5nKR\u0014\u0018pU=ti\u0016l\u0017\u0002\u0002Bw\u0005O\u0014q\"\u00117uS6,GO]=TsN$X-\u001c\u0005\b\u0003\u001fK\u0002\u0019AAI\u0011\u001d\u00119#\u0007a\u0001\u0003?\u000b\u0011\u0003]1sg\u0016lU-Y:ve\u0016lu\u000eZ3t)!\u00119p!\u0002\u0004\b\r%\u0001CBA+\u0003?\u0012I\u0010\u0005\u0003\u0003|\u000e\u0005QB\u0001B\u007f\u0015\u0011\u0011yPa\u0006\u0002\u001b5,\u0017m];sK6+G\u000f[8e\u0013\u0011\u0019\u0019A!@\u0003\u001b5+\u0017m];sK6+G\u000f[8e\u0011\u001d\tyI\u0007a\u0001\u0003#CqAa\n\u001b\u0001\u0004\ty\nC\u0004\u0002Ri\u0001\r!a\u0015\u0002-A\f'o]3EKN\u0004x\u000e\\5bi&|g\u000eT5oWN$baa\u0004\u0004\u001e\r}\u0001CBA+\u0003?\u001a\t\u0002\u0005\u0003\u0004\u0014\reQBAB\u000b\u0015\u0011\u00199Ba\u0006\u0002!\u0011,7\u000f]8mS\u0006$\u0018n\u001c8N_\u0012,\u0017\u0002BB\u000e\u0007+\u0011\u0001\u0003R3ta>d\u0017.\u0019;j_:lu\u000eZ3\t\u000f\u0005=5\u00041\u0001\u0002\u0012\"9!qE\u000eA\u0002\u0005}\u0015\u0001\u00069beN,w+\u0019;feV\u001b\u0018mZ3MS:\\7\u000f\u0006\u0005\u0004&\rM2QGB\u001c!\u0019\t)&a\u0018\u0004(A!1\u0011FB\u0018\u001b\t\u0019YC\u0003\u0003\u0004.\t]\u0011AB;tC\u001e,7/\u0003\u0003\u00042\r-\"!B+tC\u001e,\u0007bBAH9\u0001\u0007\u0011\u0011\u0013\u0005\b\u0005Oa\u0002\u0019AAP\u0011\u001d\t\t\u0006\ba\u0001\u0003'\n!\u0003]1sg\u0016D\u0015\u0010\u001a:p\u000b:$\u0018\u000e^5fgRA1QHB)\u0007'\u001a)\u0006\u0005\u0004\u0002V\u0005}3q\b\t\nQ\r\u0005\u0013QGA\u001b\u0007\u000bJ1aa\u0011*\u0005\u0019!V\u000f\u001d7fgA!1qIB'\u001b\t\u0019IE\u0003\u0003\u0004L\t]\u0011a\u00035zIJ|WI\u001c;jifLAaa\u0014\u0004J\t\u00112\u000b^1uS>t\u0007*\u001f3s_\u0016sG/\u001b;z\u0011\u001d\ty)\ba\u0001\u0003#CqAa\n\u001e\u0001\u0004\ty\nC\u0004\u0002(u\u0001\r!!\u000b)\u0007\u0001\u0019I\u0006E\u0002\u007f\u00077J1a!\u0018\u0000\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class AdesPiezometryStationImport
implements Producer {
    private final LogUtil LogUtil;
    private final AdesWSUtil adesWSUtil;
    private final ADESPiezometerDao ADESPiezometerDao;
    private final SandreCodeDao sandreCodeDao;
    private final JobLogUtil JobLogUtil;
    private final ContributorsDao ContributorsDao;
    private final PiezometerDaeau piezometerDao;
    private final DateTimeFormatter dateFormat;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        AdesPiezometryStationImport adesPiezometryStationImport = this;
        synchronized (adesPiezometryStationImport) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public Option<Bss> managePiezometerStations(Bss bss2, long jobExecutionId, Option<String> stationIntegration, String user, Seq<SandreCode> sandreCodes, AdesFilter filters) {
        if (stationIntegration.contains((Object)IntegrationType$.MODULE$.STATION_INTEGRATION()) || bss2.id().isEmpty()) {
            Elem stationsXML = this.adesWSUtil.getAdesStationsXML((Seq<Bss>)new .colon.colon((Object)bss2, (List)Nil$.MODULE$), jobExecutionId);
            Seq results = (Seq)stationsXML.$bslash$bslash("PointEau").map((Function1 & Serializable)xml -> {
                String codePointEau = xml.$bslash$bslash("CdNationalPointEau").text().toUpperCase();
                Option option = new .colon.colon((Object)bss2, (List)Nil$.MODULE$).headOption();
                if (None$.MODULE$.equals(option)) {
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(40).append("Can't find used adesBss object for code ").append(codePointEau).toString(), codePointEau, $this.JobLogUtil.log$default$5());
                    throw new Exception(new StringBuilder(40).append("Can't find used adesBss object for code ").append(codePointEau).toString());
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Bss adesBss = (Bss)some.value();
                    return new Tuple2((Object)adesBss, xml);
                }
                throw new MatchError((Object)option);
            });
            Seq notFoundAdes = (Seq)new .colon.colon((Object)bss2, (List)Nil$.MODULE$).filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)AdesPiezometryStationImport.$anonfun$managePiezometerStations$2(results, a)));
            notFoundAdes.foreach((Function1 & Serializable)notFoundBss -> {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(25).append("No station found for bss ").append(notFoundBss.wantedCode()).toString(), notFoundBss.wantedCode(), this.JobLogUtil.log$default$5());
                return BoxedUnit.UNIT;
            });
            Seq infoTerreIds = (Seq)notFoundAdes.flatMap((Function1 & Serializable)bss -> {
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(53).append("Station description, Starting InfoTerre call for bss ").append(bss.wantedCode()).toString(), bss.wantedCode(), $this.JobLogUtil.log$default$5());
                Seq<InfoTerreBorehole> infoTerreList = InfoTerreUtil$.MODULE$.getInfoTerreBoreholesByBSS(bss.wantedCode(), (Seq<InfoTerreBorehole>)((Seq)Nil$.MODULE$), 0, sandreCodes, jobExecutionId);
                return (Seq)infoTerreList.map((Function1 & Serializable)infoTerreElem -> BoxesRunTime.boxToInteger((int)AdesPiezometryStationImport.$anonfun$managePiezometerStations$6(this, jobExecutionId, bss, user, infoTerreElem)));
            });
            if (infoTerreIds.nonEmpty()) {
                Some x$103 = new Some((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToInt((Object)infoTerreIds.head())));
                String x$104 = bss2.copy$default$1();
                Option<String> x$105 = bss2.copy$default$2();
                Option<String> x$106 = bss2.copy$default$3();
                Option<String> x$107 = bss2.copy$default$5();
                return new Some((Object)bss2.copy(x$104, x$105, x$106, (Option<Object>)x$103, x$107));
            }
            return ((IterableOps)results.flatMap((Function1 & Serializable)couple -> {
                $this.JobLogUtil.checkExecutionAbort(jobExecutionId);
                Tuple2 tuple2 = couple;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Bss adesBss = (Bss)tuple2._1();
                Node xml = (Node)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)adesBss, (Object)xml);
                Bss adesBss2 = (Bss)tuple22._1();
                Node xml2 = (Node)tuple22._2();
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Parsing XML...", adesBss2.wantedCode(), $this.JobLogUtil.log$default$5());
                    AdesPiezometer adesPiezo = this.getAdesPiezometer(xml2, BoxesRunTime.unboxToInt((Object)adesBss2.id().map((Function1)(JFunction1.mcID.sp & Serializable)x$4 -> (int)x$4).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)), adesBss2.wantedCode(), jobExecutionId, user, sandreCodes, filters);
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Integration to database...", adesBss2.wantedCode(), $this.JobLogUtil.log$default$5());
                    int newId = $this.ADESPiezometerDao.importAdesPiezometer(adesPiezo, adesBss2, (Option<String>)new Some((Object)user), filters, jobExecutionId);
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), "Station description integrated with success", adesBss2.wantedCode(), $this.JobLogUtil.log$default$5());
                    Some x$108 = new Some((Object)BoxesRunTime.boxToDouble((double)newId));
                    String x$109 = adesBss2.copy$default$1();
                    Option<String> x$110 = adesBss2.copy$default$2();
                    Option<String> x$111 = adesBss2.copy$default$3();
                    Option<String> x$112 = adesBss2.copy$default$5();
                    return adesBss2.copy(x$109, x$110, x$111, (Option<Object>)x$108, x$112);
                });
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Bss result = (Bss)success.value();
                    return new Some((Object)result);
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable error = failure.exception();
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(35).append("Error while parsing <PointEau> for ").append(adesBss2.wantedCode()).toString(), adesBss2.wantedCode(), $this.JobLogUtil.log$default$5());
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), error.getMessage(), adesBss2.wantedCode(), $this.JobLogUtil.log$default$5());
                    $this.LogUtil.printError(error);
                    error.printStackTrace();
                    return None$.MODULE$;
                }
                throw new MatchError((Object)try_);
            })).headOption();
        }
        return new Some((Object)bss2);
    }

    public AdesPiezometer getAdesPiezometer(Node xml, int id, String bssCode, long jobExecutionId, String user, Seq<SandreCode> sandreCodes, AdesFilter filters) {
        Seq adesNetworkLink = filters.addCodesToADESNetwork().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters.selectedNetwork().isDefined() ? new .colon.colon((Object)new AdesNetworkLink(id, (Option<Object>)new Some(filters.selectedNetwork().get()), "", (Option<DateTime>)new Some((Object)new DateTime()), (Option<DateTime>)None$.MODULE$), (List)Nil$.MODULE$) : (Seq)Nil$.MODULE$;
        Tuple2<Piezometer, Object> tuple2 = this.parsePiezometer(xml, bssCode, id, user, jobExecutionId, filters);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Piezometer piezometer = (Piezometer)tuple2._1();
        boolean isPointEauMode = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)piezometer, (Object)BoxesRunTime.boxToBoolean((boolean)isPointEauMode));
        Piezometer piezometer2 = (Piezometer)tuple22._1();
        boolean isPointEauMode2 = tuple22._2$mcZ$sp();
        if (isPointEauMode2) {
            String x$1 = bssCode;
            boolean x$2 = isPointEauMode2;
            Piezometer x$3 = piezometer2;
            Seq x$4 = (Seq)Nil$.MODULE$;
            City x$5 = this.parseCity(xml);
            Seq x$6 = (Seq)Nil$.MODULE$;
            Option x$7 = piezometer2.projection().map((Function1 & Serializable)proj -> AdesPiezometryStationImport.$anonfun$getAdesPiezometer$1(id, piezometer2, BoxesRunTime.unboxToInt((Object)proj)));
            Seq<PiezometryEvent> x$8 = this.parseEvents(xml, id, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)jobExecutionId)));
            Seq x$9 = adesNetworkLink;
            Seq<StationFunction> x$10 = this.parseFunctions(xml, id);
            Seq<Tuple3<String, String, StationHydroEntity>> x$11 = this.parseHydroEntities(xml, id, jobExecutionId);
            Seq<Landmark> x$12 = AdesPiezometer$.MODULE$.$lessinit$greater$default$10();
            Seq<AltimetrySystem> x$13 = AdesPiezometer$.MODULE$.$lessinit$greater$default$11();
            Seq<MeasureMethod> x$14 = AdesPiezometer$.MODULE$.$lessinit$greater$default$12();
            Seq<DespoliationMode> x$15 = AdesPiezometer$.MODULE$.$lessinit$greater$default$13();
            Seq<StationWatermass> x$16 = AdesPiezometer$.MODULE$.$lessinit$greater$default$14();
            Seq<Usage> x$17 = AdesPiezometer$.MODULE$.$lessinit$greater$default$15();
            Option<Object> x$18 = AdesPiezometer$.MODULE$.$lessinit$greater$default$16();
            Seq<StationTempRef> x$19 = AdesPiezometer$.MODULE$.$lessinit$greater$default$18();
            return new AdesPiezometer(x$1, x$2, x$3, (Seq<Network>)x$4, x$5, (Seq<Watermass>)x$6, (Option<StationLocation>)x$7, x$8, (Seq<AdesNetworkLink>)x$9, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$10, x$19, x$11);
        }
        Seq<Watermass> waterMasses = this.parseWatermasses(xml);
        return new AdesPiezometer(bssCode, isPointEauMode2, piezometer2, this.parseNetworks(xml), this.parseCity(xml), waterMasses, (Option<StationLocation>)piezometer2.projection().map((Function1 & Serializable)proj -> AdesPiezometryStationImport.$anonfun$getAdesPiezometer$2(id, piezometer2, BoxesRunTime.unboxToInt((Object)proj))), this.parseEvents(xml, id, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)jobExecutionId))), (Seq<AdesNetworkLink>)((Seq)this.parseNetworkLinks(xml, id, jobExecutionId, bssCode).$plus$plus((IterableOnce)adesNetworkLink)), this.parseLandmarks(xml, id), this.parseAltimetrySystems(xml, id), this.parseMeasureModes(xml, id, sandreCodes), this.parseDespoliationLinks(xml, id), this.parseWatermassLinks(xml, id), this.parseWaterUsageLinks(xml, id, sandreCodes), this.parseDepth(xml), this.parseFunctions(xml, id), this.parseRefTempo(xml, id, jobExecutionId), this.parseHydroEntities(xml, id, jobExecutionId));
    }

    private DateTimeFormatter dateFormat() {
        return this.dateFormat;
    }

    public Tuple2<Piezometer, Object> parsePiezometer(Node xml, String bssCode, int id, String user, double jobExecutionId, AdesFilter filters) {
        if (filters.descriptionImportMode().contains((Object)"PointEau")) {
            return new Tuple2((Object)this.parsePointEau(xml, bssCode, id, user, jobExecutionId), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (xml.$bslash$bslash("Piezometre").length() > 0) {
            String designation = xml.$bslash$bslash("CdNationalPointEau").text().split("/")[1];
            Option closeDate = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                NodeSeq networkLinks = xml.$bslash$bslash("AppartenancePiezoReseauMesure");
                if (networkLinks.forall((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)AdesPiezometryStationImport.$anonfun$parsePiezometer$2(this, n)))) {
                    return new Some(((IterableOnceOps)networkLinks.map((Function1 & Serializable)elem -> DateUtil$.MODULE$.setMaxDay(this.dateFormat().parseDateTime(elem.$bslash$bslash("DateFinAppartenance").text())))).max(DateUtil$.MODULE$.ordering()));
                }
                return None$.MODULE$;
            }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
            int x$1 = id;
            String x$2 = bssCode.split("/")[0];
            Option x$3 = StringUtil$.MODULE$.toStringOpt(xml.$bslash$bslash("LbPointEau").text());
            Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(xml.$bslash$bslash("CdNaturePointEau").text()))));
            Option x$5 = Try$.MODULE$.apply((Function0 & Serializable)() -> (DateTime)((IterableOnceOps)xml.$bslash$bslash("AppartenancePiezoReseauMesure").$bslash$bslash("DateDebAppartenance").map((Function1 & Serializable)date -> this.dateFormat().parseDateTime(date.text()).withTimeAtStartOfDay())).min(DateUtil$.MODULE$.ordering())).toOption();
            Option x$6 = closeDate;
            Some x$7 = new Some((Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(xml.$bslash$bslash("CoordXPointEau").text()))));
            Some x$8 = new Some((Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(xml.$bslash$bslash("CoordYPointEau").text()))));
            Some x$9 = new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(xml.$bslash$bslash("ProjCoordPointEau").text()))));
            Some x$10 = new Some((Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(xml.$bslash$bslash("AltitudePointEau").text()))));
            Some x$11 = new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(xml.$bslash$bslash("ExpCoteChroniquePiezometre").text()))));
            Option x$12 = StringUtil$.MODULE$.toStringOpt(xml.$bslash$bslash("ModeGisement").text()).map((Function1 & Serializable)txt -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(txt))));
            Option x$13 = StringUtil$.MODULE$.toStringOpt(xml.$bslash$bslash("ComPointEau").text());
            Some x$14 = new Some((Object)xml.$bslash$bslash("CdCommune").text());
            None$ x$15 = None$.MODULE$;
            Some x$16 = new Some((Object)designation);
            Some x$17 = new Some((Object)xml.$bslash$bslash("TypDePointEau").text());
            None$ x$18 = None$.MODULE$;
            Some x$19 = new Some((Object)xml.$bslash$bslash("AdPointEau").text());
            Some x$20 = new Some((Object)BoxesRunTime.boxToInteger((int)((int)jobExecutionId)));
            Some x$21 = new Some((Object)user);
            Some x$22 = new Some((Object)new DateTime());
            Some x$23 = new Some((Object)xml.$bslash$bslash("CdCommune").text());
            Option x$24 = Piezometer$.MODULE$.$lessinit$greater$default$20();
            Option x$25 = Piezometer$.MODULE$.$lessinit$greater$default$21();
            Option x$26 = Piezometer$.MODULE$.$lessinit$greater$default$22();
            Option x$27 = Piezometer$.MODULE$.$lessinit$greater$default$24();
            Option x$28 = Piezometer$.MODULE$.$lessinit$greater$default$27();
            Option x$29 = Piezometer$.MODULE$.$lessinit$greater$default$29();
            return new Tuple2((Object)new Piezometer(x$1, x$2, x$3, (Option)x$4, x$5, x$6, (Option)x$7, (Option)x$8, (Option)x$9, (Option)x$10, (Option)x$11, x$12, x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, (Option)x$18, (Option)x$19, x$24, x$25, x$26, (Option)x$20, x$27, (Option)x$21, (Option)x$22, x$28, (Option)x$23, x$29), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return new Tuple2((Object)this.parsePointEau(xml, bssCode, id, user, jobExecutionId), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public Piezometer parsePointEau(Node xml, String bssCode, int id, String user, double jobExecutionId) {
        String designation = xml.$bslash$bslash("CdNationalPointEau").text().split("/")[1];
        int x$1 = id;
        String x$2 = bssCode.split("/")[0];
        Option x$3 = StringUtil$.MODULE$.toStringOpt(xml.$bslash$bslash("LbPointEau").text());
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(xml.$bslash$bslash("CdNaturePointEau").text()))));
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        Some x$7 = new Some((Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(xml.$bslash$bslash("CoordXPointEau").text()))));
        Some x$8 = new Some((Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(xml.$bslash$bslash("CoordYPointEau").text()))));
        Some x$9 = new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(xml.$bslash$bslash("ProjCoordPointEau").text()))));
        Some x$10 = new Some((Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(xml.$bslash$bslash("AltitudePointEau").text()))));
        None$ x$11 = None$.MODULE$;
        Option x$12 = StringUtil$.MODULE$.toStringOpt(xml.$bslash$bslash("ModeGisement").text()).map((Function1 & Serializable)txt -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(txt))));
        Option x$13 = StringUtil$.MODULE$.toStringOpt(xml.$bslash$bslash("ComPointEau").text());
        Some x$14 = new Some((Object)xml.$bslash$bslash("CdCommune").text());
        None$ x$15 = None$.MODULE$;
        Some x$16 = new Some((Object)designation);
        Some x$17 = new Some((Object)xml.$bslash$bslash("TypDePointEau").text());
        None$ x$18 = None$.MODULE$;
        Some x$19 = new Some((Object)xml.$bslash$bslash("AdPointEau").text());
        Some x$20 = new Some((Object)BoxesRunTime.boxToInteger((int)((int)jobExecutionId)));
        Some x$21 = new Some((Object)user);
        Some x$22 = new Some((Object)new DateTime());
        Some x$23 = new Some((Object)xml.$bslash$bslash("CdCommune").text());
        Option x$24 = Piezometer$.MODULE$.$lessinit$greater$default$20();
        Option x$25 = Piezometer$.MODULE$.$lessinit$greater$default$21();
        Option x$26 = Piezometer$.MODULE$.$lessinit$greater$default$22();
        Option x$27 = Piezometer$.MODULE$.$lessinit$greater$default$24();
        Option x$28 = Piezometer$.MODULE$.$lessinit$greater$default$27();
        Option x$29 = Piezometer$.MODULE$.$lessinit$greater$default$29();
        return new Piezometer(x$1, x$2, x$3, (Option)x$4, (Option)x$5, (Option)x$6, (Option)x$7, (Option)x$8, (Option)x$9, (Option)x$10, (Option)x$11, x$12, x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, (Option)x$18, (Option)x$19, x$24, x$25, x$26, (Option)x$20, x$27, (Option)x$21, (Option)x$22, x$28, (Option)x$23, x$29);
    }

    public Seq<StationTempRef> parseRefTempo(Node xml, int piezoId, long jobExecutionId) {
        return (Seq)xml.$bslash$bslash("PeriodeValiditeRefTemporelle").map((Function1 & Serializable)ref -> {
            Option dtedeb = Try$.MODULE$.apply((Function0 & Serializable)() -> (DateTime)((IterableOnceOps)ref.$bslash$bslash("DateDebValiditeRefTemporelle").map((Function1 & Serializable)date -> this.dateFormat().parseDateTime(date.text()).withTimeAtStartOfDay())).min(DateUtil$.MODULE$.ordering())).toOption();
            Option dtefin = Try$.MODULE$.apply((Function0 & Serializable)() -> (DateTime)((IterableOnceOps)ref.$bslash$bslash("DateFinValiditeRefTemporelle").map((Function1 & Serializable)date -> DateUtil$.MODULE$.setMaxDay(this.dateFormat().parseDateTime(date.text())))).min(DateUtil$.MODULE$.ordering())).toOption();
            String codeRef = ref.$bslash$bslash("RefTemporelle").$bslash$bslash("CdRefTemporelle").text();
            String lbl = ref.$bslash$bslash("RefTemporelle").$bslash$bslash("LbRefTemporelle").text();
            int codeRefInt = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(codeRef));
            if (codeRefInt > 5) {
                throw new Exception("RefTemporelle found is higher than the referential sandre");
            }
            String x$1 = "REF_TEMPORELLES";
            int x$2 = codeRefInt;
            String x$3 = lbl;
            Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId));
            Some x$5 = new Some((Object)DateTime.now());
            Some x$6 = new Some((Object)"adesPiezo");
            Option x$7 = SandreCode$.MODULE$.$lessinit$greater$default$4();
            Option x$8 = SandreCode$.MODULE$.$lessinit$greater$default$5();
            Option x$9 = SandreCode$.MODULE$.$lessinit$greater$default$6();
            Option x$10 = SandreCode$.MODULE$.$lessinit$greater$default$7();
            Option x$11 = SandreCode$.MODULE$.$lessinit$greater$default$8();
            Option x$12 = SandreCode$.MODULE$.$lessinit$greater$default$9();
            Option x$13 = SandreCode$.MODULE$.$lessinit$greater$default$10();
            Option x$14 = SandreCode$.MODULE$.$lessinit$greater$default$11();
            $this.sandreCodeDao.createSandreCode(new SandreCode("REF_TEMPORELLES", x$2, x$3, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option)x$4, (Option)x$6, (Option)x$5), $this.sandreCodeDao.createSandreCode$default$2());
            return new StationTempRef((long)piezoId, dtedeb, dtefin, (Option)new Some((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(codeRef)))), (Option)new Some((Object)""), StationTempRef$.MODULE$.$lessinit$greater$default$6());
        });
    }

    public Option<Object> parseDepth(Node xml) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(xml.$bslash$bslash("ProfInvestiForage").text()))).toOption();
    }

    public Seq<StationFunction> parseFunctions(Node xml, int piezoId) {
        return (Seq)xml.$bslash$bslash("PeriodeUtilisationPointEau").map((Function1 & Serializable)fun -> new StationFunction((double)piezoId, Try$.MODULE$.apply((Function0 & Serializable)() -> (DateTime)((IterableOnceOps)fun.$bslash("DateDebUtilisationPointEau").map((Function1 & Serializable)date -> this.dateFormat().parseDateTime(date.text()).withTimeAtStartOfDay())).min(DateUtil$.MODULE$.ordering())).toOption(), Try$.MODULE$.apply((Function0 & Serializable)() -> (DateTime)((IterableOnceOps)fun.$bslash("DateFinUtilisationPointEau").map((Function1 & Serializable)date -> this.dateFormat().parseDateTime(date.text()).withTimeAtStartOfDay())).min(DateUtil$.MODULE$.ordering())).toOption(), Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(fun.$bslash("CdFctionPointEau").text()))).toOption(), (Option)None$.MODULE$));
    }

    public Seq<Network> parseNetworks(Node xml) {
        return (Seq)xml.$bslash$bslash("AppartenancePiezoReseauMesure").map((Function1 & Serializable)network -> {
            String sandre = network.$bslash$bslash("DispositifCollecte").$bslash$bslash("CodeSandreRdd").text();
            boolean x$1 = false;
            Some x$2 = new Some((Object)network.$bslash$bslash("DispositifCollecte").$bslash$bslash("NomRdd").text());
            Some x$3 = new Some((Object)sandre);
            Some x$4 = new Some((Object)sandre);
            None$ x$5 = None$.MODULE$;
            Option x$6 = Network$.MODULE$.$lessinit$greater$default$4();
            Option x$7 = Network$.MODULE$.$lessinit$greater$default$5();
            Option x$8 = Network$.MODULE$.$lessinit$greater$default$6();
            Option x$9 = Network$.MODULE$.$lessinit$greater$default$8();
            Option x$10 = Network$.MODULE$.$lessinit$greater$default$10();
            Option x$11 = Network$.MODULE$.$lessinit$greater$default$11();
            Option x$12 = Network$.MODULE$.$lessinit$greater$default$12();
            return new Network(0, (Option)x$2, (Option)x$3, x$6, x$7, x$8, (Option)x$4, x$9, (Option)x$5, x$10, x$11, x$12);
        });
    }

    public City parseCity(Node xml) {
        return new City(xml.$bslash$bslash("CdCommune").text(), (Option)new Some((Object)xml.$bslash$bslash("LbCommune").text()), City$.MODULE$.$lessinit$greater$default$3(), City$.MODULE$.$lessinit$greater$default$4(), City$.MODULE$.$lessinit$greater$default$5(), City$.MODULE$.$lessinit$greater$default$6(), City$.MODULE$.$lessinit$greater$default$7(), City$.MODULE$.$lessinit$greater$default$8(), City$.MODULE$.$lessinit$greater$default$9(), City$.MODULE$.$lessinit$greater$default$10(), City$.MODULE$.$lessinit$greater$default$11(), City$.MODULE$.$lessinit$greater$default$12(), City$.MODULE$.$lessinit$greater$default$13(), City$.MODULE$.$lessinit$greater$default$14(), City$.MODULE$.$lessinit$greater$default$15());
    }

    public Seq<Watermass> parseWatermasses(Node xml) {
        return (Seq)xml.$bslash$bslash("MasseDEau").map((Function1 & Serializable)wtm -> {
            String code = wtm.$bslash$bslash("CdMasseDEau").text();
            String name = wtm.$bslash$bslash("NomMasseDEau").text();
            String x$1 = code;
            Some x$2 = new Some((Object)new StringBuilder(2).append("FR").append(code).toString());
            Some x$3 = new Some((Object)name);
            Some x$4 = new Some((Object)name);
            Some x$5 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
            Option x$6 = Watermass$.MODULE$.$lessinit$greater$default$4();
            Option x$7 = Watermass$.MODULE$.$lessinit$greater$default$5();
            Option x$8 = Watermass$.MODULE$.$lessinit$greater$default$6();
            Option x$9 = Watermass$.MODULE$.$lessinit$greater$default$7();
            Option x$10 = Watermass$.MODULE$.$lessinit$greater$default$8();
            Option x$11 = Watermass$.MODULE$.$lessinit$greater$default$9();
            Option x$12 = Watermass$.MODULE$.$lessinit$greater$default$10();
            Option x$13 = Watermass$.MODULE$.$lessinit$greater$default$11();
            Option x$14 = Watermass$.MODULE$.$lessinit$greater$default$12();
            Option x$15 = Watermass$.MODULE$.$lessinit$greater$default$13();
            Option x$16 = Watermass$.MODULE$.$lessinit$greater$default$14();
            Option x$17 = Watermass$.MODULE$.$lessinit$greater$default$15();
            Option x$18 = Watermass$.MODULE$.$lessinit$greater$default$16();
            Option x$19 = Watermass$.MODULE$.$lessinit$greater$default$17();
            Option x$20 = Watermass$.MODULE$.$lessinit$greater$default$18();
            Option x$21 = Watermass$.MODULE$.$lessinit$greater$default$19();
            Option x$22 = Watermass$.MODULE$.$lessinit$greater$default$20();
            return new Watermass(x$1, (Option)x$2, (Option)x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, (Option)x$4, (Option)x$5);
        });
    }

    public Seq<StationWatermass> parseWatermassLinks(Node xml, int piezoId) {
        return (Seq)xml.$bslash$bslash("PeriodeAppPteMdo").map((Function1 & Serializable)wtm -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.dateFormat().parseDateTime(wtm.$bslash$bslash("DateDebAttriPteMdo").text()));
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw new Exception(new StringBuilder(44).append("Watermass found without proper start date : ").append(e.getMessage()).toString(), e);
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            DateTime date = (DateTime)success.value();
            DateTime dateDebut = date;
            return new StationWatermass((double)piezoId, wtm.$bslash("MasseDEau").$bslash$bslash("CdMasseDEau").text(), (Option)None$.MODULE$, (Option)new Some((Object)dateDebut.withTimeAtStartOfDay()), Try$.MODULE$.apply((Function0 & Serializable)() -> DateUtil$.MODULE$.setMaxDay(this.dateFormat().parseDateTime(wtm.$bslash$bslash("DtFinAttrPteMdo").text()))).toOption());
        });
    }

    public Seq<PiezometryEvent> parseEvents(Node xml, int piezoId, Option<Object> jobExecutionId) {
        return (Seq)xml.$bslash$bslash("EvenementPointEau").map((Function1 & Serializable)event -> {
            double x$1 = piezoId;
            double x$2 = 0.0;
            Some x$3 = new Some((Object)this.dateFormat().parseDateTime(event.$bslash$bslash("DateEvenementPointEau").text()));
            Some x$4 = new Some((Object)event.$bslash$bslash("DsEvenementPointEau").text());
            Some x$5 = new Some((Object)"C");
            Some x$6 = new Some((Object)"1");
            Some x$7 = new Some((Object)"1");
            Option x$8 = jobExecutionId;
            Option x$9 = PiezometryEvent$.MODULE$.$lessinit$greater$default$4();
            Option x$10 = PiezometryEvent$.MODULE$.$lessinit$greater$default$5();
            Option x$11 = PiezometryEvent$.MODULE$.$lessinit$greater$default$6();
            Option x$12 = PiezometryEvent$.MODULE$.$lessinit$greater$default$8();
            Option x$13 = PiezometryEvent$.MODULE$.$lessinit$greater$default$12();
            Option x$14 = PiezometryEvent$.MODULE$.$lessinit$greater$default$13();
            Option x$15 = PiezometryEvent$.MODULE$.$lessinit$greater$default$14();
            Option x$16 = PiezometryEvent$.MODULE$.$lessinit$greater$default$15();
            Option x$17 = PiezometryEvent$.MODULE$.$lessinit$greater$default$16();
            Option x$18 = PiezometryEvent$.MODULE$.$lessinit$greater$default$17();
            Option x$19 = PiezometryEvent$.MODULE$.$lessinit$greater$default$18();
            Option x$20 = PiezometryEvent$.MODULE$.$lessinit$greater$default$19();
            Option x$21 = PiezometryEvent$.MODULE$.$lessinit$greater$default$20();
            Option x$22 = PiezometryEvent$.MODULE$.$lessinit$greater$default$21();
            Option x$23 = PiezometryEvent$.MODULE$.$lessinit$greater$default$22();
            Option x$24 = PiezometryEvent$.MODULE$.$lessinit$greater$default$23();
            Option x$25 = PiezometryEvent$.MODULE$.$lessinit$greater$default$24();
            Option x$26 = PiezometryEvent$.MODULE$.$lessinit$greater$default$25();
            Option x$27 = PiezometryEvent$.MODULE$.$lessinit$greater$default$26();
            Option x$28 = PiezometryEvent$.MODULE$.$lessinit$greater$default$27();
            Option x$29 = PiezometryEvent$.MODULE$.$lessinit$greater$default$28();
            Option x$30 = PiezometryEvent$.MODULE$.$lessinit$greater$default$29();
            Option x$31 = PiezometryEvent$.MODULE$.$lessinit$greater$default$30();
            Option x$32 = PiezometryEvent$.MODULE$.$lessinit$greater$default$31();
            Option x$33 = PiezometryEvent$.MODULE$.$lessinit$greater$default$32();
            Option x$34 = PiezometryEvent$.MODULE$.$lessinit$greater$default$33();
            Option x$35 = PiezometryEvent$.MODULE$.$lessinit$greater$default$34();
            Option x$36 = PiezometryEvent$.MODULE$.$lessinit$greater$default$35();
            Option x$37 = PiezometryEvent$.MODULE$.$lessinit$greater$default$36();
            Option x$38 = PiezometryEvent$.MODULE$.$lessinit$greater$default$37();
            return new PiezometryEvent(x$1, 0.0, (Option)x$3, x$9, x$10, x$11, (Option)x$4, x$12, (Option)x$6, (Option)x$7, (Option)x$5, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$8);
        });
    }

    public Seq<AdesNetworkLink> parseNetworkLinks(Node xml, int piezoId, long jobExecutionId, String codeBss) {
        return (Seq)xml.$bslash$bslash("AppartenancePiezoReseauMesure").map((Function1 & Serializable)network -> {
            Option dateDebut = Try$.MODULE$.apply((Function0 & Serializable)() -> this.dateFormat().parseDateTime(network.$bslash$bslash("DateDebAppartenance").text()).withTimeAtStartOfDay()).toOption();
            if (dateDebut.isEmpty()) {
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(55).append("Network found without proper start date, sandre code : ").append(network.$bslash$bslash("DispositifCollecte").$bslash$bslash("CodeSandreRdd").text()).toString(), codeBss, $this.JobLogUtil.log$default$5());
            }
            return new AdesNetworkLink(piezoId, (Option<Object>)None$.MODULE$, network.$bslash$bslash("DispositifCollecte").$bslash$bslash("CodeSandreRdd").text(), (Option<DateTime>)dateDebut, (Option<DateTime>)Try$.MODULE$.apply((Function0 & Serializable)() -> DateUtil$.MODULE$.setMaxDay(this.dateFormat().parseDateTime(network.$bslash("DateFinAppartenance").text()))).toOption());
        });
    }

    public Seq<Landmark> parseLandmarks(Node xml, int piezoId) {
        return (Seq)xml.$bslash$bslash("ReperePointEau").map((Function1 & Serializable)landmark -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.dateFormat().parseDateTime(landmark.$bslash$bslash("DateDebValiditeReperePointEau").text()));
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw new Exception(new StringBuilder(43).append("Landmark found without proper start date : ").append(e.getMessage()).toString(), e);
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            DateTime date = (DateTime)success.value();
            DateTime dateDebut = date;
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> this.dateFormat().parseDateTime(landmark.$bslash$bslash("RefAltimetriquePointEau").$bslash$bslash("DateDebValiditeRefAltimetrique").text()));
            if (!(try_2 instanceof Success)) {
                if (try_2 instanceof Failure) {
                    Failure failure = (Failure)try_2;
                    Throwable e = failure.exception();
                    throw new Exception(new StringBuilder(51).append("Landmark refAlti found without proper start date : ").append(e.getMessage()).toString(), e);
                }
                throw new MatchError((Object)try_2);
            }
            Success success2 = (Success)try_2;
            DateTime date2 = (DateTime)success2.value();
            DateTime sysAltiDateDebut = date2;
            String hpe = landmark.$bslash$bslash("HauteurReperePointEau").text();
            return new Landmark((long)piezoId, (Option)new Some((Object)dateDebut.withTimeAtStartOfDay()), Try$.MODULE$.apply((Function0 & Serializable)() -> DateUtil$.MODULE$.setMaxDay(this.dateFormat().parseDateTime(landmark.$bslash$bslash("DateFinValiditeReperePointEau").text()))).toOption(), (Option)(hpe.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(hpe))))), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(landmark.$bslash("RefAltimetriquePointEau").$bslash$bslash("NatureRefAltimetrique").$bslash$bslash("CdNatureRefAltimetrique").text())))), Try$.MODULE$.apply((Function0 & Serializable)() -> landmark.$bslash$bslash("ComReperePointEau").text()).toOption(), Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(landmark.$bslash$bslash("RefAltimetriquePointEau").$bslash$bslash("NatureRefAltimetrique").$bslash$bslash("CdNatureRefAltimetrique").text()))).toOption(), (Option)new Some((Object)sysAltiDateDebut), Landmark$.MODULE$.$lessinit$greater$default$9());
        });
    }

    public Seq<AltimetrySystem> parseAltimetrySystems(Node xml, int piezoId) {
        return (Seq)xml.$bslash$bslash("RefAltiPointEau").map((Function1 & Serializable)altimetrySystem -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.dateFormat().parseDateTime(altimetrySystem.$bslash$bslash("DateDebValiditeRefAltimetrique").text()));
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw new Exception(new StringBuilder(51).append("Altimetry system found without proper start date : ").append(e.getMessage()).toString(), e);
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            DateTime date = (DateTime)success.value();
            DateTime dateDebut = date;
            return new AltimetrySystem(piezoId, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(altimetrySystem.$bslash$bslash("NatureRefAltimetrique").$bslash$bslash("CdNatureRefAltimetrique").text())))), (Option)new Some((Object)dateDebut.withTimeAtStartOfDay()), Try$.MODULE$.apply((Function0 & Serializable)() -> DateUtil$.MODULE$.setMaxDay(this.dateFormat().parseDateTime(altimetrySystem.$bslash$bslash("DateFinValiditeRefAltimetrique").text()))).toOption(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(altimetrySystem.$bslash$bslash("AltitudeRefAltimetriquePointEau").text())))), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(altimetrySystem.$bslash$bslash("SystAltimetriqueRefPointEau").text())))), Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(altimetrySystem.$bslash$bslash("ModeObtentionAltitude").text()))).toOption(), (Option)new Some((Object)altimetrySystem.$bslash$bslash("ComRefAltimetriquePointEau").text()), AltimetrySystem$.MODULE$.$lessinit$greater$default$9(), AltimetrySystem$.MODULE$.$lessinit$greater$default$10());
        });
    }

    public Seq<MeasureMethod> parseMeasureModes(Node xml, int piezoId, Seq<SandreCode> sandreCodes) {
        return (Seq)xml.$bslash$bslash("ModeMesurePiezo").map(arg_0 -> AdesPiezometryStationImport.$anonfun$parseMeasureModes$1(this, piezoId, sandreCodes, arg_0));
    }

    public Seq<DespoliationMode> parseDespoliationLinks(Node xml, int piezoId) {
        return (Seq)xml.$bslash$bslash("ModeDepouillementPiezo").map((Function1 & Serializable)despoliation -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.dateFormat().parseDateTime(despoliation.$bslash$bslash("DateDebUtilisationDepuillement").text()));
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw new Exception(new StringBuilder(47).append("Despoliation found without proper start date : ").append(e.getMessage()).toString(), e);
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            DateTime date = (DateTime)success.value();
            DateTime dateDebut = date;
            return new DespoliationMode((double)piezoId, dateDebut.withTimeAtStartOfDay(), Try$.MODULE$.apply((Function0 & Serializable)() -> DateUtil$.MODULE$.setMaxDay(this.dateFormat().parseDateTime(despoliation.$bslash("DateFinUtilisationDepuillement").text()))).toOption(), (Option)new Some((Object)despoliation.$bslash$bslash("MethodeDepouillement").text()), (Option)new Some((Object)despoliation.$bslash$bslash("ComModeDepouillement").text()));
        });
    }

    public Seq<Usage> parseWaterUsageLinks(Node xml, int piezoId, Seq<SandreCode> sandreCodes) {
        return (Seq)xml.$bslash$bslash("PeriodeUtilisationEau").map((Function1 & Serializable)usage -> {
            int waterUsageCode = ReferentialUtil$.MODULE$.getSandreCodeFromCodeOrReference(sandreCodes, SandreConstants$.MODULE$.USAGES_GENERAL(), usage.$bslash$bslash("UsageEau").$bslash$bslash("CdUsageEau").text(), Try$.MODULE$.apply((Function0 & Serializable)() -> usage.$bslash$bslash("UsageEau").$bslash$bslash("LbUsageEau").text()).toOption(), $this.sandreCodeDao);
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.dateFormat().parseDateTime(usage.$bslash$bslash("DateDebUtilisationEau").text()));
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw new Exception(new StringBuilder(40).append("Usage found without proper start date : ").append(e.getMessage()).toString(), e);
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            DateTime date = (DateTime)success.value();
            DateTime dateDebut = date;
            return new Usage(piezoId, (Option)new Some((Object)dateDebut), Try$.MODULE$.apply((Function0 & Serializable)() -> this.dateFormat().parseDateTime(usage.$bslash$bslash("DateFinUtilisationEau").text())).toOption(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)waterUsageCode)), (Option)new Some((Object)usage.$bslash$bslash("UsageEau").$bslash$bslash("LbUsageEau").text()));
        });
    }

    public Seq<Tuple3<String, String, StationHydroEntity>> parseHydroEntities(Node xml, int piezoId, long jobExecutionId) {
        return (Seq)xml.$bslash$bslash("PeriodeAppPteEntiteHydrogeol1").$plus$plus((Seq)xml.$bslash$bslash("PeriodeAppPteEntiteHydrogeol2")).map((Function1 & Serializable)entity -> {
            String sandreCode = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> entity.$bslash("EntiteHydroGeol").$bslash("CdEntiteHydrogeol").text()).toOption().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$6.trim())))).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> entity.$bslash("EntiteHydroGeol").$bslash("CdEntiteHydroGeologique").text()).toOption().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7.trim()))))).getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Pas de code Entite hydro dans la balise PeriodeAppPteEntiteHydrogeol");
            });
            String name = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> entity.$bslash("EntiteHydroGeol").$bslash("NomEntiteHydrogeol").text()).toOption().filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$8.trim())))).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> entity.$bslash("EntiteHydroGeol").$bslash("LbEntiteHydroGeol").text()).toOption().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$9.trim()))))).getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Pas de nom Entite hydro dans la balise PeriodeAppPteEntiteHydrogeol");
            });
            return new Tuple3((Object)sandreCode, (Object)name, (Object)new StationHydroEntity(piezoId, (Option)None$.MODULE$, Try$.MODULE$.apply((Function0 & Serializable)() -> entity.$bslash("DateDebAttriPteEntHydrogeo1").text()).toOption().filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$10.trim())))).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> entity.$bslash("DateDebAttriPteEntHydrogeo2").text()).toOption()).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$11.trim())))).map((Function1 & Serializable)date -> this.dateFormat().parseDateTime(date).withTimeAtStartOfDay()), Try$.MODULE$.apply((Function0 & Serializable)() -> entity.$bslash("DtFinAttrPteEntHydrogeo1").text()).toOption().filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$12.trim())))).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> entity.$bslash("DtFinAttrPteEntHydrogeo2").text()).toOption()).filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$13.trim())))).map((Function1 & Serializable)date -> this.dateFormat().parseDateTime(date).withTimeAtStartOfDay()), Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(entity.$bslash("QualiteAssociationPteEntHydrogeo1").text()))).toOption().orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(entity.$bslash("QualiteAssociationPteEntHydrogeo2").text()))).toOption()), Try$.MODULE$.apply((Function0 & Serializable)() -> entity.$bslash("CdIntervenant").text()).toOption().flatMap((Function1 & Serializable)siretOrSandre -> {
                None$ x$1 = None$.MODULE$;
                None$ x$2 = siretOrSandre.length() > 10 ? new Some(siretOrSandre) : None$.MODULE$;
                None$ x$3 = siretOrSandre.length() < 10 ? new Some(siretOrSandre) : None$.MODULE$;
                Option x$4 = Try$.MODULE$.apply((Function0 & Serializable)() -> entity.$bslash$bslash("NomIntervenant").text()).toOption();
                Some x$5 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId));
                Option x$6 = ContributorLight$.MODULE$.apply$default$6();
                Option x$7 = ContributorLight$.MODULE$.apply$default$7();
                ContributorLight contrib = new ContributorLight((Option)x$1, (Option)x$2, x$4, (Option)x$3, (Option)x$5, x$6, x$7);
                return ((ContributorLight)$this.ContributorsDao.createContributors((Seq)new .colon.colon((Object)contrib, (List)Nil$.MODULE$), (Option)None$.MODULE$).head()).id();
            }), Try$.MODULE$.apply((Function0 & Serializable)() -> entity.$bslash("ComAttriPteEntHydrogeo1").text()).toOption().orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> entity.$bslash("ComAttriPteEntHydrogeo2").text()).toOption()).filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$14.trim()))))));
        });
    }

    public static final /* synthetic */ boolean $anonfun$managePiezometerStations$3(Bss a$1, Tuple2 r) {
        String string = ((Bss)r._1()).wantedCode();
        String string2 = a$1.wantedCode();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$managePiezometerStations$2(Seq results$1, Bss a) {
        return !results$1.exists((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)AdesPiezometryStationImport.$anonfun$managePiezometerStations$3(a, r)));
    }

    public static final /* synthetic */ int $anonfun$managePiezometerStations$6(AdesPiezometryStationImport $this, long jobExecutionId$1, Bss bss$2, String user$1, InfoTerreBorehole infoTerreElem) {
        Option option = $this.piezometerDao.getWithLinks((String)infoTerreElem.newBSS().getOrElse((Function0 & Serializable)() -> infoTerreElem.code()));
        if (option instanceof Some) {
            Some some = (Some)option;
            PiezometerWithLinks piezo = (PiezometerWithLinks)some.value();
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(45).append("Updating Station from Infoterre data for bss ").append(bss$2.wantedCode()).toString(), bss$2.wantedCode(), $this.JobLogUtil.log$default$5());
            $this.adesWSUtil.addUserRightsUpdate((Option<String>)new Some((Object)user$1), bss$2.wantedCode(), BoxesRunTime.unboxToInt((Object)piezo.id().get()), jobExecutionId$1, HabilitationConstants$.MODULE$.PIEZO());
            Option<Object> x$12 = infoTerreElem.x();
            Option<Object> x$22 = infoTerreElem.y();
            Option x$3 = infoTerreElem.projection().map((Function1)(JFunction1.mcID.sp & Serializable)x$1 -> (int)x$1);
            Option<String> x$4 = infoTerreElem.designation();
            Option<String> x$5 = infoTerreElem.name();
            Option<String> x$6 = infoTerreElem.townCode();
            Option<Object> x$7 = infoTerreElem.nature();
            Option<DateTime> x$8 = infoTerreElem.creationDate();
            Option<Object> x$9 = infoTerreElem.altitude();
            Option<String> x$10 = infoTerreElem.comments();
            Option<Object> x$11 = infoTerreElem.jobExecutionId();
            Option x$122 = piezo.copy$default$1();
            Option x$13 = piezo.copy$default$2();
            Option x$14 = piezo.copy$default$6();
            Option x$15 = piezo.copy$default$11();
            Option x$16 = piezo.copy$default$12();
            Option x$17 = piezo.copy$default$15();
            Option x$18 = piezo.copy$default$17();
            Option x$19 = piezo.copy$default$18();
            Option x$20 = piezo.copy$default$19();
            Option x$21 = piezo.copy$default$20();
            Option x$222 = piezo.copy$default$21();
            Option x$23 = piezo.copy$default$22();
            Option x$24 = piezo.copy$default$24();
            Option x$25 = piezo.copy$default$25();
            Option x$26 = piezo.copy$default$26();
            Option x$27 = piezo.copy$default$27();
            Option x$28 = piezo.copy$default$28();
            Option x$29 = piezo.copy$default$29();
            Option x$30 = piezo.copy$default$30();
            Option x$31 = piezo.copy$default$31();
            Option x$32 = piezo.copy$default$32();
            Option x$33 = piezo.copy$default$33();
            Option x$34 = piezo.copy$default$34();
            Option x$35 = piezo.copy$default$35();
            Option x$36 = piezo.copy$default$36();
            Option x$37 = piezo.copy$default$37();
            Option x$38 = piezo.copy$default$38();
            Option x$39 = piezo.copy$default$39();
            Option x$40 = piezo.copy$default$40();
            Option x$41 = piezo.copy$default$41();
            Option x$42 = piezo.copy$default$42();
            Option x$43 = piezo.copy$default$43();
            Option x$44 = piezo.copy$default$44();
            Option x$45 = piezo.copy$default$45();
            Option x$46 = piezo.copy$default$46();
            Option x$47 = piezo.copy$default$47();
            Option x$48 = piezo.copy$default$48();
            Option x$49 = piezo.copy$default$49();
            Option x$50 = piezo.copy$default$50();
            Option x$51 = piezo.copy$default$51();
            PiezometerWithLinks piezoCopy = piezo.copy(x$122, x$13, x$5, x$7, x$8, x$14, x$12, x$22, x$3, x$9, x$15, x$16, x$10, x$6, x$17, x$4, x$18, x$19, x$20, x$21, x$222, x$23, x$11, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51);
            $this.piezometerDao.update(piezoCopy, user$1);
            return BoxesRunTime.unboxToInt((Object)piezo.id().get());
        }
        if (None$.MODULE$.equals(option)) {
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(45).append("Updating Station from Infoterre data for bss ").append(bss$2.wantedCode()).toString(), bss$2.wantedCode(), $this.JobLogUtil.log$default$5());
            None$ x$52 = None$.MODULE$;
            Option<String> x$53 = infoTerreElem.newBSS();
            Option<Object> x$54 = infoTerreElem.x();
            Option<Object> x$55 = infoTerreElem.y();
            Option x$56 = infoTerreElem.projection().map((Function1)(JFunction1.mcID.sp & Serializable)x$2 -> (int)x$2);
            Option<String> x$57 = infoTerreElem.designation();
            Option<String> x$58 = infoTerreElem.name();
            Option<String> x$59 = infoTerreElem.townCode();
            Option<Object> x$60 = infoTerreElem.nature();
            Option<DateTime> x$61 = infoTerreElem.creationDate();
            Option<Object> x$62 = infoTerreElem.altitude();
            Option<String> x$63 = infoTerreElem.comments();
            Option<Object> x$64 = infoTerreElem.jobExecutionId();
            Option x$65 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$6();
            Option x$66 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$11();
            Option x$67 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$12();
            Option x$68 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$15();
            Option x$69 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$17();
            Option x$70 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$18();
            Option x$71 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$19();
            Option x$72 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$20();
            Option x$73 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$21();
            Option x$74 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$22();
            Option x$75 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$24();
            Option x$76 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$25();
            Option x$77 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$26();
            Option x$78 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$27();
            Option x$79 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$28();
            Option x$80 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$29();
            Option x$81 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$30();
            Option x$82 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$31();
            Option x$83 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$32();
            Option x$84 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$33();
            Option x$85 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$34();
            Option x$86 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$35();
            Option x$87 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$36();
            Option x$88 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$37();
            Option x$89 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$38();
            Option x$90 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$39();
            Option x$91 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$40();
            Option x$92 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$41();
            Option x$93 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$42();
            Option x$94 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$43();
            Option x$95 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$44();
            Option x$96 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$45();
            Option x$97 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$46();
            Option x$98 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$47();
            Option x$99 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$48();
            Option x$100 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$49();
            Option x$101 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$50();
            Option x$102 = PiezometerWithLinks$.MODULE$.$lessinit$greater$default$51();
            PiezometerWithLinks newPiezo = new PiezometerWithLinks(x$53, (Option)x$52, x$58, x$60, x$61, x$65, x$54, x$55, x$56, x$62, x$66, x$67, x$63, x$59, x$68, x$57, x$69, x$70, x$71, x$72, x$73, x$74, x$64, x$75, x$76, x$77, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$102);
            Option returnValue = $this.piezometerDao.insert(newPiezo, user$1);
            $this.adesWSUtil.addUserRightsCreation((Option<String>)new Some((Object)user$1), (int)((Tuple2)returnValue.get())._2$mcD$sp(), HabilitationConstants$.MODULE$.PIEZO());
            return (int)((Tuple2)returnValue.get())._2$mcD$sp();
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ StationLocation $anonfun$getAdesPiezometer$1(int id$1, Piezometer piezometer$1, int proj) {
        return new StationLocation((double)id$1, (Option)new Some((Object)BoxesRunTime.boxToDouble((double)proj)), piezometer$1.x(), piezometer$1.y(), piezometer$1.altitude(), (Option)None$.MODULE$);
    }

    public static final /* synthetic */ StationLocation $anonfun$getAdesPiezometer$2(int id$1, Piezometer piezometer$1, int proj) {
        return new StationLocation((double)id$1, (Option)new Some((Object)BoxesRunTime.boxToDouble((double)proj)), piezometer$1.x(), piezometer$1.y(), piezometer$1.altitude(), (Option)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$parsePiezometer$2(AdesPiezometryStationImport $this, Node n) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> $this.dateFormat().parseDateTime(n.$bslash$bslash("DateFinAppartenance").text())).toOption().isDefined();
    }

    public static final /* synthetic */ DateTime $anonfun$parseMeasureModes$2(AdesPiezometryStationImport $this, Node measurementMode$1) {
        return $this.dateFormat().parseDateTime(measurementMode$1.$bslash$bslash("DateDebUtilisationModeMesure").text());
    }

    public static final /* synthetic */ DateTime $anonfun$parseMeasureModes$3(AdesPiezometryStationImport $this, Node measurementMode$1) {
        return DateUtil$.MODULE$.setMaxDay($this.dateFormat().parseDateTime(measurementMode$1.$bslash$bslash("DateFinUtilisationModeMesure").text()));
    }

    public static final /* synthetic */ String $anonfun$parseMeasureModes$4(Node measurementMode$1) {
        return measurementMode$1.$bslash$bslash("ComModeMesurePiezo").text();
    }

    public static final /* synthetic */ int $anonfun$parseMeasureModes$5(Node measurementMode$1) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(measurementMode$1.$bslash$bslash("PeriodiciteAcquisition").text()));
    }

    public static final /* synthetic */ int $anonfun$parseMeasureModes$6(Node measurementMode$1) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(measurementMode$1.$bslash$bslash("PrecisionMesure").text()));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ MeasureMethod $anonfun$parseMeasureModes$1(AdesPiezometryStationImport $this, int piezoId$8, Seq sandreCodes$2, Node measurementMode) {
        var6_4 = Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseMeasureModes$2(ades.controller.piezometry.AdesPiezometryStationImport scala.xml.Node ), ()Lorg/joda/time/DateTime;)((AdesPiezometryStationImport)$this, (Node)measurementMode));
        if (!(var6_4 instanceof Success)) {
            if (var6_4 instanceof Failure) {
                var9_7 = (Failure)var6_4;
                e = var9_7.exception();
                throw new Exception(new StringBuilder(47).append("Measure mode found without proper start date : ").append(e.getMessage()).toString(), e);
            }
            throw new MatchError((Object)var6_4);
        }
        var7_5 = (Success)var6_4;
        date = (DateTime)var7_5.value();
        dateDebut = date;
        periodicite = measurementMode.$bslash$bslash("PeriodiciteMesure").text();
        x$1 = piezoId$8;
        x$2 = new Some((Object)dateDebut.withTimeAtStartOfDay());
        x$3 = Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseMeasureModes$3(ades.controller.piezometry.AdesPiezometryStationImport scala.xml.Node ), ()Lorg/joda/time/DateTime;)((AdesPiezometryStationImport)$this, (Node)measurementMode)).toOption();
        x$4 = new Some((Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(measurementMode.$bslash$bslash("MethodeMesure").text()))));
        if (measurementMode.$bslash$bslash("PeriodiciteMesure").isEmpty()) ** GOTO lbl-1000
        v0 = periodicite;
        var17_15 = "";
        if (!(v0 != null ? v0.equals(var17_15) == false : var17_15 != null)) lbl-1000:
        // 2 sources

        {
            v1 = None$.MODULE$;
        } else {
            v1 = new Some((Object)BoxesRunTime.boxToInteger((int)ReferentialUtil$.MODULE$.getSandreCode(sandreCodes$2, "MODES_MESURES.PERIODICITE", periodicite, $this.sandreCodeDao)));
        }
        x$5 = v1;
        x$6 = Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseMeasureModes$4(scala.xml.Node ), ()Ljava/lang/String;)((Node)measurementMode)).toOption();
        x$7 = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$parseMeasureModes$5(scala.xml.Node ), ()I)((Node)measurementMode)).toOption();
        x$8 = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$parseMeasureModes$6(scala.xml.Node ), ()I)((Node)measurementMode)).toOption();
        x$9 = MeasureMethod$.MODULE$.$lessinit$greater$default$7();
        x$10 = MeasureMethod$.MODULE$.$lessinit$greater$default$8();
        return new MeasureMethod(x$1, (Option)x$2, x$3, (Option)x$4, (Option)x$5, x$6, x$9, x$10, x$7, x$8);
    }

    @Inject
    public AdesPiezometryStationImport(LogUtil LogUtil2, AdesWSUtil adesWSUtil, ADESPiezometerDao ADESPiezometerDao2, SandreCodeDao sandreCodeDao, JobLogUtil JobLogUtil2, ContributorsDao ContributorsDao2, PiezometerDaeau piezometerDao) {
        this.LogUtil = LogUtil2;
        this.adesWSUtil = adesWSUtil;
        this.ADESPiezometerDao = ADESPiezometerDao2;
        this.sandreCodeDao = sandreCodeDao;
        this.JobLogUtil = JobLogUtil2;
        this.ContributorsDao = ContributorsDao2;
        this.piezometerDao = piezometerDao;
        Producer.$init$((Producer)this);
        this.dateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    }
}

