/*
 * Decompiled with CFR 0.152.
 */
package ades.dao.piezometry;

import ades.AdesWSUtil;
import ades.controller.AdesFilter;
import ades.dao.piezometry.ADESPiezometerDao;
import ades.domain.piezometry.AdesNetworkLink;
import ades.domain.piezometry.AdesPiezometer;
import ades.model.Bss;
import anorm.Column$;
import anorm.ParameterMetaData;
import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import anorm.package$;
import fr.aquasys.daeau.piezometry.domain.PiezometerWithLinks;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.itf.PiezometryEventDao;
import fr.aquasys.daeau.referentials.city.itf.CityDao;
import fr.aquasys.daeau.referentials.network.dao.NetworkDao;
import fr.aquasys.daeau.referentials.sandreCode.constants.SandreConstants$;
import fr.aquasys.daeau.referentials.sandreCode.dao.SandreCodeDao;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode;
import fr.aquasys.daeau.referentials.sandreCode.model.SandreCode$;
import fr.aquasys.daeau.referentials.watermass.itf.WatermassDao;
import fr.aquasys.daeau.station.links.altimetrySystem.StationAltimetrySystemDao;
import fr.aquasys.daeau.station.links.contributor.StationContributorDao;
import fr.aquasys.daeau.station.links.contributor.StationContributorLink;
import fr.aquasys.daeau.station.links.despoliationMode.StationDespoliationModeDao;
import fr.aquasys.daeau.station.links.functions.StationFunctionDao;
import fr.aquasys.daeau.station.links.hydroEntity.StationHydroEntity;
import fr.aquasys.daeau.station.links.hydroEntity.StationHydroEntityDao;
import fr.aquasys.daeau.station.links.landmark.StationLandmarkDao;
import fr.aquasys.daeau.station.links.locations.StationLocationDao;
import fr.aquasys.daeau.station.links.measureMethod.StationMeasureMethodDao;
import fr.aquasys.daeau.station.links.network.StationNetwork;
import fr.aquasys.daeau.station.links.network.StationNetworkDao;
import fr.aquasys.daeau.station.links.tempRef.StationTempRefDao;
import fr.aquasys.daeau.station.links.usages.StationUsageDao;
import fr.aquasys.daeau.station.links.watermass.StationWatermassDao;
import fr.aquasys.daeau.station.links.work.StationWorkDao;
import fr.aquasys.daeau.user.constant.HabilitationConstants$;
import fr.aquasys.rabbitmq.api.constant.SSERouting$;
import fr.aquasys.rabbitmq.util.JobType$;
import fr.aquasys.rabbitmq.util.SSEUtil;
import fr.aquasys.utils.AlgoUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import play.api.db.Database;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\t]f\u0001B\u000e\u001d\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ya\f\u0005\ts\u0001\u0011\t\u0011)A\u0006u!Aq\t\u0001B\u0001B\u0003-\u0001\n\u0003\u0005R\u0001\t\u0005\t\u0015a\u0003S\u0011!I\u0006A!A!\u0002\u0017Q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b1\u00022\t\u0011%\u0004!\u0011!Q\u0001\f)D\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006Y!\u001e\u0005\tq\u0002\u0011\t\u0011)A\u0006s\"Aa\u0010\u0001B\u0001B\u0003-q\u0010\u0003\u0006\u0002\f\u0001\u0011\t\u0011)A\u0006\u0003\u001bA!\"!\u0007\u0001\u0005\u0003\u0005\u000b1BA\u000e\u0011)\t9\u0003\u0001B\u0001B\u0003-\u0011\u0011\u0006\u0005\u000b\u0003k\u0001!\u0011!Q\u0001\f\u0005]\u0002BCA\"\u0001\t\u0005\t\u0015a\u0003\u0002F!Q\u0011q\n\u0001\u0003\u0002\u0003\u0006Y!!\u0015\t\u0015\u0005u\u0003A!A!\u0002\u0017\ty\u0006\u0003\u0006\u0002l\u0001\u0011\t\u0011)A\u0006\u0003[B!\"!\u001f\u0001\u0005\u0003\u0005\u000b1BA>\u0011)\t\u0019\t\u0001B\u0001B\u0003-\u0011Q\u0011\u0005\u000b\u0003#\u0003!\u0011!Q\u0001\f\u0005M\u0005BCAP\u0001\t\u0005\t\u0015a\u0003\u0002\"\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0006bBA|\u0001\u0011\u0005\u0013\u0011 \u0005\n\u0005;\u0002\u0011\u0013!C\u0001\u0005?BqA!\u001e\u0001\t\u0003\u00119H\u0001\fB]>\u0014X.\u0011#F'BKWM_8nKR,'\u000fR1p\u0015\tib$\u0001\u0006qS\u0016Tx.\\3uefT!a\b\u0011\u0002\u0007\u0011\fwNC\u0001\"\u0003\u0011\tG-Z:\u0004\u0001M\u0019\u0001\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g!\tYC&D\u0001\u001d\u0013\tiCDA\tB\t\u0016\u001b\u0006+[3{_6,G/\u001a:EC>\f\u0001\u0002Z1uC\n\f7/\u001a\t\u0003a]j\u0011!\r\u0006\u0003eM\n!\u0001\u001a2\u000b\u0005Q*\u0014aA1qS*\ta'\u0001\u0003qY\u0006L\u0018B\u0001\u001d2\u0005!!\u0015\r^1cCN,\u0017a\u00049jKj|W.\u001a;fe\u0012\u000bW-Y;\u0011\u0005m*U\"\u0001\u001f\u000b\u0005ur\u0014aA5uM*\u0011Qd\u0010\u0006\u0003\u0001\u0006\u000bQ\u0001Z1fCVT!AQ\"\u0002\u000f\u0005\fX/Y:zg*\tA)\u0001\u0002ge&\u0011a\t\u0010\u0002\u0010!&,'p\\7fi\u0016\u0014H)Y3bk\u0006Qa.\u001a;x_J\\G)Y8\u0011\u0005%{U\"\u0001&\u000b\u0005}Y%B\u0001'N\u0003\u001dqW\r^<pe.T!AT \u0002\u0019I,g-\u001a:f]RL\u0017\r\\:\n\u0005AS%A\u0003(fi^|'o\u001b#b_\u000691-\u001b;z\t\u0006|\u0007CA*X\u001b\u0005!&BA\u001fV\u0015\t1V*\u0001\u0003dSRL\u0018B\u0001-U\u0005\u001d\u0019\u0015\u000e^=EC>\fAb^1uKJl\u0017m]:EC>\u0004\"aW0\u000e\u0003qS!!P/\u000b\u0005yk\u0015!C<bi\u0016\u0014X.Y:t\u0013\t\u0001GL\u0001\u0007XCR,'/\\1tg\u0012\u000bw.A\u0007tC:$'/Z\"pI\u0016$\u0015m\u001c\t\u0003G\u001el\u0011\u0001\u001a\u0006\u0003?\u0015T!AZ'\u0002\u0015M\fg\u000e\u001a:f\u0007>$W-\u0003\u0002iI\ni1+\u00198ee\u0016\u001cu\u000eZ3EC>\f!c\u001d;bi&|g\u000eT8dCRLwN\u001c#b_B\u00111N]\u0007\u0002Y*\u0011QN\\\u0001\nY>\u001c\u0017\r^5p]NT!a\u001c9\u0002\u000b1Lgn[:\u000b\u0005E|\u0014aB:uCRLwN\\\u0005\u0003g2\u0014!c\u0015;bi&|g\u000eT8dCRLwN\u001c#b_\u0006\u0011\u0002+[3{_6,GO]=Fm\u0016tG\u000fR1p!\tYd/\u0003\u0002xy\t\u0011\u0002+[3{_6,GO]=Fm\u0016tG\u000fR1p\u0003E\u0019H/\u0019;j_:tU\r^<pe.$\u0015m\u001c\t\u0003url\u0011a\u001f\u0006\u0003\u0019:L!!`>\u0003#M#\u0018\r^5p]:+Go^8sW\u0012\u000bw.\u0001\nTi\u0006$\u0018n\u001c8MC:$W.\u0019:l\t\u0006|\u0007\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015a.\u0001\u0005mC:$W.\u0019:l\u0013\u0011\tI!a\u0001\u0003%M#\u0018\r^5p]2\u000bg\u000eZ7be.$\u0015m\\\u0001\u001a'R\fG/[8o\u00032$\u0018.\\3uef\u001c\u0016p\u001d;f[\u0012\u000bw\u000e\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019B\\\u0001\u0010C2$\u0018.\\3uef\u001c\u0016p\u001d;f[&!\u0011qCA\t\u0005e\u0019F/\u0019;j_:\fE\u000e^5nKR\u0014\u0018pU=ti\u0016lG)Y8\u0002/M#\u0018\r^5p]6+\u0017m];sK6+G\u000f[8e\t\u0006|\u0007\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005b.A\u0007nK\u0006\u001cXO]3NKRDw\u000eZ\u0005\u0005\u0003K\tyBA\fTi\u0006$\u0018n\u001c8NK\u0006\u001cXO]3NKRDw\u000e\u001a#b_\u0006Q2\u000b^1uS>tG)Z:q_2L\u0017\r^5p]6{G-\u001a#b_B!\u00111FA\u0019\u001b\t\tiCC\u0002\u000209\f\u0001\u0003Z3ta>d\u0017.\u0019;j_:lu\u000eZ3\n\t\u0005M\u0012Q\u0006\u0002\u001b'R\fG/[8o\t\u0016\u001c\bo\u001c7jCRLwN\\'pI\u0016$\u0015m\\\u0001\u0016gR\fG/[8o\u0007>tGO]5ckR|'\u000fR1p!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001f]\u0006Y1m\u001c8ue&\u0014W\u000f^8s\u0013\u0011\t\t%a\u000f\u0003+M#\u0018\r^5p]\u000e{g\u000e\u001e:jEV$xN\u001d#b_\u0006\u00192\u000b^1uS>tw+\u0019;fe6\f7o\u001d#b_B!\u0011qIA&\u001b\t\tIE\u0003\u0002_]&!\u0011QJA%\u0005M\u0019F/\u0019;j_:<\u0016\r^3s[\u0006\u001c8\u000fR1p\u0003=\u0019H/\u0019;j_:,6/Y4f\t\u0006|\u0007\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]c.\u0001\u0004vg\u0006<Wm]\u0005\u0005\u00037\n)FA\bTi\u0006$\u0018n\u001c8Vg\u0006<W\rR1p\u0003AyWO\u001e:bO\u0016\u001c\b+[3{_\u0012\u000bw\u000e\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)G\\\u0001\u0005o>\u00148.\u0003\u0003\u0002j\u0005\r$AD*uCRLwN\\,pe.$\u0015m\\\u0001\u0012gR\fG/[8o)\u0016l\u0007OU3g\t\u0006|\u0007\u0003BA8\u0003kj!!!\u001d\u000b\u0007\u0005Md.A\u0004uK6\u0004(+\u001a4\n\t\u0005]\u0014\u0011\u000f\u0002\u0012'R\fG/[8o)\u0016l\u0007OU3g\t\u0006|\u0017AC1eKN<6+\u0016;jYB!\u0011QPA@\u001b\u0005\u0001\u0013bAAAA\tQ\u0011\tZ3t/N+F/\u001b7\u0002%M#\u0018\r^5p]\u001a+hn\u0019;j_:$\u0015m\u001c\t\u0005\u0003\u000f\u000bi)\u0004\u0002\u0002\n*\u0019\u00111\u00128\u0002\u0013\u0019,hn\u0019;j_:\u001c\u0018\u0002BAH\u0003\u0013\u0013!c\u0015;bi&|gNR;oGRLwN\u001c#b_\u0006)2\u000b^1uS>t\u0007*\u001f3s_\u0016sG/\u001b;z\t\u0006|\u0007\u0003BAK\u00037k!!a&\u000b\u0007\u0005ee.A\u0006is\u0012\u0014x.\u00128uSRL\u0018\u0002BAO\u0003/\u0013Qc\u0015;bi&|g\u000eS=ee>,e\u000e^5us\u0012\u000bw.A\u0004T'\u0016+F/\u001b7\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006!Q\u000f^5m\u0015\r\tY+Q\u0001\te\u0006\u0014'-\u001b;nc&!\u0011qVAS\u0005\u001d\u00196+R+uS2\fa\u0001P5oSRtDCAA[)9\n9,!/\u0002<\u0006u\u0016qXAa\u0003\u0007\f)-a2\u0002J\u0006-\u0017QZAh\u0003#\f\u0019.!6\u0002X\u0006e\u00171\\Ao\u0003?\f\t/a9\u0011\u0005-\u0002\u0001\"\u0002\u0018\u0018\u0001\by\u0003\"B\u001d\u0018\u0001\bQ\u0004\"B$\u0018\u0001\bA\u0005\"B)\u0018\u0001\b\u0011\u0006\"B-\u0018\u0001\bQ\u0006\"B1\u0018\u0001\b\u0011\u0007\"B5\u0018\u0001\bQ\u0007\"\u0002;\u0018\u0001\b)\b\"\u0002=\u0018\u0001\bI\b\"\u0002@\u0018\u0001\by\bbBA\u0006/\u0001\u000f\u0011Q\u0002\u0005\b\u000339\u00029AA\u000e\u0011\u001d\t9c\u0006a\u0002\u0003SAq!!\u000e\u0018\u0001\b\t9\u0004C\u0004\u0002D]\u0001\u001d!!\u0012\t\u000f\u0005=s\u0003q\u0001\u0002R!9\u0011QL\fA\u0004\u0005}\u0003bBA6/\u0001\u000f\u0011Q\u000e\u0005\b\u0003s:\u00029AA>\u0011\u001d\t\u0019i\u0006a\u0002\u0003\u000bCq!!%\u0018\u0001\b\t\u0019\nC\u0004\u0002 ^\u0001\u001d!!))\u0007]\t9\u000f\u0005\u0003\u0002j\u0006MXBAAv\u0015\u0011\ti/a<\u0002\r%t'.Z2u\u0015\t\t\t0A\u0003kCZ\f\u00070\u0003\u0003\u0002v\u0006-(AB%oU\u0016\u001cG/\u0001\u000bj[B|'\u000f^!eKN\u0004\u0016.\u001a>p[\u0016$XM\u001d\u000b\r\u0003w\u0014\tAa\u0005\u0003$\t\r#1\u000b\t\u0004K\u0005u\u0018bAA\u0000M\t\u0019\u0011J\u001c;\t\u000f\t\r\u0001\u00041\u0001\u0003\u0006\u0005)\u0001/[3{_B!!q\u0001B\b\u001b\t\u0011IAC\u0002\u001e\u0005\u0017Q1A!\u0004!\u0003\u0019!w.\\1j]&!!\u0011\u0003B\u0005\u00059\tE-Z:QS\u0016Tx.\\3uKJDqA!\u0006\u0019\u0001\u0004\u00119\"A\u0002cgN\u0004BA!\u0007\u0003 5\u0011!1\u0004\u0006\u0004\u0005;\u0001\u0013!B7pI\u0016d\u0017\u0002\u0002B\u0011\u00057\u00111AQ:t\u0011%\u0011)\u0003\u0007I\u0001\u0002\u0004\u00119#\u0001\u0003vg\u0016\u0014\b#B\u0013\u0003*\t5\u0012b\u0001B\u0016M\t1q\n\u001d;j_:\u0004BAa\f\u0003>9!!\u0011\u0007B\u001d!\r\u0011\u0019DJ\u0007\u0003\u0005kQ1Aa\u000e#\u0003\u0019a$o\\8u}%\u0019!1\b\u0014\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011yD!\u0011\u0003\rM#(/\u001b8h\u0015\r\u0011YD\n\u0005\b\u0005\u000bB\u0002\u0019\u0001B$\u0003\u001d1\u0017\u000e\u001c;feN\u0004BA!\u0013\u0003P5\u0011!1\n\u0006\u0004\u0005\u001b\u0002\u0013AC2p]R\u0014x\u000e\u001c7fe&!!\u0011\u000bB&\u0005)\tE-Z:GS2$XM\u001d\u0005\b\u0005+B\u0002\u0019\u0001B,\u00039QwNY#yK\u000e,H/[8o\u0013\u0012\u00042!\nB-\u0013\r\u0011YF\n\u0002\u0005\u0019>tw-\u0001\u0010j[B|'\u000f^!eKN\u0004\u0016.\u001a>p[\u0016$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\r\u0016\u0005\u0005O\u0011\u0019g\u000b\u0002\u0003fA!!q\rB9\u001b\t\u0011IG\u0003\u0003\u0003l\t5\u0014!C;oG\",7m[3e\u0015\r\u0011yGJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B:\u0005S\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Q)\b\u000fZ1uKN\u000bg\u000e\u001a:f\u001d\u0016$xo\u001c:lgR1!\u0011\u0010BH\u0005'#B!a?\u0003|!9!Q\u0010\u000eA\u0004\t}\u0014!A2\u0011\t\t\u0005%1R\u0007\u0003\u0005\u0007SAA!\"\u0003\b\u0006\u00191/\u001d7\u000b\u0005\t%\u0015\u0001\u00026bm\u0006LAA!$\u0003\u0004\nQ1i\u001c8oK\u000e$\u0018n\u001c8\t\u000f\tE%\u00041\u0001\u0002|\u0006I\u0011\u000eZ*uCRLwN\u001c\u0005\b\u0005+S\u0002\u0019\u0001BL\u0003!qW\r^<pe.\u001c\bC\u0002BM\u0005G\u0013IK\u0004\u0003\u0003\u001c\n}e\u0002\u0002B\u001a\u0005;K\u0011aJ\u0005\u0004\u0005C3\u0013a\u00029bG.\fw-Z\u0005\u0005\u0005K\u00139KA\u0002TKFT1A!)'!\rQ(1V\u0005\u0004\u0005[[(AD*uCRLwN\u001c(fi^|'o\u001b\u0015\u0004\u0001\tE\u0006\u0003BAu\u0005gKAA!.\u0002l\nI1+\u001b8hY\u0016$xN\u001c")
public class AnormADESPiezometerDao
implements ADESPiezometerDao {
    private final Database database;
    private final PiezometerDaeau piezometerDaeau;
    private final NetworkDao networkDao;
    private final CityDao cityDao;
    private final WatermassDao watermassDao;
    private final SandreCodeDao sandreCodeDao;
    private final StationLocationDao stationLocationDao;
    private final PiezometryEventDao PiezometryEventDao;
    private final StationLandmarkDao StationLandmarkDao;
    private final StationAltimetrySystemDao StationAltimetrySystemDao;
    private final StationMeasureMethodDao StationMeasureMethodDao;
    private final StationDespoliationModeDao StationDespoliationModeDao;
    private final StationContributorDao stationContributorDao;
    private final StationWatermassDao StationWatermassDao;
    private final StationUsageDao stationUsageDao;
    private final StationWorkDao ouvragesPiezoDao;
    private final StationTempRefDao stationTempRefDao;
    private final AdesWSUtil adesWSUtil;
    private final StationFunctionDao StationFunctionDao;
    private final StationHydroEntityDao StationHydroEntityDao;
    private final SSEUtil SSEUtil;

    @Override
    public int importAdesPiezometer(AdesPiezometer piezo, Bss bss, Option<String> user, AdesFilter filters, long jobExecutionId) {
        int idPiezo;
        block1: {
            IntRef citiesCreated = IntRef.create((int)0);
            BooleanRef stationCreated = BooleanRef.create((boolean)false);
            idPiezo = BoxesRunTime.unboxToInt((Object)this.database.withTransaction((Function1 & Serializable)c -> BoxesRunTime.boxToInteger((int)AnormADESPiezometerDao.$anonfun$importAdesPiezometer$1(this, piezo, bss, user, jobExecutionId, stationCreated, citiesCreated, filters, c))));
            if (citiesCreated.elem > 0) {
                this.SSEUtil.broadcast(SSERouting$.MODULE$.SSE_CITY_REFRESH(), "");
            }
            if (!stationCreated.elem) break block1;
            this.SSEUtil.broadcast(SSERouting$.MODULE$.SSE_PIEZO_REFRESH(), "");
        }
        return idPiezo;
    }

    @Override
    public Option<String> importAdesPiezometer$default$3() {
        return None$.MODULE$;
    }

    public int updateSandreNetworks(int idStation, Seq<StationNetwork> networks, Connection c) {
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.intToStatement$ x$3 = ToStatement$.MODULE$.intToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)idStation), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"delete from lien_piezo_reseaux where codepiezometre = ", " and codereseau IN (select codereseau from reseaux where length(codesandre) > 0)"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).executeUpdate(c);
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)networks.map((Function1 & Serializable)network -> BoxesRunTime.boxToInteger((int)AnormADESPiezometerDao.$anonfun$updateSandreNetworks$1(idStation, c, network)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$importAdesPiezometer$6(String oldBss$1, StationContributorLink c) {
        return c.internalReference().contains((Object)oldBss$1);
    }

    public static final /* synthetic */ boolean $anonfun$importAdesPiezometer$7(String oldBssWithDesign$1, StationContributorLink c) {
        return c.internalReference().contains((Object)oldBssWithDesign$1);
    }

    public static final /* synthetic */ int $anonfun$importAdesPiezometer$1(AnormADESPiezometerDao $this, AdesPiezometer piezo$1, Bss bss$1, Option user$1, long jobExecutionId$1, BooleanRef stationCreated$1, IntRef citiesCreated$1, AdesFilter filters$1, Connection c) {
        Object object;
        int created;
        Object object2;
        int n2;
        PiezometerWithLinks piezoInput = new PiezometerWithLinks(piezo$1.piezometer());
        Option option = bss$1.id().map((Function1)(JFunction1.mcID.sp & Serializable)x$1 -> (int)x$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            int idFound = BoxesRunTime.unboxToInt((Object)some.value());
            $this.piezometerDaeau.updateWC(piezoInput, (String)user$1.getOrElse((Function0 & Serializable)() -> "SYSTEM"), c);
            $this.adesWSUtil.addUserRightsUpdate((Option<String>)user$1, bss$1.wantedCode(), idFound, jobExecutionId$1, HabilitationConstants$.MODULE$.PIEZO());
            n2 = idFound;
        } else if (None$.MODULE$.equals(option)) {
            int id = (int)((Tuple2)$this.piezometerDaeau.insertWC(piezoInput, (String)user$1.getOrElse((Function0 & Serializable)() -> "SYSTEM"), c).get())._2$mcD$sp();
            $this.adesWSUtil.addUserRightsCreation((Option<String>)user$1, id, HabilitationConstants$.MODULE$.PIEZO());
            stationCreated$1.elem = true;
            n2 = id;
        } else {
            throw new MatchError((Object)option);
        }
        int piezoId = n2;
        Option<String> otherCode = bss$1.wantedCode().startsWith("BSS") ? bss$1.oldCode() : bss$1.newCode();
        otherCode.foreach((Function1 & Serializable)oldBss -> {
            String oldBssWithDesign;
            Seq seq;
            Seq contribs = $this.stationContributorDao.getContributorLinksWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), (long)piezoId, c);
            if (!contribs.exists((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)AnormADESPiezometerDao.$anonfun$importAdesPiezometer$6(oldBss, c)))) {
                StationContributorLink stationContributorLink = new StationContributorLink((long)piezoId, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some(oldBss), (Option)None$.MODULE$, (Option)None$.MODULE$);
                Seq newContribs = (Seq)contribs.$plus$colon((Object)stationContributorLink);
                $this.stationContributorDao.setContributorLinksWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), (long)piezoId, newContribs, c);
                seq = newContribs;
            } else {
                seq = contribs;
            }
            Seq contribsWithOther = seq;
            String string = oldBssWithDesign = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(oldBss), '/')));
            String string2 = oldBss;
            if ((string == null ? string2 != null : !string.equals(string2)) && !contribsWithOther.exists((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)AnormADESPiezometerDao.$anonfun$importAdesPiezometer$7(oldBssWithDesign, c)))) {
                StationContributorLink stationContributorLink = new StationContributorLink((long)piezoId, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)oldBssWithDesign), (Option)None$.MODULE$, (Option)None$.MODULE$);
                Seq newContribs = (Seq)contribsWithOther.$plus$colon((Object)stationContributorLink);
                return BoxesRunTime.boxToInteger((int)$this.stationContributorDao.setContributorLinksWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), (long)piezoId, newContribs, c));
            }
            return BoxedUnit.UNIT;
        });
        $this.StationFunctionDao.setFunctionsWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), piezoId, piezo$1.functions(), c);
        if (piezo$1.hydroEntities().nonEmpty()) {
            Seq entities = (Seq)piezo$1.hydroEntities().map((Function1 & Serializable)x0$1 -> {
                Tuple3 tuple3 = x0$1;
                if (tuple3 != null) {
                    String code = (String)tuple3._1();
                    String name = (String)tuple3._2();
                    StationHydroEntity entity = (StationHydroEntity)tuple3._3();
                    ParameterValue[] parameterValueArray = new ParameterValue[1];
                    ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
                    Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)code, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
                    Option option = (Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select codeentitehydro from entites_hydrogeologiques where code_sandre=", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToInt()).singleOpt(), c);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int eid = BoxesRunTime.unboxToInt((Object)some.value());
                        Some x$5 = new Some((Object)BoxesRunTime.boxToInteger((int)eid));
                        int x$6 = entity.copy$default$1();
                        Option x$7 = entity.copy$default$3();
                        Option x$8 = entity.copy$default$4();
                        Option x$9 = entity.copy$default$5();
                        Option x$10 = entity.copy$default$6();
                        Option x$11 = entity.copy$default$7();
                        return entity.copy(x$6, (Option)x$5, x$7, x$8, x$9, x$10, x$11);
                    }
                    if (None$.MODULE$.equals(option)) {
                        ParameterValue[] parameterValueArray2 = new ParameterValue[2];
                        ToStatementPriority0.stringToStatement$ x$14 = ToStatement$.MODULE$.stringToStatement();
                        Null$ x$15 = ToParameterValue$.MODULE$.apply$default$1();
                        parameterValueArray2[0] = ParameterValue$.MODULE$.from((Object)name, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$14));
                        ToStatementPriority0.stringToStatement$ x$18 = ToStatement$.MODULE$.stringToStatement();
                        Null$ x$19 = ToParameterValue$.MODULE$.apply$default$1();
                        parameterValueArray2[1] = ParameterValue$.MODULE$.from((Object)code, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$18));
                        int newId = BoxesRunTime.unboxToInt((Object)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"insert into entites_hydrogeologiques (codeentitehydro, nom, code_sandre) values (\n                           (SELECT COALESCE(MAX(codeentitehydro),0) + 1 from entites_hydrogeologiques),\n                           ", ",\n                           ", "\n                           ) returning codeentitehydro"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray2)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToInt()).single(), c));
                        Some x$20 = new Some((Object)BoxesRunTime.boxToInteger((int)newId));
                        int x$21 = entity.copy$default$1();
                        Option x$22 = entity.copy$default$3();
                        Option x$23 = entity.copy$default$4();
                        Option x$24 = entity.copy$default$5();
                        Option x$25 = entity.copy$default$6();
                        Option x$26 = entity.copy$default$7();
                        return entity.copy(x$21, (Option)x$20, x$22, x$23, x$24, x$25, x$26);
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError((Object)tuple3);
            });
            object2 = BoxesRunTime.boxToInteger((int)$this.StationHydroEntityDao.setHydroEntitiesWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), piezoId, entities, c));
        } else {
            object2 = BoxedUnit.UNIT;
        }
        Tuple2 tuple2 = $this.cityDao.createCitiesWC((Seq)new .colon.colon((Object)piezo$1.city(), (List)Nil$.MODULE$), c);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int created2 = tuple2._2$mcI$sp();
        citiesCreated$1.elem = created = created2;
        $this.sandreCodeDao.createSandreCodeWC(new SandreCode(SandreConstants$.MODULE$.PROJECTION(), BoxesRunTime.unboxToInt((Object)piezo$1.piezometer().projection().get()), new StringBuilder(2).append("<").append(piezo$1.piezometer().projection().get()).append(">").toString(), SandreCode$.MODULE$.$lessinit$greater$default$4(), SandreCode$.MODULE$.$lessinit$greater$default$5(), SandreCode$.MODULE$.$lessinit$greater$default$6(), SandreCode$.MODULE$.$lessinit$greater$default$7(), SandreCode$.MODULE$.$lessinit$greater$default$8(), SandreCode$.MODULE$.$lessinit$greater$default$9(), SandreCode$.MODULE$.$lessinit$greater$default$10(), SandreCode$.MODULE$.$lessinit$greater$default$11(), SandreCode$.MODULE$.$lessinit$greater$default$12(), SandreCode$.MODULE$.$lessinit$greater$default$13(), SandreCode$.MODULE$.$lessinit$greater$default$14()), $this.sandreCodeDao.createSandreCodeWC$default$2(), c);
        $this.stationLocationDao.setLocationsWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), piezoId, (Seq)new .colon.colon(piezo$1.location(), (List)Nil$.MODULE$).flatten(Predef$.MODULE$.$conforms()), c);
        Object object3 = BoxesRunTime.unboxToBoolean((Object)filters$1.syncEvents().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true)) ? BoxesRunTime.boxToInteger((int)$this.PiezometryEventDao.setPiezometerEventsWCForJob(piezo$1.events(), piezoId, JobType$.MODULE$.WS_ADES_PIEZO(), c)) : BoxedUnit.UNIT;
        if (!piezo$1.isPointEauMode()) {
            Object object4;
            $this.watermassDao.createWatermassesWC(piezo$1.watermasses(), c);
            if (BoxesRunTime.unboxToBoolean((Object)filters$1.syncNetworks().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true))) {
                Map networkIds = $this.networkDao.createNetworksWC(piezo$1.networks(), user$1, c);
                Seq networkLinks = (Seq)((IterableOps)piezo$1.networkLinks().map((Function1 & Serializable)n -> {
                    AdesNetworkLink adesNetworkLink;
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(n.sandreCode()))) {
                        Some x$27 = new Some(networkIds.apply((Object)n.sandreCode()));
                        int x$28 = n.copy$default$1();
                        String x$29 = n.copy$default$3();
                        Option<DateTime> x$30 = n.copy$default$4();
                        Option<DateTime> x$31 = n.copy$default$5();
                        adesNetworkLink = n.copy(x$28, (Option<Object>)x$27, x$29, x$30, x$31);
                    } else {
                        adesNetworkLink = n;
                    }
                    return adesNetworkLink.toNetworkLink();
                })).map((Function1 & Serializable)n -> {
                    Some x$32 = new Some(n.startDate().getOrElse((Function0 & Serializable)() -> new DateTime(1970, 1, 1, 1, 1)));
                    int x$33 = n.copy$default$1();
                    Option x$34 = n.copy$default$2();
                    Option x$35 = n.copy$default$4();
                    return n.copy(x$33, x$34, (Option)x$32, x$35);
                });
                object4 = BoxesRunTime.boxToInteger((int)$this.updateSandreNetworks(piezoId, (Seq<StationNetwork>)AlgoUtil$.MODULE$.uniqBy(networkLinks, (Function1 & Serializable)n -> n.idNetwork()), c));
            } else {
                object4 = BoxedUnit.UNIT;
            }
            $this.StationLandmarkDao.setLandmarksWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), piezoId, piezo$1.landmarks(), c);
            $this.StationAltimetrySystemDao.setAltimetrySystemsWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), piezoId, piezo$1.altimetrySystems(), c);
            $this.StationMeasureMethodDao.setMeasureMethodsWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), piezoId, piezo$1.measureModes(), c);
            $this.StationDespoliationModeDao.setDespoliationModesWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), piezoId, piezo$1.despoliationLinks(), c);
            $this.StationWatermassDao.setWatermassesWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), piezoId, piezo$1.watermassLinks(), c);
            $this.stationUsageDao.setUsagesWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), (long)piezoId, piezo$1.waterUsageLinks(), c);
            piezo$1.depth().map((Function1)(JFunction1.mcID.sp & Serializable)depth -> $this.ouvragesPiezoDao.setDepth(piezoId, depth, c));
            object = BoxesRunTime.boxToInteger((int)$this.stationTempRefDao.setTempRefsWC(StationTypeUtil$.MODULE$.PIEZOMETRY(), piezoId, piezo$1.refTomporelle(), c));
        } else if (piezo$1.networkLinks().nonEmpty() && BoxesRunTime.unboxToBoolean((Object)filters$1.syncNetworks().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true))) {
            Map networkIds = $this.networkDao.createNetworksWC(piezo$1.networks(), user$1, c);
            Seq networkLinks = (Seq)((IterableOps)piezo$1.networkLinks().map((Function1 & Serializable)n -> {
                AdesNetworkLink adesNetworkLink;
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(n.sandreCode()))) {
                    Some x$36 = new Some(networkIds.apply((Object)n.sandreCode()));
                    int x$37 = n.copy$default$1();
                    String x$38 = n.copy$default$3();
                    Option<DateTime> x$39 = n.copy$default$4();
                    Option<DateTime> x$40 = n.copy$default$5();
                    adesNetworkLink = n.copy(x$37, (Option<Object>)x$36, x$38, x$39, x$40);
                } else {
                    adesNetworkLink = n;
                }
                return adesNetworkLink.toNetworkLink();
            })).map((Function1 & Serializable)n -> {
                Some x$41 = new Some(n.startDate().getOrElse((Function0 & Serializable)() -> new DateTime(1970, 1, 1, 1, 1)));
                int x$42 = n.copy$default$1();
                Option x$43 = n.copy$default$2();
                Option x$44 = n.copy$default$4();
                return n.copy(x$42, x$43, (Option)x$41, x$44);
            });
            object = BoxesRunTime.boxToInteger((int)$this.updateSandreNetworks(piezoId, (Seq<StationNetwork>)AlgoUtil$.MODULE$.uniqBy(networkLinks, (Function1 & Serializable)n -> n.idNetwork()), c));
        } else {
            object = BoxedUnit.UNIT;
        }
        return piezoId;
    }

    public static final /* synthetic */ int $anonfun$updateSandreNetworks$1(int idStation$1, Connection c$2, StationNetwork network) {
        ParameterValue[] parameterValueArray = new ParameterValue[4];
        ToStatementPriority0.intToStatement$ x$7 = ToStatement$.MODULE$.intToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)idStation$1), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ToStatement x$11 = ToStatement$.MODULE$.optionToStatement((ToStatement)ToStatement$.MODULE$.intToStatement(), (ParameterMetaData)ParameterMetaData.IntParameterMetaData$.MODULE$);
        Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)network.idNetwork(), ToParameterValue$.MODULE$.apply(null, x$11));
        ToStatement x$15 = ToStatement$.MODULE$.optionToStatement((ToStatement)ToStatement$.MODULE$.dateToStatement(), (ParameterMetaData)ParameterMetaData.DateParameterMetaData$.MODULE$);
        Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)network.startDate().map((Function1 & Serializable)d -> d.toDate()), ToParameterValue$.MODULE$.apply(null, x$15));
        ToStatement x$19 = ToStatement$.MODULE$.optionToStatement((ToStatement)ToStatement$.MODULE$.dateToStatement(), (ParameterMetaData)ParameterMetaData.DateParameterMetaData$.MODULE$);
        Null$ x$20 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[3] = ParameterValue$.MODULE$.from((Object)network.endDate().map((Function1 & Serializable)d -> d.toDate()), ToParameterValue$.MODULE$.apply(null, x$19));
        return package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO lien_piezo_reseaux (codepiezometre, codereseau, datedebut, datefin)\n                 VALUES (\n                    ", ",\n                    ", ",\n                    ", ",\n                    ", "\n                 )"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).executeUpdate(c$2);
    }

    @Inject
    public AnormADESPiezometerDao(Database database, PiezometerDaeau piezometerDaeau, NetworkDao networkDao, CityDao cityDao, WatermassDao watermassDao, SandreCodeDao sandreCodeDao, StationLocationDao stationLocationDao, PiezometryEventDao PiezometryEventDao2, StationNetworkDao stationNetworkDao, StationLandmarkDao StationLandmarkDao2, StationAltimetrySystemDao StationAltimetrySystemDao2, StationMeasureMethodDao StationMeasureMethodDao2, StationDespoliationModeDao StationDespoliationModeDao2, StationContributorDao stationContributorDao, StationWatermassDao StationWatermassDao2, StationUsageDao stationUsageDao, StationWorkDao ouvragesPiezoDao, StationTempRefDao stationTempRefDao, AdesWSUtil adesWSUtil, StationFunctionDao StationFunctionDao2, StationHydroEntityDao StationHydroEntityDao2, SSEUtil SSEUtil2) {
        this.database = database;
        this.piezometerDaeau = piezometerDaeau;
        this.networkDao = networkDao;
        this.cityDao = cityDao;
        this.watermassDao = watermassDao;
        this.sandreCodeDao = sandreCodeDao;
        this.stationLocationDao = stationLocationDao;
        this.PiezometryEventDao = PiezometryEventDao2;
        this.StationLandmarkDao = StationLandmarkDao2;
        this.StationAltimetrySystemDao = StationAltimetrySystemDao2;
        this.StationMeasureMethodDao = StationMeasureMethodDao2;
        this.StationDespoliationModeDao = StationDespoliationModeDao2;
        this.stationContributorDao = stationContributorDao;
        this.StationWatermassDao = StationWatermassDao2;
        this.stationUsageDao = stationUsageDao;
        this.ouvragesPiezoDao = ouvragesPiezoDao;
        this.stationTempRefDao = stationTempRefDao;
        this.adesWSUtil = adesWSUtil;
        this.StationFunctionDao = StationFunctionDao2;
        this.StationHydroEntityDao = StationHydroEntityDao2;
        this.SSEUtil = SSEUtil2;
    }
}

