/*
 * Decompiled with CFR 0.152.
 */
package check.controller;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constant.JobState$;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.constant.JobRouting$;
import fr.aquasys.rabbitmq.api.constant.MailRouting$;
import fr.aquasys.rabbitmq.api.constant.PiezometryRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import model.Measure;
import model.Measure$;
import model.constants.CheckTypes$;
import org.joda.time.DateTime;
import org.joda.time.Hours;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.libs.F;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.parallel.CollectionConverters;
import scala.collection.parallel.CollectionConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;
import util.DateUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001B\u0006\r\u0001EA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006Y!\n\u0005\tW\u0001\u0011\t\u0011)A\u0006Y!)!\u0007\u0001C\u0001g!9!\t\u0001b\u0001\n\u0003\u0019\u0005B\u0002)\u0001A\u0003%A\tC\u0003R\u0001\u0011\u0005!\u000bC\u0003d\u0001\u0011\u0005A\rC\u0005\u0002 \u0001\t\n\u0011\"\u0001\u0002\"!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002bBA \u0001\u0011\u0005\u0011\u0011\t\u0002\u0015!&,'p\\7fi\u0016\u00148i\u001c8ue>dG.\u001a:\u000b\u00055q\u0011AC2p]R\u0014x\u000e\u001c7fe*\tq\"A\u0003dQ\u0016\u001c7n\u0001\u0001\u0014\u0007\u0001\u0011\u0002\u0004\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033\tj\u0011A\u0007\u0006\u00037q\t1!\u00199j\u0015\tib$\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0015\ty\u0002%A\u0004bcV\f7/_:\u000b\u0003\u0005\n!A\u001a:\n\u0005\rR\"\u0001\u0003)s_\u0012,8-\u001a:\u0002\u000f1{w-\u0016;jYB\u0011a%K\u0007\u0002O)\u0011\u0001\u0006H\u0001\u0005kRLG.\u0003\u0002+O\t9Aj\\4Vi&d\u0017A\u0003&pE2{w-\u0016;jYB\u0011Q\u0006M\u0007\u0002])\u0011qFH\u0001\u0006kRLGn]\u0005\u0003c9\u0012!BS8c\u0019><W\u000b^5m\u0003\u0019a\u0014N\\5u}Q\tA\u0007F\u00026oa\u0002\"A\u000e\u0001\u000e\u00031AQ\u0001J\u0002A\u0004\u0015BQaK\u0002A\u00041B#a\u0001\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014AB5oU\u0016\u001cGOC\u0001@\u0003\u0015Q\u0017M^1y\u0013\t\tEH\u0001\u0004J]*,7\r^\u0001\u0011M>\u0014X.\u0019;ECf\u0004\u0016\r\u001e;fe:,\u0012\u0001\u0012\t\u0003\u000b:k\u0011A\u0012\u0006\u0003\u000f\"\u000baAZ8s[\u0006$(BA%K\u0003\u0011!\u0018.\\3\u000b\u0005-c\u0015\u0001\u00026pI\u0006T\u0011!T\u0001\u0004_J<\u0017BA(G\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM]\u0001\u0012M>\u0014X.\u0019;ECf\u0004\u0016\r\u001e;fe:\u0004\u0013aB3yK\u000e,H/\u001a\u000b\u0003'Z\u0003\"a\u0005+\n\u0005U#\"\u0001B+oSRDQa\u0016\u0004A\u0002a\u000bq!\\3tg\u0006<W\r\u0005\u0002ZC6\t!L\u0003\u0002\\9\u0006!!n]8o\u0015\tif,\u0001\u0003mS\n\u001c(BA\u000e`\u0015\u0005\u0001\u0017\u0001\u00029mCfL!A\u0019.\u0003\u000f)\u001bh+\u00197vK\u0006a1\r[3dW6+\u0017m];sKR1Q\r`A\u0005\u0003+\u0001BAZ9ui:\u0011qM\u001c\b\u0003Q6t!!\u001b7\u000e\u0003)T!a\u001b\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0017BA/`\u0013\ty\u0007/A\u0001G\u0015\tiv,\u0003\u0002sg\n)A+\u001e9mK*\u0011q\u000e\u001d\t\u0003kft!A^<\u0011\u0005%$\u0012B\u0001=\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011!p\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a$\u0002\"B?\b\u0001\u0004q\u0018aB7fCN,(/\u001a\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\t\t\u0019!A\u0003n_\u0012,G.\u0003\u0003\u0002\b\u0005\u0005!aB'fCN,(/\u001a\u0005\b\u0003\u00179\u0001\u0019AA\u0007\u0003\u0011!\u0017\r^3\u0011\t\u0005=\u0011\u0011C\u0007\u0002\u0011&\u0019\u00111\u0003%\u0003\u0011\u0011\u000bG/\u001a+j[\u0016D\u0011\"a\u0006\b!\u0003\u0005\r!!\u0007\u0002\u0015\u0019,H\u000e\u001c#fi\u0006LG\u000eE\u0002\u0014\u00037I1!!\b\u0015\u0005\u001d\u0011un\u001c7fC:\fac\u00195fG.lU-Y:ve\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003GQC!!\u0007\u0002&-\u0012\u0011q\u0005\t\u0005\u0003S\t\u0019$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003%)hn\u00195fG.,GMC\u0002\u00022Q\t!\"\u00198o_R\fG/[8o\u0013\u0011\t)$a\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bde\u0016\fG/\u001a\"pY\u0012$Vm\u001d;\u0015\u0007Q\fY\u0004\u0003\u0004\u0002>%\u0001\r\u0001^\u0001\u0006m\u0006dW/Z\u0001\fO\u0016$X*Z1tkJ,7\u000f\u0006\u0004\u0002D\u0005U\u00131\f\t\u0006\u0003\u000b\nyE \b\u0005\u0003\u000f\nYED\u0002j\u0003\u0013J\u0011!F\u0005\u0004\u0003\u001b\"\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003#\n\u0019FA\u0002TKFT1!!\u0014\u0015\u0011\u001d\t9F\u0003a\u0001\u00033\n!\u0002]1sC6,G/\u001a:t!\u0015\t)%a\u0014u\u0011\u001d\tiF\u0003a\u0001\u00033\n\u0011\u0002Z1uCRK\b/Z:")
public class PiezometerController
implements Producer {
    private final LogUtil LogUtil;
    private final JobLogUtil JobLogUtil;
    private final DateTimeFormatter formatDayPattern;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        PiezometerController piezometerController = this;
        synchronized (piezometerController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public DateTimeFormatter formatDayPattern() {
        return this.formatDayPattern;
    }

    public void execute(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            this.LogUtil.error(new StringBuilder(43).append("Error validate Json to execute Check Job :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), this.LogUtil.error$default$2());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)jobParams -> {
            PiezometerController.$anonfun$execute$2(this, jobParams);
            return BoxedUnit.UNIT;
        });
    }

    public F.Tuple<String, String> checkMeasure(Measure measure, DateTime date, boolean fullDetail) {
        Option<Object> option = measure.error();
        if (option instanceof Some) {
            String string;
            Some some = (Some)option;
            int error = BoxesRunTime.unboxToInt((Object)some.value());
            if (!fullDetail && measure.code().isDefined()) {
                String message = new StringBuilder(10).append(this.createBoldTest((String)measure.code().get())).append(" - No data").toString();
                return F.Tuple((Object)CheckTypes$.MODULE$.ALERT(), (Object)message);
            }
            int n = error;
            switch (n) {
                case 400: {
                    Option<Object> option2 = measure.id();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        int id = BoxesRunTime.unboxToInt((Object)some2.value());
                        string = new StringBuilder(30).append("Type does not exist, Station :").append(id).toString();
                        break;
                    }
                    string = "Error reading input";
                    break;
                }
                case 404: {
                    string = new StringBuilder(20).append("Station not found : ").append(measure.id().get()).toString();
                    break;
                }
                case 204: {
                    string = new StringBuilder(31).append("No measure found for station : ").append(this.createBoldTest((String)measure.code().get())).toString();
                    break;
                }
                default: {
                    string = "Unknown error";
                    break;
                }
            }
            String message = string;
            return F.Tuple((Object)CheckTypes$.MODULE$.FAILURE(), (Object)message);
        }
        int diff = Hours.hoursBetween((ReadableInstant)((ReadableInstant)measure.creationDate().get()), (ReadableInstant)date).getHours();
        String formatHour = DateUtil$.MODULE$.hourFormater().print((ReadableInstant)measure.hour().get());
        String formatDay = this.formatDayPattern().print((ReadableInstant)measure.creationDate().get());
        boolean bl = ((DateTime)measure.creationDate().get()).plus(BoxesRunTime.unboxToLong((Object)measure.timeMax().get())).isAfter((ReadableInstant)date);
        if (bl) {
            return F.Tuple((Object)CheckTypes$.MODULE$.SUCCESS(), (Object)new StringBuilder(61).append("Last measure well integrate for station ").append(this.createBoldTest((String)measure.code().get())).append(" at ").append(formatHour).append(" the ").append(formatDay).append(", ").append(diff).append(" hours ago").toString());
        }
        if (!bl) {
            return F.Tuple((Object)CheckTypes$.MODULE$.ALERT(), (Object)new StringBuilder(47).append("Station ").append(this.createBoldTest((String)measure.code().get())).append(", last integration ").append(diff).append(" hours ago, at ").append(formatHour).append(" the ").append(formatDay).toString());
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public boolean checkMeasure$default$3() {
        return false;
    }

    public String createBoldTest(String value) {
        return new StringBuilder(7).append("<b>").append(value).append("</b>").toString();
    }

    public Seq<Measure> getMeasures(Seq<String> parameters, Seq<String> dataTypes) {
        return (Seq)CollectionConverters.ImmutableSeqIsParallelizable$.MODULE$.par$extension(CollectionConverters$.MODULE$.ImmutableSeqIsParallelizable(parameters)).map((Function1 & Serializable)id -> (Seq)dataTypes.map((Function1 & Serializable)dataType -> {
            Measure result = (Measure)Await$.MODULE$.result(this.sendRPC(PiezometryRouting$.MODULE$.PIEZOMETER_MEASURE_LAST_READ(), Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(id))), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper(dataType, (Writes)Writes$.MODULE$.StringWrites()))})).toString(), Measure$.MODULE$.jsonReads(), ClassTag$.MODULE$.apply(Measure.class)), (Duration)Duration$.MODULE$.Inf());
            Some x$1 = new Some(dataType);
            Option<DateTime> x$2 = result.copy$default$1();
            Option<DateTime> x$3 = result.copy$default$2();
            Option<Object> x$4 = result.copy$default$3();
            Option<String> x$5 = result.copy$default$4();
            Option<Object> x$6 = result.copy$default$5();
            Option<Object> x$7 = result.copy$default$6();
            Option<Object> x$8 = result.copy$default$7();
            return result.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option<String>)x$1);
        })).seq().flatten(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$execute$9(Tuple2 x$2) {
        return ((IterableOnceOps)x$2._2()).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$execute$2(PiezometerController $this, JobParameters jobParams) {
        int n = ((SeqOps)jobParams.emails().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).length();
        switch (n) {
            case 0: {
                $this.JobLogUtil.log(jobParams.jobExecutionId(), JobState$.MODULE$.ERROR(), "No email defined", "", $this.JobLogUtil.log$default$5());
                break;
            }
            default: {
                Seq seq;
                Seq seq2;
                DateTime date = DateTime.now();
                Option option = jobParams.parameters();
                if (option instanceof Some) {
                    Seq parameters;
                    Some some = (Some)option;
                    seq2 = parameters = (Seq)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    seq2 = (Seq)Nil$.MODULE$;
                } else {
                    throw new MatchError((Object)option);
                }
                Seq parameters = seq2;
                Option option2 = jobParams.dataTypes();
                if (option2 instanceof Some) {
                    Seq dataTypes;
                    Some some = (Some)option2;
                    seq = dataTypes = (Seq)some.value();
                } else if (None$.MODULE$.equals(option2)) {
                    seq = (Seq)Nil$.MODULE$;
                } else {
                    throw new MatchError((Object)option2);
                }
                Seq dataTypes = seq;
                Seq<Measure> measures = $this.getMeasures((Seq<String>)parameters, (Seq<String>)dataTypes);
                Map groupDataTypes = measures.groupBy((Function1 & Serializable)x$1 -> x$1.dataType());
                Map dataTypeMessage = (Map)groupDataTypes.map((Function1 & Serializable)o -> {
                    HashMap defaultResult = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CheckTypes$.MODULE$.ALERT()), (Object)Nil$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CheckTypes$.MODULE$.FAILURE()), (Object)Nil$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CheckTypes$.MODULE$.SUCCESS()), (Object)Nil$.MODULE$)}));
                    HashMap sortedMeasures = (HashMap)((IterableOnceOps)o._2()).foldLeft((Object)defaultResult, (Function2 & Serializable)(a, v) -> {
                        F.Tuple<String, String> checkedMeasure = $this.checkMeasure((Measure)v, date, $this.checkMeasure$default$3());
                        Seq value = (Seq)((SeqOps)a.get(checkedMeasure._1).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).$colon$plus(checkedMeasure._2);
                        return (HashMap)a.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(checkedMeasure._1), (Object)value));
                    });
                    return new Tuple2(o._1(), (Object)sortedMeasures);
                });
                String content = ((IterableOnceOps)dataTypeMessage.map((Function1 & Serializable)o -> {
                    HashMap listOfChecks = (HashMap)o._2();
                    if (((SeqOps)listOfChecks.get((Object)CheckTypes$.MODULE$.ALERT()).get()).length() > 0 || ((SeqOps)listOfChecks.get((Object)CheckTypes$.MODULE$.FAILURE()).get()).length() > 0) {
                        String dataTypeLine = new StringBuilder(60).append("<p style=\"font-size:15px;font-weight:bold;color:black;\">").append(((Option)o._1()).get()).append("</p>").toString();
                        String result = ((IterableOnceOps)((StrictOptimizedIterableOps)listOfChecks.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PiezometerController.$anonfun$execute$9(x$2)))).map((Function1 & Serializable)v -> ((IterableOnceOps)((IterableOps)v._2()).map((Function1 & Serializable)m -> new StringBuilder(10).append("<p> - ").append((String)m).append("</p>").toString())).mkString(""))).mkString("<br /><hr /><br />");
                        return new StringBuilder(0).append(dataTypeLine).append(result).toString();
                    }
                    return "";
                })).mkString("");
                if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(content))) break;
                String firstRow = new StringBuilder(26).append("Data acquisition failed : ").append(DateUtil$.MODULE$.fullFormater().print((ReadableInstant)date)).toString();
                String subject = new StringBuilder(36).append("AQUASYS - Data acquisition alert on ").append(Properties$.MODULE$.envOrElse("APPLICATION_NAME", (Function0 & Serializable)() -> "SIEAU")).toString();
                String message = Source$.MODULE$.fromFile($this.getClass().getResource("/squelettes_mail/checkData.html").toURI(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("").replace("{title}", firstRow).replace("{content}", content);
                ((IterableOnceOps)jobParams.emails().get()).foreach((Function1 & Serializable)email -> {
                    $this.sendTopic(MailRouting$.MODULE$.MAIL_SEND(), Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)message, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subject"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)subject, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"support@aquasys.fr", (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)email, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isHtml"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((boolean)true), (Writes)Writes$.MODULE$.BooleanWrites()))})).toString());
                    return BoxedUnit.UNIT;
                });
                break;
            }
        }
        $this.sendTopic(JobRouting$.MODULE$.JOB_EXECUTION_COMPLETE(), Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jobExecutionId"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)jobParams.jobExecutionId()), (Writes)Writes$.MODULE$.LongWrites()))})).toString());
    }

    @Inject
    public PiezometerController(LogUtil LogUtil2, JobLogUtil JobLogUtil2) {
        this.LogUtil = LogUtil2;
        this.JobLogUtil = JobLogUtil2;
        Producer.$init$((Producer)this);
        this.formatDayPattern = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
    }
}

