/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constant.JobState$;
import csvorexcel.controllers.ScadaController;
import csvorexcel.dao.scada.ScadaDao;
import csvorexcel.model.CSVDataColumn;
import csvorexcel.model.CSVFilter;
import csvorexcel.model.CSVFilter$;
import csvorexcel.model.scada.ScadaMeasure;
import csvorexcel.model.scada.ScadaMeasure$;
import csvorexcel.model.scada.ScadaParameters;
import csvorexcel.model.scada.ScadaParameters$;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.libs.F;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001B\u0005\u000b\u0001=A\u0001B\t\u0001\u0003\u0002\u0003\u0006Ya\t\u0005\tW\u0001\u0011\t\u0011)A\u0006Y!A\u0001\u0007\u0001B\u0001B\u0003-\u0011\u0007\u0003\u00058\u0001\t\u0005\t\u0015a\u00039\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\u00111$Q9vC\n{\u0007\u0010U5fu>lW\r^3s\u0007>tGO]8mY\u0016\u0014(BA\u0006\r\u0003-\u0019wN\u001c;s_2dWM]:\u000b\u00035\t!bY:w_J,\u0007pY3m\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003I\u0007\u00021)\u0011\u0011DG\u0001\u0004CBL'BA\u000e\u001d\u0003!\u0011\u0018M\u00192ji6\f(BA\u000f\u001f\u0003\u001d\t\u0017/^1tsNT\u0011aH\u0001\u0003MJL!!\t\r\u0003\u0011A\u0013x\u000eZ;dKJ\f\u0001b]2bI\u0006$\u0015m\u001c\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nQa]2bI\u0006T!\u0001\u000b\u0007\u0002\u0007\u0011\fw.\u0003\u0002+K\tA1kY1eC\u0012\u000bw.A\btG\u0006$\u0017mQ8oiJ|G\u000e\\3s!\tic&D\u0001\u000b\u0013\ty#BA\bTG\u0006$\u0017mQ8oiJ|G\u000e\\3s\u0003\u001daunZ+uS2\u0004\"AM\u001b\u000e\u0003MR!\u0001\u000e\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003mM\u0012q\u0001T8h+RLG.\u0001\u0006K_\ndunZ+uS2\u0004\"!\u000f\u001f\u000e\u0003iR!a\u000f\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005uR$A\u0003&pE2{w-\u0016;jY\u00061A(\u001b8jiz\"\u0012\u0001\u0011\u000b\u0006\u0003\n\u001bE)\u0012\t\u0003[\u0001AQAI\u0003A\u0004\rBQaK\u0003A\u00041BQ\u0001M\u0003A\u0004EBQaN\u0003A\u0004aB#!B$\u0011\u0005!kU\"A%\u000b\u0005)[\u0015AB5oU\u0016\u001cGOC\u0001M\u0003\u0015Q\u0017M^1y\u0013\tq\u0015J\u0001\u0004J]*,7\r^\u0001\bKb,7-\u001e;f)\t\tF\u000b\u0005\u0002\u0012%&\u00111K\u0005\u0002\u0005+:LG\u000fC\u0003V\r\u0001\u0007a+A\u0004nKN\u001c\u0018mZ3\u0011\u0005]{V\"\u0001-\u000b\u0005eS\u0016\u0001\u00026t_:T!a\u0017/\u0002\t1L'm\u001d\u0006\u00033uS\u0011AX\u0001\u0005a2\f\u00170\u0003\u0002a1\n9!j\u001d,bYV,\u0017!C4fi\u001aKG\u000e^3s)\u0011\u0019\u0017.!\u0002\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019d\u0011!B7pI\u0016d\u0017B\u00015f\u0005%\u00195K\u0016$jYR,'\u000fC\u0003k\u000f\u0001\u00071.A\u0004gS2$XM]:\u0011\u0007Eag.\u0003\u0002n%\t1q\n\u001d;j_:\u00042a\\<{\u001d\t\u0001XO\u0004\u0002ri6\t!O\u0003\u0002t\u001d\u00051AH]8pizJ\u0011aE\u0005\u0003mJ\tq\u0001]1dW\u0006<W-\u0003\u0002ys\n\u00191+Z9\u000b\u0005Y\u0014\u0002CA>\u0000\u001d\taX\u0010\u0005\u0002r%%\u0011aPE\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00111\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\u0014\u0002bBA\u0004\u000f\u0001\u0007\u0011\u0011B\u0001\u000fU>\u0014W\t_3dkRLwN\\%e!\r\t\u00121B\u0005\u0004\u0003\u001b\u0011\"\u0001\u0002'p]\u001e\fQbZ3u!\u0006\u0014\u0018-\\3uKJ\u001cHCBA\n\u0003?\t\u0019\u0003\u0005\u0003po\u0006U\u0001\u0003BA\f\u00037i!!!\u0007\u000b\u0005\u0019*\u0017\u0002BA\u000f\u00033\u0011qbU2bI\u0006\u0004\u0016M]1nKR,'o\u001d\u0005\u0007\u0003CA\u0001\u0019A6\u0002\u0015A\f'/Y7fi\u0016\u00148\u000fC\u0004\u0002\b!\u0001\r!!\u0003)\u0007\u0001\t9\u0003E\u0002I\u0003SI1!a\u000bJ\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class AquaBoxPiezometerController
implements Producer {
    private final ScadaDao scadaDao;
    private final LogUtil LogUtil;
    private final JobLogUtil JobLogUtil;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        AquaBoxPiezometerController aquaBoxPiezometerController = this;
        synchronized (aquaBoxPiezometerController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public void execute(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            this.LogUtil.error(new StringBuilder(53).append("Error validate Json to execute AquaBox integration :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), this.LogUtil.error$default$2());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)jobParameters -> {
            AquaBoxPiezometerController.$anonfun$execute$2(this, jobParameters);
            return BoxedUnit.UNIT;
        });
    }

    public CSVFilter getFilter(Option<Seq<String>> filters, long jobExecutionId) {
        Option<Seq<String>> option = filters;
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq filter2 = (Seq)some.value();
            return (CSVFilter)Json$.MODULE$.parse((String)filter2.head()).validate(CSVFilter$.MODULE$.jsonReads()).fold((Function1 & Serializable)error -> {
                $this.LogUtil.error(new StringBuilder(85).append("Error validate Json to execute Aquabox Integration : filters, for job execution : ").append(jobExecutionId).append(", \n").append(error).toString(), $this.LogUtil.error$default$2());
                return new CSVFilter(CSVFilter$.MODULE$.$lessinit$greater$default$1(), CSVFilter$.MODULE$.$lessinit$greater$default$2(), CSVFilter$.MODULE$.$lessinit$greater$default$3(), CSVFilter$.MODULE$.$lessinit$greater$default$4(), CSVFilter$.MODULE$.$lessinit$greater$default$5(), CSVFilter$.MODULE$.$lessinit$greater$default$6(), CSVFilter$.MODULE$.$lessinit$greater$default$7(), CSVFilter$.MODULE$.$lessinit$greater$default$8(), CSVFilter$.MODULE$.$lessinit$greater$default$9(), CSVFilter$.MODULE$.$lessinit$greater$default$10(), CSVFilter$.MODULE$.$lessinit$greater$default$11(), CSVFilter$.MODULE$.$lessinit$greater$default$12(), CSVFilter$.MODULE$.$lessinit$greater$default$13(), CSVFilter$.MODULE$.$lessinit$greater$default$14(), CSVFilter$.MODULE$.$lessinit$greater$default$15(), CSVFilter$.MODULE$.$lessinit$greater$default$16(), CSVFilter$.MODULE$.$lessinit$greater$default$17(), CSVFilter$.MODULE$.$lessinit$greater$default$18(), CSVFilter$.MODULE$.$lessinit$greater$default$19(), CSVFilter$.MODULE$.$lessinit$greater$default$20(), CSVFilter$.MODULE$.$lessinit$greater$default$21(), CSVFilter$.MODULE$.$lessinit$greater$default$22(), CSVFilter$.MODULE$.$lessinit$greater$default$23(), CSVFilter$.MODULE$.$lessinit$greater$default$24(), CSVFilter$.MODULE$.$lessinit$greater$default$25(), CSVFilter$.MODULE$.$lessinit$greater$default$26(), CSVFilter$.MODULE$.$lessinit$greater$default$27(), CSVFilter$.MODULE$.$lessinit$greater$default$28());
            }, (Function1 & Serializable)filter -> filter);
        }
        if (None$.MODULE$.equals(option)) {
            this.LogUtil.error(new StringBuilder(59).append("No filters passed to Aquabox Integration job for execution ").append(jobExecutionId).toString(), this.LogUtil.error$default$2());
            return new CSVFilter(CSVFilter$.MODULE$.$lessinit$greater$default$1(), CSVFilter$.MODULE$.$lessinit$greater$default$2(), CSVFilter$.MODULE$.$lessinit$greater$default$3(), CSVFilter$.MODULE$.$lessinit$greater$default$4(), CSVFilter$.MODULE$.$lessinit$greater$default$5(), CSVFilter$.MODULE$.$lessinit$greater$default$6(), CSVFilter$.MODULE$.$lessinit$greater$default$7(), CSVFilter$.MODULE$.$lessinit$greater$default$8(), CSVFilter$.MODULE$.$lessinit$greater$default$9(), CSVFilter$.MODULE$.$lessinit$greater$default$10(), CSVFilter$.MODULE$.$lessinit$greater$default$11(), CSVFilter$.MODULE$.$lessinit$greater$default$12(), CSVFilter$.MODULE$.$lessinit$greater$default$13(), CSVFilter$.MODULE$.$lessinit$greater$default$14(), CSVFilter$.MODULE$.$lessinit$greater$default$15(), CSVFilter$.MODULE$.$lessinit$greater$default$16(), CSVFilter$.MODULE$.$lessinit$greater$default$17(), CSVFilter$.MODULE$.$lessinit$greater$default$18(), CSVFilter$.MODULE$.$lessinit$greater$default$19(), CSVFilter$.MODULE$.$lessinit$greater$default$20(), CSVFilter$.MODULE$.$lessinit$greater$default$21(), CSVFilter$.MODULE$.$lessinit$greater$default$22(), CSVFilter$.MODULE$.$lessinit$greater$default$23(), CSVFilter$.MODULE$.$lessinit$greater$default$24(), CSVFilter$.MODULE$.$lessinit$greater$default$25(), CSVFilter$.MODULE$.$lessinit$greater$default$26(), CSVFilter$.MODULE$.$lessinit$greater$default$27(), CSVFilter$.MODULE$.$lessinit$greater$default$28());
        }
        throw new MatchError(option);
    }

    public Seq<ScadaParameters> getParameters(Option<Seq<String>> parameters, long jobExecutionId) {
        Option<Seq<String>> option = parameters;
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq params = (Seq)some.value();
            return (Seq)params.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable)(a, p) -> (Seq)Json$.MODULE$.parse(p).validate(ScadaParameters$.MODULE$.jsonReads()).fold((Function1 & Serializable)error -> {
                $this.LogUtil.error(new StringBuilder(86).append("Error validate Json to execute Aquabox Integration : parameters, for job execution ").append(jobExecutionId).append(", \n").append(error).toString(), $this.LogUtil.error$default$2());
                return a;
            }, (Function1 & Serializable)param -> {
                ScadaParameters scadaParameters = param;
                return (Seq)a.$plus$colon((Object)scadaParameters);
            }));
        }
        if (None$.MODULE$.equals(option)) {
            this.LogUtil.error(new StringBuilder(62).append("No parameters passed to Aquabox Integration job for execution ").append(jobExecutionId).toString(), this.LogUtil.error$default$2());
            return (Seq)Nil$.MODULE$;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$execute$15(String starts$1, String ends$1, File f) {
        return f.getName().startsWith(starts$1) && f.getName().endsWith(ends$1);
    }

    public static final /* synthetic */ ScadaMeasure $anonfun$execute$21(DateTime date$1, DateTime hour$1, String[] cols$1, F.Tuple dataColumn$1, double factor$1, double offset$1) {
        return ScadaMeasure$.MODULE$.toAquaboxMeasure(date$1, hour$1, cols$1, (F.Tuple<Object, Object>)dataColumn$1, factor$1, offset$1);
    }

    public static final /* synthetic */ void $anonfun$execute$16(AquaBoxPiezometerController $this, long jobExecutionId$1, String stationCode$1, boolean hasHeader$1, String separator$1, DateTimeFormatter dtf$1, int dateCol$1, int hourCol$1, CSVDataColumn dataCol$1, double factor$1, double offset$1, String dateFilter$1, String dir$1, File file) {
        boolean bl;
        BufferedSource bufferedSource = Source$.MODULE$.fromFile(file.getAbsolutePath(), Codec$.MODULE$.fallbackSystemCodec());
        $this.LogUtil.info(new StringBuilder(28).append("Begin integration of file : ").append(file.getName()).toString(), $this.LogUtil.info$default$2());
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.START_DATA(), new StringBuilder(27).append("Begin integration of file: ").append(file.getName()).toString(), stationCode$1, $this.JobLogUtil.log$default$5());
        Seq data = (Seq)bufferedSource.getLines().drop(hasHeader$1 ? 2 : 0).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable)(a, line) -> {
            Option hour;
            String[] cols = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])line.split(separator$1)), (Function1 & Serializable)x$1 -> x$1.trim(), ClassTag$.MODULE$.apply(String.class));
            Option date = Try$.MODULE$.apply((Function0 & Serializable)() -> dtf$1.parseDateTime(cols[dateCol$1])).toOption();
            Tuple2 tuple2 = new Tuple2((Object)date, (Object)(hour = Try$.MODULE$.apply((Function0 & Serializable)() -> dtf$1.parseDateTime(cols[hourCol$1])).toOption()));
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DateTime date2 = (DateTime)some.value();
                    if (option2 instanceof Some) {
                        F.Tuple dataColumn;
                        Some some2 = (Some)option2;
                        DateTime hour2 = (DateTime)some2.value();
                        Try try_ = Try$.MODULE$.apply(() -> AquaBoxPiezometerController.$anonfun$execute$21(date2, hour2, cols, dataColumn = F.Tuple((Object)BoxesRunTime.boxToInteger((int)dataCol$1.id()), (Object)BoxesRunTime.boxToInteger((int)dataCol$1.column())), factor$1, offset$1));
                        if (try_ instanceof Success) {
                            ScadaMeasure res;
                            Success success = (Success)try_;
                            ScadaMeasure scadaMeasure = res = (ScadaMeasure)success.value();
                            return (Seq)a.$plus$colon((Object)scadaMeasure);
                        }
                        if (try_ instanceof Failure) {
                            $this.LogUtil.error(new StringBuilder(65).append("Aquabox integration: fail to read csv line: ").append((String)line).append(" for job execution : ").append(jobExecutionId$1).toString(), $this.LogUtil.error$default$2());
                            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(23).append("Fail to read csv line: ").append((String)line).toString(), stationCode$1, $this.JobLogUtil.log$default$5());
                            return a;
                        }
                        throw new MatchError((Object)try_);
                    }
                }
            }
            $this.LogUtil.error(new StringBuilder(71).append("Aquabox integration: fail to read parse date: ").append(cols[dateCol$1]).append(" in ").append(dateFilter$1).append(" for job execution : ").append(jobExecutionId$1).toString(), $this.LogUtil.error$default$2());
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(26).append("Date ").append(cols[dateCol$1]).append(" cannot be parsed in ").append(dateFilter$1).toString(), stationCode$1, $this.JobLogUtil.log$default$5());
            return a;
        });
        bufferedSource.close();
        double result = $this.scadaDao.insert(stationCode$1, (Seq<ScadaMeasure>)data);
        $this.LogUtil.info(new StringBuilder(33).append("Insert ").append(result).append(" lines of data on station ").append(stationCode$1).toString(), $this.LogUtil.info$default$2());
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(21).append("Insert ").append(result).append(" lines of data").toString(), stationCode$1, $this.JobLogUtil.log$default$5());
        long now = new DateTime().getMillis();
        String processedFile = new StringBuilder(6).append(file.getAbsolutePath()).append(".").append(Long.toString(now)).append(".DONE").toString();
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> file.renameTo(new File(processedFile)));
        if (try_ instanceof Success) {
            boolean value;
            Success success = (Success)try_;
            bl = value = BoxesRunTime.unboxToBoolean((Object)success.value());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            $this.LogUtil.info(new StringBuilder(35).append("Error renaming the file ").append(file).append(" on ").append(processedFile).append(" in ").append(dir$1).append(" : ").append(err.getMessage()).toString(), $this.LogUtil.info$default$2());
            bl = false;
        } else {
            throw new MatchError((Object)try_);
        }
        boolean isRenamed = bl;
        if (isRenamed) {
            $this.LogUtil.info(new StringBuilder(17).append("File ").append(file).append(" renamed on ").append(processedFile).toString(), $this.LogUtil.info$default$2());
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(17).append("File ").append(file).append(" renamed on ").append(processedFile).toString(), stationCode$1, $this.JobLogUtil.log$default$5());
            return;
        }
        $this.LogUtil.info(new StringBuilder(34).append("Impossible to rename the file ").append(file).append(" on ").append(processedFile).toString(), $this.LogUtil.info$default$2());
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(34).append("Impossible to rename the file ").append(file).append(" on ").append(processedFile).toString(), stationCode$1, $this.JobLogUtil.log$default$5());
    }

    public static final /* synthetic */ void $anonfun$execute$8(AquaBoxPiezometerController $this, long jobExecutionId$1, String directory$1, boolean hasHeader$1, String separator$1, DateTimeFormatter dtf$1, String dateFilter$1, ScadaParameters param) {
        File[] fileArray;
        String stationCode = param.stationCode();
        $this.LogUtil.info(new StringBuilder(25).append("Get data about station : ").append(stationCode).toString(), $this.LogUtil.info$default$2());
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(23).append("Get data about station ").append(stationCode).toString(), stationCode, $this.JobLogUtil.log$default$5());
        String paramDir = (String)param.directory().getOrElse((Function0 & Serializable)() -> "");
        String dir = new StringBuilder(0).append(directory$1).append(paramDir).toString();
        int dateCol = BoxesRunTime.unboxToInt((Object)param.dateColumn().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        int hourCol = BoxesRunTime.unboxToInt((Object)param.hourColumn().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> dateCol));
        int n = param.data().size();
        switch (n) {
            case 0: {
                $this.LogUtil.error("No filters passed to Aquabox Integration job", $this.LogUtil.error$default$2());
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), "No columns defined to match data", stationCode, $this.JobLogUtil.log$default$5());
                return;
            }
        }
        CSVDataColumn dataCol = (CSVDataColumn)param.data().head();
        double factor = BoxesRunTime.unboxToDouble((Object)param.factor().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0));
        double offset = BoxesRunTime.unboxToDouble((Object)param.offset().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
        String fileFilter = (String)param.filter().getOrElse((Function0 & Serializable)() -> "*.CSV");
        IndexedSeq splitted = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)fileFilter.split("\\*"));
        String starts = splitted.nonEmpty() ? (String)splitted.head() : fileFilter;
        String ends = splitted.length() > 1 ? (String)splitted.apply(1) : "";
        File[] fileArray2 = new File(dir).listFiles();
        File[] allFiles = fileArray2 != null ? (fileArray = fileArray2) : (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class));
        File[] files = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])allFiles), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AquaBoxPiezometerController.$anonfun$execute$15(starts, ends, f)));
        int n2 = files.length;
        switch (n2) {
            case 0: {
                $this.LogUtil.error(new StringBuilder(59).append("No files found for filter ").append(fileFilter).append(" in path ").append(dir).append(" during job execution : ").append(jobExecutionId$1).toString(), $this.LogUtil.error$default$2());
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(45).append("Can't find files with filter: ").append(fileFilter).append(", in ").append(paramDir).append(" directory").toString(), stationCode, $this.JobLogUtil.log$default$5());
                return;
            }
        }
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)file -> {
            AquaBoxPiezometerController.$anonfun$execute$16($this, jobExecutionId$1, stationCode, hasHeader$1, separator$1, dtf$1, dateCol, hourCol, dataCol, factor, offset, dateFilter$1, dir, file);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$execute$2(AquaBoxPiezometerController $this, JobParameters jobParameters) {
        long jobExecutionId = jobParameters.jobExecutionId();
        String directory = new StringBuilder(0).append((String)package$.MODULE$.env().getOrElse((Object)"UPLOAD_DIRECTORY", (Function0 & Serializable)() -> "")).append(jobParameters.path().getOrElse((Function0 & Serializable)() -> "")).toString();
        CSVFilter filter = $this.getFilter((Option<Seq<String>>)jobParameters.filters(), jobExecutionId);
        Seq<ScadaParameters> parameters = $this.getParameters((Option<Seq<String>>)jobParameters.parameters(), jobExecutionId);
        String separator = (String)filter.customSeparator().getOrElse((Function0 & Serializable)() -> "");
        boolean hasHeader = BoxesRunTime.unboxToBoolean((Object)filter.hasHeader().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
        String dateFilter = (String)filter.dateFormat().getOrElse((Function0 & Serializable)() -> "YYYY/MM/dd HH:mm:ss");
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)dateFilter);
        parameters.foreach((Function1 & Serializable)param -> {
            AquaBoxPiezometerController.$anonfun$execute$8($this, jobExecutionId, directory, hasHeader, separator, dtf, dateFilter, param);
            return BoxedUnit.UNIT;
        });
        $this.LogUtil.info(new StringBuilder(43).append("End of Aquabox integration for execution : ").append(jobExecutionId).toString(), $this.LogUtil.info$default$2());
    }

    @Inject
    public AquaBoxPiezometerController(ScadaDao scadaDao, ScadaController scadaController, LogUtil LogUtil2, JobLogUtil JobLogUtil2) {
        this.scadaDao = scadaDao;
        this.LogUtil = LogUtil2;
        this.JobLogUtil = JobLogUtil2;
        Producer.$init$((Producer)this);
    }
}

