/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers;

import csvorexcel.model.CSVDataColumn;
import csvorexcel.model.CSVFilter;
import csvorexcel.model.csv.CSVParameters;
import fr.aquasys.daeau.iaeau.model.PredMeasure;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.referentials.unit.itf.UnitDao;
import fr.aquasys.daeau.referentials.unit.model.UnitInput;
import fr.aquasys.daeau.station.links.pointprel.PointPrel;
import fr.aquasys.daeau.station.links.pointprel.PointPrelDao;
import fr.aquasys.daeau.station.model.StationCode;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.FileUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.StationTypeUtil$;
import genericImport.itf.GenericImportDao;
import genericImport.itf.PredImportDao;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import java.io.File;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001\u0002\u0007\u000e\u0001IA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IA\u0007\u0005\tM\u0001\u0011\t\u0011)A\u0005O!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000bE\u0003A\u0011\u0001*\t\u000b\u0011\u0004A\u0011A3\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBAZ\u0001\u0011\u0005\u0011Q\u0017\u0002\u000e\u0007N36i\u001c8ue>dG.\u001a:\u000b\u00059y\u0011aC2p]R\u0014x\u000e\u001c7feNT\u0011\u0001E\u0001\u000bGN4xN]3yG\u0016d7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0017a\u0002'pOV#\u0018\u000e\u001c\t\u00037\u0011j\u0011\u0001\b\u0006\u0003;y\tA!\u001e;jY*\u0011q\u0004I\u0001\te\u0006\u0014'-\u001b;nc*\u0011\u0011EI\u0001\bCF,\u0018m]=t\u0015\u0005\u0019\u0013A\u00014s\u0013\t)CDA\u0004M_\u001e,F/\u001b7\u0002!\u001d,g.\u001a:jG&k\u0007o\u001c:u\t\u0006|\u0007C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\rIGO\u001a\u0006\u0002Y\u0005iq-\u001a8fe&\u001c\u0017*\u001c9peRL!AL\u0015\u0003!\u001d+g.\u001a:jG&k\u0007o\u001c:u\t\u0006|\u0017aB;oSR$\u0015m\u001c\t\u0003cej\u0011A\r\u0006\u0003UMR!\u0001N\u001b\u0002\tUt\u0017\u000e\u001e\u0006\u0003m]\nAB]3gKJ,g\u000e^5bYNT!\u0001\u000f\u0011\u0002\u000b\u0011\fW-Y;\n\u0005i\u0012$aB+oSR$\u0015m\\\u0001\u000b\u0015>\u0014Gj\\4Vi&d\u0007CA\u001fA\u001b\u0005q$BA !\u0003\u0015)H/\u001b7t\u0013\t\teH\u0001\u0006K_\ndunZ+uS2\fA\u0002U8j]R\u0004&/\u001a7EC>\u0004\"\u0001R&\u000e\u0003\u0015S!AR$\u0002\u0013A|\u0017N\u001c;qe\u0016d'B\u0001%J\u0003\u0015a\u0017N\\6t\u0015\tQu'A\u0004ti\u0006$\u0018n\u001c8\n\u00051+%\u0001\u0004)pS:$\bK]3m\t\u0006|\u0017!\u0004)sK\u0012LU\u000e]8si\u0012\u000bw\u000e\u0005\u0002)\u001f&\u0011\u0001+\u000b\u0002\u000e!J,G-S7q_J$H)Y8\u0002\rqJg.\u001b;?)\u001d\u0019VKV,Y3j\u0003\"\u0001\u0016\u0001\u000e\u00035AQ!G\u0004A\u0002iAQAJ\u0004A\u0002\u001dBQaL\u0004A\u0002ABQaO\u0004A\u0002qBQAQ\u0004A\u0002\rCQ!T\u0004A\u00029C#a\u0002/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017AB5oU\u0016\u001cGOC\u0001b\u0003\u0015Q\u0017M^1y\u0013\t\u0019gL\u0001\u0004J]*,7\r^\u0001\u000eiJ\f\u0017\u000e^3nK:$8i\u0015,\u0015\u0017\u0019\fi#a\u0010\u0002L\u0005\u0005\u00141\u000e\u000b\u0004O\u0006u\u0001\u0003\u0002\u000biUzL!![\u000b\u0003\rQ+\b\u000f\\33!\rY7O\u001e\b\u0003YFt!!\u001c9\u000e\u00039T!a\\\t\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012B\u0001:\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001^;\u0003\u0007M+\u0017O\u0003\u0002s+A\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\u0006[>$W\r\u001c\u0006\u0003w^\n1A[8c\u0013\ti\bPA\u0006HK:,'/[2ECR\f\u0007#B@\u0002\n\u00055QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\u000f5,H/\u00192mK*\u0019\u0011qA\u000b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\f\u0005\u0005!a\u0002%bg\"\u001cV\r\u001e\t\u0005\u0003\u001f\t9B\u0004\u0003\u0002\u0012\u0005M\u0001CA7\u0016\u0013\r\t)\"F\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00111\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005UQ\u0003C\u0004\u0002 !\u0001\u001d!!\t\u0002\u0013\u0011,'-^4N_\u0012,\u0007#\u0002\u000b\u0002$\u0005\u001d\u0012bAA\u0013+\t1q\n\u001d;j_:\u00042\u0001FA\u0015\u0013\r\tY#\u0006\u0002\b\u0005>|G.Z1o\u0011\u001d\ty\u0003\u0003a\u0001\u0003c\t\u0011c\u001d;bi&|g\u000eU1sC6,G/\u001a:t!\u0011\t\u0019$a\u000f\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\t1aY:w\u0015\tIx\"\u0003\u0003\u0002>\u0005U\"!D\"T-B\u000b'/Y7fi\u0016\u00148\u000fC\u0004\u0002B!\u0001\r!a\u0011\u0002\u000f\u0019LG\u000e^3sgB!\u0011QIA$\u001b\t\tI$\u0003\u0003\u0002J\u0005e\"!C\"T-\u001aKG\u000e^3s\u0011\u001d\ti\u0005\u0003a\u0001\u0003\u001f\naBZ5mKN$v\u000e\u0015:pG\u0016\u001c8\u000f\u0005\u0003lg\u0006E\u0003\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u0003S>T!!a\u0017\u0002\t)\fg/Y\u0005\u0005\u0003?\n)F\u0001\u0003GS2,\u0007bBA2\u0011\u0001\u0007\u0011QM\u0001\u000eU>\u0014\u0007+\u0019:b[\u0016$XM]:\u0011\u0007]\f9'C\u0002\u0002ja\u0014QBS8c!\u0006\u0014\u0018-\\3uKJ\u001c\bbBA7\u0011\u0001\u0007\u0011qN\u0001\rgR\fG/[8o\u0007>$Wm\u001d\t\u0005WN\f\t\b\u0005\u0003\u0002t\u0005]TBAA;\u0015\tI\u0018*\u0003\u0003\u0002z\u0005U$aC*uCRLwN\\\"pI\u0016\f1bZ3u+:LGoQ8eKRq\u0011qPAA\u0003\u000b\u000by)!'\u0002\u001e\u0006\u0005\u0006#\u0002\u000b\u0002$\u00055\u0001bBAB\u0013\u0001\u0007\u0011QB\u0001\nk:LGOV1mk\u0016Dq!a\"\n\u0001\u0004\tI)\u0001\bk_\n,\u00050Z2vi&|g.\u00133\u0011\u0007Q\tY)C\u0002\u0002\u000eV\u0011A\u0001T8oO\"9\u0011\u0011S\u0005A\u0002\u0005M\u0015!\u00037j]\u0016Le\u000eZ3y!\r!\u0012QS\u0005\u0004\u0003/+\"aA%oi\"9\u00111T\u0005A\u0002\u00055\u0011aC:uCRLwN\\\"pI\u0016Dq!a(\n\u0001\u0004\ti!\u0001\u0005gS2,g*Y7f\u0011\u001d\t\u0019+\u0003a\u0001\u0003\u001b\tA\u0001\\5oK\u0006a1/\u001a9be\u0006$X\rT5oKR1\u0011\u0011VAX\u0003c\u0003R\u0001FAV\u0003\u001bI1!!,\u0016\u0005\u0015\t%O]1z\u0011\u001d\t\u0019K\u0003a\u0001\u0003\u001bAq!!\u0011\u000b\u0001\u0004\t\u0019%\u0001\u0007f]J,w\rR8o]\u0016,7\u000f\u0006\u0007\u0002\u0014\u0006]\u0016\u0011XA^\u0003\u007f\u000b\t\rC\u0004\u0002d-\u0001\r!!\u001a\t\u000f\u0005\u00053\u00021\u0001\u0002D!1\u0011QX\u0006A\u0002)\fA\u0001Z1uC\"9\u00111T\u0006A\u0002\u00055\u0001bBAb\u0017\u0001\u0007\u00111S\u0001\ngR\fG/[8o\u0013\u0012\u0004")
public class CSVController {
    private final LogUtil LogUtil;
    private final GenericImportDao genericImportDao;
    private final UnitDao unitDao;
    private final JobLogUtil JobLogUtil;
    private final PointPrelDao PointPrelDao;
    private final PredImportDao PredImportDao;

    public Tuple2<Seq<GenericData>, HashSet<String>> traitementCSV(CSVParameters stationParameters, CSVFilter filters, Seq<File> filesToProcess, JobParameters jobParameters, Seq<StationCode> stationCodes, Option<Object> debugMode) {
        long jobExecutionId = jobParameters.jobExecutionId();
        HashSet filesToSetProcessed = new HashSet();
        Seq results = (Seq)filesToProcess.flatMap((Function1 & Serializable)f -> {
            Option stationCodeOpt;
            block1: {
                block0: {
                    Option option = stationCodeOpt = stationParameters.autoDetectCode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? ((IterableOnceOps)stationCodes.filter((Function1 & Serializable)code -> BoxesRunTime.boxToBoolean((boolean)CSVController.$anonfun$traitementCSV$2(f, code)))).maxByOption((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)CSVController.$anonfun$traitementCSV$3(x$1)), (Ordering)Ordering.Int$.MODULE$) : stationParameters.stationCode().map((Function1 & Serializable)c -> new StationCode(BoxesRunTime.unboxToInt((Object)stationParameters.stationId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)), c, (Option)None$.MODULE$));
                    if (!stationParameters.autoDetectCode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) || !stationCodeOpt.isEmpty()) break block0;
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(26).append("No station found for file ").append(f.getName()).toString(), "", f.getName());
                    break block1;
                }
                if (!stationParameters.autoDetectCode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) || !stationCodeOpt.isDefined()) break block1;
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(31).append("Station d\u00e9duite n\u00b0").append(((StationCode)stationCodeOpt.get()).id()).append(" via le code ").append(((StationCode)stationCodeOpt.get()).code()).toString(), "", f.getName());
            }
            return (Seq)stationCodeOpt.map((Function1 & Serializable)sc -> {
                Seq seq;
                String stationCode = sc.code();
                int stationId = sc.id();
                String dataCategory = StationTypeUtil$.MODULE$.StationType((String)filters.dataCategory().getOrElse((Function0 & Serializable)() -> "piezometry"));
                try {
                    $this.JobLogUtil.checkExecutionAbort(jobExecutionId);
                    BufferedSource bufferedSource = BoxesRunTime.unboxToBoolean((Object)jobParameters.isManualImport().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? Source$.MODULE$.fromBytes(Base64.decodeBase64((String)((String)jobParameters.fileContent().get())), Codec$.MODULE$.fallbackSystemCodec()) : FileUtil$.MODULE$.readFileSource(f.getAbsolutePath());
                    String dateFormat = !filters.hourWithDate().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && stationParameters.hourColumn().isDefined() && ((String)filters.dateFormat().getOrElse((Function0 & Serializable)() -> "")).trim().length() <= 10 ? new StringBuilder(9).append(((String)filters.dateFormat().getOrElse((Function0 & Serializable)() -> "MM/dd/YYYY")).trim()).append(" HH:mm:ss").toString() : ((String)filters.dateFormat().getOrElse((Function0 & Serializable)() -> "MM/dd/YYYY")).trim();
                    DateTimeFormatter dtf = DateTimeFormat.forPattern((String)DateUtil$.MODULE$.correctDateFormat(dateFormat));
                    BooleanRef parsingErrorFound = BooleanRef.create((boolean)false);
                    BooleanRef dateErrorFound = BooleanRef.create((boolean)false);
                    ObjectRef parsingColumnErrorFound = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
                    Option excludedValue = filters.excludedValue().map((Function1 & Serializable)e -> e.replace(",", ".").trim());
                    Seq listValueToExcluded = excludedValue.isDefined() ? Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)((String)excludedValue.get()).split(";")) : (Seq)Nil$.MODULE$;
                    $this.JobLogUtil.debug(jobExecutionId, new StringBuilder(27).append("Begin integration of file: ").append(f.getName()).toString(), stationCode, f.getName(), debugMode);
                    int entete = filters.hasHeader().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? BoxesRunTime.unboxToInt((Object)filters.nbHeaders().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)) : 0;
                    $this.JobLogUtil.debug(jobExecutionId, new StringBuilder(12).append("skip ").append(entete).append("  line ").toString(), stationCode, f.getName(), debugMode);
                    int nbcolMax = stationParameters.data().isDefined() && ((SeqOps)stationParameters.data().get()).length() > 0 ? ((CSVDataColumn)((IterableOnceOps)stationParameters.data().get()).maxBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.column()), (Ordering)Ordering.Int$.MODULE$)).column() : 0;
                    IntRef lineIndex = IntRef.create((int)entete);
                    Seq pointPrels = new .colon.colon((Object)StationTypeUtil$.MODULE$.PIEZOMETRY(), (List)new .colon.colon((Object)StationTypeUtil$.MODULE$.HYDROMETRY(), (List)new .colon.colon((Object)StationTypeUtil$.MODULE$.PLUVIOMETRY(), (List)Nil$.MODULE$))).contains((Object)dataCategory) ? $this.PointPrelDao.getPoints(dataCategory, stationId) : (Seq)Nil$.MODULE$;
                    None$ codepointGlobal = stationParameters.pointPrelevement().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$3.trim())))) ? pointPrels.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CSVController.$anonfun$traitementCSV$16(stationParameters, x$4))).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.point())) : None$.MODULE$;
                    Seq data = (Seq)((IterableOps)bufferedSource.getLines().drop(entete).foldLeft((Object)Nil$.MODULE$, (arg_0, arg_1) -> CSVController.$anonfun$traitementCSV$18(this, lineIndex, filters, nbcolMax, jobExecutionId, f, stationCode, stationParameters, dtf, dateFormat, dateErrorFound, pointPrels, listValueToExcluded, (Option)codepointGlobal, parsingErrorFound, parsingColumnErrorFound, arg_0, arg_1))).flatten(Predef$.MODULE$.$conforms());
                    bufferedSource.close();
                    if (jobParameters.isManualImport().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && jobParameters.returnsData().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), "end integration of file imported ", stationCode, f.getName());
                        seq = data;
                    } else {
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(41).append(data.length()).append(" records read, begin integration into DB.").toString(), stationCode, f.getName());
                        int result = this.enregDonnees(jobParameters, filters, (Seq<GenericData>)data, stationCode, stationId);
                        if (result > 0) {
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(55).append(result).append(" elements saved, End integration of file. (station id ").append(stationId).append(")").toString(), stationCode, f.getName());
                        } else {
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "Nothing new to import.", stationCode, f.getName());
                        }
                        filesToSetProcessed.$plus$eq((Object)f.getAbsolutePath());
                        seq = (Seq)Nil$.MODULE$;
                    }
                }
                catch (InterruptedException interupted) {
                    throw interupted;
                }
                catch (Throwable err) {
                    err.printStackTrace();
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(38).append("Error during file reading : ").append(f.getName()).append(", error : ").append(err.getMessage()).toString(), stationCode, f.getName());
                    $this.LogUtil.error(new StringBuilder(38).append("Error during file reading : ").append(f.getName()).append(", error : ").append(err.getMessage()).toString(), $this.LogUtil.error$default$2());
                    $this.LogUtil.printError(err);
                    seq = (Seq)Nil$.MODULE$;
                }
                return seq;
            }).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
        });
        return new Tuple2((Object)results, (Object)filesToSetProcessed);
    }

    public Option<String> getUnitCode(String unitValue, long jobExecutionId, int lineIndex, String stationCode, String fileName, String line) {
        if (!"".equals(unitValue)) {
            Option unitInDB = this.unitDao.getCodeUnite(unitValue, unitValue);
            if (unitInDB.isDefined()) {
                return new Some(unitInDB.get());
            }
            Tuple2 tuple2 = this.unitDao.create(new UnitInput(unitValue, (Option)new Some((Object)new StringBuilder(2).append("<").append(new Some((Object)unitValue)).append(">").toString()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId))));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String codeUnit = (String)tuple2._1();
            int res = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)codeUnit, (Object)BoxesRunTime.boxToInteger((int)res));
            String codeUnit2 = (String)tuple22._1();
            int res2 = tuple22._2$mcI$sp();
            if (res2 > 0) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(40).append("Unit created with success : ").append(codeUnit2).append(" on line (").append(lineIndex).append(") ").append(line).toString(), stationCode, fileName);
                return new Some((Object)codeUnit2);
            }
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(41).append("Error during unit creation : ").append(codeUnit2).append(" on line (").append(lineIndex).append(") ").append(line).toString(), stationCode, fileName);
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public String[] separateLine(String line, CSVFilter filters) {
        String[] split1 = BoxesRunTime.unboxToBoolean((Object)filters.commaSeparator().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? line.split(",", 10000) : (String[])((Object[])new String[]{line});
        String[] split2 = BoxesRunTime.unboxToBoolean((Object)filters.semicolonSeparator().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])split1), (Function1 & Serializable)s -> s.split(";", 10000), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class)) : split1;
        String[] split3 = BoxesRunTime.unboxToBoolean((Object)filters.tabulationSeparator().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])split2), (Function1 & Serializable)s -> s.split("\t", 10000), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class)) : split2;
        String[] split4 = BoxesRunTime.unboxToBoolean((Object)filters.spaceSeparator().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])split3), (Function1 & Serializable)s -> s.split(" ", 10000), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class)) : split3;
        String[] split5 = filters.customSeparator().isDefined() ? (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])split4), (Function1 & Serializable)s -> s.split(((String)filters.customSeparator().get()).replace("|", "\\|"), 10000), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class)) : split4;
        return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])split5), (Function1 & Serializable)x$12 -> x$12.trim(), ClassTag$.MODULE$.apply(String.class));
    }

    public int enregDonnees(JobParameters jobParameters, CSVFilter filters, Seq<GenericData> data, String stationCode, int stationId) {
        String string;
        String string2;
        String string3;
        long jobExecutionId = jobParameters.jobExecutionId();
        String user = (String)jobParameters.user().get();
        Option<Object> x$1 = filters.measureCote();
        Option<String> x$2 = filters.importMode();
        None$ x$3 = filters.campaignId().isDefined() ? new Some((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToDouble((Object)filters.campaignId().get())))) : None$.MODULE$;
        Option<Object> x$4 = ImportOptions$.MODULE$.apply$default$1();
        Option<String> x$5 = ImportOptions$.MODULE$.apply$default$4();
        Option<Seq<Object>> x$6 = ImportOptions$.MODULE$.apply$default$6();
        Option<Object> x$7 = ImportOptions$.MODULE$.apply$default$7();
        Some options = new Some((Object)new ImportOptions(x$4, x$2, x$1, x$5, (Option<Object>)x$3, x$6, x$7));
        if (filters.predictMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            String source = (String)filters.predSource().getOrElse((Function0 & Serializable)() -> {
                throw new Exception("Predict mode is active but source is not defined");
            });
            return this.PredImportDao.importMeasures(stationId, source, (String)filters.dataCategory().get(), (String)filters.importMode().getOrElse((Function0 & Serializable)() -> ""), (Seq<PredMeasure>)((Seq)data.map((Function1 & Serializable)x$13 -> x$13.toPred(stationId, source, jobExecutionId))));
        }
        boolean bl = false;
        Some some = null;
        Option<String> option = filters.dataCategory();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string4 = (String)some.value();
            if ("pluviometry".equals(string4)) {
                return this.genericImportDao.importPluviometryGeneric(Integer.toString(stationId), stationCode, user, jobExecutionId, data, (Option<ImportOptions>)options);
            }
        }
        if (bl && "piezometry".equals(string3 = (String)some.value())) {
            return this.genericImportDao.importPiezometryGeneric(Integer.toString(stationId), stationCode, user, jobExecutionId, data, (Option<ImportOptions>)options);
        }
        if (bl && "hydrometry".equals(string2 = (String)some.value())) {
            return this.genericImportDao.importHydrometryGeneric(Integer.toString(stationId), stationCode, user, jobExecutionId, data, (Option<ImportOptions>)options);
        }
        if (bl && "installation".equals(string = (String)some.value())) {
            return this.genericImportDao.importInstallationGeneric(stationId, user, jobExecutionId, data, (Option<ImportOptions>)options);
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Can't determinate data category", stationCode, this.JobLogUtil.log$default$5());
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$traitementCSV$2(File f$1, StationCode code) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(code.code().trim())) && f$1.getName().contains(code.code());
    }

    public static final /* synthetic */ int $anonfun$traitementCSV$3(StationCode x$1) {
        return x$1.code().trim().length();
    }

    public static final /* synthetic */ boolean $anonfun$traitementCSV$16(CSVParameters stationParameters$1, PointPrel x$4) {
        String string = x$4.code().trim().toLowerCase();
        String string2 = ((String)stationParameters$1.pointPrelevement().get()).trim().toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$traitementCSV$22(String codeInFile$1, PointPrel x$7) {
        String string = x$7.code().trim().toLowerCase();
        String string2 = codeInFile$1.trim().toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Option $anonfun$traitementCSV$30(String[] csvLine$1, int column) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(csvLine$1[column].replace(",", ".").trim()))).toOption();
    }

    public static final /* synthetic */ Option $anonfun$traitementCSV$33(String[] csvLine$1, int column) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(csvLine$1[column].replace(",", ".").trim()))).toOption();
    }

    public static final /* synthetic */ Option $anonfun$traitementCSV$35(String[] csvLine$1, int column) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(csvLine$1[column].replace(",", ".").trim()))).toOption();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final /* synthetic */ Option $anonfun$traitementCSV$25(CSVController $this, String[] csvLine$1, Seq listValueToExcluded$1, DateTime date$1, CSVParameters stationParameters$1, CSVFilter filters$1, Option simulationDate$1, Option codePointCol$1, Option codepointGlobal$1, BooleanRef parsingErrorFound$1, long jobExecutionId$1, File f$1, String stationCode$1, IntRef lineIndex$1, String line$1, ObjectRef parsingColumnErrorFound$1, CSVDataColumn d) {
        None$ none$;
        if (!((Option)Predef$.MODULE$.wrapRefArray((Object[])csvLine$1).lift().apply((Object)BoxesRunTime.boxToInteger((int)d.column()))).exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$10.trim()))))) {
            if (((Seq)parsingColumnErrorFound$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)d.column()))) return None$.MODULE$;
            parsingColumnErrorFound$1.elem = (Seq)((Seq)parsingColumnErrorFound$1.elem).$colon$plus((Object)BoxesRunTime.boxToInteger((int)d.column()));
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(37).append("Column n\u00b0").append(d.column()).append(" not found in file ").append(f$1.getName()).append(" on line ").append(lineIndex$1.elem).toString(), stationCode$1, f$1.getName());
            return None$.MODULE$;
        }
        try {
            String stringValue;
            block8: {
                block7: {
                    stringValue = csvLine$1[d.column()].replace(",", ".").trim();
                    if (listValueToExcluded$1.contains((Object)stringValue)) break block7;
                    String string = stringValue.toUpperCase();
                    String string2 = "NAN";
                    if (string != null ? !string.equals(string2) : string2 != null) break block8;
                }
                none$ = None$.MODULE$;
                return none$;
            }
            DateTime x$1 = date$1;
            DateTime x$2 = date$1;
            Some x$3 = new Some((Object)BoxesRunTime.boxToDouble((double)(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(stringValue)) * BoxesRunTime.unboxToDouble((Object)stationParameters$1.factor().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0)) + BoxesRunTime.unboxToDouble((Object)stationParameters$1.offset().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)))));
            int x$4 = d.id();
            Option x$5 = filters$1.status().orElse((Function0 & Serializable)() -> stationParameters$1.status().flatMap((Function1 & Serializable)column -> CSVController.$anonfun$traitementCSV$30(csvLine$1, BoxesRunTime.unboxToInt((Object)column))));
            Option x$6 = filters$1.qualification().orElse((Function0 & Serializable)() -> stationParameters$1.qualification().flatMap((Function1 & Serializable)column -> CSVController.$anonfun$traitementCSV$33(csvLine$1, BoxesRunTime.unboxToInt((Object)column))));
            Option x$7 = stationParameters$1.initialPoint().flatMap((Function1 & Serializable)column -> CSVController.$anonfun$traitementCSV$35(csvLine$1, BoxesRunTime.unboxToInt((Object)column)));
            Option<Object> x$8 = filters$1.producer();
            Option<Object> x$9 = filters$1.validator();
            Option<Object> x$102 = filters$1.manager();
            Option<String> x$11 = filters$1.nature();
            Option<Object> x$12 = filters$1.obtainingMode();
            Option x$13 = simulationDate$1;
            Option x$14 = codePointCol$1.orElse((Function0 & Serializable)() -> codepointGlobal$1);
            Option x$15 = GenericData$.MODULE$.$lessinit$greater$default$13();
            Some some = new Some((Object)new GenericData(x$1, x$2, (Option)x$3, x$4, x$5, x$6, x$12, x$8, x$9, x$102, x$11, x$7, x$15, x$13, x$14));
            none$ = some;
            return none$;
        }
        catch (Exception e) {
            if (!parsingErrorFound$1.elem) {
                e.printStackTrace();
                $this.LogUtil.printError((Throwable)e);
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(43).append("Error parsing value data in file ").append(f$1.getName()).append(", error : ").append(e.getMessage()).toString(), stationCode$1, f$1.getName());
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(16).append("Failing line (").append(lineIndex$1.elem).append(") ").append(line$1).toString(), stationCode$1, f$1.getName());
                parsingErrorFound$1.elem = true;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ Option $anonfun$traitementCSV$42(String[] csvLine$1, int column) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(csvLine$1[column].replace(",", ".").trim()))).toOption();
    }

    public static final /* synthetic */ Option $anonfun$traitementCSV$45(String[] csvLine$1, int column) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(csvLine$1[column].replace(",", ".").trim()))).toOption();
    }

    public static final /* synthetic */ Option $anonfun$traitementCSV$47(String[] csvLine$1, int column) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(csvLine$1[column].replace(",", ".").trim()))).toOption();
    }

    private final /* synthetic */ Seq liftedTree1$1(String[] csvLine$1, CSVParameters stationParameters$1, Seq listValueToExcluded$1, DateTime date$1, long jobExecutionId$1, IntRef lineIndex$1, String stationCode$1, File f$1, String line$1, CSVFilter filters$1, Option codePointCol$1, Option codepointGlobal$1, BooleanRef parsingErrorFound$1) {
        Seq seq;
        block4: {
            try {
                String stringValue;
                block6: {
                    block5: {
                        stringValue = csvLine$1[BoxesRunTime.unboxToInt((Object)stationParameters$1.value().get())].replace(",", ".").trim();
                        if (listValueToExcluded$1.contains((Object)stringValue)) break block5;
                        String string = stringValue.toUpperCase();
                        String string2 = "NAN";
                        if (string != null ? !string.equals(string2) : string2 != null) break block6;
                    }
                    seq = (Seq)Nil$.MODULE$;
                    break block4;
                }
                DateTime x$16 = date$1;
                DateTime x$17 = date$1;
                Some x$18 = new Some((Object)BoxesRunTime.boxToDouble((double)(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(stringValue)) * BoxesRunTime.unboxToDouble((Object)stationParameters$1.factor().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0)) + BoxesRunTime.unboxToDouble((Object)stationParameters$1.offset().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)))));
                int x$19 = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(csvLine$1[BoxesRunTime.unboxToInt((Object)stationParameters$1.sandreCode().get())].trim()));
                Option x$20 = stationParameters$1.unit().flatMap((Function1 & Serializable)u -> this.getUnitCode(csvLine$1[BoxesRunTime.unboxToInt((Object)u)], jobExecutionId$1, lineIndex$1.elem, stationCode$1, f$1.getName(), line$1));
                Option x$21 = filters$1.status().orElse((Function0 & Serializable)() -> stationParameters$1.status().flatMap((Function1 & Serializable)column -> CSVController.$anonfun$traitementCSV$42(csvLine$1, BoxesRunTime.unboxToInt((Object)column))));
                Option x$22 = filters$1.qualification().orElse((Function0 & Serializable)() -> stationParameters$1.qualification().flatMap((Function1 & Serializable)column -> CSVController.$anonfun$traitementCSV$45(csvLine$1, BoxesRunTime.unboxToInt((Object)column))));
                Option x$23 = stationParameters$1.initialPoint().flatMap((Function1 & Serializable)column -> CSVController.$anonfun$traitementCSV$47(csvLine$1, BoxesRunTime.unboxToInt((Object)column)));
                Option<Object> x$24 = filters$1.producer();
                Option<Object> x$25 = filters$1.validator();
                Option<Object> x$26 = filters$1.manager();
                Option<String> x$27 = filters$1.nature();
                Option<Object> x$28 = filters$1.obtainingMode();
                Option x$29 = codePointCol$1.orElse((Function0 & Serializable)() -> codepointGlobal$1);
                Option x$30 = GenericData$.MODULE$.$lessinit$greater$default$14();
                .colon.colon colon2 = new .colon.colon((Object)new GenericData(x$16, x$17, (Option)x$18, x$19, x$21, x$22, x$28, x$24, x$25, x$26, x$27, x$23, x$20, x$30, x$29), (List)Nil$.MODULE$);
                seq = colon2;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.LogUtil.printError((Throwable)e);
                if (!parsingErrorFound$1.elem) {
                    this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(43).append("Error parsing value data in file ").append(f$1.getName()).append(", error : ").append(e.getMessage()).toString(), stationCode$1, f$1.getName());
                    this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(16).append("Failing line (").append(lineIndex$1.elem).append(") ").append(line$1).toString(), stationCode$1, f$1.getName());
                    parsingErrorFound$1.elem = true;
                }
                seq = (Seq)Nil$.MODULE$;
            }
        }
        return seq;
    }

    public static final /* synthetic */ Seq $anonfun$traitementCSV$18(CSVController $this, IntRef lineIndex$1, CSVFilter filters$1, int nbcolMax$1, long jobExecutionId$1, File f$1, String stationCode$1, CSVParameters stationParameters$1, DateTimeFormatter dtf$1, String dateFormat$1, BooleanRef dateErrorFound$1, Seq pointPrels$1, Seq listValueToExcluded$1, Option codepointGlobal$1, BooleanRef parsingErrorFound$1, ObjectRef parsingColumnErrorFound$1, Seq acc, String line) {
        block30: {
            Seq seq;
            block29: {
                ++lineIndex$1.elem;
                String[] csvLine = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])$this.separateLine(line, filters$1)), (Function1 & Serializable)s -> {
                    if (s.startsWith("\"")) {
                        return s.replace("\"", "");
                    }
                    return s;
                }, ClassTag$.MODULE$.apply(String.class));
                if (csvLine.length <= 0 || csvLine.length < nbcolMax$1) break block30;
                if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])csvLine), (Object)"&ERROR&")) {
                    $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(60).append("Error during file reading : ").append(f$1.getName()).append(", error : check error flag found").toString(), stationCode$1, f$1.getName());
                }
                try {
                    block32: {
                        Some some;
                        block31: {
                            if (stationParameters$1.conditionColumn().isEmpty()) break block31;
                            String string = csvLine[BoxesRunTime.unboxToInt((Object)stationParameters$1.conditionColumn().get())];
                            Object object = stationParameters$1.requiredValue().getOrElse((Function0 & Serializable)() -> "");
                            if (string != null ? !string.equals(object) : object != null) break block32;
                        }
                        try {
                            DateTime dateTime;
                            if (filters$1.hourWithDate().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                                dateTime = dtf$1.parseDateTime(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(csvLine[BoxesRunTime.unboxToInt((Object)stationParameters$1.dateColumn().get())].replace("\"", "").trim()), dateFormat$1.length()));
                            } else if (stationParameters$1.hourColumn().isDefined()) {
                                String hour = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(csvLine[BoxesRunTime.unboxToInt((Object)stationParameters$1.hourColumn().get())]), 8);
                                String hourWithDefault = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hour.isEmpty() && filters$1.defaultHour().isDefined() && filters$1.defaultHour().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$6)))) ? (String)filters$1.defaultHour().get() : hour), 8);
                                String hourValue = hourWithDefault.length() == 5 ? new StringBuilder(3).append(hourWithDefault).append(":00").toString() : (hourWithDefault.length() == 6 ? new StringBuilder(2).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hourWithDefault), 2)).append(":").append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hourWithDefault), 4)), 2)).append(":").append(StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(hourWithDefault), 2)).toString() : hourWithDefault);
                                String dateToParse = new StringBuilder(1).append(csvLine[BoxesRunTime.unboxToInt((Object)stationParameters$1.dateColumn().get())].replace("\"", "").trim()).append(" ").append(hourValue).toString();
                                dateTime = dtf$1.parseDateTime(dateToParse);
                            } else {
                                dateTime = dtf$1.parseDateTime(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(csvLine[BoxesRunTime.unboxToInt((Object)stationParameters$1.dateColumn().get())].replace("\"", "").trim()), dateFormat$1.length()));
                            }
                            some = new Some((Object)dateTime);
                        }
                        catch (Throwable e) {
                            if (e.getMessage().contains("Illegal instant")) {
                                some = None$.MODULE$;
                            }
                            if (!dateErrorFound$1.elem) {
                                dateErrorFound$1.elem = true;
                                e.printStackTrace();
                                $this.LogUtil.printError(e);
                                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(43).append("Error while reading date with date pattern ").append(dateFormat$1).toString(), stationCode$1, f$1.getName());
                                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(15).append("Failing line : ").append(line).toString(), stationCode$1, f$1.getName());
                            }
                            throw e;
                        }
                        Some dateOpt = some;
                        if (dateOpt.isEmpty()) {
                            seq = acc;
                        } else {
                            Seq res2;
                            Seq res;
                            None$ simulationDate;
                            None$ none$;
                            None$ none$2;
                            if (stationParameters$1.pointPrelCol().isDefined()) {
                                String codeInFile = csvLine[BoxesRunTime.unboxToInt((Object)stationParameters$1.pointPrelCol().get())];
                                none$2 = pointPrels$1.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CSVController.$anonfun$traitementCSV$22(codeInFile, x$7))).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.point()));
                            } else {
                                none$2 = None$.MODULE$;
                            }
                            None$ codePointCol = none$2;
                            DateTime date = (DateTime)dateOpt.get();
                            if (filters$1.predictMode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && (stationParameters$1.simulationDateColumn().isDefined() || stationParameters$1.predictHorizon().isDefined())) {
                                DateTime dateTime;
                                if (stationParameters$1.simulationDateColumn().isDefined() && filters$1.hourWithDate().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                                    dateTime = dtf$1.parseDateTime(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(csvLine[BoxesRunTime.unboxToInt((Object)stationParameters$1.simulationDateColumn().get())].replace("\"", "").trim()), dateFormat$1.length()));
                                } else if (stationParameters$1.simulationDateColumn().isDefined() && stationParameters$1.hourColumn().isDefined()) {
                                    String hour = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(csvLine[BoxesRunTime.unboxToInt((Object)stationParameters$1.simulationDateColumn().get())]), 8);
                                    String hourWithDefault = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hour.isEmpty() && filters$1.defaultHour().isDefined() && filters$1.defaultHour().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$9)))) ? (String)filters$1.defaultHour().get() : hour), 8);
                                    String hourValue = hourWithDefault.length() == 5 ? new StringBuilder(3).append(hourWithDefault).append(":00").toString() : (hourWithDefault.length() == 6 ? new StringBuilder(2).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hourWithDefault), 2)).append(":").append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hourWithDefault), 4)), 2)).append(":").append(StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(hourWithDefault), 2)).toString() : hourWithDefault);
                                    String dateToParse = new StringBuilder(1).append(csvLine[BoxesRunTime.unboxToInt((Object)stationParameters$1.simulationDateColumn().get())].replace("\"", "").trim()).append(" ").append(hourValue).toString();
                                    dateTime = dtf$1.parseDateTime(dateToParse);
                                } else if (stationParameters$1.simulationDateColumn().isDefined()) {
                                    dateTime = dtf$1.parseDateTime(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(csvLine[BoxesRunTime.unboxToInt((Object)stationParameters$1.simulationDateColumn().get())].replace("\"", "").trim()), dateFormat$1.length()));
                                } else if (stationParameters$1.predictHorizon().isDefined()) {
                                    dateTime = date.minusDays(BoxesRunTime.unboxToInt((Object)stationParameters$1.predictHorizon().get()));
                                } else {
                                    throw new Exception("Predict mode is active, but no simulationDate column or predict horizon is defined");
                                }
                                none$ = new Some((Object)dateTime);
                            } else {
                                none$ = simulationDate = None$.MODULE$;
                            }
                            Seq seq2 = res = stationParameters$1.data().isDefined() ? (Seq)((IterableOps)stationParameters$1.data().get()).flatMap(arg_0 -> CSVController.$anonfun$traitementCSV$25($this, csvLine, listValueToExcluded$1, date, stationParameters$1, filters$1, (Option)simulationDate, (Option)codePointCol, codepointGlobal$1, parsingErrorFound$1, jobExecutionId$1, f$1, stationCode$1, lineIndex$1, line, parsingColumnErrorFound$1, arg_0)) : (stationParameters$1.sandreCode().isDefined() && stationParameters$1.value().isDefined() ? (res2 = $this.liftedTree1$1(csvLine, stationParameters$1, listValueToExcluded$1, date, jobExecutionId$1, lineIndex$1, stationCode$1, f$1, line, filters$1, (Option)codePointCol, codepointGlobal$1, parsingErrorFound$1)) : (Seq)Nil$.MODULE$);
                            seq = (Seq)acc.$plus$colon((Object)seq2);
                        }
                        break block29;
                    }
                    seq = acc;
                }
                catch (Exception e) {
                    if (e.getMessage().contains("Illegal instant due to time zone offset transition")) {
                        seq = acc;
                    }
                    if (!parsingErrorFound$1.elem) {
                        e.printStackTrace();
                        $this.LogUtil.printError((Throwable)e);
                        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(37).append("Error reading date in file ").append(f$1.getName()).append(", error : ").append(e.getMessage()).toString(), stationCode$1, f$1.getName());
                        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(16).append("Failing line (").append(lineIndex$1.elem).append(") ").append(line).toString(), stationCode$1, f$1.getName());
                        parsingErrorFound$1.elem = true;
                    }
                    seq = acc;
                }
            }
            return seq;
        }
        return acc;
    }

    @Inject
    public CSVController(LogUtil LogUtil2, GenericImportDao genericImportDao, UnitDao unitDao, JobLogUtil JobLogUtil2, PointPrelDao PointPrelDao2, PredImportDao PredImportDao2) {
        this.LogUtil = LogUtil2;
        this.genericImportDao = genericImportDao;
        this.unitDao = unitDao;
        this.JobLogUtil = JobLogUtil2;
        this.PointPrelDao = PointPrelDao2;
        this.PredImportDao = PredImportDao2;
    }
}

