/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers;

import csvorexcel.controllers.XLSControllerOld;
import csvorexcel.model.CSVDataColumn;
import csvorexcel.model.CSVFilter;
import csvorexcel.model.csv.CSVParameters;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.station.links.pointprel.PointPrel;
import fr.aquasys.daeau.station.links.pointprel.PointPrelDao;
import fr.aquasys.daeau.station.model.StationCode;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.StationTypeUtil$;
import genericImport.itf.GenericImportDao;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import javax.inject.Inject;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\tMb\u0001\u0002\t\u0012\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tU\u0001\u0011\t\u0011)A\u0005W!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!)\u0005A!A!\u0002\u00131\u0005\"\u0002'\u0001\t\u0003i\u0005\"B/\u0001\t\u0003q\u0006bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!!.\u0001\t\u0003\t9\fC\u0005\u0002Z\u0002\u0001\r\u0011\"\u0001\u0002\\\"I\u0011Q\u001e\u0001A\u0002\u0013\u0005\u0011q\u001e\u0005\t\u0003w\u0004\u0001\u0015)\u0003\u0002^\"9\u0011Q \u0001\u0005\u0002\u0005}(!\u0004-M'\u000e{g\u000e\u001e:pY2,'O\u0003\u0002\u0013'\u0005Y1m\u001c8ue>dG.\u001a:t\u0015\u0005!\u0012AC2tm>\u0014X\r_2fY\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u00069Aj\\4Vi&d\u0007CA\u0010)\u001b\u0005\u0001#BA\u0011#\u0003\u0011)H/\u001b7\u000b\u0005\r\"\u0013\u0001\u0003:bE\nLG/\\9\u000b\u0005\u00152\u0013aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002O\u0005\u0011aM]\u0005\u0003S\u0001\u0012q\u0001T8h+RLG.\u0001\thK:,'/[2J[B|'\u000f\u001e#b_B\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0004SR4'\"\u0001\u0019\u0002\u001b\u001d,g.\u001a:jG&k\u0007o\u001c:u\u0013\t\u0011TF\u0001\tHK:,'/[2J[B|'\u000f\u001e#b_\u0006a\u0001k\\5oiB\u0013X\r\u001c#b_B\u0011QGP\u0007\u0002m)\u0011q\u0007O\u0001\na>Lg\u000e\u001e9sK2T!!\u000f\u001e\u0002\u000b1Lgn[:\u000b\u0005mb\u0014aB:uCRLwN\u001c\u0006\u0003{\u0011\nQ\u0001Z1fCVL!a\u0010\u001c\u0003\u0019A{\u0017N\u001c;Qe\u0016dG)Y8\u0002!ac5kQ8oiJ|G\u000e\\3s\u001f2$\u0007C\u0001\"D\u001b\u0005\t\u0012B\u0001#\u0012\u0005AAFjU\"p]R\u0014x\u000e\u001c7fe>cG-\u0001\u0006K_\ndunZ+uS2\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u0013\u0002\u000bU$\u0018\u000e\\:\n\u0005-C%A\u0003&pE2{w-\u0016;jY\u00061A(\u001b8jiz\"bAT(Q#J\u001b\u0006C\u0001\"\u0001\u0011\u0015ib\u00011\u0001\u001f\u0011\u0015Qc\u00011\u0001,\u0011\u0015\u0019d\u00011\u00015\u0011\u0015\u0001e\u00011\u0001B\u0011\u0015)e\u00011\u0001GQ\t1Q\u000b\u0005\u0002W76\tqK\u0003\u0002Y3\u00061\u0011N\u001c6fGRT\u0011AW\u0001\u0006U\u00064\u0018\r_\u0005\u00039^\u0013a!\u00138kK\u000e$\u0018!\u0004;sC&$X-\\3oibc5\u000bF\u0006`\u0003?\t\t$!\u0010\u0002T\u0005uCc\u00011\u0002\u0010A!\u0001$Y2x\u0013\t\u0011\u0017D\u0001\u0004UkBdWM\r\t\u0004I2|gBA3k\u001d\t1\u0017.D\u0001h\u0015\tAW#\u0001\u0004=e>|GOP\u0005\u00025%\u00111.G\u0001\ba\u0006\u001c7.Y4f\u0013\tigNA\u0002TKFT!a[\r\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018!B7pI\u0016d'B\u0001;=\u0003\rQwNY\u0005\u0003mF\u00141bR3oKJL7\rR1uCB\u0019\u00010`@\u000e\u0003eT!A_>\u0002\u000f5,H/\u00192mK*\u0011A0G\u0001\u000bG>dG.Z2uS>t\u0017B\u0001@z\u0005\u001dA\u0015m\u001d5TKR\u0004B!!\u0001\u0002\n9!\u00111AA\u0003!\t1\u0017$C\u0002\u0002\be\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003\u001b\u0011aa\u0015;sS:<'bAA\u00043!9\u0011\u0011C\u0004A\u0004\u0005M\u0011!\u00033fEV<Wj\u001c3f!\u0015A\u0012QCA\r\u0013\r\t9\"\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007a\tY\"C\u0002\u0002\u001ee\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\"\u001d\u0001\r!a\t\u0002#M$\u0018\r^5p]B\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0002&\u00055RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u0007\r\u001chO\u0003\u0002s'%!\u0011qFA\u0014\u00055\u00195K\u0016)be\u0006lW\r^3sg\"9\u00111G\u0004A\u0002\u0005U\u0012a\u00024jYR,'o\u001d\t\u0005\u0003o\tI$\u0004\u0002\u0002,%!\u00111HA\u0016\u0005%\u00195K\u0016$jYR,'\u000fC\u0004\u0002@\u001d\u0001\r!!\u0011\u0002\u001d\u0019LG.Z:U_B\u0013xnY3tgB!A\r\\A\"!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\n!![8\u000b\u0005\u00055\u0013\u0001\u00026bm\u0006LA!!\u0015\u0002H\t!a)\u001b7f\u0011\u001d\t)f\u0002a\u0001\u0003/\nQB[8c!\u0006\u0014\u0018-\\3uKJ\u001c\bc\u00019\u0002Z%\u0019\u00111L9\u0003\u001b){'\rU1sC6,G/\u001a:t\u0011\u001d\tyf\u0002a\u0001\u0003C\nAb\u001d;bi&|gnQ8eKN\u0004B\u0001\u001a7\u0002dA!\u0011QMA5\u001b\t\t9G\u0003\u0002su%!\u00111NA4\u0005-\u0019F/\u0019;j_:\u001cu\u000eZ3\u0002\u0019\u0015t'/Z4E_:tW-Z:\u0015\u0019\u0005E\u0014qOA=\u0003w\ny(a!\u0011\u0007a\t\u0019(C\u0002\u0002ve\u00111!\u00138u\u0011\u001d\t)\u0006\u0003a\u0001\u0003/Bq!a\r\t\u0001\u0004\t)\u0004\u0003\u0004\u0002~!\u0001\raY\u0001\u0005I\u0006$\u0018\r\u0003\u0004\u0002\u0002\"\u0001\ra`\u0001\fgR\fG/[8o\u0007>$W\rC\u0004\u0002\u0006\"\u0001\r!!\u001d\u0002\u0013M$\u0018\r^5p]&#\u0017\u0001F2iK\u000e\\7i\u001c8eSRLwN\\\"pYVlg\u000e\u0006\u0004\u0002\u001a\u0005-\u0015Q\u0012\u0005\b\u0003CI\u0001\u0019AA\u0012\u0011\u001d\ty)\u0003a\u0001\u0003#\u000b1A]8x!\u0015A\u00121SAL\u0013\r\t)*\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u00033\u000by*\u0004\u0002\u0002\u001c*\u0011\u0011QT\u0001\u0004Ubd\u0017\u0002BAQ\u00037\u0013AaQ3mY\u0006\u0001BO]1ji\u0016lWM\u001c;PY\u0012DFj\u0015\u000b\u000eA\u0006\u001d\u0016\u0011VAV\u0003_\u000b\t,a-\t\u000f\u0005\u0005\"\u00021\u0001\u0002$!9\u00111\u0007\u0006A\u0002\u0005U\u0002bBAW\u0015\u0001\u0007\u00111I\u0001\u000eM&dW\rV8Qe>\u001cWm]:\t\u000f\u0005U#\u00021\u0001\u0002X!1\u0011\u0011\u0011\u0006A\u0002}Dq!!\"\u000b\u0001\u0004\t\t(A\bhKR\u001cU\r\u001c7U_N#(/\u001b8h)\u0011\tI,a/\u0011\ta\t)b \u0005\b\u0003{[\u0001\u0019AA`\u0003\u0005\u0019\u0007\u0003BAa\u0003/l!!a1\u000b\t\u0005\u0015\u0017qY\u0001\nkN,'/\\8eK2TA!!3\u0002L\u0006\u00111o\u001d\u0006\u0005\u0003\u001b\fy-A\u0002q_&TA!!5\u0002T\u00061\u0011\r]1dQ\u0016T!!!6\u0002\u0007=\u0014x-\u0003\u0003\u0002\"\u0006\r\u0017!\u00043bi\u0016\u001cU\r\u001c7TifdW-\u0006\u0002\u0002^B)\u0001$!\u0006\u0002`B!\u0011\u0011]Au\u001b\t\t\u0019O\u0003\u0003\u0002F\u0006\u0015(\u0002BAt\u0003\u0017\fA\u0001[:tM&!\u00111^Ar\u00055A5k\u0015$DK2d7\u000b^=mK\u0006\tB-\u0019;f\u0007\u0016dGn\u0015;zY\u0016|F%Z9\u0015\t\u0005E\u0018q\u001f\t\u00041\u0005M\u0018bAA{3\t!QK\\5u\u0011%\tI0DA\u0001\u0002\u0004\ti.A\u0002yIE\na\u0002Z1uK\u000e+G\u000e\\*us2,\u0007%A\u0007hKR\u001cU\r\u001c7U_\u0012\u000bG/\u001a\u000b\u000b\u0005\u0003\u0011\u0019B!\u0006\u0003&\t%\u0002#\u0002\r\u0002\u0016\t\r\u0001\u0003\u0002B\u0003\u0005\u001fi!Aa\u0002\u000b\t\t%!1B\u0001\u0005i&lWM\u0003\u0003\u0003\u000e\u0005M\u0017\u0001\u00026pI\u0006LAA!\u0005\u0003\b\tAA)\u0019;f)&lW\rC\u0004\u0002>>\u0001\r!a0\t\u000f\t]q\u00021\u0001\u0003\u001a\u0005\u0019A\r\u001e4\u0011\t\tm!\u0011E\u0007\u0003\u0005;QAAa\b\u0003\b\u00051am\u001c:nCRLAAa\t\u0003\u001e\t\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:\t\r\t\u001dr\u00021\u0001\u0000\u0003)!\u0017\r^3G_Jl\u0017\r\u001e\u0005\b\u0005Wy\u0001\u0019\u0001B\u0017\u0003\t9(\r\u0005\u0003\u0002b\n=\u0012\u0002\u0002B\u0019\u0003G\u0014A\u0002S*T\r^{'o\u001b2p_.\u0004")
public class XLSController {
    private final LogUtil LogUtil;
    private final GenericImportDao genericImportDao;
    private final PointPrelDao PointPrelDao;
    private final XLSControllerOld XLSControllerOld;
    private final JobLogUtil JobLogUtil;
    private Option<HSSFCellStyle> dateCellStyle;

    public Tuple2<Seq<GenericData>, HashSet<String>> traitementXLS(CSVParameters stationParameters, CSVFilter filters, Seq<File> filesToProcess, JobParameters jobParameters, Seq<StationCode> stationCodes, Option<Object> debugMode) {
        long jobExecutionId = jobParameters.jobExecutionId();
        HashSet filesToSetProcessed = new HashSet();
        int dateColumn = BoxesRunTime.unboxToInt((Object)stationParameters.dateColumn().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        String dataCategory = StationTypeUtil$.MODULE$.StationType((String)filters.dataCategory().getOrElse((Function0 & Serializable)() -> "piezometry"));
        Seq results = (Seq)filesToProcess.flatMap((Function1 & Serializable)f -> {
            Seq listValueToExcluded;
            Option stationCodeOpt;
            block1: {
                block0: {
                    $this.JobLogUtil.checkExecutionAbort(jobExecutionId);
                    stationCodeOpt = stationParameters.autoDetectCode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? ((IterableOnceOps)stationCodes.filter((Function1 & Serializable)code -> BoxesRunTime.boxToBoolean((boolean)XLSController.$anonfun$traitementXLS$4(f, code)))).maxByOption((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)XLSController.$anonfun$traitementXLS$5(x$1)), (Ordering)Ordering.Int$.MODULE$) : stationParameters.stationCode().map((Function1 & Serializable)c -> new StationCode(BoxesRunTime.unboxToInt((Object)stationParameters.stationId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)), c, (Option)None$.MODULE$));
                    Option excludedValue = filters.excludedValue().map((Function1 & Serializable)e -> e.replace(",", ".").trim());
                    Object object = listValueToExcluded = excludedValue.isDefined() ? Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)((String)excludedValue.get()).split(";")) : (Seq)Nil$.MODULE$;
                    if (!stationParameters.autoDetectCode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) || !stationCodeOpt.isEmpty()) break block0;
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(26).append("No station found for file ").append(f.getName()).toString(), "", f.getName());
                    break block1;
                }
                if (!stationParameters.autoDetectCode().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) || !stationCodeOpt.isDefined()) break block1;
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(31).append("Station d\u00e9duite n\u00b0").append(((StationCode)stationCodeOpt.get()).id()).append(" via le code ").append(((StationCode)stationCodeOpt.get()).code()).toString(), "", f.getName());
            }
            return (Seq)stationCodeOpt.map((Function1 & Serializable)sc -> {
                Seq seq;
                block11: {
                    String stationCode = sc.code();
                    int stationId = sc.id();
                    Seq pointPrels = new .colon.colon((Object)StationTypeUtil$.MODULE$.PIEZOMETRY(), (List)new .colon.colon((Object)StationTypeUtil$.MODULE$.HYDROMETRY(), (List)new .colon.colon((Object)StationTypeUtil$.MODULE$.PLUVIOMETRY(), (List)Nil$.MODULE$))).contains((Object)dataCategory) ? $this.PointPrelDao.getPoints(dataCategory, stationId) : (Seq)Nil$.MODULE$;
                    None$ samplePoint = stationParameters.pointPrelevement().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim())))) ? pointPrels.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)XLSController.$anonfun$traitementXLS$11(stationParameters, x$3))) : None$.MODULE$;
                    Option codepointGlobal = samplePoint.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.point()));
                    String dateFormat = ((String)filters.dateFormat().getOrElse((Function0 & Serializable)() -> "MM/dd/YYYY")).trim();
                    DateTimeFormatter dtf = DateTimeFormat.forPattern((String)DateUtil$.MODULE$.correctDateFormat(dateFormat));
                    BooleanRef parsingErrorFound = BooleanRef.create((boolean)false);
                    try {
                        Success success;
                        Seq res;
                        Try try_ = Try$.MODULE$.apply(() -> XLSController.$anonfun$traitementXLS$14(this, f, filters, jobExecutionId, stationCode, stationParameters, dateColumn, dtf, dateFormat, pointPrels, (Option)samplePoint, listValueToExcluded, codepointGlobal, parsingErrorFound, jobParameters, stationId, filesToSetProcessed));
                        if (try_ instanceof Success && (res = (Seq)(success = (Success)try_).value()) != null) {
                            Seq seq2;
                            seq = seq2 = res;
                            break block11;
                        }
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable err = failure.exception();
                            if (err.toString().contains("org.apache.poi.hssf.OldExcelFormatException") || err.toString().contains("Extern sheet is part of LinkTable") || err.toString().contains("Your file appears not to be a valid OLE2 document")) {
                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(15).append("Old Excel File ").append(f.getName()).append(err.getMessage()).toString(), "", f.getName());
                                Tuple2<Seq<GenericData>, HashSet<String>> tuple2 = this.traitementOldXLS(stationParameters, filters, (File)f, jobParameters, stationCode, stationId);
                                if (tuple2 == null) {
                                    throw new MatchError(tuple2);
                                }
                                Seq results2 = (Seq)tuple2._1();
                                HashSet filesToSetProcessed2 = (HashSet)tuple2._2();
                                Tuple2 tuple22 = new Tuple2((Object)results2, (Object)filesToSetProcessed2);
                                Seq results22 = (Seq)tuple22._1();
                                HashSet filesToSetProcessed22 = (HashSet)tuple22._2();
                                filesToSetProcessed22.foreach((Function1 & Serializable)filePath -> (HashSet)filesToSetProcessed.$plus$eq(filePath));
                                seq = results22;
                            } else {
                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(38).append("Error during file reading : ").append(f.getName()).append(", error : ").append(err.getMessage()).toString(), stationCode, f.getName());
                                $this.LogUtil.error(new StringBuilder(38).append("Error during file reading : ").append(f.getName()).append(", error : ").append(err.getMessage()).toString(), $this.LogUtil.error$default$2());
                                $this.LogUtil.printError(err);
                                seq = (Seq)Nil$.MODULE$;
                            }
                            break block11;
                        }
                        seq = (Seq)Nil$.MODULE$;
                    }
                    catch (OldExcelFormatException e) {
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(15).append("Old Excel File ").append(f.getName()).append(e.getMessage()).toString(), "", f.getName());
                        Tuple2<Seq<GenericData>, HashSet<String>> tuple2 = this.traitementOldXLS(stationParameters, filters, (File)f, jobParameters, stationCode, stationId);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Seq results2 = (Seq)tuple2._1();
                        HashSet filesToSetProcessed2 = (HashSet)tuple2._2();
                        Tuple2 tuple23 = new Tuple2((Object)results2, (Object)filesToSetProcessed2);
                        Seq results23 = (Seq)tuple23._1();
                        HashSet filesToSetProcessed23 = (HashSet)tuple23._2();
                        filesToSetProcessed23.foreach((Function1 & Serializable)filePath -> (HashSet)filesToSetProcessed.$plus$eq(filePath));
                        seq = results23;
                    }
                    catch (Exception err) {
                        if (err.getMessage().contains("Extern sheet is part of LinkTable") || err.getMessage().contains("Your file appears not to be a valid OLE2 document")) {
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(17).append("Old Excel File ").append(f.getName()).append(", ").append(err.getMessage()).toString(), "", f.getName());
                            Tuple2<Seq<GenericData>, HashSet<String>> tuple2 = this.traitementOldXLS(stationParameters, filters, (File)f, jobParameters, stationCode, stationId);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            Seq results2 = (Seq)tuple2._1();
                            HashSet filesToSetProcessed2 = (HashSet)tuple2._2();
                            Tuple2 tuple24 = new Tuple2((Object)results2, (Object)filesToSetProcessed2);
                            Seq results24 = (Seq)tuple24._1();
                            HashSet filesToSetProcessed24 = (HashSet)tuple24._2();
                            filesToSetProcessed24.foreach((Function1 & Serializable)filePath -> (HashSet)filesToSetProcessed.$plus$eq(filePath));
                            seq = results24;
                            break block11;
                        }
                        $this.LogUtil.error(new StringBuilder(38).append("Error during file reading : ").append(filesToProcess).append(", error : ").append(err.getMessage()).toString(), $this.LogUtil.error$default$2());
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(38).append("Error during file reading : ").append(f.getName()).append(", error : ").append(err.getMessage()).toString(), stationCode, f.getName());
                        seq = (Seq)Nil$.MODULE$;
                    }
                }
                return seq;
            }).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
        });
        return new Tuple2((Object)results, (Object)filesToSetProcessed);
    }

    public int enregDonnees(JobParameters jobParameters, CSVFilter filters, Seq<GenericData> data, String stationCode, int stationId) {
        String string;
        String string2;
        String string3;
        long jobExecutionId = jobParameters.jobExecutionId();
        String user = (String)jobParameters.user().get();
        Option<Object> x$1 = filters.measureCote();
        Option<String> x$2 = filters.importMode();
        Option<Object> x$3 = ImportOptions$.MODULE$.apply$default$1();
        Option<String> x$4 = ImportOptions$.MODULE$.apply$default$4();
        Option<Object> x$5 = ImportOptions$.MODULE$.apply$default$5();
        Option<Seq<Object>> x$6 = ImportOptions$.MODULE$.apply$default$6();
        Option<Object> x$7 = ImportOptions$.MODULE$.apply$default$7();
        Some options = new Some((Object)new ImportOptions(x$3, x$2, x$1, x$4, x$5, x$6, x$7));
        boolean bl = false;
        Some some = null;
        Option<String> option = filters.dataCategory();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string4 = (String)some.value();
            if ("pluviometry".equals(string4)) {
                return this.genericImportDao.importPluviometryGeneric(Integer.toString(stationId), stationCode, user, jobExecutionId, data, (Option<ImportOptions>)options);
            }
        }
        if (bl && "piezometry".equals(string3 = (String)some.value())) {
            return this.genericImportDao.importPiezometryGeneric(Integer.toString(stationId), stationCode, user, jobExecutionId, data, (Option<ImportOptions>)options);
        }
        if (bl && "hydrometry".equals(string2 = (String)some.value())) {
            return this.genericImportDao.importHydrometryGeneric(Integer.toString(stationId), stationCode, user, jobExecutionId, data, (Option<ImportOptions>)options);
        }
        if (bl && "installation".equals(string = (String)some.value())) {
            return this.genericImportDao.importInstallationGeneric(stationId, user, jobExecutionId, data, (Option<ImportOptions>)options);
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Can't determinate data category", stationCode, this.JobLogUtil.log$default$5());
        return 0;
    }

    public boolean checkConditionColumn(CSVParameters stationParameters, Cell[] row) {
        Option<Object> option = stationParameters.conditionColumn();
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            int condColumn = BoxesRunTime.unboxToInt((Object)some.value());
            String content = new String(row[condColumn].getContents());
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(content)) && !content.contains("ERROR")) {
                String string = content;
                Object object = stationParameters.requiredValue().getOrElse((Function0 & Serializable)() -> "");
                return !(string != null ? !string.equals(object) : object != null);
            }
            return false;
        }
        throw new MatchError(option);
    }

    public Tuple2<Seq<GenericData>, HashSet<String>> traitementOldXLS(CSVParameters stationParameters, CSVFilter filters, File fileToProcess, JobParameters jobParameters, String stationCode, int stationId) {
        Seq seq;
        long jobExecutionId = jobParameters.jobExecutionId();
        HashSet filesToSetProcessed = new HashSet();
        None$ samplePoint = stationParameters.pointPrelevement().exists((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$14.trim())))) ? this.PointPrelDao.getPoints((String)filters.dataCategory().getOrElse((Function0 & Serializable)() -> "piezometry"), stationId).find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)XLSController.$anonfun$traitementOldXLS$3(stationParameters, x$15))) : None$.MODULE$;
        Option codepoint = samplePoint.map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.point()));
        this.JobLogUtil.checkExecutionAbort(jobExecutionId);
        try {
            FileInputStream inputStream = new FileInputStream(fileToProcess);
            String dateFormat = !filters.hourWithDate().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && stationParameters.hourColumn().isDefined() ? new StringBuilder(9).append(((String)filters.dateFormat().getOrElse((Function0 & Serializable)() -> "MM/dd/YYYY")).trim()).append(":HH:mm:ss").toString() : ((String)filters.dateFormat().getOrElse((Function0 & Serializable)() -> "MM/dd/YYYY")).trim();
            int entete = BoxesRunTime.unboxToBoolean((Object)filters.hasHeader().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true)) ? BoxesRunTime.unboxToInt((Object)filters.nbHeaders().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)) : 0;
            Workbook oldwoorkbook = Workbook.getWorkbook((InputStream)inputStream);
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)DateUtil$.MODULE$.correctDateFormat(dateFormat));
            ObjectRef data = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
            ObjectRef date = ObjectRef.create((Object)new DateTime());
            Option excludedValue = filters.excludedValue().map((Function1 & Serializable)e -> e.replace(",", ".").trim());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), oldwoorkbook.getNumberOfSheets() - 1).map(arg_0 -> XLSController.$anonfun$traitementOldXLS$10$adapted(this, oldwoorkbook, stationParameters, entete, date, filters, dtf, dateFormat, (Option)samplePoint, excludedValue, codepoint, jobExecutionId, stationCode, fileToProcess, data, arg_0));
            oldwoorkbook.close();
            if (BoxesRunTime.unboxToBoolean((Object)jobParameters.isManualImport().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) && BoxesRunTime.unboxToBoolean((Object)jobParameters.returnsData().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), "end integration of file imported ", stationCode, fileToProcess.getName());
                seq = (Seq)data.elem;
            } else if (((Seq)data.elem).length() == 0) {
                Tuple2<Seq<GenericData>, HashSet<String>> tuple2 = this.XLSControllerOld.traitementOldXLSBis(stationParameters, filters, fileToProcess, jobParameters, stationCode, stationId);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Seq results2 = (Seq)tuple2._1();
                HashSet filesToSetProcessed2 = (HashSet)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)results2, (Object)filesToSetProcessed2);
                Seq results22 = (Seq)tuple22._1();
                HashSet filesToSetProcessed22 = (HashSet)tuple22._2();
                filesToSetProcessed22.foreach((Function1 & Serializable)filePath -> (HashSet)filesToSetProcessed.$plus$eq(filePath));
                seq = results22;
            } else {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(51).append(((Seq)data.elem).length()).append(" records read, begin integration into DB. (old XLS)").toString(), stationCode, fileToProcess.getName());
                int result = this.enregDonnees(jobParameters, filters, (Seq<GenericData>)((Seq)data.elem), stationCode, stationId);
                if (result > 0) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(55).append(result).append(" elements saved, End integration of file. (station id ").append(stationId).append(")").toString(), stationCode, fileToProcess.getName());
                } else {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "Nothing new to import.", stationCode, fileToProcess.getName());
                }
                filesToSetProcessed.$plus$eq((Object)fileToProcess.getAbsolutePath());
                seq = (Seq)Nil$.MODULE$;
            }
        }
        catch (Exception e2) {
            this.JobLogUtil.log(jobParameters.jobExecutionId(), JobState$.MODULE$.ERROR(), new StringBuilder(11).append("Error   ").append(e2).append(" : ").append(e2.getMessage()).toString(), stationCode, fileToProcess.getName());
            this.LogUtil.printError((Throwable)e2);
            seq = (Seq)Nil$.MODULE$;
        }
        Seq results = seq;
        return new Tuple2((Object)results, (Object)filesToSetProcessed);
    }

    public Option<String> getCellToString(org.apache.poi.ss.usermodel.Cell c) {
        if (c != null) {
            org.apache.poi.ss.usermodel.CellType cellType;
            org.apache.poi.ss.usermodel.CellType cellType2 = cellType = c.getCellType();
            org.apache.poi.ss.usermodel.CellType cellType3 = org.apache.poi.ss.usermodel.CellType.STRING;
            if (!(cellType2 != null ? !cellType2.equals(cellType3) : cellType3 != null)) {
                return new Some((Object)c.getStringCellValue().trim());
            }
            org.apache.poi.ss.usermodel.CellType cellType4 = cellType;
            org.apache.poi.ss.usermodel.CellType cellType5 = org.apache.poi.ss.usermodel.CellType.NUMERIC;
            if (!(cellType4 != null ? !cellType4.equals(cellType5) : cellType5 != null)) {
                return new Some((Object)Integer.toString((int)c.getNumericCellValue()).trim());
            }
            org.apache.poi.ss.usermodel.CellType cellType6 = cellType;
            org.apache.poi.ss.usermodel.CellType cellType7 = org.apache.poi.ss.usermodel.CellType.BLANK;
            if (!(cellType6 != null ? !cellType6.equals(cellType7) : cellType7 != null)) {
                return new Some((Object)"");
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Option<HSSFCellStyle> dateCellStyle() {
        return this.dateCellStyle;
    }

    public void dateCellStyle_$eq(Option<HSSFCellStyle> x$1) {
        this.dateCellStyle = x$1;
    }

    public Option<DateTime> getCellToDate(org.apache.poi.ss.usermodel.Cell c, DateTimeFormatter dtf, String dateFormat, HSSFWorkbook wb) {
        block5: {
            block7: {
                block6: {
                    org.apache.poi.ss.usermodel.CellType cellType;
                    if (c == null) break block5;
                    org.apache.poi.ss.usermodel.CellType cellType2 = cellType = c.getCellType();
                    org.apache.poi.ss.usermodel.CellType cellType3 = org.apache.poi.ss.usermodel.CellType.STRING;
                    if (!(cellType2 != null ? !cellType2.equals(cellType3) : cellType3 != null)) {
                        String stringValue = c.getStringCellValue().trim();
                        String string = stringValue.trim();
                        String string2 = "";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return None$.MODULE$;
                        }
                        return Try$.MODULE$.apply((Function0 & Serializable)() -> dtf.parseDateTime(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(stringValue), BoxesRunTime.unboxToInt((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{dateFormat.length(), stringValue.length()})).min((Ordering)Ordering.Int$.MODULE$))))).toOption();
                    }
                    org.apache.poi.ss.usermodel.CellType cellType4 = cellType;
                    org.apache.poi.ss.usermodel.CellType cellType5 = org.apache.poi.ss.usermodel.CellType.NUMERIC;
                    if (!(cellType4 == null ? cellType5 != null : !cellType4.equals(cellType5))) break block6;
                    org.apache.poi.ss.usermodel.CellType cellType6 = cellType;
                    org.apache.poi.ss.usermodel.CellType cellType7 = org.apache.poi.ss.usermodel.CellType.FORMULA;
                    if (cellType6 != null ? !cellType6.equals(cellType7) : cellType7 != null) break block7;
                }
                return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    HSSFCellStyle cellStyle = (HSSFCellStyle)this.dateCellStyle().getOrElse((Function0 & Serializable)() -> {
                        HSSFCellStyle cs = wb.createCellStyle();
                        HSSFCreationHelper createHelper = wb.getCreationHelper();
                        cs.setDataFormat(createHelper.createDataFormat().getFormat(dateFormat));
                        this.dateCellStyle_$eq((Option<HSSFCellStyle>)new Some((Object)cs));
                        return cs;
                    });
                    c.setCellStyle((CellStyle)cellStyle);
                    DataFormatter dataFormatter = new DataFormatter();
                    String cellStringValue = dataFormatter.formatCellValue(c).trim();
                    return Try$.MODULE$.apply((Function0 & Serializable)() -> dtf.parseDateTime(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(cellStringValue), BoxesRunTime.unboxToInt((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{dateFormat.length(), cellStringValue.length()})).min((Ordering)Ordering.Int$.MODULE$))))).toOption();
                }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$traitementXLS$4(File f$1, StationCode code) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(code.code().trim())) && f$1.getName().contains(code.code());
    }

    public static final /* synthetic */ int $anonfun$traitementXLS$5(StationCode x$1) {
        return x$1.code().trim().length();
    }

    public static final /* synthetic */ boolean $anonfun$traitementXLS$11(CSVParameters stationParameters$1, PointPrel x$3) {
        String string = x$3.code().trim().toLowerCase();
        String string2 = ((String)stationParameters$1.pointPrelevement().get()).trim().toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Option getString$1(int column, Row row$1) {
        return this.getCellToString(row$1.getCell(column));
    }

    public static final /* synthetic */ boolean $anonfun$traitementXLS$25(String c$1, PointPrel x$6) {
        String string = x$6.code().trim().toLowerCase();
        String string2 = c$1.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Option $anonfun$traitementXLS$33(Row row$1, int column) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> (int)row$1.getCell(column).getNumericCellValue()).toOption();
    }

    public static final /* synthetic */ Option $anonfun$traitementXLS$36(Row row$1, int column) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> (int)row$1.getCell(column).getNumericCellValue()).toOption();
    }

    public static final /* synthetic */ Option $anonfun$traitementXLS$38(Row row$1, int column) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> (int)row$1.getCell(column).getNumericCellValue()).toOption();
    }

    public static final /* synthetic */ Option $anonfun$traitementXLS$46(Row row$1, int column) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> (int)row$1.getCell(column).getNumericCellValue()).toOption();
    }

    public static final /* synthetic */ Option $anonfun$traitementXLS$49(Row row$1, int column) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> (int)row$1.getCell(column).getNumericCellValue()).toOption();
    }

    public static final /* synthetic */ Option $anonfun$traitementXLS$51(Row row$1, int column) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> (int)row$1.getCell(column).getNumericCellValue()).toOption();
    }

    public static final /* synthetic */ IterableOnce $anonfun$traitementXLS$22(CSVParameters stationParameters$1, Row row$1, Seq pointPrels$1, Option samplePoint$1, Seq listValueToExcluded$1, Option date$1, CSVFilter filters$1, Option codepointGlobal$1, CSVDataColumn d) {
        org.apache.poi.ss.usermodel.Cell c2;
        Option codePointCol;
        block11: {
            block12: {
                Tuple2 tuple2;
                Tuple2 tuple22;
                if (stationParameters$1.pointPrelCol().isDefined()) {
                    Option codeInFile = Try$.MODULE$.apply((Function0 & Serializable)() -> row$1.getCell(BoxesRunTime.unboxToInt((Object)stationParameters$1.pointPrelCol().get())).getStringCellValue()).toOption();
                    Option samplePoint2 = codeInFile.flatMap((Function1 & Serializable)c -> pointPrels$1.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)XLSController.$anonfun$traitementXLS$25(c, x$6))));
                    tuple22 = new Tuple2((Object)samplePoint2.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.point())), (Object)samplePoint2);
                } else {
                    tuple22 = tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                }
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option codePointCol2 = (Option)tuple2._1();
                Option samplePoint2 = (Option)tuple2._2();
                Tuple2 tuple23 = new Tuple2((Object)codePointCol2, (Object)samplePoint2);
                codePointCol = (Option)tuple23._1();
                Option samplePoint22 = (Option)tuple23._2();
                if (samplePoint$1.isDefined() && ((PointPrel)samplePoint$1.get()).typeId() != d.id() || samplePoint22.isDefined() && ((PointPrel)samplePoint22.get()).typeId() != d.id()) {
                    throw new Exception(new StringBuilder(92).append("Le point de pr\u00e9l\u00e8vement '").append(((PointPrel)samplePoint$1.get()).code()).append("' ne correspond pas au type de la colonne s\u00e9lectionn\u00e9e (colonne n\u00b0").append(d.column()).append(")").toString());
                }
                c2 = row$1.getCell(d.column());
                if (c2 == null) break block11;
                org.apache.poi.ss.usermodel.CellType cellType = c2.getCellType();
                org.apache.poi.ss.usermodel.CellType cellType2 = org.apache.poi.ss.usermodel.CellType.NUMERIC;
                if (!(cellType == null ? cellType2 != null : !cellType.equals(cellType2))) break block12;
                org.apache.poi.ss.usermodel.CellType cellType3 = c2.getCellType();
                org.apache.poi.ss.usermodel.CellType cellType4 = org.apache.poi.ss.usermodel.CellType.FORMULA;
                if (cellType3 != null ? !cellType3.equals(cellType4) : cellType4 != null) break block11;
            }
            Option numericValue = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> c2.getNumericCellValue()).toOption();
            Option stringValue = Try$.MODULE$.apply((Function0 & Serializable)() -> c2.getStringCellValue().trim()).toOption();
            if (numericValue.isEmpty() && stringValue.contains((Object)"") || numericValue.exists((Function1)(JFunction1.mcZD.sp & Serializable)x$9 -> Double.isNaN(x$9)) || listValueToExcluded$1.contains((Object)numericValue)) {
                return None$.MODULE$;
            }
            DateTime x$1 = (DateTime)date$1.get();
            DateTime x$2 = (DateTime)date$1.get();
            Some x$3 = new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)numericValue.get()) * BoxesRunTime.unboxToDouble((Object)stationParameters$1.factor().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0)) + BoxesRunTime.unboxToDouble((Object)stationParameters$1.offset().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)))));
            int x$4 = d.id();
            Option x$5 = filters$1.status().orElse((Function0 & Serializable)() -> stationParameters$1.status().flatMap((Function1 & Serializable)column -> XLSController.$anonfun$traitementXLS$33(row$1, BoxesRunTime.unboxToInt((Object)column))));
            Option x$6 = filters$1.qualification().orElse((Function0 & Serializable)() -> stationParameters$1.qualification().flatMap((Function1 & Serializable)column -> XLSController.$anonfun$traitementXLS$36(row$1, BoxesRunTime.unboxToInt((Object)column))));
            Option x$72 = stationParameters$1.initialPoint().flatMap((Function1 & Serializable)column -> XLSController.$anonfun$traitementXLS$38(row$1, BoxesRunTime.unboxToInt((Object)column)));
            Option<Object> x$8 = filters$1.producer();
            Option<Object> x$92 = filters$1.validator();
            Option<Object> x$102 = filters$1.manager();
            Option<String> x$11 = filters$1.nature();
            Option<Object> x$12 = filters$1.obtainingMode();
            Option x$13 = codePointCol.orElse((Function0 & Serializable)() -> codepointGlobal$1);
            Option x$14 = GenericData$.MODULE$.$lessinit$greater$default$13();
            Option x$15 = GenericData$.MODULE$.$lessinit$greater$default$14();
            return new Some((Object)new GenericData(x$1, x$2, (Option)x$3, x$4, x$5, x$6, x$12, x$8, x$92, x$102, x$11, x$72, x$14, x$15, x$13));
        }
        if (c2 != null) {
            org.apache.poi.ss.usermodel.CellType cellType = c2.getCellType();
            org.apache.poi.ss.usermodel.CellType cellType5 = org.apache.poi.ss.usermodel.CellType.STRING;
            if (!(cellType != null ? !cellType.equals(cellType5) : cellType5 != null)) {
                Option doubleValue = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(c2.getStringCellValue().trim().replace(",", ".")))).toOption();
                if (doubleValue.isEmpty() || doubleValue.exists((Function1)(JFunction1.mcZD.sp & Serializable)x$10 -> Double.isNaN(x$10)) || listValueToExcluded$1.contains((Object)doubleValue)) {
                    return None$.MODULE$;
                }
                DateTime x$16 = (DateTime)date$1.get();
                DateTime x$17 = (DateTime)date$1.get();
                Some x$18 = new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)doubleValue.get()) * BoxesRunTime.unboxToDouble((Object)stationParameters$1.factor().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0)) + BoxesRunTime.unboxToDouble((Object)stationParameters$1.offset().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)))));
                int x$19 = d.id();
                Option x$20 = filters$1.status().orElse((Function0 & Serializable)() -> stationParameters$1.status().flatMap((Function1 & Serializable)column -> XLSController.$anonfun$traitementXLS$46(row$1, BoxesRunTime.unboxToInt((Object)column))));
                Option x$21 = filters$1.qualification().orElse((Function0 & Serializable)() -> stationParameters$1.qualification().flatMap((Function1 & Serializable)column -> XLSController.$anonfun$traitementXLS$49(row$1, BoxesRunTime.unboxToInt((Object)column))));
                Option x$22 = stationParameters$1.initialPoint().flatMap((Function1 & Serializable)column -> XLSController.$anonfun$traitementXLS$51(row$1, BoxesRunTime.unboxToInt((Object)column)));
                Option<Object> x$23 = filters$1.producer();
                Option<Object> x$24 = filters$1.validator();
                Option<Object> x$25 = filters$1.manager();
                Option<String> x$26 = filters$1.nature();
                Option<Object> x$27 = filters$1.obtainingMode();
                Option x$28 = codePointCol.orElse((Function0 & Serializable)() -> codepointGlobal$1);
                Option x$29 = GenericData$.MODULE$.$lessinit$greater$default$13();
                Option x$30 = GenericData$.MODULE$.$lessinit$greater$default$14();
                return new Some((Object)new GenericData(x$16, x$17, (Option)x$18, x$19, x$20, x$21, x$27, x$23, x$24, x$25, x$26, x$22, x$29, x$30, x$28));
            }
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ Seq $anonfun$traitementXLS$14(XLSController $this, File f$1, CSVFilter filters$1, long jobExecutionId$1, String stationCode$1, CSVParameters stationParameters$1, int dateColumn$1, DateTimeFormatter dtf$1, String dateFormat$1, Seq pointPrels$1, Option samplePoint$1, Seq listValueToExcluded$1, Option codepointGlobal$1, BooleanRef parsingErrorFound$1, JobParameters jobParameters$1, int stationId$1, HashSet filesToSetProcessed$1) {
        Seq seq;
        FileInputStream inputStream = new FileInputStream(f$1);
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)inputStream);
        $this.dateCellStyle_$eq((Option<HSSFCellStyle>)None$.MODULE$);
        Iterator sheetIterator = workbook.iterator();
        Seq data = (Seq)Nil$.MODULE$;
        int entete = BoxesRunTime.unboxToBoolean((Object)filters$1.hasHeader().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true)) ? BoxesRunTime.unboxToInt((Object)filters$1.nbHeaders().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)) : 0;
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(12).append("skip ").append(entete).append("  line ").toString(), stationCode$1, f$1.getName());
        while (sheetIterator.hasNext()) {
            org.apache.poi.ss.usermodel.Sheet sheet = (org.apache.poi.ss.usermodel.Sheet)sheetIterator.next();
            if ((!stationParameters$1.sheet().isDefined() || sheet.getSheetName().indexOf((String)stationParameters$1.sheet().get()) < 0) && !stationParameters$1.sheet().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)))).isEmpty()) continue;
            for (Row row : sheet) {
                BoxedUnit boxedUnit;
                block28: {
                    block29: {
                        int rowNum = row.getRowNum();
                        if (rowNum % 10000 == 0) {
                            $this.JobLogUtil.checkExecutionAbort(jobExecutionId$1);
                            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(35).append("Reading line ").append(rowNum).append(", data read length is ").append(data.length()).toString(), stationCode$1, f$1.getName());
                        }
                        if (row.getRowNum() < entete) break block28;
                        if (row.getCell(dateColumn$1) == null) break block29;
                        try {
                            block31: {
                                Some date;
                                Object object;
                                block30: {
                                    if (stationParameters$1.conditionColumn().isEmpty()) break block30;
                                    Option option = $this.getString$1(BoxesRunTime.unboxToInt((Object)stationParameters$1.conditionColumn().get()), row);
                                    Option<String> option2 = stationParameters$1.requiredValue();
                                    if (option != null ? !option.equals(option2) : option2 != null) break block31;
                                }
                                if (filters$1.hourWithDate().isDefined() && BoxesRunTime.unboxToBoolean((Object)filters$1.hourWithDate().get())) {
                                    org.apache.poi.ss.usermodel.CellType cellType = row.getCell(dateColumn$1).getCellType();
                                    org.apache.poi.ss.usermodel.CellType cellType2 = org.apache.poi.ss.usermodel.CellType.STRING;
                                    if (!(cellType != null ? !cellType.equals(cellType2) : cellType2 != null)) {
                                        object = $this.getCellToDate(row.getCell(dateColumn$1), dtf$1, dateFormat$1, workbook);
                                    } else {
                                        org.apache.poi.ss.usermodel.CellType cellType3 = row.getCell(dateColumn$1).getCellType();
                                        org.apache.poi.ss.usermodel.CellType cellType4 = org.apache.poi.ss.usermodel.CellType.NUMERIC;
                                        if (!(cellType3 != null ? !cellType3.equals(cellType4) : cellType4 != null)) {
                                            object = $this.getCellToDate(row.getCell(dateColumn$1), dtf$1, dateFormat$1, workbook);
                                        } else {
                                            org.apache.poi.ss.usermodel.CellType cellType5 = row.getCell(dateColumn$1).getCellType();
                                            org.apache.poi.ss.usermodel.CellType cellType6 = org.apache.poi.ss.usermodel.CellType.FORMULA;
                                            object = !(cellType5 != null ? !cellType5.equals(cellType6) : cellType6 != null) ? (Try$.MODULE$.apply((Function0 & Serializable)() -> row.getCell(dateColumn$1).getStringCellValue().trim()).toOption().contains((Object)"") ? None$.MODULE$ : Try$.MODULE$.apply((Function0 & Serializable)() -> new DateTime((Object)row.getCell(dateColumn$1).getDateCellValue())).toOption()) : new Some((Object)new DateTime((Object)row.getCell(dateColumn$1).getDateCellValue()));
                                        }
                                    }
                                } else if (stationParameters$1.hourColumn().isDefined()) {
                                    String hourWithDefault;
                                    String hour = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString((String)$this.getString$1(BoxesRunTime.unboxToInt((Object)stationParameters$1.hourColumn().get()), row).get()), 8);
                                    String string = hourWithDefault = hour.isEmpty() && filters$1.defaultHour().isDefined() && filters$1.defaultHour().exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$5)))) ? (String)filters$1.defaultHour().get() : hour;
                                    String hourValue = hourWithDefault.length() == 5 ? new StringBuilder(3).append(hourWithDefault).append(":00").toString() : (hourWithDefault.length() == 6 ? new StringBuilder(2).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hour), 2)).append(":").append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hourWithDefault), 4)), 2)).append(":").append(StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(hourWithDefault), 2)).toString() : hourWithDefault);
                                    DateTime dateCol = (DateTime)$this.getCellToDate(row.getCell(dateColumn$1), dtf$1, dateFormat$1, workbook).get();
                                    object = new Some((Object)dateCol.withTime(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hourValue), 2))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(hourValue), 3)), 2))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(hourValue), 6))), 0));
                                } else {
                                    org.apache.poi.ss.usermodel.CellType cellType = row.getCell(dateColumn$1).getCellType();
                                    org.apache.poi.ss.usermodel.CellType cellType7 = org.apache.poi.ss.usermodel.CellType.STRING;
                                    if (!(cellType != null ? !cellType.equals(cellType7) : cellType7 != null)) {
                                        object = $this.getCellToDate(row.getCell(dateColumn$1), dtf$1, dateFormat$1, workbook);
                                    } else {
                                        org.apache.poi.ss.usermodel.CellType cellType8 = row.getCell(dateColumn$1).getCellType();
                                        org.apache.poi.ss.usermodel.CellType cellType9 = org.apache.poi.ss.usermodel.CellType.NUMERIC;
                                        if (!(cellType8 != null ? !cellType8.equals(cellType9) : cellType9 != null)) {
                                            object = $this.getCellToDate(row.getCell(dateColumn$1), dtf$1, dateFormat$1, workbook);
                                        } else {
                                            org.apache.poi.ss.usermodel.CellType cellType10 = row.getCell(dateColumn$1).getCellType();
                                            org.apache.poi.ss.usermodel.CellType cellType11 = org.apache.poi.ss.usermodel.CellType.FORMULA;
                                            object = !(cellType10 != null ? !cellType10.equals(cellType11) : cellType11 != null) ? (Try$.MODULE$.apply((Function0 & Serializable)() -> row.getCell(dateColumn$1).getStringCellValue().trim()).toOption().contains((Object)"") ? None$.MODULE$ : new Some((Object)new DateTime((Object)row.getCell(dateColumn$1).getDateCellValue()))) : (date = new Some((Object)new DateTime((Object)row.getCell(dateColumn$1).getDateCellValue())));
                                        }
                                    }
                                }
                                if (date.isDefined()) {
                                    Seq res = stationParameters$1.data().isDefined() ? (Seq)((IterableOps)stationParameters$1.data().get()).flatMap(arg_0 -> XLSController.$anonfun$traitementXLS$22(stationParameters$1, row, pointPrels$1, samplePoint$1, listValueToExcluded$1, (Option)date, filters$1, codepointGlobal$1, arg_0)) : (Seq)Nil$.MODULE$;
                                    data = (Seq)data.$plus$plus((IterableOnce)res);
                                }
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        catch (Exception e) {
                            if (e != null && e.getMessage() != null && e.getMessage().contains("Illegal instant due to time zone offset transition")) {
                                boxedUnit = None$.MODULE$;
                                continue;
                            }
                            if (e != null && e.getMessage() != null && !parsingErrorFound$1.elem) {
                                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(57).append("Error parsing value data in file ").append(f$1.getName()).append(" at the line ").append(row.getRowNum()).append(" , error : ").append(e.getMessage()).toString(), stationCode$1, f$1.getName());
                                parsingErrorFound$1.elem = true;
                            }
                            boxedUnit = None$.MODULE$;
                        }
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (BoxesRunTime.unboxToBoolean((Object)jobParameters$1.isManualImport().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) && BoxesRunTime.unboxToBoolean((Object)jobParameters$1.returnsData().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), "end integration of file imported ", stationCode$1, f$1.getName());
            seq = data;
        } else {
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(47).append(data.length()).append(" records read, begin integration into DB. (XLS)").toString(), stationCode$1, f$1.getName());
            int result = $this.enregDonnees(jobParameters$1, filters$1, (Seq<GenericData>)data, stationCode$1, stationId$1);
            if (result > 0) {
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(55).append(result).append(" elements saved, End integration of file. (station id ").append(stationId$1).append(")").toString(), stationCode$1, f$1.getName());
            } else {
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.NOTHING_TO_DO(), "Nothing new to import.", stationCode$1, f$1.getName());
            }
            filesToSetProcessed$1.$plus$eq((Object)f$1.getAbsolutePath());
            seq = (Seq)Nil$.MODULE$;
        }
        Seq returned = seq;
        workbook.close();
        inputStream.close();
        return returned;
    }

    public static final /* synthetic */ boolean $anonfun$traitementOldXLS$3(CSVParameters stationParameters$2, PointPrel x$15) {
        String string = x$15.code().trim().toLowerCase();
        String string2 = ((String)stationParameters$2.pointPrelevement().get()).trim().toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ DateTime $anonfun$traitementOldXLS$13(Cell cellEncours$1) {
        return new DateTime((Object)((DateCell)cellEncours$1).getDate());
    }

    public static final /* synthetic */ DateTime $anonfun$traitementOldXLS$14(DateTimeFormatter dtf$2, String content$1, String dateFormat$2) {
        return dtf$2.parseDateTime(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(content$1), dateFormat$2.length()));
    }

    public static final /* synthetic */ IterableOnce $anonfun$traitementOldXLS$16(XLSController $this, Option samplePoint$2, int rowIndex$1, String content$1, Option excludedValue$1, Option numericValue$1, ObjectRef date$2, CSVParameters stationParameters$2, Option codepoint$1, long jobExecutionId$2, int i$1, String stationCode$2, File fileToProcess$1, CSVDataColumn d) {
        block5: {
            Option value;
            block7: {
                block6: {
                    if (samplePoint$2.isDefined() && ((PointPrel)samplePoint$2.get()).typeId() != d.id()) {
                        throw new Exception(new StringBuilder(92).append("Le point de pr\u00e9l\u00e8vement '").append(((PointPrel)samplePoint$2.get()).code()).append("' ne correspond pas au type de la colonne s\u00e9lectionn\u00e9e (colonne n\u00b0").append(d.column()).append(")").toString());
                    }
                    if (rowIndex$1 != d.column()) break block5;
                    String stringValue = content$1.replace(",", ".").trim();
                    if (excludedValue$1.contains((Object)stringValue)) break block6;
                    String string = stringValue.toUpperCase();
                    String string2 = "NAN";
                    if (string != null ? !string.equals(string2) : string2 != null) break block7;
                }
                return None$.MODULE$;
            }
            Option option = value = numericValue$1.isDefined() ? numericValue$1 : Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(content$1.replace(",", ".")))).toOption();
            if (value.isDefined()) {
                DateTime x$1 = (DateTime)date$2.elem;
                DateTime x$2 = (DateTime)date$2.elem;
                Some x$3 = new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)value.get()) * BoxesRunTime.unboxToDouble((Object)stationParameters$2.factor().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0)) + BoxesRunTime.unboxToDouble((Object)stationParameters$2.offset().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)))));
                int x$4 = d.id();
                Option x$5 = codepoint$1;
                Option x$6 = GenericData$.MODULE$.$lessinit$greater$default$5();
                Option x$7 = GenericData$.MODULE$.$lessinit$greater$default$6();
                Option x$8 = GenericData$.MODULE$.$lessinit$greater$default$7();
                Option x$9 = GenericData$.MODULE$.$lessinit$greater$default$8();
                Option x$10 = GenericData$.MODULE$.$lessinit$greater$default$9();
                Option x$11 = GenericData$.MODULE$.$lessinit$greater$default$10();
                Option x$12 = GenericData$.MODULE$.$lessinit$greater$default$11();
                Option x$13 = GenericData$.MODULE$.$lessinit$greater$default$12();
                Option x$14 = GenericData$.MODULE$.$lessinit$greater$default$13();
                Option x$15 = GenericData$.MODULE$.$lessinit$greater$default$14();
                return new Some((Object)new GenericData(x$1, x$2, (Option)x$3, x$4, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$5));
            }
            $this.JobLogUtil.log(jobExecutionId$2, JobState$.MODULE$.WARNING(), new StringBuilder(43).append("Unable to read cell value in line ").append(i$1).append(", column ").append(rowIndex$1).toString(), stationCode$2, fileToProcess$1.getName());
            $this.JobLogUtil.log(jobExecutionId$2, JobState$.MODULE$.WARNING(), new StringBuilder(14).append("Value found : ").append(((Throwable)Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(content$1.replace(",", ".")))).failed().get()).getMessage()).toString(), stationCode$2, fileToProcess$1.getName());
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ void $anonfun$traitementOldXLS$12(XLSController $this, Cell[] row$2, CSVParameters stationParameters$2, ObjectRef date$2, CSVFilter filters$2, DateTimeFormatter dtf$2, String dateFormat$2, Option samplePoint$2, Option excludedValue$1, Option codepoint$1, long jobExecutionId$2, int i$1, String stationCode$2, File fileToProcess$1, ObjectRef data$1, int rowIndex) {
        block8: {
            block9: {
                cellEncours = row$2[rowIndex];
                if (!$this.checkConditionColumn(stationParameters$2, row$2)) break block8;
                if (cellEncours.getType() == CellType.EMPTY) break block9;
                content = new String(cellEncours.getContents());
                if (rowIndex == BoxesRunTime.unboxToInt((Object)stationParameters$2.dateColumn().get())) ** GOTO lbl-1000
                v0 = cellEncours.getType();
                var20_18 = CellType.NUMBER;
                if (!(v0 == null ? var20_18 != null : v0.equals(var20_18) == false)) ** GOTO lbl-1000
                v1 = cellEncours.getType();
                var21_19 = CellType.NUMBER_FORMULA;
                if (!(v1 != null ? v1.equals(var21_19) == false : var21_19 != null)) lbl-1000:
                // 2 sources

                {
                    v2 = new Some((Object)BoxesRunTime.boxToDouble((double)((NumberCell)cellEncours).getValue()));
                } else lbl-1000:
                // 2 sources

                {
                    v2 = numericValue = None$.MODULE$;
                }
                if (rowIndex == BoxesRunTime.unboxToInt((Object)stationParameters$2.dateColumn().get())) {
                    if (filters$2.hourWithDate().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                        v3 /* !! */  = (DateTime)Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$traitementOldXLS$13(jxl.Cell ), ()Lorg/joda/time/DateTime;)((Cell)cellEncours)).toOption().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$traitementOldXLS$14(org.joda.time.format.DateTimeFormatter java.lang.String java.lang.String ), ()Lorg/joda/time/DateTime;)((DateTimeFormatter)dtf$2, (String)content, (String)dateFormat$2));
                    } else if (stationParameters$2.hourColumn().isDefined()) {
                        hour = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(content), 8);
                        v4 = hourWithDefault = hour.isEmpty() != false && filters$2.defaultHour().isDefined() != false && filters$2.defaultHour().exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$traitementOldXLS$15$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()) != false ? (String)filters$2.defaultHour().get() : hour;
                        hourValue = hourWithDefault.length() == 5 ? new StringBuilder(3).append(hourWithDefault).append(":00").toString() : (hourWithDefault.length() == 6 ? new StringBuilder(2).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hourWithDefault), 2)).append(":").append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hourWithDefault), 4)), 2)).append(":").append(StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(hourWithDefault), 2)).toString() : hourWithDefault);
                        v3 /* !! */  = dtf$2.parseDateTime(new StringBuilder(1).append(content).append(":").append(hourValue).toString());
                    } else {
                        v3 /* !! */  = date$2.elem = dtf$2.parseDateTime(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(content), dateFormat$2.length()));
                    }
                }
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(content)) && !content.contains("ERROR")) {
                    res = stationParameters$2.data().isDefined() != false ? (Seq)((IterableOps)stationParameters$2.data().get()).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$traitementOldXLS$16(csvorexcel.controllers.XLSController scala.Option int java.lang.String scala.Option scala.Option scala.runtime.ObjectRef csvorexcel.model.csv.CSVParameters scala.Option long int java.lang.String java.io.File csvorexcel.model.CSVDataColumn ), (Lcsvorexcel/model/CSVDataColumn;)Lscala/collection/IterableOnce;)((XLSController)$this, (Option)samplePoint$2, (int)rowIndex, (String)content, (Option)excludedValue$1, (Option)numericValue, (ObjectRef)date$2, (CSVParameters)stationParameters$2, (Option)codepoint$1, (long)jobExecutionId$2, (int)i$1, (String)stationCode$2, (File)fileToProcess$1)) : (Seq)Nil$.MODULE$;
                    data$1.elem = (Seq)((Seq)data$1.elem).$plus$plus((IterableOnce)res);
                    return;
                }
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ IndexedSeq $anonfun$traitementOldXLS$11(XLSController $this, Sheet sheet$1, CSVParameters stationParameters$2, ObjectRef date$2, CSVFilter filters$2, DateTimeFormatter dtf$2, String dateFormat$2, Option samplePoint$2, Option excludedValue$1, Option codepoint$1, long jobExecutionId$2, String stationCode$2, File fileToProcess$1, ObjectRef data$1, int i) {
        Cell[] row = sheet$1.getRow(i);
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), row.length).map((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> XLSController.$anonfun$traitementOldXLS$12($this, row, stationParameters$2, date$2, filters$2, dtf$2, dateFormat$2, samplePoint$2, excludedValue$1, codepoint$1, jobExecutionId$2, i, stationCode$2, fileToProcess$1, data$1, arg_0)));
    }

    public static final /* synthetic */ Object $anonfun$traitementOldXLS$10(XLSController $this, Workbook oldwoorkbook$1, CSVParameters stationParameters$2, int entete$1, ObjectRef date$2, CSVFilter filters$2, DateTimeFormatter dtf$2, String dateFormat$2, Option samplePoint$2, Option excludedValue$1, Option codepoint$1, long jobExecutionId$2, String stationCode$2, File fileToProcess$1, ObjectRef data$1, int idx) {
        Sheet sheet = oldwoorkbook$1.getSheet(idx);
        if (oldwoorkbook$1.getNumberOfSheets() == 1 || sheet.getName().contains((CharSequence)stationParameters$2.sheet().get())) {
            return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(entete$1), sheet.getRows()).map((Function1 & Serializable)i -> XLSController.$anonfun$traitementOldXLS$11($this, sheet, stationParameters$2, date$2, filters$2, dtf$2, dateFormat$2, samplePoint$2, excludedValue$1, codepoint$1, jobExecutionId$2, stationCode$2, fileToProcess$1, data$1, BoxesRunTime.unboxToInt((Object)i)));
        }
        return BoxedUnit.UNIT;
    }

    @Inject
    public XLSController(LogUtil LogUtil2, GenericImportDao genericImportDao, PointPrelDao PointPrelDao2, XLSControllerOld XLSControllerOld2, JobLogUtil JobLogUtil2) {
        this.LogUtil = LogUtil2;
        this.genericImportDao = genericImportDao;
        this.PointPrelDao = PointPrelDao2;
        this.XLSControllerOld = XLSControllerOld2;
        this.JobLogUtil = JobLogUtil2;
        this.dateCellStyle = None$.MODULE$;
    }

    public static final /* synthetic */ Object $anonfun$traitementOldXLS$10$adapted(XLSController $this, Workbook oldwoorkbook$1, CSVParameters stationParameters$2, int entete$1, ObjectRef date$2, CSVFilter filters$2, DateTimeFormatter dtf$2, String dateFormat$2, Option samplePoint$2, Option excludedValue$1, Option codepoint$1, long jobExecutionId$2, String stationCode$2, File fileToProcess$1, ObjectRef data$1, Object idx) {
        return XLSController.$anonfun$traitementOldXLS$10($this, oldwoorkbook$1, stationParameters$2, entete$1, date$2, filters$2, dtf$2, dateFormat$2, samplePoint$2, excludedValue$1, codepoint$1, jobExecutionId$2, stationCode$2, fileToProcess$1, data$1, BoxesRunTime.unboxToInt((Object)idx));
    }

    public static final /* synthetic */ Object $anonfun$traitementOldXLS$15$adapted(String x$17) {
        return BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$17)));
    }
}

