/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import common.Assert;
import csvorexcel.controllers.jxlAquasys.CellValue;
import csvorexcel.controllers.jxlAquasys.ExternalSheet;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.FormulaException;
import csvorexcel.controllers.jxlAquasys.FormulaParser;
import csvorexcel.controllers.jxlAquasys.Record;
import jxl.BooleanCell;
import jxl.CellType;
import jxl.biff.FormulaData;

class BooleanFormulaRecord
extends CellValue
implements BooleanCell,
FormulaData {
    private boolean value;
    private ExternalSheet externalSheet;
    private String formulaString;
    private byte[] data;

    public BooleanFormulaRecord(Record t, FormattingRecords fr, ExternalSheet es) {
        super(t, fr);
        this.externalSheet = es;
        this.value = false;
        this.data = this.getRecord().getData();
        Assert.verify((this.data[6] != 2 ? 1 : 0) != 0);
        this.value = this.data[8] == 1;
    }

    @Override
    public String getContents() {
        return new Boolean(this.value).toString();
    }

    public String getFormula() throws FormulaException {
        if (this.formulaString == null) {
            byte[] tokens = new byte[this.data.length - 22];
            System.arraycopy(this.data, 22, tokens, 0, tokens.length);
            FormulaParser fp = new FormulaParser(tokens, this, this.externalSheet);
            fp.parse();
            this.formulaString = fp.getFormula();
        }
        return this.formulaString;
    }

    public byte[] getFormulaData() {
        return this.data;
    }

    @Override
    public CellType getType() {
        return CellType.BOOLEAN_FORMULA;
    }

    public boolean getValue() {
        return this.value;
    }
}

