/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import common.Assert;
import csvorexcel.controllers.jxlAquasys.CellValue;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.Record;
import jxl.BooleanCell;
import jxl.CellType;

class BooleanRecord
extends CellValue
implements BooleanCell {
    private boolean error = false;
    private boolean value = false;

    public BooleanRecord(Record t, FormattingRecords fr) {
        super(t, fr);
        byte[] data = this.getRecord().getData();
        boolean bl = this.error = data[7] == 1;
        if (!this.error) {
            this.value = data[6] == 1;
        }
    }

    @Override
    public String getContents() {
        Assert.verify((boolean)(this.isError() ^ true));
        return new Boolean(this.value).toString();
    }

    @Override
    public Record getRecord() {
        return super.getRecord();
    }

    @Override
    public CellType getType() {
        return CellType.BOOLEAN;
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean isError() {
        return this.error;
    }
}

