/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import csvorexcel.controllers.jxlAquasys.Record;
import csvorexcel.controllers.jxlAquasys.RecordData;
import java.io.UnsupportedEncodingException;
import jxl.biff.IntegerHelper;

class BoundsheetRecord
extends RecordData {
    private int offset;
    private byte typeFlag;
    private byte visibilityFlag;
    private int length;
    private String name;
    public static Biff7 biff7 = new Biff7();

    public BoundsheetRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.offset = IntegerHelper.getInt((byte)data[0], (byte)data[1], (byte)data[2], (byte)data[3]);
        this.typeFlag = data[4];
        this.visibilityFlag = data[5];
        this.length = data[6];
        if (data[7] == 0) {
            byte[] bytes = new byte[this.length];
            System.arraycopy(data, 8, bytes, 0, this.length);
            this.name = new String(bytes);
        } else {
            byte[] bytes = new byte[this.length * 2];
            System.arraycopy(data, 8, bytes, 0, this.length * 2);
            try {
                this.name = new String(bytes, "UnicodeLittle");
            }
            catch (UnsupportedEncodingException var4) {
                this.name = "Error";
            }
        }
    }

    public BoundsheetRecord(Record t, Biff7 biff7) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.offset = IntegerHelper.getInt((byte)data[0], (byte)data[1], (byte)data[2], (byte)data[3]);
        this.typeFlag = data[4];
        this.visibilityFlag = data[5];
        this.length = data[6];
        byte[] bytes = new byte[this.length];
        System.arraycopy(data, 7, bytes, 0, this.length);
        this.name = new String(bytes);
    }

    public String getName() {
        return this.name;
    }

    public boolean isHidden() {
        return this.visibilityFlag != 0;
    }

    private static class Biff7 {
        Biff7() {
        }
    }
}

