/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.Record;
import csvorexcel.controllers.jxlAquasys.RecordData;
import csvorexcel.controllers.jxlAquasys.XFRecord;
import jxl.Cell;
import jxl.CellType;
import jxl.biff.IntegerHelper;
import jxl.format.CellFormat;

public abstract class CellValue
extends RecordData
implements Cell {
    private int row;
    private int column;
    private int xfIndex;
    private FormattingRecords formattingRecords;
    private boolean initialized;
    private XFRecord format;

    protected CellValue(Record t, FormattingRecords fr) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.row = IntegerHelper.getInt((byte)data[0], (byte)data[1]);
        this.column = IntegerHelper.getInt((byte)data[2], (byte)data[3]);
        this.xfIndex = IntegerHelper.getInt((byte)data[4], (byte)data[5]);
        this.formattingRecords = fr;
        this.initialized = false;
    }

    public CellFormat getCellFormat() {
        if (!this.initialized) {
            this.format = this.formattingRecords.getXFRecord(this.xfIndex);
            this.initialized = true;
        }
        return this.format;
    }

    public final int getColumn() {
        return this.column;
    }

    public abstract String getContents();

    public final int getRow() {
        return this.row;
    }

    public abstract CellType getType();

    public final int getXFIndex() {
        return this.xfIndex;
    }
}

