/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import csvorexcel.controllers.jxlAquasys.Record;
import csvorexcel.controllers.jxlAquasys.RecordData;
import jxl.biff.IntegerHelper;

class DimensionRecord
extends RecordData {
    private int numRows;
    private int numCols;
    public static Biff7 biff7 = new Biff7();

    public DimensionRecord(Record t) {
        super(t);
        byte[] data = t.getData();
        if (data.length == 10) {
            this.read10ByteData(data);
        } else {
            this.read14ByteData(data);
        }
    }

    public DimensionRecord(Record t, Biff7 biff7) {
        super(t);
        byte[] data = t.getData();
        this.read10ByteData(data);
    }

    public int getNumberOfColumns() {
        return this.numCols;
    }

    public int getNumberOfRows() {
        return this.numRows;
    }

    private void read10ByteData(byte[] data) {
        this.numRows = IntegerHelper.getInt((byte)data[2], (byte)data[3]);
        this.numCols = IntegerHelper.getInt((byte)data[6], (byte)data[7]);
    }

    private void read14ByteData(byte[] data) {
        this.numRows = IntegerHelper.getInt((byte)data[4], (byte)data[5], (byte)data[6], (byte)data[7]);
        this.numCols = IntegerHelper.getInt((byte)data[10], (byte)data[11]);
    }

    private static class Biff7 {
        Biff7() {
        }
    }
}

