/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import common.Assert;
import csvorexcel.controllers.jxlAquasys.CellValue;
import csvorexcel.controllers.jxlAquasys.ErrorCell;
import csvorexcel.controllers.jxlAquasys.ErrorFormulaCell;
import csvorexcel.controllers.jxlAquasys.ExternalSheet;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.FormulaData;
import csvorexcel.controllers.jxlAquasys.FormulaException;
import csvorexcel.controllers.jxlAquasys.FormulaParser;
import csvorexcel.controllers.jxlAquasys.Record;
import jxl.CellType;

class ErrorFormulaRecord
extends CellValue
implements ErrorCell,
FormulaData,
ErrorFormulaCell {
    private int errorCode;
    private ExternalSheet externalSheet;
    private String formulaString;
    private byte[] data;

    public ErrorFormulaRecord(Record t, FormattingRecords fr, ExternalSheet es) {
        super(t, fr);
        this.externalSheet = es;
        this.data = this.getRecord().getData();
        Assert.verify((this.data[6] == 2 ? 1 : 0) != 0);
        this.errorCode = this.data[8];
    }

    @Override
    public String getContents() {
        return "ERROR " + this.errorCode;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getFormula() throws FormulaException {
        if (this.formulaString == null) {
            byte[] tokens = new byte[this.data.length - 22];
            System.arraycopy(this.data, 22, tokens, 0, tokens.length);
            FormulaParser fp = new FormulaParser(tokens, this, this.externalSheet);
            fp.parse();
            this.formulaString = fp.getFormula();
        }
        return this.formulaString;
    }

    @Override
    public byte[] getFormulaData() {
        return this.data;
    }

    @Override
    public CellType getType() {
        return CellType.FORMULA_ERROR;
    }
}

