/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import csvorexcel.controllers.jxlAquasys.Record;
import csvorexcel.controllers.jxlAquasys.RecordData;
import jxl.biff.IntegerHelper;

public class ExternalSheetRecord
extends RecordData {
    public static Biff7 biff7 = new Biff7();
    private XTI[] xtiArray;

    ExternalSheetRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        int numxtis = IntegerHelper.getInt((byte)data[0], (byte)data[1]);
        this.xtiArray = new XTI[numxtis];
        int pos = 2;
        for (int i = 0; i < numxtis; ++i) {
            int s = IntegerHelper.getInt((byte)data[pos], (byte)data[pos + 1]);
            int f = IntegerHelper.getInt((byte)data[pos + 2], (byte)data[pos + 3]);
            int l = IntegerHelper.getInt((byte)data[pos + 4], (byte)data[pos + 5]);
            this.xtiArray[i] = new XTI(s, f, l);
            pos += 6;
        }
    }

    ExternalSheetRecord(Record t, Biff7 dummy) {
        super(t);
    }

    public byte[] getData() {
        return this.getRecord().getData();
    }

    int getFirstTabIndex(int index) {
        return this.xtiArray[index].firstTab;
    }

    int getLastTabIndex(int index) {
        return this.xtiArray[index].lastTab;
    }

    int getSupbookIndex(int index) {
        return this.xtiArray[index].supbookIndex;
    }

    private static class XTI {
        int supbookIndex;
        int firstTab;
        int lastTab;

        XTI(int s, int f, int l) {
            this.supbookIndex = s;
            this.firstTab = f;
            this.lastTab = l;
        }
    }

    private static class Biff7 {
        Biff7() {
        }
    }
}

