/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import csvorexcel.controllers.jxlAquasys.BuiltInStyle;
import csvorexcel.controllers.jxlAquasys.File;
import csvorexcel.controllers.jxlAquasys.FormatRecord;
import csvorexcel.controllers.jxlAquasys.WritableRecordData;
import csvorexcel.controllers.jxlAquasys.XFRecord;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.biff.DisplayFormat;
import jxl.biff.Fonts;
import jxl.biff.NumFormatRecordsException;

public class FormattingRecords {
    private HashMap formats = new HashMap(10);
    private ArrayList formatsList = new ArrayList(10);
    private ArrayList xfRecords = new ArrayList(10);
    private int nextCustomIndexNumber;
    private Fonts fonts;
    private static final int customFormatStartIndex = 164;
    private static final int maxFormatRecordsIndex = 441;

    public FormattingRecords(Fonts f) {
        this.fonts = f;
        this.nextCustomIndexNumber = 164;
    }

    public final void addFormat(DisplayFormat fr) throws NumFormatRecordsException {
        if (!fr.isInitialized()) {
            fr.initialize(this.nextCustomIndexNumber);
            ++this.nextCustomIndexNumber;
        }
        if (this.nextCustomIndexNumber > 441) {
            this.nextCustomIndexNumber = 441;
            throw new NumFormatRecordsException();
        }
        if (fr.getFormatIndex() >= this.nextCustomIndexNumber) {
            this.nextCustomIndexNumber = fr.getFormatIndex() + 1;
        }
        if (!fr.isBuiltIn()) {
            this.formatsList.add(fr);
            this.formats.put(new Integer(fr.getFormatIndex()), fr);
        }
    }

    public final void addStyle(XFRecord xf) throws NumFormatRecordsException {
        if (!xf.isInitialized()) {
            int pos = this.xfRecords.size();
            xf.initialize(pos, this, this.fonts);
            this.xfRecords.add(xf);
        } else if (xf.getXFIndex() >= this.xfRecords.size()) {
            this.xfRecords.add(xf);
        }
    }

    public final DateFormat getDateFormat(int pos) {
        XFRecord xfr = (XFRecord)this.xfRecords.get(pos);
        if (xfr.isDate()) {
            return xfr.getDateFormat();
        }
        jxl.biff.FormatRecord fr = (jxl.biff.FormatRecord)this.formats.get(new Integer(xfr.getFormatRecord()));
        if (fr == null) {
            return null;
        }
        return fr.isDate() ? fr.getDateFormat() : null;
    }

    protected final Fonts getFonts() {
        return this.fonts;
    }

    FormatRecord getFormatRecord(int index) {
        return (FormatRecord)this.formats.get(new Integer(index));
    }

    public final NumberFormat getNumberFormat(int pos) {
        if (this.xfRecords.size() == 0) {
            return null;
        }
        XFRecord xfr = (XFRecord)this.xfRecords.get(pos);
        if (xfr.isNumber()) {
            return xfr.getNumberFormat();
        }
        FormatRecord fr = (FormatRecord)this.formats.get(new Integer(xfr.getFormatRecord()));
        if (fr == null) {
            return null;
        }
        return fr.isNumber() ? fr.getNumberFormat() : null;
    }

    protected final int getNumberOfFormatRecords() {
        return this.formatsList.size();
    }

    public final XFRecord getXFRecord(int index) {
        return (XFRecord)this.xfRecords.get(index);
    }

    public final boolean isDate(int pos) {
        if (this == null || this.xfRecords == null || this.xfRecords.size() < 1) {
            return false;
        }
        XFRecord xfr = (XFRecord)this.xfRecords.get(pos);
        if (xfr.isDate()) {
            return true;
        }
        if (this.formats == null) {
            return false;
        }
        if (xfr == null) {
            return false;
        }
        FormatRecord fr = (FormatRecord)this.formats.get(new Integer(xfr.getFormatRecord()));
        return fr == null ? false : fr.isDate();
    }

    public void write(File outputFile) throws IOException {
        Iterator i = this.formatsList.iterator();
        WritableRecordData fr = null;
        while (i.hasNext()) {
            fr = (WritableRecordData)i.next();
            outputFile.write(fr);
        }
        i = this.xfRecords.iterator();
        WritableRecordData xfr = null;
        while (i.hasNext()) {
            xfr = (WritableRecordData)i.next();
            outputFile.write(xfr);
        }
        BuiltInStyle style = new BuiltInStyle(16, 3);
        outputFile.write(style);
        style = new BuiltInStyle(17, 6);
        outputFile.write(style);
        style = new BuiltInStyle(18, 4);
        outputFile.write(style);
        style = new BuiltInStyle(19, 7);
        outputFile.write(style);
        style = new BuiltInStyle(0, 0);
        outputFile.write(style);
        style = new BuiltInStyle(20, 5);
        outputFile.write(style);
    }
}

