/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import common.Assert;
import csvorexcel.controllers.jxlAquasys.BooleanFormulaRecord;
import csvorexcel.controllers.jxlAquasys.CellValue;
import csvorexcel.controllers.jxlAquasys.ErrorFormulaRecord;
import csvorexcel.controllers.jxlAquasys.ExternalSheet;
import csvorexcel.controllers.jxlAquasys.File;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.NumberFormulaRecord;
import csvorexcel.controllers.jxlAquasys.Record;
import csvorexcel.controllers.jxlAquasys.SharedNumberFormulaRecord;
import csvorexcel.controllers.jxlAquasys.SharedStringFormulaRecord;
import csvorexcel.controllers.jxlAquasys.StringFormulaRecord;
import jxl.CellType;
import jxl.biff.DoubleHelper;
import jxl.biff.IntegerHelper;

class FormulaRecord
extends CellValue {
    private CellValue formula;
    private boolean shared;

    public FormulaRecord(Record t, File excelFile, FormattingRecords fr, ExternalSheet es) {
        super(t, fr);
        byte[] data = this.getRecord().getData();
        this.shared = false;
        int grbit = 0;
        if (data.length > 14) {
            grbit = IntegerHelper.getInt((byte)data[14], (byte)data[15]);
        }
        if ((grbit & 8) != 0) {
            this.shared = true;
            if (data[6] == 0 && data[12] == -1 && data[13] == -1) {
                this.formula = new SharedStringFormulaRecord(t, excelFile, fr, es);
            } else {
                double value = DoubleHelper.getIEEEDouble((byte[])data, (int)6);
                this.formula = new SharedNumberFormulaRecord(t, value, fr, es);
            }
        } else {
            this.formula = data[6] == 0 && data[12] == -1 && data[13] == -1 ? new StringFormulaRecord(t, excelFile, fr, es) : (data[6] == 1 && data[12] == -1 && data[13] == -1 ? new BooleanFormulaRecord(t, fr, es) : (data[6] == 2 && data[12] == -1 && data[13] == -1 ? new ErrorFormulaRecord(t, fr, es) : new NumberFormulaRecord(t, fr, es)));
        }
    }

    @Override
    public String getContents() {
        Assert.verify((boolean)false);
        return "";
    }

    final CellValue getFormula() {
        return this.formula;
    }

    @Override
    public CellType getType() {
        Assert.verify((boolean)false);
        return CellType.EMPTY;
    }

    final boolean isShared() {
        return this.shared;
    }
}

