/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import csvorexcel.controllers.jxlAquasys.Record;
import csvorexcel.controllers.jxlAquasys.RecordData;
import jxl.biff.IntegerHelper;

class MulRKRecord
extends RecordData {
    private int row;
    private int colFirst;
    private int colLast;
    private int numrks;
    private int[] rknumbers;
    private int[] xfIndices;

    public MulRKRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        int length = this.getRecord().getLength();
        this.row = IntegerHelper.getInt((byte)data[0], (byte)data[1]);
        this.colFirst = IntegerHelper.getInt((byte)data[2], (byte)data[3]);
        this.colLast = IntegerHelper.getInt((byte)data[length - 2], (byte)data[length - 1]);
        this.numrks = this.colLast - this.colFirst + 1;
        this.rknumbers = new int[this.numrks];
        this.xfIndices = new int[this.numrks];
        this.readRks(data);
    }

    public int getFirstColumn() {
        return this.colFirst;
    }

    public int getNumberOfColumns() {
        return this.numrks;
    }

    public int getRKNumber(int index) {
        return this.rknumbers[index];
    }

    public int getRow() {
        return this.row;
    }

    public int getXFIndex(int index) {
        return this.xfIndices[index];
    }

    private void readRks(byte[] data) {
        int pos = 4;
        for (int i = 0; i < this.numrks; ++i) {
            int rk;
            this.xfIndices[i] = IntegerHelper.getInt((byte)data[pos], (byte)data[pos + 1]);
            this.rknumbers[i] = rk = IntegerHelper.getInt((byte)data[pos + 2], (byte)data[pos + 3], (byte)data[pos + 4], (byte)data[pos + 5]);
            pos += 6;
        }
    }
}

