/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import common.Assert;
import csvorexcel.controllers.jxlAquasys.Record;
import csvorexcel.controllers.jxlAquasys.RecordData;
import java.util.ArrayList;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;

class NameRecord
extends RecordData {
    private String name;
    public static Biff7 biff7 = new Biff7();
    private static final int cellReference = 58;
    private static final int areaReference = 59;
    private static final int subExpression = 41;
    private static final int union = 16;
    private ArrayList ranges;

    public NameRecord(Record t) {
        super(t);
        try {
            int pos;
            this.ranges = new ArrayList();
            byte[] data = this.getRecord().getData();
            byte length = data[3];
            this.name = StringHelper.getString((byte[])data, (int)length, (int)15);
            if (data[pos] == 58) {
                int sheet1 = IntegerHelper.getInt((byte)data[pos + 1], (byte)data[pos + 2]);
                int row = IntegerHelper.getInt((byte)data[pos + 3], (byte)data[pos + 4]);
                int r1 = IntegerHelper.getInt((byte)data[pos + 5], (byte)data[pos + 6]);
                int columnMask = r1 & 0xFF;
                Assert.verify(((r1 & 0xC0000) == 0 ? 1 : 0) != 0);
                NameRange r = new NameRange(this, sheet1, columnMask, row, sheet1, columnMask, row);
                this.ranges.add(r);
            } else if (data[pos] == 59) {
                int sheet1 = 0;
                boolean sheet2 = false;
                int r1 = 0;
                int columnMask = 0;
                int c1 = 0;
                int r2 = 0;
                int c2 = 0;
                NameRange range = null;
                for (pos = length + 15; pos < data.length; pos += 11) {
                    sheet1 = IntegerHelper.getInt((byte)data[pos + 1], (byte)data[pos + 2]);
                    r1 = IntegerHelper.getInt((byte)data[pos + 3], (byte)data[pos + 4]);
                    r2 = IntegerHelper.getInt((byte)data[pos + 5], (byte)data[pos + 6]);
                    columnMask = IntegerHelper.getInt((byte)data[pos + 7], (byte)data[pos + 8]);
                    c1 = columnMask & 0xFF;
                    Assert.verify(((columnMask & 0xC0000) == 0 ? 1 : 0) != 0);
                    columnMask = IntegerHelper.getInt((byte)data[pos + 9], (byte)data[pos + 10]);
                    c2 = columnMask & 0xFF;
                    Assert.verify(((columnMask & 0xC0000) == 0 ? 1 : 0) != 0);
                    range = new NameRange(this, sheet1, c1, r1, sheet1, c2, r2);
                    this.ranges.add(range);
                }
            } else if (data[pos] == 41) {
                int sheet1 = 0;
                boolean sheet2 = false;
                int r1 = 0;
                int columnMask = 0;
                int c1 = 0;
                int r2 = 0;
                int c2 = 0;
                NameRange range = null;
                if (pos < data.length && data[pos] != 58 && data[pos] != 59) {
                    if (data[pos] == 41) {
                        pos += 3;
                    } else if (data[pos] == 16) {
                        ++pos;
                    }
                }
                while (pos < data.length) {
                    sheet1 = IntegerHelper.getInt((byte)data[pos + 1], (byte)data[pos + 2]);
                    r1 = IntegerHelper.getInt((byte)data[pos + 3], (byte)data[pos + 4]);
                    r2 = IntegerHelper.getInt((byte)data[pos + 5], (byte)data[pos + 6]);
                    columnMask = IntegerHelper.getInt((byte)data[pos + 7], (byte)data[pos + 8]);
                    c1 = columnMask & 0xFF;
                    Assert.verify(((columnMask & 0xC0000) == 0 ? 1 : 0) != 0);
                    columnMask = IntegerHelper.getInt((byte)data[pos + 9], (byte)data[pos + 10]);
                    c2 = columnMask & 0xFF;
                    Assert.verify(((columnMask & 0xC0000) == 0 ? 1 : 0) != 0);
                    range = new NameRange(this, sheet1, c1, r1, sheet1, c2, r2);
                    this.ranges.add(range);
                    if ((pos += 11) >= data.length || data[pos] == 58 || data[pos] == 59) continue;
                    if (data[pos] == 41) {
                        pos += 3;
                        continue;
                    }
                    if (data[pos] != 16) continue;
                    ++pos;
                }
            }
        }
        catch (Throwable var13) {
            System.err.println("WARNING:  cannot read name");
            this.name = "ERROR";
        }
    }

    public NameRecord(Record t, Biff7 dummy) {
        super(t);
        try {
            int pos;
            this.ranges = new ArrayList();
            byte[] data = this.getRecord().getData();
            byte length = data[3];
            this.name = StringHelper.getString((byte[])data, (int)length, (int)14);
            if (data[pos] == 58) {
                int sheet1 = IntegerHelper.getInt((byte)data[pos + 11], (byte)data[pos + 12]);
                int sheet2 = IntegerHelper.getInt((byte)data[pos + 15], (byte)data[pos + 16]);
                byte column = data[pos + 17];
                NameRange r = new NameRange(this, sheet1, column, sheet2, sheet1, column, sheet2);
                this.ranges.add(r);
            } else if (data[pos] == 59) {
                int sheet1 = 0;
                int sheet2 = 0;
                int r1 = 0;
                boolean columnMask = false;
                byte c1 = 0;
                int r2 = 0;
                byte c2 = 0;
                NameRange range = null;
                for (pos = length + 14; pos < data.length; pos += 21) {
                    sheet1 = IntegerHelper.getInt((byte)data[pos + 11], (byte)data[pos + 12]);
                    sheet2 = IntegerHelper.getInt((byte)data[pos + 13], (byte)data[pos + 14]);
                    r1 = IntegerHelper.getInt((byte)data[pos + 15], (byte)data[pos + 16]);
                    r2 = IntegerHelper.getInt((byte)data[pos + 17], (byte)data[pos + 18]);
                    c1 = data[pos + 19];
                    c2 = data[pos + 20];
                    range = new NameRange(this, sheet1, c1, r1, sheet1, c2, r2);
                    this.ranges.add(range);
                }
            } else if (data[pos] == 41) {
                int sheet1 = 0;
                int sheet2 = 0;
                int r1 = 0;
                boolean columnMask = false;
                byte c1 = 0;
                int r2 = 0;
                byte c2 = 0;
                NameRange range = null;
                if (pos < data.length && data[pos] != 58 && data[pos] != 59) {
                    if (data[pos] == 41) {
                        pos += 3;
                    } else if (data[pos] == 16) {
                        ++pos;
                    }
                }
                while (pos < data.length) {
                    sheet1 = IntegerHelper.getInt((byte)data[pos + 11], (byte)data[pos + 12]);
                    sheet2 = IntegerHelper.getInt((byte)data[pos + 13], (byte)data[pos + 14]);
                    r1 = IntegerHelper.getInt((byte)data[pos + 15], (byte)data[pos + 16]);
                    r2 = IntegerHelper.getInt((byte)data[pos + 17], (byte)data[pos + 18]);
                    c1 = data[pos + 19];
                    c2 = data[pos + 20];
                    range = new NameRange(this, sheet1, c1, r1, sheet1, c2, r2);
                    this.ranges.add(range);
                    if ((pos += 21) >= data.length || data[pos] == 58 || data[pos] == 59) continue;
                    if (data[pos] == 41) {
                        pos += 3;
                        continue;
                    }
                    if (data[pos] != 16) continue;
                    ++pos;
                }
            }
        }
        catch (Throwable var14) {
            System.err.println("WARNING:  cannot read name");
            this.name = "ERROR";
        }
    }

    String getName() {
        return this.name;
    }

    NameRange[] getRanges() {
        Object[] o = this.ranges.toArray();
        NameRange[] nr = new NameRange[o.length];
        for (int i = 0; i < o.length; ++i) {
            nr[i] = (NameRange)o[i];
        }
        return nr;
    }

    class NameRange {
        private int columnFirst;
        private int rowFirst;
        private int columnLast;
        private int rowLast;
        private int sheetFirst;
        private int sheetLast;

        NameRange(NameRecord this$0, int s1, int c1, int r1, int s2, int c2, int r2) {
            this.columnFirst = c1;
            this.rowFirst = r1;
            this.columnLast = c2;
            this.rowLast = r2;
            this.sheetFirst = s1;
            this.sheetLast = s2;
        }

        int getFirstColumn() {
            return this.columnFirst;
        }

        int getFirstRow() {
            return this.rowFirst;
        }

        int getFirstSheet() {
            return this.sheetFirst;
        }

        int getLastColumn() {
            return this.columnLast;
        }

        int getLastRow() {
            return this.rowLast;
        }

        int getLastSheet() {
            return this.sheetLast;
        }
    }

    private static class Biff7 {
        Biff7() {
        }
    }
}

