/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import csvorexcel.controllers.jxlAquasys.CellValue;
import csvorexcel.controllers.jxlAquasys.ExternalSheet;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.FormulaData;
import csvorexcel.controllers.jxlAquasys.FormulaException;
import csvorexcel.controllers.jxlAquasys.FormulaParser;
import csvorexcel.controllers.jxlAquasys.Record;
import java.text.DecimalFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.biff.IntegerHelper;

class NumberFormulaRecord
extends CellValue
implements NumberCell,
FormulaData {
    private double value;
    private static DecimalFormat format = new DecimalFormat("#.###");
    private String formulaString;
    private ExternalSheet externalSheet;
    private byte[] data;

    public NumberFormulaRecord(Record t, FormattingRecords fr, ExternalSheet es) {
        super(t, fr);
        this.externalSheet = es;
        this.data = this.getRecord().getData();
        int num1 = IntegerHelper.getInt((byte)this.data[6], (byte)this.data[7], (byte)this.data[8], (byte)this.data[9]);
        int num2 = IntegerHelper.getInt((byte)this.data[10], (byte)this.data[11], (byte)this.data[12], (byte)this.data[13]);
        Object s1 = Integer.toBinaryString(num1);
        while (((String)s1).length() < 32) {
            s1 = "0" + (String)s1;
        }
        boolean negative = (num2 & Integer.MIN_VALUE) != 0;
        String s = Integer.toBinaryString(num2 & Integer.MAX_VALUE) + (String)s1;
        long val = Long.parseLong(s, 2);
        this.value = Double.longBitsToDouble(val);
        if (negative) {
            this.value = -this.value;
        }
    }

    @Override
    public String getContents() {
        return format.format(this.value);
    }

    public String getFormula() throws FormulaException {
        if (this.formulaString == null) {
            byte[] tokens = new byte[this.data.length - 22];
            System.arraycopy(this.data, 22, tokens, 0, tokens.length);
            FormulaParser fp = new FormulaParser(tokens, this, this.externalSheet);
            fp.parse();
            this.formulaString = fp.getFormula();
        }
        return this.formulaString;
    }

    @Override
    public byte[] getFormulaData() {
        return this.data;
    }

    @Override
    public CellType getType() {
        return CellType.NUMBER_FORMULA;
    }

    public double getValue() {
        return this.value;
    }
}

