/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import csvorexcel.controllers.jxlAquasys.CellValue;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.Record;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.biff.IntegerHelper;

class NumberRecord
extends CellValue
implements NumberCell {
    private double value;
    private NumberFormat format;
    private static DecimalFormat defaultFormat = new DecimalFormat("#.###");

    public NumberRecord(Record t, FormattingRecords fr) {
        super(t, fr);
        byte[] data = this.getRecord().getData();
        int num1 = IntegerHelper.getInt((byte)data[6], (byte)data[7], (byte)data[8], (byte)data[9]);
        int num2 = IntegerHelper.getInt((byte)data[10], (byte)data[11], (byte)data[12], (byte)data[13]);
        Object s1 = Integer.toBinaryString(num1);
        while (((String)s1).length() < 32) {
            s1 = "0" + (String)s1;
        }
        boolean negative = (num2 & Integer.MIN_VALUE) != 0;
        String s = Integer.toBinaryString(num2 & Integer.MAX_VALUE) + (String)s1;
        long val = Long.parseLong(s, 2);
        this.value = Double.longBitsToDouble(val);
        if (negative) {
            this.value = -this.value;
        }
        this.format = fr.getNumberFormat(this.getXFIndex());
        if (this.format == null) {
            this.format = defaultFormat;
        }
    }

    @Override
    public String getContents() {
        return this.format.format(this.value);
    }

    @Override
    public CellType getType() {
        return CellType.NUMBER;
    }

    public double getValue() {
        return this.value;
    }
}

