/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import csvorexcel.controllers.jxlAquasys.CellValue;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.RKHelper;
import csvorexcel.controllers.jxlAquasys.Record;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.biff.IntegerHelper;

class RKRecord
extends CellValue
implements NumberCell {
    private double value;
    private NumberFormat format;
    private static DecimalFormat defaultFormat = new DecimalFormat("#.###");

    public RKRecord(Record t, FormattingRecords fr) {
        super(t, fr);
        byte[] data = this.getRecord().getData();
        int rknum = IntegerHelper.getInt((byte)data[6], (byte)data[7], (byte)data[8], (byte)data[9]);
        this.value = RKHelper.getDouble(rknum);
        this.format = fr.getNumberFormat(this.getXFIndex());
        if (this.format == null) {
            this.format = defaultFormat;
        }
    }

    @Override
    public String getContents() {
        return this.format.format(this.value);
    }

    @Override
    public CellType getType() {
        return CellType.NUMBER;
    }

    public double getValue() {
        return this.value;
    }
}

