/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import csvorexcel.controllers.jxlAquasys.BaseSharedFormulaRecord;
import csvorexcel.controllers.jxlAquasys.ExternalSheet;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.FormulaData;
import csvorexcel.controllers.jxlAquasys.FormulaException;
import csvorexcel.controllers.jxlAquasys.FormulaParser;
import csvorexcel.controllers.jxlAquasys.Record;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.biff.DoubleHelper;
import jxl.biff.IntegerHelper;

public class SharedNumberFormulaRecord
extends BaseSharedFormulaRecord
implements NumberCell,
FormulaData {
    private double value;
    private NumberFormat format;
    private FormattingRecords formattingRecords;
    private static DecimalFormat defaultFormat = new DecimalFormat("#.###");

    public SharedNumberFormulaRecord(Record t, double v, FormattingRecords fr, ExternalSheet es) {
        super(t, fr, es);
        this.value = v;
        this.format = defaultFormat;
    }

    @Override
    public String getContents() {
        return this.format.format(this.value);
    }

    @Override
    public byte[] getFormulaData() throws FormulaException {
        FormulaParser fp = new FormulaParser(this.getTokens(), this, this.getExternalSheet());
        fp.parse();
        byte[] rpnTokens = fp.getBytes();
        byte[] data = new byte[rpnTokens.length + 22];
        IntegerHelper.getTwoBytes((int)this.getRow(), (byte[])data, (int)0);
        IntegerHelper.getTwoBytes((int)this.getColumn(), (byte[])data, (int)2);
        IntegerHelper.getTwoBytes((int)this.getXFIndex(), (byte[])data, (int)4);
        DoubleHelper.getIEEEBytes((double)this.value, (byte[])data, (int)6);
        System.arraycopy(rpnTokens, 0, data, 22, rpnTokens.length);
        IntegerHelper.getTwoBytes((int)rpnTokens.length, (byte[])data, (int)20);
        return data;
    }

    @Override
    public CellType getType() {
        return CellType.NUMBER_FORMULA;
    }

    public double getValue() {
        return this.value;
    }

    final void setNumberFormat(NumberFormat f) {
        if (f != null) {
            this.format = f;
        }
    }
}

