/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import common.Assert;
import csvorexcel.controllers.jxlAquasys.BaseSharedFormulaRecord;
import csvorexcel.controllers.jxlAquasys.ExternalSheet;
import csvorexcel.controllers.jxlAquasys.File;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.FormulaData;
import csvorexcel.controllers.jxlAquasys.FormulaException;
import csvorexcel.controllers.jxlAquasys.FormulaParser;
import csvorexcel.controllers.jxlAquasys.Record;
import jxl.CellType;
import jxl.LabelCell;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;

public class SharedStringFormulaRecord
extends BaseSharedFormulaRecord
implements LabelCell,
FormulaData {
    private String value;
    private FormattingRecords formattingRecords;

    public SharedStringFormulaRecord(Record t, File excelFile, FormattingRecords fr, ExternalSheet es) {
        super(t, fr, es);
        int count;
        int pos = excelFile.getPos();
        int filepos = excelFile.getPos();
        Record nextRecord = excelFile.next();
        for (count = 0; nextRecord.getType() != Type.STRING && count < 4; ++count) {
            nextRecord = excelFile.next();
        }
        Assert.verify((count < 4 ? 1 : 0) != 0, (String)(" @ " + pos));
        byte[] stringData = nextRecord.getData();
        int chars = IntegerHelper.getInt((byte)stringData[0], (byte)stringData[1]);
        this.value = (stringData[2] & 1) == 0 ? StringHelper.getString((byte[])stringData, (int)chars, (int)3) : StringHelper.getUnicodeString((byte[])stringData, (int)chars, (int)3);
        excelFile.setPos(filepos);
    }

    @Override
    public String getContents() {
        return this.value;
    }

    @Override
    public byte[] getFormulaData() throws FormulaException {
        FormulaParser fp = new FormulaParser(this.getTokens(), this, this.getExternalSheet());
        fp.parse();
        byte[] rpnTokens = fp.getBytes();
        byte[] data = new byte[rpnTokens.length + 22];
        IntegerHelper.getTwoBytes((int)this.getRow(), (byte[])data, (int)0);
        IntegerHelper.getTwoBytes((int)this.getColumn(), (byte[])data, (int)2);
        IntegerHelper.getTwoBytes((int)this.getXFIndex(), (byte[])data, (int)4);
        data[6] = 0;
        data[12] = -1;
        data[13] = -1;
        System.arraycopy(rpnTokens, 0, data, 22, rpnTokens.length);
        IntegerHelper.getTwoBytes((int)rpnTokens.length, (byte[])data, (int)20);
        return data;
    }

    public String getString() {
        return this.value;
    }

    @Override
    public CellType getType() {
        return CellType.STRING_FORMULA;
    }
}

