/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import common.Assert;
import csvorexcel.controllers.jxlAquasys.BOFRecord;
import csvorexcel.controllers.jxlAquasys.BaseSharedFormulaRecord;
import csvorexcel.controllers.jxlAquasys.BiffException;
import csvorexcel.controllers.jxlAquasys.BlankCell;
import csvorexcel.controllers.jxlAquasys.ColumnInfoRecord;
import csvorexcel.controllers.jxlAquasys.DateRecord;
import csvorexcel.controllers.jxlAquasys.DimensionRecord;
import csvorexcel.controllers.jxlAquasys.File;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.FormulaRecord;
import csvorexcel.controllers.jxlAquasys.LabelRecord;
import csvorexcel.controllers.jxlAquasys.NumberFormulaRecord;
import csvorexcel.controllers.jxlAquasys.NumberRecord;
import csvorexcel.controllers.jxlAquasys.RKRecord;
import csvorexcel.controllers.jxlAquasys.RStringRecord;
import csvorexcel.controllers.jxlAquasys.Record;
import csvorexcel.controllers.jxlAquasys.SSTRecord;
import csvorexcel.controllers.jxlAquasys.SharedFormulaRecord;
import csvorexcel.controllers.jxlAquasys.WorkbookParser;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.LabelCell;
import jxl.Sheet;
import jxl.biff.EmptyCell;
import jxl.biff.Type;

public class SheetImpl
implements Sheet {
    private File excelFile;
    private SSTRecord sharedStrings;
    private BOFRecord sheetBof;
    private BOFRecord workbookBof;
    private FormattingRecords formattingRecords;
    private String name;
    private boolean hidden;
    private int numRows;
    private int numCols;
    private Cell[][] cells;
    private int startPosition;
    private ColumnInfoRecord[] columnInfos;
    private ArrayList columnInfosArray;
    private ArrayList sharedFormulas;
    private boolean columnInfosInitialized;
    private boolean nineteenFour;
    private WorkbookParser workbook;

    SheetImpl(File f, SSTRecord sst, FormattingRecords fr, BOFRecord sb, BOFRecord wb, boolean nf, WorkbookParser wp) throws BiffException {
        this.excelFile = f;
        this.sharedStrings = sst;
        this.formattingRecords = fr;
        this.sheetBof = sb;
        this.workbookBof = wb;
        this.columnInfosArray = new ArrayList();
        this.sharedFormulas = new ArrayList();
        this.columnInfosInitialized = false;
        this.nineteenFour = nf;
        this.workbook = wp;
        this.startPosition = f.getPos();
        Record r = null;
        int bofs = 1;
        while (bofs >= 1) {
            r = f.next();
            if (r.getCode() == Type.EOF.value) {
                --bofs;
            }
            if (r.getCode() != Type.BOF.value) continue;
            ++bofs;
        }
    }

    private void addCell(Cell cell) {
        Assert.verify((this.cells[cell.getRow()][cell.getColumn()] == null ? 1 : 0) != 0);
        this.cells[cell.getRow()][cell.getColumn()] = cell;
    }

    private void addToSharedFormulas(BaseSharedFormulaRecord fr) {
        Iterator i = this.sharedFormulas.iterator();
        boolean added = false;
        SharedFormulaRecord sfr = null;
        while (i.hasNext() && !added) {
            sfr = (SharedFormulaRecord)i.next();
            added = sfr.add(fr);
        }
    }

    public final void clear() {
        this.cells = null;
        System.gc();
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        for (int i = 0; i < this.getRows() && !found; ++i) {
            Cell[] row = this.getRow(i);
            for (int j = 0; j < row.length && !found; ++j) {
                if (!row[j].getContents().equals(contents)) continue;
                cell = row[j];
                found = true;
            }
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        for (int i = 0; i < this.getRows() && !found; ++i) {
            Cell[] row = this.getRow(i);
            for (int j = 0; j < row.length && !found; ++j) {
                if (row[j].getType() != CellType.LABEL && row[j].getType() != CellType.STRING_FORMULA || !row[j].getContents().equals(contents)) continue;
                cell = (LabelCell)row[j];
                found = true;
            }
        }
        return cell;
    }

    public Cell getCell(int column, int row) {
        Cell c;
        if (this.cells == null) {
            this.readSheet();
        }
        if ((c = this.cells[row][column]) == null) {
            c = new EmptyCell(column, row);
            this.addCell(c);
        }
        return c;
    }

    public Cell[] getColumn(int col) {
        if (this.cells == null) {
            this.readSheet();
        }
        boolean found = false;
        int row = this.numRows - 1;
        while (row >= 0 && !found) {
            if (this.cells[row][col] != null) {
                found = true;
                continue;
            }
            --row;
        }
        Cell[] cells = new Cell[row + 1];
        for (int i = 0; i <= row; ++i) {
            cells[i] = this.getCell(col, i);
        }
        return cells;
    }

    public ColumnInfoRecord getColumnInfo(int col) {
        if (!this.columnInfosInitialized) {
            Iterator i = this.columnInfosArray.iterator();
            ColumnInfoRecord cir = null;
            while (i.hasNext()) {
                cir = (ColumnInfoRecord)i.next();
                int startcol = Math.max(0, cir.getStartColumn());
                int endcol = Math.min(this.columnInfos.length - 1, cir.getEndColumn());
                for (int c = startcol; c <= endcol; ++c) {
                    this.columnInfos[c] = cir;
                }
            }
            this.columnInfosInitialized = true;
        }
        return this.columnInfos[col];
    }

    public int getColumns() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numCols;
    }

    public String getName() {
        return this.name;
    }

    public Cell[] getRow(int row) {
        if (this.cells == null) {
            this.readSheet();
        }
        boolean found = false;
        int col = this.numCols - 1;
        while (col >= 0 && !found) {
            if (this.cells[row][col] != null) {
                found = true;
                continue;
            }
            --col;
        }
        Cell[] cells = new Cell[col + 1];
        for (int i = 0; i <= col; ++i) {
            cells[i] = this.getCell(i, row);
        }
        return cells;
    }

    public int getRows() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numRows;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    final void readSheet() {
        block30: {
            try {
                if (!this.sheetBof.isWorksheet()) {
                    System.out.println("ko");
                    this.numRows = 0;
                    this.numCols = 0;
                    this.cells = new Cell[0][0];
                    break block30;
                }
                Record r = null;
                BaseSharedFormulaRecord sharedFormula = null;
                boolean cont = true;
                this.excelFile.setPos(this.startPosition);
                while (cont) {
                    Type var10000;
                    DimensionRecord lr;
                    block31: {
                        DateRecord dc;
                        r = this.excelFile.next();
                        if (r.getType() == Type.DIMENSION) {
                            lr = null;
                            lr = this.workbookBof.isBiff8() ? new DimensionRecord(r) : new DimensionRecord(r, DimensionRecord.biff7);
                            this.numRows = lr.getNumberOfRows();
                            this.numCols = lr.getNumberOfColumns();
                            this.cells = new Cell[this.numRows][this.numCols];
                            this.columnInfos = new ColumnInfoRecord[this.numCols];
                        }
                        if (r.getType() == Type.RK || r.getType() == Type.RK2) {
                            RKRecord rkr = new RKRecord(r, this.formattingRecords);
                            if (this.formattingRecords.isDate(rkr.getXFIndex())) {
                                dc = new DateRecord(rkr, rkr.getXFIndex(), this.formattingRecords, this.nineteenFour);
                                this.addCell((Cell)dc);
                            } else {
                                this.addCell(rkr);
                            }
                        }
                        r.getType();
                        var10000 = Type.ROW;
                        if (r.getType() == Type.NUMBER) {
                            NumberRecord nr = new NumberRecord(r, this.formattingRecords);
                            if (this.formattingRecords != null && this.formattingRecords.isDate(nr.getXFIndex())) {
                                dc = new DateRecord(nr, nr.getXFIndex(), this.formattingRecords, this.nineteenFour);
                                this.addCell((Cell)dc);
                            } else {
                                this.addCell(nr);
                            }
                        }
                        if (r.getType() == Type.FORMULA || r.getType() == Type.FORMULA2) {
                            if (r.getData() == null || r.getData().length > 0) {
                                FormulaRecord fr = new FormulaRecord(r, this.excelFile, this.formattingRecords, this.workbook);
                                if (fr.isShared()) {
                                    sharedFormula = (BaseSharedFormulaRecord)fr.getFormula();
                                    this.addToSharedFormulas(sharedFormula);
                                } else {
                                    Object cell = fr.getFormula();
                                    try {
                                        if (fr.getFormula().getType() == CellType.NUMBER_FORMULA) {
                                            NumberFormulaRecord nfr = (NumberFormulaRecord)fr.getFormula();
                                            if (this.formattingRecords.isDate(nfr.getXFIndex())) {
                                                cell = new DateRecord(nfr, nfr.getXFIndex(), this.formattingRecords, this.nineteenFour);
                                            }
                                            this.addCell((Cell)cell);
                                            break block31;
                                        }
                                        try {
                                            this.addCell((Cell)cell);
                                        }
                                        catch (Exception var9) {
                                            System.out.println(var9.toString());
                                        }
                                    }
                                    catch (Exception var11) {
                                        System.out.println(var11.toString());
                                        this.addCell(fr.getFormula());
                                    }
                                }
                            } else {
                                System.out.println(" col Formula vide ");
                            }
                        }
                    }
                    r.getType();
                    var10000 = Type.CONTINUE;
                    r.getType();
                    var10000 = Type.NOTE;
                    if (r.getType() == Type.SHAREDFORMULA && r.getData().length > 0) {
                        SharedFormulaRecord sfr = new SharedFormulaRecord(r, sharedFormula, this.workbook);
                        this.sharedFormulas.add(sfr);
                    }
                    if (r.getType() == Type.LABEL) {
                        lr = null;
                        LabelRecord lrg = this.workbookBof.isBiff8() ? new LabelRecord(r, this.formattingRecords) : new LabelRecord(r, this.formattingRecords, LabelRecord.biff7);
                        this.addCell(lrg);
                    }
                    if (r.getType() == Type.RSTRING) {
                        lr = null;
                        Assert.verify((boolean)(this.workbookBof.isBiff8() ^ true));
                        RStringRecord lrr = new RStringRecord(r, this.formattingRecords, RStringRecord.biff7);
                        this.addCell(lrr);
                    }
                    r.getType();
                    var10000 = Type.NAME;
                    if (r.getType() == Type.BLANK) {
                        BlankCell bc = new BlankCell(r, this.formattingRecords);
                        this.addCell(bc);
                    }
                    r.getType();
                    var10000 = Type.OBJ;
                    r.getType();
                    var10000 = Type.MSODRAWING;
                    if (r.getType() == Type.BOF) {
                        BOFRecord br = new BOFRecord(r);
                        Assert.verify((boolean)(br.isWorksheet() ^ true));
                        int startpos = this.excelFile.getPos() - r.getLength() - 4;
                        Record r2 = this.excelFile.next();
                        while (r2.getCode() != Type.EOF.value) {
                            r2 = this.excelFile.next();
                        }
                    }
                    if (r.getType() != Type.EOF) continue;
                    cont = false;
                }
                this.excelFile.restorePos();
                for (SharedFormulaRecord sfr : this.sharedFormulas) {
                    Cell[] sfnr = sfr.getFormulas(this.formattingRecords);
                    for (int i = 0; i < sfnr.length; ++i) {
                        this.addCell(sfnr[i]);
                    }
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    final void setHidden(boolean h) {
        this.hidden = h;
    }

    final void setName(String s) {
        this.name = s;
    }
}

