/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import common.Assert;
import csvorexcel.controllers.jxlAquasys.CellValue;
import csvorexcel.controllers.jxlAquasys.ExternalSheet;
import csvorexcel.controllers.jxlAquasys.File;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.FormulaException;
import csvorexcel.controllers.jxlAquasys.FormulaParser;
import csvorexcel.controllers.jxlAquasys.Record;
import java.io.UnsupportedEncodingException;
import jxl.CellType;
import jxl.LabelCell;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;

class StringFormulaRecord
extends CellValue
implements LabelCell,
FormulaData {
    private String value;
    private ExternalSheet externalSheet;
    private String formulaString;
    private byte[] data;

    public StringFormulaRecord(Record t, File excelFile, FormattingRecords fr, ExternalSheet es) {
        super(t, fr);
        this.externalSheet = es;
        this.data = this.getRecord().getData();
        int pos = excelFile.getPos();
        Record nextRecord = excelFile.next();
        if (nextRecord != null) {
            int count;
            for (count = 0; nextRecord.getType() != Type.STRING && count < 4; ++count) {
                nextRecord = excelFile.next();
            }
            Assert.verify((count < 4 ? 1 : 0) != 0, (String)(" @ " + pos));
            this.readString(nextRecord.getData());
        } else {
            this.readString(this.data);
        }
    }

    @Override
    public String getContents() {
        return this.value;
    }

    public String getFormula() throws FormulaException {
        if (this.formulaString == null) {
            byte[] tokens = new byte[this.data.length - 22];
            System.arraycopy(this.data, 22, tokens, 0, tokens.length);
            FormulaParser fp = new FormulaParser(tokens, this, this.externalSheet);
            fp.parse();
            this.formulaString = fp.getFormula();
        }
        return this.formulaString;
    }

    public byte[] getFormulaData() {
        return this.data;
    }

    public String getString() {
        return this.value;
    }

    @Override
    public CellType getType() {
        return CellType.STRING_FORMULA;
    }

    private void readString(byte[] data) {
        try {
            if (data != null && data.length > 2) {
                boolean richString;
                int pos = 0;
                int chars = IntegerHelper.getInt((byte)data[0], (byte)data[1]);
                byte optionFlags = data[pos += 2];
                ++pos;
                boolean extendedString = (optionFlags & 4) != 0;
                boolean bl = richString = (optionFlags & 8) != 0;
                if (richString) {
                    pos += 2;
                }
                if (extendedString) {
                    pos += 4;
                }
                boolean asciiEncoding = (optionFlags & 1) == 0;
                byte[] bytes = null;
                if (asciiEncoding) {
                    bytes = new byte[chars];
                    System.arraycopy(data, pos - 1, bytes, 0, chars);
                    int var10000 = pos + chars;
                } else {
                    bytes = new byte[chars * 2];
                    System.arraycopy(data, pos - 1, bytes, 0, data.length - pos + 1);
                    int var10000 = pos + bytes.length;
                }
                this.value = asciiEncoding ? new String(bytes) : new String(bytes, "UTF8");
            }
        }
        catch (UnsupportedEncodingException var9) {
            System.err.println(var9.toString());
        }
    }
}

