/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import common.Assert;
import csvorexcel.controllers.jxlAquasys.BOFRecord;
import csvorexcel.controllers.jxlAquasys.BiffException;
import csvorexcel.controllers.jxlAquasys.BoundsheetRecord;
import csvorexcel.controllers.jxlAquasys.ExternalSheet;
import csvorexcel.controllers.jxlAquasys.ExternalSheetRecord;
import csvorexcel.controllers.jxlAquasys.File;
import csvorexcel.controllers.jxlAquasys.FormatRecord;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.NameRecord;
import csvorexcel.controllers.jxlAquasys.NineteenFourRecord;
import csvorexcel.controllers.jxlAquasys.RangeImpl;
import csvorexcel.controllers.jxlAquasys.Record;
import csvorexcel.controllers.jxlAquasys.RecordData;
import csvorexcel.controllers.jxlAquasys.SSTRecord;
import csvorexcel.controllers.jxlAquasys.SheetImpl;
import csvorexcel.controllers.jxlAquasys.Workbook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.Cell;
import jxl.Range;
import jxl.biff.Fonts;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.Type;
import jxl.read.biff.PasswordException;

public class WorkbookParser
extends Workbook
implements ExternalSheet {
    private File excelFile;
    private int bofs;
    private boolean nineteenFour;
    private SSTRecord sharedStrings;
    private ArrayList boundsheets;
    private FormattingRecords formattingRecords;
    private Fonts fonts;
    private ArrayList sheets;
    private SheetImpl lastSheet;
    private int lastSheetIndex;
    private HashMap namedRecords;
    private ExternalSheetRecord externSheet;
    private BOFRecord workbookBof;

    public WorkbookParser(File f) {
        this.excelFile = f;
        this.boundsheets = new ArrayList(10);
        this.fonts = new Fonts();
        this.formattingRecords = new FormattingRecords(this.fonts);
        this.sheets = new ArrayList(10);
        this.namedRecords = new HashMap();
        this.lastSheetIndex = -1;
    }

    final void addSheet(SheetImpl s) {
        this.sheets.add(s);
    }

    @Override
    public void close() {
        if (this.lastSheet != null) {
            this.lastSheet.clear();
        }
        this.excelFile.clear();
        System.gc();
    }

    @Override
    public Range[] findByName(String name) {
        NameRecord nr = (NameRecord)this.namedRecords.get(name);
        if (nr == null) {
            return null;
        }
        NameRecord.NameRange[] ranges = nr.getRanges();
        Range[] cellRanges = new Range[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            cellRanges[i] = new RangeImpl(this, ranges[i].getFirstSheet(), ranges[i].getFirstColumn(), ranges[i].getFirstRow(), ranges[i].getLastSheet(), ranges[i].getLastColumn(), ranges[i].getLastRow());
        }
        return cellRanges;
    }

    @Override
    public Cell findCellByName(String name) {
        NameRecord nr = (NameRecord)this.namedRecords.get(name);
        if (nr == null) {
            return null;
        }
        NameRecord.NameRange[] ranges = nr.getRanges();
        SheetImpl s = this.getSheet(ranges[0].getFirstSheet());
        Cell cell = s.getCell(ranges[0].getFirstColumn(), ranges[0].getFirstRow());
        return cell;
    }

    int getExternalSheetIndex(int index) {
        if (this.workbookBof.isBiff7()) {
            return index;
        }
        Assert.verify((this.externSheet != null ? 1 : 0) != 0);
        int firstTab = this.externSheet.getFirstTabIndex(index);
        int lastTab = this.externSheet.getLastTabIndex(index);
        Assert.verify((firstTab == lastTab ? 1 : 0) != 0);
        return firstTab;
    }

    @Override
    public String getExternalSheetName(int index) {
        if (this.workbookBof.isBiff8()) {
            int lastTab;
            int firstTab = this.externSheet.getFirstTabIndex(index);
            Assert.verify((firstTab == (lastTab = this.externSheet.getLastTabIndex(index)) ? 1 : 0) != 0);
        }
        BoundsheetRecord br = (BoundsheetRecord)this.boundsheets.get(index);
        return br.getName();
    }

    public ExternalSheetRecord getExternalSheetRecord() {
        return this.externSheet;
    }

    public Fonts getFonts() {
        return this.fonts;
    }

    public FormattingRecords getFormattingRecords() {
        return this.formattingRecords;
    }

    @Override
    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    @Override
    public SheetImpl getSheet(int index) {
        if (this.lastSheet != null && this.lastSheetIndex == index) {
            return this.lastSheet;
        }
        if (this.lastSheet != null) {
            this.lastSheet.clear();
            System.gc();
        }
        this.lastSheet = (SheetImpl)this.sheets.get(index);
        this.lastSheetIndex = index;
        this.lastSheet.readSheet();
        return this.lastSheet;
    }

    @Override
    public SheetImpl getSheet(String name) {
        int pos = 0;
        boolean found = false;
        Iterator i = this.boundsheets.iterator();
        BoundsheetRecord br = null;
        while (i.hasNext() && !found) {
            br = (BoundsheetRecord)i.next();
            if (br.getName().equals(name)) {
                found = true;
                continue;
            }
            ++pos;
        }
        return found ? this.getSheet(pos) : null;
    }

    @Override
    public SheetImpl[] getSheets() {
        SheetImpl[] sheetArray = new SheetImpl[this.getNumberOfSheets()];
        for (int i = 0; i < this.getNumberOfSheets(); ++i) {
            sheetArray[i] = (SheetImpl)this.sheets.get(i);
        }
        return sheetArray;
    }

    @Override
    public BOFRecord getWorkbookBof() {
        return this.workbookBof;
    }

    @Override
    protected void parse() throws BiffException, PasswordException {
        BOFRecord bof;
        Record r = null;
        this.workbookBof = bof = new BOFRecord(this.excelFile.next());
        ++this.bofs;
        if (!bof.isBiff8() && !bof.isBiff7()) {
            throw new BiffException(BiffException.unrecognizedBiffVersion);
        }
        if (!bof.isWorkbookGlobals()) {
            throw new BiffException(BiffException.expectedGlobals);
        }
        ArrayList<Record> continueRecords = new ArrayList<Record>();
        while (this.bofs == 1) {
            RecordData nr;
            Record br;
            r = this.excelFile.next();
            if (r.getType() == Type.SST) {
                continueRecords.clear();
                br = this.excelFile.peek();
                while (br.getType() == Type.CONTINUE) {
                    continueRecords.add(this.excelFile.next());
                    br = this.excelFile.peek();
                }
                Object[] rec = continueRecords.toArray();
                Record[] records = new Record[rec.length];
                System.arraycopy(rec, 0, records, 0, rec.length);
                this.sharedStrings = new SSTRecord(r, records);
            }
            if (r.getType() == Type.FILEPASS) {
                throw new PasswordException();
            }
            r.getType();
            Type var10000 = Type.TXO;
            if (r.getType() == Type.NAME) {
                br = null;
                nr = bof.isBiff8() ? new NameRecord(r) : new NameRecord(r, NameRecord.biff7);
                this.namedRecords.put(((NameRecord)nr).getName(), nr);
            }
            r.getType();
            var10000 = Type.ROW;
            if (r.getType() == Type.NINETEENFOUR) {
                nr = new NineteenFourRecord(r);
                this.nineteenFour = ((NineteenFourRecord)nr).is1904();
            }
            if (r.getType() == Type.FORMAT) {
                br = null;
                FormatRecord fr = bof.isBiff8() ? new FormatRecord(r, FormatRecord.biff8) : new FormatRecord(r, FormatRecord.biff7);
                try {
                    this.formattingRecords.addFormat(fr);
                }
                catch (NumFormatRecordsException var8) {
                    Assert.verify((boolean)false, (String)var8.getMessage());
                }
            }
            if (r.getType() == Type.BOUNDSHEET) {
                BoundsheetRecord brr = null;
                brr = bof.isBiff8() ? new BoundsheetRecord(r) : new BoundsheetRecord(r, BoundsheetRecord.biff7);
                this.boundsheets.add(brr);
            }
            r.getType();
            var10000 = Type.EXTSST;
            r.getType();
            var10000 = Type.CONTINUE;
            if (r.getType() != Type.EOF) continue;
            --this.bofs;
        }
        if (this.excelFile.hasNext() && (r = this.excelFile.next()).getType() == Type.BOF) {
            bof = new BOFRecord(r);
        }
        while (bof != null) {
            if (!bof.isBiff8() && !bof.isBiff7()) {
                throw new BiffException(BiffException.unrecognizedBiffVersion);
            }
            SheetImpl s = new SheetImpl(this.excelFile, this.sharedStrings, this.formattingRecords, bof, this.workbookBof, this.nineteenFour, this);
            BoundsheetRecord br = (BoundsheetRecord)this.boundsheets.get(this.getNumberOfSheets());
            s.setName(br.getName());
            s.setHidden(br.isHidden());
            this.addSheet(s);
            if (this.excelFile.hasNext()) {
                r = this.excelFile.next();
                if (r.getType() == Type.BOF) {
                    bof = new BOFRecord(r);
                    continue;
                }
                bof = null;
                continue;
            }
            bof = null;
        }
    }
}

