/*
 * Decompiled with CFR 0.152.
 */
package csvorexcel.controllers.jxlAquasys;

import common.Assert;
import csvorexcel.controllers.jxlAquasys.BuiltInFormat;
import csvorexcel.controllers.jxlAquasys.FormattingRecords;
import csvorexcel.controllers.jxlAquasys.Record;
import csvorexcel.controllers.jxlAquasys.WritableRecordData;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.biff.Fonts;
import jxl.biff.IntegerHelper;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.Type;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Font;
import jxl.format.Format;
import jxl.format.Orientation;
import jxl.format.Pattern;
import jxl.format.VerticalAlignment;

public class XFRecord
extends WritableRecordData
implements CellFormat {
    private int formatIndex;
    private boolean date;
    private boolean number;
    private DateFormat dateFormat;
    private NumberFormat numberFormat;
    private int fontIndex;
    private boolean locked;
    private boolean hidden;
    private Alignment align;
    private VerticalAlignment valign;
    private Orientation orientation;
    private boolean wrap;
    private BorderLineStyle leftBorder;
    private BorderLineStyle rightBorder;
    private BorderLineStyle topBorder;
    private BorderLineStyle bottomBorder;
    private Colour backgroundColour;
    private Pattern pattern;
    private int options;
    private int xfIndex;
    private FontRecord font;
    private DisplayFormat format;
    private boolean initialized;
    private boolean read;
    private Format excelFormat;
    private boolean formatInfoInitialized;
    private FormattingRecords formattingRecords;
    private static int[] dateFormats = new int[]{14, 15, 16, 17, 18, 19, 20, 21, 22, 45, 46, 47};
    private static DateFormat[] javaDateFormats = new DateFormat[]{new SimpleDateFormat("M/d/yy"), new SimpleDateFormat("d-MMM-yy"), new SimpleDateFormat("d-MMM"), new SimpleDateFormat("MMM-yy"), new SimpleDateFormat("h:mm a"), new SimpleDateFormat("h:mm:ss a"), new SimpleDateFormat("H:mm"), new SimpleDateFormat("H:mm:ss"), new SimpleDateFormat("M/d/yy H:mm"), new SimpleDateFormat("mm:ss"), new SimpleDateFormat("H:mm:ss"), new SimpleDateFormat("mm:ss.S")};
    private static int[] numberFormats = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 37, 38, 39, 40, 41, 42, 43, 44, 48};
    private static NumberFormat[] javaNumberFormats = new NumberFormat[]{new DecimalFormat("0"), new DecimalFormat("0.00"), new DecimalFormat("#,##0"), new DecimalFormat("#,##0.00"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("0%"), new DecimalFormat("0.00%"), new DecimalFormat("0.00E00"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("##0.0E0")};

    public XFRecord(FontRecord fnt, DisplayFormat form) {
        super(Type.XF);
        this.initialized = false;
        this.locked = true;
        this.hidden = false;
        this.align = Alignment.GENERAL;
        this.valign = VerticalAlignment.BOTTOM;
        this.orientation = Orientation.HORIZONTAL;
        this.wrap = false;
        this.leftBorder = BorderLineStyle.NONE;
        this.rightBorder = BorderLineStyle.NONE;
        this.topBorder = BorderLineStyle.NONE;
        this.bottomBorder = BorderLineStyle.NONE;
        this.backgroundColour = Colour.DEFAULT_BACKGROUND;
        this.pattern = Pattern.NONE;
        this.font = fnt;
        this.format = form;
        this.read = false;
        this.formatInfoInitialized = true;
        Assert.verify((this.font != null ? 1 : 0) != 0);
        Assert.verify((this.format != null ? 1 : 0) != 0);
    }

    public XFRecord(Record t) {
        super(t);
        int i;
        byte[] data = this.getRecord().getData();
        this.fontIndex = IntegerHelper.getInt((byte)data[0], (byte)data[1]);
        this.formatIndex = IntegerHelper.getInt((byte)data[2], (byte)data[3]);
        this.date = false;
        this.number = false;
        for (i = 0; i < dateFormats.length; ++i) {
            if (this.formatIndex != dateFormats[i]) continue;
            this.date = true;
            this.dateFormat = javaDateFormats[i];
        }
        for (i = 0; i < numberFormats.length; ++i) {
            if (this.formatIndex != numberFormats[i]) continue;
            this.number = true;
            this.numberFormat = javaNumberFormats[i];
        }
        this.initialized = false;
        this.read = true;
        this.formatInfoInitialized = false;
    }

    public Alignment getAlignment() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.align;
    }

    public Colour getBackgroundColour() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.backgroundColour;
    }

    public BorderLineStyle getBorder(Border border) {
        if (border != Border.NONE && border != Border.ALL) {
            if (!this.formatInfoInitialized) {
                this.initializeFormatInformation();
            }
            if (border == Border.LEFT) {
                return this.leftBorder;
            }
            if (border == Border.RIGHT) {
                return this.rightBorder;
            }
            if (border == Border.TOP) {
                return this.topBorder;
            }
            return border == Border.BOTTOM ? this.bottomBorder : BorderLineStyle.NONE;
        }
        return BorderLineStyle.NONE;
    }

    @Override
    public byte[] getData() {
        if (this.read) {
            return this.getRecord().getData();
        }
        byte[] data = new byte[20];
        IntegerHelper.getTwoBytes((int)this.fontIndex, (byte[])data, (int)0);
        IntegerHelper.getTwoBytes((int)this.formatIndex, (byte[])data, (int)2);
        int alignMask = this.align.getValue();
        if (this.wrap) {
            alignMask |= 8;
        }
        alignMask |= this.valign.getValue() << 4;
        IntegerHelper.getTwoBytes((int)(alignMask |= this.orientation.getValue() << 8), (byte[])data, (int)6);
        int borderMask = this.leftBorder.getValue();
        borderMask |= this.rightBorder.getValue() << 4;
        borderMask |= this.topBorder.getValue() << 8;
        IntegerHelper.getTwoBytes((int)(borderMask |= this.bottomBorder.getValue() << 12), (byte[])data, (int)10);
        if (borderMask != 0) {
            data[12] = 64;
            data[13] = 32;
            data[14] = 64;
            data[15] = 32;
        }
        IntegerHelper.getTwoBytes((int)this.pattern.getValue(), (byte[])data, (int)16);
        int colourPaletteMask = this.backgroundColour.getValue();
        IntegerHelper.getTwoBytes((int)(colourPaletteMask |= 0x2000), (byte[])data, (int)18);
        IntegerHelper.getTwoBytes((int)this.options, (byte[])data, (int)8);
        return data;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public Font getFont() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.font;
    }

    public Format getFormat() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.excelFormat;
    }

    public int getFormatRecord() {
        return this.formatIndex;
    }

    protected final boolean getHidden() {
        return this.hidden;
    }

    protected final boolean getLocked() {
        return this.locked;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public Orientation getOrientation() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.orientation;
    }

    public Pattern getPattern() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.pattern;
    }

    public VerticalAlignment getVerticalAlignment() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.valign;
    }

    public boolean getWrap() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.wrap;
    }

    public final int getXFIndex() {
        return this.xfIndex;
    }

    public final void initialize(int pos, FormattingRecords fr, Fonts fonts) throws NumFormatRecordsException {
        this.xfIndex = pos;
        this.formattingRecords = fr;
        if (this.read) {
            this.initialized = true;
        } else {
            if (!this.font.isInitialized()) {
                fonts.addFont(this.font);
            }
            if (!this.format.isInitialized()) {
                fr.addFormat(this.format);
            }
            this.fontIndex = this.font.getFontIndex();
            this.formatIndex = this.format.getFormatIndex();
            this.initialized = true;
        }
    }

    private void initializeFormatInformation() {
        this.excelFormat = this.formatIndex < BuiltInFormat.builtIns.length && BuiltInFormat.builtIns[this.formatIndex] != null ? BuiltInFormat.builtIns[this.formatIndex] : this.formattingRecords.getFormatRecord(this.formatIndex);
        this.font = this.formattingRecords.getFonts().getFont(this.fontIndex);
        byte[] data = this.getRecord().getData();
        int alignMask = IntegerHelper.getInt((byte)data[6], (byte)data[7]);
        if ((alignMask & 8) != 0) {
            this.wrap = true;
        }
        this.align = Alignment.getAlignment((int)(alignMask & 7));
        this.valign = VerticalAlignment.getAlignment((int)(alignMask >> 4 & 7));
        this.orientation = Orientation.getOrientation((int)(alignMask >> 8 & 0xFF));
        int borderMask = IntegerHelper.getInt((byte)data[10], (byte)data[11]);
        this.leftBorder = BorderLineStyle.getStyle((int)(borderMask & 7));
        this.rightBorder = BorderLineStyle.getStyle((int)(borderMask >> 4 & 7));
        this.topBorder = BorderLineStyle.getStyle((int)(borderMask >> 8 & 7));
        this.bottomBorder = BorderLineStyle.getStyle((int)(borderMask >> 12 & 7));
        int patternVal = IntegerHelper.getInt((byte)data[16], (byte)data[17]);
        this.pattern = Pattern.getPattern((int)patternVal);
        int colourPaletteMask = IntegerHelper.getInt((byte)data[18], (byte)data[19]);
        this.backgroundColour = Colour.getColour((int)(colourPaletteMask & 0xFF));
        if (this.backgroundColour == Colour.UNKNOWN) {
            this.backgroundColour = Colour.DEFAULT_BACKGROUND;
        }
        this.formatInfoInitialized = true;
    }

    public boolean isDate() {
        return this.date;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public boolean isNumber() {
        return this.number;
    }

    public final void setLocked(boolean l) {
        this.locked = l;
    }

    protected void setXFAlignment(Alignment a) {
        Assert.verify((boolean)(this.initialized ^ true));
        this.align = a;
    }

    protected void setXFBackground(Colour c, Pattern p) {
        Assert.verify((boolean)(this.initialized ^ true));
        this.backgroundColour = c;
        this.pattern = p;
    }

    protected void setXFBorder(Border b, BorderLineStyle ls) {
        Assert.verify((boolean)(this.initialized ^ true));
        if (b == Border.LEFT) {
            this.leftBorder = ls;
        } else if (b == Border.RIGHT) {
            this.rightBorder = ls;
        } else if (b == Border.TOP) {
            this.topBorder = ls;
        } else if (b == Border.BOTTOM) {
            this.bottomBorder = ls;
        }
    }

    protected final void setXFCellOptions(int opt) {
        this.options = opt;
    }

    protected void setXFOrientation(Orientation o) {
        Assert.verify((boolean)(this.initialized ^ true));
        this.orientation = o;
    }

    protected void setXFVerticalAlignment(VerticalAlignment va) {
        Assert.verify((boolean)(this.initialized ^ true));
        this.valign = va;
    }

    protected void setXFWrap(boolean w) {
        Assert.verify((boolean)(this.initialized ^ true));
        this.wrap = w;
    }

    public final void uninitialize() {
        this.initialized = false;
    }
}

