/*
 * Decompiled with CFR 0.152.
 */
package era5;

import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constant.ImportMode$;
import era5.DateValueMeasure;
import era5.DateValueMeasure$;
import era5.ERA5Coordinates;
import era5.ERA5Coordinates$;
import era5.ERA5Filter;
import era5.ERA5Filter$;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.pluviometry.domain.PluviometerWithLinks;
import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.pluviometry.model.Pluviometer;
import fr.aquasys.daeau.pluviometry.model.Pluviometer$;
import fr.aquasys.daeau.referentials.city.itf.CityDao;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.AlgoUtil$;
import fr.aquasys.utils.DateTimeFormatUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import genericImport.itf.GenericImportDao;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Buffer;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import util.WSUtil$;

@ScalaSignature(bytes="\u0006\u0005\tEa\u0001B\n\u0015\u0001]A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006Y!\n\u0005\tc\u0001\u0011\t\u0011)A\u0006e!A\u0001\b\u0001B\u0001B\u0003-\u0011\b\u0003\u0005D\u0001\t\u0005\t\u0015a\u0003E\u0011!i\u0005A!A!\u0002\u0017q\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b1\u0002,\t\u000b\u0005\u0004A\u0011\u00012\t\u000bU\u0004A\u0011\t<\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011q\u0006\u0001\u0005B\u0005E\u0002bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\n\u0003\u001b\u0002!\u0019!C\u0001\u0003\u001fB\u0001\"!\u001a\u0001A\u0003%\u0011\u0011\u000b\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!!/\u0001\t\u0003\tY\fC\u0004\u0002L\u0002!\t!!4\t\u000f\u0005%\b\u0001\"\u0001\u0002l\nqQIU!6\u0007>tGO]8mY\u0016\u0014(\"A\u000b\u0002\t\u0015\u0014\u0018-N\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\n1!\u00199j\u0013\t\u0019\u0003EA\u0003N_\u0012,G.A\u0004M_\u001e,F/\u001b7\u0011\u0005\u0019zS\"A\u0014\u000b\u0005!J\u0013\u0001B;uS2T!AK\u0016\u0002\u0011I\f'MY5u[FT!\u0001L\u0017\u0002\u000f\u0005\fX/Y:zg*\ta&\u0001\u0002ge&\u0011\u0001g\n\u0002\b\u0019><W\u000b^5m\u0003)QuN\u0019'pOV#\u0018\u000e\u001c\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k-\nQ!\u001e;jYNL!a\u000e\u001b\u0003\u0015){'\rT8h+RLG.\u0001\bqYV4\u0018n\\7fi\u0016\u0014H)Y8\u0011\u0005i\nU\"A\u001e\u000b\u0005qj\u0014aA5uM*\u0011ahP\u0001\fa2,h/[8nKR\u0014\u0018P\u0003\u0002AW\u0005)A-Y3bk&\u0011!i\u000f\u0002\u000f!2,h/[8nKR,'\u000fR1p\u0003\u001d\u0019\u0017\u000e^=EC>\u0004\"!R&\u000e\u0003\u0019S!\u0001P$\u000b\u0005!K\u0015\u0001B2jifT!AS \u0002\u0019I,g-\u001a:f]RL\u0017\r\\:\n\u000513%aB\"jif$\u0015m\\\u0001\u0011\u000f\u0016tWM]5d\u00136\u0004xN\u001d;EC>\u0004\"aT*\u000e\u0003AS!\u0001P)\u000b\u0003I\u000bQbZ3oKJL7-S7q_J$\u0018B\u0001+Q\u0005A9UM\\3sS\u000eLU\u000e]8si\u0012\u000bw.\u0001\u0005X'\u000ec\u0017.\u001a8u!\t9v,D\u0001Y\u0015\tI&,\u0001\u0002xg*\u00111\fX\u0001\u0005Y&\u00147O\u0003\u0002\";*\ta,\u0001\u0003qY\u0006L\u0018B\u00011Y\u0005!96k\u00117jK:$\u0018A\u0002\u001fj]&$h\bF\u0001d)\u001d!gm\u001a5jU.\u0004\"!\u001a\u0001\u000e\u0003QAQ\u0001J\u0004A\u0004\u0015BQ!M\u0004A\u0004IBQ\u0001O\u0004A\u0004eBQaQ\u0004A\u0004\u0011CQ!T\u0004A\u00049CQ!V\u0004A\u0004YC#aB7\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018AB5oU\u0016\u001cGOC\u0001s\u0003\u0015Q\u0017M^1y\u0013\t!xN\u0001\u0004J]*,7\r^\u0001\u000eO\u0016$(k\\;uS:<7*Z=\u0015\u0003]\u0004\"\u0001_@\u000f\u0005el\bC\u0001>\u001b\u001b\u0005Y(B\u0001?\u0017\u0003\u0019a$o\\8u}%\u0011aPG\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00111\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005yT\u0012a\u00035b]\u0012dW-\u0012:s_J$b!!\u0003\u0002\u0010\u0005\u0015\u0002cA\r\u0002\f%\u0019\u0011Q\u0002\u000e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003#I\u0001\u0019AA\n\u0003\u0005)\u0007\u0003BA\u000b\u0003?qA!a\u0006\u0002\u001c9\u0019!0!\u0007\n\u0003mI1!!\b\u001b\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\t\u0002$\tIQ\t_2faRLwN\u001c\u0006\u0004\u0003;Q\u0002bBA\u0014\u0013\u0001\u0007\u0011\u0011F\u0001\u000fU>\u0014W\t_3dkRLwN\\%e!\rI\u00121F\u0005\u0004\u0003[Q\"\u0001\u0002'p]\u001e\fq!\u001a=fGV$X\r\u0006\u0004\u0002\n\u0005M\u0012q\u0007\u0005\u0007\u0003kQ\u0001\u0019A<\u0002\u0015I|W\u000f^5oO.+\u0017\u0010C\u0004\u0002:)\u0001\r!a\u000f\u0002\u000f5,7o]1hKB!\u0011QHA\"\u001b\t\tyDC\u0002\u0002Bi\u000bAA[:p]&!\u0011QIA \u0005\u001dQ5OV1mk\u0016\fq\"\u001a=fGV$X-T1ok\u0006dG.\u001f\u000b\u0004o\u0006-\u0003bBA\u001d\u0017\u0001\u0007\u00111H\u0001\fI\u00164\u0017-\u001e7u\t\u0006$X-\u0006\u0002\u0002RA!\u00111KA1\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013\u0001\u0002;j[\u0016TA!a\u0017\u0002^\u0005!!n\u001c3b\u0015\t\ty&A\u0002pe\u001eLA!a\u0019\u0002V\tAA)\u0019;f)&lW-\u0001\u0007eK\u001a\fW\u000f\u001c;ECR,\u0007%A\u0007fq\u0016\u001cW\u000f^3J[B|'\u000f\u001e\u000b\u0005\u0003W\n9\b\u0005\u0004\u0002\u0016\u00055\u0014\u0011O\u0005\u0005\u0003_\n\u0019CA\u0002TKF\u00042!GA:\u0013\r\t)H\u0007\u0002\u0004\u0013:$\bbBA\u001d\u001d\u0001\u0007\u00111H\u0001\u000fS6\u0004xN\u001d;ECR\fG+\u001f9f)1\ti(!%\u0002\u0016\u0006e\u00151VA[)\u0019\tI!a \u0002\u0002\"9\u0011qE\bA\u0004\u0005%\u0002bBAB\u001f\u0001\u000f\u0011QQ\u0001\nI\u0016\u0014WoZ'pI\u0016\u0004R!GAD\u0003\u0017K1!!#\u001b\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011$!$\n\u0007\u0005=%DA\u0004C_>dW-\u00198\t\r\u0005Mu\u00021\u0001x\u0003\u0019!GOT1nK\"9\u0011qS\bA\u0002\u0005E\u0014A\u0002;za\u0016LE\rC\u0004\u0002\u001c>\u0001\r!!(\u0002\u0011M$\u0018\r^5p]N\u0004b!!\u0006\u0002n\u0005}\u0005\u0003BAQ\u0003Ok!!a)\u000b\u0007\u0005\u0015V(A\u0003n_\u0012,G.\u0003\u0003\u0002*\u0006\r&a\u0003)mkZLw.\\3uKJDq!!,\u0010\u0001\u0004\ty+A\u0004gS2$XM]:\u0011\u0007\u0015\f\t,C\u0002\u00024R\u0011!\"\u0012*Bk\u0019KG\u000e^3s\u0011\u0019\t9l\u0004a\u0001o\u0006!Qo]3s\u000359W\r^\"p_J$7oQ8eKR)q/!0\u0002H\"9\u0011q\u0018\tA\u0002\u0005\u0005\u0017!\u0001=\u0011\u0007e\t\u0019-C\u0002\u0002Fj\u0011a\u0001R8vE2,\u0007bBAe!\u0001\u0007\u0011\u0011Y\u0001\u0002s\u0006Qr-\u001a;DSRL8\u000b^1uS>t7oQ8pe\u0012Lg.\u0019;fgRA\u0011qZAo\u0003C\f)\u000f\u0006\u0004\u0002R\u0006e\u00171\u001c\t\u0007\u0003+\ti'a5\u0011\u0007\u0015\f).C\u0002\u0002XR\u0011q\"\u0012*Bk\r{wN\u001d3j]\u0006$Xm\u001d\u0005\b\u0003O\t\u00029AA\u0015\u0011\u001d\t\u0019)\u0005a\u0002\u0003\u000bCa!a8\u0012\u0001\u00049\u0018\u0001C2jif\u001cu\u000eZ3\t\u000f\u0005\r\u0018\u00031\u0001\u0002\f\u0006iA/Y6f!JLgnY5qC2Dq!a:\u0012\u0001\u0004\t\t(A\u0004biR,W\u000e\u001d;\u0002\u0017\u001d,G/T3bgV\u0014Xm\u001d\u000b\r\u0003[\fY0a@\u0003\u0004\t\u001d!Q\u0002\u000b\u0007\u0003_\f90!?\u0011\r\u0005U\u0011QNAy!\r)\u00171_\u0005\u0004\u0003k$\"\u0001\u0005#bi\u00164\u0016\r\\;f\u001b\u0016\f7/\u001e:f\u0011\u001d\t9C\u0005a\u0002\u0003SAq!a!\u0013\u0001\b\t)\tC\u0004\u0002~J\u0001\r!a(\u0002\u000fM$\u0018\r^5p]\"9!\u0011\u0001\nA\u0002\u0005-\u0015!\u00023bS2L\bB\u0002B\u0003%\u0001\u0007q/\u0001\u0005eCR\fG+\u001f9f\u0011\u001d\u0011IA\u0005a\u0001\u0005\u0017\t\u0011b\u001d;beR$\u0015\r^3\u0011\u000be\t9)!\u0015\t\u000f\t=!\u00031\u0001\u0003\f\u00059QM\u001c3ECR,\u0007")
public class ERA5Controller
implements Model {
    private final LogUtil LogUtil;
    private final JobLogUtil JobLogUtil;
    private final PluviometerDao pluviometerDao;
    private final GenericImportDao GenericImportDao;
    private final WSClient WSClient;
    private final DateTime defaultDate;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        ERA5Controller eRA5Controller = this;
        synchronized (eRA5Controller) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        ERA5Controller eRA5Controller = this;
        synchronized (eRA5Controller) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.INTEGRATION_ERA5_TOPIC();
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_ERA5_JOB();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.executeImport(message);
            return;
        }
        if (string != null) {
            String string4 = string;
            this.LogUtil.info(new StringBuilder(37).append("Bad routing key in ERA5Controlelr => ").append(string4).toString(), this.LogUtil.info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    public String executeManually(JsValue message) {
        Seq<Object> results = this.executeImport(message);
        return Json$.MODULE$.toJson(results.map((Function1 & Serializable)id -> ERA5Controller.$anonfun$executeManually$1(BoxesRunTime.unboxToInt((Object)id))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)GenericData$.MODULE$.writes())).toString();
    }

    public DateTime defaultDate() {
        return this.defaultDate;
    }

    public Seq<Object> executeImport(JsValue message) {
        return (Seq)message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            Predef$.MODULE$.print(error);
            $this.LogUtil.error(new StringBuilder(50).append("Error validate Json to execute ERA5 integration :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.LogUtil.error$default$2());
            return (Seq)Nil$.MODULE$;
        }, (Function1 & Serializable)jobParameters -> {
            long jobExecutionId = jobParameters.jobExecutionId();
            Option debugMode = jobParameters.debugMode();
            String user = (String)jobParameters.user().get();
            ERA5Filter filters = (ERA5Filter)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new ERA5Filter(ERA5Filter$.MODULE$.$lessinit$greater$default$1(), ERA5Filter$.MODULE$.$lessinit$greater$default$2(), ERA5Filter$.MODULE$.$lessinit$greater$default$3(), ERA5Filter$.MODULE$.$lessinit$greater$default$4(), ERA5Filter$.MODULE$.$lessinit$greater$default$5(), ERA5Filter$.MODULE$.$lessinit$greater$default$6(), ERA5Filter$.MODULE$.$lessinit$greater$default$7(), ERA5Filter$.MODULE$.$lessinit$greater$default$8(), ERA5Filter$.MODULE$.$lessinit$greater$default$9(), ERA5Filter$.MODULE$.$lessinit$greater$default$10(), ERA5Filter$.MODULE$.$lessinit$greater$default$11(), ERA5Filter$.MODULE$.$lessinit$greater$default$12(), ERA5Filter$.MODULE$.$lessinit$greater$default$13(), ERA5Filter$.MODULE$.$lessinit$greater$default$14()), false, ERA5Filter$.MODULE$.format());
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Fetching stations...", "", $this.JobLogUtil.log$default$5());
            Buffer allPluvios = ((IterableOnceOps)$this.pluviometerDao.getAll($this.pluviometerDao.getAll$default$1(), $this.pluviometerDao.getAll$default$2()).map((Function1 & Serializable)p -> new Pluviometer(p.id(), p.name(), p.creationDate(), p.closeDate(), p.x(), p.y(), p.projectionType(), p.altitude(), p.measureExpression(), p.comment(), p.townCode(), p.contactCode(), p.code(), p.address(), p.countryCode(), p.contributorCode(), p.jobId(), p.updateLogin(), p.updateDate(), p.cityCodeDeclaration(), p.localization()))).toBuffer();
            Seq stationsWithReplicas = (Seq)filters.cities().flatMap((Function1 & Serializable)cityCode -> {
                Seq<ERA5Coordinates> coords = this.getCityStationsCoordinates((String)cityCode, BoxesRunTime.unboxToBoolean((Object)filters.takePrincipal().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true)), 1, jobExecutionId, (Option<Object>)debugMode);
                return (Seq)((IterableOps)coords.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        ERA5Coordinates c = (ERA5Coordinates)tuple2._1();
                        int idx = tuple2._2$mcI$sp();
                        return (Pluviometer)allPluvios.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ERA5Controller.$anonfun$executeImport$7(this, c, x$1))).getOrElse((Function0 & Serializable)() -> {
                            Option x$21;
                            Option x$20;
                            Option x$19;
                            Option x$18;
                            Option x$17;
                            Option x$16;
                            Option x$15;
                            Option x$14;
                            Option x$13;
                            boolean x$1 = false;
                            Some x$2 = new Some((Object)new StringBuilder(6).append("ERA5 ").append(c.name()).append("_").append(idx + 1).toString());
                            Some x$3 = new Some((Object)new DateTime());
                            Some x$4 = new Some((Object)new DateTime());
                            Some x$5 = new Some((Object)user);
                            Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)((int)jobExecutionId)));
                            Some x$7 = new Some((Object)this.getCoordsCode(c.x(), c.y()));
                            Some x$8 = new Some(cityCode);
                            Some x$9 = new Some((Object)BoxesRunTime.boxToDouble((double)c.x()));
                            Some x$10 = new Some((Object)BoxesRunTime.boxToDouble((double)c.y()));
                            Some x$11 = new Some((Object)BoxesRunTime.boxToInteger((int)16));
                            Option x$12 = Pluviometer$.MODULE$.$lessinit$greater$default$4();
                            Pluviometer newStation = new Pluviometer(0, (Option)x$2, (Option)x$3, x$12, (Option)x$9, (Option)x$10, (Option)x$11, x$13 = Pluviometer$.MODULE$.$lessinit$greater$default$8(), x$14 = Pluviometer$.MODULE$.$lessinit$greater$default$9(), x$15 = Pluviometer$.MODULE$.$lessinit$greater$default$10(), (Option)x$8, x$16 = Pluviometer$.MODULE$.$lessinit$greater$default$12(), (Option)x$7, x$17 = Pluviometer$.MODULE$.$lessinit$greater$default$14(), x$18 = Pluviometer$.MODULE$.$lessinit$greater$default$15(), x$19 = Pluviometer$.MODULE$.$lessinit$greater$default$16(), (Option)x$6, (Option)x$5, (Option)x$4, x$20 = Pluviometer$.MODULE$.$lessinit$greater$default$20(), x$21 = Pluviometer$.MODULE$.$lessinit$greater$default$21());
                            Tuple2 tuple2 = $this.pluviometerDao.create(new PluviometerWithLinks(newStation), user);
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            double id = tuple2._2$mcD$sp();
                            double id2 = id;
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(16).append("Station ").append(newStation.name().get()).append(" created").toString(), (String)newStation.code().get(), $this.JobLogUtil.log$default$5());
                            Pluviometer newWithId = newStation.copy((int)id2, newStation.copy$default$2(), newStation.copy$default$3(), newStation.copy$default$4(), newStation.copy$default$5(), newStation.copy$default$6(), newStation.copy$default$7(), newStation.copy$default$8(), newStation.copy$default$9(), newStation.copy$default$10(), newStation.copy$default$11(), newStation.copy$default$12(), newStation.copy$default$13(), newStation.copy$default$14(), newStation.copy$default$15(), newStation.copy$default$16(), newStation.copy$default$17(), newStation.copy$default$18(), newStation.copy$default$19(), newStation.copy$default$20(), newStation.copy$default$21());
                            allPluvios.append((Object)newWithId);
                            return newWithId;
                        });
                    }
                    throw new MatchError((Object)tuple2);
                });
            });
            Seq stations = AlgoUtil$.MODULE$.uniqBy(stationsWithReplicas, (Function1 & Serializable)s -> (String)s.code().get());
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(25).append("Begin update of ").append(stations.length()).append(" stations").toString(), "", $this.JobLogUtil.log$default$5());
            if (filters.rain().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters.rainDt().nonEmpty()) {
                this.importDataType("rain", BoxesRunTime.unboxToInt((Object)filters.rainDt().get()), (Seq<Pluviometer>)stations, filters, user, jobExecutionId, (Option<Object>)debugMode);
            }
            if (filters.temperature().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters.temperatureDt().nonEmpty()) {
                this.importDataType("temperature", BoxesRunTime.unboxToInt((Object)filters.temperatureDt().get()), (Seq<Pluviometer>)stations, filters, user, jobExecutionId, (Option<Object>)debugMode);
            }
            if (filters.radiation().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters.radiationDt().nonEmpty()) {
                this.importDataType("radiation", BoxesRunTime.unboxToInt((Object)filters.radiationDt().get()), (Seq<Pluviometer>)stations, filters, user, jobExecutionId, (Option<Object>)debugMode);
            }
            if (filters.etp().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters.etpDt().nonEmpty()) {
                this.importDataType("etp", BoxesRunTime.unboxToInt((Object)filters.etpDt().get()), (Seq<Pluviometer>)stations, filters, user, jobExecutionId, (Option<Object>)debugMode);
            }
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.STATION_IDS(), ((IterableOnceOps)stations.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()))).mkString(","), "", $this.JobLogUtil.log$default$5());
            return (Seq)stations.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()));
        });
    }

    public void importDataType(String dtName, int typeId, Seq<Pluviometer> stations, ERA5Filter filters, String user, long jobExecutionId, Option<Object> debugMode) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(15).append("Integrating ").append(dtName).append("...").toString(), "", this.JobLogUtil.log$default$5());
        stations.foreach((Function1 & Serializable)s -> {
            ERA5Controller.$anonfun$importDataType$1(this, filters, typeId, dtName, jobExecutionId, debugMode, user, s);
            return BoxedUnit.UNIT;
        });
    }

    public String getCoordsCode(double x, double y) {
        return new StringBuilder(2).append("X").append(Double.toString(x).replace(".0", "")).append("Y").append(Double.toString(y).replace(".0", "")).toString();
    }

    public Seq<ERA5Coordinates> getCityStationsCoordinates(String cityCode, boolean takePrincipal, int attempt, long jobExecutionId, Option<Object> debugMode) {
        Option option;
        String url = new StringBuilder(74).append("https://aqua6bo.aquadb.fr/data/climatic/era5/stations?code=").append(cityCode).append("&takePrincipal=").append(takePrincipal).toString();
        if (debugMode.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(15).append("call aqua6bo : ").append(url).toString(), "", "");
        }
        if (None$.MODULE$.equals(option = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String x$1 = url;
            int x$2 = 4;
            FiniteDuration x$3 = new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds();
            Seq<Nothing$> x$4 = WSUtil$.MODULE$.getWithAuthOneTry$default$3();
            return WSUtil$.MODULE$.getWithAuthOneTry(x$1, 4, x$4, (Duration)x$3, Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), ERA5Coordinates$.MODULE$.format()), $this.WSClient);
        }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()))) {
            if (attempt == 3) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(66).append("3 attempt failed : Error while fetching stations with city code : ").append(cityCode).toString(), cityCode, this.JobLogUtil.log$default$5());
                return (Seq)Nil$.MODULE$;
            }
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(78).append("Attempt ").append(attempt).append(" failed, waiting 10s : Error while fetching stations with city code : ").append(cityCode).toString(), cityCode, this.JobLogUtil.log$default$5());
            Thread.sleep(10000L);
            return this.getCityStationsCoordinates(cityCode, takePrincipal, attempt + 1, jobExecutionId, debugMode);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq coords = (Seq)some.value();
            return coords;
        }
        throw new MatchError((Object)option);
    }

    public Seq<DateValueMeasure> getMeasures(Pluviometer station, boolean daily, String dataType, Option<DateTime> startDate, Option<DateTime> endDate, long jobExecutionId, Option<Object> debugMode) {
        Option option;
        String url = "https://aqua6bo.aquadb.fr/data/climatic/era5/measures";
        String body = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)station.x(), Writes$.MODULE$.OptionWrites((Writes)Writes$.MODULE$.DoubleWrites()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"y"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)station.y(), Writes$.MODULE$.OptionWrites((Writes)Writes$.MODULE$.DoubleWrites()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)dataType, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"daily"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((boolean)daily), (Writes)Writes$.MODULE$.BooleanWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startDate"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper(startDate, (Writes)DateTimeFormatUtil$.MODULE$.datetimeFormatOpt())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endDate"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper(endDate, (Writes)DateTimeFormatUtil$.MODULE$.datetimeFormatOpt()))})).toString();
        if (debugMode.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.DEBUG(), new StringBuilder(28).append("call aqua6bo : ").append(url).append(" with body : ").append(body).toString(), ((String)station.code().get()).toString(), "");
        }
        if (None$.MODULE$.equals(option = WSUtil$.MODULE$.postAqua6BO(url, body, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), WSUtil$.MODULE$.postAqua6BO$default$4(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), DateValueMeasure$.MODULE$.measureRead()), this.WSClient))) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error while fetching measures", (String)station.code().get(), this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(11).append("Url used : ").append(url).toString(), (String)station.code().get(), this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(12).append("body used : ").append(body).toString(), (String)station.code().get(), this.JobLogUtil.log$default$5());
            return (Seq)Nil$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq measures = (Seq)some.value();
            return measures;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ GenericData $anonfun$executeManually$1(int id) {
        DateTime x$1 = new DateTime();
        DateTime x$2 = new DateTime();
        int x$3 = id;
        None$ x$4 = None$.MODULE$;
        Option x$5 = GenericData$.MODULE$.$lessinit$greater$default$5();
        Option x$6 = GenericData$.MODULE$.$lessinit$greater$default$6();
        Option x$7 = GenericData$.MODULE$.$lessinit$greater$default$7();
        Option x$8 = GenericData$.MODULE$.$lessinit$greater$default$8();
        Option x$9 = GenericData$.MODULE$.$lessinit$greater$default$9();
        Option x$10 = GenericData$.MODULE$.$lessinit$greater$default$10();
        Option x$11 = GenericData$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = GenericData$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = GenericData$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = GenericData$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = GenericData$.MODULE$.$lessinit$greater$default$15();
        return new GenericData(x$1, x$2, (Option)x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
    }

    public static final /* synthetic */ boolean $anonfun$executeImport$7(ERA5Controller $this, ERA5Coordinates c$1, Pluviometer x$1) {
        Object object = x$1.code().getOrElse((Function0 & Serializable)() -> "");
        String string = $this.getCoordsCode(c$1.x(), c$1.y());
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$importDataType$1(ERA5Controller $this, ERA5Filter filters$2, int typeId$1, String dtName$1, long jobExecutionId$2, Option debugMode$2, String user$2, Pluviometer s) {
        DateTime startDate = (DateTime)filters$2.startDate().getOrElse((Function0 & Serializable)() -> {
            if (filters$2.importMode().contains((Object)ImportMode$.MODULE$.REPLACE_HISTO())) {
                return $this.defaultDate();
            }
            return (DateTime)$this.GenericImportDao.getLastDateByStation(StationTypeUtil$.MODULE$.PLUVIOMETRY(), typeId$1, s.id(), $this.GenericImportDao.getLastDateByStation$default$4()).getOrElse((Function0 & Serializable)() -> $this.defaultDate());
        });
        Seq<DateValueMeasure> measures = $this.getMeasures(s, BoxesRunTime.unboxToBoolean((Object)filters$2.daily().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)), dtName$1, (Option<DateTime>)new Some((Object)startDate), filters$2.endDate(), jobExecutionId$2, (Option<Object>)debugMode$2);
        if (measures.nonEmpty()) {
            $this.JobLogUtil.log(jobExecutionId$2, JobState$.MODULE$.INFO(), new StringBuilder(39).append(measures.length()).append(" measures fetched. Integration to DB...").toString(), (String)s.code().get(), $this.JobLogUtil.log$default$5());
            Option<String> x$1 = filters$2.importMode();
            Option<Object> x$2 = ImportOptions$.MODULE$.apply$default$1();
            Option<Object> x$3 = ImportOptions$.MODULE$.apply$default$3();
            Option<String> x$42 = ImportOptions$.MODULE$.apply$default$4();
            Option<Object> x$5 = ImportOptions$.MODULE$.apply$default$5();
            Option<Seq<Object>> x$6 = ImportOptions$.MODULE$.apply$default$6();
            Option<Object> x$7 = ImportOptions$.MODULE$.apply$default$7();
            int res = $this.GenericImportDao.importPluviometry(Integer.toString(s.id()), (String)s.code().get(), user$2, jobExecutionId$2, (Seq<GenericData>)((Seq)measures.map((Function1 & Serializable)x$4 -> x$4.toGenericData(typeId$1))), (Option<ImportOptions>)new Some((Object)new ImportOptions(x$2, x$1, x$3, x$42, x$5, x$6, x$7)));
            $this.JobLogUtil.log(jobExecutionId$2, JobState$.MODULE$.SUCCESS(), new StringBuilder(19).append(res).append(" measures imported.").toString(), (String)s.code().get(), $this.JobLogUtil.log$default$5());
            return;
        }
        $this.JobLogUtil.log(jobExecutionId$2, JobState$.MODULE$.NOTHING_TO_DO(), "no new measures.", (String)s.code().get(), $this.JobLogUtil.log$default$5());
    }

    @Inject
    public ERA5Controller(LogUtil LogUtil2, JobLogUtil JobLogUtil2, PluviometerDao pluviometerDao, CityDao cityDao, GenericImportDao GenericImportDao2, WSClient WSClient2) {
        this.LogUtil = LogUtil2;
        this.JobLogUtil = JobLogUtil2;
        this.pluviometerDao = pluviometerDao;
        this.GenericImportDao = GenericImportDao2;
        this.WSClient = WSClient2;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        this.defaultDate = new DateTime(1979, 1, 1, 0, 0, 0, 0);
        Statics.releaseFence();
    }
}

