/*
 * Decompiled with CFR 0.152.
 */
package hydrometry.controller;

import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constant.ImportMode$;
import constant.IntegrationType$;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicDao;
import fr.aquasys.daeau.hydrometry.chronic.HydroChronicMeasure;
import fr.aquasys.daeau.hydrometry.itf.HydrometryEventDao;
import fr.aquasys.daeau.iaeau.model.PredMeasure;
import fr.aquasys.daeau.iaeau.model.PredMeasure$;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.referentials.city.itf.CityDao;
import fr.aquasys.daeau.referentials.city.model.City;
import fr.aquasys.daeau.referentials.city.model.City$;
import fr.aquasys.daeau.station.itf.StationThresholdDao;
import fr.aquasys.daeau.station.threshold.StationThreshold;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.JobType$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.AlgoUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.MathUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import genericImport.anorms.AnormHydroChronicImportDao;
import genericImport.itf.PredImportDao;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import hydrometry.dao.HydrometryStationDao;
import hydrometry.dao.http.Aqua6boHydrometryDao;
import hydrometry.domain.HydroJobParams;
import hydrometry.domain.HydroJobParams$;
import hydrometry.domain.banqueHydro.BHEvent;
import hydrometry.domain.banqueHydro.BHStation;
import hydrometry.domain.vigicruesPred.VigicruePredMeasure;
import hydrometry.domain.vigicruesPred.VigicruePredMeasure$;
import hydrometry.model.HydrometryStation;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.Hours;
import org.joda.time.ReadablePartial;
import play.api.db.Database;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.ws.WSClient;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import util.JobParametersUtil$;
import util.WSUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\tUg\u0001\u0002\u0012$\u0001!B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006YA\u000e\u0005\t\u0001\u0002\u0011\t\u0011)A\u0006\u0003\"AQ\n\u0001B\u0001B\u0003-a\n\u0003\u0005U\u0001\t\u0005\t\u0015a\u0003V\u0011!Y\u0006A!A!\u0002\u0017a\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b1B3\t\u0011=\u0004!\u0011!Q\u0001\fAD\u0001B\u001e\u0001\u0003\u0002\u0003\u0006Ya\u001e\u0005\t{\u0002\u0011\t\u0011)A\u0006}\"Q\u0011q\u0002\u0001\u0003\u0002\u0003\u0006Y!!\u0005\t\u0015\u0005m\u0001A!A!\u0002\u0017\ti\u0002\u0003\u0006\u0002*\u0001\u0011\t\u0011)A\u0006\u0003WAq!!\u000e\u0001\t\u0003\t9\u0004C\u0005\u0002j\u0001\u0011\r\u0011b\u0001\u0002l!A\u0011\u0011\u0010\u0001!\u0002\u0013\ti\u0007C\u0004\u0002|\u0001!\t%! \t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0006bBA]\u0001\u0011\u0005\u00131\u0018\u0005\b\u0003;\u0004A\u0011BAp\u0011\u001d\ty\u000f\u0001C\u0001\u0003cD\u0011B!\u0006\u0001#\u0003%\tAa\u0006\t\u000f\t5\u0002\u0001\"\u0001\u00030!I!q\r\u0001\u0012\u0002\u0013\u0005!q\u0003\u0005\n\u0005S\u0002\u0011\u0013!C\u0001\u0005/A\u0011Ba\u001b\u0001#\u0003%\tAa\u0006\t\u000f\t5\u0004\u0001\"\u0003\u0003p!I!q\u0010\u0001\u0012\u0002\u0013%!q\u0003\u0005\n\u0005\u0003\u0003\u0011\u0013!C\u0005\u0005/AqAa!\u0001\t\u0013\u0011)\tC\u0005\u0003 \u0002\u0011\r\u0011\"\u0003\u0003\"\"A!q\u0016\u0001!\u0002\u0013\u0011\u0019\u000bC\u0004\u00032\u0002!IAa-\u0003)!KHM]8nKR\u0014\u0018pQ8oiJ|G\u000e\\3s\u0015\t!S%\u0001\u0006d_:$(o\u001c7mKJT\u0011AJ\u0001\u000bQf$'o\\7fiJL8\u0001A\n\u0004\u0001%z\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00021g5\t\u0011GC\u00013\u0003\r\t\u0007/[\u0005\u0003iE\u0012Q!T8eK2\f!a^:\u0011\u0005]rT\"\u0001\u001d\u000b\u0005UJ$B\u0001\u001e<\u0003\u0011a\u0017NY:\u000b\u0005Ib$\"A\u001f\u0002\tAd\u0017-_\u0005\u0003\u007fa\u0012\u0001bV*DY&,g\u000e^\u0001\b\u0019><W\u000b^5m!\t\u00115*D\u0001D\u0015\t!U)\u0001\u0003vi&d'B\u0001$H\u0003!\u0011\u0018M\u00192ji6\f(B\u0001%J\u0003\u001d\t\u0017/^1tsNT\u0011AS\u0001\u0003MJL!\u0001T\"\u0003\u000f1{w-\u0016;jY\u0006!\u0002.\u001f3s_6,GO]=Ti\u0006$\u0018n\u001c8EC>\u0004\"a\u0014*\u000e\u0003AS!!U\u0013\u0002\u0007\u0011\fw.\u0003\u0002T!\n!\u0002*\u001f3s_6,GO]=Ti\u0006$\u0018n\u001c8EC>\fA#Y9vCZ\u0012w\u000eS=ee>lW\r\u001e:z\t\u0006|\u0007C\u0001,Z\u001b\u00059&B\u0001-Q\u0003\u0011AG\u000f\u001e9\n\u0005i;&\u0001F!rk\u00064$m\u001c%zIJ|W.\u001a;ss\u0012\u000bw.\u0001\u000eB]>\u0014X\u000eS=ee>\u001c\u0005N]8oS\u000eLU\u000e]8si\u0012\u000bw\u000e\u0005\u0002^E6\taL\u0003\u0002`A\u00061\u0011M\\8s[NT\u0011!Y\u0001\u000eO\u0016tWM]5d\u00136\u0004xN\u001d;\n\u0005\rt&AG!o_Jl\u0007*\u001f3s_\u000eC'o\u001c8jG&k\u0007o\u001c:u\t\u0006|\u0017aE:uCRLwN\u001c+ie\u0016\u001c\bn\u001c7e\t\u0006|\u0007C\u00014n\u001b\u00059'B\u00015j\u0003\rIGO\u001a\u0006\u0003U.\fqa\u001d;bi&|gN\u0003\u0002m\u000f\u0006)A-Y3bk&\u0011an\u001a\u0002\u0014'R\fG/[8o)\"\u0014Xm\u001d5pY\u0012$\u0015m\\\u0001\u0013\u0011f$'o\\7fiJLXI^3oi\u0012\u000bw\u000e\u0005\u0002ri6\t!O\u0003\u0002ig*\u0011ae[\u0005\u0003kJ\u0014!\u0003S=ee>lW\r\u001e:z\u000bZ,g\u000e\u001e#b_\u0006y\u0001*\u001f3s_\u000eC'o\u001c8jG\u0012\u000bw\u000e\u0005\u0002yw6\t\u0011P\u0003\u0002{g\u000691\r\u001b:p]&\u001c\u0017B\u0001?z\u0005=A\u0015\u0010\u001a:p\u0007\"\u0014xN\\5d\t\u0006|\u0017aB2jif$\u0015m\u001c\t\u0004\u007f\u0006-QBAA\u0001\u0015\rA\u00171\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003dSRL(bAA\u0005W\u0006a!/\u001a4fe\u0016tG/[1mg&!\u0011QBA\u0001\u0005\u001d\u0019\u0015\u000e^=EC>\fQ\u0002\u0015:fI&k\u0007o\u001c:u\t\u0006|\u0007\u0003BA\n\u0003/i!!!\u0006\u000b\u0005!\u0004\u0017\u0002BA\r\u0003+\u0011Q\u0002\u0015:fI&k\u0007o\u001c:u\t\u0006|\u0017A\u0003&pE2{w-\u0016;jYB!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$\u001d\u000bQ!\u001e;jYNLA!a\n\u0002\"\tQ!j\u001c2M_\u001e,F/\u001b7\u0002\u0005\u0011\u0014\u0007\u0003BA\u0017\u0003ci!!a\f\u000b\u0007\u0005%2(\u0003\u0003\u00024\u0005=\"\u0001\u0003#bi\u0006\u0014\u0017m]3\u0002\rqJg.\u001b;?)\t\tI\u0004\u0006\u000e\u0002<\u0005}\u0012\u0011IA\"\u0003\u000b\n9%!\u0013\u0002L\u00055\u0013qJA)\u0003'\n)\u0006E\u0002\u0002>\u0001i\u0011a\t\u0005\u0006k5\u0001\u001dA\u000e\u0005\u0006\u00016\u0001\u001d!\u0011\u0005\u0006\u001b6\u0001\u001dA\u0014\u0005\u0006)6\u0001\u001d!\u0016\u0005\u000676\u0001\u001d\u0001\u0018\u0005\u0006I6\u0001\u001d!\u001a\u0005\u0006_6\u0001\u001d\u0001\u001d\u0005\u0006m6\u0001\u001da\u001e\u0005\u0006{6\u0001\u001dA \u0005\b\u0003\u001fi\u00019AA\t\u0011\u001d\tY\"\u0004a\u0002\u0003;Aq!!\u000b\u000e\u0001\b\tY\u0003K\u0002\u000e\u00033\u0002B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0004j]*,7\r\u001e\u0006\u0003\u0003G\nQA[1wCbLA!a\u001a\u0002^\t1\u0011J\u001c6fGR\f!!Z2\u0016\u0005\u00055\u0004\u0003BA8\u0003kj!!!\u001d\u000b\u0007\u0005M4&\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u001e\u0002r\tAR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:\u0002\u0007\u0015\u001c\u0007%A\u0007hKR\u0014v.\u001e;j]\u001e\\U-\u001f\u000b\u0003\u0003\u007f\u0002B!!!\u0002\u0010:!\u00111QAF!\r\t)iK\u0007\u0003\u0003\u000fS1!!#(\u0003\u0019a$o\\8u}%\u0019\u0011QR\u0016\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t*a%\u0003\rM#(/\u001b8h\u0015\r\tiiK\u0001\bKb,7-\u001e;f)\u0019\tI*a(\u0002$B\u0019!&a'\n\u0007\u0005u5F\u0001\u0003V]&$\bbBAQ#\u0001\u0007\u0011qP\u0001\u000be>,H/\u001b8h\u0017\u0016L\bbBAS#\u0001\u0007\u0011qU\u0001\b[\u0016\u001c8/Y4f!\u0011\tI+a,\u000e\u0005\u0005-&bAAWs\u0005!!n]8o\u0013\u0011\t\t,a+\u0003\u000f)\u001bh+\u00197vK\u0006yQ\r_3dkR,W*\u00198vC2d\u0017\u0010\u0006\u0003\u0002\u0000\u0005]\u0006bBAS%\u0001\u0007\u0011qU\u0001\fQ\u0006tG\r\\3FeJ|'\u000f\u0006\u0004\u0002\u001a\u0006u\u00161\u001b\u0005\b\u0003\u007f\u001b\u0002\u0019AAa\u0003\u0005)\u0007\u0003BAb\u0003\u001btA!!2\u0002J:!\u0011QQAd\u0013\u0005a\u0013bAAfW\u00059\u0001/Y2lC\u001e,\u0017\u0002BAh\u0003#\u0014\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005-7\u0006C\u0004\u0002VN\u0001\r!a6\u0002\u001d)|'-\u0012=fGV$\u0018n\u001c8JIB\u0019!&!7\n\u0007\u0005m7F\u0001\u0003M_:<\u0017aC5oi\u0016<'/\u0019;j_:$B!!9\u0002nB1\u00111YAr\u0003OLA!!:\u0002R\n\u00191+Z9\u0011\u0007)\nI/C\u0002\u0002l.\u00121!\u00138u\u0011\u001d\t)\u000b\u0006a\u0001\u0003O\u000b!c\u001d;bi&|g.\u00138uK\u001e\u0014\u0018\r^5p]R1\u00111\u001fB\u0007\u0005#!\u0002\"!>\u0002|\u0006u(\u0011\u0001\t\u0006U\u0005]\u0018q]\u0005\u0004\u0003s\\#AB(qi&|g\u000eC\u0004\u0002VV\u0001\u001d!a6\t\u000f\u0005}X\u0003q\u0001\u0002\u0000\u0005!Qo]3s\u0011\u001d\u0011\u0019!\u0006a\u0002\u0005\u000b\t\u0011\u0002Z3ck\u001elu\u000eZ3\u0011\u000b)\n9Pa\u0002\u0011\u0007)\u0012I!C\u0002\u0003\f-\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0003\u0010U\u0001\n\u00111\u0001\u0003\b\u0005i\u0011.\u001c9peR\u001cF/\u0019;j_:DqAa\u0005\u0016\u0001\u0004\ty(\u0001\u0003d_\u0012,\u0017\u0001H:uCRLwN\\%oi\u0016<'/\u0019;j_:$C-\u001a4bk2$H%M\u000b\u0003\u00053QCAa\u0002\u0003\u001c-\u0012!Q\u0004\t\u0005\u0005?\u0011I#\u0004\u0002\u0003\")!!1\u0005B\u0013\u0003%)hn\u00195fG.,GMC\u0002\u0003(-\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YC!\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\nnK\u0006\u001cXO]3t\u0013:$Xm\u001a:bi&|g\u000e\u0006\n\u00032\te\"Q\bB!\u0005\u0007\u00129Ea\u0013\u0003`\t\rD\u0003CAM\u0005g\u0011)Da\u000e\t\u000f\u0005Uw\u0003q\u0001\u0002X\"9\u0011q`\fA\u0004\u0005}\u0004b\u0002B\u0002/\u0001\u000f!Q\u0001\u0005\n\u0005w9\u0002\u0013!a\u0001\u0005\u000f\tqBZ;mY&sG/Z4sCRLwN\u001c\u0005\b\u0005\u007f9\u0002\u0019AAt\u0003%\u0019H/\u0019;j_:LE\rC\u0004\u0003\u0014]\u0001\r!a \t\u0013\t\u0015s\u0003%AA\u0002\t\u001d\u0011A\u00025fS\u001eDG\u000fC\u0005\u0003J]\u0001\n\u00111\u0001\u0003\b\u0005)A-\u001a2ji\"9!QJ\fA\u0002\t=\u0013A\u00039be\u0006lW\r^3sgB!!\u0011\u000bB.\u001b\t\u0011\u0019F\u0003\u0003\u0003V\t]\u0013!B7pI\u0016d'b\u0001B-W\u0006\u0019!n\u001c2\n\t\tu#1\u000b\u0002\u000e\u0015>\u0014\u0007+\u0019:b[\u0016$XM]:\t\u000f\t\u0005t\u00031\u0001\u0003\b\u0005Qq/\u001b;i\u000bZ,g\u000e^:\t\u000f\t\u0015t\u00031\u0001\u0003\b\u0005qq/\u001b;i)\"\u0014Xm\u001d5pY\u0012\u001c\u0018!H7fCN,(/Z:J]R,wM]1uS>tG\u0005Z3gCVdG\u000fJ\u0019\u0002;5,\u0017m];sKNLe\u000e^3he\u0006$\u0018n\u001c8%I\u00164\u0017-\u001e7uIQ\nQ$\\3bgV\u0014Xm]%oi\u0016<'/\u0019;j_:$C-\u001a4bk2$H%N\u0001\u0018aJ,G-T3bgV\u0014Xm]%oi\u0016<'/\u0019;j_:$\"B!\u001d\u0003x\te$1\u0010B?)\u0019\tIJa\u001d\u0003v!9\u0011Q[\u000eA\u0004\u0005]\u0007bBA\u00007\u0001\u000f\u0011q\u0010\u0005\b\u0005\u007fY\u0002\u0019AAt\u0011\u001d\u0011\u0019b\u0007a\u0001\u0003\u007fB\u0011B!\u0012\u001c!\u0003\u0005\rAa\u0002\t\u0013\t%3\u0004%AA\u0002\t\u001d\u0011!\t9sK\u0012lU-Y:ve\u0016\u001c\u0018J\u001c;fOJ\fG/[8oI\u0011,g-Y;mi\u0012\u001a\u0014!\t9sK\u0012lU-Y:ve\u0016\u001c\u0018J\u001c;fOJ\fG/[8oI\u0011,g-Y;mi\u0012\"\u0014\u0001\b9sK\u0012lU-Y:ve\u0016\u001c8)\u00197m/&$\bNV1sS\u0006\u0014G.\u001a\u000b\u000b\u0005\u000f\u0013iIa$\u0003\u0012\nUECBAM\u0005\u0013\u0013Y\tC\u0004\u0002Vz\u0001\u001d!a6\t\u000f\u0005}h\u0004q\u0001\u0002\u0000!9!q\b\u0010A\u0002\u0005\u001d\bb\u0002B\n=\u0001\u0007\u0011q\u0010\u0005\b\u0005's\u0002\u0019AA@\u0003!1\u0018M]5bE2,\u0007b\u0002BL=\u0001\u0007!\u0011T\u0001\fY\u0006\u001cH/T3bgV\u0014X\rE\u0002y\u00057K1A!(z\u0005MA\u0015\u0010\u001a:p\u0007\"\u0014xN\\5d\u001b\u0016\f7/\u001e:f\u0003Y\u0011X-\u00193t\u0007>$Wm\u001d%zIJ|\u0007o\u001c:uC&dWC\u0001BR!\u0019\tIK!*\u0003*&!!qUAV\u0005\u0015\u0011V-\u00193t!\u0019\t\u0019Ma+\u0002\u0000%!!QVAi\u0005\u0011a\u0015n\u001d;\u0002/I,\u0017\rZ:D_\u0012,7\u000fS=ee>\u0004xN\u001d;bS2\u0004\u0013\u0001E4fiN#\u0018\r^5p]N\u001cu\u000eZ3t)\u0019\u0011)La/\u0003LR!!q\u0017B]!\u0019\t\u0019-a9\u0002\u0000!9\u0011Q[\u0011A\u0004\u0005]\u0007b\u0002B_C\u0001\u0007!qX\u0001\bM&dG/\u001a:t!\u0011\u0011\tMa2\u000e\u0005\t\r'b\u0001BcK\u00051Am\\7bS:LAA!3\u0003D\nq\u0001*\u001f3s_*{'\rU1sC6\u001c\bb\u0002B'C\u0001\u0007!q\n\u0015\u0004\u0001\t=\u0007\u0003BA.\u0005#LAAa5\u0002^\tI1+\u001b8hY\u0016$xN\u001c")
public class HydrometryController
implements Model {
    private final WSClient ws;
    private final LogUtil LogUtil;
    private final HydrometryStationDao hydrometryStationDao;
    private final Aqua6boHydrometryDao aqua6boHydrometryDao;
    private final AnormHydroChronicImportDao AnormHydroChronicImportDao;
    private final StationThresholdDao stationThresholdDao;
    private final HydrometryEventDao HydrometryEventDao;
    private final HydroChronicDao HydroChronicDao;
    private final CityDao cityDao;
    private final PredImportDao PredImportDao;
    private final JobLogUtil JobLogUtil;
    private final Database db;
    private final ExecutionContextExecutor ec;
    private final Reads<List<String>> readsCodesHydroportail;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        HydrometryController hydrometryController = this;
        synchronized (hydrometryController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        HydrometryController hydrometryController = this;
        synchronized (hydrometryController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.HYDRO_MODEL_TOPIC();
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_HYDRO();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.integration(message);
            return;
        }
        if (string != null) {
            String string4 = string;
            this.LogUtil.info(new StringBuilder(19).append("Bad routing key => ").append(string4).toString(), this.LogUtil.info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    public String executeManually(JsValue message) {
        Seq<Object> results = this.integration(message);
        return Json$.MODULE$.toJson(results.map((Function1 & Serializable)id -> HydrometryController.$anonfun$executeManually$1(BoxesRunTime.unboxToInt((Object)id))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)GenericData$.MODULE$.writes())).toString();
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    private Seq<Object> integration(JsValue message) {
        return (Seq)message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            $this.LogUtil.error(new StringBuilder(21).append("Fail to parse json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.LogUtil.error$default$2());
            return (Seq)Nil$.MODULE$;
        }, (Function1 & Serializable)parameters -> {
            Seq seq;
            long jobExecutionId = parameters.jobExecutionId();
            String user = (String)parameters.user().getOrElse((Function0 & Serializable)() -> "HYDRO_JOB");
            Option debugMode = parameters.debugMode();
            if (!scala.sys.package$.MODULE$.env().contains((Object)"APPLICATION_TOKEN")) {
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Env APPLICATION_TOKEN is not in ENV", "", $this.JobLogUtil.log$default$5());
                return (Seq)Nil$.MODULE$;
            }
            try {
                boolean si = JobParametersUtil$.MODULE$.hasDataType((JobParameters)parameters, IntegrationType$.MODULE$.STATION_INTEGRATION());
                boolean di = ((IterableOnceOps)parameters.dataTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("DATA")));
                boolean dfi = JobParametersUtil$.MODULE$.hasDataType((JobParameters)parameters, IntegrationType$.MODULE$.DATA_FULL_INTEGRATION()) || JobParametersUtil$.MODULE$.hasDataType((JobParameters)parameters, ImportMode$.MODULE$.REPLACE_HISTO());
                boolean h = JobParametersUtil$.MODULE$.hasDataType((JobParameters)parameters, "heightIntegration");
                boolean d = JobParametersUtil$.MODULE$.hasDataType((JobParameters)parameters, "debitIntegration");
                boolean withThresholds = JobParametersUtil$.MODULE$.hasDataType((JobParameters)parameters, "withThresholds");
                boolean withEvents = JobParametersUtil$.MODULE$.hasDataType((JobParameters)parameters, "withEvents");
                boolean withPredData = JobParametersUtil$.MODULE$.hasDataType((JobParameters)parameters, "withPred");
                HydroJobParams filters = (HydroJobParams)JobUtil$.MODULE$.getFilters(parameters, jobExecutionId, $this.JobLogUtil, (Object)new HydroJobParams(HydroJobParams$.MODULE$.$lessinit$greater$default$1(), HydroJobParams$.MODULE$.$lessinit$greater$default$2(), HydroJobParams$.MODULE$.$lessinit$greater$default$3()), true, HydroJobParams$.MODULE$.jsonReads());
                Seq<String> stationsCodes = this.getStationsCodes(filters, (JobParameters)parameters, jobExecutionId);
                int total = stationsCodes.size();
                AtomicInteger counter = new AtomicInteger(0);
                Seq integratedStationIds = (Seq)stationsCodes.flatMap((Function1 & Serializable)code -> {
                    Option<Object> option = this.stationIntegration(si, (String)code, jobExecutionId, user, (Option<Object>)debugMode);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int id = BoxesRunTime.unboxToInt((Object)some.value());
                        return new .colon.colon((Object)new Tuple2(code, (Object)BoxesRunTime.boxToInteger((int)id)), (List)Nil$.MODULE$);
                    }
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "Station not found", code, $this.JobLogUtil.log$default$5());
                    counter.incrementAndGet();
                    return Nil$.MODULE$;
                });
                Seq futures = (Seq)((IterableOps)integratedStationIds.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Tuple2 codeId = (Tuple2)tuple2._1();
                        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
                            Tuple2 tuple2 = codeId;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            String code = (String)tuple2._1();
                            int id = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = new Tuple2((Object)code, (Object)BoxesRunTime.boxToInteger((int)id));
                            String code2 = (String)tuple22._1();
                            int id2 = tuple22._2$mcI$sp();
                            if (di || dfi) {
                                $this.JobLogUtil.debug(jobExecutionId, new StringBuilder(61).append("Start data integration (height : ").append(h).append(" and flow : ").append(d).append(") for station : ").append(code2).toString(), code2, $this.JobLogUtil.debug$default$4(), debugMode);
                                this.measuresIntegration(dfi, id2, code2, h, d, (JobParameters)parameters, withEvents, withThresholds, jobExecutionId, user, (Option<Object>)debugMode);
                                $this.JobLogUtil.debug(jobExecutionId, new StringBuilder(40).append("End integration for station with code : ").append(code2).toString(), code2, $this.JobLogUtil.debug$default$4(), debugMode);
                                if (withPredData) {
                                    this.predMeasuresIntegration(id2, code2, h, d, jobExecutionId, user);
                                }
                                int done = counter.incrementAndGet();
                                int progress = (int)((double)done / (double)total * (double)100);
                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.PROGRESS(), Integer.toString(progress), "", $this.JobLogUtil.log$default$5());
                                return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id2}));
                            }
                            counter.incrementAndGet();
                            return (Seq)Nil$.MODULE$;
                        }, (ExecutionContext)this.ec());
                    }
                    throw new MatchError((Object)tuple2);
                });
                Seq importedIds = (Seq)((IterableOps)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((IterableOnce)futures, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.ec()), (Duration)Duration$.MODULE$.Inf())).flatten(Predef$.MODULE$.$conforms());
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.STATION_IDS(), importedIds.mkString(","), "", $this.JobLogUtil.log$default$5());
                seq = importedIds;
            }
            catch (InterruptedException interruptedException) {
                seq = (Seq)Nil$.MODULE$;
            }
            catch (Aqua6boHydrometryDao.BanqueHydroTimeoutException e) {
                e.printStackTrace();
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Site hydro.eaufrance.fr injoignable", e.code(), $this.JobLogUtil.log$default$5());
                $this.LogUtil.printError((Throwable)e);
                seq = (Seq)Nil$.MODULE$;
            }
            catch (Exception e) {
                e.printStackTrace();
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(25).append("Error during execution : ").append(e.getMessage()).toString(), "", $this.JobLogUtil.log$default$5());
                $this.LogUtil.printError((Throwable)e);
                seq = (Seq)Nil$.MODULE$;
            }
            return seq;
        });
    }

    public Option<Object> stationIntegration(boolean importStation, String code, long jobExecutionId, String user, Option<Object> debugMode) {
        this.JobLogUtil.checkExecutionAbort(jobExecutionId);
        if (importStation) {
            Option<BHStation> option = this.aqua6boHydrometryDao.getStation(code, jobExecutionId);
            if (option instanceof Some) {
                Some some = (Some)option;
                BHStation bhStation = (BHStation)some.value();
                this.JobLogUtil.debug(jobExecutionId, new StringBuilder(40).append("Start station integration for station : ").append(code).toString(), code, this.JobLogUtil.debug$default$4(), debugMode);
                bhStation.townCode().foreach((Function1 & Serializable)cityCode -> this.cityDao.createCities((Seq)new .colon.colon((Object)new City(StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(new StringBuilder(1).append("0").append(Integer.toString(BoxesRunTime.unboxToInt((Object)cityCode))).toString()), 5), bhStation.townName(), City$.MODULE$.$lessinit$greater$default$3(), City$.MODULE$.$lessinit$greater$default$4(), City$.MODULE$.$lessinit$greater$default$5(), City$.MODULE$.$lessinit$greater$default$6(), City$.MODULE$.$lessinit$greater$default$7(), City$.MODULE$.$lessinit$greater$default$8(), City$.MODULE$.$lessinit$greater$default$9(), City$.MODULE$.$lessinit$greater$default$10(), City$.MODULE$.$lessinit$greater$default$11(), City$.MODULE$.$lessinit$greater$default$12(), City$.MODULE$.$lessinit$greater$default$13(), City$.MODULE$.$lessinit$greater$default$14(), City$.MODULE$.$lessinit$greater$default$15()), (List)Nil$.MODULE$)));
                Option<HydrometryStation> option2 = this.hydrometryStationDao.get(code);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    HydrometryStation stationFound = (HydrometryStation)some2.value();
                    Tuple2<Object, Object> tuple2 = this.hydrometryStationDao.update((int)stationFound.id(), bhStation, (Option<String>)new Some((Object)user), jobExecutionId);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int id = tuple2._1$mcI$sp();
                    int result = tuple2._2$mcI$sp();
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(id, result);
                    int id2 = sp2._1$mcI$sp();
                    int result2 = sp2._2$mcI$sp();
                    if (result2 > 0) {
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Station updated with success.", code, this.JobLogUtil.log$default$5());
                    } else {
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "Station found, but no update done in database.", code, this.JobLogUtil.log$default$5());
                    }
                    return new Some((Object)BoxesRunTime.boxToInteger((int)id2));
                }
                if (None$.MODULE$.equals(option2)) {
                    Tuple2<Object, Object> tuple2 = this.hydrometryStationDao.insert(bhStation, (Option<String>)new Some((Object)user), jobExecutionId);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int id = tuple2._1$mcI$sp();
                    int result = tuple2._2$mcI$sp();
                    Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(id, result);
                    int id3 = sp3._1$mcI$sp();
                    int result3 = sp3._2$mcI$sp();
                    if (result3 > 0) {
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Station created with success.", code, this.JobLogUtil.log$default$5());
                    } else {
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Station not found and not created in database.", code, this.JobLogUtil.log$default$5());
                    }
                    return new Some((Object)BoxesRunTime.boxToInteger((int)id3));
                }
                throw new MatchError(option2);
            }
            if (None$.MODULE$.equals(option)) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(83).append("Station not found on Banque Hydro, url : ").append(scala.sys.package$.MODULE$.env().getOrElse((Object)"AQUA6BO_URL", (Function0 & Serializable)() -> "https://aqua6bo2.aquadb.fr")).append("/data/hydrometry/banquehydro/station?code=").append(code).toString(), code, this.JobLogUtil.log$default$5());
                return None$.MODULE$;
            }
            throw new MatchError(option);
        }
        return this.hydrometryStationDao.get(code).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)HydrometryController.$anonfun$stationIntegration$3(x$5)));
    }

    public boolean stationIntegration$default$1() {
        return true;
    }

    public void measuresIntegration(boolean fullIntegration, int stationId, String code, boolean height, boolean debit, JobParameters parameters, boolean withEvents, boolean withThresholds, long jobExecutionId, String user, Option<Object> debugMode) {
        this.JobLogUtil.checkExecutionAbort(jobExecutionId);
        if (height || debit) {
            Option x$1 = ((IterableOnceOps)parameters.dataTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.startsWith("DATA")));
            Option<Object> x$2 = ImportOptions$.MODULE$.apply$default$1();
            Option<Object> x$3 = ImportOptions$.MODULE$.apply$default$3();
            Option<String> x$4 = ImportOptions$.MODULE$.apply$default$4();
            Option<Object> x$5 = ImportOptions$.MODULE$.apply$default$5();
            Option<Seq<Object>> x$62 = ImportOptions$.MODULE$.apply$default$6();
            Option<Object> x$72 = ImportOptions$.MODULE$.apply$default$7();
            ImportOptions importOptions = new ImportOptions(x$2, (Option<String>)x$1, x$3, x$4, x$5, x$62, x$72);
            if (height) {
                None$ lastDate = fullIntegration ? None$.MODULE$ : this.AnormHydroChronicImportDao.getLastDateConnect(stationId, 4, this.AnormHydroChronicImportDao.getLastDateConnect$default$3()).map((Function1 & Serializable)d -> d.plusMillis(1));
                this.JobLogUtil.debug(jobExecutionId, new StringBuilder(19).append("Last height date : ").append(lastDate.map((Function1 & Serializable)d -> d.toString("dd/MM/YYYY")).getOrElse((Function0 & Serializable)() -> "")).toString(), code, this.JobLogUtil.debug$default$4(), debugMode);
                Seq<GenericData> heights = this.aqua6boHydrometryDao.getHeights(code, (Option<DateTime>)lastDate, jobExecutionId);
                if (heights.isEmpty()) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No new height measures", code, this.JobLogUtil.log$default$5());
                } else {
                    this.JobLogUtil.debug(jobExecutionId, "Start height measures integration into database...", code, this.JobLogUtil.debug$default$4(), debugMode);
                    int results = this.AnormHydroChronicImportDao.importMeasuresConnect(stationId, code, (String)parameters.user().getOrElse((Function0 & Serializable)() -> "ADMIN"), jobExecutionId, heights, (Option<ImportOptions>)new Some((Object)importOptions));
                    if (results > 0) {
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(28).append(results).append(" height measures integrated.").toString(), code, this.JobLogUtil.log$default$5());
                    }
                    if (results == 0) {
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No new height measures imported", code, this.JobLogUtil.log$default$5());
                    }
                }
                if (withThresholds) {
                    Seq thresholds = (Seq)((IterableOps)this.aqua6boHydrometryDao.getBanqueHydroThresholds(code, "H", jobExecutionId).map((Function1 & Serializable)x$7 -> x$7.toStationThreshold(4))).map((Function1 & Serializable)t -> {
                        Some x$8 = ((String)t.name().getOrElse((Function0 & Serializable)() -> "")).contains("DSAR") ? new Some((Object)"#FF0000") : (((String)t.name().getOrElse((Function0 & Serializable)() -> "")).contains("DSA") ? new Some((Object)"#FF9000") : (((String)t.name().getOrElse((Function0 & Serializable)() -> "")).contains("DCR") ? new Some((Object)"#000000") : t.htmlColor()));
                        None$ x$9 = scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DSV", "DSA", "DCR", "DOE", "Autre (Etiage - Vigilance)", "Autre (Etiage - Alerte)", "Autre (Etiage - Vigilance Renforc\u00e9e)", "Autre (Etiage - Alerte Renforc\u00e9e)"})).exists((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)HydrometryController.$anonfun$measuresIntegration$12(t, c))) ? None$.MODULE$ : new Some((Object)"1");
                        Option x$10 = t.copy$default$1();
                        Option x$11 = t.copy$default$2();
                        Option x$12 = t.copy$default$3();
                        Option x$13 = t.copy$default$4();
                        Option x$14 = t.copy$default$5();
                        Option x$15 = t.copy$default$6();
                        Option x$16 = t.copy$default$8();
                        Option x$17 = t.copy$default$9();
                        Option x$18 = t.copy$default$10();
                        Option x$19 = t.copy$default$11();
                        Option x$20 = t.copy$default$12();
                        Option x$21 = t.copy$default$13();
                        Option x$22 = t.copy$default$14();
                        Option x$23 = t.copy$default$15();
                        Option x$24 = t.copy$default$16();
                        Option x$25 = t.copy$default$17();
                        Option x$26 = t.copy$default$18();
                        Option x$27 = t.copy$default$19();
                        Option x$28 = t.copy$default$20();
                        Option x$29 = t.copy$default$22();
                        return t.copy(x$10, x$11, x$12, x$13, x$14, x$15, (Option)x$9, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, (Option)x$8, x$29);
                    });
                    Seq oldThresholds = (Seq)this.stationThresholdDao.get(Integer.toString(stationId), StationTypeUtil$.MODULE$.HYDROMETRY()).filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)HydrometryController.$anonfun$measuresIntegration$14(x$8)));
                    Seq thresholdsProcessed = AlgoUtil$.MODULE$.uniqBy((Seq)oldThresholds.$plus$plus((IterableOnce)thresholds), (Function1 & Serializable)t -> new StringBuilder(1).append((String)t.name().getOrElse((Function0 & Serializable)() -> "")).append(":").append(Double.toString(MathUtil$.MODULE$.roundAt2(BoxesRunTime.unboxToDouble((Object)t.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))))).toString());
                    int tUpdated = this.stationThresholdDao.updateWithDataType(Integer.toString(stationId), StationTypeUtil$.MODULE$.HYDROMETRY(), 4, thresholdsProcessed);
                    if (tUpdated > 0) {
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(20).append(tUpdated).append(" thresholds updated.").toString(), code, this.JobLogUtil.log$default$5());
                    }
                }
            }
            if (debit) {
                None$ lastDate = fullIntegration ? None$.MODULE$ : this.AnormHydroChronicImportDao.getLastDateConnect(stationId, 5, this.AnormHydroChronicImportDao.getLastDateConnect$default$3()).map((Function1 & Serializable)d -> d.plusMillis(1));
                this.JobLogUtil.debug(jobExecutionId, new StringBuilder(17).append("Last flow date : ").append(lastDate.map((Function1 & Serializable)d -> d.toString("dd/MM/YYYY")).getOrElse((Function0 & Serializable)() -> "")).toString(), code, this.JobLogUtil.debug$default$4(), debugMode);
                Seq<GenericData> debits = this.aqua6boHydrometryDao.getDebits(code, (Option<DateTime>)lastDate, jobExecutionId);
                if (debits.isEmpty()) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No new flow measures", code, this.JobLogUtil.log$default$5());
                } else {
                    this.JobLogUtil.debug(jobExecutionId, "Start flow measures integration into database...", code, this.JobLogUtil.debug$default$4(), debugMode);
                    int results = this.AnormHydroChronicImportDao.importMeasuresConnect(stationId, code, (String)parameters.user().getOrElse((Function0 & Serializable)() -> "ADMIN"), jobExecutionId, debits, (Option<ImportOptions>)new Some((Object)importOptions));
                    if (results > 0) {
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(26).append(results).append(" flow measures integrated.").toString(), code, this.JobLogUtil.log$default$5());
                    }
                    if (results == 0) {
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No new flow measures imported", code, this.JobLogUtil.log$default$5());
                    }
                }
                if (withThresholds) {
                    Seq thresholds = (Seq)((IterableOps)this.aqua6boHydrometryDao.getBanqueHydroThresholds(code, "Q", jobExecutionId).map((Function1 & Serializable)x$9 -> x$9.toStationThreshold(5))).map((Function1 & Serializable)t -> {
                        Some x$30 = ((String)t.name().getOrElse((Function0 & Serializable)() -> "")).contains("DSAR") ? new Some((Object)"#FF0000") : (((String)t.name().getOrElse((Function0 & Serializable)() -> "")).contains("DSA") ? new Some((Object)"#FF9000") : (((String)t.name().getOrElse((Function0 & Serializable)() -> "")).contains("DCR") ? new Some((Object)"#000000") : t.htmlColor()));
                        None$ x$31 = scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DSV", "DSA", "DCR", "DOE", "Autre (Etiage - Vigilance)", "Autre (Etiage - Alerte)", "Autre (Etiage - Vigilance Renforc\u00e9e)", "Autre (Etiage - Alerte Renforc\u00e9e)"})).exists((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)HydrometryController.$anonfun$measuresIntegration$27(t, c))) ? None$.MODULE$ : new Some((Object)"1");
                        Option x$32 = t.copy$default$1();
                        Option x$33 = t.copy$default$2();
                        Option x$34 = t.copy$default$3();
                        Option x$35 = t.copy$default$4();
                        Option x$36 = t.copy$default$5();
                        Option x$37 = t.copy$default$6();
                        Option x$38 = t.copy$default$8();
                        Option x$39 = t.copy$default$9();
                        Option x$40 = t.copy$default$10();
                        Option x$41 = t.copy$default$11();
                        Option x$42 = t.copy$default$12();
                        Option x$43 = t.copy$default$13();
                        Option x$44 = t.copy$default$14();
                        Option x$45 = t.copy$default$15();
                        Option x$46 = t.copy$default$16();
                        Option x$47 = t.copy$default$17();
                        Option x$48 = t.copy$default$18();
                        Option x$49 = t.copy$default$19();
                        Option x$50 = t.copy$default$20();
                        Option x$51 = t.copy$default$22();
                        return t.copy(x$32, x$33, x$34, x$35, x$36, x$37, (Option)x$31, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, (Option)x$30, x$51);
                    });
                    Seq oldThresholds = (Seq)this.stationThresholdDao.get(Integer.toString(stationId), StationTypeUtil$.MODULE$.HYDROMETRY()).filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)HydrometryController.$anonfun$measuresIntegration$29(x$10)));
                    Seq thresholdsProcessed = AlgoUtil$.MODULE$.uniqBy((Seq)oldThresholds.$plus$plus((IterableOnce)thresholds), (Function1 & Serializable)t -> new StringBuilder(1).append((String)t.name().getOrElse((Function0 & Serializable)() -> "")).append(":").append(Double.toString(MathUtil$.MODULE$.roundAt2(BoxesRunTime.unboxToDouble((Object)t.value().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0))))).toString());
                    int tUpdated = this.stationThresholdDao.updateWithDataType(Integer.toString(stationId), StationTypeUtil$.MODULE$.HYDROMETRY(), 5, thresholdsProcessed);
                    if (tUpdated > 0) {
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(20).append(tUpdated).append(" thresholds updated.").toString(), code, this.JobLogUtil.log$default$5());
                    }
                }
            }
            if (withEvents) {
                Seq<BHEvent> events = this.aqua6boHydrometryDao.getBanqueHydroEvents(code, jobExecutionId);
                int eUpdated = BoxesRunTime.unboxToInt((Object)this.db.withConnection((Function1 & Serializable)c -> BoxesRunTime.boxToInteger((int)this.HydrometryEventDao.setHydroEventsWCForJob((Seq)events.map((Function1 & Serializable)x$11 -> x$11.toHydroEvent(stationId$1, jobExecutionId$2)), user, stationId, JobType$.MODULE$.HYDRO(), c))));
                if (eUpdated > 0) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(16).append(eUpdated).append(" events updated.").toString(), code, this.JobLogUtil.log$default$5());
                    return;
                }
                return;
            }
            return;
        }
    }

    public boolean measuresIntegration$default$1() {
        return false;
    }

    public boolean measuresIntegration$default$4() {
        return true;
    }

    public boolean measuresIntegration$default$5() {
        return true;
    }

    private void predMeasuresIntegration(int stationId, String code, boolean height, boolean debit, long jobExecutionId, String user) {
        if (height) {
            this.HydroChronicDao.getLastMeasures((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{stationId})), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), this.HydroChronicDao.getLastMeasures$default$3()).headOption().foreach((Function1 & Serializable)lastHeight -> {
                this.predMeasuresCallWithVariable(stationId, code, "H", lastHeight, jobExecutionId, user);
                return BoxedUnit.UNIT;
            });
        }
        if (debit) {
            this.HydroChronicDao.getLastMeasures((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{stationId})), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})), this.HydroChronicDao.getLastMeasures$default$3()).headOption().foreach((Function1 & Serializable)lastFlow -> {
                this.predMeasuresCallWithVariable(stationId, code, "Q", lastFlow, jobExecutionId, user);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private boolean predMeasuresIntegration$default$3() {
        return true;
    }

    private boolean predMeasuresIntegration$default$4() {
        return true;
    }

    private void predMeasuresCallWithVariable(int stationId, String code, String variable, HydroChronicMeasure lastMeasure, long jobExecutionId, String user) {
        Reads readsVigicruePred = JsPath$.MODULE$.$bslash("Simul").$bslash("Prevs").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), VigicruePredMeasure$.MODULE$.format()));
        String url = new StringBuilder(108).append("https://www.vigicrues.gouv.fr/services/previsions.json/index.php?CdStationHydro=").append(code).append("&GrdSimul=").append(variable).append("&FormatSortie=json").toString();
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(45).append("Call Vigicrues pred measures for variable ").append(variable).append(" : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
        Either either = (Either)Await$.MODULE$.result(WSUtil$.MODULE$.simpleGetWithReads(url, readsVigicruePred, this.ws), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes());
        if (either instanceof Right) {
            Right right = (Right)either;
            Exception e = (Exception)right.value();
            if (e.getMessage().contains("/Simul/Prevs,List(JsonValidationError(List(error.path.missing")) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(34).append("No pred measures found for viable ").append(variable).toString(), code, this.JobLogUtil.log$default$5());
                return;
            }
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(53).append("Error with Call Vigicrues pred measures for variable ").append(variable).toString(), code, this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), code, this.JobLogUtil.log$default$5());
            this.LogUtil.printError((Throwable)e);
            return;
        }
        if (either instanceof Left) {
            PredMeasure first;
            Left left = (Left)either;
            Seq measures = (Seq)left.value();
            if (measures.isEmpty()) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(46).append("No Vigicrues pred measures found for variable ").append(variable).toString(), code, this.JobLogUtil.log$default$5());
                return;
            }
            DateTime simulationDate = lastMeasure.date();
            String string = variable;
            String string2 = "H";
            String source = new StringBuilder(20).append("Pr\u00e9vision Vigicrues ").append((Object)(!(string != null ? !string.equals(string2) : string2 != null) ? "Hauteur" : "D\u00e9bit")).toString();
            Seq sorted = (Seq)measures.sortBy((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)HydrometryController.$anonfun$predMeasuresCallWithVariable$1(x$12)), (Ordering)Ordering.Long$.MODULE$);
            Seq preds = (Seq)sorted.map((Function1 & Serializable)m -> {
                int x$1 = stationId;
                String string = variable;
                String string2 = "H";
                int x$2 = !(string != null ? !string.equals(string2) : string2 != null) ? 4 : 5;
                DateTime x$3 = simulationDate;
                DateTime x$4 = m.DtPrev();
                Some x$5 = new Some((Object)BoxesRunTime.boxToDouble((double)m.ResMoyPrev()));
                String x$6 = source;
                Some x$7 = new Some((Object)BoxesRunTime.boxToDouble((double)m.ResMinPrev()));
                Some x$8 = new Some((Object)BoxesRunTime.boxToDouble((double)m.ResMaxPrev()));
                Some x$9 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId));
                String x$10 = user;
                int x$11 = Hours.hoursBetween((ReadablePartial)simulationDate.toLocalDateTime(), (ReadablePartial)((VigicruePredMeasure)sorted.last()).DtPrev().toLocalDateTime()).getHours();
                String x$12 = "hours";
                int x$13 = Hours.hoursBetween((ReadablePartial)simulationDate.toLocalDateTime(), (ReadablePartial)m.DtPrev().toLocalDateTime()).getHours();
                Option x$14 = PredMeasure$.MODULE$.$lessinit$greater$default$7();
                DateTime x$15 = PredMeasure$.MODULE$.$lessinit$greater$default$11();
                DateTime x$16 = PredMeasure$.MODULE$.$lessinit$greater$default$12();
                Option x$17 = PredMeasure$.MODULE$.$lessinit$greater$default$14();
                Option x$18 = PredMeasure$.MODULE$.$lessinit$greater$default$15();
                return new PredMeasure(x$1, x$2, x$3, x$4, (Option)x$5, x$6, x$14, (Option)x$7, (Option)x$8, (Option)x$9, x$15, x$16, x$10, x$17, x$18, x$11, "hours", x$13);
            });
            int x$19 = stationId;
            String string3 = variable;
            String string4 = "H";
            int x$20 = !(string3 != null ? !string3.equals(string4) : string4 != null) ? 4 : 5;
            DateTime x$21 = simulationDate;
            DateTime x$22 = lastMeasure.date();
            Option x$23 = lastMeasure.value();
            String x$24 = source;
            Option x$25 = lastMeasure.value();
            Option x$26 = lastMeasure.value();
            Some x$27 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId));
            String x$28 = user;
            int x$29 = Hours.hoursBetween((ReadablePartial)simulationDate.toLocalDateTime(), (ReadablePartial)((VigicruePredMeasure)sorted.last()).DtPrev().toLocalDateTime()).getHours();
            String x$30 = "hours";
            boolean x$31 = false;
            Option x$32 = PredMeasure$.MODULE$.$lessinit$greater$default$7();
            DateTime x$33 = PredMeasure$.MODULE$.$lessinit$greater$default$11();
            DateTime x$34 = PredMeasure$.MODULE$.$lessinit$greater$default$12();
            Option x$35 = PredMeasure$.MODULE$.$lessinit$greater$default$14();
            Option x$36 = PredMeasure$.MODULE$.$lessinit$greater$default$15();
            PredMeasure predMeasure = first = new PredMeasure(x$19, x$20, x$21, x$22, x$23, x$24, x$32, x$25, x$26, (Option)x$27, x$33, x$34, x$28, x$35, x$36, x$29, "hours", 0);
            int res = this.PredImportDao.importMeasures(stationId, source, StationTypeUtil$.MODULE$.HYDROMETRY(), ImportMode$.MODULE$.REPLACE_DATA(), (Seq<PredMeasure>)((Seq)preds.$plus$colon((Object)predMeasure)));
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(47).append(res).append(" Vigicrues pred measures imported for variable ").append(variable).toString(), code, this.JobLogUtil.log$default$5());
            return;
        }
        throw new MatchError((Object)either);
    }

    private Reads<List<String>> readsCodesHydroportail() {
        return this.readsCodesHydroportail;
    }

    private Seq<String> getStationsCodes(HydroJobParams filters, JobParameters parameters, long jobExecutionId) {
        String string;
        block10: {
            string = (String)filters.stationsMode().getOrElse((Function0 & Serializable)() -> "stations");
            switch (string == null ? 0 : string.hashCode()) {
                case -1360151735: {
                    if ("cities".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 523904865: {
                    if ("departments".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 1318331839: {
                    if ("stations".equals(string)) {
                        return (Seq)parameters.parameters().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
                    }
                    break block10;
                }
                default: {
                    break block10;
                }
            }
            String codes = filters.stationsMode().contains((Object)"cities") ? ((IterableOnceOps)((IterableOps)filters.cities().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable)c -> new StringBuilder(32).append("hydro_entities_search[cities][]=").append((String)c).toString())).mkString("&") : ((IterableOnceOps)((IterableOps)filters.departments().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable)d -> new StringBuilder(37).append("hydro_entities_search[departments][]=").append((String)d).toString())).mkString("&");
            String url = new StringBuilder(66).append("https://hydro.eaufrance.fr/rechercher/ajax/entites-hydrometriques?").append(codes).toString();
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(42).append("Call hydroportail to get stations from ").append(filters.stationsMode().get()).append(" : ").append(url).toString(), "", this.JobLogUtil.log$default$5());
            Either either = (Either)Await$.MODULE$.result(WSUtil$.MODULE$.simpleGetWithReads(url, this.readsCodesHydroportail(), this.ws), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes());
            if (either instanceof Right) {
                Right right = (Right)either;
                Exception e = (Exception)right.value();
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(55).append("Error while getting stations codes from Hydroportail : ").append(e.getMessage()).toString(), "", this.JobLogUtil.log$default$5());
                this.logUtil().printError((Throwable)e);
                return (Seq)Nil$.MODULE$;
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                List list = (List)left.value();
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(33).append(list.length()).append(" stations found from hydroportail").toString(), "", this.JobLogUtil.log$default$5());
                return list;
            }
            throw new MatchError((Object)either);
        }
        throw new MatchError((Object)string);
    }

    public static final /* synthetic */ GenericData $anonfun$executeManually$1(int id) {
        DateTime x$1 = new DateTime();
        DateTime x$2 = new DateTime();
        int x$3 = id;
        None$ x$4 = None$.MODULE$;
        Option x$5 = GenericData$.MODULE$.$lessinit$greater$default$5();
        Option x$6 = GenericData$.MODULE$.$lessinit$greater$default$6();
        Option x$7 = GenericData$.MODULE$.$lessinit$greater$default$7();
        Option x$8 = GenericData$.MODULE$.$lessinit$greater$default$8();
        Option x$9 = GenericData$.MODULE$.$lessinit$greater$default$9();
        Option x$10 = GenericData$.MODULE$.$lessinit$greater$default$10();
        Option x$11 = GenericData$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = GenericData$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = GenericData$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = GenericData$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = GenericData$.MODULE$.$lessinit$greater$default$15();
        return new GenericData(x$1, x$2, (Option)x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
    }

    public static final /* synthetic */ int $anonfun$stationIntegration$3(HydrometryStation x$5) {
        return (int)x$5.id();
    }

    public static final /* synthetic */ boolean $anonfun$measuresIntegration$12(StationThreshold t$1, String c) {
        return ((String)t$1.name().getOrElse((Function0 & Serializable)() -> "")).contains(c);
    }

    public static final /* synthetic */ boolean $anonfun$measuresIntegration$14(StationThreshold x$8) {
        return x$8.dataType().contains((Object)BoxesRunTime.boxToInteger((int)4));
    }

    public static final /* synthetic */ boolean $anonfun$measuresIntegration$27(StationThreshold t$2, String c) {
        return ((String)t$2.name().getOrElse((Function0 & Serializable)() -> "")).contains(c);
    }

    public static final /* synthetic */ boolean $anonfun$measuresIntegration$29(StationThreshold x$10) {
        return x$10.dataType().contains((Object)BoxesRunTime.boxToInteger((int)5));
    }

    public static final /* synthetic */ long $anonfun$predMeasuresCallWithVariable$1(VigicruePredMeasure x$12) {
        return x$12.DtPrev().getMillis();
    }

    @Inject
    public HydrometryController(WSClient ws, LogUtil LogUtil2, HydrometryStationDao hydrometryStationDao, Aqua6boHydrometryDao aqua6boHydrometryDao, AnormHydroChronicImportDao AnormHydroChronicImportDao2, StationThresholdDao stationThresholdDao, HydrometryEventDao HydrometryEventDao2, HydroChronicDao HydroChronicDao2, CityDao cityDao, PredImportDao PredImportDao2, JobLogUtil JobLogUtil2, Database db) {
        this.ws = ws;
        this.LogUtil = LogUtil2;
        this.hydrometryStationDao = hydrometryStationDao;
        this.aqua6boHydrometryDao = aqua6boHydrometryDao;
        this.AnormHydroChronicImportDao = AnormHydroChronicImportDao2;
        this.stationThresholdDao = stationThresholdDao;
        this.HydrometryEventDao = HydrometryEventDao2;
        this.HydroChronicDao = HydroChronicDao2;
        this.cityDao = cityDao;
        this.PredImportDao = PredImportDao2;
        this.JobLogUtil = JobLogUtil2;
        this.db = db;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        this.ec = ExecutionContext$.MODULE$.fromExecutor((Executor)Executors.newFixedThreadPool(4));
        this.readsCodesHydroportail = JsPath$.MODULE$.$bslash("sites").read(Reads$.MODULE$.traversableReads(List$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.JsObjectReads())).map((Function1 & Serializable)sites -> sites.flatMap((Function1 & Serializable)site -> (Seq)((IterableOps)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)site), "stations").asOpt(Reads$.MODULE$.traversableReads(List$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.JsObjectReads())).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable)station -> (String)JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)station), "CdStationHydro").as((Reads)Reads$.MODULE$.StringReads()))));
        Statics.releaseFence();
    }
}

