/*
 * Decompiled with CFR 0.152.
 */
package hydrometry.dao.http;

import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.FileUtil$;
import fr.aquasys.utils.JobLogUtil;
import hydrometry.constant.HydrometryConstants$;
import hydrometry.dao.http.Aqua6boHydrometryDao$BanqueHydroTimeoutException$;
import hydrometry.domain.HydrometryObservationInput;
import hydrometry.domain.HydrometryObservationInput$;
import hydrometry.domain.banqueHydro.BHEvent;
import hydrometry.domain.banqueHydro.BHEvent$;
import hydrometry.domain.banqueHydro.BHMeasure;
import hydrometry.domain.banqueHydro.BHMeasure$;
import hydrometry.domain.banqueHydro.BHStation;
import hydrometry.domain.banqueHydro.BHStation$;
import hydrometry.domain.banqueHydro.BHThreshold;
import hydrometry.domain.banqueHydro.BHThreshold$;
import hydrometry.domain.hubeauSite.HubeauHydroResult;
import hydrometry.domain.hubeauSite.HubeauHydroResult$;
import hydrometry.domain.hubeauSite.HubeauHydroSite;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.Reads$;
import play.api.libs.ws.WSClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import util.WSUtil$;

@ScalaSignature(bytes="\u0006\u0005\t}g\u0001B\u0016-\u0001MB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ya\u000f\u0005\t\u000f\u0002\u0011\t\u0011)A\u0006\u0011\"A1\u000b\u0001B\u0001B\u0003-A\u000bC\u0003[\u0001\u0011\u00051\fC\u0003l\u0001\u0011\u0005A\u000eC\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002\"CA>\u0001E\u0005I\u0011AA?\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+C\u0011\"!(\u0001#\u0003%\t!! \t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\"I\u0011\u0011\u0016\u0001\u0012\u0002\u0013\u0005\u0011Q\u0010\u0005\b\u0003W\u0003A\u0011AAW\u0011%\t9\rAI\u0001\n\u0003\ti\bC\u0004\u0002J\u0002!\t!a3\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0007\"CAy\u0001E\u0005I\u0011AA?\u0011\u001d\t\u0019\u0010\u0001C\u0003\u0003kDqAa\u0004\u0001\t\u0003\u0011\t\u0002C\u0004\u0003\"\u0001!\tAa\t\u0007\r\tE\u0002\u0001\u0011B\u001a\u0011%IxC!f\u0001\n\u0003\u00119\u0005C\u0005\u0003J]\u0011\t\u0012)A\u0005u\"1!l\u0006C\u0001\u0005\u0017B\u0011Ba\u0015\u0018\u0003\u0003%\tA!\u0016\t\u0013\tes#%A\u0005\u0002\tm\u0003\"\u0003B0/\u0005\u0005I\u0011\tB1\u0011%\u0011\thFA\u0001\n\u0003\u0011\u0019\bC\u0005\u0003v]\t\t\u0011\"\u0001\u0003x!I!1Q\f\u0002\u0002\u0013\u0005#Q\u0011\u0005\n\u0005';\u0012\u0011!C\u0001\u0005+C\u0011Ba(\u0018\u0003\u0003%\tE!)\t\u0013\t\u0015v#!A\u0005B\t\u001d\u0006\"\u0003BU/\u0005\u0005I\u0011\tBV\u000f%\u0011y\u000bAA\u0001\u0012\u0003\u0011\tLB\u0005\u00032\u0001\t\t\u0011#\u0001\u00034\"1!L\nC\u0001\u0005\u0017D\u0011B!4'\u0003\u0003%)Ea4\t\u0013\tEg%!A\u0005\u0002\nM\u0007\"\u0003BlM\u0005\u0005I\u0011\u0011Bm\u0005Q\t\u0015/^17E>D\u0015\u0010\u001a:p[\u0016$(/\u001f#b_*\u0011QFL\u0001\u0005QR$\bO\u0003\u00020a\u0005\u0019A-Y8\u000b\u0003E\n!\u0002[=ee>lW\r\u001e:z\u0007\u0001\u0019\"\u0001\u0001\u001b\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g\u0003\u001daunZ+uS2\u0004\"\u0001P#\u000e\u0003uR!AP \u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0001\u0006\u000b\u0001B]1cE&$X.\u001d\u0006\u0003\u0005\u000e\u000bq!Y9vCNL8OC\u0001E\u0003\t1'/\u0003\u0002G{\t9Aj\\4Vi&d\u0017AA<t!\tI\u0015+D\u0001K\u0015\t95J\u0003\u0002M\u001b\u0006!A.\u001b2t\u0015\tqu*A\u0002ba&T\u0011\u0001U\u0001\u0005a2\f\u00170\u0003\u0002S\u0015\nAqkU\"mS\u0016tG/\u0001\u0006K_\ndunZ+uS2\u0004\"!\u0016-\u000e\u0003YS!aV!\u0002\u000bU$\u0018\u000e\\:\n\u0005e3&A\u0003&pE2{w-\u0016;jY\u00061A(\u001b8jiz\"\u0012\u0001\u0018\u000b\u0005;~\u0003\u0017\r\u0005\u0002_\u00015\tA\u0006C\u0003;\t\u0001\u000f1\bC\u0003H\t\u0001\u000f\u0001\nC\u0003T\t\u0001\u000fA\u000b\u000b\u0002\u0005GB\u0011A-[\u0007\u0002K*\u0011amZ\u0001\u0007S:TWm\u0019;\u000b\u0003!\fQA[1wCbL!A[3\u0003\r%s'.Z2u\u0003)9W\r^*uCRLwN\u001c\u000b\u0005[b\fY\u0001E\u00026]BL!a\u001c\u001c\u0003\r=\u0003H/[8o!\t\th/D\u0001s\u0015\t\u0019H/A\u0006cC:\fX/\u001a%zIJ|'BA;1\u0003\u0019!w.\\1j]&\u0011qO\u001d\u0002\n\u0005\"\u001bF/\u0019;j_:DQ!_\u0003A\u0002i\fAaY8eKB\u001910!\u0002\u000f\u0007q\f\t\u0001\u0005\u0002~m5\taP\u0003\u0002\u0000e\u00051AH]8pizJ1!a\u00017\u0003\u0019\u0001&/\u001a3fM&!\u0011qAA\u0005\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0001\u001c\t\u000f\u00055Q\u00011\u0001\u0002\u0010\u0005q!n\u001c2Fq\u0016\u001cW\u000f^5p]&#\u0007cA\u001b\u0002\u0012%\u0019\u00111\u0003\u001c\u0003\t1{gnZ\u0001\u000eO\u0016$\b*\u001e2fCV\u001cu\u000eZ3\u0015\r\u0005e\u00111DA\u000f!\r)dN\u001f\u0005\u0006s\u001a\u0001\rA\u001f\u0005\b\u0003\u001b1\u0001\u0019AA\b\u0003I9W\r\u001e\"b]F,X\rS=ee>\u001cu\u000eZ3\u0015\t\u0005e\u00111\u0005\u0005\u0006s\u001e\u0001\rA_\u0001\u0018G\u0006dGNQ1ocV,\u0007*\u001f3s_6+\u0017m];sKN$B\"!\u000b\u0002P\u0005E\u00131NA7\u0003c\u0002b!a\u000b\u00026\u0005mb\u0002BA\u0017\u0003cq1!`A\u0018\u0013\u00059\u0014bAA\u001am\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001c\u0003s\u00111aU3r\u0015\r\t\u0019D\u000e\t\u0005\u0003{\tY%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u0015iw\u000eZ3m\u0015\u0011\t)%a\u0012\u0002\u0007)|'MC\u0002\u0002J\u0005\u000bQ\u0001Z1fCVLA!!\u0014\u0002@\tYq)\u001a8fe&\u001cG)\u0019;b\u0011\u0015I\b\u00021\u0001{\u0011%\t\u0019\u0006\u0003I\u0001\u0002\u0004\t)&\u0001\u0003mCN$\b\u0003B\u001bo\u0003/\u0002B!!\u0017\u0002h5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0003uS6,'\u0002BA1\u0003G\nAA[8eC*\u0011\u0011QM\u0001\u0004_J<\u0017\u0002BA5\u00037\u0012\u0001\u0002R1uKRKW.\u001a\u0005\b\u0003\u001bA\u0001\u0019AA\b\u0011\u0019\ty\u0007\u0003a\u0001u\u0006YA-\u0019;b)f\u0004Xm\u0015;s\u0011\u001d\t\u0019\b\u0003a\u0001\u0003k\n\u0001\u0002Z1uCRK\b/\u001a\t\u0004k\u0005]\u0014bAA=m\t\u0019\u0011J\u001c;\u0002C\r\fG\u000e\u001c\"b]F,X\rS=ee>lU-Y:ve\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005}$\u0006BA+\u0003\u0003[#!a!\u0011\t\u0005\u0015\u0015qR\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001b3\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011SAD\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000bO\u0016$\b*Z5hQR\u001cH\u0003CA\u0015\u0003/\u000bI*a'\t\u000beT\u0001\u0019\u0001>\t\u0013\u0005M#\u0002%AA\u0002\u0005U\u0003bBA\u0007\u0015\u0001\u0007\u0011qB\u0001\u0015O\u0016$\b*Z5hQR\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002\u0013\u001d,G\u000fR3cSR\u001cH\u0003CA\u0015\u0003G\u000b)+a*\t\u000bed\u0001\u0019\u0001>\t\u0013\u0005MC\u0002%AA\u0002\u0005U\u0003bBA\u0007\u0019\u0001\u0007\u0011qB\u0001\u0014O\u0016$H)\u001a2jiN$C-\u001a4bk2$HEM\u0001\u0012O\u0016$x+\u001b;i\t\u0006$Xm\u00149uS>tG\u0003DAX\u0003s\u000bY,!0\u0002B\u0006\u0015\u0007CBA\u0016\u0003k\t\t\f\u0005\u0003\u00024\u0006UV\"\u0001;\n\u0007\u0005]FO\u0001\u000eIs\u0012\u0014x.\\3uef|%m]3sm\u0006$\u0018n\u001c8J]B,H\u000fC\u0003z\u001d\u0001\u0007!\u0010C\u0005\u0002T9\u0001\n\u00111\u0001\u0002V!1\u0011q\u0018\bA\u0002i\fqAY1tKV\u0013F\n\u0003\u0004\u0002D:\u0001\rA_\u0001\u0007g>,(oY3\t\u000f\u00055a\u00021\u0001\u0002\u0010\u0005Yr-\u001a;XSRDG)\u0019;f\u001fB$\u0018n\u001c8%I\u00164\u0017-\u001e7uII\n!bY1mYJ+7/\u001e7u)!\ty+!4\u0002R\u0006M\u0007BBAh!\u0001\u0007!0A\u0002ve2Da!a1\u0011\u0001\u0004Q\b\"B=\u0011\u0001\u0004Q\u0018!\u0002;p+JdGc\u0001>\u0002Z\"1\u0011qZ\tA\u0002i\fAdZ3u/&$\b\u000eR1uK>\u0003H/[8o\u0005\u0006t\u0017/^3Is\u0012\u0014x\u000e\u0006\u0006\u0002`\u0006\u001d\u0018\u0011^Av\u0003[\u0004b!a\u000b\u00026\u0005\u0005\bcA9\u0002d&\u0019\u0011Q\u001d:\u0003\u0013\tCU*Z1tkJ,\u0007\"B=\u0013\u0001\u0004Q\b\"CA*%A\u0005\t\u0019AA+\u0011\u001d\tiA\u0005a\u0001\u0003\u001fAa!a<\u0013\u0001\u0004Q\u0018aC7fCN,(/\u001a+za\u0016\faeZ3u/&$\b\u000eR1uK>\u0003H/[8o\u0005\u0006t\u0017/^3Is\u0012\u0014x\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0003U\u0019\u0017\r\u001c7SKN,H\u000e\u001e\"b]F,X\rS=ee>$B\"a8\u0002x\u0006e\u0018Q`A\u0000\u0005\u0003Aa!a4\u0015\u0001\u0004Q\bbBA~)\u0001\u0007\u0011q\\\u0001\u0010[\u0016\f7/\u001e:fg\u001a+Go\u00195fI\"9\u0011Q\u0002\u000bA\u0002\u0005=\u0001\"B=\u0015\u0001\u0004Q\bb\u0002B\u0002)\u0001\u0007\u0011QO\u0001\bCR$X-\u001c9uQ\r!\"q\u0001\t\u0005\u0005\u0013\u0011Y!\u0004\u0002\u0002\f&!!QBAF\u0005\u001d!\u0018-\u001b7sK\u000e\f\u0001dZ3u\u0005\u0006t\u0017/^3Is\u0012\u0014x\u000e\u00165sKNDw\u000e\u001c3t)!\u0011\u0019Ba\u0007\u0003\u001e\t}\u0001CBA\u0016\u0003k\u0011)\u0002E\u0002r\u0005/I1A!\u0007s\u0005-\u0011\u0005\n\u00165sKNDw\u000e\u001c3\t\u000be,\u0002\u0019\u0001>\t\r\u0005=X\u00031\u0001{\u0011\u001d\ti!\u0006a\u0001\u0003\u001f\tAcZ3u\u0005\u0006t\u0017/^3Is\u0012\u0014x.\u0012<f]R\u001cHC\u0002B\u0013\u0005[\u0011y\u0003\u0005\u0004\u0002,\u0005U\"q\u0005\t\u0004c\n%\u0012b\u0001B\u0016e\n9!\tS#wK:$\b\"B=\u0017\u0001\u0004Q\bbBA\u0007-\u0001\u0007\u0011q\u0002\u0002\u001c\u0005\u0006t\u0017/^3Is\u0012\u0014x\u000eV5nK>,H/\u0012=dKB$\u0018n\u001c8\u0014\u000f]\u0011)Da\u000f\u0003BA!\u00111\u0006B\u001c\u0013\u0011\u0011I$!\u000f\u0003\u0013\u0015C8-\u001a9uS>t\u0007cA\u001b\u0003>%\u0019!q\b\u001c\u0003\u000fA\u0013x\u000eZ;diB!\u00111\u0006B\"\u0013\u0011\u0011)%!\u000f\u0003\u0019M+'/[1mSj\f'\r\\3\u0016\u0003i\fQaY8eK\u0002\"BA!\u0014\u0003RA\u0019!qJ\f\u000e\u0003\u0001AQ!\u001f\u000eA\u0002i\fAaY8qsR!!Q\nB,\u0011\u001dI8\u0004%AA\u0002i\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003^)\u001a!0!!\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011\u0019\u0007\u0005\u0003\u0003f\t=TB\u0001B4\u0015\u0011\u0011IGa\u001b\u0002\t1\fgn\u001a\u0006\u0003\u0005[\nAA[1wC&!\u0011q\u0001B4\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)(\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\te$q\u0010\t\u0004k\tm\u0014b\u0001B?m\t\u0019\u0011I\\=\t\u0013\t\u0005u$!AA\u0002\u0005U\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\bB1!\u0011\u0012BH\u0005sj!Aa#\u000b\u0007\t5e'\u0001\u0006d_2dWm\u0019;j_:LAA!%\u0003\f\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u00119J!(\u0011\u0007U\u0012I*C\u0002\u0003\u001cZ\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0003\u0002\u0006\n\t\u00111\u0001\u0003z\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011\u0019Ga)\t\u0013\t\u0005%%!AA\u0002\u0005U\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005U\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0003\u0018\n5\u0006\"\u0003BAI\u0005\u0005\t\u0019\u0001B=\u0003m\u0011\u0015M\\9vK\"KHM]8US6,w.\u001e;Fq\u000e,\u0007\u000f^5p]B\u0019!q\n\u0014\u0014\u000b\u0019\u0012)L!1\u0011\u000f\t]&Q\u0018>\u0003N5\u0011!\u0011\u0018\u0006\u0004\u0005w3\u0014a\u0002:v]RLW.Z\u0005\u0005\u0005\u007f\u0013ILA\tBEN$(/Y2u\rVt7\r^5p]F\u0002BAa1\u0003J6\u0011!Q\u0019\u0006\u0005\u0005\u000f\u0014Y'\u0001\u0002j_&!!Q\tBc)\t\u0011\t,\u0001\u0005u_N#(/\u001b8h)\t\u0011\u0019'A\u0003baBd\u0017\u0010\u0006\u0003\u0003N\tU\u0007\"B=*\u0001\u0004Q\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u00033\u0011Y\u000eC\u0005\u0003^*\n\t\u00111\u0001\u0003N\u0005\u0019\u0001\u0010\n\u0019")
public class Aqua6boHydrometryDao {
    private volatile Aqua6boHydrometryDao$BanqueHydroTimeoutException$ BanqueHydroTimeoutException$module;
    private final LogUtil LogUtil;
    private final WSClient ws;
    private final JobLogUtil JobLogUtil;

    public Aqua6boHydrometryDao$BanqueHydroTimeoutException$ BanqueHydroTimeoutException() {
        if (this.BanqueHydroTimeoutException$module == null) {
            this.BanqueHydroTimeoutException$lzycompute$1();
        }
        return this.BanqueHydroTimeoutException$module;
    }

    public Option<BHStation> getStation(String code, long jobExecutionId) {
        String url = new StringBuilder(42).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"AQUA6BO_URL", (Function0 & Serializable)() -> "https://aqua6bo2.aquadb.fr")).append("/data/hydrometry/banquehydro/station?code=").append(code).toString();
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(11).append("Call url : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
        return WSUtil$.MODULE$.getWithAuthOneTry(url, 4, WSUtil$.MODULE$.getWithAuthOneTry$default$3(), WSUtil$.MODULE$.getWithAuthOneTry$default$4(), BHStation$.MODULE$.format(), this.ws);
    }

    public Option<String> getHubeauCode(String code, long jobExecutionId) {
        if (code.length() == 10) {
            return new Some((Object)code);
        }
        if (code.length() == 8) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(55).append("Fetching station codes from hubeau with site code : ").append(code).append("...").toString(), code, this.JobLogUtil.log$default$5());
            Option<HubeauHydroResult> option = WSUtil$.MODULE$.simpleGet(new StringBuilder(77).append("http://hubeau.eaufrance.fr/api/v1/hydrometrie/referentiel/stations?code_site=").append(code).toString(), WSUtil$.MODULE$.simpleGet$default$2(), WSUtil$.MODULE$.simpleGet$default$3(), HubeauHydroResult$.MODULE$.format(), this.ws);
            if (option instanceof Some) {
                Some some = (Some)option;
                HubeauHydroResult result = (HubeauHydroResult)some.value();
                if (result.count() == 0) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(71).append("Result found, but no station codes found with site code : ").append(code).append(", (count = 0)").toString(), code, this.JobLogUtil.log$default$5());
                    return None$.MODULE$;
                }
                if (result.count() == 1) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(21).append("Found station code : ").append(((HubeauHydroSite)result.data().head()).code_station()).toString(), code, this.JobLogUtil.log$default$5());
                    return new Some((Object)((HubeauHydroSite)result.data().head()).code_station());
                }
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "Multiple station codes found. Please relaunch the job with the station code you want.", code, this.JobLogUtil.log$default$5());
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(23).append("Stations codes found : ").append(((IterableOnceOps)result.data().map((Function1 & Serializable)d -> d.code_station())).mkString(",")).toString(), code, this.JobLogUtil.log$default$5());
                return None$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(65).append("Error while fetching station codes from hubeau, with site code : ").append(code).toString(), code, this.JobLogUtil.log$default$5());
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(88).append("url used : http://hubeau.eaufrance.fr/api/v1/hydrometrie/referentiel/stations?code_site=").append(code).toString(), code, this.JobLogUtil.log$default$5());
                return None$.MODULE$;
            }
            throw new MatchError(option);
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Station code must be 8 or 10 characters.", code, this.JobLogUtil.log$default$5());
        return None$.MODULE$;
    }

    public Option<String> getBanqueHydroCode(String code) {
        return new Some((Object)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(code.trim()), 10));
    }

    public Seq<GenericData> callBanqueHydroMeasures(String code, Option<DateTime> last, long jobExecutionId, String dataTypeStr, int dataType) {
        Seq<BHMeasure> banqueHydro;
        block9: {
            Seq<BHMeasure> seq;
            Option<String> option = this.getBanqueHydroCode(code);
            if (option instanceof Some) {
                Some some = (Some)option;
                String apiCode = (String)some.value();
                if (apiCode.length() == 8) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "Banque hydro codes with 8 characters is not advised, you should use a code with 10 characters.", code, this.JobLogUtil.log$default$5());
                }
                Seq<BHMeasure> measures = this.getWithDateOptionBanqueHydro(apiCode, last, jobExecutionId, dataTypeStr);
                if (dataType == 4) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(43).append(measures.length()).append(" height measures fetched from Banque Hydro.").toString(), code, this.JobLogUtil.log$default$5());
                }
                if (dataType == 5) {
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(41).append(measures.length()).append(" flow measures fetched from Banque Hydro.").toString(), code, this.JobLogUtil.log$default$5());
                }
                seq = measures;
            } else if (None$.MODULE$.equals(option)) {
                seq = (Seq<BHMeasure>)Nil$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            banqueHydro = seq;
            if (!last.isEmpty() || !banqueHydro.isEmpty()) break block9;
            if (dataType == 4) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No height measures found for this station.", code, this.JobLogUtil.log$default$5());
            }
            if (dataType == 5) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No flow measures found for this station.", code, this.JobLogUtil.log$default$5());
            }
        }
        return (Seq)banqueHydro.map((Function1 & Serializable)x$1 -> x$1.toGenericData(dataType));
    }

    public Option<DateTime> callBanqueHydroMeasures$default$2() {
        return None$.MODULE$;
    }

    public Seq<GenericData> getHeights(String code, Option<DateTime> last, long jobExecutionId) {
        return this.callBanqueHydroMeasures(code, last, jobExecutionId, "H", 4);
    }

    public Option<DateTime> getHeights$default$2() {
        return None$.MODULE$;
    }

    public Seq<GenericData> getDebits(String code, Option<DateTime> last, long jobExecutionId) {
        return this.callBanqueHydroMeasures(code, last, jobExecutionId, "Q", 5);
    }

    public Option<DateTime> getDebits$default$2() {
        return None$.MODULE$;
    }

    public Seq<HydrometryObservationInput> getWithDateOption(String code, Option<DateTime> last, String baseURL, String source, long jobExecutionId) {
        String dateParam = (String)last.map((Function1 & Serializable)d -> new StringBuilder(11).append("&beginDate=").append(Long.toString(d.getMillis())).toString()).getOrElse((Function0 & Serializable)() -> "");
        String url = new StringBuilder(0).append(baseURL).append(code).append(dateParam).toString();
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(19).append("Call url : ").append(url).append("&source=").append(source).toString(), code, this.JobLogUtil.log$default$5());
        return this.callResult(url, source, code);
    }

    public Option<DateTime> getWithDateOption$default$2() {
        return None$.MODULE$;
    }

    public Seq<HydrometryObservationInput> callResult(String url, String source, String code) {
        Seq seq;
        try {
            Option listOfMeasure = WSUtil$.MODULE$.getWithAuthOneTry(new StringBuilder(8).append(url).append("&source=").append(source).toString(), 4, WSUtil$.MODULE$.getWithAuthOneTry$default$3(), WSUtil$.MODULE$.getWithAuthOneTry$default$4(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), HydrometryObservationInput$.MODULE$.reads()), this.ws);
            seq = (Seq)((IterableOps)listOfMeasure.getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)m -> {
                Option<DateTime> date = m.date().isDefined() ? m.date() : m.measureDate();
                Some x$1 = new Some((Object)source);
                Option<DateTime> x$2 = date;
                Option<DateTime> x$3 = m.copy$default$1();
                double x$4 = m.copy$default$3();
                Option<String> x$5 = m.copy$default$4();
                Option<String> x$6 = m.copy$default$5();
                Option<String> x$7 = m.copy$default$6();
                Option<DateTime> x$8 = m.copy$default$7();
                Option<DateTime> x$9 = m.copy$default$8();
                Option<Object> x$10 = m.copy$default$9();
                Option<Object> x$11 = m.copy$default$10();
                Option<Object> x$12 = m.copy$default$11();
                Option<String> x$13 = m.copy$default$12();
                Option<String> x$14 = m.copy$default$13();
                Option<Object> x$15 = m.copy$default$14();
                Option<Object> x$16 = m.copy$default$15();
                Option<Object> x$17 = m.copy$default$16();
                Option<Object> x$18 = m.copy$default$17();
                return m.copy(x$3, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, (Option<String>)x$1);
            });
        }
        catch (TimeoutException te) {
            String string = source;
            String string2 = HydrometryConstants$.MODULE$.BANQUE_HYDRO_SOURCE();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new BanqueHydroTimeoutException(this, code);
            }
            throw te;
        }
        catch (Exception e) {
            throw e;
        }
        return seq;
    }

    public String toUrl(String url) {
        return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(FileUtil$.MODULE$.toPath(url)), 1)), 1).replace("https:/", "https://").replace("http:/", "http://");
    }

    public Seq<BHMeasure> getWithDateOptionBanqueHydro(String code, Option<DateTime> last, long jobExecutionId, String measureType) {
        String dateParam = (String)last.map((Function1 & Serializable)d -> new StringBuilder(11).append("&startDate=").append(Long.toString(d.getMillis())).toString()).getOrElse((Function0 & Serializable)() -> "");
        String url = this.toUrl(new StringBuilder(56).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"AQUA6BO_URL", (Function0 & Serializable)() -> "https://aqua6bo.aquadb.fr")).append("/data/hydrometry/banquehydro/measures?code=").append(code).append("&measureType=").append(measureType).append(dateParam).toString());
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(11).append("Call url : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
        return this.callResultBanqueHydro(url, (Seq<BHMeasure>)((Seq)Nil$.MODULE$), jobExecutionId, code, 4);
    }

    public Option<DateTime> getWithDateOptionBanqueHydro$default$2() {
        return None$.MODULE$;
    }

    public final Seq<BHMeasure> callResultBanqueHydro(String url, Seq<BHMeasure> measuresFetched, long jobExecutionId, String code, int attempt) {
        Either either;
        block4: {
            Option option;
            Seq measures;
            while (true) {
                Left left;
                Tuple2 tuple2;
                if ((either = (Either)Await$.MODULE$.result(WSUtil$.MODULE$.getWithAuthWithReads(url, BHMeasure$.MODULE$.readBH(), WSUtil$.MODULE$.getWithAuthWithReads$default$3(), WSUtil$.MODULE$.getWithAuthWithReads$default$4(), this.ws), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(15)).minutes())) instanceof Right) {
                    Right right = (Right)either;
                    Exception error = (Exception)right.value();
                    if (attempt == 3) {
                        this.LogUtil.printError((Throwable)error);
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(20).append("3 attempts failed : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
                        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(49).append("Error during aqua6BO banqueHydro call with url : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
                        return measuresFetched;
                    }
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(71).append("Attempt ").append(attempt).append(", Waiting 5s, Error during aqua6BO banqueHydro call with url : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
                    Thread.sleep(5000L);
                    ++attempt;
                    continue;
                }
                if (!(either instanceof Left) || (tuple2 = (Tuple2)(left = (Left)either).value()) == null) break block4;
                measures = (Seq)tuple2._1();
                Option nextUrlOpt = (Option)tuple2._2();
                option = nextUrlOpt;
                if (!(option instanceof Some)) break;
                Some some = (Some)option;
                String nextUrl = (String)some.value();
                attempt = 1;
                measuresFetched = (Seq)measuresFetched.$plus$plus((IterableOnce)measures);
                url = this.toUrl(new StringBuilder(6).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"AQUA6BO_URL", (Function0 & Serializable)() -> "https://aqua6bo.aquadb.fr")).append("/data/").append(nextUrl).toString());
            }
            if (None$.MODULE$.equals(option)) {
                return (Seq)measuresFetched.$plus$plus((IterableOnce)measures);
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)either);
    }

    public Seq<BHThreshold> getBanqueHydroThresholds(String code, String measureType, long jobExecutionId) {
        String url = this.toUrl(new StringBuilder(58).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"AQUA6BO_URL", (Function0 & Serializable)() -> "https://aqua6bo.aquadb.fr")).append("/data/hydrometry/banquehydro/thresholds?code=").append(code).append("&measureType=").append(measureType).toString());
        Option option = WSUtil$.MODULE$.getWithAuthOneTry(url, 4, WSUtil$.MODULE$.getWithAuthOneTry$default$3(), WSUtil$.MODULE$.getWithAuthOneTry$default$4(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), BHThreshold$.MODULE$.format()), this.ws);
        if (None$.MODULE$.equals(option)) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(60).append("Error during aqua6BO banqueHydro thresholds call with url : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
            return (Seq)Nil$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq res = (Seq)some.value();
            return res;
        }
        throw new MatchError(option);
    }

    public Seq<BHEvent> getBanqueHydroEvents(String code, long jobExecutionId) {
        String url = this.toUrl(new StringBuilder(41).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"AQUA6BO_URL", (Function0 & Serializable)() -> "https://aqua6bo.aquadb.fr")).append("/data/hydrometry/banquehydro/events?code=").append(code).toString());
        Option option = WSUtil$.MODULE$.getWithAuthOneTry(url, 4, WSUtil$.MODULE$.getWithAuthOneTry$default$3(), WSUtil$.MODULE$.getWithAuthOneTry$default$4(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), BHEvent$.MODULE$.format()), this.ws);
        if (None$.MODULE$.equals(option)) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(56).append("Error during aqua6BO banqueHydro events call with url : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
            return (Seq)Nil$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq res = (Seq)some.value();
            return res;
        }
        throw new MatchError(option);
    }

    private final void BanqueHydroTimeoutException$lzycompute$1() {
        Aqua6boHydrometryDao aqua6boHydrometryDao = this;
        synchronized (aqua6boHydrometryDao) {
            if (this.BanqueHydroTimeoutException$module == null) {
                this.BanqueHydroTimeoutException$module = new Aqua6boHydrometryDao$BanqueHydroTimeoutException$(this);
            }
        }
    }

    @Inject
    public Aqua6boHydrometryDao(LogUtil LogUtil2, WSClient ws, JobLogUtil JobLogUtil2) {
        this.LogUtil = LogUtil2;
        this.ws = ws;
        this.JobLogUtil = JobLogUtil2;
    }

    public class BanqueHydroTimeoutException
    extends Exception
    implements Product {
        private final String code;
        public final /* synthetic */ Aqua6boHydrometryDao $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String code() {
            return this.code;
        }

        public BanqueHydroTimeoutException copy(String code) {
            return new BanqueHydroTimeoutException(this.hydrometry$dao$http$Aqua6boHydrometryDao$BanqueHydroTimeoutException$$$outer(), code);
        }

        public String copy$default$1() {
            return this.code();
        }

        public String productPrefix() {
            return "BanqueHydroTimeoutException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.code();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BanqueHydroTimeoutException;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "code";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof BanqueHydroTimeoutException)) return false;
            if (((BanqueHydroTimeoutException)object).hydrometry$dao$http$Aqua6boHydrometryDao$BanqueHydroTimeoutException$$$outer() != this.hydrometry$dao$http$Aqua6boHydrometryDao$BanqueHydroTimeoutException$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            BanqueHydroTimeoutException banqueHydroTimeoutException = (BanqueHydroTimeoutException)x$1;
            String string = this.code();
            String string2 = banqueHydroTimeoutException.code();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!banqueHydroTimeoutException.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Aqua6boHydrometryDao hydrometry$dao$http$Aqua6boHydrometryDao$BanqueHydroTimeoutException$$$outer() {
            return this.$outer;
        }

        public BanqueHydroTimeoutException(Aqua6boHydrometryDao $outer, String code) {
            this.code = code;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

