/*
 * Decompiled with CFR 0.152.
 */
package ligura.controller;

import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constant.DataType$;
import constant.JobState$;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import ligura.controller.LiguraIntegration;
import ligura.dao.LiguraStationDao;
import ligura.dao.http.LiguraDao;
import ligura.model.HydrometerLigura;
import ligura.model.PluviometerLigura;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.ws.WSClient;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\b\u0011\u0001UA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ya\t\u0005\t[\u0001\u0011\t\u0011)A\u0006]!A!\b\u0001B\u0001B\u0003-1\b\u0003\u0005@\u0001\t\u0005\t\u0015a\u0003A\u0011!1\u0005A!A!\u0002\u00179\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b1\u0002(\t\u000bQ\u0003A\u0011A+\t\u000b\u001d\u0004A\u0011\t5\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011q\u0005\u0001\u0005\n\u0005%\u0002bBA\u0017\u0001\u0011%\u0011q\u0006\u0005\b\u0003\u0013\u0002A\u0011BA&\u0011\u001d\ti\u0007\u0001C\u0005\u0003_Bq!!\u001e\u0001\t\u0003\n9H\u0001\tMS\u001e,(/Y\"p]R\u0014x\u000e\u001c7fe*\u0011\u0011CE\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\n\u0002\r1Lw-\u001e:b\u0007\u0001\u00192\u0001\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011Q\u0004I\u0007\u0002=)\tq$A\u0002ba&L!!\t\u0010\u0003\u000b5{G-\u001a7\u0002\u0005]\u001c\bC\u0001\u0013,\u001b\u0005)#B\u0001\u0012'\u0015\t9\u0003&\u0001\u0003mS\n\u001c(BA\u0010*\u0015\u0005Q\u0013\u0001\u00029mCfL!\u0001L\u0013\u0003\u0011]\u001b6\t\\5f]R\fq\u0001T8h+RLG\u000e\u0005\u00020q5\t\u0001G\u0003\u00022e\u0005!Q\u000f^5m\u0015\t\u0019D'\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0015\t)d'A\u0004bcV\f7/_:\u000b\u0003]\n!A\u001a:\n\u0005e\u0002$a\u0002'pOV#\u0018\u000e\\\u0001\u0012Y&<WO]1J]R,wM]1uS>t\u0007C\u0001\u001f>\u001b\u0005\u0001\u0012B\u0001 \u0011\u0005Ea\u0015nZ;sC&sG/Z4sCRLwN\\\u0001\u0011Y&<WO]1Ti\u0006$\u0018n\u001c8EC>\u0004\"!\u0011#\u000e\u0003\tS!a\u0011\n\u0002\u0007\u0011\fw.\u0003\u0002F\u0005\n\u0001B*[4ve\u0006\u001cF/\u0019;j_:$\u0015m\\\u0001\nY&<WO]1EC>\u0004\"\u0001S&\u000e\u0003%S!A\u0013\"\u0002\t!$H\u000f]\u0005\u0003\u0019&\u0013\u0011\u0002T5hkJ\fG)Y8\u0002\u0015){'\rT8h+RLG\u000e\u0005\u0002P%6\t\u0001K\u0003\u0002Ri\u0005)Q\u000f^5mg&\u00111\u000b\u0015\u0002\u000b\u0015>\u0014Gj\\4Vi&d\u0017A\u0002\u001fj]&$h\bF\u0001W)\u001d9\u0006,\u0017.\\9v\u0003\"\u0001\u0010\u0001\t\u000b\t:\u00019A\u0012\t\u000b5:\u00019\u0001\u0018\t\u000bi:\u00019A\u001e\t\u000b}:\u00019\u0001!\t\u000b\u0019;\u00019A$\t\u000b5;\u00019\u0001()\u0005\u001dy\u0006C\u00011f\u001b\u0005\t'B\u00012d\u0003\u0019IgN[3di*\tA-A\u0003kCZ\f\u00070\u0003\u0002gC\n1\u0011J\u001c6fGR\fq!\u001a=fGV$X\rF\u0002jYf\u0004\"a\u00066\n\u0005-D\"\u0001B+oSRDQ!\u001c\u0005A\u00029\f!B]8vi&twmS3z!\tygO\u0004\u0002qiB\u0011\u0011\u000fG\u0007\u0002e*\u00111\u000fF\u0001\u0007yI|w\u000e\u001e \n\u0005UD\u0012A\u0002)sK\u0012,g-\u0003\u0002xq\n11\u000b\u001e:j]\u001eT!!\u001e\r\t\u000biD\u0001\u0019A>\u0002\u000f5,7o]1hKB\u0011Ap`\u0007\u0002{*\u0011aPJ\u0001\u0005UN|g.C\u0002\u0002\u0002u\u0014qAS:WC2,X-A\u0006iC:$G.Z#se>\u0014H#B5\u0002\b\u0005u\u0001bBA\u0005\u0013\u0001\u0007\u00111B\u0001\u0002KB!\u0011QBA\f\u001d\u0011\ty!a\u0005\u000f\u0007E\f\t\"C\u0001\u001a\u0013\r\t)\u0002G\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI\"a\u0007\u0003\u0013\u0015C8-\u001a9uS>t'bAA\u000b1!9\u0011qD\u0005A\u0002\u0005\u0005\u0012A\u00046pE\u0016CXmY;uS>t\u0017\n\u001a\t\u0004/\u0005\r\u0012bAA\u00131\t!Aj\u001c8h\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0015\u0007%\fY\u0003C\u0003{\u0015\u0001\u000710\u0001\rmS\u001e,(/Y'fCN,(/Z%oi\u0016<'/\u0019;j_:$2\"[A\u0019\u0003k\ty$a\u0011\u0002F!1\u00111G\u0006A\u00029\f!c\u001d;bi&|g.\u00138uK\u001e\u0014\u0018\r^5p]\"9\u0011qG\u0006A\u0002\u0005e\u0012AA5e!\r9\u00121H\u0005\u0004\u0003{A\"aA%oi\"1\u0011\u0011I\u0006A\u00029\fQ\u0001]1sC6Dq!a\b\f\u0001\u0004\t\t\u0003\u0003\u0004\u0002H-\u0001\rA\\\u0001\u0005kN,'/\u0001\rmS\u001e,(/Y*uCRLwN\\%oi\u0016<'/\u0019;j_:$b!!\u0014\u0002T\u0005U\u0003#B\f\u0002P\u0005e\u0012bAA)1\t1q\n\u001d;j_:Da!!\u0011\r\u0001\u0004q\u0007bBA,\u0019\u0001\u0007\u0011\u0011L\u0001\u0006gftw\u000e\u001d\t\u0005\u00037\nI'\u0004\u0002\u0002^)!\u0011qLA1\u0003\u0015iw\u000eZ3m\u0015\u0011\t\u0019'!\u001a\u0002\u0007)|'MC\u0002\u0002hQ\nQ\u0001Z1fCVLA!a\u001b\u0002^\ti!j\u001c2QCJ\fW.\u001a;feN\fQ\u0004\\5hkJ\f7\u000b^1uS>t\u0017J\u001c;fOJ\fG/[8o\u0011f$'o\u001c\u000b\u0007\u0003\u001b\n\t(a\u001d\t\r\u0005\u0005S\u00021\u0001o\u0011\u001d\t9&\u0004a\u0001\u00033\nQbZ3u%>,H/\u001b8h\u0017\u0016LH#\u00018)\u0007\u0001\tY\bE\u0002a\u0003{J1!a b\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class LiguraController
implements Model {
    private final LogUtil LogUtil;
    private final LiguraIntegration liguraIntegration;
    private final LiguraStationDao liguraStationDao;
    private final LiguraDao liguraDao;
    private final JobLogUtil JobLogUtil;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        LiguraController liguraController = this;
        synchronized (liguraController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        LiguraController liguraController = this;
        synchronized (liguraController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_LIGURA();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.integration(message);
            return;
        }
        if (string != null) {
            String string4 = string;
            this.LogUtil.info(new StringBuilder(19).append("Bad routing key => ").append(string4).toString(), this.LogUtil.info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    private void integration(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            this.LogUtil.error(new StringBuilder(21).append("Fail to parse json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), this.LogUtil.error$default$2());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)ligura -> {
            LiguraController.$anonfun$integration$2(this, ligura);
            return BoxedUnit.UNIT;
        });
    }

    private void liguraMeasureIntegration(String stationIntegration, int id, String param, long jobExecutionId, String user) {
        String string = stationIntegration;
        String string2 = DataType$.MODULE$.DATA_HYDRO();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Option<JsValue> option = this.liguraDao.getMeasures(param, DataType$.MODULE$.DATA_HYDRO());
            if (option instanceof Some) {
                Some some = (Some)option;
                JsValue measures = (JsValue)some.value();
                this.liguraIntegration.insertMeasuresHydro(id, measures, jobExecutionId, user);
            } else {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "No measure", param, this.JobLogUtil.log$default$5());
                this.LogUtil.debug(new StringBuilder(23).append("No measure for station ").append(param).toString(), this.LogUtil.debug$default$2());
            }
            return;
        }
        String string4 = DataType$.MODULE$.DATA_PLUVIO();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            Option<JsValue> option = this.liguraDao.getMeasures(param, DataType$.MODULE$.DATA_PLUVIO());
            if (option instanceof Some) {
                Some some = (Some)option;
                JsValue measures = (JsValue)some.value();
                this.liguraIntegration.insertMeasures(id, measures, jobExecutionId, user);
            } else {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "No measure", param, this.JobLogUtil.log$default$5());
                this.LogUtil.debug(new StringBuilder(23).append("No measure for station ").append(param).toString(), this.LogUtil.debug$default$2());
            }
            return;
        }
        this.LogUtil.error("No data type for the station", this.LogUtil.error$default$2());
    }

    private Option<Object> liguraStationIntegration(String param, JobParameters synop) {
        Option<PluviometerLigura> option = this.liguraStationDao.getLiguraStation(param);
        if (option instanceof Some) {
            Some some = (Some)option;
            PluviometerLigura station = (PluviometerLigura)some.value();
            return new Some((Object)BoxesRunTime.boxToInteger((int)station.id()));
        }
        return None$.MODULE$;
    }

    private Option<Object> liguraStationIntegrationHydro(String param, JobParameters synop) {
        None$ none$;
        block3: {
            try {
                Option<HydrometerLigura> option = this.liguraStationDao.getLiguraStationHydro(param);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    HydrometerLigura station = (HydrometerLigura)some.value();
                    none$ = new Some((Object)BoxesRunTime.boxToInteger((int)station.id()));
                    break block3;
                }
                none$ = None$.MODULE$;
            }
            catch (Exception e) {
                this.LogUtil.error(new StringBuilder(24).append("threw an exception :\n").append(e.getMessage()).append(" \n ").append(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace()), (Function1 & Serializable)s -> s.toString(), ClassTag$.MODULE$.apply(String.class))).toString(), this.LogUtil.error$default$2());
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.LIGURA_MODEL_TOPIC();
    }

    public static final /* synthetic */ void $anonfun$integration$7(LiguraController $this, String stationIntegration$1, JobParameters ligura$1, String user$1, String param) {
        String string = stationIntegration$1;
        String string2 = DataType$.MODULE$.DATA_PLUVIO();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Option<Object> option = $this.liguraStationIntegration(param, ligura$1);
            if (option instanceof Some) {
                Some some = (Some)option;
                int id = BoxesRunTime.unboxToInt((Object)some.value());
                $this.liguraMeasureIntegration(stationIntegration$1, id, param, ligura$1.jobExecutionId(), user$1);
            } else {
                $this.JobLogUtil.log(ligura$1.jobExecutionId(), JobState$.MODULE$.WARNING(), "Station not found", param, $this.JobLogUtil.log$default$5());
            }
            return;
        }
        String string4 = DataType$.MODULE$.DATA_HYDRO();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            Option<Object> option = $this.liguraStationIntegrationHydro(param, ligura$1);
            if (option instanceof Some) {
                Some some = (Some)option;
                int id = BoxesRunTime.unboxToInt((Object)some.value());
                $this.liguraMeasureIntegration(stationIntegration$1, id, param, ligura$1.jobExecutionId(), user$1);
            } else {
                $this.JobLogUtil.log(ligura$1.jobExecutionId(), JobState$.MODULE$.WARNING(), "Station not found", param, $this.JobLogUtil.log$default$5());
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$integration$5(LiguraController $this, JobParameters ligura$1, String user$1, String stationIntegration) {
        ((IterableOnceOps)ligura$1.parameters().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).foreach((Function1 & Serializable)param -> {
            LiguraController.$anonfun$integration$7($this, stationIntegration, ligura$1, user$1, param);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$integration$2(LiguraController $this, JobParameters ligura) {
        String user = (String)ligura.user().getOrElse((Function0 & Serializable)() -> "");
        try {
            ((IterableOnceOps)ligura.dataTypes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).foreach((Function1 & Serializable)stationIntegration -> {
                LiguraController.$anonfun$integration$5($this, ligura, user, stationIntegration);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            $this.JobLogUtil.log(ligura.jobExecutionId(), JobState$.MODULE$.ERROR(), e.getMessage(), "Job Failed", $this.JobLogUtil.log$default$5());
            $this.LogUtil.error(new StringBuilder(24).append("threw an exception :\n").append(e.getMessage()).append(" \n ").append(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace()), (Function1 & Serializable)s -> s.toString(), ClassTag$.MODULE$.apply(String.class))).toString(), $this.LogUtil.error$default$2());
        }
    }

    @Inject
    public LiguraController(WSClient ws, LogUtil LogUtil2, LiguraIntegration liguraIntegration, LiguraStationDao liguraStationDao, LiguraDao liguraDao, JobLogUtil JobLogUtil2) {
        this.LogUtil = LogUtil2;
        this.liguraIntegration = liguraIntegration;
        this.liguraStationDao = liguraStationDao;
        this.liguraDao = liguraDao;
        this.JobLogUtil = JobLogUtil2;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        Statics.releaseFence();
    }
}

