/*
 * Decompiled with CFR 0.152.
 */
package ligura.controller;

import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.StationTypeUtil$;
import genericImport.itf.GenericImportDao;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import ligura.dao.LiguraStationDao;
import ligura.domain.LiguraMeasureHydroInput$;
import ligura.domain.LiguraMeasureInput$;
import ligura.domain.LiguraStationInput;
import ligura.domain.LiguraStationInput$;
import org.joda.time.DateTime;
import play.api.libs.json.JsValue;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\u0006\f\u0001AA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006Y\u0001\u0007\u0005\tI\u0001\u0011\t\u0011)A\u0006K!A1\u0006\u0001B\u0001B\u0003-A\u0006\u0003\u00055\u0001\t\u0005\t\u0015a\u00036\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u00159\b\u0001\"\u0001y\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\u0011\u0011\u0003T5hkJ\f\u0017J\u001c;fOJ\fG/[8o\u0015\taQ\"\u0001\u0006d_:$(o\u001c7mKJT\u0011AD\u0001\u0007Y&<WO]1\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\u000f1{w-\u0016;jYB\u0011\u0011DI\u0007\u00025)\u00111\u0004H\u0001\u0005kRLGN\u0003\u0002\u001e=\u0005A!/\u00192cSRl\u0017O\u0003\u0002 A\u00059\u0011-];bgf\u001c(\"A\u0011\u0002\u0005\u0019\u0014\u0018BA\u0012\u001b\u0005\u001daunZ+uS2\f\u0001\u0003\\5hkJ\f7\u000b^1uS>tG)Y8\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!j\u0011a\u00013b_&\u0011!f\n\u0002\u0011\u0019&<WO]1Ti\u0006$\u0018n\u001c8EC>\f\u0001cR3oKJL7-S7q_J$H)Y8\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014aA5uM*\t\u0011'A\u0007hK:,'/[2J[B|'\u000f^\u0005\u0003g9\u0012\u0001cR3oKJL7-S7q_J$H)Y8\u0002\u0015){'\rT8h+RLG\u000e\u0005\u00027s5\tqG\u0003\u00029=\u0005)Q\u000f^5mg&\u0011!h\u000e\u0002\u000b\u0015>\u0014Gj\\4Vi&d\u0017A\u0002\u001fj]&$h\bF\u0001>)\u0015q\u0004)\u0011\"D!\ty\u0004!D\u0001\f\u0011\u00159R\u0001q\u0001\u0019\u0011\u0015!S\u0001q\u0001&\u0011\u0015YS\u0001q\u0001-\u0011\u0015!T\u0001q\u00016Q\t)Q\t\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u00061\u0011N\u001c6fGRT\u0011AS\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0019\u001e\u0013a!\u00138kK\u000e$\u0018AD5og\u0016\u0014H/T3bgV\u0014Xm\u001d\u000b\u0006\u001fJ;VM\u001b\t\u0003%AK!!U\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006'\u001a\u0001\r\u0001V\u0001\u0003S\u0012\u0004\"AE+\n\u0005Y\u001b\"aA%oi\")\u0001L\u0002a\u00013\u0006iQ.Z1tkJ,7/\u00138qkR\u0004\"AW2\u000e\u0003mS!\u0001X/\u0002\t)\u001cxN\u001c\u0006\u0003=~\u000bA\u0001\\5cg*\u0011\u0001-Y\u0001\u0004CBL'\"\u00012\u0002\tAd\u0017-_\u0005\u0003In\u0013qAS:WC2,X\rC\u0003g\r\u0001\u0007q-\u0001\bk_\n,\u00050Z2vi&|g.\u00133\u0011\u0005IA\u0017BA5\u0014\u0005\u0011auN\\4\t\u000b-4\u0001\u0019\u00017\u0002\tU\u001cXM\u001d\t\u0003[Rt!A\u001c:\u0011\u0005=\u001cR\"\u00019\u000b\u0005E|\u0011A\u0002\u001fs_>$h(\u0003\u0002t'\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u00198#A\nj]N,'\u000f^'fCN,(/Z:Is\u0012\u0014x\u000eF\u0003Psj\\H\u0010C\u0003T\u000f\u0001\u0007A\u000bC\u0003Y\u000f\u0001\u0007\u0011\fC\u0003g\u000f\u0001\u0007q\rC\u0003l\u000f\u0001\u0007A.A\u0007j]N,'\u000f^*uCRLwN\u001c\u000b\b\u007f\u0006\u0015\u0011\u0011BA\u0007!\u0011\u0011\u0012\u0011\u0001+\n\u0007\u0005\r1C\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003\u000fA\u0001\u0019A-\u0002%M$\u0018\r^5p]2Kw-\u001e:b\u0013:\u0004X\u000f\u001e\u0005\u0007W\"\u0001\r!a\u0003\u0011\tI\t\t\u0001\u001c\u0005\u0006M\"\u0001\raZ\u0001\u000ekB$\u0017\r^3Ti\u0006$\u0018n\u001c8\u0015\u0013}\f\u0019\"!\u0006\u0002\u0018\u0005e\u0001\"B*\n\u0001\u0004!\u0006BBA\u0004\u0013\u0001\u0007\u0011\f\u0003\u0004l\u0013\u0001\u0007\u00111\u0002\u0005\u0006M&\u0001\ra\u001a\u0015\u0004\u0001\u0005u\u0001c\u0001$\u0002 %\u0019\u0011\u0011E$\u0003\u0013MKgn\u001a7fi>t\u0007")
public class LiguraIntegration {
    private final LogUtil LogUtil;
    private final LiguraStationDao liguraStationDao;
    private final GenericImportDao GenericImportDao;
    private final JobLogUtil JobLogUtil;

    public void insertMeasures(int id, JsValue measuresInput, long jobExecutionId, String user) {
        this.LogUtil.debug("insert measure in bdd", this.LogUtil.debug$default$2());
        measuresInput.validate(LiguraMeasureInput$.MODULE$.liguraMeasureSeqRead()).fold((Function1 & Serializable)error -> {
            LiguraIntegration.$anonfun$insertMeasures$1(this, jobExecutionId, id, error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)measures -> {
            LiguraIntegration.$anonfun$insertMeasures$2(this, jobExecutionId, id, user, measures);
            return BoxedUnit.UNIT;
        });
    }

    public void insertMeasuresHydro(int id, JsValue measuresInput, long jobExecutionId, String user) {
        this.LogUtil.debug("insert measure in bdd", this.LogUtil.debug$default$2());
        measuresInput.validate(LiguraMeasureHydroInput$.MODULE$.liguraMeasureSeqRead()).fold((Function1 & Serializable)error -> {
            this.LogUtil.info(new StringBuilder(29).append("Fail to parse json measure :\n").append(error).toString(), this.LogUtil.info$default$2());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)measures -> {
            LiguraIntegration.$anonfun$insertMeasuresHydro$2(this, jobExecutionId, id, user, measures);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> insertStation(JsValue stationLiguraInput, Option<String> user, long jobExecutionId) {
        return (Option)stationLiguraInput.validate(LiguraStationInput$.MODULE$.liguraStationReads()).fold((Function1 & Serializable)error -> {
            $this.LogUtil.info(new StringBuilder(28).append("Error when insert station :\n").append(error).toString(), $this.LogUtil.info$default$2());
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error when insert station", "", $this.JobLogUtil.log$default$5());
            return None$.MODULE$;
        }, (Function1 & Serializable)stationLigura -> {
            int result = $this.liguraStationDao.createLiguraStation((LiguraStationInput)stationLigura, user);
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), "Station created", stationLigura.code(), $this.JobLogUtil.log$default$5());
            return new Some((Object)BoxesRunTime.boxToInteger((int)result));
        });
    }

    public Option<Object> updateStation(int id, JsValue stationLiguraInput, Option<String> user, long jobExecutionId) {
        return (Option)stationLiguraInput.validate(LiguraStationInput$.MODULE$.liguraStationReads()).fold((Function1 & Serializable)error -> {
            $this.LogUtil.info(new StringBuilder(29).append("Error when update station ").append(id).append(" :\n").append(error).toString(), $this.LogUtil.info$default$2());
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Error when update station", new StringBuilder(5).append("id : ").append(id).toString(), $this.JobLogUtil.log$default$5());
            return None$.MODULE$;
        }, (Function1 & Serializable)stationLigura -> {
            int result = $this.liguraStationDao.updateLiguraStation(id, (LiguraStationInput)stationLigura, user);
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), "Station updated", stationLigura.code(), $this.JobLogUtil.log$default$5());
            return new Some((Object)BoxesRunTime.boxToInteger((int)result));
        });
    }

    public static final /* synthetic */ void $anonfun$insertMeasures$1(LiguraIntegration $this, long jobExecutionId$1, int id$1, Seq error) {
        $this.LogUtil.info(new StringBuilder(29).append("Fail to parse json measure :\n").append(error).toString(), $this.LogUtil.info$default$2());
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), "Fail to parse json measure", Integer.toString(id$1), $this.JobLogUtil.log$default$5());
    }

    public static final /* synthetic */ void $anonfun$insertMeasures$2(LiguraIntegration $this, long jobExecutionId$1, int id$1, String user$1, scala.collection.immutable.Seq measures) {
        scala.collection.immutable.Seq genericMeasures = (scala.collection.immutable.Seq)measures.map((Function1 & Serializable)m -> new GenericData(m.measureDate(), m.measureDate(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)m.pluvio())), 1, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(21).append("Integrating ").append(genericMeasures.length()).append(" measures").toString(), Integer.toString(id$1), $this.JobLogUtil.log$default$5());
        int res = $this.GenericImportDao.importPluviometry(Integer.toString(id$1), "", user$1, jobExecutionId$1, (scala.collection.immutable.Seq<GenericData>)genericMeasures, $this.GenericImportDao.importPluviometry$default$6());
        if (res > 0) {
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(16).append(res).append(" measures saved.").toString(), Integer.toString(id$1), $this.JobLogUtil.log$default$5());
            return;
        }
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.NOTHING_TO_DO(), "Nothing new to import", Integer.toString(id$1), $this.JobLogUtil.log$default$5());
    }

    public static final /* synthetic */ void $anonfun$insertMeasuresHydro$2(LiguraIntegration $this, long jobExecutionId$2, int id$2, String user$2, scala.collection.immutable.Seq measures) {
        scala.collection.immutable.Seq genericMeasures = (scala.collection.immutable.Seq)measures.map((Function1 & Serializable)m -> new GenericData(m.measureDate(), m.measureDate(), (Option)(m.hydro().isDefined() ? new Some(m.hydro().get()) : None$.MODULE$), 4, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
        $this.JobLogUtil.log(jobExecutionId$2, JobState$.MODULE$.INFO(), new StringBuilder(21).append("Integrating ").append(measures.length()).append(" measures").toString(), Integer.toString(id$2), $this.JobLogUtil.log$default$5());
        DateTime lastdate = (DateTime)$this.GenericImportDao.getLastDateByStation(StationTypeUtil$.MODULE$.HYDROMETRY(), 4, id$2, $this.GenericImportDao.getLastDateByStation$default$4()).getOrElse((Function0 & Serializable)() -> new DateTime(2000, 2, 3, 12, 0));
        int res = $this.GenericImportDao.importHydrometry(Integer.toString(id$2), Integer.toString(id$2), user$2, jobExecutionId$2, (scala.collection.immutable.Seq<GenericData>)genericMeasures, $this.GenericImportDao.importHydrometry$default$6());
        if (res > 0) {
            $this.JobLogUtil.log(jobExecutionId$2, JobState$.MODULE$.SUCCESS(), new StringBuilder(16).append(res).append(" measures saved.").toString(), Integer.toString(id$2), $this.JobLogUtil.log$default$5());
            return;
        }
        $this.JobLogUtil.log(jobExecutionId$2, JobState$.MODULE$.NOTHING_TO_DO(), "Nothing new to import", Integer.toString(id$2), $this.JobLogUtil.log$default$5());
    }

    @Inject
    public LiguraIntegration(LogUtil LogUtil2, LiguraStationDao liguraStationDao, GenericImportDao GenericImportDao2, JobLogUtil JobLogUtil2) {
        this.LogUtil = LogUtil2;
        this.liguraStationDao = liguraStationDao;
        this.GenericImportDao = GenericImportDao2;
        this.JobLogUtil = JobLogUtil2;
    }
}

