/*
 * Decompiled with CFR 0.152.
 */
package lowwater.controller;

import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import hydrometry.dao.HydrometryStationDao;
import hydrometry.model.HydrometryStation;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import lowwater.controller.LowWaterFilter;
import lowwater.controller.LowWaterFilter$;
import lowwater.dao.Aqua6boLowWaterDao;
import lowwater.dao.HydrometryModalityObservationDao;
import lowwater.model.A6BO_Observation;
import lowwater.model.A6BO_OndeStation;
import lowwater.model.HydrometryModalityObservation;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001\u0002\t\u0012\u0001YA\u0001b\t\u0001\u0003\u0002\u0003\u0006Y\u0001\n\u0005\t]\u0001\u0011\t\u0011)A\u0006_!AQ\u0007\u0001B\u0001B\u0003-a\u0007\u0003\u0005>\u0001\t\u0005\t\u0015a\u0003?\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015)\b\u0001\"\u0011w\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!a\u0005\u0001\t\u0003\t)\u0002C\u0005\u00022\u0001\t\n\u0011\"\u0001\u00024!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003\"CA>\u0001E\u0005I\u0011AA?\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007C\u0011\"a*\u0001#\u0003%\t!! \u0003%1{woV1uKJ\u001cuN\u001c;s_2dWM\u001d\u0006\u0003%M\t!bY8oiJ|G\u000e\\3s\u0015\u0005!\u0012\u0001\u00037po^\fG/\u001a:\u0004\u0001M\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013aA1qS&\u0011!e\b\u0002\u0006\u001b>$W\r\\\u0001\u000bU>\u0014Gj\\4Vi&d\u0007CA\u0013-\u001b\u00051#BA\u0014)\u0003\u0015)H/\u001b7t\u0015\tI#&A\u0004bcV\f7/_:\u000b\u0003-\n!A\u001a:\n\u000552#A\u0003&pE2{w-\u0016;jY\u0006\u0011\u0012-];bm\t|Gj\\<XCR,'\u000fR1p!\t\u00014'D\u00012\u0015\t\u00114#A\u0002eC>L!\u0001N\u0019\u0003%\u0005\u000bX/\u0019\u001cc_2{woV1uKJ$\u0015m\\\u0001\u0015Qf$'o\\7fiJL8\u000b^1uS>tG)Y8\u0011\u0005]ZT\"\u0001\u001d\u000b\u0005IJ$\"\u0001\u001e\u0002\u0015!LHM]8nKR\u0014\u00180\u0003\u0002=q\t!\u0002*\u001f3s_6,GO]=Ti\u0006$\u0018n\u001c8EC>\f\u0001\u0005[=ee>lW\r\u001e:z\u001b>$\u0017\r\\5us>\u00137/\u001a:wCRLwN\u001c#b_B\u0011\u0001gP\u0005\u0003\u0001F\u0012\u0001\u0005S=ee>lW\r\u001e:z\u001b>$\u0017\r\\5us>\u00137/\u001a:wCRLwN\u001c#b_\u00061A(\u001b8jiz\"\u0012a\u0011\u000b\u0006\t\u001a;\u0005*\u0013\t\u0003\u000b\u0002i\u0011!\u0005\u0005\u0006G\u0015\u0001\u001d\u0001\n\u0005\u0006]\u0015\u0001\u001da\f\u0005\u0006k\u0015\u0001\u001dA\u000e\u0005\u0006{\u0015\u0001\u001dA\u0010\u0015\u0003\u000b-\u0003\"\u0001T)\u000e\u00035S!AT(\u0002\r%t'.Z2u\u0015\u0005\u0001\u0016!\u00026bm\u0006D\u0018B\u0001*N\u0005\u0019IeN[3di\u0006iq-\u001a;S_V$\u0018N\\4LKf$\u0012!\u0016\t\u0003-vs!aV.\u0011\u0005aKR\"A-\u000b\u0005i+\u0012A\u0002\u001fs_>$h(\u0003\u0002]3\u00051\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\ta\u0016$A\u0006iC:$G.Z#se>\u0014Hc\u00012faB\u0011\u0001dY\u0005\u0003If\u0011A!\u00168ji\")am\u0002a\u0001O\u0006\tQ\r\u0005\u0002i[:\u0011\u0011n\u001b\b\u00031*L\u0011AG\u0005\u0003Yf\tq\u0001]1dW\u0006<W-\u0003\u0002o_\nIQ\t_2faRLwN\u001c\u0006\u0003YfAQ!]\u0004A\u0002I\faB[8c\u000bb,7-\u001e;j_:LE\r\u0005\u0002\u0019g&\u0011A/\u0007\u0002\u0005\u0019>tw-A\u0004fq\u0016\u001cW\u000f^3\u0015\u0007\t<\u0018\u0010C\u0003y\u0011\u0001\u0007Q+\u0001\u0006s_V$\u0018N\\4LKfDQA\u001f\u0005A\u0002m\fq!\\3tg\u0006<W\rE\u0002}\u0003\u0013i\u0011! \u0006\u0003}~\fAA[:p]*!\u0011\u0011AA\u0002\u0003\u0011a\u0017NY:\u000b\u0007\u0001\n)A\u0003\u0002\u0002\b\u0005!\u0001\u000f\\1z\u0013\r\tY! \u0002\b\u0015N4\u0016\r\\;f\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0015\u0007\t\f\t\u0002C\u0003{\u0013\u0001\u000710A\u0003feJ|'\u000f\u0006\u0005\u0002\u0018\u0005m\u0011QDA\u0011)\r\u0011\u0017\u0011\u0004\u0005\u0006c*\u0001\u001dA\u001d\u0005\u0006u*\u0001\r!\u0016\u0005\u0007\u0003?Q\u0001\u0019A+\u0002\t\r|G-\u001a\u0005\n\u0003GQ\u0001\u0013!a\u0001\u0003K\t\u0011\"\u001a=dKB$\u0018n\u001c8\u0011\u000ba\t9#a\u000b\n\u0007\u0005%\u0012D\u0001\u0004PaRLwN\u001c\t\u0004Q\u00065\u0012bAA\u0018_\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0010KJ\u0014xN\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0007\u0016\u0005\u0003K\t9d\u000b\u0002\u0002:A!\u00111HA#\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013!C;oG\",7m[3e\u0015\r\t\u0019%G\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA$\u0003{\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I\u0019H/\u0019;j_:Le\u000e^3he\u0006$\u0018n\u001c8\u0015\r\u00055\u0013\u0011OA=)\u0019\ty%a\u0016\u0002ZA)\u0001$a\n\u0002RA\u0019\u0001$a\u0015\n\u0007\u0005U\u0013D\u0001\u0004E_V\u0014G.\u001a\u0005\u0006c2\u0001\u001dA\u001d\u0005\b\u00037b\u00019AA/\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005\u0003?\ni'\u0004\u0002\u0002b)!\u00111MA3\u0003\u0015iw\u000eZ3m\u0015\u0011\t9'!\u001b\u0002\u0007)|'MC\u0002\u0002l!\nQ\u0001Z1fCVLA!a\u001c\u0002b\ti!j\u001c2QCJ\fW.\u001a;feND\u0011\"!\u0004\r!\u0003\u0005\r!a\u001d\u0011\u0007a\t)(C\u0002\u0002xe\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002 1\u0001\r!V\u0001\u001dgR\fG/[8o\u0013:$Xm\u001a:bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\tyH\u000b\u0003\u0002t\u0005]\u0012AF8cg\u0016\u0014h/\u0019;j_:Le\u000e^3he\u0006$\u0018n\u001c8\u0015\u0011\u0005\u0015\u0015QTAQ\u0003K#b!a\"\u0002\u001a\u0006m\u0005CBAE\u0003\u001f\u000b\u0019*\u0004\u0002\u0002\f*\u0019\u0011QR\r\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003#\u000bYIA\u0002Uef\u00042\u0001GAK\u0013\r\t9*\u0007\u0002\u0004\u0013:$\b\"B9\u000f\u0001\b\u0011\bbBA.\u001d\u0001\u000f\u0011Q\f\u0005\n\u0003?s\u0001\u0013!a\u0001\u0003g\n1\u0001\u001a4j\u0011\u001d\t\u0019K\u0004a\u0001\u0003#\n!!\u001b3\t\r\u0005}a\u00021\u0001V\u0003\u0001z'm]3sm\u0006$\u0018n\u001c8J]R,wM]1uS>tG\u0005Z3gCVdG\u000fJ\u0019)\u0007\u0001\tY\u000bE\u0002M\u0003[K1!a,N\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class LowWaterController
implements Model {
    private final JobLogUtil jobLogUtil;
    private final Aqua6boLowWaterDao aqua6boLowWaterDao;
    private final HydrometryStationDao hydrometryStationDao;
    private final HydrometryModalityObservationDao hydrometryModalityObservationDao;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        LowWaterController lowWaterController = this;
        synchronized (lowWaterController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        LowWaterController lowWaterController = this;
        synchronized (lowWaterController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.LOW_WATER_MODEL_TOPIC();
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.jobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.jobLogUtil.log$default$5());
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_LOW_WATER();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.integration(message);
            return;
        }
        if (string != null) {
            String string4 = string;
            this.logUtil().info(new StringBuilder(19).append("Bad routing key => ").append(string4).toString(), this.logUtil().info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    public void integration(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            LowWaterController.$anonfun$integration$1(this, error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)parameters -> {
            LowWaterController.$anonfun$integration$2(this, parameters);
            return BoxedUnit.UNIT;
        });
    }

    public void error(String message, String code, Option<Throwable> exception, long jobExecutionId) {
        this.jobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), message, code, this.jobLogUtil.log$default$5());
        exception.foreach((Function1 & Serializable)err -> {
            LowWaterController.$anonfun$error$1(this, err);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Throwable> error$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> stationIntegration(boolean integration, String code, long jobExecutionId, JobParameters parameters) {
        Option<HydrometryStation> option = this.hydrometryStationDao.get(code);
        if (option instanceof Some) {
            Some some = (Some)option;
            HydrometryStation station = (HydrometryStation)some.value();
            if (integration) {
                Try<A6BO_OndeStation> try_ = this.aqua6boLowWaterDao.getStation(code, jobExecutionId);
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    this.error(new StringBuilder(21).append("Cannot get station : ").append(code).toString(), code, (Option<Throwable>)new Some((Object)exception), jobExecutionId);
                    return None$.MODULE$;
                }
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    A6BO_OndeStation value = (A6BO_OndeStation)success.value();
                    this.hydrometryStationDao.update((int)station.id(), value.toHydro(), (Option<String>)parameters.user(), 1L);
                    return new Some((Object)BoxesRunTime.boxToDouble((double)station.id()));
                }
                throw new MatchError(try_);
            }
            return new Some((Object)BoxesRunTime.boxToDouble((double)station.id()));
        }
        if (None$.MODULE$.equals(option)) {
            Try<A6BO_OndeStation> try_ = this.aqua6boLowWaterDao.getStation(code, jobExecutionId);
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.error(new StringBuilder(21).append("Cannot get station : ").append(code).toString(), code, (Option<Throwable>)new Some((Object)exception), jobExecutionId);
                return None$.MODULE$;
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                A6BO_OndeStation value = (A6BO_OndeStation)success.value();
                int id = this.hydrometryStationDao.insert(value.toHydro(), (Option<String>)parameters.user(), 1L)._1$mcI$sp();
                return new Some((Object)BoxesRunTime.boxToDouble((double)id));
            }
            throw new MatchError(try_);
        }
        throw new MatchError(option);
    }

    public boolean stationIntegration$default$1() {
        return true;
    }

    public Try<Object> observationIntegration(boolean dfi, double id, String code, long jobExecutionId, JobParameters parameters) {
        this.jobLogUtil.checkExecutionAbort(jobExecutionId);
        if (dfi) {
            this.hydrometryModalityObservationDao.deleteAll(id);
        }
        Option<DateTime> minDate = this.hydrometryModalityObservationDao.lastDate(id);
        Try<scala.collection.immutable.Seq<A6BO_Observation>> try_ = this.aqua6boLowWaterDao.getObservations(code, jobExecutionId);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.error(new StringBuilder(26).append("Cannot get observations : ").append(code).toString(), code, (Option<Throwable>)new Some((Object)exception), jobExecutionId);
            return new Failure(exception);
        }
        if (try_ instanceof Success) {
            scala.collection.immutable.Seq seq;
            Success success = (Success)try_;
            scala.collection.immutable.Seq values = (scala.collection.immutable.Seq)success.value();
            Option<DateTime> option = minDate;
            if (option instanceof Some) {
                Some some = (Some)option;
                DateTime date = (DateTime)some.value();
                seq = (scala.collection.immutable.Seq)((IterableOps)values.filter((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)LowWaterController.$anonfun$observationIntegration$1(date, o)))).flatMap((Function1 & Serializable)x$3 -> x$3.toObservations(id, (Option<String>)parameters.user()));
            } else if (None$.MODULE$.equals(option)) {
                seq = (scala.collection.immutable.Seq)values.flatMap((Function1 & Serializable)x$4 -> x$4.toObservations(id, (Option<String>)parameters.user()));
            } else {
                throw new MatchError(option);
            }
            scala.collection.immutable.Seq observations = (scala.collection.immutable.Seq)seq.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LowWaterController.$anonfun$observationIntegration$5(x$5)));
            return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.hydrometryModalityObservationDao.insertAll((scala.collection.immutable.Seq<HydrometryModalityObservation>)observations)).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)observations.length()));
        }
        throw new MatchError(try_);
    }

    public boolean observationIntegration$default$1() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$integration$1(LowWaterController $this, Seq error) {
        $this.logUtil().error(new StringBuilder(21).append("Fail to parse json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil().error$default$2());
    }

    public static final /* synthetic */ void $anonfun$integration$3(LowWaterController $this, long jobExecutionId$1, boolean si$1, JobParameters parameters$1, boolean di$1, boolean dfi$1, String code) {
        $this.jobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(20).append("Start integration : ").append(code).toString(), code, $this.jobLogUtil.log$default$5());
        Option<Object> option = $this.stationIntegration(si$1, code, jobExecutionId$1, parameters$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            double id = BoxesRunTime.unboxToDouble((Object)some.value());
            if (di$1 || dfi$1) {
                $this.jobLogUtil.log(parameters$1.jobExecutionId(), JobState$.MODULE$.INFO(), new StringBuilder(37).append("Start data integration for station : ").append(code).toString(), code, $this.jobLogUtil.log$default$5());
                Try<Object> try_ = $this.observationIntegration(dfi$1, id, code, jobExecutionId$1, parameters$1);
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    $this.error(new StringBuilder(23).append("Error on integration : ").append(exception.getMessage()).toString(), code, (Option<Throwable>)new Some((Object)exception), jobExecutionId$1);
                } else if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    int value = BoxesRunTime.unboxToInt((Object)success.value());
                    $this.jobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(27).append(value).append(" observations integrated : ").append(code).toString(), code, $this.jobLogUtil.log$default$5());
                } else {
                    throw new MatchError(try_);
                }
                return;
            }
            return;
        }
        $this.jobLogUtil.log(parameters$1.jobExecutionId(), JobState$.MODULE$.WARNING(), "Station not found", code, $this.jobLogUtil.log$default$5());
    }

    public static final /* synthetic */ void $anonfun$integration$2(LowWaterController $this, JobParameters parameters) {
        block7: {
            if (!package$.MODULE$.env().contains((Object)"APPLICATION_TOKEN")) {
                $this.jobLogUtil.log(parameters.jobExecutionId(), JobState$.MODULE$.ERROR(), "APPLICATION_TOKEN env is not in .env", "", $this.jobLogUtil.log$default$5());
                return;
            }
            try {
                long jobExecutionId = parameters.jobExecutionId();
                LowWaterFilter filter = (LowWaterFilter)JobUtil$.MODULE$.getFilters(parameters, jobExecutionId, $this.jobLogUtil, (Object)new LowWaterFilter(LowWaterFilter$.MODULE$.apply$default$1(), LowWaterFilter$.MODULE$.apply$default$2(), LowWaterFilter$.MODULE$.apply$default$3()), false, LowWaterFilter$.MODULE$.format());
                Tuple3<Object, Object, Object> tuple3 = filter.dataIntegrations();
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                boolean si = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
                boolean di = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
                boolean dfi = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)si), (Object)BoxesRunTime.boxToBoolean((boolean)di), (Object)BoxesRunTime.boxToBoolean((boolean)dfi));
                boolean si2 = BoxesRunTime.unboxToBoolean((Object)tuple32._1());
                boolean di2 = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
                boolean dfi2 = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
                Option<scala.collection.immutable.Seq<String>> option = filter.codes();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    scala.collection.immutable.Seq codes = (scala.collection.immutable.Seq)some.value();
                    codes.foreach((Function1 & Serializable)code -> {
                        LowWaterController.$anonfun$integration$3($this, jobExecutionId, si2, parameters, di2, dfi2, code);
                        return BoxedUnit.UNIT;
                    });
                    break block7;
                }
                if (None$.MODULE$.equals(option)) {
                    $this.jobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "Nothing to do", "", $this.jobLogUtil.log$default$5());
                    break block7;
                }
                throw new MatchError(option);
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (Exception e) {
                $this.logUtil().printError((Throwable)e);
                $this.jobLogUtil.log(parameters.jobExecutionId(), JobState$.MODULE$.ERROR(), e.getMessage(), "", $this.jobLogUtil.log$default$5());
            }
        }
    }

    public static final /* synthetic */ void $anonfun$error$1(LowWaterController $this, Throwable err) {
        $this.logUtil().printError(err);
    }

    public static final /* synthetic */ boolean $anonfun$observationIntegration$1(DateTime date$1, A6BO_Observation o) {
        return o.date().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isAfter((ReadableInstant)date$1)));
    }

    public static final /* synthetic */ boolean $anonfun$observationIntegration$5(HydrometryModalityObservation x$5) {
        return x$5.codeobservation().isDefined();
    }

    @Inject
    public LowWaterController(JobLogUtil jobLogUtil, Aqua6boLowWaterDao aqua6boLowWaterDao, HydrometryStationDao hydrometryStationDao, HydrometryModalityObservationDao hydrometryModalityObservationDao) {
        this.jobLogUtil = jobLogUtil;
        this.aqua6boLowWaterDao = aqua6boLowWaterDao;
        this.hydrometryStationDao = hydrometryStationDao;
        this.hydrometryModalityObservationDao = hydrometryModalityObservationDao;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        Statics.releaseFence();
    }
}

