/*
 * Decompiled with CFR 0.152.
 */
package meteofrance.obs;

import anorm.Column$;
import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import anorm.package$;
import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constant.ImportMode$;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.pluviometry.domain.PluviometerListSpecific;
import fr.aquasys.daeau.pluviometry.domain.PluviometerWithLinks;
import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.pluviometry.model.Pluviometer;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.ReferentialUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import genericImport.itf.GenericImportDao;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import meteofrance.obs.MFFilter;
import meteofrance.obs.MFFilter$;
import meteofrance.obs.MFMeasure$;
import meteofrance.obs.MFMeasureFull$;
import meteofrance.obs.MFStation;
import meteofrance.obs.MFStation$;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;
import play.api.db.Database;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.ws.WSClient;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import util.WSUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001B\n\u0015\u0001eA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ya\n\u0005\tg\u0001\u0011\t\u0011)A\u0006i!A!\b\u0001B\u0001B\u0003-1\b\u0003\u0005F\u0001\t\u0005\t\u0015a\u0003G\u0011!i\u0005A!A!\u0002\u0017q\u0005\u0002C,\u0001\u0005\u0003\u0005\u000b1\u0002-\t\u000b\u0001\u0004A\u0011A1\t\u000fQ\u0004!\u0019!C\u0005k\"9\u00111\u0001\u0001!\u0002\u00131\bbBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002X\u0001!I!!\u0017\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0006bBAl\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003O\u0004A\u0011AAu\u00051ieiQ8oiJ|G\u000e\\3s\u0015\t)b#A\u0002pENT\u0011aF\u0001\f[\u0016$Xm\u001c4sC:\u001cWm\u0001\u0001\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VM\u001a\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005\u0019\u0011\r]5\n\u0005\u0015\u0012#!B'pI\u0016d\u0017a\u0002'pOV#\u0018\u000e\u001c\t\u0003QEj\u0011!\u000b\u0006\u0003U-\nA!\u001e;jY*\u0011A&L\u0001\te\u0006\u0014'-\u001b;nc*\u0011afL\u0001\bCF,\u0018m]=t\u0015\u0005\u0001\u0014A\u00014s\u0013\t\u0011\u0014FA\u0004M_\u001e,F/\u001b7\u0002\u0015){'\rT8h+RLG\u000e\u0005\u00026q5\taG\u0003\u00028[\u0005)Q\u000f^5mg&\u0011\u0011H\u000e\u0002\u000b\u0015>\u0014Gj\\4Vi&d\u0017A\u00049mkZLw.\\3uKJ$\u0015m\u001c\t\u0003y\rk\u0011!\u0010\u0006\u0003}}\n1!\u001b;g\u0015\t\u0001\u0015)A\u0006qYV4\u0018n\\7fiJL(B\u0001\".\u0003\u0015!\u0017-Z1v\u0013\t!UH\u0001\bQYV4\u0018n\\7fi\u0016\u0014H)Y8\u0002!\u001d+g.\u001a:jG&k\u0007o\u001c:u\t\u0006|\u0007CA$L\u001b\u0005A%B\u0001 J\u0015\u0005Q\u0015!D4f]\u0016\u0014\u0018nY%na>\u0014H/\u0003\u0002M\u0011\n\u0001r)\u001a8fe&\u001c\u0017*\u001c9peR$\u0015m\\\u0001\tI\u0006$\u0018MY1tKB\u0011q*V\u0007\u0002!*\u0011\u0011KU\u0001\u0003I\nT!aI*\u000b\u0003Q\u000bA\u0001\u001d7bs&\u0011a\u000b\u0015\u0002\t\t\u0006$\u0018MY1tK\u0006AqkU\"mS\u0016tG\u000f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006\u0011qo\u001d\u0006\u0003;J\u000bA\u0001\\5cg&\u0011qL\u0017\u0002\t/N\u001bE.[3oi\u00061A(\u001b8jiz\"\u0012A\u0019\u000b\bG\u00164w\r[5k!\t!\u0007!D\u0001\u0015\u0011\u00151s\u0001q\u0001(\u0011\u0015\u0019t\u0001q\u00015\u0011\u0015Qt\u0001q\u0001<\u0011\u0015)u\u0001q\u0001G\u0011\u0015iu\u0001q\u0001O\u0011\u00159v\u0001q\u0001YQ\t9A\u000e\u0005\u0002ne6\taN\u0003\u0002pa\u00061\u0011N\u001c6fGRT\u0011!]\u0001\u0006U\u00064\u0018\r_\u0005\u0003g:\u0014a!\u00138kK\u000e$\u0018aB!R+\u00063$iT\u000b\u0002mB\u0011qO \b\u0003qr\u0004\"!\u001f\u000f\u000e\u0003iT!a\u001f\r\u0002\rq\u0012xn\u001c;?\u0013\tiH$\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u007f\u0006\u0005!AB*ue&twM\u0003\u0002~9\u0005A\u0011)U+Bm\t{\u0005%A\u0007hKR\u0014v.\u001e;j]\u001e\\U-\u001f\u000b\u0002m\u0006Y\u0001.\u00198eY\u0016,%O]8s)\u0019\ti!a\u0005\u0002*A\u00191$a\u0004\n\u0007\u0005EAD\u0001\u0003V]&$\bbBA\u000b\u0017\u0001\u0007\u0011qC\u0001\u0002KB!\u0011\u0011DA\u0012\u001d\u0011\tY\"a\b\u000f\u0007e\fi\"C\u0001\u001e\u0013\r\t\t\u0003H\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)#a\n\u0003\u0013\u0015C8-\u001a9uS>t'bAA\u00119!9\u00111F\u0006A\u0002\u00055\u0012A\u00046pE\u0016CXmY;uS>t\u0017\n\u001a\t\u00047\u0005=\u0012bAA\u00199\t!Aj\u001c8h\u0003\u001d)\u00070Z2vi\u0016$b!!\u0004\u00028\u0005m\u0002BBA\u001d\u0019\u0001\u0007a/\u0001\u0006s_V$\u0018N\\4LKfDq!!\u0010\r\u0001\u0004\ty$A\u0004nKN\u001c\u0018mZ3\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007R1!!\u0012]\u0003\u0011Q7o\u001c8\n\t\u0005%\u00131\t\u0002\b\u0015N4\u0016\r\\;f\u00035)\u00070Z2vi\u0016LU\u000e]8siR!\u0011qJA+!\rY\u0012\u0011K\u0005\u0004\u0003'b\"aA!os\"9\u0011QH\u0007A\u0002\u0005}\u0012aE4fiN#\u0018\r^5p]N$v.S7q_J$H\u0003BA.\u0003w\"b!!\u0018\u0002j\u0005-\u0004CBA\r\u0003?\n\u0019'\u0003\u0003\u0002b\u0005\u001d\"aA*fcB\u0019A-!\u001a\n\u0007\u0005\u001dDCA\u0005N\rN#\u0018\r^5p]\"9\u00111\u0006\bA\u0004\u00055\u0002bBA7\u001d\u0001\u000f\u0011qN\u0001\nI\u0016\u0014WoZ'pI\u0016\u0004RaGA9\u0003kJ1!a\u001d\u001d\u0005\u0019y\u0005\u000f^5p]B\u00191$a\u001e\n\u0007\u0005eDDA\u0004C_>dW-\u00198\t\u000f\u0005ud\u00021\u0001\u0002\u0000\u00059a-\u001b7uKJ\u001c\bc\u00013\u0002\u0002&\u0019\u00111\u0011\u000b\u0003\u001153e)\u001b7uKJ\fa\"[7q_J$H)\u0019;b)f\u0004X\r\u0006\u0007\u0002\n\u0006=\u0015\u0011SAQ\u0003W\u000by\u000b\u0006\u0004\u0002\u000e\u0005-\u0015Q\u0012\u0005\b\u0003Wy\u00019AA\u0017\u0011\u001d\tig\u0004a\u0002\u0003_Bq!! \u0010\u0001\u0004\ty\bC\u0004\u0002\u0014>\u0001\r!!&\u0002\u0003A\u0004B!a&\u0002\u001e6\u0011\u0011\u0011\u0014\u0006\u0004\u00037{\u0014!B7pI\u0016d\u0017\u0002BAP\u00033\u00131\u0002\u00157vm&|W.\u001a;fe\"9\u00111U\bA\u0002\u0005\u0015\u0016A\u0002;za\u0016LE\rE\u0002\u001c\u0003OK1!!+\u001d\u0005\rIe\u000e\u001e\u0005\u0007\u0003[{\u0001\u0019\u0001<\u0002\u0017QL\b/Z!rk\u00064$m\u001c\u0005\u0007\u0003c{\u0001\u0019\u0001<\u0002\tU\u001cXM]\u0001\fO\u0016$H*Y:u\t\u0006$X\r\u0006\u0005\u00028\u00065\u0017\u0011[Aj!\u0015Y\u0012\u0011OA]!\u0011\tY,!3\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\fA\u0001^5nK*!\u00111YAc\u0003\u0011Qw\u000eZ1\u000b\u0005\u0005\u001d\u0017aA8sO&!\u00111ZA_\u0005!!\u0015\r^3US6,\u0007bBAh!\u0001\u0007\u0011QU\u0001\nS\u0012\u001cF/\u0019;j_:Dq!a)\u0011\u0001\u0004\t)\u000bC\u0004\u0002VB\u0001\r!!*\u0002\rM$\u0018\r^;t\u0003eIW\u000e]8si\u0012\u000bG/\u0019$s_6\f\u0005+S0DY&l\u0017\r^8\u0015\u0011\u0005m\u0017\u0011]Ar\u0003K$b!!\u0004\u0002^\u0006}\u0007bBA\u0016#\u0001\u000f\u0011Q\u0006\u0005\b\u0003[\n\u00029AA8\u0011\u001d\ti(\u0005a\u0001\u0003\u007fBq!a%\u0012\u0001\u0004\t)\n\u0003\u0004\u00022F\u0001\rA^\u0001\u0016S6\u0004xN\u001d;ECR\fgI]8n\u0003BKul\u00142t)!\tY/!=\u0002t\u0006UHCBA\u0007\u0003[\fy\u000fC\u0004\u0002,I\u0001\u001d!!\f\t\u000f\u00055$\u0003q\u0001\u0002p!9\u0011Q\u0010\nA\u0002\u0005}\u0004bBAJ%\u0001\u0007\u0011Q\u0013\u0005\u0007\u0003c\u0013\u0002\u0019\u0001<")
public class MFController
implements Model {
    private final LogUtil LogUtil;
    private final JobLogUtil JobLogUtil;
    private final PluviometerDao pluviometerDao;
    private final GenericImportDao GenericImportDao;
    private final Database database;
    private final WSClient WSClient;
    private final String AQUA6BO;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        MFController mFController = this;
        synchronized (mFController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        MFController mFController = this;
        synchronized (mFController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    private String AQUA6BO() {
        return this.AQUA6BO;
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.INTEGRATION_MF_OBS_TOPIC();
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_MF_OBS_JOB();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.executeImport(message);
            return;
        }
        if (string != null) {
            String string4 = string;
            this.LogUtil.info(new StringBuilder(35).append("Bad routing key in MFController => ").append(string4).toString(), this.LogUtil.info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    public Object executeImport(JsValue message) {
        return message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            Predef$.MODULE$.print(error);
            $this.LogUtil.error(new StringBuilder(52).append("Error validate Json to execute MF obs integration :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.LogUtil.error$default$2());
            return (Seq)Nil$.MODULE$;
        }, (Function1 & Serializable)jobParameters -> {
            MFController.$anonfun$executeImport$2(this, jobParameters);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<MFStation> getStationsToImport(MFFilter filters, long jobExecutionId, Option<Object> debugMode) {
        String string = filters.codeMode();
        switch (string == null ? 0 : string.hashCode()) {
            case -1360151735: {
                if (!"cities".equals(string)) break;
                return (Seq)((IterableOps)((IterableOps)filters.cityCodes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)code -> {
                    String url = new StringBuilder(32).append(this.AQUA6BO()).append("/data/climatic/mf/stations?city=").append((String)code).toString();
                    $this.JobLogUtil.debug(jobExecutionId, new StringBuilder(17).append("Call aqua6bo url ").append(url).toString(), code, $this.JobLogUtil.debug$default$4(), debugMode);
                    return WSUtil$.MODULE$.getWithAuth(url, WSUtil$.MODULE$.getWithAuth$default$2(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), MFStation$.MODULE$.format()), $this.WSClient);
                })).flatten(Predef$.MODULE$.$conforms());
            }
            case 523904865: {
                if (!"departments".equals(string)) break;
                return (Seq)((IterableOps)((IterableOps)filters.departmentCodes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)code -> {
                    String url = new StringBuilder(38).append(this.AQUA6BO()).append("/data/climatic/mf/stations?department=").append((String)code).toString();
                    $this.JobLogUtil.debug(jobExecutionId, new StringBuilder(17).append("Call aqua6bo url ").append(url).toString(), code, $this.JobLogUtil.debug$default$4(), debugMode);
                    return WSUtil$.MODULE$.getWithAuth(url, WSUtil$.MODULE$.getWithAuth$default$2(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), MFStation$.MODULE$.format()), $this.WSClient);
                })).flatten(Predef$.MODULE$.$conforms());
            }
            case 1318331839: {
                if (!"stations".equals(string)) break;
                return (Seq)((IterableOps)filters.stationCodes().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)code -> {
                    String url = new StringBuilder(32).append(this.AQUA6BO()).append("/data/climatic/mf/stations?code=").append((String)code).toString();
                    $this.JobLogUtil.debug(jobExecutionId, new StringBuilder(17).append("Call aqua6bo url ").append(url).toString(), code, $this.JobLogUtil.debug$default$4(), debugMode);
                    return WSUtil$.MODULE$.getWithAuth(url, WSUtil$.MODULE$.getWithAuth$default$2(), MFStation$.MODULE$.format(), $this.WSClient);
                });
            }
        }
        throw new MatchError((Object)string);
    }

    public void importDataType(MFFilter filters, Pluviometer p, int typeId, String typeAqua6bo, String user, long jobExecutionId, Option<Object> debugMode) {
        String startDate = (String)filters.startDate().orElse((Function0 & Serializable)() -> {
            Object object = filters.importMode().getOrElse((Function0 & Serializable)() -> ImportMode$.MODULE$.ADD_LAST_DATA());
            String string = ImportMode$.MODULE$.ADD_LAST_DATA();
            if (!(object != null ? !object.equals(string) : string != null)) {
                return $this.GenericImportDao.getLastDateByStation(StationTypeUtil$.MODULE$.PLUVIOMETRY(), typeId, p.id(), $this.GenericImportDao.getLastDateByStation$default$4());
            }
            return None$.MODULE$;
        }).map((Function1 & Serializable)s -> new StringBuilder(11).append("&startDate=").append(Long.toString(s.getMillis())).toString()).getOrElse((Function0 & Serializable)() -> "");
        String url = new StringBuilder(40).append(this.AQUA6BO()).append("/data/climatic/mf/measures?code=").append(p.code().get()).append("&typeId=").append(typeAqua6bo).append(startDate).toString();
        this.JobLogUtil.debug(jobExecutionId, new StringBuilder(17).append("Call aqua6bo url ").append(url).toString(), (String)p.code().get(), this.JobLogUtil.debug$default$4(), debugMode);
        Option option = WSUtil$.MODULE$.getWithAuth(url, WSUtil$.MODULE$.getWithAuth$default$2(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), MFMeasure$.MODULE$.measureRead()), this.WSClient);
        if (None$.MODULE$.equals(option)) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(26).append("Error during aqua6bo call ").append(url).toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq measures = (Seq)some.value();
            this.JobLogUtil.log(jobExecutionId, measures.nonEmpty() ? JobState$.MODULE$.INFO() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(17).append(measures.length()).append(" measures fetched").append((Object)(measures.nonEmpty() ? ". Begin import" : "")).toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
            if (measures.nonEmpty()) {
                Option<String> x$1 = filters.importMode();
                Option<Object> x$2 = ImportOptions$.MODULE$.apply$default$1();
                Option<Object> x$32 = ImportOptions$.MODULE$.apply$default$3();
                Option<String> x$4 = ImportOptions$.MODULE$.apply$default$4();
                Option<Object> x$5 = ImportOptions$.MODULE$.apply$default$5();
                Option<Seq<Object>> x$6 = ImportOptions$.MODULE$.apply$default$6();
                Option<Object> x$7 = ImportOptions$.MODULE$.apply$default$7();
                int res = this.GenericImportDao.importPluviometry(Integer.toString(p.id()), (String)p.code().get(), user, jobExecutionId, (Seq<GenericData>)((Seq)measures.map((Function1 & Serializable)x$3 -> x$3.toGenericData(typeId))), (Option<ImportOptions>)new Some((Object)new ImportOptions(x$2, x$1, x$32, x$4, x$5, x$6, x$7)));
                this.JobLogUtil.log(jobExecutionId, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(19).append(res).append(" measures imported.").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public Option<DateTime> getLastDate(int idStation, int typeId, int status) {
        return (Option)this.database.withConnection((Function1 & Serializable)c -> {
            String statusStr = status == ReferentialUtil$.MODULE$.STATUS_BRUTE() ? " (statutmesure is null or statutmesure = 1)" : new StringBuilder(16).append(" statutmesure = ").append(status).toString();
            ParameterValue[] parameterValueArray = new ParameterValue[3];
            ToStatementPriority0.intToStatement$ x$3 = ToStatement$.MODULE$.intToStatement();
            Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)idStation), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
            ToStatementPriority0.intToStatement$ x$7 = ToStatement$.MODULE$.intToStatement();
            Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)typeId), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
            ToStatementPriority0.stringToStatement$ x$11 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
            parameterValueArray[2] = ParameterValue$.MODULE$.from((Object)statusStr, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
            return (Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select max(datemesure) from chroniques_pluvio where codepluviometre = ", " and typeid = ", " and #", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToJodaDateTime()).singleOpt(), c);
        });
    }

    public void importDataFromAPI_Climato(MFFilter filters, Pluviometer p, String user, long jobExecutionId, Option<Object> debugMode) {
        Option<DateTime> lastDateNv1 = this.getLastDate(p.id(), BoxesRunTime.unboxToInt((Object)filters.rainDt().get()), ReferentialUtil$.MODULE$.STATUS_NV1());
        DateTime startDateApiClimato = new DateTime().withTimeAtStartOfDay().minusDays(3);
        long endDateApiClimato = new DateTime().withTime(new DateTime().getHourOfDay(), 0, 0, 0).minusDays(1).getMillis();
        long startDate = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)new .colon.colon(lastDateNv1, (List)new .colon.colon((Object)new Some((Object)startDateApiClimato), (List)Nil$.MODULE$)).flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getMillis()))).max((Ordering)Ordering.Long$.MODULE$));
        String url = new StringBuilder(55).append(this.AQUA6BO()).append("/data/climatic/mfAPI/climatic?code=").append(p.code().get()).append("&startDate=").append(startDate).append("&endDate=").append(endDateApiClimato).toString();
        this.JobLogUtil.debug(jobExecutionId, new StringBuilder(17).append("Call aqua6bo url ").append(url).toString(), (String)p.code().get(), this.JobLogUtil.debug$default$4(), debugMode);
        Option option = WSUtil$.MODULE$.getWithAuth(url, new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)523), (JFunction0.mcV.sp & Serializable)() -> this.handle523Error$1(jobExecutionId, p), (Object)new Some((Object)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)404), (JFunction0.mcV.sp & Serializable)() -> this.handle404Error$1(jobExecutionId, p), (Object)new Some((Object)Nil$.MODULE$)), (List)Nil$.MODULE$)), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), MFMeasureFull$.MODULE$.measureRead()), this.WSClient);
        if (None$.MODULE$.equals(option)) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(51).append("Error during aqua6bo call for CLIMATO API with url ").append(url).toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq measures = (Seq)some.value();
            this.JobLogUtil.log(jobExecutionId, measures.nonEmpty() ? JobState$.MODULE$.INFO() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(17).append(measures.length()).append(" measures fetched").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
            if (measures.nonEmpty() && filters.rain().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters.rainDt().isDefined()) {
                Seq rainMeasures = (Seq)measures.flatMap((Function1 & Serializable)x$5 -> x$5.toGenericDataRain(BoxesRunTime.unboxToInt((Object)filters.rainDt().get()), ReferentialUtil$.MODULE$.STATUS_NV1()));
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(27).append("Importing ").append(rainMeasures.length()).append(" rain measures...").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
                Some x$1 = new Some((Object)ImportMode$.MODULE$.REPLACE_DATA());
                Option<Object> x$2 = ImportOptions$.MODULE$.apply$default$1();
                Option<Object> x$3 = ImportOptions$.MODULE$.apply$default$3();
                Option<String> x$42 = ImportOptions$.MODULE$.apply$default$4();
                Option<Object> x$52 = ImportOptions$.MODULE$.apply$default$5();
                Option<Seq<Object>> x$62 = ImportOptions$.MODULE$.apply$default$6();
                Option<Object> x$72 = ImportOptions$.MODULE$.apply$default$7();
                int res = this.GenericImportDao.importPluviometry(Integer.toString(p.id()), (String)p.code().get(), user, jobExecutionId, (Seq<GenericData>)rainMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$2, (Option<String>)x$1, x$3, x$42, x$52, x$62, x$72)));
                this.JobLogUtil.log(jobExecutionId, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(24).append(res).append(" rain measures imported.").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
            }
            if (measures.nonEmpty() && filters.temperature().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters.temperatureDt().isDefined()) {
                Seq tempMeasures = (Seq)measures.flatMap((Function1 & Serializable)x$6 -> x$6.toGenericDataTemperature(BoxesRunTime.unboxToInt((Object)filters.temperatureDt().get()), ReferentialUtil$.MODULE$.STATUS_NV1()));
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(34).append("Importing ").append(tempMeasures.length()).append(" temperature measures...").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
                Some x$8 = new Some((Object)ImportMode$.MODULE$.REPLACE_DATA());
                Option<Object> x$9 = ImportOptions$.MODULE$.apply$default$1();
                Option<Object> x$10 = ImportOptions$.MODULE$.apply$default$3();
                Option<String> x$11 = ImportOptions$.MODULE$.apply$default$4();
                Option<Object> x$12 = ImportOptions$.MODULE$.apply$default$5();
                Option<Seq<Object>> x$13 = ImportOptions$.MODULE$.apply$default$6();
                Option<Object> x$14 = ImportOptions$.MODULE$.apply$default$7();
                int res = this.GenericImportDao.importPluviometry(Integer.toString(p.id()), (String)p.code().get(), user, jobExecutionId, (Seq<GenericData>)tempMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$9, (Option<String>)x$8, x$10, x$11, x$12, x$13, x$14)));
                this.JobLogUtil.log(jobExecutionId, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(31).append(res).append(" temperature measures imported.").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
            }
            if (measures.nonEmpty() && filters.radiation().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters.radiationDt().isDefined()) {
                Seq radiationMeasures = (Seq)measures.flatMap((Function1 & Serializable)x$7 -> x$7.toGenericDataRadiation(BoxesRunTime.unboxToInt((Object)filters.radiationDt().get()), ReferentialUtil$.MODULE$.STATUS_NV1()));
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(32).append("Importing ").append(radiationMeasures.length()).append(" radiation measures...").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
                Some x$15 = new Some((Object)ImportMode$.MODULE$.REPLACE_DATA());
                Option<Object> x$16 = ImportOptions$.MODULE$.apply$default$1();
                Option<Object> x$17 = ImportOptions$.MODULE$.apply$default$3();
                Option<String> x$18 = ImportOptions$.MODULE$.apply$default$4();
                Option<Object> x$19 = ImportOptions$.MODULE$.apply$default$5();
                Option<Seq<Object>> x$20 = ImportOptions$.MODULE$.apply$default$6();
                Option<Object> x$21 = ImportOptions$.MODULE$.apply$default$7();
                int res = this.GenericImportDao.importPluviometry(Integer.toString(p.id()), (String)p.code().get(), user, jobExecutionId, (Seq<GenericData>)radiationMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$16, (Option<String>)x$15, x$17, x$18, x$19, x$20, x$21)));
                this.JobLogUtil.log(jobExecutionId, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(29).append(res).append(" radiation measures imported.").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void importDataFromAPI_Obs(MFFilter filters, Pluviometer p, String user, long jobExecutionId, Option<Object> debugMode) {
        Option<DateTime> lastDateNv1 = this.getLastDate(p.id(), BoxesRunTime.unboxToInt((Object)filters.rainDt().get()), ReferentialUtil$.MODULE$.STATUS_BRUTE());
        DateTime startDateApiBrute = new DateTime().withTime(new DateTime().getHourOfDay(), 0, 0, 0).minusDays(1);
        long endDateApiBrute = new DateTime().withTime(new DateTime().getHourOfDay(), 0, 0, 0).getMillis();
        long startDate = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)new .colon.colon(lastDateNv1, (List)new .colon.colon((Object)new Some((Object)startDateApiBrute), (List)Nil$.MODULE$)).flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.getMillis()))).max((Ordering)Ordering.Long$.MODULE$));
        String url = new StringBuilder(50).append(this.AQUA6BO()).append("/data/climatic/mfAPI/obs?code=").append(p.code().get()).append("&startDate=").append(startDate).append("&endDate=").append(endDateApiBrute).toString();
        this.JobLogUtil.debug(jobExecutionId, new StringBuilder(17).append("Call aqua6bo url ").append(url).toString(), (String)p.code().get(), this.JobLogUtil.debug$default$4(), debugMode);
        Option option = WSUtil$.MODULE$.getWithAuth(url, WSUtil$.MODULE$.getWithAuth$default$2(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), MFMeasureFull$.MODULE$.measureRead()), this.WSClient);
        if (None$.MODULE$.equals(option)) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(47).append("Error during aqua6bo call for OBS API with url ").append(url).toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq measures = (Seq)some.value();
            this.JobLogUtil.log(jobExecutionId, measures.nonEmpty() ? JobState$.MODULE$.INFO() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(17).append(measures.length()).append(" measures fetched").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
            if (measures.nonEmpty() && filters.rain().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters.rainDt().isDefined()) {
                Seq rainMeasures = (Seq)measures.flatMap((Function1 & Serializable)x$9 -> x$9.toGenericDataRain(BoxesRunTime.unboxToInt((Object)filters.rainDt().get()), ReferentialUtil$.MODULE$.STATUS_BRUTE()));
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(27).append("Importing ").append(rainMeasures.length()).append(" rain measures...").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
                Some x$1 = new Some((Object)ImportMode$.MODULE$.REPLACE_DATA());
                Option<Object> x$2 = ImportOptions$.MODULE$.apply$default$1();
                Option<Object> x$3 = ImportOptions$.MODULE$.apply$default$3();
                Option<String> x$4 = ImportOptions$.MODULE$.apply$default$4();
                Option<Object> x$5 = ImportOptions$.MODULE$.apply$default$5();
                Option<Seq<Object>> x$6 = ImportOptions$.MODULE$.apply$default$6();
                Option<Object> x$7 = ImportOptions$.MODULE$.apply$default$7();
                int res = this.GenericImportDao.importPluviometry(Integer.toString(p.id()), (String)p.code().get(), user, jobExecutionId, (Seq<GenericData>)rainMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$2, (Option<String>)x$1, x$3, x$4, x$5, x$6, x$7)));
                this.JobLogUtil.log(jobExecutionId, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(24).append(res).append(" rain measures imported.").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
            }
            if (measures.nonEmpty() && filters.temperature().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters.temperatureDt().isDefined()) {
                Seq tempMeasures = (Seq)measures.flatMap((Function1 & Serializable)x$10 -> x$10.toGenericDataTemperature(BoxesRunTime.unboxToInt((Object)filters.temperatureDt().get()), ReferentialUtil$.MODULE$.STATUS_BRUTE()));
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(34).append("Importing ").append(tempMeasures.length()).append(" temperature measures...").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
                Some x$82 = new Some((Object)ImportMode$.MODULE$.REPLACE_DATA());
                Option<Object> x$92 = ImportOptions$.MODULE$.apply$default$1();
                Option<Object> x$102 = ImportOptions$.MODULE$.apply$default$3();
                Option<String> x$112 = ImportOptions$.MODULE$.apply$default$4();
                Option<Object> x$12 = ImportOptions$.MODULE$.apply$default$5();
                Option<Seq<Object>> x$13 = ImportOptions$.MODULE$.apply$default$6();
                Option<Object> x$14 = ImportOptions$.MODULE$.apply$default$7();
                int res = this.GenericImportDao.importPluviometry(Integer.toString(p.id()), (String)p.code().get(), user, jobExecutionId, (Seq<GenericData>)tempMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$92, (Option<String>)x$82, x$102, x$112, x$12, x$13, x$14)));
                this.JobLogUtil.log(jobExecutionId, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(31).append(res).append(" temperature measures imported.").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
            }
            if (measures.nonEmpty() && filters.radiation().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters.radiationDt().isDefined()) {
                Seq radiationMeasures = (Seq)measures.flatMap((Function1 & Serializable)x$11 -> x$11.toGenericDataRadiation(BoxesRunTime.unboxToInt((Object)filters.radiationDt().get()), ReferentialUtil$.MODULE$.STATUS_BRUTE()));
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(32).append("Importing ").append(radiationMeasures.length()).append(" radiation measures...").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
                Some x$15 = new Some((Object)ImportMode$.MODULE$.REPLACE_DATA());
                Option<Object> x$16 = ImportOptions$.MODULE$.apply$default$1();
                Option<Object> x$17 = ImportOptions$.MODULE$.apply$default$3();
                Option<String> x$18 = ImportOptions$.MODULE$.apply$default$4();
                Option<Object> x$19 = ImportOptions$.MODULE$.apply$default$5();
                Option<Seq<Object>> x$20 = ImportOptions$.MODULE$.apply$default$6();
                Option<Object> x$21 = ImportOptions$.MODULE$.apply$default$7();
                int res = this.GenericImportDao.importPluviometry(Integer.toString(p.id()), (String)p.code().get(), user, jobExecutionId, (Seq<GenericData>)radiationMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$16, (Option<String>)x$15, x$17, x$18, x$19, x$20, x$21)));
                this.JobLogUtil.log(jobExecutionId, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(29).append(res).append(" radiation measures imported.").toString(), (String)p.code().get(), this.JobLogUtil.log$default$5());
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$executeImport$5(MFStation s$1, PluviometerListSpecific x$1) {
        Object object = x$1.code().getOrElse((Function0 & Serializable)() -> "");
        String string = s$1.code();
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$executeImport$7(MFController $this, long jobExecutionId$1, MFFilter filters$1, DateTime startDateApiClimato$1, String user$1, Option debugMode$1, Pluviometer p) {
        Option<DateTime> lastDateNv1;
        Option<DateTime> lastDateNv12;
        Option<DateTime> lastDateNv13;
        $this.JobLogUtil.checkExecutionAbort(jobExecutionId$1);
        if (filters$1.rain().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters$1.rainDt().isDefined() && ((lastDateNv13 = $this.getLastDate(p.id(), BoxesRunTime.unboxToInt((Object)filters$1.rainDt().get()), ReferentialUtil$.MODULE$.STATUS_NV1())).isEmpty() || ((BaseDateTime)lastDateNv13.get()).getMillis() < startDateApiClimato$1.getMillis() || new .colon.colon((Object)ImportMode$.MODULE$.REPLACE_DATA(), (List)new .colon.colon((Object)ImportMode$.MODULE$.REPLACE_HISTO(), (List)new .colon.colon((Object)ImportMode$.MODULE$.REPLACE_RECENT_HISTO(), (List)Nil$.MODULE$))).contains(filters$1.importMode().getOrElse((Function0 & Serializable)() -> "")))) {
            $this.importDataType(filters$1, p, BoxesRunTime.unboxToInt((Object)filters$1.rainDt().get()), "P", user$1, jobExecutionId$1, (Option<Object>)debugMode$1);
        }
        if (filters$1.temperature().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters$1.temperatureDt().isDefined() && ((lastDateNv12 = $this.getLastDate(p.id(), BoxesRunTime.unboxToInt((Object)filters$1.temperatureDt().get()), ReferentialUtil$.MODULE$.STATUS_NV1())).isEmpty() || ((BaseDateTime)lastDateNv12.get()).getMillis() < startDateApiClimato$1.getMillis() || new .colon.colon((Object)ImportMode$.MODULE$.REPLACE_DATA(), (List)new .colon.colon((Object)ImportMode$.MODULE$.REPLACE_HISTO(), (List)new .colon.colon((Object)ImportMode$.MODULE$.REPLACE_RECENT_HISTO(), (List)Nil$.MODULE$))).contains(filters$1.importMode().getOrElse((Function0 & Serializable)() -> "")))) {
            $this.importDataType(filters$1, p, BoxesRunTime.unboxToInt((Object)filters$1.temperatureDt().get()), "T", user$1, jobExecutionId$1, (Option<Object>)debugMode$1);
        }
        if (filters$1.etp().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters$1.etpDt().isDefined()) {
            $this.importDataType(filters$1, p, BoxesRunTime.unboxToInt((Object)filters$1.etpDt().get()), "E", user$1, jobExecutionId$1, (Option<Object>)debugMode$1);
        }
        if (filters$1.radiation().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters$1.radiationDt().isDefined() && ((lastDateNv1 = $this.getLastDate(p.id(), BoxesRunTime.unboxToInt((Object)filters$1.radiationDt().get()), ReferentialUtil$.MODULE$.STATUS_NV1())).isEmpty() || ((BaseDateTime)lastDateNv1.get()).getMillis() < startDateApiClimato$1.getMillis() || new .colon.colon((Object)ImportMode$.MODULE$.REPLACE_DATA(), (List)new .colon.colon((Object)ImportMode$.MODULE$.REPLACE_HISTO(), (List)new .colon.colon((Object)ImportMode$.MODULE$.REPLACE_RECENT_HISTO(), (List)Nil$.MODULE$))).contains(filters$1.importMode().getOrElse((Function0 & Serializable)() -> "")))) {
            $this.importDataType(filters$1, p, BoxesRunTime.unboxToInt((Object)filters$1.radiationDt().get()), "R", user$1, jobExecutionId$1, (Option<Object>)debugMode$1);
        }
        if (filters$1.rain().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && filters$1.rainDt().isDefined()) {
            DateTime newLastDateNv1 = (DateTime)$this.getLastDate(p.id(), BoxesRunTime.unboxToInt((Object)filters$1.rainDt().get()), ReferentialUtil$.MODULE$.STATUS_NV1()).getOrElse((Function0 & Serializable)() -> new DateTime().minusYears(100));
            if (new DateTime().minusYears(1).getMillis() < newLastDateNv1.getMillis()) {
                $this.importDataFromAPI_Climato(filters$1, p, user$1, jobExecutionId$1, (Option<Object>)debugMode$1);
                $this.importDataFromAPI_Obs(filters$1, p, user$1, jobExecutionId$1, (Option<Object>)debugMode$1);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$executeImport$2(MFController $this, JobParameters jobParameters) {
        long jobExecutionId = jobParameters.jobExecutionId();
        Option debugMode = jobParameters.debugMode();
        String user = (String)jobParameters.user().get();
        MFFilter filters = (MFFilter)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new MFFilter(MFFilter$.MODULE$.$lessinit$greater$default$1(), MFFilter$.MODULE$.$lessinit$greater$default$2(), MFFilter$.MODULE$.$lessinit$greater$default$3(), MFFilter$.MODULE$.$lessinit$greater$default$4(), MFFilter$.MODULE$.$lessinit$greater$default$5(), MFFilter$.MODULE$.$lessinit$greater$default$6(), MFFilter$.MODULE$.$lessinit$greater$default$7(), MFFilter$.MODULE$.$lessinit$greater$default$8(), MFFilter$.MODULE$.$lessinit$greater$default$9(), MFFilter$.MODULE$.$lessinit$greater$default$10(), MFFilter$.MODULE$.$lessinit$greater$default$11(), MFFilter$.MODULE$.$lessinit$greater$default$12(), MFFilter$.MODULE$.$lessinit$greater$default$13(), MFFilter$.MODULE$.$lessinit$greater$default$14()), false, MFFilter$.MODULE$.format());
        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Fetching stations...", "", $this.JobLogUtil.log$default$5());
        Seq<MFStation> stationsToImport = $this.getStationsToImport(filters, jobExecutionId, (Option<Object>)debugMode);
        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(34).append(stationsToImport.length()).append(" stations fetched. Begin import...").toString(), "", $this.JobLogUtil.log$default$5());
        Seq allPluvios = $this.pluviometerDao.getAll($this.pluviometerDao.getAll$default$1(), $this.pluviometerDao.getAll$default$2());
        Seq pluvios = (Seq)$this.database.withTransaction((Function1 & Serializable)c -> (Seq)stationsToImport.map((Function1 & Serializable)s -> {
            Option option = allPluvios.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MFController.$anonfun$executeImport$5(s, x$1)));
            if (option instanceof Some) {
                Some some = (Some)option;
                PluviometerListSpecific sFound = (PluviometerListSpecific)some.value();
                Pluviometer newPluvio = s.toPluvio(sFound.id(), (Option<DateTime>)sFound.creationDate(), user, jobExecutionId);
                $this.pluviometerDao.updateWC(new PluviometerWithLinks(newPluvio), user, c);
                return newPluvio;
            }
            if (None$.MODULE$.equals(option)) {
                Pluviometer newPluvio = s.toPluvio(0, (Option<DateTime>)new Some((Object)new DateTime()), user, jobExecutionId);
                Tuple2 tuple2 = $this.pluviometerDao.createWC(new PluviometerWithLinks(newPluvio), user, c);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                double id = tuple2._2$mcD$sp();
                double id2 = id;
                return newPluvio.copy((int)id2, newPluvio.copy$default$2(), newPluvio.copy$default$3(), newPluvio.copy$default$4(), newPluvio.copy$default$5(), newPluvio.copy$default$6(), newPluvio.copy$default$7(), newPluvio.copy$default$8(), newPluvio.copy$default$9(), newPluvio.copy$default$10(), newPluvio.copy$default$11(), newPluvio.copy$default$12(), newPluvio.copy$default$13(), newPluvio.copy$default$14(), newPluvio.copy$default$15(), newPluvio.copy$default$16(), newPluvio.copy$default$17(), newPluvio.copy$default$18(), newPluvio.copy$default$19(), newPluvio.copy$default$20(), newPluvio.copy$default$21());
            }
            throw new MatchError((Object)option);
        }));
        $this.JobLogUtil.checkExecutionAbort(jobExecutionId);
        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(38).append(stationsToImport.length()).append(" stations updated/created with success").toString(), "", $this.JobLogUtil.log$default$5());
        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "starting measures import", "", $this.JobLogUtil.log$default$5());
        DateTime startDateApiClimato = new DateTime().withTimeAtStartOfDay().minusDays(3);
        pluvios.foreach((Function1 & Serializable)p -> {
            MFController.$anonfun$executeImport$7($this, jobExecutionId, filters, startDateApiClimato, user, debugMode, p);
            return BoxedUnit.UNIT;
        });
        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.STATION_IDS(), ((IterableOnceOps)pluvios.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()))).mkString(","), "", $this.JobLogUtil.log$default$5());
    }

    private final void handle523Error$1(long jobExecutionId$3, Pluviometer p$2) {
        this.JobLogUtil.log(jobExecutionId$3, JobState$.MODULE$.WARNING(), "API returned no data cause of missing data in MF store.", (String)p$2.code().get(), this.JobLogUtil.log$default$5());
    }

    private final void handle404Error$1(long jobExecutionId$3, Pluviometer p$2) {
        this.JobLogUtil.log(jobExecutionId$3, JobState$.MODULE$.WARNING(), "API returned 404 cause of station not found in hourly CLIMATO API.", (String)p$2.code().get(), this.JobLogUtil.log$default$5());
    }

    @Inject
    public MFController(LogUtil LogUtil2, JobLogUtil JobLogUtil2, PluviometerDao pluviometerDao, GenericImportDao GenericImportDao2, Database database, WSClient WSClient2) {
        this.LogUtil = LogUtil2;
        this.JobLogUtil = JobLogUtil2;
        this.pluviometerDao = pluviometerDao;
        this.GenericImportDao = GenericImportDao2;
        this.database = database;
        this.WSClient = WSClient2;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        this.AQUA6BO = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"AQUA6BO_URL", (Function0 & Serializable)() -> "https://aqua6bo.aquadb.fr");
        Statics.releaseFence();
    }
}

