/*
 * Decompiled with CFR 0.152.
 */
package meteofrance.radar;

import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constant.ImportMode$;
import era5.ERA5Coordinates;
import era5.ERA5Coordinates$;
import fr.aquasys.daeau.iaeau.model.PredMeasure;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.pluviometry.domain.PluviometerWithLinks;
import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.pluviometry.model.Pluviometer;
import fr.aquasys.daeau.pluviometry.model.Pluviometer$;
import fr.aquasys.daeau.station.itf.DataTypeDao;
import fr.aquasys.daeau.station.links.pointprel.PointPrel;
import fr.aquasys.daeau.station.links.pointprel.PointPrel$;
import fr.aquasys.daeau.station.links.pointprel.PointPrelDao;
import fr.aquasys.daeau.station.model.DataType;
import fr.aquasys.daeau.station.model.DataType$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.AlgoUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.MathUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import genericImport.itf.GenericImportDao;
import genericImport.itf.PredImportDao;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import meteofrance.radar.ECMWF_SeedMeasure;
import meteofrance.radar.ECMWF_SeedMeasure$;
import meteofrance.radar.MF_PredMeasure;
import meteofrance.radar.MF_PredMeasure$;
import meteofrance.radar.MF_RadarFilter;
import meteofrance.radar.MF_RadarFilter$;
import meteofrance.radar.MF_SAFRAN_Measure$;
import org.joda.time.DateTime;
import org.joda.time.Hours;
import org.joda.time.ReadablePartial;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.ws.WSClient;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Buffer;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import util.CoordinatesUtil2$;
import util.WSUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001\u0002\n\u0014\u0001aA\u0001\"\n\u0001\u0003\u0002\u0003\u0006YA\n\u0005\te\u0001\u0011\t\u0011)A\u0006g!A\u0011\b\u0001B\u0001B\u0003-!\b\u0003\u0005E\u0001\t\u0005\t\u0015a\u0003F\u0011!a\u0005A!A!\u0002\u0017i\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b1B)\t\u0011m\u0003!\u0011!Q\u0001\fqC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006YA\u0019\u0005\u0006[\u0002!\tA\u001c\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!a\u0013\u0001\t\u0003\ni\u0005C\u0004\u0002d\u0001!\t!!\u001a\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAR\u0001\u0011\u0005\u0011Q\u0015\u0005\n\u0003s\u0003\u0011\u0013!C\u0001\u0003w\u0013!#\u0014$`%\u0006$\u0017M]\"p]R\u0014x\u000e\u001c7fe*\u0011A#F\u0001\u0006e\u0006$\u0017M\u001d\u0006\u0002-\u0005YQ.\u001a;f_\u001a\u0014\u0018M\\2f\u0007\u0001\u00192\u0001A\r !\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fMB\u0011\u0001eI\u0007\u0002C)\t!%A\u0002ba&L!\u0001J\u0011\u0003\u000b5{G-\u001a7\u0002\u000f1{w-\u0016;jYB\u0011q\u0005M\u0007\u0002Q)\u0011\u0011FK\u0001\u0005kRLGN\u0003\u0002,Y\u0005A!/\u00192cSRl\u0017O\u0003\u0002.]\u00059\u0011-];bgf\u001c(\"A\u0018\u0002\u0005\u0019\u0014\u0018BA\u0019)\u0005\u001daunZ+uS2\f!BS8c\u0019><W\u000b^5m!\t!t'D\u00016\u0015\t1D&A\u0003vi&d7/\u0003\u00029k\tQ!j\u001c2M_\u001e,F/\u001b7\u0002\u001dAdWO^5p[\u0016$XM\u001d#b_B\u00111HQ\u0007\u0002y)\u0011QHP\u0001\u0004SR4'BA A\u0003-\u0001H.\u001e<j_6,GO]=\u000b\u0005\u0005c\u0013!\u00023bK\u0006,\u0018BA\"=\u00059\u0001F.\u001e<j_6,G/\u001a:EC>\f\u0001cR3oKJL7-S7q_J$H)Y8\u0011\u0005\u0019SU\"A$\u000b\u0005uB%\"A%\u0002\u001b\u001d,g.\u001a:jG&k\u0007o\u001c:u\u0013\tYuI\u0001\tHK:,'/[2J[B|'\u000f\u001e#b_\u0006i\u0001K]3e\u00136\u0004xN\u001d;EC>\u0004\"A\u0012(\n\u0005=;%!\u0004)sK\u0012LU\u000e]8si\u0012\u000bw.\u0001\u0007Q_&tG\u000f\u0015:fY\u0012\u000bw\u000e\u0005\u0002S36\t1K\u0003\u0002U+\u0006I\u0001o\\5oiB\u0014X\r\u001c\u0006\u0003-^\u000bQ\u0001\\5oWNT!\u0001\u0017!\u0002\u000fM$\u0018\r^5p]&\u0011!l\u0015\u0002\r!>Lg\u000e\u001e)sK2$\u0015m\\\u0001\f\t\u0006$\u0018\rV=qK\u0012\u000bw\u000e\u0005\u0002^?6\taL\u0003\u0002>/&\u0011\u0001M\u0018\u0002\f\t\u0006$\u0018\rV=qK\u0012\u000bw.\u0001\u0005X'\u000ec\u0017.\u001a8u!\t\u00197.D\u0001e\u0015\t)g-\u0001\u0002xg*\u0011q\r[\u0001\u0005Y&\u00147O\u0003\u0002#S*\t!.\u0001\u0003qY\u0006L\u0018B\u00017e\u0005!96k\u00117jK:$\u0018A\u0002\u001fj]&$h\bF\u0001p)%\u0001(o\u001d;vm^D\u0018\u0010\u0005\u0002r\u00015\t1\u0003C\u0003&\u0013\u0001\u000fa\u0005C\u00033\u0013\u0001\u000f1\u0007C\u0003:\u0013\u0001\u000f!\bC\u0003E\u0013\u0001\u000fQ\tC\u0003M\u0013\u0001\u000fQ\nC\u0003Q\u0013\u0001\u000f\u0011\u000bC\u0003\\\u0013\u0001\u000fA\fC\u0003b\u0013\u0001\u000f!\r\u000b\u0002\nwB\u0019A0a\u0001\u000e\u0003uT!A`@\u0002\r%t'.Z2u\u0015\t\t\t!A\u0003kCZ\f\u00070C\u0002\u0002\u0006u\u0014a!\u00138kK\u000e$\u0018!D4fiJ{W\u000f^5oO.+\u0017\u0010\u0006\u0002\u0002\fA!\u0011QBA\u000e\u001d\u0011\ty!a\u0006\u0011\u0007\u0005E1$\u0004\u0002\u0002\u0014)\u0019\u0011QC\f\u0002\rq\u0012xn\u001c;?\u0013\r\tIbG\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0011q\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005e1$A\u0006iC:$G.Z#se>\u0014HCBA\u0013\u0003W\t\t\u0005E\u0002\u001b\u0003OI1!!\u000b\u001c\u0005\u0011)f.\u001b;\t\u000f\u000552\u00021\u0001\u00020\u0005\tQ\r\u0005\u0003\u00022\u0005mb\u0002BA\u001a\u0003oqA!!\u0005\u00026%\tA$C\u0002\u0002:m\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002>\u0005}\"!C#yG\u0016\u0004H/[8o\u0015\r\tId\u0007\u0005\b\u0003\u0007Z\u0001\u0019AA#\u00039QwNY#yK\u000e,H/[8o\u0013\u0012\u00042AGA$\u0013\r\tIe\u0007\u0002\u0005\u0019>tw-A\u0004fq\u0016\u001cW\u000f^3\u0015\r\u0005\u0015\u0012qJA*\u0011\u001d\t\t\u0006\u0004a\u0001\u0003\u0017\t!B]8vi&twmS3z\u0011\u001d\t)\u0006\u0004a\u0001\u0003/\nq!\\3tg\u0006<W\r\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\tiFZ\u0001\u0005UN|g.\u0003\u0003\u0002b\u0005m#a\u0002&t-\u0006dW/Z\u0001\u000eKb,7-\u001e;f\u00136\u0004xN\u001d;\u0015\t\u0005\u0015\u0012q\r\u0005\b\u0003+j\u0001\u0019AA,\u0003i9W\r^\"jif\u001cF/\u0019;j_:\u001c8i\\8sI&t\u0017\r^3t)\u0019\ti'a!\u0002\bR!\u0011qNAA!\u0019\t\t$!\u001d\u0002v%!\u00111OA \u0005\r\u0019V-\u001d\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0011\u00111P\u0001\u0005KJ\fW'\u0003\u0003\u0002\u0000\u0005e$aD#S\u0003V\u001aun\u001c:eS:\fG/Z:\t\u000f\u0005\rc\u0002q\u0001\u0002F!9\u0011Q\u0011\bA\u0002\u0005-\u0011\u0001C2jif\u001cu\u000eZ3\t\u000f\u0005%e\u00021\u0001\u0002\f\u00069\u0011\r\u001e;f[B$\bc\u0001\u000e\u0002\u000e&\u0019\u0011qR\u000e\u0003\u0007%sG/A\u0007hKR\u001cun\u001c:eg\u000e{G-\u001a\u000b\u0007\u0003\u0017\t)*a(\t\u000f\u0005]u\u00021\u0001\u0002\u001a\u0006\t\u0001\u0010E\u0002\u001b\u00037K1!!(\u001c\u0005\u0019!u.\u001e2mK\"9\u0011\u0011U\bA\u0002\u0005e\u0015!A=\u0002\u0017\u001d,G\u000fR1uCRL\b/\u001a\u000b\t\u0003\u0017\u000b9+a+\u00020\"9\u0011\u0011\u0016\tA\u0002\u0005-\u0011\u0001\u00028b[\u0016Dq!!,\u0011\u0001\u0004\tY!\u0001\u0003v]&$\b\"CAY!A\u0005\t\u0019AAZ\u0003\u001d\u0019w.\\7f]R\u0004RAGA[\u0003\u0017I1!a.\u001c\u0005\u0019y\u0005\u000f^5p]\u0006)r-\u001a;ECR\fG/\u001f9fI\u0011,g-Y;mi\u0012\u001aTCAA_U\u0011\t\u0019,a0,\u0005\u0005\u0005\u0007\u0003BAb\u0003\u001bl!!!2\u000b\t\u0005\u001d\u0017\u0011Z\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a3\u001c\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\f)MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class MF_RadarController
implements Model {
    private final LogUtil LogUtil;
    private final JobLogUtil JobLogUtil;
    private final PluviometerDao pluviometerDao;
    private final GenericImportDao GenericImportDao;
    private final PredImportDao PredImportDao;
    private final PointPrelDao PointPrelDao;
    private final DataTypeDao DataTypeDao;
    private final WSClient WSClient;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        MF_RadarController mF_RadarController = this;
        synchronized (mF_RadarController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        MF_RadarController mF_RadarController = this;
        synchronized (mF_RadarController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.INTEGRATION_MF_RADAR_TOPIC();
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_MF_RADAR_JOB();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.executeImport(message);
            return;
        }
        if (string != null) {
            String string4 = string;
            this.LogUtil.info(new StringBuilder(35).append("Bad routing key in MFController => ").append(string4).toString(), this.LogUtil.info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    public void executeImport(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            Predef$.MODULE$.print(error);
            $this.LogUtil.error(new StringBuilder(52).append("Error validate Json to execute MF obs integration :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.LogUtil.error$default$2());
            return (Seq)Nil$.MODULE$;
        }, (Function1 & Serializable)jobParameters -> {
            MF_RadarController.$anonfun$executeImport$2(this, jobParameters);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<ERA5Coordinates> getCityStationsCoordinates(String cityCode, int attempt, long jobExecutionId) {
        String url = new StringBuilder(83).append("https://aqua6bo.aquadb.fr/data/climatic/mf/SAFRAN/stations?code=").append(cityCode).append("&takePrincipal=true").toString();
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(20).append("call url for city : ").append(url).toString(), "", this.JobLogUtil.log$default$5());
        Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> WSUtil$.MODULE$.getWithAuthOneTry(url, 4, WSUtil$.MODULE$.getWithAuthOneTry$default$3(), WSUtil$.MODULE$.getWithAuthOneTry$default$4(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), ERA5Coordinates$.MODULE$.format()), $this.WSClient)).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (None$.MODULE$.equals(option)) {
            if (attempt == 3) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(66).append("3 attempt failed : Error while fetching stations with city code : ").append(cityCode).toString(), cityCode, this.JobLogUtil.log$default$5());
                return (Seq)Nil$.MODULE$;
            }
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(78).append("Attempt ").append(attempt).append(" failed, waiting 10s : Error while fetching stations with city code : ").append(cityCode).toString(), cityCode, this.JobLogUtil.log$default$5());
            Thread.sleep(10000L);
            return this.getCityStationsCoordinates(cityCode, attempt + 1, jobExecutionId);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq coords = (Seq)some.value();
            return coords;
        }
        throw new MatchError((Object)option);
    }

    public String getCoordsCode(double x, double y) {
        return new StringBuilder(8).append("SAFRAN_").append(Double.toString(x).replace(".0", "")).append("_").append(Double.toString(y).replace(".0", "")).toString();
    }

    public int getDatatype(String name, String unit, Option<String> comment) {
        Seq dataTypes = this.DataTypeDao.getPluvioDataTypes();
        Option option = dataTypes.find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)MF_RadarController.$anonfun$getDatatype$1(name, d)));
        if (option instanceof Some) {
            Some some = (Some)option;
            DataType d2 = (DataType)some.value();
            return (int)d2.id();
        }
        if (None$.MODULE$.equals(option)) {
            double newId = ((DataType)dataTypes.maxBy((Function1 & Serializable)x$24 -> BoxesRunTime.boxToDouble((double)x$24.id()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).id() + 1.0;
            double x$1 = ((DataType)dataTypes.maxBy((Function1 & Serializable)x$25 -> BoxesRunTime.boxToDouble((double)x$25.id()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).id() + 1.0;
            Some x$2 = new Some((Object)name);
            Some x$3 = new Some((Object)"SIP");
            Some x$4 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
            Some x$5 = new Some((Object)unit);
            Option<String> x$6 = comment;
            Option x$7 = DataType$.MODULE$.$lessinit$greater$default$4();
            Option x$8 = DataType$.MODULE$.$lessinit$greater$default$6();
            Option x$9 = DataType$.MODULE$.$lessinit$greater$default$7();
            Option x$10 = DataType$.MODULE$.$lessinit$greater$default$9();
            Option x$11 = DataType$.MODULE$.$lessinit$greater$default$10();
            Option x$12 = DataType$.MODULE$.$lessinit$greater$default$11();
            Option x$13 = DataType$.MODULE$.$lessinit$greater$default$12();
            Option x$14 = DataType$.MODULE$.$lessinit$greater$default$13();
            Option x$15 = DataType$.MODULE$.$lessinit$greater$default$14();
            Option x$16 = DataType$.MODULE$.$lessinit$greater$default$15();
            Option x$17 = DataType$.MODULE$.$lessinit$greater$default$16();
            Option x$18 = DataType$.MODULE$.$lessinit$greater$default$17();
            Option x$19 = DataType$.MODULE$.$lessinit$greater$default$18();
            Option x$20 = DataType$.MODULE$.$lessinit$greater$default$19();
            Option x$21 = DataType$.MODULE$.$lessinit$greater$default$20();
            Option x$22 = DataType$.MODULE$.$lessinit$greater$default$21();
            Option x$23 = DataType$.MODULE$.$lessinit$greater$default$23();
            Option x$242 = DataType$.MODULE$.$lessinit$greater$default$24();
            DataType newDt = new DataType(x$1, (Option)x$2, (Option)x$3, x$7, (Option)x$4, x$8, x$9, (Option)x$5, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$6, x$23, x$242);
            this.DataTypeDao.setDataTypesByProject("SIP", (Seq)dataTypes.$colon$plus((Object)newDt));
            return (int)newId;
        }
        throw new MatchError((Object)option);
    }

    public Option<String> getDatatype$default$3() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$executeImport$8(MF_RadarController $this, ERA5Coordinates c$1, Pluviometer x$1) {
        Object object = x$1.code().getOrElse((Function0 & Serializable)() -> "");
        String string = $this.getCoordsCode(c$1.x(), c$1.y());
        return !(object != null ? !object.equals(string) : string != null);
    }

    private final void progress$1(DoubleRef current$1, double step$1, long jobExecutionId$1) {
        current$1.elem += step$1;
        this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.PROGRESS(), Integer.toString((int)current$1.elem), "", this.JobLogUtil.log$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$executeImport$16(int temperatureDt$1, PointPrel p) {
        return p.typeId() == temperatureDt$1 && p.typePoint() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$executeImport$18(Tuple2 x$6) {
        return ((Option)x$6._1()).contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ Seq $anonfun$executeImport$15(MF_RadarController $this, int temperatureDt$1, MF_RadarFilter filters$1, Seq points$1, Pluviometer station$1, int dt) {
        if (dt == temperatureDt$1 && (filters$1.temperatureMin().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) || filters$1.temperatureMax().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)))) {
            return (Seq)((IterableOps)new .colon.colon((Object)new Tuple2(filters$1.temperature(), (Object)points$1.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)MF_RadarController.$anonfun$executeImport$16(temperatureDt$1, p))).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.point()))), (List)new .colon.colon((Object)new Tuple2(filters$1.temperatureMin(), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)31))), (List)new .colon.colon((Object)new Tuple2(filters$1.temperatureMax(), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)32))), (List)Nil$.MODULE$))).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MF_RadarController.$anonfun$executeImport$18(x$6)))).map((Function1 & Serializable)tuple -> (DateTime)$this.GenericImportDao.getLastDateByStation(StationTypeUtil$.MODULE$.PLUVIOMETRY(), dt, station$1.id(), (Option<Object>)((Option)tuple._2())).getOrElse((Function0 & Serializable)() -> new DateTime().withYear(1950)));
        }
        return new .colon.colon((Object)((DateTime)$this.GenericImportDao.getLastDateByStation(StationTypeUtil$.MODULE$.PLUVIOMETRY(), dt, station$1.id(), $this.GenericImportDao.getLastDateByStation$default$4()).getOrElse((Function0 & Serializable)() -> new DateTime().withYear(1950))), (List)Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$executeImport$34(GenericData x$8) {
        return x$8.value().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$executeImport$36(GenericData x$9) {
        return x$9.value().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$executeImport$38(GenericData x$10) {
        return x$10.value().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$executeImport$39(int temperatureDt$1, PointPrel p) {
        return p.typeId() == temperatureDt$1 && p.point() == 31;
    }

    public static final /* synthetic */ boolean $anonfun$executeImport$40(int temperatureDt$1, PointPrel p) {
        return p.typeId() == temperatureDt$1 && p.point() == 32;
    }

    public static final /* synthetic */ boolean $anonfun$executeImport$45(GenericData x$11) {
        return x$11.value().isDefined();
    }

    public static final /* synthetic */ String $anonfun$executeImport$46(double c2) {
        SeqOps seqOps;
        String n = Double.toString(MathUtil$.MODULE$.roundAt2(c2));
        List list = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(n), '.')).toList();
        if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) {
            throw new MatchError((Object)list);
        }
        String head = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        String tail = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        Tuple2 tuple2 = new Tuple2((Object)head, (Object)tail);
        String head2 = (String)tuple2._1();
        String tail2 = (String)tuple2._2();
        String newTail = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(new StringBuilder(1).append(".").append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(new StringBuilder(3).append(tail2).append("000").toString()), 2)).toString()))), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(".0"), BoxesRunTime.unboxToChar((Object)c))))));
        return new StringBuilder(0).append(head2).append(newTail).toString();
    }

    public static final /* synthetic */ long $anonfun$executeImport$48(MF_PredMeasure x$13) {
        return x$13.date().getMillis();
    }

    public static final /* synthetic */ long $anonfun$executeImport$51(MF_PredMeasure x$15) {
        return x$15.date().getMillis();
    }

    public static final /* synthetic */ long $anonfun$executeImport$56(MF_PredMeasure x$18) {
        return x$18.date().getMillis();
    }

    public static final /* synthetic */ long $anonfun$executeImport$58(MF_PredMeasure x$19) {
        return x$19.date().getMillis();
    }

    public static final /* synthetic */ long $anonfun$executeImport$63(ECMWF_SeedMeasure x$21) {
        return x$21.date().getMillis();
    }

    public static final /* synthetic */ long $anonfun$executeImport$65(ECMWF_SeedMeasure x$22) {
        return x$22.date().getMillis();
    }

    public static final /* synthetic */ void $anonfun$executeImport$13(MF_RadarController $this, long jobExecutionId$1, MF_RadarFilter filters$1, int temperatureDt$1, int etrDt$1, int humidityDt$1, int windDt$1, int soilHumidityDt$1, int radiationDt$1, int drainDt$1, int runoffDt$1, int humiditySpeDt$1, String user$1, int snowDt$1, DoubleRef current$1, double step$1, Pluviometer station) {
        String code = (String)station.code().get();
        String coords = ((String)station.code().get()).replace("SAFRAN_", "");
        Seq points = $this.PointPrelDao.getPoints(StationTypeUtil$.MODULE$.PLUVIOMETRY(), station.id());
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(28).append("fetch measures for coords : ").append(coords).toString(), code, $this.JobLogUtil.log$default$5());
        String startDate = (String)(filters$1.importMode().contains((Object)ImportMode$.MODULE$.ADD_LAST_DATA()) ? ((IterableOnceOps)((IterableOps)((IterableOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, temperatureDt$1, etrDt$1, humidityDt$1, windDt$1, soilHumidityDt$1, radiationDt$1, drainDt$1, runoffDt$1, humiditySpeDt$1})).distinct()).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 > 0)).flatMap((Function1 & Serializable)dt -> MF_RadarController.$anonfun$executeImport$15($this, temperatureDt$1, filters$1, points, station, BoxesRunTime.unboxToInt((Object)dt)))).minByOption((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.getMillis()), (Ordering)Ordering.Long$.MODULE$) : None$.MODULE$).map((Function1 & Serializable)d -> new StringBuilder(11).append("&startDate=").append(Long.toString(d.getMillis())).toString()).getOrElse((Function0 & Serializable)() -> "");
        String url = new StringBuilder(66).append("https://aqua6bo.aquadb.fr/data/climatic/mf/SAFRAN/measures?coords=").append(coords).append(startDate).toString();
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(9).append("call url ").append(url).toString(), "", $this.JobLogUtil.log$default$5());
        Option option = WSUtil$.MODULE$.getWithAuth(url, WSUtil$.MODULE$.getWithAuth$default$2(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), MF_SAFRAN_Measure$.MODULE$.measureRead()), $this.WSClient);
        if (None$.MODULE$.equals(option)) {
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(26).append("Error during aqua6bo call ").append(url).toString(), code, $this.JobLogUtil.log$default$5());
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Seq measures = (Seq)some.value();
            $this.JobLogUtil.log(jobExecutionId$1, measures.nonEmpty() ? JobState$.MODULE$.INFO() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(17).append(measures.length()).append(" measures fetched").append((Object)(measures.nonEmpty() ? ". Begin import" : "")).toString(), code, $this.JobLogUtil.log$default$5());
            if (measures.nonEmpty()) {
                Object object;
                if (filters$1.rain().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)measures.map((Function1 & Serializable)m -> new GenericData(m.date(), m.date(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)m.rain())), 1, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
                    Option<String> x$222 = filters$1.importMode();
                    Option<Object> x$232 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$24 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$25 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$26 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$27 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$28 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$232, x$222, x$24, x$25, x$26, x$27, x$28)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(24).append(res).append(" rain measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.etp().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)measures.map((Function1 & Serializable)m -> new GenericData(m.date(), m.date(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)m.etp())), 3, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
                    Option<String> x$29 = filters$1.importMode();
                    Option<Object> x$30 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$31 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$32 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$33 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$34 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$35 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$30, x$29, x$31, x$32, x$33, x$34, x$35)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(23).append(res).append(" ETP measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.temperature().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)measures.map((Function1 & Serializable)m -> new GenericData(m.date(), m.date(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)m.temperature())), temperatureDt$1, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
                    Option<String> x$36 = filters$1.importMode();
                    Option<Object> x$37 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$38 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$39 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$40 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$41 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$42 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$37, x$36, x$38, x$39, x$40, x$41, x$42)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(31).append(res).append(" temperature measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.etr().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)measures.map((Function1 & Serializable)m -> new GenericData(m.date(), m.date(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)m.etr())), etrDt$1, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
                    Option<String> x$43 = filters$1.importMode();
                    Option<Object> x$44 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$45 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$46 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$47 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$48 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$49 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$44, x$43, x$45, x$46, x$47, x$48, x$49)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(23).append(res).append(" ETR measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.humidity().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)measures.map((Function1 & Serializable)m -> new GenericData(m.date(), m.date(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)m.humidity())), humidityDt$1, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
                    Option<String> x$50 = filters$1.importMode();
                    Option<Object> x$51 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$52 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$53 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$54 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$55 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$56 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$51, x$50, x$52, x$53, x$54, x$55, x$56)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(28).append(res).append(" humidity measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.wind().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)measures.map((Function1 & Serializable)m -> new GenericData(m.date(), m.date(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)m.wind())), windDt$1, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
                    Option<String> x$57 = filters$1.importMode();
                    Option<Object> x$58 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$59 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$60 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$61 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$62 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$63 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$58, x$57, x$59, x$60, x$61, x$62, x$63)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(24).append(res).append(" wind measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.soilHumidity().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)measures.map((Function1 & Serializable)m -> new GenericData(m.date(), m.date(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)m.soilHumidity())), soilHumidityDt$1, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
                    Option<String> x$64 = filters$1.importMode();
                    Option<Object> x$65 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$66 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$67 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$68 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$69 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$70 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$65, x$64, x$66, x$67, x$68, x$69, x$70)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(33).append(res).append(" soil humidity measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.radiation().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)measures.map((Function1 & Serializable)m -> new GenericData(m.date(), m.date(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)m.radiation())), radiationDt$1, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
                    Option<String> x$71 = filters$1.importMode();
                    Option<Object> x$72 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$73 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$74 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$75 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$76 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$77 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$72, x$71, x$73, x$74, x$75, x$76, x$77)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(29).append(res).append(" radiation measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.drain().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)((IterableOps)measures.map((Function1 & Serializable)m -> new GenericData(m.date(), m.date(), m.drain(), drainDt$1, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()))).filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MF_RadarController.$anonfun$executeImport$34(x$8)));
                    Option<String> x$78 = filters$1.importMode();
                    Option<Object> x$79 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$80 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$81 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$82 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$83 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$84 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$79, x$78, x$80, x$81, x$82, x$83, x$84)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(25).append(res).append(" drain measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.runoff().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)((IterableOps)measures.map((Function1 & Serializable)m -> new GenericData(m.date(), m.date(), m.runoff(), runoffDt$1, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()))).filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MF_RadarController.$anonfun$executeImport$36(x$9)));
                    Option<String> x$85 = filters$1.importMode();
                    Option<Object> x$86 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$87 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$88 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$89 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$90 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$91 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$86, x$85, x$87, x$88, x$89, x$90, x$91)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(26).append(res).append(" runoff measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.humiditySpe().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)((IterableOps)measures.map((Function1 & Serializable)m -> new GenericData(m.date(), m.date(), m.humiditySpe(), humiditySpeDt$1, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()))).filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MF_RadarController.$anonfun$executeImport$38(x$10)));
                    Option<String> x$92 = filters$1.importMode();
                    Option<Object> x$93 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$94 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$95 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$96 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$97 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$98 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$93, x$92, x$94, x$95, x$96, x$97, x$98)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(37).append(res).append(" specific humidity measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.temperatureMin().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) || filters$1.temperatureMax().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    .colon.colon pointMax;
                    .colon.colon colon2;
                    .colon.colon pointMin;
                    .colon.colon colon3;
                    if (!points.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)MF_RadarController.$anonfun$executeImport$39(temperatureDt$1, p)))) {
                        int x$99 = station.id();
                        int x$100 = 31;
                        int x$101 = temperatureDt$1;
                        String x$102 = "31";
                        String x$103 = "Temp\u00e9rature Min";
                        Some x$104 = new Some((Object)user$1);
                        Some x$105 = new Some((Object)new DateTime());
                        Some x$106 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$1));
                        int x$107 = 2;
                        Option x$108 = PointPrel$.MODULE$.$lessinit$greater$default$6();
                        Option x$109 = PointPrel$.MODULE$.$lessinit$greater$default$7();
                        Option x$110 = PointPrel$.MODULE$.$lessinit$greater$default$8();
                        Option x$111 = PointPrel$.MODULE$.$lessinit$greater$default$9();
                        Option x$112 = PointPrel$.MODULE$.$lessinit$greater$default$10();
                        Option x$113 = PointPrel$.MODULE$.$lessinit$greater$default$11();
                        Option x$114 = PointPrel$.MODULE$.$lessinit$greater$default$12();
                        .colon.colon colon4 = new .colon.colon((Object)new PointPrel(x$99, 31, x$101, "31", "Temp\u00e9rature Min", x$108, x$109, x$110, x$111, x$112, x$113, x$114, 2, (Option)x$104, (Option)x$105, (Option)x$106), (List)Nil$.MODULE$);
                        colon3 = colon4;
                    } else {
                        colon3 = pointMin = (Seq)Nil$.MODULE$;
                    }
                    if (!points.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)MF_RadarController.$anonfun$executeImport$40(temperatureDt$1, p)))) {
                        int x$115 = station.id();
                        int x$116 = 32;
                        int x$117 = temperatureDt$1;
                        String x$118 = "32";
                        String x$119 = "Temp\u00e9rature Max";
                        Some x$120 = new Some((Object)user$1);
                        Some x$121 = new Some((Object)new DateTime());
                        Some x$122 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$1));
                        int x$123 = 2;
                        Option x$124 = PointPrel$.MODULE$.$lessinit$greater$default$6();
                        Option x$125 = PointPrel$.MODULE$.$lessinit$greater$default$7();
                        Option x$126 = PointPrel$.MODULE$.$lessinit$greater$default$8();
                        Option x$127 = PointPrel$.MODULE$.$lessinit$greater$default$9();
                        Option x$128 = PointPrel$.MODULE$.$lessinit$greater$default$10();
                        Option x$129 = PointPrel$.MODULE$.$lessinit$greater$default$11();
                        Option x$130 = PointPrel$.MODULE$.$lessinit$greater$default$12();
                        .colon.colon colon5 = new .colon.colon((Object)new PointPrel(x$115, 32, x$117, "32", "Temp\u00e9rature Max", x$124, x$125, x$126, x$127, x$128, x$129, x$130, 2, (Option)x$120, (Option)x$121, (Option)x$122), (List)Nil$.MODULE$);
                        colon2 = colon5;
                    } else {
                        colon2 = pointMax = (Seq)Nil$.MODULE$;
                    }
                    object = pointMin.nonEmpty() || pointMax.nonEmpty() ? BoxesRunTime.boxToInteger((int)$this.PointPrelDao.setPoints(StationTypeUtil$.MODULE$.PLUVIOMETRY(), station.id(), (Seq)((SeqOps)((IterableOps)points.$plus$plus((IterableOnce)pointMin)).$plus$plus((IterableOnce)pointMax)).distinctBy((Function1 & Serializable)p -> new StringBuilder(1).append(p.typeId()).append(":").append(p.point()).toString()), user$1, (Option)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$1)))) : BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
                if (filters$1.temperatureMin().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)measures.map((Function1 & Serializable)m -> {
                        DateTime x$131 = m.date();
                        DateTime x$132 = m.date();
                        Option<Object> x$133 = m.temperatureMin();
                        int x$134 = temperatureDt$1;
                        Some x$135 = new Some((Object)BoxesRunTime.boxToInteger((int)31));
                        Option x$136 = GenericData$.MODULE$.apply$default$5();
                        Option x$137 = GenericData$.MODULE$.apply$default$6();
                        Option x$138 = GenericData$.MODULE$.apply$default$7();
                        Option x$139 = GenericData$.MODULE$.apply$default$8();
                        Option x$140 = GenericData$.MODULE$.apply$default$9();
                        Option x$141 = GenericData$.MODULE$.apply$default$10();
                        Option x$142 = GenericData$.MODULE$.apply$default$11();
                        Option x$143 = GenericData$.MODULE$.apply$default$12();
                        Option x$144 = GenericData$.MODULE$.apply$default$13();
                        Option x$145 = GenericData$.MODULE$.apply$default$14();
                        return new GenericData(x$131, x$132, x$133, x$134, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144, x$145, (Option)x$135);
                    });
                    Option<String> x$146 = filters$1.importMode();
                    Option<Object> x$147 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$148 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$149 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$150 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$151 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$152 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$147, x$146, x$148, x$149, x$150, x$151, x$152)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(35).append(res).append(" temperature min measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.temperatureMax().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)measures.map((Function1 & Serializable)m -> {
                        DateTime x$153 = m.date();
                        DateTime x$154 = m.date();
                        Option<Object> x$155 = m.temperatureMax();
                        int x$156 = temperatureDt$1;
                        Some x$157 = new Some((Object)BoxesRunTime.boxToInteger((int)32));
                        Option x$158 = GenericData$.MODULE$.apply$default$5();
                        Option x$159 = GenericData$.MODULE$.apply$default$6();
                        Option x$160 = GenericData$.MODULE$.apply$default$7();
                        Option x$161 = GenericData$.MODULE$.apply$default$8();
                        Option x$162 = GenericData$.MODULE$.apply$default$9();
                        Option x$163 = GenericData$.MODULE$.apply$default$10();
                        Option x$164 = GenericData$.MODULE$.apply$default$11();
                        Option x$165 = GenericData$.MODULE$.apply$default$12();
                        Option x$166 = GenericData$.MODULE$.apply$default$13();
                        Option x$167 = GenericData$.MODULE$.apply$default$14();
                        return new GenericData(x$153, x$154, x$155, x$156, x$158, x$159, x$160, x$161, x$162, x$163, x$164, x$165, x$166, x$167, (Option)x$157);
                    });
                    Option<String> x$168 = filters$1.importMode();
                    Option<Object> x$169 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$170 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$171 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$172 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$173 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$174 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$169, x$168, x$170, x$171, x$172, x$173, x$174)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(35).append(res).append(" temperature max measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
                if (filters$1.snow().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    Seq dtMeasures = (Seq)((IterableOps)measures.map((Function1 & Serializable)m -> new GenericData(m.date(), m.date(), m.snow(), snowDt$1, GenericData$.MODULE$.apply$default$5(), GenericData$.MODULE$.apply$default$6(), GenericData$.MODULE$.apply$default$7(), GenericData$.MODULE$.apply$default$8(), GenericData$.MODULE$.apply$default$9(), GenericData$.MODULE$.apply$default$10(), GenericData$.MODULE$.apply$default$11(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()))).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MF_RadarController.$anonfun$executeImport$45(x$11)));
                    Option<String> x$175 = filters$1.importMode();
                    Option<Object> x$176 = ImportOptions$.MODULE$.apply$default$1();
                    Option<Object> x$177 = ImportOptions$.MODULE$.apply$default$3();
                    Option<String> x$178 = ImportOptions$.MODULE$.apply$default$4();
                    Option<Object> x$179 = ImportOptions$.MODULE$.apply$default$5();
                    Option<Seq<Object>> x$180 = ImportOptions$.MODULE$.apply$default$6();
                    Option<Object> x$181 = ImportOptions$.MODULE$.apply$default$7();
                    int res = $this.GenericImportDao.importPluviometry(Integer.toString(station.id()), code, user$1, jobExecutionId$1, (Seq<GenericData>)dtMeasures, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$176, x$175, x$177, x$178, x$179, x$180, x$181)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(24).append(res).append(" snow measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                    $this.progress$1(current$1, step$1, jobExecutionId$1);
                }
            }
        } else {
            throw new MatchError(option);
        }
        String wgs84Coords = ((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{BoxesRunTime.unboxToDouble((Object)station.x().get()), BoxesRunTime.unboxToDouble((Object)station.y().get())})).map((Function1 & Serializable)c -> MF_RadarController.$anonfun$executeImport$46(BoxesRunTime.unboxToDouble((Object)c)))).mkString("_");
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("coords for ").append(coords).append(" = ").append(wgs84Coords).toString());
        if (filters$1.addAROMEdata().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(34).append("fetch AROME measures for coords : ").append(wgs84Coords).toString(), code, $this.JobLogUtil.log$default$5());
            String url2 = new StringBuilder(70).append("https://aqua6bo.aquadb.fr/data/climaticPrevi/mf/arome/measures?coords=").append(wgs84Coords).toString();
            Option option2 = WSUtil$.MODULE$.getWithAuth(url2, WSUtil$.MODULE$.getWithAuth$default$2(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), MF_PredMeasure$.MODULE$.measureRead()), $this.WSClient);
            if (None$.MODULE$.equals(option2)) {
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(26).append("Error during aqua6bo call ").append(url2).toString(), code, $this.JobLogUtil.log$default$5());
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                Seq measures = (Seq)some.value();
                $this.JobLogUtil.log(jobExecutionId$1, measures.nonEmpty() ? JobState$.MODULE$.INFO() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(23).append(measures.length()).append(" AROME measures fetched").append((Object)(measures.nonEmpty() ? ". Begin import" : "")).toString(), code, $this.JobLogUtil.log$default$5());
                if (measures.nonEmpty()) {
                    MF_PredMeasure latest = (MF_PredMeasure)measures.maxBy((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)MF_RadarController.$anonfun$executeImport$48(x$13)), (Ordering)Ordering.Long$.MODULE$);
                    int sourceHorizon = Hours.hoursBetween((ReadablePartial)((MF_PredMeasure)measures.head()).simulationDate().toLocalDateTime(), (ReadablePartial)latest.date().toLocalDateTime()).getHours();
                    int res = $this.PredImportDao.importMeasures(station.id(), "M\u00e9t\u00e9o France Donn\u00e9es AROME", StationTypeUtil$.MODULE$.PLUVIOMETRY(), (String)filters$1.importMode().getOrElse((Function0 & Serializable)() -> ""), (Seq<PredMeasure>)((Seq)measures.map((Function1 & Serializable)x$14 -> x$14.toPred(station.id(), "M\u00e9t\u00e9o France Donn\u00e9es AROME", jobExecutionId$1, user$1, sourceHorizon))));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(25).append(res).append(" AROME measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                }
            } else {
                throw new MatchError(option2);
            }
            $this.progress$1(current$1, step$1, jobExecutionId$1);
        }
        if (filters$1.addARPEGEdata().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(35).append("fetch ARPEGE measures for coords : ").append(wgs84Coords).toString(), code, $this.JobLogUtil.log$default$5());
            String url3 = new StringBuilder(71).append("https://aqua6bo.aquadb.fr/data/climaticPrevi/mf/arpege/measures?coords=").append(wgs84Coords).toString();
            Option option3 = WSUtil$.MODULE$.getWithAuth(url3, WSUtil$.MODULE$.getWithAuth$default$2(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), MF_PredMeasure$.MODULE$.measureRead()), $this.WSClient);
            if (None$.MODULE$.equals(option3)) {
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(26).append("Error during aqua6bo call ").append(url3).toString(), code, $this.JobLogUtil.log$default$5());
            } else if (option3 instanceof Some) {
                Some some = (Some)option3;
                Seq measures = (Seq)some.value();
                $this.JobLogUtil.log(jobExecutionId$1, measures.nonEmpty() ? JobState$.MODULE$.INFO() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(24).append(measures.length()).append(" ARPEGE measures fetched").append((Object)(measures.nonEmpty() ? ". Begin import" : "")).toString(), code, $this.JobLogUtil.log$default$5());
                if (measures.nonEmpty()) {
                    MF_PredMeasure latest = (MF_PredMeasure)measures.maxBy((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)MF_RadarController.$anonfun$executeImport$51(x$15)), (Ordering)Ordering.Long$.MODULE$);
                    int sourceHorizon = Hours.hoursBetween((ReadablePartial)((MF_PredMeasure)measures.head()).simulationDate().toLocalDateTime(), (ReadablePartial)latest.date().toLocalDateTime()).getHours();
                    int res = $this.PredImportDao.importMeasures(station.id(), "M\u00e9t\u00e9o France Donn\u00e9es ARPEGE", StationTypeUtil$.MODULE$.PLUVIOMETRY(), (String)filters$1.importMode().getOrElse((Function0 & Serializable)() -> ""), (Seq<PredMeasure>)((Seq)measures.map((Function1 & Serializable)x$16 -> x$16.toPred(station.id(), "M\u00e9t\u00e9o France Donn\u00e9es ARPEGE", jobExecutionId$1, user$1, sourceHorizon))));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(26).append(res).append(" ARPEGE measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                }
            } else {
                throw new MatchError(option3);
            }
            $this.progress$1(current$1, step$1, jobExecutionId$1);
        }
        if (filters$1.addECMWFdata().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(34).append("fetch ECMWF measures for coords : ").append(wgs84Coords).toString(), code, $this.JobLogUtil.log$default$5());
            String url3 = new StringBuilder(67).append("https://aqua6bo.aquadb.fr/data/climaticPrevi/ecmwf/measures?coords=").append(wgs84Coords).toString();
            Option option4 = WSUtil$.MODULE$.getWithAuth(url3, WSUtil$.MODULE$.getWithAuth$default$2(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), MF_PredMeasure$.MODULE$.measureRead()), $this.WSClient);
            if (None$.MODULE$.equals(option4)) {
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(26).append("Error during aqua6bo call ").append(url3).toString(), code, $this.JobLogUtil.log$default$5());
            } else if (option4 instanceof Some) {
                Some some = (Some)option4;
                Seq measures = (Seq)some.value();
                $this.JobLogUtil.log(jobExecutionId$1, measures.nonEmpty() ? JobState$.MODULE$.INFO() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(23).append(measures.length()).append(" ECMWF measures fetched").append((Object)(measures.nonEmpty() ? ". Begin import" : "")).toString(), code, $this.JobLogUtil.log$default$5());
                if (measures.nonEmpty()) {
                    List correctedMeasures = measures.groupBy((Function1 & Serializable)x$17 -> x$17.simulationDate().toString("dd/MM/YYYY HH:mm:ss")).values().toList().flatMap((Function1 & Serializable)list -> (List)((Tuple2)((IterableOnceOps)list.sortBy((Function1 & Serializable)x$18 -> BoxesRunTime.boxToLong((long)MF_RadarController.$anonfun$executeImport$56(x$18)), (Ordering)Ordering.Long$.MODULE$)).foldLeft((Object)new Tuple2((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)0.0)), (Function2 & Serializable)(x0$2, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            MF_PredMeasure measure = (MF_PredMeasure)tuple2._2();
                            if (tuple22 != null) {
                                List built = (List)tuple22._1();
                                double previousCumul = tuple22._2$mcD$sp();
                                double x$182 = measure.value() - previousCumul;
                                DateTime x$183 = measure.copy$default$1();
                                DateTime x$184 = measure.copy$default$2();
                                return new Tuple2(built.$colon$plus((Object)measure.copy(x$183, x$184, x$182)), (Object)BoxesRunTime.boxToDouble((double)measure.value()));
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }))._1());
                    MF_PredMeasure latest = (MF_PredMeasure)correctedMeasures.maxBy((Function1 & Serializable)x$19 -> BoxesRunTime.boxToLong((long)MF_RadarController.$anonfun$executeImport$58(x$19)), (Ordering)Ordering.Long$.MODULE$);
                    int sourceHorizon = Hours.hoursBetween((ReadablePartial)((MF_PredMeasure)correctedMeasures.head()).simulationDate().toLocalDateTime(), (ReadablePartial)latest.date().toLocalDateTime()).getHours();
                    int res = $this.PredImportDao.importMeasures(station.id(), "Donn\u00e9es ECMWF", StationTypeUtil$.MODULE$.PLUVIOMETRY(), (String)filters$1.importMode().getOrElse((Function0 & Serializable)() -> ""), (Seq<PredMeasure>)correctedMeasures.map((Function1 & Serializable)x$20 -> x$20.toPred(station.id(), "Donn\u00e9es ECMWF", jobExecutionId$1, user$1, sourceHorizon)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(25).append(res).append(" ECMWF measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                }
            } else {
                throw new MatchError(option4);
            }
            $this.progress$1(current$1, step$1, jobExecutionId$1);
        }
        if (filters$1.addECMWFSeedsdata().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(40).append("fetch ECMWF Seeds measures for coords : ").append(wgs84Coords).toString(), code, $this.JobLogUtil.log$default$5());
            String url3 = new StringBuilder(72).append("https://aqua6bo.aquadb.fr/data/climaticPrevi/ecmwfSeeds/measures?coords=").append(wgs84Coords).toString();
            Option option5 = WSUtil$.MODULE$.getWithAuth(url3, WSUtil$.MODULE$.getWithAuth$default$2(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), ECMWF_SeedMeasure$.MODULE$.measureRead()), $this.WSClient);
            if (None$.MODULE$.equals(option5)) {
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(26).append("Error during aqua6bo call ").append(url3).toString(), code, $this.JobLogUtil.log$default$5());
            } else if (option5 instanceof Some) {
                Some some = (Some)option5;
                Seq measures = (Seq)some.value();
                $this.JobLogUtil.log(jobExecutionId$1, measures.nonEmpty() ? JobState$.MODULE$.INFO() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(29).append(measures.length()).append(" ECMWF Seeds measures fetched").append((Object)(measures.nonEmpty() ? ". Begin import" : "")).toString(), code, $this.JobLogUtil.log$default$5());
                if (measures.nonEmpty()) {
                    List correctedMeasures = measures.groupBy((Function1 & Serializable)m -> new StringBuilder(2).append(m.simulationDate().toString("dd/MM/YYYY HH:mm:ss")).append("--").append(Integer.toString((int)m.seed())).toString()).values().toList().flatMap((Function1 & Serializable)list -> (List)((Tuple2)((IterableOnceOps)list.sortBy((Function1 & Serializable)x$21 -> BoxesRunTime.boxToLong((long)MF_RadarController.$anonfun$executeImport$63(x$21)), (Ordering)Ordering.Long$.MODULE$)).foldLeft((Object)new Tuple2((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)0.0)), (Function2 & Serializable)(x0$3, x1$2) -> {
                        Tuple2 tuple2 = new Tuple2(x0$3, x1$2);
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            ECMWF_SeedMeasure measure = (ECMWF_SeedMeasure)tuple2._2();
                            if (tuple22 != null) {
                                List built = (List)tuple22._1();
                                double previousCumul = tuple22._2$mcD$sp();
                                double x$185 = measure.value() - previousCumul;
                                DateTime x$186 = measure.copy$default$1();
                                DateTime x$187 = measure.copy$default$2();
                                double x$188 = measure.copy$default$4();
                                return new Tuple2(built.$colon$plus((Object)measure.copy(x$186, x$187, x$185, x$188)), (Object)BoxesRunTime.boxToDouble((double)measure.value()));
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }))._1());
                    ECMWF_SeedMeasure latest = (ECMWF_SeedMeasure)correctedMeasures.maxBy((Function1 & Serializable)x$22 -> BoxesRunTime.boxToLong((long)MF_RadarController.$anonfun$executeImport$65(x$22)), (Ordering)Ordering.Long$.MODULE$);
                    int sourceHorizon = Hours.hoursBetween((ReadablePartial)((ECMWF_SeedMeasure)correctedMeasures.head()).simulationDate().toLocalDateTime(), (ReadablePartial)latest.date().toLocalDateTime()).getHours();
                    int res = $this.PredImportDao.importMeasures(station.id(), "Donn\u00e9es ECMWF Seeds", StationTypeUtil$.MODULE$.PLUVIOMETRY(), (String)filters$1.importMode().getOrElse((Function0 & Serializable)() -> ""), (Seq<PredMeasure>)correctedMeasures.map((Function1 & Serializable)x$23 -> x$23.toPred(station.id(), "Donn\u00e9es ECMWF Seeds", jobExecutionId$1, user$1, sourceHorizon)));
                    $this.JobLogUtil.log(jobExecutionId$1, res > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(31).append(res).append(" ECMWF Seeds measures imported.").toString(), code, $this.JobLogUtil.log$default$5());
                }
            } else {
                throw new MatchError(option5);
            }
            $this.progress$1(current$1, step$1, jobExecutionId$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$executeImport$2(MF_RadarController $this, JobParameters jobParameters) {
        long jobExecutionId = jobParameters.jobExecutionId();
        String user = (String)jobParameters.user().get();
        MF_RadarFilter filters = (MF_RadarFilter)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new MF_RadarFilter(MF_RadarFilter$.MODULE$.$lessinit$greater$default$1(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$2(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$3(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$4(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$5(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$6(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$7(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$8(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$9(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$10(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$11(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$12(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$13(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$14(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$15(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$16(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$17(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$18(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$19(), MF_RadarFilter$.MODULE$.$lessinit$greater$default$20()), false, MF_RadarFilter$.MODULE$.format());
        try {
            int snowDt;
            Buffer allPluvios = ((IterableOnceOps)$this.pluviometerDao.getAll($this.pluviometerDao.getAll$default$1(), $this.pluviometerDao.getAll$default$2()).map((Function1 & Serializable)p -> new Pluviometer(p.id(), p.name(), p.creationDate(), p.closeDate(), p.x(), p.y(), p.projectionType(), p.altitude(), p.measureExpression(), p.comment(), p.townCode(), p.contactCode(), p.code(), p.address(), p.countryCode(), p.contributorCode(), p.jobId(), p.updateLogin(), p.updateDate(), p.cityCodeDeclaration(), p.localization()))).toBuffer();
            int temperatureDt = filters.temperature().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) || filters.temperatureMin().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) || filters.temperatureMax().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? $this.getDatatype("Temp\u00e9rature", "\u00b0C", $this.getDatatype$default$3()) : 0;
            int etrDt = filters.etr().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? $this.getDatatype("ETR", "mm", $this.getDatatype$default$3()) : 0;
            int humidityDt = filters.humidity().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? $this.getDatatype("Humidit\u00e9", "%", $this.getDatatype$default$3()) : 0;
            int windDt = filters.wind().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? $this.getDatatype("Vent", "m/s", $this.getDatatype$default$3()) : 0;
            int soilHumidityDt = filters.soilHumidity().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? $this.getDatatype("Indice d'humidit\u00e9 des sols", "%", $this.getDatatype$default$3()) : 0;
            int radiationDt = filters.radiation().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? $this.getDatatype("Rayonnement", "J/cm2", $this.getDatatype$default$3()) : 0;
            int drainDt = filters.drain().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? $this.getDatatype("Drainage", "mm", $this.getDatatype$default$3()) : 0;
            int runoffDt = filters.runoff().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? $this.getDatatype("Ruissellement", "mm", $this.getDatatype$default$3()) : 0;
            int humiditySpeDt = filters.humiditySpe().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? $this.getDatatype("Humidit\u00e9 Sp\u00e9cifique", "g/kg", $this.getDatatype$default$3()) : 0;
            int n = snowDt = filters.snow().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? $this.getDatatype("Neige", "mm", (Option<String>)new Some((Object)"Equivalent en eau du manteau neigeux")) : 0;
            if (((SeqOps)filters.cities().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).isEmpty()) {
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No cities selected", "", $this.JobLogUtil.log$default$5());
            }
            Seq stationsWithReplicas = (Seq)((IterableOps)filters.cities().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)cityCode -> {
                Seq<ERA5Coordinates> coords = $this.getCityStationsCoordinates((String)cityCode, 1, jobExecutionId);
                return (Seq)((IterableOps)coords.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        ERA5Coordinates c = (ERA5Coordinates)tuple2._1();
                        int idx = tuple2._2$mcI$sp();
                        return (Pluviometer)allPluvios.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MF_RadarController.$anonfun$executeImport$8($this, c, x$1))).getOrElse((Function0 & Serializable)() -> {
                            Tuple2<Object, Object> tuple2 = CoordinatesUtil2$.MODULE$.convertCoordinateWithEPSG(c.x() * (double)100, c.y() * (double)100, "EPSG:27572", "EPSG:4326");
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            double newX = tuple2._1$mcD$sp();
                            double newY = tuple2._2$mcD$sp();
                            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(newX, newY);
                            double newX2 = sp2._1$mcD$sp();
                            double newY2 = sp2._2$mcD$sp();
                            boolean x$1 = false;
                            Some x$2 = new Some((Object)new StringBuilder(8).append("SAFRAN ").append(c.name()).append("_").append(idx + 1).toString());
                            Some x$3 = new Some((Object)new DateTime());
                            Some x$4 = new Some((Object)new DateTime());
                            Some x$5 = new Some((Object)user);
                            Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)((int)jobExecutionId)));
                            Some x$7 = new Some((Object)$this.getCoordsCode(c.x(), c.y()));
                            Some x$8 = new Some(cityCode);
                            Some x$9 = new Some((Object)BoxesRunTime.boxToDouble((double)newX2));
                            Some x$10 = new Some((Object)BoxesRunTime.boxToDouble((double)newY2));
                            Some x$11 = new Some((Object)BoxesRunTime.boxToInteger((int)16));
                            Option x$12 = Pluviometer$.MODULE$.$lessinit$greater$default$4();
                            Option x$13 = Pluviometer$.MODULE$.$lessinit$greater$default$8();
                            Option x$14 = Pluviometer$.MODULE$.$lessinit$greater$default$9();
                            Option x$15 = Pluviometer$.MODULE$.$lessinit$greater$default$10();
                            Option x$16 = Pluviometer$.MODULE$.$lessinit$greater$default$12();
                            Option x$17 = Pluviometer$.MODULE$.$lessinit$greater$default$14();
                            Option x$18 = Pluviometer$.MODULE$.$lessinit$greater$default$15();
                            Option x$19 = Pluviometer$.MODULE$.$lessinit$greater$default$16();
                            Option x$20 = Pluviometer$.MODULE$.$lessinit$greater$default$20();
                            Option x$21 = Pluviometer$.MODULE$.$lessinit$greater$default$21();
                            Pluviometer newStation = new Pluviometer(0, (Option)x$2, (Option)x$3, x$12, (Option)x$9, (Option)x$10, (Option)x$11, x$13, x$14, x$15, (Option)x$8, x$16, (Option)x$7, x$17, x$18, x$19, (Option)x$6, (Option)x$5, (Option)x$4, x$20, x$21);
                            Tuple2 tuple22 = $this.pluviometerDao.create(new PluviometerWithLinks(newStation), user);
                            if (tuple22 == null) {
                                throw new MatchError((Object)tuple22);
                            }
                            double id = tuple22._2$mcD$sp();
                            double id2 = id;
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(16).append("Station ").append(newStation.name().get()).append(" created").toString(), (String)newStation.code().get(), $this.JobLogUtil.log$default$5());
                            Pluviometer newWithId = newStation.copy((int)id2, newStation.copy$default$2(), newStation.copy$default$3(), newStation.copy$default$4(), newStation.copy$default$5(), newStation.copy$default$6(), newStation.copy$default$7(), newStation.copy$default$8(), newStation.copy$default$9(), newStation.copy$default$10(), newStation.copy$default$11(), newStation.copy$default$12(), newStation.copy$default$13(), newStation.copy$default$14(), newStation.copy$default$15(), newStation.copy$default$16(), newStation.copy$default$17(), newStation.copy$default$18(), newStation.copy$default$19(), newStation.copy$default$20(), newStation.copy$default$21());
                            allPluvios.append((Object)newWithId);
                            return newWithId;
                        });
                    }
                    throw new MatchError((Object)tuple2);
                });
            });
            Seq stations = AlgoUtil$.MODULE$.uniqBy(stationsWithReplicas, (Function1 & Serializable)s -> (String)s.code().get());
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(25).append("Begin update of ").append(stations.length()).append(" stations").toString(), "", $this.JobLogUtil.log$default$5());
            int nbData = package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{filters.rain(), filters.etp(), filters.temperature(), filters.etr(), filters.humidity(), filters.wind(), filters.soilHumidity(), filters.radiation(), filters.drain(), filters.runoff(), filters.humiditySpe(), filters.temperatureMin(), filters.temperatureMax(), filters.snow(), filters.addECMWFdata(), filters.addAROMEdata(), filters.addARPEGEdata(), filters.addECMWFSeedsdata()})).count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))));
            double step = 100.0 / (double)stations.length() / (double)nbData;
            DoubleRef current = DoubleRef.create((double)0.0);
            stations.foreach((Function1 & Serializable)station -> {
                MF_RadarController.$anonfun$executeImport$13($this, jobExecutionId, filters, temperatureDt, etrDt, humidityDt, windDt, soilHumidityDt, radiationDt, drainDt, runoffDt, humiditySpeDt, user, snowDt, current, step, station);
                return BoxedUnit.UNIT;
            });
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.PROGRESS(), "100", "", $this.JobLogUtil.log$default$5());
        }
        catch (Throwable e) {
            e.printStackTrace();
            $this.logUtil().printError(e);
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(19).append("Error during job : ").append(e.getMessage()).toString(), "", $this.JobLogUtil.log$default$5());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getDatatype$1(String name$1, DataType d) {
        String string = ((String)d.name().getOrElse((Function0 & Serializable)() -> "")).toLowerCase().replace("\u00e9", "e").replace("\u00e8", "e");
        String string2 = name$1.toLowerCase().replace("\u00e9", "e").replace("\u00e8", "e");
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Inject
    public MF_RadarController(LogUtil LogUtil2, JobLogUtil JobLogUtil2, PluviometerDao pluviometerDao, GenericImportDao GenericImportDao2, PredImportDao PredImportDao2, PointPrelDao PointPrelDao2, DataTypeDao DataTypeDao2, WSClient WSClient2) {
        this.LogUtil = LogUtil2;
        this.JobLogUtil = JobLogUtil2;
        this.pluviometerDao = pluviometerDao;
        this.GenericImportDao = GenericImportDao2;
        this.PredImportDao = PredImportDao2;
        this.PointPrelDao = PointPrelDao2;
        this.DataTypeDao = DataTypeDao2;
        this.WSClient = WSClient2;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        Statics.releaseFence();
    }
}

