/*
 * Decompiled with CFR 0.152.
 */
package mis;

import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.hydrometry.itf.HydrologicalStationDao;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.station.links.pointprel.PointPrel;
import fr.aquasys.daeau.station.links.pointprel.PointPrelDao;
import fr.aquasys.daeau.station.model.StationCode;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import genericImport.itf.GenericImportDao;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import mis.MISDataType;
import mis.MISFilter;
import mis.MISFilter$;
import mis.MISParameters;
import mis.MISParameters$;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\u0007\u000e\u0001AA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tU\u0001\u0011\t\u0011)A\u0005W!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u000b]\u0003A\u0011\u0001-\t\u000b)\u0004A\u0011I6\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0002\u000e\u001b&\u001b6i\u001c8ue>dG.\u001a:\u000b\u00039\t1!\\5t\u0007\u0001\u00192\u0001A\t\u0018!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fMB\u0011\u0001dG\u0007\u00023)\t!$A\u0002ba&L!\u0001H\r\u0003\u000b5{G-\u001a7\u0002\u000f1{w-\u0016;jYB\u0011q\u0004K\u0007\u0002A)\u0011\u0011EI\u0001\u0005kRLGN\u0003\u0002$I\u0005A!/\u00192cSRl\u0017O\u0003\u0002&M\u00059\u0011-];bgf\u001c(\"A\u0014\u0002\u0005\u0019\u0014\u0018BA\u0015!\u0005\u001daunZ+uS2\f\u0001cZ3oKJL7-S7q_J$H)Y8\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013aA5uM*\t\u0001'A\u0007hK:,'/[2J[B|'\u000f^\u0005\u0003e5\u0012\u0001cR3oKJL7-S7q_J$H)Y8\u0002\u0015){'\rT8h+RLG\u000e\u0005\u00026q5\taG\u0003\u00028I\u0005)Q\u000f^5mg&\u0011\u0011H\u000e\u0002\u000b\u0015>\u0014Gj\\4Vi&d\u0017a\u00049jKj|W.\u001a;fe\u0012\u000bW-Y;\u0011\u0005q\u0012U\"A\u001f\u000b\u00059r$BA A\u0003)\u0001\u0018.\u001a>p[\u0016$(/\u001f\u0006\u0003\u0003\u0012\nQ\u0001Z1fCVL!aQ\u001f\u0003\u001fAKWM_8nKR,'\u000fR1fCV\fA\u0002U8j]R\u0004&/\u001a7EC>\u0004\"AR'\u000e\u0003\u001dS!\u0001S%\u0002\u0013A|\u0017N\u001c;qe\u0016d'B\u0001&L\u0003\u0015a\u0017N\\6t\u0015\ta\u0005)A\u0004ti\u0006$\u0018n\u001c8\n\u00059;%\u0001\u0004)pS:$\bK]3m\t\u0006|\u0017A\u0006%zIJ|Gn\\4jG\u0006d7\u000b^1uS>tG)Y8\u0011\u0005E+V\"\u0001*\u000b\u00059\u001a&B\u0001+A\u0003)A\u0017\u0010\u001a:p[\u0016$(/_\u0005\u0003-J\u0013a\u0003S=ee>dwnZ5dC2\u001cF/\u0019;j_:$\u0015m\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fe[F,\u00180`AB\u0011!\fA\u0007\u0002\u001b!)Qd\u0002a\u0001=!)!f\u0002a\u0001W!)1g\u0002a\u0001i!)!h\u0002a\u0001w!)Ai\u0002a\u0001\u000b\")qj\u0002a\u0001!\"\u0012qA\u0019\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\fa!\u001b8kK\u000e$(\"A4\u0002\u000b)\fg/\u0019=\n\u0005%$'AB%oU\u0016\u001cG/A\u0004fq\u0016\u001cW\u000f^3\u0015\u00071|G\u0010\u0005\u0002\u0013[&\u0011an\u0005\u0002\u0005+:LG\u000fC\u0003q\u0011\u0001\u0007\u0011/\u0001\u0006s_V$\u0018N\\4LKf\u0004\"A]=\u000f\u0005M<\bC\u0001;\u0014\u001b\u0005)(B\u0001<\u0010\u0003\u0019a$o\\8u}%\u0011\u0001pE\u0001\u0007!J,G-\u001a4\n\u0005i\\(AB*ue&twM\u0003\u0002y'!)Q\u0010\u0003a\u0001}\u00069Q.Z:tC\u001e,\u0007cA@\u0002\u00105\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0003kg>t'\u0002BA\u0004\u0003\u0013\tA\u0001\\5cg*\u0019!$a\u0003\u000b\u0005\u00055\u0011\u0001\u00029mCfLA!!\u0005\u0002\u0002\t9!j\u001d,bYV,\u0017!D4fiJ{W\u000f^5oO.+\u0017\u0010F\u0001r\u0003-A\u0017M\u001c3mK\u0016\u0013(o\u001c:\u0015\u000b1\fY\"!\r\t\u000f\u0005u!\u00021\u0001\u0002 \u0005\tQ\r\u0005\u0003\u0002\"\u0005-b\u0002BA\u0012\u0003Oq1\u0001^A\u0013\u0013\u0005!\u0012bAA\u0015'\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0017\u0003_\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005%2\u0003C\u0004\u00024)\u0001\r!!\u000e\u0002\u001d)|'-\u0012=fGV$\u0018n\u001c8JIB\u0019!#a\u000e\n\u0007\u0005e2C\u0001\u0003M_:<\u0017\u0001E3yK\u000e,H/Z'J'&k\u0007o\u001c:u)%\t\u0018qHA!\u0003#\n)\u0006C\u0003~\u0017\u0001\u0007a\u0010C\u0004\u0002D-\u0001\r!!\u0012\u0002\u000f!,\u0017\rZ3sgB1!/a\u0012r\u0003\u0017J1!!\u0013|\u0005\ri\u0015\r\u001d\t\u0004%\u00055\u0013bAA('\t\u0019\u0011I\\=\t\r\u0005M3\u00021\u0001r\u0003\u0019iw\u000eZ;mK\"1\u0011qK\u0006A\u0002E\fA!^:fe\u0002")
public class MISController
implements Model {
    private final LogUtil LogUtil;
    private final GenericImportDao genericImportDao;
    private final JobLogUtil JobLogUtil;
    private final PiezometerDaeau piezometerDaeau;
    private final PointPrelDao PointPrelDao;
    private final HydrologicalStationDao HydrologicalStationDao;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        MISController mISController = this;
        synchronized (mISController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        MISController mISController = this;
        synchronized (mISController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_MIS();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.executeMISImport(message, (Map<String, Object>)new HashMap(), "WEB", "JOB_USER");
            return;
        }
        if (string != null) {
            String string4 = string;
            this.LogUtil.info(new StringBuilder(19).append("Bad routing key => ").append(string4).toString(), this.LogUtil.info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.MIS_TOPIC();
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    public String executeMISImport(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            Predef$.MODULE$.print(error);
            $this.LogUtil.error(new StringBuilder(22).append("Error validate Json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.LogUtil.error$default$2());
            return "";
        }, (Function1 & Serializable)jobParameters -> {
            String stationType;
            long jobExecutionId = jobParameters.jobExecutionId();
            String user = (String)jobParameters.user().get();
            String baseDir = (String)package$.MODULE$.env().getOrElse((Object)"UPLOAD_DIRECTORY", (Function0 & Serializable)() -> "");
            String directory = new StringBuilder(0).append(baseDir).append(jobParameters.path().getOrElse((Function0 & Serializable)() -> "")).toString();
            MISFilter filters = (MISFilter)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new MISFilter(MISFilter$.MODULE$.$lessinit$greater$default$1(), MISFilter$.MODULE$.$lessinit$greater$default$2(), MISFilter$.MODULE$.$lessinit$greater$default$3(), MISFilter$.MODULE$.$lessinit$greater$default$4(), MISFilter$.MODULE$.$lessinit$greater$default$5(), MISFilter$.MODULE$.$lessinit$greater$default$6(), MISFilter$.MODULE$.$lessinit$greater$default$7(), MISFilter$.MODULE$.$lessinit$greater$default$8(), MISFilter$.MODULE$.$lessinit$greater$default$9(), MISFilter$.MODULE$.$lessinit$greater$default$10(), MISFilter$.MODULE$.$lessinit$greater$default$11(), MISFilter$.MODULE$.$lessinit$greater$default$12(), MISFilter$.MODULE$.$lessinit$greater$default$13(), MISFilter$.MODULE$.$lessinit$greater$default$14(), MISFilter$.MODULE$.$lessinit$greater$default$15()), JobUtil$.MODULE$.getFilters$default$5(), MISFilter$.MODULE$.format());
            Seq parameters = JobUtil$.MODULE$.getParameters(jobParameters, jobExecutionId, $this.JobLogUtil, MISParameters$.MODULE$.format());
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)DateUtil$.MODULE$.correctDateFormat((String)filters.dateFormat().getOrElse((Function0 & Serializable)() -> "YYYYMMdd")));
            DateTimeFormatter htf = DateTimeFormat.forPattern((String)"HHmmss");
            DateTimeFormatter htf2 = DateTimeFormat.forPattern((String)"HH:mm:ss");
            DateTimeFormatter htf3 = DateTimeFormat.forPattern((String)"HH:mm");
            String string = stationType = StationTypeUtil$.MODULE$.StationType((String)filters.stationType().getOrElse((Function0 & Serializable)() -> "piezometry"));
            String string2 = StationTypeUtil$.MODULE$.HYDROMETRY();
            Seq stationCodes = !(string != null ? !string.equals(string2) : string2 != null) ? $this.HydrologicalStationDao.getCodes($this.HydrologicalStationDao.getCodes$default$1()) : (Seq)((IterableOps)$this.piezometerDaeau.getAllCodes($this.piezometerDaeau.getAllCodes$default$1()).$plus$plus((IterableOnce)$this.piezometerDaeau.getAllOldOrNewBssCodes())).map((Function1 & Serializable)code -> new StationCode((int)code.id(), code.code(), (Option)None$.MODULE$));
            HashSet filesToSetProcessed = new HashSet();
            Seq processedFiles = $this.JobLogUtil.getProcessedFileNames(jobExecutionId);
            Seq returnedData = (Seq)parameters.flatMap((Function1 & Serializable)stationParameters -> {
                .colon.colon toProcess;
                String stationCode = (String)stationParameters.stationCode().getOrElse((Function0 & Serializable)() -> "");
                String subDir = (String)stationParameters.directory().getOrElse((Function0 & Serializable)() -> "");
                String filter = (String)stationParameters.filter().getOrElse((Function0 & Serializable)() -> "*.xml.gz");
                IndexedSeq splitted = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)filter.split("\\*"));
                String starts = splitted.nonEmpty() ? (String)splitted.head() : filter;
                String ends = splitted.length() > 1 ? (String)splitted.apply(1) : "";
                String dirPath = new StringBuilder(0).append(directory).append(subDir).toString().replace("//", "/");
                if (!new File(dirPath).exists()) {
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(22).append("Directory not found : ").append(dirPath).toString(), "", "");
                    throw new Exception(new StringBuilder(22).append("Directory not found : ").append(dirPath).toString());
                }
                File[] testFiles = new File(dirPath).listFiles();
                File[] files = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])testFiles), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MISController.$anonfun$executeMISImport$12(starts, ends, f)))), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MISController.$anonfun$executeMISImport$13(f)));
                File[] filesToProcess = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(filters.dontProcessFilesInLogs().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? (Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MISController.$anonfun$executeMISImport$14(processedFiles, f))) : (Object[])files), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MISController.$anonfun$executeMISImport$15(f)));
                Object object = toProcess = jobParameters.isManualImport().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? new .colon.colon((Object)new File(""), (List)Nil$.MODULE$) : Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)filesToProcess);
                if (toProcess.nonEmpty()) {
                    return (IterableOnce)toProcess.flatMap((Function1 & Serializable)f -> {
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.START_DATA(), new StringBuilder(27).append("Begin integration of file: ").append(f.getName()).toString(), stationCode, $this.JobLogUtil.log$default$5());
                        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                            BufferedSource bufferedSource = jobParameters.isManualImport().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? Source$.MODULE$.fromBytes(Base64.decodeBase64((String)((String)jobParameters.fileContent().get())), Codec$.MODULE$.fallbackSystemCodec()) : Source$.MODULE$.fromFile(f.getAbsolutePath(), Codec$.MODULE$.fallbackSystemCodec());
                            return (Seq)((SeqOps)bufferedSource.getLines().foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable)(acc, line) -> {
                                if (line.trim().isEmpty()) {
                                    return acc;
                                }
                                if (line.trim().startsWith("<STATION>")) {
                                    .colon.colon colon2 = new .colon.colon(line, (List)Nil$.MODULE$);
                                    return (Seq)acc.$plus$colon((Object)colon2);
                                }
                                Seq seq = acc;
                                if (!(seq instanceof .colon.colon)) {
                                    throw new MatchError((Object)seq);
                                }
                                .colon.colon colon3 = (.colon.colon)seq;
                                Seq head = (Seq)colon3.head();
                                List queue = colon3.next$access$1();
                                Tuple2 tuple2 = new Tuple2((Object)head, (Object)queue);
                                Seq head2 = (Seq)tuple2._1();
                                List queue2 = (List)tuple2._2();
                                Seq seq2 = (Seq)head2.$colon$plus(line);
                                return queue2.$colon$colon((Object)seq2);
                            })).reverse();
                        });
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable error = failure.exception();
                            if (error.getMessage().equalsIgnoreCase("List() (of class scala.collection.immutable.Nil$)")) {
                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(54).append("Error while reading file: ").append(f.getName()).append(", possible corrupted file : ").append(error.getMessage()).toString(), stationCode, f.getName());
                            } else {
                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(36).append("Error while reading file: ").append(f.getName()).append(", error : ").append(error).toString(), stationCode, f.getName());
                            }
                            $this.JobLogUtil.setFileProcessed(f, jobExecutionId);
                            return Nil$.MODULE$;
                        }
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            Seq grouped = (Seq)success.value();
                            BooleanRef logCorrupted = BooleanRef.create((boolean)false);
                            ObjectRef usedCodeForLogs = ObjectRef.create((Object)"");
                            Seq results = (Seq)grouped.flatMap((Function1 & Serializable)group -> {
                                boolean bl = false;
                                Failure failure = null;
                                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                                    Seq seq = group;
                                    if (!(seq instanceof .colon.colon)) {
                                        throw new MatchError((Object)seq);
                                    }
                                    .colon.colon colon2 = (.colon.colon)seq;
                                    String stationLine = (String)colon2.head();
                                    List lines = colon2.next$access$1();
                                    Tuple2 tuple2 = new Tuple2((Object)stationLine, (Object)lines);
                                    String stationLine2 = (String)tuple2._1();
                                    List lines2 = (List)tuple2._2();
                                    String sensorTag = stationLine2.split("<SENSOR>")[1].split("</SENSOR>")[0];
                                    String stationTag = stationLine2.split("<STATION>")[1].split("</STATION>")[0];
                                    String usedCode = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(stationCode)) ? stationCode : stationTag;
                                    usedCodeForLogs$1.elem = usedCode;
                                    Option option = stationCodes.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MISController.$anonfun$executeMISImport$21(usedCode, x$3)));
                                    if (stationParameters.condition().isDefined()) {
                                        String string = stationTag;
                                        Object object = stationParameters.condition().get();
                                        if (string == null ? object != null : !string.equals(object)) {
                                            return (Seq)Nil$.MODULE$;
                                        }
                                    }
                                    if (option instanceof Some) {
                                        Some some = (Some)option;
                                        StationCode foundStation = (StationCode)some.value();
                                        None$ codepoint = stationParameters.pointPrelevement().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$4.trim())))) ? $this.PointPrelDao.getPoints(stationType, foundStation.id()).find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MISController.$anonfun$executeMISImport$23(stationParameters, x$5))).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.point())) : None$.MODULE$;
                                        usedCodeForLogs$1.elem = foundStation.code();
                                        Option option2 = stationParameters.data().find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])d.channels().split(",")), (Object)sensorTag)));
                                        if (option2 instanceof Some) {
                                            Seq seq2;
                                            Some some2 = (Some)option2;
                                            MISDataType dataType = (MISDataType)some2.value();
                                            List data = lines2.flatMap(arg_0 -> MISController.$anonfun$executeMISImport$26(this, htf, htf2, htf3, dtf, stationParameters, dataType, filters, (Option)codepoint, logCorrupted, jobExecutionId, f, usedCodeForLogs, arg_0));
                                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(35).append(data.length()).append(" values read from file for channel ").append(sensorTag).toString(), (String)usedCodeForLogs$1.elem, f.getName());
                                            if (jobParameters.isManualImport().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && jobParameters.returnsData().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), "end integration of file imported ", (String)usedCodeForLogs$1.elem, f.getName());
                                                return data;
                                            }
                                            try {
                                                if (data.isEmpty()) {
                                                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(34).append("No records on channel ").append(sensorTag).append(", on file : ").append(f.getName()).toString(), (String)usedCodeForLogs$1.elem, f.getName());
                                                } else {
                                                    int n;
                                                    String string = stationType;
                                                    String string2 = StationTypeUtil$.MODULE$.HYDROMETRY();
                                                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                                        Option<Object> x$16 = filters.measureCote();
                                                        Option<String> x$17 = filters.importMode();
                                                        Option<Object> x$18 = ImportOptions$.MODULE$.apply$default$1();
                                                        Option<String> x$19 = ImportOptions$.MODULE$.apply$default$4();
                                                        Option<Object> x$20 = ImportOptions$.MODULE$.apply$default$5();
                                                        Option<Seq<Object>> x$21 = ImportOptions$.MODULE$.apply$default$6();
                                                        Option<Object> x$22 = ImportOptions$.MODULE$.apply$default$7();
                                                        n = $this.genericImportDao.importHydrometryGeneric(Integer.toString(foundStation.id()), foundStation.code(), user, jobExecutionId, (Seq<GenericData>)data, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$18, x$17, x$16, x$19, x$20, x$21, x$22)));
                                                    } else {
                                                        Option<Object> x$23 = filters.measureCote();
                                                        Option<String> x$24 = filters.importMode();
                                                        Option<Object> x$25 = ImportOptions$.MODULE$.apply$default$1();
                                                        Option<String> x$26 = ImportOptions$.MODULE$.apply$default$4();
                                                        Option<Object> x$27 = ImportOptions$.MODULE$.apply$default$5();
                                                        Option<Seq<Object>> x$28 = ImportOptions$.MODULE$.apply$default$6();
                                                        Option<Object> x$29 = ImportOptions$.MODULE$.apply$default$7();
                                                        n = $this.genericImportDao.importPiezometryGeneric(Integer.toString(foundStation.id()), foundStation.code(), user, jobExecutionId, (Seq<GenericData>)data, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$25, x$24, x$23, x$26, x$27, x$28, x$29)));
                                                    }
                                                    int results = n;
                                                    $this.JobLogUtil.log(jobExecutionId, results > 0 ? JobState$.MODULE$.SUCCESS() : JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(32).append(results).append(" records on channel ").append(sensorTag).append(", on file : ").append(f.getName()).toString(), (String)usedCodeForLogs$1.elem, f.getName());
                                                }
                                                seq2 = (Seq)Nil$.MODULE$;
                                            }
                                            catch (InterruptedException interupted) {
                                                throw interupted;
                                            }
                                            catch (Exception exception) {
                                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), exception.getMessage(), (String)usedCodeForLogs$1.elem, f.getName());
                                                seq2 = (Seq)Nil$.MODULE$;
                                            }
                                            return seq2;
                                        }
                                        return (Seq)Nil$.MODULE$;
                                    }
                                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(55).append("Can't find piezometer in database with code : ").append((String)usedCodeForLogs$1.elem).append(", file : ").append(f.getName()).toString(), (String)usedCodeForLogs$1.elem, f.getName());
                                    return (Seq)Nil$.MODULE$;
                                });
                                if (try_ instanceof Failure) {
                                    bl = true;
                                    failure = (Failure)try_;
                                    Throwable interupted = failure.exception();
                                    if (interupted instanceof InterruptedException) {
                                        InterruptedException interruptedException = (InterruptedException)interupted;
                                        throw interruptedException;
                                    }
                                }
                                if (bl) {
                                    Throwable error = failure.exception();
                                    $this.LogUtil.printError(error);
                                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(48).append("Can't read file data, possible corrupted file : ").append(f.getName()).toString(), (String)usedCodeForLogs$1.elem, f.getName());
                                    return Nil$.MODULE$;
                                }
                                if (try_ instanceof Success) {
                                    Success success = (Success)try_;
                                    Seq res = (Seq)success.value();
                                    return res;
                                }
                                throw new MatchError((Object)try_);
                            });
                            filesToSetProcessed.$plus$eq((Object)f.getAbsolutePath());
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.END_DATA(), new StringBuilder(25).append("End integration of file: ").append(f.getName()).toString(), (String)usedCodeForLogs.elem, f.getName());
                            return results;
                        }
                        throw new MatchError((Object)try_);
                    });
                }
                $this.LogUtil.debug("No files to process (due to filter or files found on job logs)", $this.LogUtil.debug$default$2());
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No files to process (due to filter or files found on job logs)", stationCode, $this.JobLogUtil.log$default$5());
                return Nil$.MODULE$;
            });
            filesToSetProcessed.foreach((Function1 & Serializable)filePath -> {
                MISController.$anonfun$executeMISImport$30(this, filters, jobExecutionId, filePath);
                return BoxedUnit.UNIT;
            });
            if (jobParameters.returnsData().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return Json$.MODULE$.toJson((Object)returnedData, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)GenericData$.MODULE$.writes())).toString();
            }
            return "";
        });
    }

    public static final /* synthetic */ boolean $anonfun$executeMISImport$12(String starts$1, String ends$1, File f) {
        return f.getName().startsWith(starts$1) && f.getName().endsWith(ends$1);
    }

    public static final /* synthetic */ boolean $anonfun$executeMISImport$13(File f) {
        return !f.getName().endsWith(".DONE");
    }

    public static final /* synthetic */ boolean $anonfun$executeMISImport$14(Seq processedFiles$1, File f) {
        return !processedFiles$1.contains((Object)f.getName());
    }

    public static final /* synthetic */ boolean $anonfun$executeMISImport$15(File f) {
        return !f.getName().contains(".DONE");
    }

    public static final /* synthetic */ boolean $anonfun$executeMISImport$21(String usedCode$1, StationCode x$3) {
        String string = x$3.code();
        String string2 = usedCode$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$executeMISImport$23(MISParameters stationParameters$1, PointPrel x$5) {
        String string = x$5.code().trim().toLowerCase();
        String string2 = ((String)stationParameters$1.pointPrelevement().get()).trim().toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Option $anonfun$executeMISImport$26(MISController $this, DateTimeFormatter htf$1, DateTimeFormatter htf2$1, DateTimeFormatter htf3$1, DateTimeFormatter dtf$1, MISParameters stationParameters$1, MISDataType dataType$1, MISFilter filters$1, Option codepoint$1, BooleanRef logCorrupted$1, long jobExecutionId$1, File f$1, ObjectRef usedCodeForLogs$1, String line) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            block1: {
                String[] splitted = line.split(";");
                if (!new .colon.colon((Object)"[10]", (List)new .colon.colon((Object)"---", (List)new .colon.colon((Object)"---/[10]", (List)Nil$.MODULE$))).contains((Object)splitted[2])) {
                    DateTime date;
                    String h = splitted[1];
                    DateTime hour = h.length() == 6 ? htf$1.parseDateTime(h) : (h.length() == 8 ? htf2$1.parseDateTime(h) : htf3$1.parseDateTime(h));
                    DateTime x$1 = date = dtf$1.parseDateTime(splitted[0]).withHourOfDay(hour.hourOfDay().get()).withMinuteOfHour(hour.minuteOfHour().get()).withSecondOfMinute(hour.secondOfMinute().get());
                    DateTime x$2 = date.withHourOfDay(hour.hourOfDay().get()).withMinuteOfHour(hour.minuteOfHour().get()).withSecondOfMinute(hour.secondOfMinute().get());
                    Some x$3 = new Some((Object)BoxesRunTime.boxToDouble((double)(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(splitted[2])) * BoxesRunTime.unboxToDouble((Object)stationParameters$1.factor().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0)) + BoxesRunTime.unboxToDouble((Object)stationParameters$1.offset().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)))));
                    int x$4 = dataType$1.dataType();
                    Option<Object> x$5 = filters$1.status();
                    Option<Object> x$6 = filters$1.qualification();
                    Option<Object> x$7 = filters$1.obtainingMode();
                    Option<Object> x$8 = filters$1.producer();
                    Option<Object> x$9 = filters$1.validator();
                    Option<Object> x$10 = filters$1.manager();
                    Option<String> x$11 = filters$1.nature();
                    Option x$12 = codepoint$1;
                    Option x$13 = GenericData$.MODULE$.apply$default$12();
                    Option x$14 = GenericData$.MODULE$.apply$default$13();
                    Option x$15 = GenericData$.MODULE$.apply$default$14();
                    return new Some((Object)new GenericData(x$1, x$2, (Option)x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$13, x$14, x$15, x$12));
                }
                if (logCorrupted$1.elem) break block1;
                logCorrupted$1.elem = true;
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(26).append("Corrupted file : ").append(f$1.getName()).append(", line : ").append(line).toString(), (String)usedCodeForLogs$1.elem, f$1.getName());
            }
            return None$.MODULE$;
        });
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable e = failure.exception();
            if (e.getMessage().contains("Illegal instant")) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(25).append("Error during line read : ").append(e.getMessage()).toString(), (String)usedCodeForLogs$1.elem, f$1.getName());
            return None$.MODULE$;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Option r = (Option)success.value();
            return r;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$executeMISImport$30(MISController $this, MISFilter filters$1, long jobExecutionId$1, String filePath) {
        File f = new File(filePath);
        if (filters$1.renameProcessedFiles().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            DateTime now = new DateTime();
            boolean renameSucceded = f.renameTo(new File(new StringBuilder(6).append(f.getAbsolutePath()).append(".").append(now.toString("YYYMMDDHHmmss")).append(".DONE").toString()));
            if (!renameSucceded) {
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(24).append("Unable to rename file : ").append(f.getName()).toString(), "", f.getName());
            }
        }
        $this.JobLogUtil.setFileProcessed(f, jobExecutionId$1);
    }

    @Inject
    public MISController(LogUtil LogUtil2, GenericImportDao genericImportDao, JobLogUtil JobLogUtil2, PiezometerDaeau piezometerDaeau, PointPrelDao PointPrelDao2, HydrologicalStationDao HydrologicalStationDao2) {
        this.LogUtil = LogUtil2;
        this.genericImportDao = genericImportDao;
        this.JobLogUtil = JobLogUtil2;
        this.piezometerDaeau = piezometerDaeau;
        this.PointPrelDao = PointPrelDao2;
        this.HydrologicalStationDao = HydrologicalStationDao2;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        Statics.releaseFence();
    }
}

