/*
 * Decompiled with CFR 0.152.
 */
package omnidia.controller;

import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.FileUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import model.ImportQualityDefaultValue;
import model.ImportQualityDefaultValue$;
import omnidia.itf.OmnidiaDao;
import omnidia.model.OmnidiaDataIndice;
import omnidia.model.OmnidiaDataTaxon;
import omnidia.model.OmnidiaIndice;
import omnidia.model.OmnidiaList;
import omnidia.model.OmnidiaOperation;
import omnidia.model.OmnidiaParameter;
import omnidia.model.OmnidiaParameter$;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.joda.time.format.DateTimeFormatter;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import util.DateUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\tEe\u0001\u0002\r\u001a\u0001yA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006Y\u0001\f\u0005\tq\u0001\u0011\t\u0011)A\u0006s!Aq\b\u0001B\u0001B\u0003-\u0001\tC\u0003G\u0001\u0011\u0005q\tC\u0003X\u0001\u0011\u0005\u0003\fC\u0003e\u0001\u0011\u0005S\rC\u0003z\u0001\u0011\u0005#\u0010C\u0004\u0002\u0016\u0001!I!a\u0006\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R!9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0004bBAA\u0001\u0011%\u00111\u0011\u0005\b\u0003#\u0003A\u0011BAJ\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GCq!!-\u0001\t\u0013\t\u0019\fC\u0004\u0002J\u0002!I!a3\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBA}\u0001\u0011%\u00111 \u0005\b\u0005\u0013\u0001A\u0011\u0002B\u0006\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057A\u0011Ba\u0011\u0001#\u0003%\tA!\u0012\t\u000f\tm\u0003\u0001\"\u0001\u0003^!9!1\u0011\u0001\u0005\u0002\t\u0015%!E(n]&$\u0017.Y\"p]R\u0014x\u000e\u001c7fe*\u0011!dG\u0001\u000bG>tGO]8mY\u0016\u0014(\"\u0001\u000f\u0002\u000f=lg.\u001b3jC\u000e\u00011c\u0001\u0001 KA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0004CBL\u0017B\u0001\u0016(\u0005\u0015iu\u000eZ3m\u0003\u001daunZ+uS2\u0004\"!\f\u001c\u000e\u00039R!a\f\u0019\u0002\tU$\u0018\u000e\u001c\u0006\u0003cI\n\u0001B]1cE&$X.\u001d\u0006\u0003gQ\nq!Y9vCNL8OC\u00016\u0003\t1'/\u0003\u00028]\t9Aj\\4Vi&d\u0017AC8n]&$\u0017.\u0019#b_B\u0011!(P\u0007\u0002w)\u0011AhG\u0001\u0004SR4\u0017B\u0001 <\u0005)yUN\\5eS\u0006$\u0015m\\\u0001\u000b\u0015>\u0014Gj\\4Vi&d\u0007CA!E\u001b\u0005\u0011%BA\"3\u0003\u0015)H/\u001b7t\u0013\t)%I\u0001\u0006K_\ndunZ+uS2\fa\u0001P5oSRtD#\u0001%\u0015\t%[E*\u0014\t\u0003\u0015\u0002i\u0011!\u0007\u0005\u0006W\u0011\u0001\u001d\u0001\f\u0005\u0006q\u0011\u0001\u001d!\u000f\u0005\u0006\u007f\u0011\u0001\u001d\u0001\u0011\u0015\u0003\t=\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\r%t'.Z2u\u0015\u0005!\u0016!\u00026bm\u0006D\u0018B\u0001,R\u0005\u0019IeN[3di\u0006iq-\u001a;S_V$\u0018N\\4LKf$\u0012!\u0017\t\u00035\u0006t!aW0\u0011\u0005q\u000bS\"A/\u000b\u0005yk\u0012A\u0002\u001fs_>$h(\u0003\u0002aC\u00051\u0001K]3eK\u001aL!AY2\u0003\rM#(/\u001b8h\u0015\t\u0001\u0017%A\u0006iC:$G.Z#se>\u0014Hc\u00014jiB\u0011\u0001eZ\u0005\u0003Q\u0006\u0012A!\u00168ji\")!N\u0002a\u0001W\u0006\tQ\r\u0005\u0002mc:\u0011Qn\u001c\b\u00039:L\u0011AI\u0005\u0003a\u0006\nq\u0001]1dW\u0006<W-\u0003\u0002sg\nIQ\t_2faRLwN\u001c\u0006\u0003a\u0006BQ!\u001e\u0004A\u0002Y\faB[8c\u000bb,7-\u001e;j_:LE\r\u0005\u0002!o&\u0011\u00010\t\u0002\u0005\u0019>tw-A\u0004fq\u0016\u001cW\u000f^3\u0015\u0007\u0019\\X\u0010C\u0003}\u000f\u0001\u0007\u0011,\u0001\u0006s_V$\u0018N\\4LKfDQA`\u0004A\u0002}\fq!\\3tg\u0006<W\r\u0005\u0003\u0002\u0002\u0005EQBAA\u0002\u0015\u0011\t)!a\u0002\u0002\t)\u001cxN\u001c\u0006\u0005\u0003\u0013\tY!\u0001\u0003mS\n\u001c(b\u0001\u0015\u0002\u000e)\u0011\u0011qB\u0001\u0005a2\f\u00170\u0003\u0003\u0002\u0014\u0005\r!a\u0002&t-\u0006dW/Z\u0001\na\u0006\u00148/\u001a$jY\u0016$\u0002\"!\u0007\u00024\u0005]\u0012Q\t\u000b\u0007\u00037\ti#a\f\u0011\u000b1\fi\"!\t\n\u0007\u0005}1OA\u0002TKF\u0004B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003OY\u0012!B7pI\u0016d\u0017\u0002BA\u0016\u0003K\u0011\u0001cT7oS\u0012L\u0017\rR1uCR\u000b\u0007p\u001c8\t\u000bUD\u00019\u0001<\t\r\u0005E\u0002\u0002q\u0001Z\u0003!1\u0017\u000e\\3OC6,\u0007BBA\u001b\u0011\u0001\u0007\u0011,A\u0006gS2,7i\u001c8uK:$\bbBA\u001d\u0011\u0001\u0007\u00111H\u0001\u000eI\u00164\u0017-\u001e7u-\u0006dW/Z:\u0011\t\u0005u\u0012\u0011I\u0007\u0003\u0003\u007fQ!!a\n\n\t\u0005\r\u0013q\b\u0002\u001a\u00136\u0004xN\u001d;Rk\u0006d\u0017\u000e^=EK\u001a\fW\u000f\u001c;WC2,X\rC\u0004\u0002H!\u0001\r!!\u0013\u0002\u0019=lg.\u001b3jCB\u000b'/Y7\u0011\t\u0005\r\u00121J\u0005\u0005\u0003\u001b\n)C\u0001\tP[:LG-[1QCJ\fW.\u001a;fe\u0006Q\u0011N\\:feR$\u0015\r^1\u0015\u0011\u0005M\u0013\u0011LA/\u0003O\"RAZA+\u0003/BQ!^\u0005A\u0004YDa!!\r\n\u0001\bI\u0006bBA.\u0013\u0001\u0007\u00111D\u0001\r_6t\u0017\u000eZ5b\t\u0006$\u0018m\u001d\u0005\b\u0003?J\u0001\u0019AA1\u0003\u0011)8/\u001a:\u0011\t\u0001\n\u0019'W\u0005\u0004\u0003K\n#AB(qi&|g\u000eC\u0004\u0002j%\u0001\r!a\u001b\u0002%\u0011|g\u000e^%oi\u0016<'/\u0019;f)\u0006DxN\u001c\t\u0004A\u00055\u0014bAA8C\t9!i\\8mK\u0006t\u0017aC1eI2\u000b7\u000f\u001e#bi\u0006$\u0002\"!\u001e\u0002|\u0005u\u0014q\u0010\u000b\u0006M\u0006]\u0014\u0011\u0010\u0005\u0006k*\u0001\u001dA\u001e\u0005\u0007\u0003cQ\u00019A-\t\u000f\u0005m#\u00021\u0001\u0002\u001c!9\u0011q\f\u0006A\u0002\u0005\u0005\u0004bBA5\u0015\u0001\u0007\u00111N\u0001\u000bC\u0012$g*Z<ECR\fG\u0003CAC\u0003\u0017\u000bi)a$\u0015\u000b\u0019\f9)!#\t\u000bU\\\u00019\u0001<\t\r\u0005E2\u0002q\u0001Z\u0011\u001d\tYf\u0003a\u0001\u00037Aq!a\u0018\f\u0001\u0004\t\t\u0007C\u0004\u0002j-\u0001\r!a\u001b\u0002\u0019I,\u0007\u000f\\1dK\"K7\u000f^8\u0015\u0011\u0005U\u00151TAO\u0003?#RAZAL\u00033CQ!\u001e\u0007A\u0004YDa!!\r\r\u0001\bI\u0006bBA.\u0019\u0001\u0007\u00111\u0004\u0005\b\u0003?b\u0001\u0019AA1\u0011\u001d\tI\u0007\u0004a\u0001\u0003W\n1B]3qY\u0006\u001cW\rR1uCRA\u0011QUAV\u0003[\u000by\u000bF\u0003g\u0003O\u000bI\u000bC\u0003v\u001b\u0001\u000fa\u000f\u0003\u0004\u000225\u0001\u001d!\u0017\u0005\b\u00037j\u0001\u0019AA\u000e\u0011\u001d\ty&\u0004a\u0001\u0003CBq!!\u001b\u000e\u0001\u0004\tY'A\bqCJ\u001cXMR5mK&sG-[2f)!\t),a1\u0002F\u0006\u001dGCBA\\\u0003\u007f\u000b\t\rE\u0003m\u0003;\tI\f\u0005\u0003\u0002$\u0005m\u0016\u0002BA_\u0003K\u0011\u0011cT7oS\u0012L\u0017\rR1uC&sG-[2f\u0011\u0015)h\u0002q\u0001w\u0011\u0019\t\tD\u0004a\u00023\"1\u0011Q\u0007\bA\u0002eCq!!\u000f\u000f\u0001\u0004\tY\u0004C\u0004\u0002H9\u0001\r!!\u0013\u0002#%t7/\u001a:u\u0013:$\u0017nY3t\t\u0006$\u0018\r\u0006\u0005\u0002N\u0006M\u0017Q[Al)\u00151\u0017qZAi\u0011\u0015)x\u0002q\u0001w\u0011\u0019\t\td\u0004a\u00023\"9\u00111L\bA\u0002\u0005]\u0006bBA0\u001f\u0001\u0007\u0011\u0011\r\u0005\b\u0003Sz\u0001\u0019AA6\u0003I\tG\rZ%oI&\u001cWm\u001d'bgR$\u0015\r^1\u0015\u0011\u0005u\u00171]As\u0003O$RAZAp\u0003CDQ!\u001e\tA\u0004YDa!!\r\u0011\u0001\bI\u0006bBA.!\u0001\u0007\u0011q\u0017\u0005\b\u0003?\u0002\u0002\u0019AA1\u0011\u001d\tI\u0007\u0005a\u0001\u0003W\n\u0011#\u00193e\u0013:$\u0017nY3t\u001d\u0016<H)\u0019;b)!\ti/a=\u0002v\u0006]H#\u00024\u0002p\u0006E\b\"B;\u0012\u0001\b1\bBBA\u0019#\u0001\u000f\u0011\fC\u0004\u0002\\E\u0001\r!a.\t\u000f\u0005}\u0013\u00031\u0001\u0002b!9\u0011\u0011N\tA\u0002\u0005-\u0014a\u0005:fa2\f7-Z%oI&\u001cWm\u001d%jgR|G\u0003CA\u007f\u0005\u0007\u0011)Aa\u0002\u0015\u000b\u0019\fyP!\u0001\t\u000bU\u0014\u00029\u0001<\t\r\u0005E\"\u0003q\u0001Z\u0011\u001d\tYF\u0005a\u0001\u0003oCq!a\u0018\u0013\u0001\u0004\t\t\u0007C\u0004\u0002jI\u0001\r!a\u001b\u0002%I,\u0007\u000f\\1dK&sG-[2fg\u0012\u000bG/\u0019\u000b\t\u0005\u001b\u0011\u0019B!\u0006\u0003\u0018Q)aMa\u0004\u0003\u0012!)Qo\u0005a\u0002m\"1\u0011\u0011G\nA\u0004eCq!a\u0017\u0014\u0001\u0004\t9\fC\u0004\u0002`M\u0001\r!!\u0019\t\u000f\u0005%4\u00031\u0001\u0002l\u0005\tr-\u001a;GS2,7\u000fV8Qe>\u001cWm]:\u0015\u0015\tu!1\u0007B\u001c\u0005w\u0011y\u0004\u0006\u0003\u0003 \tE\u0002#\u00027\u0002\u001e\t\u0005\u0002\u0003\u0002B\u0012\u0005[i!A!\n\u000b\t\t\u001d\"\u0011F\u0001\u0003S>T!Aa\u000b\u0002\t)\fg/Y\u0005\u0005\u0005_\u0011)C\u0001\u0003GS2,\u0007\"B;\u0015\u0001\b1\bB\u0002B\u001b)\u0001\u0007\u0011,A\u0002eSJDqA!\u000f\u0015\u0001\u0004\tI%A\u0005qCJ\fW.\u001a;fe\"1!Q\b\u000bA\u0002e\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\t\u0013\t\u0005C\u0003%AA\u0002\u0005-\u0014AB5o\u0019><7/A\u000ehKR4\u0015\u000e\\3t)>\u0004&o\\2fgN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u000fRC!a\u001b\u0003J-\u0012!1\n\t\u0005\u0005\u001b\u00129&\u0004\u0002\u0003P)!!\u0011\u000bB*\u0003%)hn\u00195fG.,GMC\u0002\u0003V\u0005\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IFa\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006qe>\u001cWm]:GS2,GC\u0003B0\u0005K\u0012IGa \u0003\u0002R)aM!\u0019\u0003d!)QO\u0006a\u0002m\"1\u0011\u0011\u0007\fA\u0004eCqAa\u001a\u0017\u0001\u0004\u0011\t#\u0001\u0003gS2,\u0007b\u0002B6-\u0001\u0007!QN\u0001\u000eU>\u0014\u0007+\u0019:b[\u0016$XM]:\u0011\t\t=$1P\u0007\u0003\u0005cRA!a\n\u0003t)!!Q\u000fB<\u0003\rQwN\u0019\u0006\u0004\u0005s\u0012\u0014!\u00023bK\u0006,\u0018\u0002\u0002B?\u0005c\u0012QBS8c!\u0006\u0014\u0018-\\3uKJ\u001c\bbBA$-\u0001\u0007\u0011\u0011\n\u0005\b\u0003s1\u0002\u0019AA\u001e\u00035)\u00070Z2vi\u0016LU\u000e]8siR\u0019aMa\"\t\u000by<\u0002\u0019A@)\u0007\u0001\u0011Y\tE\u0002Q\u0005\u001bK1Aa$R\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class OmnidiaController
implements Model {
    private final LogUtil LogUtil;
    private final OmnidiaDao omnidiaDao;
    private final JobLogUtil JobLogUtil;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        OmnidiaController omnidiaController = this;
        synchronized (omnidiaController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        OmnidiaController omnidiaController = this;
        synchronized (omnidiaController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.INTEGRATION_OMNIDIA_TOPIC();
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_OMNIDIA_JOB();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.executeImport(message);
            return;
        }
        if (string != null) {
            String string4 = string;
            this.LogUtil.info(new StringBuilder(35).append("Bad routing key in MFController => ").append(string4).toString(), this.LogUtil.info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    private Seq<OmnidiaDataTaxon> parseFile(String fileContent, ImportQualityDefaultValue defaultValues, OmnidiaParameter omnidiaParam, long jobExecutionId, String fileName) {
        IndexedSeq indexedSeq;
        try {
            String regexSplit = "\\n(?=(\\d*\\*))";
            String[] splitContent = fileContent.split(regexSplit);
            indexedSeq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])splitContent), (Function1 & Serializable)data -> {
                String regexOperation = "(?=\\r\\n)*(\\d*\\*[^\\t]*(?=\\t))";
                String dataOperation = (String)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(regexOperation)).findFirstIn((CharSequence)data).get();
                String[] splitDataOperation = dataOperation.split("\\*");
                OmnidiaOperation operation = new OmnidiaOperation(DateTime.parse((String)new StringBuilder(9).append(splitDataOperation[1]).append(" 00:00:00").toString(), (DateTimeFormatter)DateUtil$.MODULE$.fullDateFormat()), splitDataOperation[5], omnidiaParam.campaignId(), splitDataOperation[9], defaultValues.sampler(), defaultValues.producer(), defaultValues.determiner(), BoxesRunTime.unboxToInt((Object)defaultValues.support().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 10)), defaultValues.status(), defaultValues.qualification());
                String dataHydrobio = data.replaceAll(regexOperation, "");
                OmnidiaList[] hydrobioList = (OmnidiaList[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])dataHydrobio.split("\\r\\n")), (Function1 & Serializable)line -> {
                    String[] lineSplit = line.substring(1).split("\\t");
                    return new OmnidiaList(lineSplit[0], StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(lineSplit[1])));
                }, ClassTag$.MODULE$.apply(OmnidiaList.class));
                return new OmnidiaDataTaxon(operation, (Seq<OmnidiaList>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)hydrobioList));
            }, ClassTag$.MODULE$.apply(OmnidiaDataTaxon.class)));
        }
        catch (Exception exception) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(21).append("Error while parsing: ").append(exception.getMessage()).toString(), "", fileName);
            this.LogUtil.printError((Throwable)exception);
            indexedSeq = (Seq)Nil$.MODULE$;
        }
        return indexedSeq;
    }

    private void insertData(Seq<OmnidiaDataTaxon> omnidiaDatas, Option<String> user, boolean dontIntegrateTaxon, long jobExecutionId, String fileName) {
        if (omnidiaDatas.nonEmpty()) {
            omnidiaDatas.foreach((Function1 & Serializable)data -> BoxesRunTime.boxToInteger((int)OmnidiaController.$anonfun$insertData$1(this, user, jobExecutionId, fileName, dontIntegrateTaxon, data)));
            return;
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "No integration to do", "", fileName);
    }

    private void addLastData(Seq<OmnidiaDataTaxon> omnidiaDatas, Option<String> user, boolean dontIntegrateTaxon, long jobExecutionId, String fileName) {
        Seq filteredDatas = (Seq)omnidiaDatas.filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)OmnidiaController.$anonfun$addLastData$1(this, d)));
        this.insertData((Seq<OmnidiaDataTaxon>)filteredDatas, user, dontIntegrateTaxon, jobExecutionId, fileName);
    }

    private void addNewData(Seq<OmnidiaDataTaxon> omnidiaDatas, Option<String> user, boolean dontIntegrateTaxon, long jobExecutionId, String fileName) {
        this.insertData(omnidiaDatas, user, dontIntegrateTaxon, jobExecutionId, fileName);
    }

    private void replaceHisto(Seq<OmnidiaDataTaxon> omnidiaDatas, Option<String> user, boolean dontIntegrateTaxon, long jobExecutionId, String fileName) {
        Seq listCodeBSS = (Seq)((SeqOps)omnidiaDatas.map((Function1 & Serializable)d -> d.operation().codeBSS())).distinct();
        this.omnidiaDao.deleteAllOperation((Seq<String>)listCodeBSS, jobExecutionId, fileName);
        this.insertData(omnidiaDatas, user, dontIntegrateTaxon, jobExecutionId, fileName);
    }

    private void replaceData(Seq<OmnidiaDataTaxon> omnidiaDatas, Option<String> user, boolean dontIntegrateTaxon, long jobExecutionId, String fileName) {
        omnidiaDatas.foreach((Function1 & Serializable)d -> {
            OmnidiaController.$anonfun$replaceData$1(this, d);
            return BoxedUnit.UNIT;
        });
        this.insertData(omnidiaDatas, user, dontIntegrateTaxon, jobExecutionId, fileName);
    }

    private Seq<OmnidiaDataIndice> parseFileIndice(String fileContent, ImportQualityDefaultValue defaultValues, OmnidiaParameter omnidiaParam, long jobExecutionId, String fileName) {
        Seq seq;
        try {
            String[] lines = fileContent.split("\\r\\n");
            String[][] splitDatas = (String[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])lines), (Function1 & Serializable)line -> line.split("\\t"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            String[] headers = (String[])ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])splitDatas));
            Object qual$1 = Predef$.MODULE$.refArrayOps((Object[])headers);
            String x$1 = "CODE HYDRO";
            int x$2 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$1);
            int indexStationCode = ArrayOps$.MODULE$.indexOf$extension(qual$1, (Object)"CODE HYDRO", x$2);
            Object qual$2 = Predef$.MODULE$.refArrayOps((Object[])headers);
            String x$3 = "DATE";
            int x$4 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$2);
            int indexDate = ArrayOps$.MODULE$.indexOf$extension(qual$2, (Object)"DATE", x$4);
            Map mapIndiceCode = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Effectif"), (Object)"1691"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NB esp"), (Object)"1690"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SLA"), (Object)"1027"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DESCY"), (Object)"1024"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CEE"), (Object)"1026"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"IPS"), (Object)"1022"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"IBD"), (Object)"5856"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"IDAP"), (Object)"1081")}));
            Object qual$3 = Predef$.MODULE$.refArrayOps((Object[])headers);
            String x$5 = "Effectif";
            int x$6 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$3);
            int index1691 = ArrayOps$.MODULE$.indexOf$extension(qual$3, (Object)"Effectif", x$6);
            Object qual$4 = Predef$.MODULE$.refArrayOps((Object[])headers);
            String x$7 = "NB esp";
            int x$8 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$4);
            int index1690 = ArrayOps$.MODULE$.indexOf$extension(qual$4, (Object)"NB esp", x$8);
            Object qual$5 = Predef$.MODULE$.refArrayOps((Object[])headers);
            String x$9 = "SLA";
            int x$10 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$5);
            int index1027 = ArrayOps$.MODULE$.indexOf$extension(qual$5, (Object)"SLA", x$10);
            Object qual$6 = Predef$.MODULE$.refArrayOps((Object[])headers);
            String x$11 = "DESCY";
            int x$12 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$6);
            int index1024 = ArrayOps$.MODULE$.indexOf$extension(qual$6, (Object)"DESCY", x$12);
            Object qual$7 = Predef$.MODULE$.refArrayOps((Object[])headers);
            String x$13 = "CEE";
            int x$14 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$7);
            int index1026 = ArrayOps$.MODULE$.indexOf$extension(qual$7, (Object)"CEE", x$14);
            Object qual$8 = Predef$.MODULE$.refArrayOps((Object[])headers);
            String x$15 = "IPS";
            int x$16 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$8);
            int index1022 = ArrayOps$.MODULE$.indexOf$extension(qual$8, (Object)"IPS", x$16);
            Object qual$9 = Predef$.MODULE$.refArrayOps((Object[])headers);
            String x$17 = "IBD";
            int x$18 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$9);
            int index5856 = ArrayOps$.MODULE$.indexOf$extension(qual$9, (Object)"IBD", x$18);
            Object qual$10 = Predef$.MODULE$.refArrayOps((Object[])headers);
            String x$19 = "IDAP";
            int x$20 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$10);
            int index1081 = ArrayOps$.MODULE$.indexOf$extension(qual$10, (Object)"IDAP", x$20);
            Seq listIndex = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{index1691, index1690, index1027, index1024, index1026, index1022, index5856, index1081})).filter((Function1)(JFunction1.mcZI.sp & Serializable)i -> i != -1);
            seq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])splitDatas))), 2)), (Function1 & Serializable)data -> {
                OmnidiaOperation operation = new OmnidiaOperation(DateTime.parse((String)new StringBuilder(9).append(data[indexDate]).append(" 00:00:00").toString(), (DateTimeFormatter)DateUtil$.MODULE$.fullDateFormat()), data[indexStationCode], omnidiaParam.campaignId(), "", defaultValues.sampler(), defaultValues.producer(), defaultValues.determiner(), BoxesRunTime.unboxToInt((Object)defaultValues.support().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 10)), defaultValues.status(), defaultValues.qualification());
                Seq indices = (Seq)listIndex.map((Function1 & Serializable)i -> OmnidiaController.$anonfun$parseFileIndice$5(mapIndiceCode, headers, data, BoxesRunTime.unboxToInt((Object)i)));
                return new OmnidiaDataIndice(operation, (Seq<OmnidiaIndice>)indices);
            }, ClassTag$.MODULE$.apply(OmnidiaDataIndice.class)));
        }
        catch (Exception exception) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(21).append("Error while parsing: ").append(exception.getMessage()).toString(), "", fileName);
            this.LogUtil.printError((Throwable)exception);
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    private void insertIndicesData(Seq<OmnidiaDataIndice> omnidiaDatas, Option<String> user, boolean dontIntegrateTaxon, long jobExecutionId, String fileName) {
        if (omnidiaDatas.nonEmpty()) {
            omnidiaDatas.foreach((Function1 & Serializable)data -> BoxesRunTime.boxToInteger((int)OmnidiaController.$anonfun$insertIndicesData$1(this, user, jobExecutionId, fileName, dontIntegrateTaxon, data)));
            return;
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "No integration to do", "", fileName);
    }

    private void addIndicesLastData(Seq<OmnidiaDataIndice> omnidiaDatas, Option<String> user, boolean dontIntegrateTaxon, long jobExecutionId, String fileName) {
        Seq filteredDatas = (Seq)omnidiaDatas.filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)OmnidiaController.$anonfun$addIndicesLastData$1(this, d)));
        this.insertIndicesData((Seq<OmnidiaDataIndice>)filteredDatas, user, dontIntegrateTaxon, jobExecutionId, fileName);
    }

    private void addIndicesNewData(Seq<OmnidiaDataIndice> omnidiaDatas, Option<String> user, boolean dontIntegrateTaxon, long jobExecutionId, String fileName) {
        Seq filteredDatas = (Seq)omnidiaDatas.filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)OmnidiaController.$anonfun$addIndicesNewData$1(this, d)));
        this.insertIndicesData((Seq<OmnidiaDataIndice>)filteredDatas, user, dontIntegrateTaxon, jobExecutionId, fileName);
    }

    private void replaceIndicesHisto(Seq<OmnidiaDataIndice> omnidiaDatas, Option<String> user, boolean dontIntegrateTaxon, long jobExecutionId, String fileName) {
        Seq listCodeBSS = (Seq)((SeqOps)omnidiaDatas.map((Function1 & Serializable)d -> d.operation().codeBSS())).distinct();
        this.omnidiaDao.deleteAllOperation((Seq<String>)listCodeBSS, jobExecutionId, fileName);
        this.insertIndicesData(omnidiaDatas, user, dontIntegrateTaxon, jobExecutionId, fileName);
    }

    private void replaceIndicesData(Seq<OmnidiaDataIndice> omnidiaDatas, Option<String> user, boolean dontIntegrateTaxon, long jobExecutionId, String fileName) {
        omnidiaDatas.foreach((Function1 & Serializable)d -> {
            OmnidiaController.$anonfun$replaceIndicesData$1(this, d);
            return BoxedUnit.UNIT;
        });
        this.insertIndicesData(omnidiaDatas, user, dontIntegrateTaxon, jobExecutionId, fileName);
    }

    public Seq<File> getFilesToProcess(String dir, OmnidiaParameter parameter, String extension, boolean inLogs, long jobExecutionId) {
        String contains;
        String filter = (String)parameter.filter().getOrElse((Function0 & Serializable)() -> extension);
        IndexedSeq splitted = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)filter.split("\\*"));
        String starts = splitted.nonEmpty() ? (String)splitted.head() : filter;
        String ends = splitted.length() > 1 ? (String)splitted.apply(splitted.length() - 1) : "";
        String string = contains = splitted.length() >= 2 ? (String)splitted.apply(splitted.length() - 2) : "";
        if (!new File(dir).isDirectory()) {
            this.LogUtil.error(new StringBuilder(24).append("Le dossier n'existe pas ").append(dir).toString(), this.LogUtil.error$default$2());
            return new .colon.colon((Object)new File(""), (List)Nil$.MODULE$);
        }
        File[] testFiles = new File(dir).listFiles();
        this.LogUtil.debug(new StringBuilder(63).append("nombre de fichier \u00e0 traiter avant le filtre : ").append(testFiles.length).append(" dans le dossier ").append(dir).toString(), this.LogUtil.debug$default$2());
        File[] files = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])testFiles), arg_0 -> OmnidiaController.$anonfun$getFilesToProcess$2$adapted((Seq)splitted, filter, starts, contains, ends, arg_0));
        this.LogUtil.debug(new StringBuilder(46).append("nombre de fichier \u00e0 traiter apres le filtre : ").append(files.length).toString(), this.LogUtil.debug$default$2());
        if (parameter.dontProcessFilesInLogs().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && inLogs) {
            Seq processedFiles = this.JobLogUtil.getProcessedFileNames(jobExecutionId);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)f -> {
                OmnidiaController.$anonfun$getFilesToProcess$3(this, processedFiles, jobExecutionId, f);
                return BoxedUnit.UNIT;
            });
            return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)OmnidiaController.$anonfun$getFilesToProcess$4(processedFiles, f))));
        }
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)files);
    }

    public boolean getFilesToProcess$default$4() {
        return true;
    }

    public void processFile(File file, JobParameters jobParameters, OmnidiaParameter omnidiaParam, ImportQualityDefaultValue defaultValues, long jobExecutionId, String fileName) {
        block14: {
            boolean dontIntegrateTaxons;
            String dataType;
            String contentFile;
            block12: {
                block13: {
                    contentFile = FileUtil$.MODULE$.readFileSource(file.getPath()).getLines().toSeq().mkString("\r\n");
                    dataType = (String)((IterableOps)jobParameters.dataTypes().getOrElse((Function0 & Serializable)() -> new .colon.colon((Object)"DATA_ADD_NEW_DATA", (List)Nil$.MODULE$))).head();
                    dontIntegrateTaxons = BoxesRunTime.unboxToBoolean((Object)omnidiaParam.dontIntegrateTaxons().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
                    if (!contentFile.startsWith("Num")) break block12;
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Indice detected", "", fileName);
                    Seq<OmnidiaDataIndice> omnidiaDataIndices = this.parseFileIndice(contentFile, defaultValues, omnidiaParam, jobExecutionId, fileName);
                    String string = dataType;
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1686931411: {
                            if (!"DATA_REPLACE_HISTO".equals(string)) break;
                            this.replaceIndicesHisto(omnidiaDataIndices, (Option<String>)jobParameters.user(), dontIntegrateTaxons, jobExecutionId, fileName);
                            break block13;
                        }
                        case -1301469974: {
                            if (!"DATA_REPLACE_DATA".equals(string)) break;
                            this.replaceIndicesData(omnidiaDataIndices, (Option<String>)jobParameters.user(), dontIntegrateTaxons, jobExecutionId, fileName);
                            break block13;
                        }
                        case -145596548: {
                            if (!"DATA_ADD_NEW_DATA".equals(string)) break;
                            this.addIndicesNewData(omnidiaDataIndices, (Option<String>)jobParameters.user(), dontIntegrateTaxons, jobExecutionId, fileName);
                            break block13;
                        }
                        case 1175147936: {
                            if (!"DATA_ADD_LAST_DATA".equals(string)) break;
                            this.addIndicesLastData(omnidiaDataIndices, (Option<String>)jobParameters.user(), dontIntegrateTaxons, jobExecutionId, fileName);
                            break block13;
                        }
                    }
                    throw new MatchError((Object)string);
                }
                return;
            }
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Taxon detected", "", fileName);
            Seq<OmnidiaDataTaxon> omnidiaDatas = this.parseFile(contentFile, defaultValues, omnidiaParam, jobExecutionId, fileName);
            String string = dataType;
            switch (string == null ? 0 : string.hashCode()) {
                case -1686931411: {
                    if (!"DATA_REPLACE_HISTO".equals(string)) break;
                    this.replaceHisto(omnidiaDatas, (Option<String>)jobParameters.user(), dontIntegrateTaxons, jobExecutionId, fileName);
                    break block14;
                }
                case -1301469974: {
                    if (!"DATA_REPLACE_DATA".equals(string)) break;
                    this.replaceData(omnidiaDatas, (Option<String>)jobParameters.user(), dontIntegrateTaxons, jobExecutionId, fileName);
                    break block14;
                }
                case -145596548: {
                    if (!"DATA_ADD_NEW_DATA".equals(string)) break;
                    this.addNewData(omnidiaDatas, (Option<String>)jobParameters.user(), dontIntegrateTaxons, jobExecutionId, fileName);
                    break block14;
                }
                case 1175147936: {
                    if (!"DATA_ADD_LAST_DATA".equals(string)) break;
                    this.addLastData(omnidiaDatas, (Option<String>)jobParameters.user(), dontIntegrateTaxons, jobExecutionId, fileName);
                    break block14;
                }
            }
            throw new MatchError((Object)string);
        }
    }

    public void executeImport(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            this.LogUtil.error(new StringBuilder(53).append("Error validate Json to execute OMNIDIA integration :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), this.LogUtil.error$default$2());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)jobParameters -> {
            OmnidiaController.$anonfun$executeImport$2(this, jobParameters);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$insertData$1(OmnidiaController $this, Option user$1, long jobExecutionId$1, String fileName$1, boolean dontIntegrateTaxon$1, OmnidiaDataTaxon data) {
        OmnidiaOperation operation = data.operation();
        Seq<OmnidiaList> hydrobioList = data.hydrobioList();
        double qualitometerId = $this.omnidiaDao.getOrCreateQualitometer(operation.codeBSS(), (Option<String>)user$1, jobExecutionId$1, fileName$1);
        double operationId = $this.omnidiaDao.getOrCreateOperation(operation, qualitometerId, (Option<String>)user$1, jobExecutionId$1, fileName$1);
        return $this.omnidiaDao.createLists(hydrobioList, qualitometerId, operationId, operation.codeBSS(), dontIntegrateTaxon$1, jobExecutionId$1, fileName$1);
    }

    public static final /* synthetic */ boolean $anonfun$addLastData$1(OmnidiaController $this, OmnidiaDataTaxon d) {
        Option<DateTime> lastOperation = $this.omnidiaDao.getLastOperationDate(d.operation().codeBSS());
        return lastOperation.isEmpty() || ((AbstractInstant)lastOperation.get()).isBefore((ReadableInstant)d.operation().date());
    }

    public static final /* synthetic */ void $anonfun$replaceData$1(OmnidiaController $this, OmnidiaDataTaxon d) {
        Option<Object> opeId = $this.omnidiaDao.getOperationId(d.operation().codeBSS(), d.operation().date(), d.operation().support());
        if (opeId.isDefined()) {
            $this.omnidiaDao.deleteOperation(BoxesRunTime.unboxToDouble((Object)opeId.get()), d.operation().codeBSS());
            return;
        }
    }

    public static final /* synthetic */ OmnidiaIndice $anonfun$parseFileIndice$5(Map mapIndiceCode$1, String[] headers$1, String[] data$1, int i) {
        return new OmnidiaIndice((String)mapIndiceCode$1.apply((Object)headers$1[i]), headers$1[i], StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(data$1[i])));
    }

    public static final /* synthetic */ int $anonfun$insertIndicesData$1(OmnidiaController $this, Option user$2, long jobExecutionId$2, String fileName$2, boolean dontIntegrateTaxon$2, OmnidiaDataIndice data) {
        OmnidiaOperation operation = data.operation();
        Seq<OmnidiaIndice> indices = data.indices();
        double qualitometerId = $this.omnidiaDao.getOrCreateQualitometer(operation.codeBSS(), (Option<String>)user$2, jobExecutionId$2, fileName$2);
        double operationId = $this.omnidiaDao.getOrCreateOperation(operation, qualitometerId, (Option<String>)user$2, jobExecutionId$2, fileName$2);
        return $this.omnidiaDao.createIndices(indices, qualitometerId, operationId, operation.codeBSS(), dontIntegrateTaxon$2, jobExecutionId$2, fileName$2);
    }

    public static final /* synthetic */ boolean $anonfun$addIndicesLastData$1(OmnidiaController $this, OmnidiaDataIndice d) {
        Option<DateTime> lastOperation = $this.omnidiaDao.getLastOperationDate(d.operation().codeBSS());
        return lastOperation.isEmpty() || ((AbstractInstant)lastOperation.get()).isBefore((ReadableInstant)d.operation().date());
    }

    public static final /* synthetic */ boolean $anonfun$addIndicesNewData$1(OmnidiaController $this, OmnidiaDataIndice d) {
        return $this.omnidiaDao.getOperationId(d.operation().codeBSS(), d.operation().date(), d.operation().support()).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$replaceIndicesData$1(OmnidiaController $this, OmnidiaDataIndice d) {
        Option<Object> opeId = $this.omnidiaDao.getOperationId(d.operation().codeBSS(), d.operation().date(), d.operation().support());
        if (opeId.isDefined()) {
            $this.omnidiaDao.deleteOperation(BoxesRunTime.unboxToDouble((Object)opeId.get()), d.operation().codeBSS());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getFilesToProcess$2(Seq splitted$1, String filter$1, String starts$1, String contains$1, String ends$1, File f) {
        if (splitted$1.isEmpty()) {
            return f.getName().startsWith(filter$1);
        }
        if (splitted$1.length() >= 2) {
            return f.getName().startsWith(starts$1) && f.getName().contains(contains$1) && f.getName().endsWith(ends$1);
        }
        return f.getName().startsWith(starts$1) && f.getName().endsWith(ends$1);
    }

    public static final /* synthetic */ void $anonfun$getFilesToProcess$3(OmnidiaController $this, Seq processedFiles$1, long jobExecutionId$3, File f) {
        if (processedFiles$1.contains((Object)f.getName())) {
            $this.JobLogUtil.log(jobExecutionId$3, JobState$.MODULE$.NOTHING_TO_DO(), "The file has already been processed ", "", $this.JobLogUtil.log$default$5());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getFilesToProcess$4(Seq processedFiles$1, File f) {
        return !processedFiles$1.contains((Object)f.getName());
    }

    public static final /* synthetic */ void $anonfun$executeImport$6(OmnidiaController $this, long jobExecutionId$4, JobParameters jobParameters$1, OmnidiaParameter omnidiaParam$3, ImportQualityDefaultValue defaultValues$3, File file) {
        String fileName = file.getName();
        $this.JobLogUtil.log(jobExecutionId$4, JobState$.MODULE$.INFO(), "Begin file integration", "", fileName);
        try {
            $this.processFile(file, jobParameters$1, omnidiaParam$3, defaultValues$3, jobExecutionId$4, fileName);
            $this.JobLogUtil.log(jobExecutionId$4, JobState$.MODULE$.SUCCESS(), "Success", "", fileName);
        }
        catch (Throwable throwable) {
            $this.JobLogUtil.log(jobExecutionId$4, JobState$.MODULE$.ERROR(), "Error while processing", "", fileName);
        }
    }

    public static final /* synthetic */ void $anonfun$executeImport$8(OmnidiaController $this, long jobExecutionId$4, DateTime now$1, File f) {
        $this.JobLogUtil.setFileProcessed(f, jobExecutionId$4);
        if (!f.renameTo(new File(new StringBuilder(6).append(f.getAbsolutePath()).append(".").append(now$1.toString("YYYMMDDHHmmss")).append(".DONE").toString()))) {
            $this.LogUtil.error(new StringBuilder(21).append("Error to rename file ").append(f).toString(), $this.LogUtil.error$default$2());
            $this.JobLogUtil.log(jobExecutionId$4, JobState$.MODULE$.WARNING(), new StringBuilder(21).append("Error to rename file ").append(f.getName()).toString(), " ", $this.JobLogUtil.log$default$5());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$executeImport$2(OmnidiaController $this, JobParameters jobParameters) {
        long jobExecutionId = jobParameters.jobExecutionId();
        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Start", "", "");
        OmnidiaParameter omnidiaParam = (OmnidiaParameter)JobUtil$.MODULE$.getParameters(jobParameters, jobExecutionId, $this.JobLogUtil, OmnidiaParameter$.MODULE$.jsonReads()).head();
        ImportQualityDefaultValue defaultValues = (ImportQualityDefaultValue)JobUtil$.MODULE$.getParameters(jobParameters, jobExecutionId, $this.JobLogUtil, ImportQualityDefaultValue$.MODULE$.jsonReads()).head();
        String baseDir = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"UPLOAD_DIRECTORY", (Function0 & Serializable)() -> "");
        String directory = FileUtil$.MODULE$.toPath(new StringBuilder(0).append(FileUtil$.MODULE$.toPath(baseDir)).append(jobParameters.path().getOrElse((Function0 & Serializable)() -> "")).toString());
        boolean renameFile = omnidiaParam.rename().contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
        String subDir = (String)omnidiaParam.directory().getOrElse((Function0 & Serializable)() -> "");
        Seq<File> filesToProcess = $this.getFilesToProcess(new StringBuilder(0).append(directory).append(subDir).toString(), omnidiaParam, "*", true, jobExecutionId);
        $this.LogUtil.debug(new StringBuilder(56).append("nombre de fichiers \u00e0 traiter apres le filtre des logs : ").append(filesToProcess.length()).toString(), $this.LogUtil.debug$default$2());
        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(56).append("nombre de fichiers \u00e0 traiter apres le filtre des logs : ").append(filesToProcess.length()).toString(), " ", $this.JobLogUtil.log$default$5());
        if (filesToProcess.nonEmpty()) {
            filesToProcess.foreach((Function1 & Serializable)file -> {
                OmnidiaController.$anonfun$executeImport$6($this, jobExecutionId, jobParameters, omnidiaParam, defaultValues, file);
                return BoxedUnit.UNIT;
            });
        } else {
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No files to process (due to filter or files found on job logs)", "", $this.JobLogUtil.log$default$5());
        }
        if (renameFile) {
            DateTime now = new DateTime();
            String subDir2 = (String)omnidiaParam.directory().getOrElse((Function0 & Serializable)() -> "");
            Seq<File> filesToProcess2 = $this.getFilesToProcess(new StringBuilder(0).append(directory).append(subDir2).toString(), omnidiaParam, "*", false, jobExecutionId);
            filesToProcess2.foreach((Function1 & Serializable)f -> {
                OmnidiaController.$anonfun$executeImport$8($this, jobExecutionId, now, f);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Inject
    public OmnidiaController(LogUtil LogUtil2, OmnidiaDao omnidiaDao, JobLogUtil JobLogUtil2) {
        this.LogUtil = LogUtil2;
        this.omnidiaDao = omnidiaDao;
        this.JobLogUtil = JobLogUtil2;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$getFilesToProcess$2$adapted(Seq splitted$1, String filter$1, String starts$1, String contains$1, String ends$1, File f) {
        return BoxesRunTime.boxToBoolean((boolean)OmnidiaController.$anonfun$getFilesToProcess$2(splitted$1, filter$1, starts$1, contains$1, ends$1, f));
    }
}

