/*
 * Decompiled with CFR 0.152.
 */
package seba;

import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.hydrometry.itf.HydrologicalStationDao;
import fr.aquasys.daeau.job.itf.JobFileDao;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.station.links.pointprel.PointPrel;
import fr.aquasys.daeau.station.links.pointprel.PointPrelDao;
import fr.aquasys.daeau.station.model.StationCode;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import fr.aquasys.utils.StringUtil$;
import genericImport.itf.GenericImportDao;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import seba.SebaDataType;
import seba.SebaFilter;
import seba.SebaFilter$;
import seba.SebaParameter;
import seba.SebaParameter$;

@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\b\u0011\u0001MA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006Y!\t\u0005\t[\u0001\u0011\t\u0011)A\u0006]!Aa\u0007\u0001B\u0001B\u0003-q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015a\u0003?\u0011!9\u0005A!A!\u0002\u0017A\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b1\u0002)\t\u0011]\u0003!\u0011!Q\u0001\faC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ya\u0019\u0005\u0006U\u0002!\ta\u001b\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\ty\u0004\u0001C!\u0003\u0003Bq!a\u0011\u0001\t\u0003\n)\u0005C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\nq1+\u001a2b\u0007>tGO]8mY\u0016\u0014(\"A\t\u0002\tM,'-Y\u0002\u0001'\r\u0001AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\t1!\u00199j\u0013\tyBDA\u0003N_\u0012,G.A\u0004M_\u001e,F/\u001b7\u0011\u0005\tZS\"A\u0012\u000b\u0005\u0011*\u0013\u0001B;uS2T!AJ\u0014\u0002\u0011I\f'MY5u[FT!\u0001K\u0015\u0002\u000f\u0005\fX/Y:zg*\t!&\u0001\u0002ge&\u0011Af\t\u0002\b\u0019><W\u000b^5m\u0003A9WM\\3sS\u000eLU\u000e]8si\u0012\u000bw\u000e\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005\u0019\u0011\u000e\u001e4\u000b\u0003M\nQbZ3oKJL7-S7q_J$\u0018BA\u001b1\u0005A9UM\\3sS\u000eLU\u000e]8si\u0012\u000bw.\u0001\u0006K_\ndunZ+uS2\u0004\"\u0001O\u001e\u000e\u0003eR!AO\u0014\u0002\u000bU$\u0018\u000e\\:\n\u0005qJ$A\u0003&pE2{w-\u0016;jY\u0006Q!j\u001c2GS2,G)Y8\u0011\u0005}*U\"\u0001!\u000b\u0005E\n%B\u0001\"D\u0003\rQwN\u0019\u0006\u0003\t\u001e\nQ\u0001Z1fCVL!A\u0012!\u0003\u0015){'MR5mK\u0012\u000bw.\u0001\fIs\u0012\u0014x\u000e\\8hS\u000e\fGn\u0015;bi&|g\u000eR1p!\tIU*D\u0001K\u0015\t\t4J\u0003\u0002M\u0007\u0006Q\u0001.\u001f3s_6,GO]=\n\u00059S%A\u0006%zIJ|Gn\\4jG\u0006d7\u000b^1uS>tG)Y8\u0002\u001dAcWO^5p[\u0016$XM\u001d#b_B\u0011\u0011+V\u0007\u0002%*\u0011\u0011g\u0015\u0006\u0003)\u000e\u000b1\u0002\u001d7vm&|W.\u001a;ss&\u0011aK\u0015\u0002\u000f!2,h/[8nKR,'\u000fR1p\u00031\u0001v.\u001b8u!J,G\u000eR1p!\tI\u0006-D\u0001[\u0015\tYF,A\u0005q_&tG\u000f\u001d:fY*\u0011QLX\u0001\u0006Y&t7n\u001d\u0006\u0003?\u000e\u000bqa\u001d;bi&|g.\u0003\u0002b5\na\u0001k\\5oiB\u0013X\r\u001c#b_\u0006y\u0001/[3{_6,G/\u001a:EC\u0016\fW\u000f\u0005\u0002eQ6\tQM\u0003\u00022M*\u0011qmQ\u0001\u000ba&,'p\\7fiJL\u0018BA5f\u0005=\u0001\u0016.\u001a>p[\u0016$XM\u001d#bK\u0006,\u0018A\u0002\u001fj]&$h\bF\u0001m)%iw\u000e]9sgR,h\u000f\u0005\u0002o\u00015\t\u0001\u0003C\u0003!\u0013\u0001\u000f\u0011\u0005C\u0003.\u0013\u0001\u000fa\u0006C\u00037\u0013\u0001\u000fq\u0007C\u0003>\u0013\u0001\u000fa\bC\u0003H\u0013\u0001\u000f\u0001\nC\u0003P\u0013\u0001\u000f\u0001\u000bC\u0003X\u0013\u0001\u000f\u0001\fC\u0003c\u0013\u0001\u000f1\r\u000b\u0002\nqB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0007S:TWm\u0019;\u000b\u0003u\fQA[1wCbL!a >\u0003\r%s'.Z2u\u0003\u001d)\u00070Z2vi\u0016$b!!\u0002\u0002\f\u0005\u0015\u0002cA\u000b\u0002\b%\u0019\u0011\u0011\u0002\f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u001bQ\u0001\u0019AA\b\u0003)\u0011x.\u001e;j]\u001e\\U-\u001f\t\u0005\u0003#\tyB\u0004\u0003\u0002\u0014\u0005m\u0001cAA\u000b-5\u0011\u0011q\u0003\u0006\u0004\u00033\u0011\u0012A\u0002\u001fs_>$h(C\u0002\u0002\u001eY\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0011\u0003G\u0011aa\u0015;sS:<'bAA\u000f-!9\u0011q\u0005\u0006A\u0002\u0005%\u0012aB7fgN\fw-\u001a\t\u0005\u0003W\tY$\u0004\u0002\u0002.)!\u0011qFA\u0019\u0003\u0011Q7o\u001c8\u000b\t\u0005M\u0012QG\u0001\u0005Y&\u00147OC\u0002\u001e\u0003oQ!!!\u000f\u0002\tAd\u0017-_\u0005\u0005\u0003{\tiCA\u0004KgZ\u000bG.^3\u0002\u001b\u001d,GOU8vi&twmS3z)\t\ty!A\u0006iC:$G.Z#se>\u0014HCBA\u0003\u0003\u000f\ni\u0006C\u0004\u0002J1\u0001\r!a\u0013\u0002\u0003\u0015\u0004B!!\u0014\u0002X9!\u0011qJA*\u001d\u0011\t)\"!\u0015\n\u0003]I1!!\u0016\u0017\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0017\u0002\\\tIQ\t_2faRLwN\u001c\u0006\u0004\u0003+2\u0002bBA0\u0019\u0001\u0007\u0011\u0011M\u0001\u000fU>\u0014W\t_3dkRLwN\\%e!\r)\u00121M\u0005\u0004\u0003K2\"\u0001\u0002'p]\u001e\fa#\u001a=fGV$XmU#C\u0003&sG/Z4sCRLwN\u001c\u000b\u000b\u0003\u001f\tY'!\u001c\u0002~\u0005\u0005\u0005bBA\u0014\u001b\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003_j\u0001\u0019AA9\u0003\u001dAW-\u00193feN\u0004\u0002\"!\u0005\u0002t\u0005=\u0011qO\u0005\u0005\u0003k\n\u0019CA\u0002NCB\u00042!FA=\u0013\r\tYH\u0006\u0002\u0004\u0003:L\bbBA@\u001b\u0001\u0007\u0011qB\u0001\u0007[>$W\u000f\\3\t\u000f\u0005\rU\u00021\u0001\u0002\u0010\u0005!Qo]3s\u00031\u0019X\r]1sCR,G*\u001b8f)\u0011\tI)a$\u0011\u000bU\tY)a\u0004\n\u0007\u00055eCA\u0003BeJ\f\u0017\u0010C\u0004\u0002\u0012:\u0001\r!a\u0004\u0002\t1Lg.\u001a")
public class SebaController
implements Model {
    private final LogUtil LogUtil;
    private final GenericImportDao genericImportDao;
    private final JobLogUtil JobLogUtil;
    private final HydrologicalStationDao HydrologicalStationDao;
    private final PluviometerDao PluviometerDao;
    private final PointPrelDao PointPrelDao;
    private final PiezometerDaeau piezometerDaeau;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        SebaController sebaController = this;
        synchronized (sebaController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        SebaController sebaController = this;
        synchronized (sebaController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_SEBA();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.executeSEBAIntegration(message, (Map<String, Object>)new HashMap(), "WEB", "JOB_USER");
            return;
        }
        if (string != null) {
            String string4 = string;
            this.LogUtil.info(new StringBuilder(19).append("Bad routing key => ").append(string4).toString(), this.LogUtil.info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.SEBA_MODEL_TOPIC();
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    public String executeSEBAIntegration(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            $this.LogUtil.error(new StringBuilder(45).append("Error validate Json to execute integration :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.LogUtil.error$default$2());
            return "";
        }, (Function1 & Serializable)jobParameters -> {
            Seq seq;
            long jobExecutionId = jobParameters.jobExecutionId();
            String user = (String)jobParameters.user().get();
            Seq parameters = JobUtil$.MODULE$.getParameters(jobParameters, jobExecutionId, $this.JobLogUtil, SebaParameter$.MODULE$.format());
            SebaFilter filters = (SebaFilter)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new SebaFilter(SebaFilter$.MODULE$.$lessinit$greater$default$1(), SebaFilter$.MODULE$.$lessinit$greater$default$2(), SebaFilter$.MODULE$.$lessinit$greater$default$3(), SebaFilter$.MODULE$.$lessinit$greater$default$4(), SebaFilter$.MODULE$.$lessinit$greater$default$5(), SebaFilter$.MODULE$.$lessinit$greater$default$6(), SebaFilter$.MODULE$.$lessinit$greater$default$7(), SebaFilter$.MODULE$.$lessinit$greater$default$8(), SebaFilter$.MODULE$.$lessinit$greater$default$9(), SebaFilter$.MODULE$.$lessinit$greater$default$10(), SebaFilter$.MODULE$.$lessinit$greater$default$11(), SebaFilter$.MODULE$.$lessinit$greater$default$12(), SebaFilter$.MODULE$.$lessinit$greater$default$13()), true, SebaFilter$.MODULE$.format());
            String baseDir = StringUtil$.MODULE$.getPath((String)package$.MODULE$.env().getOrElse((Object)"UPLOAD_DIRECTORY", (Function0 & Serializable)() -> ""));
            String directory = StringUtil$.MODULE$.getPath(new StringBuilder(0).append(baseDir).append(jobParameters.path().getOrElse((Function0 & Serializable)() -> "")).toString());
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"dd.MM.YYYY");
            DateTimeFormatter htf = DateTimeFormat.forPattern((String)"HH:mm");
            String string = StationTypeUtil$.MODULE$.StationType((String)filters.stationType().get());
            String string2 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                seq = (Seq)((IterableOps)$this.piezometerDaeau.getAllCodes($this.piezometerDaeau.getAllCodes$default$1()).$plus$plus((IterableOnce)$this.piezometerDaeau.getAllOldOrNewBssCodes())).map((Function1 & Serializable)c -> new StationCode((int)c.id(), c.code(), (Option)None$.MODULE$));
            } else {
                String string4 = StationTypeUtil$.MODULE$.HYDROMETRY();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    seq = $this.HydrologicalStationDao.getCodes($this.HydrologicalStationDao.getCodes$default$1());
                } else {
                    String string6 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        seq = $this.PluviometerDao.getCodes($this.PluviometerDao.getCodes$default$1());
                    } else {
                        throw new MatchError((Object)string);
                    }
                }
            }
            Seq stationsCodes = seq;
            HashSet filesToSetProcessed = new HashSet();
            Seq processedFiles = $this.JobLogUtil.getProcessedFileNames(jobExecutionId);
            Seq returnedData = (Seq)parameters.flatMap((Function1 & Serializable)stationParameters -> {
                Seq allChannels = (Seq)stationParameters.data().flatMap((Function1 & Serializable)d -> Predef$.MODULE$.wrapRefArray((Object[])d.channels().split(",")));
                String subDir = StringUtil$.MODULE$.getPath((String)stationParameters.directory().getOrElse((Function0 & Serializable)() -> ""));
                String filter = (String)stationParameters.filter().getOrElse((Function0 & Serializable)() -> "*.csv");
                String stationCode = (String)stationParameters.stationCode().getOrElse((Function0 & Serializable)() -> "");
                IndexedSeq splitted = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)filter.split("\\*"));
                String starts = splitted.nonEmpty() ? (String)splitted.head() : filter;
                String ends = splitted.length() > 1 ? (String)splitted.apply(1) : "";
                String dirPath = new StringBuilder(0).append(directory).append(subDir).toString().replace("//", "/");
                if (!new File(dirPath).exists()) {
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(22).append("Directory not found : ").append(dirPath).toString(), stationCode, "");
                    throw new Exception(new StringBuilder(22).append("Directory not found : ").append(dirPath).toString());
                }
                File[] testFiles = new File(dirPath).listFiles();
                File[] files = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])testFiles), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SebaController.$anonfun$executeSEBAIntegration$11(starts, ends, f)));
                File[] filesToProcess = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(filters.dontProcessFilesInLogs().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? (Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SebaController.$anonfun$executeSEBAIntegration$12(processedFiles, f))) : (Object[])files), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SebaController.$anonfun$executeSEBAIntegration$13(f)));
                if (filesToProcess.length > 0 || jobParameters.isManualImport().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    .colon.colon toProcess = jobParameters.isManualImport().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? new .colon.colon((Object)new File(""), (List)Nil$.MODULE$) : Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)filesToProcess);
                    return (IterableOnce)toProcess.flatMap((Function1 & Serializable)f -> {
                        Throwable err;
                        boolean bl = false;
                        Failure failure = null;
                        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                            Seq lines;
                            Seq seq = lines = BoxesRunTime.unboxToBoolean((Object)jobParameters.isManualImport().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? Source$.MODULE$.fromBytes(Base64.decodeBase64((String)((String)jobParameters.fileContent().get())), Codec$.MODULE$.fallbackSystemCodec()).getLines().toSeq() : Source$.MODULE$.fromFile(f.getAbsolutePath(), Codec$.MODULE$.fallbackSystemCodec()).getLines().toSeq();
                            if (lines.isEmpty()) {
                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Empty file", "", f.getName());
                                return (Seq)Nil$.MODULE$;
                            }
                            String[] firstLine = this.separateLine((String)lines.head());
                            String stationTag = firstLine[2].toUpperCase();
                            String usedCode = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(stationCode)) ? stationCode : stationTag;
                            Option option = stationsCodes.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SebaController.$anonfun$executeSEBAIntegration$17(usedCode, x$1)));
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                StationCode foundStation = (StationCode)some.value();
                                if (filters.dontProcessFilesInLogs().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && processedFiles.contains((Object)f.getName())) {
                                    return (Seq)Nil$.MODULE$;
                                }
                                None$ codepoint = stationParameters.pointPrelevement().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim())))) ? $this.PointPrelDao.getPoints((String)filters.stationType().getOrElse((Function0 & Serializable)() -> "piezometry"), foundStation.id()).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SebaController.$anonfun$executeSEBAIntegration$20(stationParameters, x$3))).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.point())) : None$.MODULE$;
                                BooleanRef errorFound = BooleanRef.create((boolean)false);
                                Seq data = (Seq)((IterableOps)((IterableOps)lines.zipWithIndex()).flatMap(arg_0 -> SebaController.$anonfun$executeSEBAIntegration$22(this, errorFound, jobExecutionId, foundStation, f, allChannels, dtf, htf, stationParameters, filters, (Option)codepoint, arg_0))).flatten(Predef$.MODULE$.$conforms());
                                if (jobParameters.isManualImport().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) && jobParameters.returnsData().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.END_DATA(), "end integration of file imported ", foundStation.code(), f.getName());
                                    return data;
                                }
                                try {
                                    if (data.isEmpty()) {
                                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No records to import", foundStation.code(), f.getName());
                                    } else {
                                        int n;
                                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(60).append(data.length()).append(" records read in file + ").append(f.getName()).append(". Begin integration into database...").toString(), foundStation.code(), f.getName());
                                        String string = StationTypeUtil$.MODULE$.StationType((String)filters.stationType().get());
                                        String string2 = StationTypeUtil$.MODULE$.PIEZOMETRY();
                                        String string3 = string;
                                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                            Option<Object> x$16 = filters.measureCote();
                                            Option<String> x$17 = filters.importMode();
                                            Option<Object> x$18 = ImportOptions$.MODULE$.apply$default$1();
                                            Option<String> x$19 = ImportOptions$.MODULE$.apply$default$4();
                                            Option<Object> x$20 = ImportOptions$.MODULE$.apply$default$5();
                                            Option<Seq<Object>> x$21 = ImportOptions$.MODULE$.apply$default$6();
                                            Option<Object> x$22 = ImportOptions$.MODULE$.apply$default$7();
                                            n = $this.genericImportDao.importPiezometryGeneric(Integer.toString(foundStation.id()), foundStation.code(), user, jobExecutionId, (Seq<GenericData>)data, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$18, x$17, x$16, x$19, x$20, x$21, x$22)));
                                        } else {
                                            String string4 = StationTypeUtil$.MODULE$.HYDROMETRY();
                                            String string5 = string;
                                            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                                                Option<Object> x$23 = filters.measureCote();
                                                Option<String> x$24 = filters.importMode();
                                                Option<Object> x$25 = ImportOptions$.MODULE$.apply$default$1();
                                                Option<String> x$26 = ImportOptions$.MODULE$.apply$default$4();
                                                Option<Object> x$27 = ImportOptions$.MODULE$.apply$default$5();
                                                Option<Seq<Object>> x$28 = ImportOptions$.MODULE$.apply$default$6();
                                                Option<Object> x$29 = ImportOptions$.MODULE$.apply$default$7();
                                                n = $this.genericImportDao.importHydrometryGeneric(Integer.toString(foundStation.id()), foundStation.code(), user, jobExecutionId, (Seq<GenericData>)data, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$25, x$24, x$23, x$26, x$27, x$28, x$29)));
                                            } else {
                                                String string6 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                                                String string7 = string;
                                                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                                    Option<Object> x$30 = filters.measureCote();
                                                    Option<String> x$31 = filters.importMode();
                                                    Option<Object> x$32 = ImportOptions$.MODULE$.apply$default$1();
                                                    Option<String> x$33 = ImportOptions$.MODULE$.apply$default$4();
                                                    Option<Object> x$34 = ImportOptions$.MODULE$.apply$default$5();
                                                    Option<Seq<Object>> x$35 = ImportOptions$.MODULE$.apply$default$6();
                                                    Option<Object> x$36 = ImportOptions$.MODULE$.apply$default$7();
                                                    n = $this.genericImportDao.importPluviometryGeneric(Integer.toString(foundStation.id()), foundStation.code(), user, jobExecutionId, (Seq<GenericData>)data, (Option<ImportOptions>)new Some((Object)new ImportOptions(x$32, x$31, x$30, x$33, x$34, x$35, x$36)));
                                                } else {
                                                    throw new MatchError((Object)string);
                                                }
                                            }
                                        }
                                        int results = n;
                                        $this.JobLogUtil.log(jobExecutionId, results == 0 ? JobState$.MODULE$.NOTHING_TO_DO() : JobState$.MODULE$.SUCCESS(), new StringBuilder(30).append(results).append(" records imported with file : ").append(f.getName()).toString(), foundStation.code(), f.getName());
                                    }
                                }
                                catch (InterruptedException interupted) {
                                    throw interupted;
                                }
                                catch (Exception exception) {
                                    $this.LogUtil.printError((Throwable)exception);
                                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), exception.getMessage(), foundStation.code(), f.getName());
                                }
                                filesToSetProcessed.$plus$eq((Object)f.getAbsolutePath());
                                return (Seq)Nil$.MODULE$;
                            }
                            if (None$.MODULE$.equals(option)) {
                                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(52).append("Can't find station in database with code : ").append(stationTag).append(", file : ").append(f.getName()).toString(), stationTag, f.getName());
                                return (Seq)Nil$.MODULE$;
                            }
                            throw new MatchError((Object)option);
                        });
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            Seq res = (Seq)success.value();
                            return res;
                        }
                        if (try_ instanceof Failure) {
                            bl = true;
                            failure = (Failure)try_;
                            Throwable interupted = failure.exception();
                            if (interupted instanceof InterruptedException) {
                                InterruptedException interruptedException = (InterruptedException)interupted;
                                throw interruptedException;
                            }
                        }
                        if (bl && (err = failure.exception()).getMessage().contains("head of empty stream") && f.length() <= 1L) {
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), new StringBuilder(16).append("File corrupted :").append(f.getName()).toString(), (String)stationParameters.stationCode().getOrElse((Function0 & Serializable)() -> ""), f.getName());
                            return Nil$.MODULE$;
                        }
                        if (bl) {
                            Throwable err2 = failure.exception();
                            $this.LogUtil.printError(err2);
                            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(36).append("Error while reading file :").append(f.getName()).append(", error : ").append(err2.getMessage()).toString(), (String)stationParameters.stationCode().getOrElse((Function0 & Serializable)() -> ""), f.getName());
                            return Nil$.MODULE$;
                        }
                        throw new MatchError((Object)try_);
                    });
                }
                $this.LogUtil.error(new StringBuilder(31).append("No files to process with filter").append(filter).toString(), $this.LogUtil.error$default$2());
                $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), new StringBuilder(31).append("No files to process with filter").append(filter).toString(), (String)stationParameters.stationCode().getOrElse((Function0 & Serializable)() -> ""), $this.JobLogUtil.log$default$5());
                return Nil$.MODULE$;
            });
            filesToSetProcessed.foreach((Function1 & Serializable)filePath -> {
                SebaController.$anonfun$executeSEBAIntegration$32(this, jobExecutionId, filePath);
                return BoxedUnit.UNIT;
            });
            if (filters.renameProcessedFiles().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                DateTime now = new DateTime();
                filesToSetProcessed.foreach((Function1 & Serializable)filePath -> {
                    SebaController.$anonfun$executeSEBAIntegration$33(this, now, jobExecutionId, filePath);
                    return BoxedUnit.UNIT;
                });
            }
            if (jobParameters.returnsData().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return Json$.MODULE$.toJson((Object)returnedData, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)GenericData$.MODULE$.writes())).toString();
            }
            return "";
        });
    }

    public String[] separateLine(String line) {
        return line.replace(";", "").replace("T001:", "").split(",");
    }

    public static final /* synthetic */ boolean $anonfun$executeSEBAIntegration$11(String starts$1, String ends$1, File f) {
        return f.getName().startsWith(starts$1) && f.getName().endsWith(ends$1);
    }

    public static final /* synthetic */ boolean $anonfun$executeSEBAIntegration$12(Seq processedFiles$1, File f) {
        return !processedFiles$1.contains((Object)f.getName());
    }

    public static final /* synthetic */ boolean $anonfun$executeSEBAIntegration$13(File f) {
        return !f.getName().contains(".DONE");
    }

    public static final /* synthetic */ boolean $anonfun$executeSEBAIntegration$17(String usedCode$1, StationCode x$1) {
        String string = x$1.code();
        String string2 = usedCode$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$executeSEBAIntegration$20(SebaParameter stationParameters$1, PointPrel x$3) {
        String string = x$3.code().trim().toLowerCase();
        String string2 = ((String)stationParameters$1.pointPrelevement().get()).trim().toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Option $anonfun$executeSEBAIntegration$22(SebaController $this, BooleanRef errorFound$1, long jobExecutionId$1, StationCode foundStation$1, File f$1, Seq allChannels$1, DateTimeFormatter dtf$1, DateTimeFormatter htf$1, SebaParameter stationParameters$1, SebaFilter filters$1, Option codepoint$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Success success;
            Object values;
            String line = (String)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                String string = line.trim();
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return None$.MODULE$;
                }
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    List list;
                    String hour;
                    String date;
                    block3: {
                        List list2;
                        block2: {
                            list2 = Predef$.MODULE$.wrapRefArray((Object[])$this.separateLine(line)).toList();
                            if (!(list2 instanceof .colon.colon)) break block2;
                            .colon.colon colon2 = (.colon.colon)list2;
                            date = (String)colon2.head();
                            List list3 = colon2.next$access$1();
                            if (!(list3 instanceof .colon.colon)) break block2;
                            .colon.colon colon3 = (.colon.colon)list3;
                            hour = (String)colon3.head();
                            list = colon3.next$access$1();
                            if (list instanceof .colon.colon) break block3;
                        }
                        throw new MatchError((Object)list2);
                    }
                    .colon.colon colon4 = (.colon.colon)list;
                    List values = colon4.next$access$1();
                    Tuple3 tuple3 = new Tuple3((Object)date, (Object)hour, (Object)values);
                    String date2 = (String)tuple3._1();
                    String hour2 = (String)tuple3._2();
                    List values2 = (List)tuple3._3();
                    return new Tuple3((Object)date2, (Object)hour2, (Object)values2);
                });
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        errorFound$1.elem = true;
                        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(56).append("Error while extracting dates, hour and values in line ").append(idx + 1).append(", ").append(exception.getMessage()).toString(), foundStation$1.code(), f$1.getName());
                        $this.LogUtil.printError(exception);
                        throw exception;
                    }
                    throw new MatchError((Object)try_);
                }
                Success success = (Success)try_;
                Tuple3 res = (Tuple3)success.value();
                Tuple3 tuple3 = res;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                String date = (String)tuple3._1();
                String hour = (String)tuple3._2();
                List values = (List)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)date, (Object)hour, (Object)values);
                String date2 = (String)tuple32._1();
                String hour2 = (String)tuple32._2();
                List values2 = (List)tuple32._3();
                List res2 = values2.flatMap((Function1 & Serializable)strValue -> {
                    String value;
                    String channel;
                    block5: {
                        List list;
                        block4: {
                            list = Predef$.MODULE$.wrapRefArray((Object[])strValue.split("=")).toList();
                            if (!(list instanceof .colon.colon)) break block4;
                            .colon.colon colon2 = (.colon.colon)list;
                            channel = (String)colon2.head();
                            List list2 = colon2.next$access$1();
                            if (!(list2 instanceof .colon.colon)) break block4;
                            .colon.colon colon3 = (.colon.colon)list2;
                            value = (String)colon3.head();
                            List list3 = colon3.next$access$1();
                            if (Nil$.MODULE$.equals(list3)) break block5;
                        }
                        throw new MatchError((Object)list);
                    }
                    Tuple2 tuple2 = new Tuple2((Object)channel, (Object)value);
                    String channel2 = (String)tuple2._1();
                    String value2 = (String)tuple2._2();
                    if (allChannels$1.contains((Object)channel2)) {
                        DateTime parsedDate;
                        DateTime x$1 = parsedDate = (DateTime)DateUtil$.MODULE$.getFullDate((Option)new Some((Object)dtf$1.parseDateTime(date2)), (Option)new Some((Object)htf$1.parseDateTime(hour2))).get();
                        DateTime x$2 = parsedDate;
                        Some x$3 = new Some((Object)BoxesRunTime.boxToDouble((double)(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(value2)) * BoxesRunTime.unboxToDouble((Object)stationParameters$1.factor().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0)) + BoxesRunTime.unboxToDouble((Object)stationParameters$1.offset().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)))));
                        int x$4 = ((SebaDataType)stationParameters$1.data().find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])d.channels().split(",")), (Object)channel2))).get()).id();
                        Option<Object> x$5 = filters$1.status();
                        Option<Object> x$6 = filters$1.qualification();
                        Option<Object> x$7 = filters$1.obtainingMode();
                        Option<Object> x$8 = filters$1.producer();
                        Option<Object> x$9 = filters$1.validator();
                        Option<Object> x$10 = filters$1.manager();
                        Option<String> x$11 = filters$1.nature();
                        Option x$12 = codepoint$1;
                        Option x$13 = GenericData$.MODULE$.apply$default$12();
                        Option x$14 = GenericData$.MODULE$.apply$default$13();
                        Option x$15 = GenericData$.MODULE$.apply$default$14();
                        return new Some((Object)new GenericData(x$1, x$2, (Option)x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$13, x$14, x$15, x$12));
                    }
                    return None$.MODULE$;
                });
                return res2;
            });
            if (try_ instanceof Success && (values = (success = (Success)try_).value()) instanceof Seq) {
                Seq seq = (Seq)values;
                return new Some((Object)seq);
            }
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable e = failure.exception();
                if (e instanceof MatchError) {
                    MatchError matchError = (MatchError)e;
                    errorFound$1.elem = true;
                    $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(50).append("Error while reading channel and values in line ").append(idx + 1).append(",  ").append(matchError.getMessage()).toString(), foundStation$1.code(), f$1.getName());
                    $this.LogUtil.printError((Throwable)matchError);
                    return None$.MODULE$;
                }
            }
            if (bl) {
                Throwable err = failure.exception();
                errorFound$1.elem = true;
                $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(35).append("Error while reading file in line ").append(idx + 1).append(", ").append(err.getMessage()).toString(), foundStation$1.code(), f$1.getName());
                $this.LogUtil.printError(err);
                return None$.MODULE$;
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$executeSEBAIntegration$32(SebaController $this, long jobExecutionId$1, String filePath) {
        File f = new File(filePath);
        $this.JobLogUtil.setFileProcessed(f, jobExecutionId$1);
    }

    public static final /* synthetic */ void $anonfun$executeSEBAIntegration$33(SebaController $this, DateTime now$1, long jobExecutionId$1, String filePath) {
        File f = new File(filePath);
        if (!f.renameTo(new File(new StringBuilder(6).append(f.getAbsolutePath()).append(".").append(now$1.toString("YYYMMDDHHmmss")).append(".DONE").toString()))) {
            $this.LogUtil.error(new StringBuilder(21).append("Error to rename file ").append(f.getName()).toString(), $this.LogUtil.error$default$2());
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), new StringBuilder(21).append("Error to rename file ").append(f.getName()).toString(), " ", $this.JobLogUtil.log$default$5());
            return;
        }
    }

    @Inject
    public SebaController(LogUtil LogUtil2, GenericImportDao genericImportDao, JobLogUtil JobLogUtil2, JobFileDao JobFileDao2, HydrologicalStationDao HydrologicalStationDao2, PluviometerDao PluviometerDao2, PointPrelDao PointPrelDao2, PiezometerDaeau piezometerDaeau) {
        this.LogUtil = LogUtil2;
        this.genericImportDao = genericImportDao;
        this.JobLogUtil = JobLogUtil2;
        this.HydrologicalStationDao = HydrologicalStationDao2;
        this.PluviometerDao = PluviometerDao2;
        this.PointPrelDao = PointPrelDao2;
        this.piezometerDaeau = piezometerDaeau;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        Statics.releaseFence();
    }
}

