/*
 * Decompiled with CFR 0.152.
 */
package synop.dao.http;

import constant.JobState$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.JsValue;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSResponse;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001\u0002\u0005\n\u0001AA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006Y\u0001\u0007\u0005\tI\u0001\u0011\t\u0011)A\u0006K!A1\u0006\u0001B\u0001B\u0003-A\u0006C\u00038\u0001\u0011\u0005\u0001\bC\u0003I\u0001\u0011\u0005\u0011\nC\u0003T\u0001\u0011\u0005A\u000bC\u0004u\u0001E\u0005I\u0011A;\u0003\u0011MKhn\u001c9EC>T!AC\u0006\u0002\t!$H\u000f\u001d\u0006\u0003\u00195\t1\u0001Z1p\u0015\u0005q\u0011!B:z]>\u00048\u0001A\n\u0003\u0001E\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0017a\u0002'pOV#\u0018\u000e\u001c\t\u00033\tj\u0011A\u0007\u0006\u00037q\tA!\u001e;jY*\u0011QDH\u0001\te\u0006\u0014'-\u001b;nc*\u0011q\u0004I\u0001\bCF,\u0018m]=t\u0015\u0005\t\u0013A\u00014s\u0013\t\u0019#DA\u0004M_\u001e,F/\u001b7\u0002\u0015){'\rT8h+RLG\u000e\u0005\u0002'S5\tqE\u0003\u0002)=\u0005)Q\u000f^5mg&\u0011!f\n\u0002\u000b\u0015>\u0014Gj\\4Vi&d\u0017AA<t!\tiS'D\u0001/\u0015\tYsF\u0003\u00021c\u0005!A.\u001b2t\u0015\t\u00114'A\u0002ba&T\u0011\u0001N\u0001\u0005a2\f\u00170\u0003\u00027]\tAqkU\"mS\u0016tG/\u0001\u0004=S:LGO\u0010\u000b\u0002sQ!!\bP\u001f?!\tY\u0004!D\u0001\n\u0011\u00159B\u0001q\u0001\u0019\u0011\u0015!C\u0001q\u0001&\u0011\u0015YC\u0001q\u0001-Q\t!\u0001\t\u0005\u0002B\r6\t!I\u0003\u0002D\t\u00061\u0011N\u001c6fGRT\u0011!R\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u000f\n\u0013a!\u00138kK\u000e$\u0018aD4fiN#\u0018\r^5p]NKhn\u001c9\u0015\u0003)\u00032AE&N\u0013\ta5C\u0001\u0004PaRLwN\u001c\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!>\nAA[:p]&\u0011!k\u0014\u0002\b\u0015N4\u0016\r\\;f\u0003-9W\r^'fCN,(/Z:\u0015\t)+&m\u001c\u0005\u0006-\u001a\u0001\raV\u0001\u0005G>$W\r\u0005\u0002Y?:\u0011\u0011,\u0018\t\u00035Ni\u0011a\u0017\u0006\u00039>\ta\u0001\u0010:p_Rt\u0014B\u00010\u0014\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001-\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\u001b\u0002bB2\u0007!\u0003\u0005\r\u0001Z\u0001\ngR\f'\u000f\u001e#bi\u0016\u00042AE&f!\t1W.D\u0001h\u0015\tA\u0017.\u0001\u0003uS6,'B\u00016l\u0003\u0011Qw\u000eZ1\u000b\u00031\f1a\u001c:h\u0013\tqwM\u0001\u0005ECR,G+[7f\u0011\u0015\u0001h\u00011\u0001r\u00039QwNY#yK\u000e,H/[8o\u0013\u0012\u0004\"A\u0005:\n\u0005M\u001c\"\u0001\u0002'p]\u001e\fQcZ3u\u001b\u0016\f7/\u001e:fg\u0012\"WMZ1vYR$#'F\u0001wU\t!woK\u0001y!\tIh0D\u0001{\u0015\tYH0A\u0005v]\u000eDWmY6fI*\u0011QpE\u0001\u000bC:tw\u000e^1uS>t\u0017BA@{\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class SynopDao {
    private final LogUtil LogUtil;
    private final JobLogUtil JobLogUtil;
    private final WSClient ws;

    public Option<JsValue> getStationSynop() {
        String applicationToken = System.getenv("APPLICATION_TOKEN");
        String urlAqua6bo = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"AQUA6BO_URL", (Function0 & Serializable)() -> "https://aqua6bo.aquadb.fr");
        String url = new StringBuilder(20).append(urlAqua6bo).append("/data/synop/stations").toString();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> ((WSResponse)Await$.MODULE$.result((Awaitable)$this.ws.url(url).withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Authorization", (Object)applicationToken)})).get(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).minutes())).json());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JsValue data = (JsValue)success.value();
            return new Some((Object)data);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.LogUtil.error(new StringBuilder(40).append("Fail to get stations from Aqua6bo on ").append(url).append(" :\n").append(e.getMessage()).toString(), this.LogUtil.error$default$2());
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    public Option<JsValue> getMeasures(String code, Option<DateTime> startDate, long jobExecutionId) {
        String string;
        String applicationToken = System.getenv("APPLICATION_TOKEN");
        String urlAqua6bo = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"AQUA6BO_URL", (Function0 & Serializable)() -> "https://aqua6bo.aquadb.fr");
        Option<DateTime> option = startDate;
        if (option instanceof Some) {
            Some some = (Some)option;
            DateTime date = (DateTime)some.value();
            string = new StringBuilder(11).append("&beginDate=").append(date.getMillis()).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError(option);
        }
        String startDateOption = string;
        String url = new StringBuilder(49).append(urlAqua6bo).append("/data/synop/measures?code=").append(code).append("&dataType=rain&endDate=").append(DateTime.now().plusMonths(1).getMillis()).append(startDateOption).toString();
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(13).append("url called : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> ((WSResponse)Await$.MODULE$.result((Awaitable)$this.ws.url(url).withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Authorization", (Object)applicationToken)})).withRequestTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).minutes()).get(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).minutes())).json());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JsValue data = (JsValue)success.value();
            return new Some((Object)data);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.LogUtil.error(new StringBuilder(40).append("Fail to get measures from Aqua6bo on ").append(url).append(" :\n").append(e.getMessage()).toString(), this.LogUtil.error$default$2());
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    public Option<DateTime> getMeasures$default$2() {
        return None$.MODULE$;
    }

    @Inject
    public SynopDao(LogUtil LogUtil2, JobLogUtil JobLogUtil2, WSClient ws) {
        this.LogUtil = LogUtil2;
        this.JobLogUtil = JobLogUtil2;
        this.ws = ws;
    }
}

