/*
 * Decompiled with CFR 0.152.
 */
package tidegauge.controller;

import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constant.ImportMode$;
import fr.aquasys.daeau.hydrometry.itf.HydrometryEventDao;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import genericImport.anorms.AnormHydroChronicImportDao;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import hydrometry.dao.HydrometryStationDao;
import hydrometry.model.HydrometryStation;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.ws.WSClient;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import tidegauge.constant.TideGaugeConstants$;
import tidegauge.controller.OceanogramFilter;
import tidegauge.controller.OceanogramFilter$;
import tidegauge.dao.StationsHydroMaree;
import tidegauge.dao.http.Aqua6boTideGaugeDao;
import tidegauge.model.HydroMaree;
import tidegauge.model.HydroMaree$;
import tidegauge.model.OceanogramParameters;
import tidegauge.model.OceanogramParameters$;
import tidegauge.model.Oceanogramme;
import tidegauge.model.ValueVariable;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\b\u0011\u0001UA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ya\t\u0005\t[\u0001\u0011\t\u0011)A\u0006]!A!\b\u0001B\u0001B\u0003-1\b\u0003\u0005D\u0001\t\u0005\t\u0015a\u0003E\u0011!Y\u0005A!A!\u0002\u0017a\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b1B+\t\u0011y\u0003!\u0011!Q\u0001\f}C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006Y\u0001\u001a\u0005\u0006U\u0002!\ta\u001b\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\tY\u0002\u0001C!\u0003;Aq!!\u000f\u0001\t\u0003\nY\u0004C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f\t!rjY3b]><'/Y7D_:$(o\u001c7mKJT!!\u0005\n\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0014\u0003%!\u0018\u000eZ3hCV<Wm\u0001\u0001\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005\u0019\u0011\r]5\n\u0005\u0005r\"!B'pI\u0016d\u0017AA<t!\t!3&D\u0001&\u0015\t\u0011cE\u0003\u0002(Q\u0005!A.\u001b2t\u0015\ty\u0012FC\u0001+\u0003\u0011\u0001H.Y=\n\u00051*#\u0001C,T\u00072LWM\u001c;\u0002\u000f1{w-\u0016;jYB\u0011q\u0006O\u0007\u0002a)\u0011\u0011GM\u0001\u0005kRLGN\u0003\u00024i\u0005A!/\u00192cSRl\u0017O\u0003\u00026m\u00059\u0011-];bgf\u001c(\"A\u001c\u0002\u0005\u0019\u0014\u0018BA\u001d1\u0005\u001daunZ+uS2\f1#Y9vCZ\u0012w\u000eV5eK\u001e\u000bWoZ3EC>\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\t!$H\u000f\u001d\u0006\u0003\u0001J\t1\u0001Z1p\u0013\t\u0011UHA\nBcV\fgGY8US\u0012,w)Y;hK\u0012\u000bw.\u0001\u000bis\u0012\u0014x.\\3uef\u001cF/\u0019;j_:$\u0015m\u001c\t\u0003\u000b&k\u0011A\u0012\u0006\u0003\u0001\u001eS\u0011\u0001S\u0001\u000bQf$'o\\7fiJL\u0018B\u0001&G\u0005QA\u0015\u0010\u001a:p[\u0016$(/_*uCRLwN\u001c#b_\u0006Q\u0012I\\8s[\"KHM]8DQJ|g.[2J[B|'\u000f\u001e#b_B\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0007C:|'/\\:\u000b\u0003E\u000bQbZ3oKJL7-S7q_J$\u0018BA*O\u0005i\ten\u001c:n\u0011f$'o\\\"ie>t\u0017nY%na>\u0014H\u000fR1p\u0003IA\u0017\u0010\u001a:p[\u0016$(/_#wK:$H)Y8\u0011\u0005YcV\"A,\u000b\u0005aK\u0016aA5uM*\u0011\u0001J\u0017\u0006\u00037R\nQ\u0001Z1fCVL!!X,\u0003%!KHM]8nKR\u0014\u00180\u0012<f]R$\u0015m\\\u0001\u0013gR\fG/[8og\"KHM]8NCJ,W\r\u0005\u0002aC6\tq(\u0003\u0002c\u007f\t\u00112\u000b^1uS>t7\u000fS=ee>l\u0015M]3f\u0003)QuN\u0019'pOV#\u0018\u000e\u001c\t\u0003K\"l\u0011A\u001a\u0006\u0003OR\nQ!\u001e;jYNL!!\u001b4\u0003\u0015){'\rT8h+RLG.\u0001\u0004=S:LGO\u0010\u000b\u0002YRIQn\u001c9reN$XO\u001e\t\u0003]\u0002i\u0011\u0001\u0005\u0005\u0006E%\u0001\u001da\t\u0005\u0006[%\u0001\u001dA\f\u0005\u0006u%\u0001\u001da\u000f\u0005\u0006\u0007&\u0001\u001d\u0001\u0012\u0005\u0006\u0017&\u0001\u001d\u0001\u0014\u0005\u0006)&\u0001\u001d!\u0016\u0005\u0006=&\u0001\u001da\u0018\u0005\u0006G&\u0001\u001d\u0001\u001a\u0015\u0003\u0013a\u0004\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\r%t'.Z2u\u0015\u0005i\u0018!\u00026bm\u0006D\u0018BA@{\u0005\u0019IeN[3di\u0006iq-\u001a;S_V$\u0018N\\4LKf$\"!!\u0002\u0011\t\u0005\u001d\u0011Q\u0003\b\u0005\u0003\u0013\t\t\u0002E\u0002\u0002\fai!!!\u0004\u000b\u0007\u0005=A#\u0001\u0004=e>|GOP\u0005\u0004\u0003'A\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0018\u0005e!AB*ue&twMC\u0002\u0002\u0014a\tq!\u001a=fGV$X\r\u0006\u0004\u0002 \u0005\u0015\u0012\u0011\u0006\t\u0004/\u0005\u0005\u0012bAA\u00121\t!QK\\5u\u0011\u001d\t9c\u0003a\u0001\u0003\u000b\t!B]8vi&twmS3z\u0011\u001d\tYc\u0003a\u0001\u0003[\tq!\\3tg\u0006<W\r\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019DJ\u0001\u0005UN|g.\u0003\u0003\u00028\u0005E\"a\u0002&t-\u0006dW/Z\u0001\fQ\u0006tG\r\\3FeJ|'\u000f\u0006\u0004\u0002 \u0005u\u00121\u000b\u0005\b\u0003\u007fa\u0001\u0019AA!\u0003\u0005)\u0007\u0003BA\"\u0003\u001brA!!\u0012\u0002J9!\u00111BA$\u0013\u0005I\u0012bAA&1\u00059\u0001/Y2lC\u001e,\u0017\u0002BA(\u0003#\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005-\u0003\u0004C\u0004\u0002V1\u0001\r!a\u0016\u0002\u001d)|'-\u0012=fGV$\u0018n\u001c8JIB\u0019q#!\u0017\n\u0007\u0005m\u0003D\u0001\u0003M_:<\u0017\u0001F(dK:\fwM]1n\u0013:$Xm\u001a:bi&|g\u000e\u0006\u0003\u0002 \u0005\u0005\u0004bBA\u0016\u001b\u0001\u0007\u0011QF\u0001\u001d\u001f\u000e,\u0017M\\8he\u0006lW*Z1tkJ,\u0017J\u001c;fOJ\fG/[8o)1\t9'a\u001b\u0002v\u0005e\u0014QPAA)\u0011\ty\"!\u001b\t\u000f\u0005Uc\u0002q\u0001\u0002X!9\u0011Q\u000e\bA\u0002\u0005=\u0014a\u00043bi\u0006Le\u000e^3he\u0006$\u0018n\u001c8\u0011\u000b]\t\t(!\u0002\n\u0007\u0005M\u0004D\u0001\u0004PaRLwN\u001c\u0005\b\u0003or\u0001\u0019AA\u0003\u0003\u001d\u0019H/\u0019;j_:Dq!a\u001f\u000f\u0001\u0004\ty'\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0003\u007fr\u0001\u0019AA\u0003\u0003\u0011)8/\u001a:\t\u000f\u0005\re\u00021\u0001\u0002\u0006\u00061a-\u001b7uKJ\u00042A\\AD\u0013\r\tI\t\u0005\u0002\u0011\u001f\u000e,\u0017M\\8he\u0006lg)\u001b7uKJD3\u0001AAG!\rI\u0018qR\u0005\u0004\u0003#S(!C*j]\u001edW\r^8o\u0001")
public class OceanogramController
implements Model {
    private final LogUtil LogUtil;
    private final Aqua6boTideGaugeDao aqua6boTideGaugeDao;
    private final HydrometryStationDao hydrometryStationDao;
    private final AnormHydroChronicImportDao AnormHydroChronicImportDao;
    private final StationsHydroMaree stationsHydroMaree;
    private final JobLogUtil JobLogUtil;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        OceanogramController oceanogramController = this;
        synchronized (oceanogramController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        OceanogramController oceanogramController = this;
        synchronized (oceanogramController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.INTEGRATION_OCEANOGRAM();
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_OCEANOGRAM();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.OcenagramIntegration(message);
            return;
        }
        if (string != null) {
            String string4 = string;
            this.LogUtil.info(new StringBuilder(19).append("Bad routing key => ").append(string4).toString(), this.LogUtil.info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    public void OcenagramIntegration(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            OceanogramController.$anonfun$OcenagramIntegration$1(this, error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)parameters -> {
            Object object;
            try {
                long jobExecutionId = parameters.jobExecutionId();
                String x$1 = "1";
                Option<String> x$2 = OceanogramFilter$.MODULE$.apply$default$1();
                Option<Object> x$3 = OceanogramFilter$.MODULE$.apply$default$2();
                Option<Object> x$4 = OceanogramFilter$.MODULE$.apply$default$3();
                Option<Object> x$5 = OceanogramFilter$.MODULE$.apply$default$4();
                Option<Object> x$6 = OceanogramFilter$.MODULE$.apply$default$5();
                Option<Object> x$7 = OceanogramFilter$.MODULE$.apply$default$6();
                Option<Object> x$8 = OceanogramFilter$.MODULE$.apply$default$7();
                Option<Object> x$9 = OceanogramFilter$.MODULE$.apply$default$8();
                Option<Object> x$10 = OceanogramFilter$.MODULE$.apply$default$9();
                Option<Object> x$11 = OceanogramFilter$.MODULE$.apply$default$10();
                Option<Object> x$12 = OceanogramFilter$.MODULE$.apply$default$11();
                Option<String> x$13 = OceanogramFilter$.MODULE$.apply$default$12();
                Option<Object> x$14 = OceanogramFilter$.MODULE$.apply$default$13();
                Option<Object> x$15 = OceanogramFilter$.MODULE$.apply$default$14();
                Option<Object> x$16 = OceanogramFilter$.MODULE$.apply$default$15();
                Option<Object> x$17 = OceanogramFilter$.MODULE$.apply$default$16();
                Option<Object> x$18 = OceanogramFilter$.MODULE$.apply$default$17();
                Option<Object> x$19 = OceanogramFilter$.MODULE$.apply$default$18();
                Option<Object> x$20 = OceanogramFilter$.MODULE$.apply$default$19();
                Option<Object> x$21 = OceanogramFilter$.MODULE$.apply$default$20();
                Option<Object> x$22 = OceanogramFilter$.MODULE$.apply$default$21();
                OceanogramFilter filter = (OceanogramFilter)JobUtil$.MODULE$.getFilters(parameters, jobExecutionId, $this.JobLogUtil, (Object)new OceanogramFilter(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, "1"), false, OceanogramFilter$.MODULE$.format());
                Option<String> importMode = filter.importMode();
                scala.collection.immutable.Seq params = JobUtil$.MODULE$.getParameters(parameters, jobExecutionId, $this.JobLogUtil, OceanogramParameters$.MODULE$.jsonReads());
                object = params.map((Function1 & Serializable)param -> {
                    OceanogramController.$anonfun$OcenagramIntegration$3(this, jobExecutionId, importMode, parameters, filter, param);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                $this.LogUtil.error(new StringBuilder(14).append("Error : ").append(e.getClass().getName()).append(" : ").append(e.getMessage()).append(" \n ").toString(), $this.LogUtil.error$default$2());
                $this.JobLogUtil.log(parameters.jobExecutionId(), JobState$.MODULE$.ERROR(), e.getMessage(), "", $this.JobLogUtil.log$default$5());
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public void OceanogramMeasureIntegration(Option<String> dataIntegration, String station, Option<String> offset, String user, OceanogramFilter filter, long jobExecutionId) {
        Option<String> x$12 = dataIntegration;
        Option<Object> x$22 = ImportOptions$.MODULE$.$lessinit$greater$default$1();
        Option<Object> x$3 = ImportOptions$.MODULE$.$lessinit$greater$default$3();
        Option<String> x$4 = ImportOptions$.MODULE$.$lessinit$greater$default$4();
        Option<Object> x$5 = ImportOptions$.MODULE$.$lessinit$greater$default$5();
        Option<scala.collection.immutable.Seq<Object>> x$6 = ImportOptions$.MODULE$.$lessinit$greater$default$6();
        Option<Object> x$7 = ImportOptions$.MODULE$.$lessinit$greater$default$7();
        Some importOptions = new Some((Object)new ImportOptions(x$22, x$12, x$3, x$4, x$5, x$6, x$7));
        Option<HydrometryStation> stationOption = this.hydrometryStationDao.get(station);
        if (stationOption.isDefined()) {
            int stationId = (int)((HydrometryStation)stationOption.get()).id();
            DateTimeFormatter dateFormater = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            double ofset = BoxesRunTime.unboxToDouble((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(((String)offset.get()).replace(',', '.')))).toOption().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
            String url = station.contains("#") ? new StringBuilder(12).append(TideGaugeConstants$.MODULE$.OCEANOGRAM_URL()).append("code=").append(station.substring(0, station.indexOf("#"))).append("&delta=").append(filter.delta()).toString() : new StringBuilder(12).append(TideGaugeConstants$.MODULE$.OCEANOGRAM_URL()).append("code=").append(station).append("&delta=").append(filter.delta()).toString();
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(11).append("Call url : ").append(url).toString(), station, this.JobLogUtil.log$default$5());
            Option<Oceanogramme> oceano = this.aqua6boTideGaugeDao.getOceanogramData(url, station, filter.delta(), 0, jobExecutionId);
            if (oceano.isDefined()) {
                if (filter.surchargeReal().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    scala.collection.immutable.Seq data = (scala.collection.immutable.Seq)((IterableOps)((Oceanogramme)oceano.get()).valueVariable().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OceanogramController.$anonfun$OceanogramMeasureIntegration$3(x$1)))).map((Function1 & Serializable)vv -> new GenericData(dateFormater.parseDateTime(vv.datetime()), dateFormater.parseDateTime(vv.datetime()), (Option)new Some(vv.surge().get()), BoxesRunTime.unboxToInt((Object)filter.surchargeRealDt().get()), filter.status(), filter.qualification(), filter.obtainingMode(), filter.producer(), filter.validator(), filter.manager(), filter.nature(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(27).append("Begin integration of ").append(data.size()).append(" surge").toString(), station, this.JobLogUtil.log$default$5());
                    this.AnormHydroChronicImportDao.importMeasuresConnect(stationId, station, user, jobExecutionId, (scala.collection.immutable.Seq<GenericData>)data, (Option<ImportOptions>)importOptions);
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(21).append("Integration of ").append(data.size()).append(" surge").toString(), station, this.JobLogUtil.log$default$5());
                }
                if (filter.height().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    scala.collection.immutable.Seq data = (scala.collection.immutable.Seq)((IterableOps)((Oceanogramme)oceano.get()).valueVariable().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)OceanogramController.$anonfun$OceanogramMeasureIntegration$5(x$2)))).map((Function1 & Serializable)vv -> new GenericData(dateFormater.parseDateTime(vv.datetime()), dateFormater.parseDateTime(vv.datetime()), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)vv.ssh().get()) + ofset))), BoxesRunTime.unboxToInt((Object)filter.heightDt().get()), filter.status(), filter.qualification(), filter.obtainingMode(), filter.producer(), filter.validator(), filter.manager(), filter.nature(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(28).append("Begin integration of ").append(data.size()).append(" height").toString(), station, this.JobLogUtil.log$default$5());
                    this.AnormHydroChronicImportDao.importMeasuresConnect(stationId, station, user, jobExecutionId, (scala.collection.immutable.Seq<GenericData>)data, (Option<ImportOptions>)importOptions);
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(22).append("Integration of ").append(data.size()).append(" height").toString(), station, this.JobLogUtil.log$default$5());
                }
                if (filter.tide().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    scala.collection.immutable.Seq dataToImport = (scala.collection.immutable.Seq)((IterableOps)((Oceanogramme)oceano.get()).externalData().map((Function1 & Serializable)ed -> {
                        if (ed.tideCoef().isDefined()) {
                            int x$8 = stationId;
                            DateTime x$9 = ed.date();
                            Option x$10 = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)((SeqOps)ed.tideCoef().get()).apply(0)))).toOption();
                            Option x$11 = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)((SeqOps)ed.tideCoef().get()).apply(1)))).toOption();
                            Some x$12 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId));
                            Option<DateTime> x$13 = HydroMaree$.MODULE$.$lessinit$greater$default$3();
                            Option<Object> x$14 = HydroMaree$.MODULE$.$lessinit$greater$default$4();
                            Option<DateTime> x$15 = HydroMaree$.MODULE$.$lessinit$greater$default$5();
                            Option<Object> x$16 = HydroMaree$.MODULE$.$lessinit$greater$default$6();
                            Option<DateTime> x$17 = HydroMaree$.MODULE$.$lessinit$greater$default$7();
                            Option<Object> x$18 = HydroMaree$.MODULE$.$lessinit$greater$default$8();
                            Option<DateTime> x$19 = HydroMaree$.MODULE$.$lessinit$greater$default$9();
                            Option<Object> x$20 = HydroMaree$.MODULE$.$lessinit$greater$default$10();
                            return new .colon.colon((Object)new HydroMaree(x$8, x$9, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, (Option<Object>)x$10, (Option<Object>)x$11, (Option<Object>)x$12), (List)Nil$.MODULE$);
                        }
                        return (scala.collection.immutable.Seq)Nil$.MODULE$;
                    })).flatten(Predef$.MODULE$.$conforms());
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(30).append("Begin integration of ").append(dataToImport.size()).append(" measures").toString(), station, this.JobLogUtil.log$default$5());
                    dataToImport.map((Function1 & Serializable)maree -> BoxesRunTime.boxToInteger((int)this.stationsHydroMaree.insert(maree)));
                    this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(24).append("Integration of ").append(dataToImport.size()).append(" measures").toString(), station, this.JobLogUtil.log$default$5());
                    return;
                }
                return;
            }
            return;
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "Station not found in database", station, this.JobLogUtil.log$default$5());
    }

    public static final /* synthetic */ void $anonfun$OcenagramIntegration$1(OceanogramController $this, Seq error) {
        Predef$.MODULE$.println((Object)new StringBuilder(21).append("Fail to parse json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString());
        $this.LogUtil.error(new StringBuilder(21).append("Fail to parse json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.LogUtil.error$default$2());
    }

    public static final /* synthetic */ void $anonfun$OcenagramIntegration$3(OceanogramController $this, long jobExecutionId$1, Option importMode$1, JobParameters parameters$1, OceanogramFilter filter$1, OceanogramParameters param) {
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(42).append("Start integration for station with code : ").append(param.station()).toString(), param.station(), $this.JobLogUtil.log$default$5());
        if (importMode$1.isDefined()) {
            Object object = importMode$1.get();
            String string = ImportMode$.MODULE$.NOTHING();
            if (object == null ? string != null : !object.equals(string)) {
                $this.OceanogramMeasureIntegration((Option<String>)importMode$1, param.station(), param.offset(), (String)parameters$1.user().getOrElse((Function0 & Serializable)() -> "ADMIN"), filter$1, jobExecutionId$1);
            }
        }
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(40).append("End integration for station with code : ").append(param.station()).toString(), param.station(), $this.JobLogUtil.log$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$OceanogramMeasureIntegration$3(ValueVariable x$1) {
        return x$1.surge().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$OceanogramMeasureIntegration$5(ValueVariable x$2) {
        return x$2.ssh().isDefined();
    }

    @Inject
    public OceanogramController(WSClient ws, LogUtil LogUtil2, Aqua6boTideGaugeDao aqua6boTideGaugeDao, HydrometryStationDao hydrometryStationDao, AnormHydroChronicImportDao AnormHydroChronicImportDao2, HydrometryEventDao hydrometryEventDao, StationsHydroMaree stationsHydroMaree, JobLogUtil JobLogUtil2) {
        this.LogUtil = LogUtil2;
        this.aqua6boTideGaugeDao = aqua6boTideGaugeDao;
        this.hydrometryStationDao = hydrometryStationDao;
        this.AnormHydroChronicImportDao = AnormHydroChronicImportDao2;
        this.stationsHydroMaree = stationsHydroMaree;
        this.JobLogUtil = JobLogUtil2;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        Statics.releaseFence();
    }
}

